// content/common/child_process.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/child_process.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/child_process.mojom-params-data.h"
#include "content/common/child_process.mojom-shared-message-ids.h"

#include "content/common/child_process.mojom-import-headers.h"
#include "content/common/child_process.mojom-test-utils.h"


namespace content::mojom {
const char ChildProcessHost::Name_[] = "content.mojom.ChildProcessHost";

ChildProcessHost::IPCStableHashFunction ChildProcessHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ChildProcessHost>(message.name())) {
    case messages::ChildProcessHost::kPing: {
      return &ChildProcessHost::Ping_Sym::IPCStableHash;
    }
    case messages::ChildProcessHost::kBindHostReceiver: {
      return &ChildProcessHost::BindHostReceiver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ChildProcessHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ChildProcessHost>(message.name())) {
      case messages::ChildProcessHost::kPing:
            return "Receive content::mojom::ChildProcessHost::Ping";
      case messages::ChildProcessHost::kBindHostReceiver:
            return "Receive content::mojom::ChildProcessHost::BindHostReceiver";
    }
  } else {
    switch (static_cast<messages::ChildProcessHost>(message.name())) {
      case messages::ChildProcessHost::kPing:
            return "Receive reply content::mojom::ChildProcessHost::Ping";
      case messages::ChildProcessHost::kBindHostReceiver:
            return "Receive reply content::mojom::ChildProcessHost::BindHostReceiver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ChildProcessHost::Ping_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::ChildProcessHost::Ping");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChildProcessHost::BindHostReceiver_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::ChildProcessHost::BindHostReceiver");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ChildProcessHost_Ping_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChildProcessHost_Ping_ForwardToCallback(
      ChildProcessHost::PingCallback callback
      ) : callback_(std::move(callback)) {
  }

  ChildProcessHost_Ping_ForwardToCallback(const ChildProcessHost_Ping_ForwardToCallback&) = delete;
  ChildProcessHost_Ping_ForwardToCallback& operator=(const ChildProcessHost_Ping_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ChildProcessHost::PingCallback callback_;
};

ChildProcessHostProxy::ChildProcessHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChildProcessHostProxy::Ping(
    PingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::ChildProcessHost::Ping");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildProcessHost::kPing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcessHost_Ping_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcessHost::Name_);
  message.set_method_name("Ping");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChildProcessHost_Ping_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ChildProcessHostProxy::BindHostReceiver(
    ::mojo::GenericPendingReceiver in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::ChildProcessHost::BindHostReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::GenericPendingReceiver>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildProcessHost::kBindHostReceiver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcessHost_BindHostReceiver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->receiver)::BaseType> receiver_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::GenericPendingReceiverDataView>(
      in_receiver, receiver_fragment);
  params->receiver.Set(
      receiver_fragment.is_null() ? nullptr : receiver_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->receiver.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null receiver in ChildProcessHost.BindHostReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcessHost::Name_);
  message.set_method_name("BindHostReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ChildProcessHost_Ping_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ChildProcessHost::PingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ChildProcessHost_Ping_ProxyToResponder> proxy(
        new ChildProcessHost_Ping_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ChildProcessHost_Ping_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChildProcessHost_Ping_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ChildProcessHost_Ping_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ChildProcessHost::PingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool ChildProcessHost_Ping_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ChildProcessHost_Ping_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChildProcessHost_Ping_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for ChildProcessHost.0
  bool success = true;
  ChildProcessHost_Ping_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChildProcessHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ChildProcessHost_Ping_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply content::mojom::ChildProcessHost::Ping");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildProcessHost::kPing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcessHost_Ping_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcessHost::Name_);
  message.set_method_name("Ping");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ChildProcessHostStubDispatch::Accept(
    ChildProcessHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ChildProcessHost>(message->header()->name)) {
    case messages::ChildProcessHost::kPing: {
      break;
    }
    case messages::ChildProcessHost::kBindHostReceiver: {
      DCHECK(message->is_serialized());
      internal::ChildProcessHost_BindHostReceiver_Params_Data* params =
          reinterpret_cast<internal::ChildProcessHost_BindHostReceiver_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ChildProcessHost.1
      bool success = true;
      ::mojo::GenericPendingReceiver p_receiver{};
      ChildProcessHost_BindHostReceiver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReceiver(&p_receiver))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcessHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindHostReceiver(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool ChildProcessHostStubDispatch::AcceptWithResponder(
    ChildProcessHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ChildProcessHost>(message->header()->name)) {
    case messages::ChildProcessHost::kPing: {
      internal::ChildProcessHost_Ping_Params_Data* params =
          reinterpret_cast<
              internal::ChildProcessHost_Ping_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for ChildProcessHost.0
      bool success = true;
      ChildProcessHost_Ping_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcessHost::Name_, 0, false);
        return false;
      }
      ChildProcessHost::PingCallback callback =
          ChildProcessHost_Ping_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Ping(std::move(callback));
      return true;
    }
    case messages::ChildProcessHost::kBindHostReceiver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kChildProcessHostValidationInfo[] = {
    {base::to_underlying(messages::ChildProcessHost::kPing),
     { &internal::ChildProcessHost_Ping_Params_Data::Validate,
      &internal::ChildProcessHost_Ping_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::ChildProcessHost::kBindHostReceiver),
     { &internal::ChildProcessHost_BindHostReceiver_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ChildProcessHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::ChildProcessHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kChildProcessHostValidationInfo);
}

bool ChildProcessHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::ChildProcessHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kChildProcessHostValidationInfo);

}
const char ChildProcess::Name_[] = "content.mojom.ChildProcess";

ChildProcess::IPCStableHashFunction ChildProcess::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ChildProcess>(message.name())) {
    case messages::ChildProcess::kProcessShutdown: {
      return &ChildProcess::ProcessShutdown_Sym::IPCStableHash;
    }
    case messages::ChildProcess::kGetBackgroundTracingAgentProvider: {
      return &ChildProcess::GetBackgroundTracingAgentProvider_Sym::IPCStableHash;
    }
    case messages::ChildProcess::kEnableSystemTracingService: {
      return &ChildProcess::EnableSystemTracingService_Sym::IPCStableHash;
    }
    case messages::ChildProcess::kCrashHungProcess: {
      return &ChildProcess::CrashHungProcess_Sym::IPCStableHash;
    }
    case messages::ChildProcess::kBindServiceInterface: {
      return &ChildProcess::BindServiceInterface_Sym::IPCStableHash;
    }
    case messages::ChildProcess::kBindReceiver: {
      return &ChildProcess::BindReceiver_Sym::IPCStableHash;
    }
    case messages::ChildProcess::kSetPseudonymizationSalt: {
      return &ChildProcess::SetPseudonymizationSalt_Sym::IPCStableHash;
    }
    case messages::ChildProcess::kSetBatterySaverMode: {
      return &ChildProcess::SetBatterySaverMode_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ChildProcess::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ChildProcess>(message.name())) {
      case messages::ChildProcess::kProcessShutdown:
            return "Receive content::mojom::ChildProcess::ProcessShutdown";
      case messages::ChildProcess::kGetBackgroundTracingAgentProvider:
            return "Receive content::mojom::ChildProcess::GetBackgroundTracingAgentProvider";
      case messages::ChildProcess::kEnableSystemTracingService:
            return "Receive content::mojom::ChildProcess::EnableSystemTracingService";
      case messages::ChildProcess::kCrashHungProcess:
            return "Receive content::mojom::ChildProcess::CrashHungProcess";
      case messages::ChildProcess::kBindServiceInterface:
            return "Receive content::mojom::ChildProcess::BindServiceInterface";
      case messages::ChildProcess::kBindReceiver:
            return "Receive content::mojom::ChildProcess::BindReceiver";
      case messages::ChildProcess::kSetPseudonymizationSalt:
            return "Receive content::mojom::ChildProcess::SetPseudonymizationSalt";
      case messages::ChildProcess::kSetBatterySaverMode:
            return "Receive content::mojom::ChildProcess::SetBatterySaverMode";
    }
  } else {
    switch (static_cast<messages::ChildProcess>(message.name())) {
      case messages::ChildProcess::kProcessShutdown:
            return "Receive reply content::mojom::ChildProcess::ProcessShutdown";
      case messages::ChildProcess::kGetBackgroundTracingAgentProvider:
            return "Receive reply content::mojom::ChildProcess::GetBackgroundTracingAgentProvider";
      case messages::ChildProcess::kEnableSystemTracingService:
            return "Receive reply content::mojom::ChildProcess::EnableSystemTracingService";
      case messages::ChildProcess::kCrashHungProcess:
            return "Receive reply content::mojom::ChildProcess::CrashHungProcess";
      case messages::ChildProcess::kBindServiceInterface:
            return "Receive reply content::mojom::ChildProcess::BindServiceInterface";
      case messages::ChildProcess::kBindReceiver:
            return "Receive reply content::mojom::ChildProcess::BindReceiver";
      case messages::ChildProcess::kSetPseudonymizationSalt:
            return "Receive reply content::mojom::ChildProcess::SetPseudonymizationSalt";
      case messages::ChildProcess::kSetBatterySaverMode:
            return "Receive reply content::mojom::ChildProcess::SetBatterySaverMode";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ChildProcess::ProcessShutdown_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::ChildProcess::ProcessShutdown");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChildProcess::GetBackgroundTracingAgentProvider_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::ChildProcess::GetBackgroundTracingAgentProvider");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChildProcess::EnableSystemTracingService_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::ChildProcess::EnableSystemTracingService");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChildProcess::CrashHungProcess_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::ChildProcess::CrashHungProcess");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChildProcess::BindServiceInterface_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::ChildProcess::BindServiceInterface");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChildProcess::BindReceiver_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::ChildProcess::BindReceiver");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChildProcess::SetPseudonymizationSalt_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::ChildProcess::SetPseudonymizationSalt");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChildProcess::SetBatterySaverMode_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)content::mojom::ChildProcess::SetBatterySaverMode");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ChildProcessProxy::ChildProcessProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChildProcessProxy::ProcessShutdown(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::ChildProcess::ProcessShutdown");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildProcess::kProcessShutdown), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_ProcessShutdown_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("ProcessShutdown");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChildProcessProxy::GetBackgroundTracingAgentProvider(
    ::mojo::PendingReceiver<::tracing::mojom::BackgroundTracingAgentProvider> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::ChildProcess::GetBackgroundTracingAgentProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::tracing::mojom::BackgroundTracingAgentProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildProcess::kGetBackgroundTracingAgentProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_GetBackgroundTracingAgentProvider_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::tracing::mojom::BackgroundTracingAgentProviderInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in ChildProcess.GetBackgroundTracingAgentProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("GetBackgroundTracingAgentProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChildProcessProxy::EnableSystemTracingService(
    ::mojo::PendingRemote<::tracing::mojom::SystemTracingService> in_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::ChildProcess::EnableSystemTracingService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote"), in_remote,
                        "<value of type ::mojo::PendingRemote<::tracing::mojom::SystemTracingService>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildProcess::kEnableSystemTracingService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_EnableSystemTracingService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::tracing::mojom::SystemTracingServiceInterfaceBase>>(
      in_remote, &params->remote, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->remote),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid remote in ChildProcess.EnableSystemTracingService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("EnableSystemTracingService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChildProcessProxy::CrashHungProcess(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send content::mojom::ChildProcess::CrashHungProcess");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildProcess::kCrashHungProcess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_CrashHungProcess_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("CrashHungProcess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChildProcessProxy::BindServiceInterface(
    ::mojo::GenericPendingReceiver in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::ChildProcess::BindServiceInterface", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::GenericPendingReceiver>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildProcess::kBindServiceInterface), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_BindServiceInterface_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->receiver)::BaseType> receiver_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::GenericPendingReceiverDataView>(
      in_receiver, receiver_fragment);
  params->receiver.Set(
      receiver_fragment.is_null() ? nullptr : receiver_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->receiver.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null receiver in ChildProcess.BindServiceInterface request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("BindServiceInterface");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChildProcessProxy::BindReceiver(
    ::mojo::GenericPendingReceiver in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::ChildProcess::BindReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::GenericPendingReceiver>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildProcess::kBindReceiver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_BindReceiver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->receiver)::BaseType> receiver_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::GenericPendingReceiverDataView>(
      in_receiver, receiver_fragment);
  params->receiver.Set(
      receiver_fragment.is_null() ? nullptr : receiver_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->receiver.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null receiver in ChildProcess.BindReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("BindReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChildProcessProxy::SetPseudonymizationSalt(
    uint32_t in_salt) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::ChildProcess::SetPseudonymizationSalt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("salt"), in_salt,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildProcess::kSetPseudonymizationSalt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_SetPseudonymizationSalt_Params_Data> params(
          message);
  params.Allocate();
  params->salt = in_salt;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("SetPseudonymizationSalt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChildProcessProxy::SetBatterySaverMode(
    bool in_battery_saver_mode_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send content::mojom::ChildProcess::SetBatterySaverMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("battery_saver_mode_enabled"), in_battery_saver_mode_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChildProcess::kSetBatterySaverMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::content::mojom::internal::ChildProcess_SetBatterySaverMode_Params_Data> params(
          message);
  params.Allocate();
  params->battery_saver_mode_enabled = in_battery_saver_mode_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChildProcess::Name_);
  message.set_method_name("SetBatterySaverMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ChildProcessStubDispatch::Accept(
    ChildProcess* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ChildProcess>(message->header()->name)) {
    case messages::ChildProcess::kProcessShutdown: {
      DCHECK(message->is_serialized());
      internal::ChildProcess_ProcessShutdown_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_ProcessShutdown_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ChildProcess.0
      bool success = true;
      ChildProcess_ProcessShutdown_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ProcessShutdown(        );
      return true;
    }
    case messages::ChildProcess::kGetBackgroundTracingAgentProvider: {
      DCHECK(message->is_serialized());
      internal::ChildProcess_GetBackgroundTracingAgentProvider_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_GetBackgroundTracingAgentProvider_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ChildProcess.1
      bool success = true;
      ::mojo::PendingReceiver<::tracing::mojom::BackgroundTracingAgentProvider> p_receiver{};
      ChildProcess_GetBackgroundTracingAgentProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBackgroundTracingAgentProvider(        
        std::move(p_receiver));
      return true;
    }
    case messages::ChildProcess::kEnableSystemTracingService: {
      DCHECK(message->is_serialized());
      internal::ChildProcess_EnableSystemTracingService_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_EnableSystemTracingService_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ChildProcess.2
      bool success = true;
      ::mojo::PendingRemote<::tracing::mojom::SystemTracingService> p_remote{};
      ChildProcess_EnableSystemTracingService_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_remote =
            input_data_view.TakeRemote<decltype(p_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableSystemTracingService(        
        std::move(p_remote));
      return true;
    }
    case messages::ChildProcess::kCrashHungProcess: {
      DCHECK(message->is_serialized());
      internal::ChildProcess_CrashHungProcess_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_CrashHungProcess_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ChildProcess.3
      bool success = true;
      ChildProcess_CrashHungProcess_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CrashHungProcess(        );
      return true;
    }
    case messages::ChildProcess::kBindServiceInterface: {
      DCHECK(message->is_serialized());
      internal::ChildProcess_BindServiceInterface_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_BindServiceInterface_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ChildProcess.4
      bool success = true;
      ::mojo::GenericPendingReceiver p_receiver{};
      ChildProcess_BindServiceInterface_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReceiver(&p_receiver))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindServiceInterface(        
        std::move(p_receiver));
      return true;
    }
    case messages::ChildProcess::kBindReceiver: {
      DCHECK(message->is_serialized());
      internal::ChildProcess_BindReceiver_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_BindReceiver_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ChildProcess.5
      bool success = true;
      ::mojo::GenericPendingReceiver p_receiver{};
      ChildProcess_BindReceiver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReceiver(&p_receiver))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindReceiver(        
        std::move(p_receiver));
      return true;
    }
    case messages::ChildProcess::kSetPseudonymizationSalt: {
      DCHECK(message->is_serialized());
      internal::ChildProcess_SetPseudonymizationSalt_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_SetPseudonymizationSalt_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ChildProcess.6
      bool success = true;
      uint32_t p_salt{};
      ChildProcess_SetPseudonymizationSalt_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_salt = input_data_view.salt();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPseudonymizationSalt(        
        std::move(p_salt));
      return true;
    }
    case messages::ChildProcess::kSetBatterySaverMode: {
      DCHECK(message->is_serialized());
      internal::ChildProcess_SetBatterySaverMode_Params_Data* params =
          reinterpret_cast<internal::ChildProcess_SetBatterySaverMode_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ChildProcess.7
      bool success = true;
      bool p_battery_saver_mode_enabled{};
      ChildProcess_SetBatterySaverMode_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_battery_saver_mode_enabled = input_data_view.battery_saver_mode_enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChildProcess::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBatterySaverMode(        
        std::move(p_battery_saver_mode_enabled));
      return true;
    }
  }
  return false;
}

// static
bool ChildProcessStubDispatch::AcceptWithResponder(
    ChildProcess* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ChildProcess>(message->header()->name)) {
    case messages::ChildProcess::kProcessShutdown: {
      break;
    }
    case messages::ChildProcess::kGetBackgroundTracingAgentProvider: {
      break;
    }
    case messages::ChildProcess::kEnableSystemTracingService: {
      break;
    }
    case messages::ChildProcess::kCrashHungProcess: {
      break;
    }
    case messages::ChildProcess::kBindServiceInterface: {
      break;
    }
    case messages::ChildProcess::kBindReceiver: {
      break;
    }
    case messages::ChildProcess::kSetPseudonymizationSalt: {
      break;
    }
    case messages::ChildProcess::kSetBatterySaverMode: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kChildProcessValidationInfo[] = {
    {base::to_underlying(messages::ChildProcess::kProcessShutdown),
     { &internal::ChildProcess_ProcessShutdown_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ChildProcess::kGetBackgroundTracingAgentProvider),
     { &internal::ChildProcess_GetBackgroundTracingAgentProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ChildProcess::kEnableSystemTracingService),
     { &internal::ChildProcess_EnableSystemTracingService_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ChildProcess::kCrashHungProcess),
     { &internal::ChildProcess_CrashHungProcess_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ChildProcess::kBindServiceInterface),
     { &internal::ChildProcess_BindServiceInterface_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ChildProcess::kBindReceiver),
     { &internal::ChildProcess_BindReceiver_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ChildProcess::kSetPseudonymizationSalt),
     { &internal::ChildProcess_SetPseudonymizationSalt_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ChildProcess::kSetBatterySaverMode),
     { &internal::ChildProcess_SetBatterySaverMode_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ChildProcessRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::ChildProcess::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kChildProcessValidationInfo);
}



}  // content::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace content::mojom {


void ChildProcessHostInterceptorForTesting::Ping(PingCallback callback) {
  GetForwardingInterface()->Ping(std::move(callback));
}
void ChildProcessHostInterceptorForTesting::BindHostReceiver(::mojo::GenericPendingReceiver receiver) {
  GetForwardingInterface()->BindHostReceiver(
    std::move(receiver)
    );
}
ChildProcessHostAsyncWaiter::ChildProcessHostAsyncWaiter(
    ChildProcessHost* proxy) : proxy_(proxy) {}

ChildProcessHostAsyncWaiter::~ChildProcessHostAsyncWaiter() = default;

void ChildProcessHostAsyncWaiter::Ping(
    ) {
  base::RunLoop loop;
  proxy_->Ping(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void ChildProcessInterceptorForTesting::ProcessShutdown() {
  GetForwardingInterface()->ProcessShutdown();
}
void ChildProcessInterceptorForTesting::GetBackgroundTracingAgentProvider(::mojo::PendingReceiver<::tracing::mojom::BackgroundTracingAgentProvider> receiver) {
  GetForwardingInterface()->GetBackgroundTracingAgentProvider(
    std::move(receiver)
    );
}
void ChildProcessInterceptorForTesting::EnableSystemTracingService(::mojo::PendingRemote<::tracing::mojom::SystemTracingService> remote) {
  GetForwardingInterface()->EnableSystemTracingService(
    std::move(remote)
    );
}
void ChildProcessInterceptorForTesting::CrashHungProcess() {
  GetForwardingInterface()->CrashHungProcess();
}
void ChildProcessInterceptorForTesting::BindServiceInterface(::mojo::GenericPendingReceiver receiver) {
  GetForwardingInterface()->BindServiceInterface(
    std::move(receiver)
    );
}
void ChildProcessInterceptorForTesting::BindReceiver(::mojo::GenericPendingReceiver receiver) {
  GetForwardingInterface()->BindReceiver(
    std::move(receiver)
    );
}
void ChildProcessInterceptorForTesting::SetPseudonymizationSalt(uint32_t salt) {
  GetForwardingInterface()->SetPseudonymizationSalt(
    std::move(salt)
    );
}
void ChildProcessInterceptorForTesting::SetBatterySaverMode(bool battery_saver_mode_enabled) {
  GetForwardingInterface()->SetBatterySaverMode(
    std::move(battery_saver_mode_enabled)
    );
}
ChildProcessAsyncWaiter::ChildProcessAsyncWaiter(
    ChildProcess* proxy) : proxy_(proxy) {}

ChildProcessAsyncWaiter::~ChildProcessAsyncWaiter() = default;






}  // content::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif