// components/visitedlink/common/visitedlink.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_VISITEDLINK_COMMON_VISITEDLINK_MOJOM_H_
#define COMPONENTS_VISITEDLINK_COMMON_VISITEDLINK_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/visitedlink/common/visitedlink.mojom-features.h"  // IWYU pragma: export
#include "components/visitedlink/common/visitedlink.mojom-shared.h"  // IWYU pragma: export
#include "components/visitedlink/common/visitedlink.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace visitedlink::mojom {

class VisitedLinkNotificationSinkProxy;

template <typename ImplRefTraits>
class VisitedLinkNotificationSinkStub;

class VisitedLinkNotificationSinkRequestValidator;


class VisitedLinkNotificationSink
    : public VisitedLinkNotificationSinkInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VisitedLinkNotificationSinkInterfaceBase;
  using Proxy_ = VisitedLinkNotificationSinkProxy;

  template <typename ImplRefTraits>
  using Stub_ = VisitedLinkNotificationSinkStub<ImplRefTraits>;

  using RequestValidator_ = VisitedLinkNotificationSinkRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateVisitedLinksMinVersion = 0,
    kAddVisitedLinksMinVersion = 0,
    kResetVisitedLinksMinVersion = 0,
    kUpdateOriginSaltsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateVisitedLinks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddVisitedLinks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetVisitedLinks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateOriginSalts_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VisitedLinkNotificationSink() = default;

  
  virtual void UpdateVisitedLinks(::base::ReadOnlySharedMemoryRegion table_region) = 0;

  
  virtual void AddVisitedLinks(const std::vector<uint64_t>& link_hashes) = 0;

  
  virtual void ResetVisitedLinks(bool invalidate_cached_hashes) = 0;

  
  virtual void UpdateOriginSalts(const base::flat_map<::url::Origin, uint64_t>& origin_salts) = 0;
};



class  VisitedLinkNotificationSinkProxy
    : public VisitedLinkNotificationSink {
 public:
  using InterfaceType = VisitedLinkNotificationSink;

  explicit VisitedLinkNotificationSinkProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateVisitedLinks(::base::ReadOnlySharedMemoryRegion table_region) final;
  
  void AddVisitedLinks(const std::vector<uint64_t>& link_hashes) final;
  
  void ResetVisitedLinks(bool invalidate_cached_hashes) final;
  
  void UpdateOriginSalts(const base::flat_map<::url::Origin, uint64_t>& origin_salts) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VisitedLinkNotificationSinkStubDispatch {
 public:
  static bool Accept(VisitedLinkNotificationSink* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VisitedLinkNotificationSink* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VisitedLinkNotificationSink>>
class VisitedLinkNotificationSinkStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VisitedLinkNotificationSinkStub() = default;
  ~VisitedLinkNotificationSinkStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VisitedLinkNotificationSinkStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VisitedLinkNotificationSinkStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VisitedLinkNotificationSinkRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // visitedlink::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_VISITEDLINK_COMMON_VISITEDLINK_MOJOM_H_