/* Session.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Session.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include <camel/camel.h>
#include <glib-object.h>
#include <glib.h>
#include <libedataserver/libedataserver.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libedataserverui/libedataserverui.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_BACKEND_TYPE_SESSION (mail_backend_session_get_type ())
#define MAIL_BACKEND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSession))
#define MAIL_BACKEND_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))
#define MAIL_BACKEND_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_IS_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))

typedef struct _MailBackendSession MailBackendSession;
typedef struct _MailBackendSessionClass MailBackendSessionClass;
typedef struct _MailBackendSessionPrivate MailBackendSessionPrivate;

#define MAIL_BACKEND_TYPE_ACCOUNT (mail_backend_account_get_type ())
#define MAIL_BACKEND_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccount))
#define MAIL_BACKEND_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))
#define MAIL_BACKEND_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))

typedef struct _MailBackendAccount MailBackendAccount;
typedef struct _MailBackendAccountClass MailBackendAccountClass;
enum  {
	MAIL_BACKEND_SESSION_0_PROPERTY,
	MAIL_BACKEND_SESSION_NUM_PROPERTIES
};
static GParamSpec* mail_backend_session_properties[MAIL_BACKEND_SESSION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MailBackendSessionStartData MailBackendSessionStartData;
typedef struct _Block28Data Block28Data;
#define __vala_CamelServiceAuthType_free0(var) ((var == NULL) ? NULL : (var = (_vala_CamelServiceAuthType_free (var), NULL)))
#define __vala_CamelProvider_free0(var) ((var == NULL) ? NULL : (var = (_vala_CamelProvider_free (var), NULL)))
typedef struct _MailBackendSessionSetAliasesForAccountUidData MailBackendSessionSetAliasesForAccountUidData;
typedef struct _Block29Data Block29Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define MAIL_BACKEND_SESSION_TYPE_MESSAGE_INFO (mail_backend_session_message_info_get_type ())
#define MAIL_BACKEND_SESSION_MESSAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_SESSION_TYPE_MESSAGE_INFO, MailBackendSessionMessageInfo))
#define MAIL_BACKEND_SESSION_MESSAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_SESSION_TYPE_MESSAGE_INFO, MailBackendSessionMessageInfoClass))
#define MAIL_BACKEND_SESSION_IS_MESSAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_SESSION_TYPE_MESSAGE_INFO))
#define MAIL_BACKEND_SESSION_IS_MESSAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_SESSION_TYPE_MESSAGE_INFO))
#define MAIL_BACKEND_SESSION_MESSAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_SESSION_TYPE_MESSAGE_INFO, MailBackendSessionMessageInfoClass))

typedef struct _MailBackendSessionMessageInfo MailBackendSessionMessageInfo;
typedef struct _MailBackendSessionMessageInfoClass MailBackendSessionMessageInfoClass;
typedef struct _MailBackendSessionSendEmailData MailBackendSessionSendEmailData;
typedef struct _MailBackendSessionSaveDraftData MailBackendSessionSaveDraftData;
typedef struct _MailBackendSessionSetSignatureUidForAccountUidData MailBackendSessionSetSignatureUidForAccountUidData;
typedef struct _MailBackendSessionGetSignatureForUidData MailBackendSessionGetSignatureForUidData;
typedef struct _MailBackendSessionCreateNewSignatureData MailBackendSessionCreateNewSignatureData;
typedef struct _MailBackendSessionMessageInfoPrivate MailBackendSessionMessageInfoPrivate;
enum  {
	MAIL_BACKEND_SESSION_MESSAGE_INFO_0_PROPERTY,
	MAIL_BACKEND_SESSION_MESSAGE_INFO_NUM_PROPERTIES
};
static GParamSpec* mail_backend_session_message_info_properties[MAIL_BACKEND_SESSION_MESSAGE_INFO_NUM_PROPERTIES];
enum  {
	MAIL_BACKEND_SESSION_ACCOUNT_ADDED_SIGNAL,
	MAIL_BACKEND_SESSION_ACCOUNT_REMOVED_SIGNAL,
	MAIL_BACKEND_SESSION_SIGNATURE_CHANGED_SIGNAL,
	MAIL_BACKEND_SESSION_NUM_SIGNALS
};
static guint mail_backend_session_signals[MAIL_BACKEND_SESSION_NUM_SIGNALS] = {0};

struct _MailBackendSession {
	CamelSession parent_instance;
	MailBackendSessionPrivate * priv;
};

struct _MailBackendSessionClass {
	CamelSessionClass parent_class;
};

struct _MailBackendSessionPrivate {
	gboolean started;
	ESourceRegistry* registry;
	GeeLinkedList* accounts;
};

struct _MailBackendSessionStartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailBackendSession* self;
	ESourceRegistry* _tmp0_;
	ESourceRegistry* _tmp1_;
	ESourceRegistry* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GList* sources;
	ESourceRegistry* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	ESourceRegistry* _tmp8_;
	ESourceRegistry* _tmp9_;
	ESourceRegistry* _tmp10_;
	GError* _inner_error0_;
};

struct _Block28Data {
	int _ref_count_;
	MailBackendSession* self;
	CamelService* service;
	gchar* mechanism;
};

struct _MailBackendSessionSetAliasesForAccountUidData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailBackendSession* self;
	gchar* uid;
	gchar* encoded_aliases;
	ESource* identity_source;
	ESource* _tmp0_;
	ESourceMailIdentity* extension;
	ESourceExtension* _tmp1_;
	ESourceMailIdentity* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_;
};

struct _Block29Data {
	int _ref_count_;
	MailBackendSession* self;
	GeeArrayList* addresses;
};

struct _MailBackendSessionSendEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailBackendSession* self;
	CamelMimeMessage* message;
	CamelInternetAddress* from;
	CamelAddress* recipients;
	gboolean result;
	ESource* mail_submission_source;
	ESource* _tmp0_;
	ESource* _tmp1_;
	GError* _tmp2_;
	ESource* transport_source;
	ESource* _tmp3_;
	ESource* _tmp4_;
	ESource* _tmp5_;
	GError* _tmp6_;
	CamelTransport* transport;
	ESource* _tmp7_;
	CamelTransport* _tmp8_;
	CamelTransport* _tmp9_;
	GError* _tmp10_;
	gboolean sent_message_saved;
	CamelTransport* _tmp11_;
	CamelTransport* _tmp12_;
	gboolean _tmp13_;
	CamelTransport* _tmp14_;
	ESource* _tmp15_;
	ESourceAuthentication* transport_auth_extension;
	ESource* _tmp16_;
	ESourceExtension* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	ESourceAuthentication* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	ESourceAuthentication* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ESourceAuthentication* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	ESourceAuthentication* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	CamelProvider* provider;
	CamelTransport* _tmp37_;
	CamelProvider* _tmp38_;
	gboolean _tmp39_;
	CamelProvider* _tmp40_;
	CamelProvider* _tmp41_;
	CamelStore* camel_store;
	CamelStore* _tmp42_;
	CamelStore* _tmp43_;
	GError* _tmp44_;
	ESourceMailSubmission* mail_submission_extension;
	ESource* _tmp45_;
	ESourceExtension* _tmp46_;
	gchar* sent_folder_uri;
	ESourceMailSubmission* _tmp47_;
	gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gboolean _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	GError* _tmp54_;
	CamelFolder* sent_folder;
	CamelFolder* _tmp55_;
	CamelStore* _tmp56_;
	CamelStore* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	CamelFolder* _tmp63_;
	CamelFolder* _tmp64_;
	CamelFolder* _tmp65_;
	CamelFolder* _tmp66_;
	GError* _tmp67_;
	MailBackendSessionMessageInfo* message_info;
	MailBackendSessionMessageInfo* _tmp68_;
	CamelFolder* _tmp69_;
	MailBackendSessionMessageInfo* _tmp70_;
	GError* e;
	GError* _tmp71_;
	const gchar* _tmp72_;
	CamelTransport* _tmp73_;
	GError* _inner_error0_;
};

struct _MailBackendSessionSaveDraftData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailBackendSession* self;
	CamelMimeMessage* message;
	CamelInternetAddress* from;
	CamelAddress* recipients;
	CamelMessageInfo* ancestor_message_info;
	CamelStore* camel_store;
	CamelStore* _tmp0_;
	CamelStore* _tmp1_;
	GError* _tmp2_;
	gchar* drafts_folder_uri;
	CamelStore* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	CamelFolder* drafts_folder;
	CamelFolder* _tmp9_;
	CamelStore* _tmp10_;
	CamelStore* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	CamelFolder* _tmp17_;
	CamelFolder* _tmp18_;
	CamelFolder* _tmp19_;
	CamelFolder* _tmp20_;
	GError* _tmp21_;
	MailBackendSessionMessageInfo* message_info;
	MailBackendSessionMessageInfo* _tmp22_;
	CamelFolder* _tmp23_;
	MailBackendSessionMessageInfo* _tmp24_;
	gboolean _tmp25_;
	CamelMessageFlags _tmp26_;
	CamelMessageFlags _tmp27_;
	CamelFolder* _tmp28_;
	GError* _inner_error0_;
};

struct _MailBackendSessionSetSignatureUidForAccountUidData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailBackendSession* self;
	gchar* account_uid;
	gchar* signature_uid;
	ESource* identity_source;
	ESource* _tmp0_;
	ESourceMailIdentity* identity_extension;
	ESourceExtension* _tmp1_;
	GError* e;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_;
};

struct _MailBackendSessionGetSignatureForUidData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailBackendSession* self;
	gchar* uid;
	gchar* result;
	ESource* signature_source;
	ESourceRegistry* _tmp0_;
	ESource* _tmp1_;
	ESource* _tmp2_;
	gchar* _tmp3_;
	gchar* signature;
	gsize length;
	gboolean _tmp4_;
	ESource* _tmp5_;
	gchar* _tmp6_;
	gsize _tmp7_;
	gboolean _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_;
};

struct _MailBackendSessionCreateNewSignatureData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailBackendSession* self;
	ESource* result;
	gchar* uid;
	gchar* _tmp0_;
	ESource* signature_source;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	ESource* _tmp3_;
	ESource* _tmp4_;
	ESourceRegistry* _tmp5_;
	ESource* _tmp6_;
	ESource* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	ESourceRegistry* _tmp10_;
	const gchar* _tmp11_;
	ESource* _tmp12_;
	GError* e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _inner_error0_;
};

struct _MailBackendSessionMessageInfo {
	CamelMessageInfoBase parent_instance;
	MailBackendSessionMessageInfoPrivate * priv;
};

struct _MailBackendSessionMessageInfoClass {
	CamelMessageInfoBaseClass parent_class;
};

static gint MailBackendSession_private_offset;
static gpointer mail_backend_session_parent_class = NULL;
static MailBackendSession* mail_backend_session__session;
static MailBackendSession* mail_backend_session__session = NULL;
static gpointer mail_backend_session_message_info_parent_class = NULL;

VALA_EXTERN GType mail_backend_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendSession, g_object_unref)
VALA_EXTERN GType mail_backend_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendAccount, g_object_unref)
VALA_EXTERN MailBackendSession* mail_backend_session_get_default (void);
VALA_EXTERN MailBackendSession* mail_backend_session_new (void);
VALA_EXTERN MailBackendSession* mail_backend_session_construct (GType object_type);
static void mail_backend_session_start_data_free (gpointer _data);
VALA_EXTERN void mail_backend_session_start (MailBackendSession* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void mail_backend_session_start_finish (MailBackendSession* self,
                                        GAsyncResult* _res_);
static gboolean mail_backend_session_start_co (MailBackendSessionStartData* _data_);
static void mail_backend_session_start_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void mail_backend_session_add_source (MailBackendSession* self,
                                      ESource* source);
static void _mail_backend_session_add_source_gfunc (gconstpointer data,
                                             gpointer self);
static void __lambda7_ (MailBackendSession* self,
                 ESource* source_item);
VALA_EXTERN void mail_backend_session_check_for_signature_change (MailBackendSession* self,
                                                      ESource* source);
static void ___lambda7__e_source_registry_source_added (ESourceRegistry* _sender,
                                                 ESource* source,
                                                 gpointer self);
static void _mail_backend_session_check_for_signature_change_e_source_registry_source_removed (ESourceRegistry* _sender,
                                                                                        ESource* source,
                                                                                        gpointer self);
static void _mail_backend_session_check_for_signature_change_e_source_registry_source_changed (ESourceRegistry* _sender,
                                                                                        ESource* source,
                                                                                        gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean mail_backend_session_real_authenticate_sync (CamelSession* base,
                                                      CamelService* service,
                                                      const gchar* mechanism,
                                                      GCancellable* cancellable,
                                                      GError** error);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static CamelServiceAuthType* _vala_CamelServiceAuthType_copy (CamelServiceAuthType* self);
static void _vala_CamelServiceAuthType_free (CamelServiceAuthType* self);
static void _vala_CamelProvider_free (CamelProvider* self);
static gboolean ___lambda8_ (Block28Data* _data28_,
                      ECredentialsPrompter* prompter,
                      ESource* source,
                      ENamedParameters* credentials,
                      gboolean* out_authenticated,
                      GCancellable* cancellable,
                      GError** error);
VALA_EXTERN gboolean mail_backend_session_try_credentials_sync (MailBackendSession* self,
                                                    ECredentialsPrompter* prompter,
                                                    ESource* source,
                                                    ENamedParameters* credentials,
                                                    gboolean* out_authenticated,
                                                    GCancellable* cancellable,
                                                    CamelService* service,
                                                    const gchar* mechanism,
                                                    GError** error);
static gboolean ____lambda8__ecredentials_prompter_loop_prompt_func (ECredentialsPrompter* prompter,
                                                              ESource* source,
                                                              ENamedParameters* credentials,
                                                              gboolean* out_authenticated,
                                                              gpointer self,
                                                              GCancellable* cancellable,
                                                              GError** error);
static gboolean mail_backend_session_real_get_oauth2_access_token_sync (CamelSession* base,
                                                                 CamelService* service,
                                                                 gchar** access_token,
                                                                 gint* expires_in,
                                                                 GCancellable* cancellable,
                                                                 GError** error);
VALA_EXTERN ESource* mail_backend_session_get_identity_source_for_account_uid (MailBackendSession* self,
                                                                   const gchar* account_uid);
VALA_EXTERN ESource* mail_backend_session_get_identity_source_for_service (MailBackendSession* self,
                                                               CamelService* service);
VALA_EXTERN gchar* mail_backend_session_get_archive_folder_uri_for_service (MailBackendSession* self,
                                                                CamelService* service);
VALA_EXTERN GHashTable* mail_backend_session_get_aliases_for_account_uid (MailBackendSession* self,
                                                              const gchar* uid);
static void mail_backend_session_set_aliases_for_account_uid_data_free (gpointer _data);
VALA_EXTERN void mail_backend_session_set_aliases_for_account_uid (MailBackendSession* self,
                                                       const gchar* uid,
                                                       const gchar* encoded_aliases,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
VALA_EXTERN void mail_backend_session_set_aliases_for_account_uid_finish (MailBackendSession* self,
                                                              GAsyncResult* _res_);
static gboolean mail_backend_session_set_aliases_for_account_uid_co (MailBackendSessionSetAliasesForAccountUidData* _data_);
static void mail_backend_session_set_aliases_for_account_uid_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
VALA_EXTERN gchar* mail_backend_session_get_drafts_folder_uri_for_store (MailBackendSession* self,
                                                             CamelStore* store);
static CamelService* mail_backend_session_real_add_service (CamelSession* base,
                                                     const gchar* uid,
                                                     const gchar* protocol,
                                                     CamelProviderType type,
                                                     GError** error);
VALA_EXTERN MailBackendAccount* mail_backend_account_new (CamelService* service);
VALA_EXTERN MailBackendAccount* mail_backend_account_construct (GType object_type,
                                                    CamelService* service);
static void mail_backend_session_real_remove_service (CamelSession* base,
                                               CamelService* service);
VALA_EXTERN GeeLinkedList* mail_backend_session_get_accounts (MailBackendSession* self);
static CamelFilterDriver* mail_backend_session_real_get_filter_driver (CamelSession* base,
                                                                const gchar* type,
                                                                CamelFolder* for_folder,
                                                                GError** error);
VALA_EXTERN GeeArrayList* mail_backend_session_get_own_addresses (MailBackendSession* self);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void __lambda9_ (Block29Data* _data29_,
                 ESource* source_item);
static void ___lambda10_ (Block29Data* _data29_,
                   const gchar* key,
                   const gchar* val);
static void ____lambda10__gh_func (gconstpointer key,
                            gconstpointer value,
                            gpointer self);
static void ___lambda9__gfunc (gconstpointer data,
                        gpointer self);
static ESource* mail_backend_session_get_mail_submission_source_from_email (MailBackendSession* self,
                                                                     CamelInternetAddress* from,
                                                                     GError** error);
static ESource* mail_backend_session_get_transport_source_from_mail_submission_source (MailBackendSession* self,
                                                                                ESource* mail_submission_source,
                                                                                GError** error);
static CamelTransport* mail_backend_session_get_camel_transport_from_transport_source (MailBackendSession* self,
                                                                                ESource* transport_source,
                                                                                GError** error);
static void mail_backend_session_send_email_data_free (gpointer _data);
VALA_EXTERN void mail_backend_session_send_email (MailBackendSession* self,
                                      CamelMimeMessage* message,
                                      CamelInternetAddress* from,
                                      CamelAddress* recipients,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN gboolean mail_backend_session_send_email_finish (MailBackendSession* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static gboolean mail_backend_session_send_email_co (MailBackendSessionSendEmailData* _data_);
static void mail_backend_session_send_email_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static CamelStore* mail_backend_session_get_camel_store_from_email (MailBackendSession* self,
                                                             CamelInternetAddress* from);
VALA_EXTERN gchar* mail_utils_strip_folder_full_name (const gchar* service_uid,
                                          const gchar* folder_uri);
static GType mail_backend_session_message_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendSessionMessageInfo, g_object_unref)
static MailBackendSessionMessageInfo* mail_backend_session_message_info_new (CamelMessageFlags flags);
static MailBackendSessionMessageInfo* mail_backend_session_message_info_construct (GType object_type,
                                                                            CamelMessageFlags flags);
VALA_EXTERN ESource* mail_backend_session_ref_source (MailBackendSession* self,
                                          const gchar* source_uid);
static void mail_backend_session_save_draft_data_free (gpointer _data);
VALA_EXTERN void mail_backend_session_save_draft (MailBackendSession* self,
                                      CamelMimeMessage* message,
                                      CamelInternetAddress* from,
                                      CamelAddress* recipients,
                                      CamelMessageInfo* ancestor_message_info,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN void mail_backend_session_save_draft_finish (MailBackendSession* self,
                                             GAsyncResult* _res_,
                                             GError** error);
static gboolean mail_backend_session_save_draft_co (MailBackendSessionSaveDraftData* _data_);
static void mail_backend_session_save_draft_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void mail_backend_session_set_signature_uid_for_account_uid_data_free (gpointer _data);
VALA_EXTERN void mail_backend_session_set_signature_uid_for_account_uid (MailBackendSession* self,
                                                             const gchar* account_uid,
                                                             const gchar* signature_uid,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void mail_backend_session_set_signature_uid_for_account_uid_finish (MailBackendSession* self,
                                                                    GAsyncResult* _res_);
static gboolean mail_backend_session_set_signature_uid_for_account_uid_co (MailBackendSessionSetSignatureUidForAccountUidData* _data_);
static void mail_backend_session_set_signature_uid_for_account_uid_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
VALA_EXTERN gchar* mail_backend_session_get_signature_uid_for_sender (MailBackendSession* self,
                                                          const gchar* sender);
static void mail_backend_session_get_signature_for_uid_data_free (gpointer _data);
VALA_EXTERN void mail_backend_session_get_signature_for_uid (MailBackendSession* self,
                                                 const gchar* uid,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN gchar* mail_backend_session_get_signature_for_uid_finish (MailBackendSession* self,
                                                          GAsyncResult* _res_);
static gboolean mail_backend_session_get_signature_for_uid_co (MailBackendSessionGetSignatureForUidData* _data_);
static void mail_backend_session_get_signature_for_uid_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void mail_backend_session_create_new_signature_data_free (gpointer _data);
VALA_EXTERN void mail_backend_session_create_new_signature (MailBackendSession* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN ESource* mail_backend_session_create_new_signature_finish (MailBackendSession* self,
                                                           GAsyncResult* _res_);
static gboolean mail_backend_session_create_new_signature_co (MailBackendSessionCreateNewSignatureData* _data_);
static void mail_backend_session_create_new_signature_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
VALA_EXTERN GList* mail_backend_session_get_all_identity_sources (MailBackendSession* self);
VALA_EXTERN GList* mail_backend_session_get_all_signature_sources (MailBackendSession* self);
static GType mail_backend_session_message_info_get_type_once (void);
static GObject * mail_backend_session_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _mail_backend_session___lambda11_ (MailBackendSession* self,
                                        CamelService* service,
                                        CamelSessionAlertType type,
                                        const gchar* message);
static void __mail_backend_session___lambda11__camel_session_user_alert (CamelSession* _sender,
                                                                  CamelService* service,
                                                                  CamelSessionAlertType type,
                                                                  const gchar* message,
                                                                  gpointer self);
static void _camel_session_set_online_g_network_monitor_network_changed (GNetworkMonitor* _sender,
                                                                  gboolean network_available,
                                                                  gpointer self);
static void mail_backend_session_finalize (GObject * obj);
static GType mail_backend_session_get_type_once (void);

static inline gpointer
mail_backend_session_get_instance_private (MailBackendSession* self)
{
	return G_STRUCT_MEMBER_P (self, MailBackendSession_private_offset);
}

MailBackendSession*
mail_backend_session_get_default (void)
{
	MailBackendSession* _tmp0_;
	MailBackendSession* _tmp2_;
	MailBackendSession* result;
	_tmp0_ = mail_backend_session__session;
	if (_tmp0_ == NULL) {
		MailBackendSession* _tmp1_;
		_tmp1_ = mail_backend_session_new ();
		_g_object_unref0 (mail_backend_session__session);
		mail_backend_session__session = _tmp1_;
	}
	_tmp2_ = mail_backend_session__session;
	result = _tmp2_;
	return result;
}

MailBackendSession*
mail_backend_session_construct (GType object_type)
{
	MailBackendSession * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	_tmp0_ = e_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "mail", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = e_get_user_cache_dir ();
	_tmp4_ = g_build_filename (_tmp3_, "mail", NULL);
	_tmp5_ = _tmp4_;
	self = (MailBackendSession*) g_object_new (object_type, "user-data-dir", _tmp2_, "user-cache-dir", _tmp5_, NULL);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	return self;
}

MailBackendSession*
mail_backend_session_new (void)
{
	return mail_backend_session_construct (MAIL_BACKEND_TYPE_SESSION);
}

static void
mail_backend_session_start_data_free (gpointer _data)
{
	MailBackendSessionStartData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailBackendSessionStartData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
mail_backend_session_start (MailBackendSession* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	MailBackendSessionStartData* _data_;
	MailBackendSession* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailBackendSessionStartData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_backend_session_start_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_backend_session_start_co (_data_);
}

void
mail_backend_session_start_finish (MailBackendSession* self,
                                   GAsyncResult* _res_)
{
	MailBackendSessionStartData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_backend_session_start_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	MailBackendSessionStartData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_backend_session_start_co (_data_);
}

static void
_mail_backend_session_add_source_gfunc (gconstpointer data,
                                        gpointer self)
{
	mail_backend_session_add_source ((MailBackendSession*) self, (ESource*) data);
}

static void
__lambda7_ (MailBackendSession* self,
            ESource* source_item)
{
	g_return_if_fail (source_item != NULL);
	if (e_source_has_extension (source_item, E_SOURCE_EXTENSION_MAIL_ACCOUNT)) {
		mail_backend_session_add_source (self, source_item);
	}
	mail_backend_session_check_for_signature_change (self, source_item);
}

static void
___lambda7__e_source_registry_source_added (ESourceRegistry* _sender,
                                            ESource* source,
                                            gpointer self)
{
	__lambda7_ ((MailBackendSession*) self, source);
}

static void
_mail_backend_session_check_for_signature_change_e_source_registry_source_removed (ESourceRegistry* _sender,
                                                                                   ESource* source,
                                                                                   gpointer self)
{
	mail_backend_session_check_for_signature_change ((MailBackendSession*) self, source);
}

static void
_mail_backend_session_check_for_signature_change_e_source_registry_source_changed (ESourceRegistry* _sender,
                                                                                   ESource* source,
                                                                                   gpointer self)
{
	mail_backend_session_check_for_signature_change ((MailBackendSession*) self, source);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
mail_backend_session_start_co (MailBackendSessionStartData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->started) {
		g_debug ("Session.vala:58: Camel.Session is already started.");
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->started = TRUE;
	{
		_data_->_state_ = 1;
		e_source_registry_new (NULL, mail_backend_session_start_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = e_source_registry_new_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->registry);
		_data_->self->priv->registry = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_critical ("Session.vala:66: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->registry;
	_data_->_tmp6_ = e_source_registry_list_sources (_data_->_tmp5_, E_SOURCE_EXTENSION_MAIL_ACCOUNT);
	_data_->sources = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->sources;
	g_list_foreach (_data_->_tmp7_, _mail_backend_session_add_source_gfunc, _data_->self);
	_data_->_tmp8_ = _data_->self->priv->registry;
	g_signal_connect_object (_data_->_tmp8_, "source-added", (GCallback) ___lambda7__e_source_registry_source_added, _data_->self, 0);
	_data_->_tmp9_ = _data_->self->priv->registry;
	g_signal_connect_object (_data_->_tmp9_, "source-removed", (GCallback) _mail_backend_session_check_for_signature_change_e_source_registry_source_removed, _data_->self, 0);
	_data_->_tmp10_ = _data_->self->priv->registry;
	g_signal_connect_object (_data_->_tmp10_, "source-changed", (GCallback) _mail_backend_session_check_for_signature_change_e_source_registry_source_changed, _data_->self, 0);
	(_data_->sources == NULL) ? NULL : (_data_->sources = (_g_list_free__g_object_unref0_ (_data_->sources), NULL));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		MailBackendSession* self;
		self = _data28_->self;
		_g_object_unref0 (_data28_->service);
		_g_free0 (_data28_->mechanism);
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}

static CamelServiceAuthType*
_vala_CamelServiceAuthType_copy (CamelServiceAuthType* self)
{
	return g_boxed_copy (camel_service_auth_type_get_type (), self);
}

static gpointer
__vala_CamelServiceAuthType_copy0 (gpointer self)
{
	return self ? _vala_CamelServiceAuthType_copy (self) : NULL;
}

static void
_vala_CamelServiceAuthType_free (CamelServiceAuthType* self)
{
	g_boxed_free (camel_service_auth_type_get_type (), self);
}

static void
_vala_CamelProvider_free (CamelProvider* self)
{
	g_boxed_free (camel_provider_get_type (), self);
}

static gboolean
___lambda8_ (Block28Data* _data28_,
             ECredentialsPrompter* prompter,
             ESource* source,
             ENamedParameters* credentials,
             gboolean* out_authenticated,
             GCancellable* cancellable,
             GError** error)
{
	MailBackendSession* self;
	gboolean _vala_out_authenticated = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data28_->self;
	g_return_val_if_fail (prompter != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (credentials != NULL, FALSE);
	_tmp2_ = mail_backend_session_try_credentials_sync (self, prompter, source, credentials, &_tmp1_, cancellable, _data28_->service, _data28_->mechanism, &_inner_error0_);
	_vala_out_authenticated = _tmp1_;
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp3_;
	}
	result = _tmp0_;
	if (out_authenticated) {
		*out_authenticated = _vala_out_authenticated;
	}
	return result;
}

static gboolean
____lambda8__ecredentials_prompter_loop_prompt_func (ECredentialsPrompter* prompter,
                                                     ESource* source,
                                                     ENamedParameters* credentials,
                                                     gboolean* out_authenticated,
                                                     gpointer self,
                                                     GCancellable* cancellable,
                                                     GError** error)
{
	gboolean result;
	result = ___lambda8_ (self, prompter, source, credentials, out_authenticated, cancellable, error);
	return result;
}

static gboolean
mail_backend_session_real_authenticate_sync (CamelSession* base,
                                             CamelService* service,
                                             const gchar* mechanism,
                                             GCancellable* cancellable,
                                             GError** error)
{
	MailBackendSession * self;
	Block28Data* _data28_;
	CamelService* _tmp0_;
	gchar* _tmp1_;
	CamelServiceAuthType* authtype = NULL;
	gboolean try_empty_password = FALSE;
	CamelAuthenticationResult _result_ = 0;
	ESource* source = NULL;
	ESourceRegistry* _tmp21_;
	const gchar* _tmp22_;
	ESource* _tmp23_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (MailBackendSession*) base;
	g_return_val_if_fail (service != NULL, FALSE);
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (service);
	_g_object_unref0 (_data28_->service);
	_data28_->service = _tmp0_;
	_tmp1_ = g_strdup (mechanism);
	_g_free0 (_data28_->mechanism);
	_data28_->mechanism = _tmp1_;
	authtype = NULL;
	try_empty_password = FALSE;
	_result_ = CAMEL_AUTHENTICATION_REJECTED;
	if (g_strcmp0 (_data28_->mechanism, "none") == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (NULL);
		_g_free0 (_data28_->mechanism);
		_data28_->mechanism = _tmp2_;
	}
	if (_data28_->mechanism != NULL) {
		CamelServiceAuthType* _tmp3_;
		gboolean _tmp4_ = FALSE;
		CamelServiceAuthType* _tmp5_;
		CamelSasl* sasl = NULL;
		CamelProvider* _tmp11_;
		CamelProvider* _tmp12_;
		CamelProvider* _tmp13_;
		const gchar* _tmp14_;
		CamelSasl* _tmp15_;
		CamelSasl* _tmp16_;
		CamelSasl* _tmp17_;
		_tmp3_ = __vala_CamelServiceAuthType_copy0 (camel_sasl_authtype (_data28_->mechanism));
		__vala_CamelServiceAuthType_free0 (authtype);
		authtype = _tmp3_;
		_tmp5_ = authtype;
		if (_tmp5_ != NULL) {
			CamelServiceAuthType* _tmp6_;
			_tmp6_ = authtype;
			_tmp4_ = !(*_tmp6_).need_password;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			CamelAuthenticationResult _tmp7_ = 0;
			_tmp7_ = camel_service_authenticate_sync (_data28_->service, _data28_->mechanism, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp8_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				__vala_CamelServiceAuthType_free0 (authtype);
				block28_data_unref (_data28_);
				_data28_ = NULL;
				return _tmp8_;
			}
			_result_ = _tmp7_;
			if (_result_ == CAMEL_AUTHENTICATION_REJECTED) {
				GError* _tmp9_;
				gboolean _tmp10_ = FALSE;
				_tmp9_ = g_error_new (CAMEL_SERVICE_ERROR, CAMEL_SERVICE_ERROR_CANT_AUTHENTICATE, "%s authentication failed", _data28_->mechanism);
				_inner_error0_ = _tmp9_;
				g_propagate_error (error, _inner_error0_);
				__vala_CamelServiceAuthType_free0 (authtype);
				block28_data_unref (_data28_);
				_data28_ = NULL;
				return _tmp10_;
			}
			result = _result_ == CAMEL_AUTHENTICATION_ACCEPTED;
			__vala_CamelServiceAuthType_free0 (authtype);
			block28_data_unref (_data28_);
			_data28_ = NULL;
			return result;
		}
		_tmp11_ = camel_service_get_provider (_data28_->service);
		_tmp12_ = _tmp11_;
		_tmp13_ = (CamelProvider*) _tmp12_;
		_tmp14_ = _tmp13_->protocol;
		_tmp15_ = camel_sasl_new (_tmp14_, _data28_->mechanism, _data28_->service);
		_tmp16_ = _tmp15_;
		__vala_CamelProvider_free0 (_tmp13_);
		sasl = _tmp16_;
		_tmp17_ = sasl;
		if (_tmp17_ != NULL) {
			gboolean _tmp18_ = FALSE;
			CamelSasl* _tmp19_;
			_tmp19_ = sasl;
			_tmp18_ = camel_sasl_try_empty_password_sync (_tmp19_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp20_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (sasl);
				__vala_CamelServiceAuthType_free0 (authtype);
				block28_data_unref (_data28_);
				_data28_ = NULL;
				return _tmp20_;
			}
			try_empty_password = _tmp18_;
		}
		_g_object_unref0 (sasl);
	}
	_tmp21_ = self->priv->registry;
	_tmp22_ = camel_service_get_uid (_data28_->service);
	_tmp23_ = e_source_registry_ref_source (_tmp21_, _tmp22_);
	source = _tmp23_;
	_result_ = CAMEL_AUTHENTICATION_REJECTED;
	if (try_empty_password) {
		CamelAuthenticationResult _tmp24_ = 0;
		_tmp24_ = camel_service_authenticate_sync (_data28_->service, _data28_->mechanism, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp25_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (source);
			__vala_CamelServiceAuthType_free0 (authtype);
			block28_data_unref (_data28_);
			_data28_ = NULL;
			return _tmp25_;
		}
		_result_ = _tmp24_;
	}
	if (_result_ == CAMEL_AUTHENTICATION_REJECTED) {
		ECredentialsPrompter* credentials_prompter = NULL;
		ESourceRegistry* _tmp26_;
		ECredentialsPrompter* _tmp27_;
		ECredentialsPrompter* _tmp28_;
		gboolean _tmp29_ = FALSE;
		ECredentialsPrompter* _tmp30_;
		ESource* _tmp31_;
		_tmp26_ = self->priv->registry;
		_tmp27_ = e_credentials_prompter_new (_tmp26_);
		credentials_prompter = _tmp27_;
		_tmp28_ = credentials_prompter;
		e_credentials_prompter_set_auto_prompt (_tmp28_, TRUE);
		_tmp30_ = credentials_prompter;
		_tmp31_ = source;
		_tmp29_ = e_credentials_prompter_loop_prompt_sync (_tmp30_, _tmp31_, E_CREDENTIALS_PROMPTER_PROMPT_FLAG_ALLOW_SOURCE_SAVE, ____lambda8__ecredentials_prompter_loop_prompt_func, _data28_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp32_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (credentials_prompter);
			_g_object_unref0 (source);
			__vala_CamelServiceAuthType_free0 (authtype);
			block28_data_unref (_data28_);
			_data28_ = NULL;
			return _tmp32_;
		}
		result = _tmp29_;
		_g_object_unref0 (credentials_prompter);
		_g_object_unref0 (source);
		__vala_CamelServiceAuthType_free0 (authtype);
		block28_data_unref (_data28_);
		_data28_ = NULL;
		return result;
	} else {
		result = _result_ == CAMEL_AUTHENTICATION_ACCEPTED;
		_g_object_unref0 (source);
		__vala_CamelServiceAuthType_free0 (authtype);
		block28_data_unref (_data28_);
		_data28_ = NULL;
		return result;
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
mail_backend_session_real_get_oauth2_access_token_sync (CamelSession* base,
                                                        CamelService* service,
                                                        gchar** access_token,
                                                        gint* expires_in,
                                                        GCancellable* cancellable,
                                                        GError** error)
{
	MailBackendSession * self;
	gchar* _vala_access_token = NULL;
	gint _vala_expires_in = 0;
	GError* local_error = NULL;
	ESource* source = NULL;
	ESourceRegistry* _tmp0_;
	const gchar* _tmp1_;
	ESource* _tmp2_;
	ESource* _tmp3_;
	ESource* cred_source = NULL;
	ESourceRegistry* _tmp7_;
	ESource* _tmp8_;
	ESource* _tmp9_;
	gboolean _tmp10_ = FALSE;
	ESource* _tmp11_;
	gboolean success = FALSE;
	GError* _tmp36_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (MailBackendSession*) base;
	g_return_val_if_fail (service != NULL, FALSE);
	local_error = NULL;
	_tmp0_ = self->priv->registry;
	_tmp1_ = camel_service_get_uid (service);
	_tmp2_ = e_source_registry_ref_source (_tmp0_, _tmp1_);
	source = _tmp2_;
	_tmp3_ = source;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		GError* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = camel_service_get_uid (service);
		_tmp5_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "Corresponding source for service with UID “%s” not found", _tmp4_);
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (source);
		_g_error_free0 (local_error);
		_g_free0 (_vala_access_token);
		return _tmp6_;
	}
	_tmp7_ = self->priv->registry;
	_tmp8_ = source;
	_tmp9_ = e_source_registry_find_extension (_tmp7_, _tmp8_, E_SOURCE_EXTENSION_COLLECTION);
	cred_source = _tmp9_;
	_tmp11_ = cred_source;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		ESource* _tmp12_;
		ESource* _tmp13_;
		_tmp12_ = cred_source;
		_tmp13_ = source;
		_tmp10_ = !e_util_can_use_collection_as_credential_source (_tmp12_, _tmp13_);
	}
	if (_tmp10_) {
		ESource* _tmp14_;
		ESource* _tmp15_;
		_tmp14_ = source;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_g_object_unref0 (cred_source);
		cred_source = _tmp15_;
	}
	success = FALSE;
	{
		gboolean _tmp16_ = FALSE;
		ESource* _tmp17_;
		gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gboolean _tmp20_;
		_tmp17_ = cred_source;
		_tmp20_ = e_source_get_oauth2_access_token_sync (_tmp17_, cancellable, &_tmp18_, &_tmp19_, &_inner_error0_);
		_g_free0 (_vala_access_token);
		_vala_access_token = _tmp18_;
		_vala_expires_in = _tmp19_;
		_tmp16_ = _tmp20_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		success = _tmp16_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		GError* _tmp22_;
		gboolean _tmp23_ = FALSE;
		GError* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _g_error_copy0 (_tmp21_);
		_g_error_free0 (local_error);
		local_error = _tmp22_;
		_tmp24_ = e;
		if (g_error_matches (_tmp24_, G_IO_ERROR, G_IO_ERROR_CONNECTION_REFUSED)) {
			_tmp23_ = TRUE;
		} else {
			GError* _tmp25_;
			_tmp25_ = e;
			_tmp23_ = g_error_matches (_tmp25_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND);
		}
		if (_tmp23_) {
			GError* _tmp26_;
			const gchar* _tmp27_;
			GError* _tmp28_;
			_tmp26_ = e;
			_tmp27_ = _tmp26_->message;
			_tmp28_ = g_error_new_literal (CAMEL_SERVICE_ERROR, CAMEL_SERVICE_ERROR_CANT_AUTHENTICATE, _tmp27_);
			_g_error_free0 (local_error);
			local_error = _tmp28_;
			{
				gboolean _tmp29_ = FALSE;
				ESource* _tmp30_;
				GError* _tmp31_;
				_tmp30_ = cred_source;
				_tmp31_ = e;
				_tmp29_ = e_source_invoke_credentials_required_sync (_tmp30_, E_SOURCE_CREDENTIALS_REASON_REJECTED, "", 0, _tmp31_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				if (_tmp29_) {
					_g_error_free0 (local_error);
					local_error = NULL;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* invoke_error = NULL;
				GError* _tmp32_;
				GError* _tmp33_;
				invoke_error = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp32_ = invoke_error;
				_tmp33_ = _g_error_copy0 (_tmp32_);
				_g_error_free0 (local_error);
				local_error = _tmp33_;
				_g_error_free0 (invoke_error);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp34_ = FALSE;
				_g_error_free0 (e);
				_g_object_unref0 (cred_source);
				_g_object_unref0 (source);
				_g_error_free0 (local_error);
				_g_free0 (_vala_access_token);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp34_;
			}
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp35_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (cred_source);
		_g_object_unref0 (source);
		_g_error_free0 (local_error);
		_g_free0 (_vala_access_token);
		return _tmp35_;
	}
	_tmp36_ = local_error;
	if (_tmp36_ != NULL) {
		GError* _tmp37_;
		GError* _tmp38_;
		gboolean _tmp39_ = FALSE;
		_tmp37_ = local_error;
		_tmp38_ = _g_error_copy0 (_tmp37_);
		_inner_error0_ = _tmp38_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (cred_source);
		_g_object_unref0 (source);
		_g_error_free0 (local_error);
		_g_free0 (_vala_access_token);
		return _tmp39_;
	}
	result = success;
	_g_object_unref0 (cred_source);
	_g_object_unref0 (source);
	_g_error_free0 (local_error);
	if (access_token) {
		*access_token = _vala_access_token;
	} else {
		_g_free0 (_vala_access_token);
	}
	if (expires_in) {
		*expires_in = _vala_expires_in;
	}
	return result;
}

gboolean
mail_backend_session_try_credentials_sync (MailBackendSession* self,
                                           ECredentialsPrompter* prompter,
                                           ESource* source,
                                           ENamedParameters* credentials,
                                           gboolean* out_authenticated,
                                           GCancellable* cancellable,
                                           CamelService* service,
                                           const gchar* mechanism,
                                           GError** error)
{
	gboolean _vala_out_authenticated = FALSE;
	gchar* credential_name = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	CamelAuthenticationResult _result_ = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (prompter != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (credentials != NULL, FALSE);
	g_return_val_if_fail (service != NULL, FALSE);
	credential_name = NULL;
	if (e_source_has_extension (source, E_SOURCE_EXTENSION_AUTHENTICATION)) {
		ESourceAuthentication* auth_extension = NULL;
		ESourceExtension* _tmp0_;
		ESourceAuthentication* _tmp1_;
		gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
		_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_AUTHENTICATION);
		auth_extension = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_authentication_get_type (), ESourceAuthentication);
		_tmp1_ = auth_extension;
		_tmp2_ = e_source_authentication_dup_credential_name (_tmp1_);
		_g_free0 (credential_name);
		credential_name = _tmp2_;
		_tmp4_ = credential_name;
		if (_tmp4_ != NULL) {
			const gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			_tmp5_ = credential_name;
			_tmp6_ = strlen (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp3_ = _tmp7_ == 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_g_free0 (credential_name);
			credential_name = NULL;
		}
	}
	_tmp9_ = credential_name;
	_tmp8_ = _tmp9_;
	if (_tmp8_ == NULL) {
		_tmp8_ = E_SOURCE_CREDENTIAL_PASSWORD;
	}
	_tmp10_ = e_named_parameters_get (credentials, _tmp8_);
	camel_service_set_password (service, _tmp10_);
	_result_ = camel_service_authenticate_sync (service, mechanism, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (credential_name);
		return _tmp11_;
	}
	_vala_out_authenticated = _result_ == CAMEL_AUTHENTICATION_ACCEPTED;
	if (_vala_out_authenticated) {
		ESource* credentials_source = NULL;
		ESourceCredentialsProvider* _tmp12_;
		ESource* _tmp13_;
		ESource* _tmp14_;
		_tmp12_ = e_credentials_prompter_get_provider (prompter);
		_tmp13_ = e_source_credentials_provider_ref_credentials_source (_tmp12_, source);
		credentials_source = _tmp13_;
		_tmp14_ = credentials_source;
		if (_tmp14_ != NULL) {
			ESource* _tmp15_;
			_tmp15_ = credentials_source;
			e_source_invoke_authenticate_sync (_tmp15_, credentials, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp16_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (credentials_source);
				_g_free0 (credential_name);
				return _tmp16_;
			}
		}
		_g_object_unref0 (credentials_source);
	}
	result = _result_ == CAMEL_AUTHENTICATION_REJECTED;
	_g_free0 (credential_name);
	if (out_authenticated) {
		*out_authenticated = _vala_out_authenticated;
	}
	return result;
}

ESource*
mail_backend_session_get_identity_source_for_account_uid (MailBackendSession* self,
                                                          const gchar* account_uid)
{
	ESource* account_source = NULL;
	ESourceRegistry* _tmp0_;
	ESource* _tmp1_;
	ESourceMailAccount* account_extension = NULL;
	ESourceExtension* _tmp2_;
	const gchar* identity_uid = NULL;
	const gchar* _tmp3_;
	ESourceRegistry* _tmp4_;
	ESource* _tmp5_;
	ESource* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (account_uid != NULL, NULL);
	_tmp0_ = self->priv->registry;
	_tmp1_ = e_source_registry_ref_source (_tmp0_, account_uid);
	account_source = _tmp1_;
	_tmp2_ = e_source_get_extension (account_source, E_SOURCE_EXTENSION_MAIL_ACCOUNT);
	account_extension = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, e_source_mail_account_get_type (), ESourceMailAccount);
	_tmp3_ = e_source_mail_account_get_identity_uid (account_extension);
	identity_uid = _tmp3_;
	_tmp4_ = self->priv->registry;
	_tmp5_ = e_source_registry_ref_source (_tmp4_, identity_uid);
	result = _tmp5_;
	_g_object_unref0 (account_source);
	return result;
}

ESource*
mail_backend_session_get_identity_source_for_service (MailBackendSession* self,
                                                      CamelService* service)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ESource* _tmp2_;
	ESource* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (service != NULL, NULL);
	_tmp0_ = camel_service_get_uid (service);
	_tmp1_ = _tmp0_;
	_tmp2_ = mail_backend_session_get_identity_source_for_account_uid (self, _tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
mail_backend_session_get_archive_folder_uri_for_service (MailBackendSession* self,
                                                         CamelService* service)
{
	ESource* source = NULL;
	ESourceRegistry* _tmp0_;
	const gchar* _tmp1_;
	ESource* _tmp2_;
	ESource* _tmp3_;
	ESource* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (service != NULL, NULL);
	_tmp0_ = self->priv->registry;
	_tmp1_ = camel_service_get_uid (service);
	_tmp2_ = e_source_registry_ref_source (_tmp0_, _tmp1_);
	source = _tmp2_;
	_tmp3_ = source;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_object_unref0 (source);
		return result;
	}
	_tmp4_ = source;
	if (e_source_has_extension (_tmp4_, E_SOURCE_EXTENSION_MAIL_ACCOUNT)) {
		ESourceMailAccount* account_extension = NULL;
		ESource* _tmp5_;
		ESourceExtension* _tmp6_;
		ESourceMailAccount* _tmp7_;
		ESourceMailAccount* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = source;
		_tmp6_ = e_source_get_extension (_tmp5_, E_SOURCE_EXTENSION_MAIL_ACCOUNT);
		_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, e_source_mail_account_get_type (), ESourceMailAccount));
		account_extension = _tmp7_;
		_tmp8_ = account_extension;
		_tmp9_ = e_source_mail_account_dup_archive_folder (_tmp8_);
		result = _tmp9_;
		_g_object_unref0 (account_extension);
		_g_object_unref0 (source);
		return result;
	}
	result = NULL;
	_g_object_unref0 (source);
	return result;
}

GHashTable*
mail_backend_session_get_aliases_for_account_uid (MailBackendSession* self,
                                                  const gchar* uid)
{
	ESource* identity_source = NULL;
	ESource* _tmp0_;
	ESourceMailIdentity* extension = NULL;
	ESourceExtension* _tmp1_;
	ESourceMailIdentity* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	_tmp0_ = mail_backend_session_get_identity_source_for_account_uid (self, uid);
	identity_source = _tmp0_;
	_tmp1_ = e_source_get_extension (identity_source, E_SOURCE_EXTENSION_MAIL_IDENTITY);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, e_source_mail_identity_get_type (), ESourceMailIdentity));
	extension = _tmp2_;
	_tmp3_ = e_source_mail_identity_get_aliases_as_hash_table (extension);
	result = _tmp3_;
	_g_object_unref0 (extension);
	_g_object_unref0 (identity_source);
	return result;
}

static void
mail_backend_session_set_aliases_for_account_uid_data_free (gpointer _data)
{
	MailBackendSessionSetAliasesForAccountUidData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uid);
	_g_free0 (_data_->encoded_aliases);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailBackendSessionSetAliasesForAccountUidData, _data_);
}

void
mail_backend_session_set_aliases_for_account_uid (MailBackendSession* self,
                                                  const gchar* uid,
                                                  const gchar* encoded_aliases,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	MailBackendSessionSetAliasesForAccountUidData* _data_;
	MailBackendSession* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	g_return_if_fail (encoded_aliases != NULL);
	_data_ = g_slice_new0 (MailBackendSessionSetAliasesForAccountUidData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_backend_session_set_aliases_for_account_uid_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uid);
	_g_free0 (_data_->uid);
	_data_->uid = _tmp1_;
	_tmp2_ = g_strdup (encoded_aliases);
	_g_free0 (_data_->encoded_aliases);
	_data_->encoded_aliases = _tmp2_;
	mail_backend_session_set_aliases_for_account_uid_co (_data_);
}

void
mail_backend_session_set_aliases_for_account_uid_finish (MailBackendSession* self,
                                                         GAsyncResult* _res_)
{
	MailBackendSessionSetAliasesForAccountUidData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_backend_session_set_aliases_for_account_uid_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	MailBackendSessionSetAliasesForAccountUidData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_backend_session_set_aliases_for_account_uid_co (_data_);
}

static gboolean
mail_backend_session_set_aliases_for_account_uid_co (MailBackendSessionSetAliasesForAccountUidData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = mail_backend_session_get_identity_source_for_account_uid (_data_->self, _data_->uid);
	_data_->identity_source = _data_->_tmp0_;
	_data_->_tmp1_ = e_source_get_extension (_data_->identity_source, E_SOURCE_EXTENSION_MAIL_IDENTITY);
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, e_source_mail_identity_get_type (), ESourceMailIdentity));
	_data_->extension = _data_->_tmp2_;
	e_source_mail_identity_set_aliases (_data_->extension, _data_->encoded_aliases);
	{
		_data_->_state_ = 1;
		e_source_write (_data_->identity_source, NULL, mail_backend_session_set_aliases_for_account_uid_ready, _data_);
		return FALSE;
		_state_1:
		e_source_write_finish (_data_->identity_source, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_critical ("Session.vala:259: Failed to write new aliases: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->extension);
		_g_object_unref0 (_data_->identity_source);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->extension);
	_g_object_unref0 (_data_->identity_source);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gchar*
mail_backend_session_get_drafts_folder_uri_for_store (MailBackendSession* self,
                                                      CamelStore* store)
{
	ESource* source = NULL;
	ESourceRegistry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ESource* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ESource* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = self->priv->registry;
	_tmp1_ = camel_service_get_uid ((CamelService*) store);
	_tmp2_ = _tmp1_;
	_tmp3_ = e_source_registry_ref_source (_tmp0_, _tmp2_);
	source = _tmp3_;
	_tmp5_ = source;
	if (_tmp5_ != NULL) {
		ESource* _tmp6_;
		_tmp6_ = source;
		_tmp4_ = e_source_has_extension (_tmp6_, E_SOURCE_EXTENSION_MAIL_ACCOUNT);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ESourceMailAccount* mail_account = NULL;
		ESource* _tmp7_;
		ESourceExtension* _tmp8_;
		gchar* identity_uid = NULL;
		ESourceMailAccount* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		_tmp7_ = source;
		_tmp8_ = e_source_get_extension (_tmp7_, E_SOURCE_EXTENSION_MAIL_ACCOUNT);
		mail_account = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, e_source_mail_account_get_type (), ESourceMailAccount);
		_tmp9_ = mail_account;
		_tmp10_ = e_source_mail_account_get_identity_uid (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup (_tmp11_);
		identity_uid = _tmp12_;
		_tmp14_ = identity_uid;
		if (_tmp14_ != NULL) {
			const gchar* _tmp15_;
			_tmp15_ = identity_uid;
			_tmp13_ = g_strcmp0 (_tmp15_, "") != 0;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			ESource* identity_source = NULL;
			ESourceRegistry* _tmp16_;
			const gchar* _tmp17_;
			ESource* _tmp18_;
			gboolean _tmp19_ = FALSE;
			ESource* _tmp20_;
			_tmp16_ = self->priv->registry;
			_tmp17_ = identity_uid;
			_tmp18_ = e_source_registry_ref_source (_tmp16_, _tmp17_);
			identity_source = _tmp18_;
			_tmp20_ = identity_source;
			if (_tmp20_ != NULL) {
				ESource* _tmp21_;
				_tmp21_ = identity_source;
				_tmp19_ = e_source_has_extension (_tmp21_, E_SOURCE_EXTENSION_MAIL_COMPOSITION);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				ESourceMailComposition* composition_extension = NULL;
				ESource* _tmp22_;
				ESourceExtension* _tmp23_;
				ESourceMailComposition* _tmp24_;
				gchar* drafts_folder = NULL;
				ESourceMailComposition* _tmp25_;
				gchar* _tmp26_;
				const gchar* _tmp27_;
				_tmp22_ = identity_source;
				_tmp23_ = e_source_get_extension (_tmp22_, E_SOURCE_EXTENSION_MAIL_COMPOSITION);
				_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, e_source_mail_composition_get_type (), ESourceMailComposition));
				composition_extension = _tmp24_;
				_tmp25_ = composition_extension;
				_tmp26_ = e_source_mail_composition_dup_drafts_folder (_tmp25_);
				drafts_folder = _tmp26_;
				_tmp27_ = drafts_folder;
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = drafts_folder;
					camel_url_decode (_tmp28_);
				}
				result = drafts_folder;
				_g_object_unref0 (composition_extension);
				_g_object_unref0 (identity_source);
				_g_free0 (identity_uid);
				_g_object_unref0 (source);
				return result;
			}
			_g_object_unref0 (identity_source);
		}
		_g_free0 (identity_uid);
	}
	result = NULL;
	_g_object_unref0 (source);
	return result;
}

static void
mail_backend_session_add_source (MailBackendSession* self,
                                 ESource* source)
{
	const gchar* uid = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ESourceMailAccount* extension = NULL;
	ESourceExtension* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = e_source_get_uid (source);
	uid = _tmp0_;
	_tmp1_ = uid;
	if (g_strcmp0 (_tmp1_, "vfolder") == 0) {
		return;
	}
	_tmp2_ = e_source_get_extension (source, E_SOURCE_EXTENSION_MAIL_ACCOUNT);
	extension = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, e_source_mail_account_get_type (), ESourceMailAccount);
	{
		const gchar* _tmp3_;
		ESourceMailAccount* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		CamelService* _tmp7_;
		CamelService* _tmp8_;
		_tmp3_ = uid;
		_tmp4_ = extension;
		_tmp5_ = e_source_backend_get_backend_name ((ESourceBackend*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = camel_session_add_service ((CamelSession*) self, _tmp3_, _tmp6_, CAMEL_PROVIDER_STORE, &_inner_error0_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp8_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_critical ("Session.vala:298: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static CamelService*
mail_backend_session_real_add_service (CamelSession* base,
                                       const gchar* uid,
                                       const gchar* protocol,
                                       CamelProviderType type,
                                       GError** error)
{
	MailBackendSession * self;
	CamelService* service = NULL;
	CamelService* _tmp0_;
	GError* _inner_error0_ = NULL;
	CamelService* result;
	self = (MailBackendSession*) base;
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = CAMEL_SESSION_CLASS (mail_backend_session_parent_class)->add_service (G_TYPE_CHECK_INSTANCE_CAST (self, camel_session_get_type (), CamelSession), uid, protocol, type, &_inner_error0_);
	service = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (service, camel_service_get_type ())) {
		ESource* source = NULL;
		ESourceRegistry* _tmp1_;
		ESource* _tmp2_;
		const gchar* extension_name = NULL;
		const gchar* _tmp3_;
		ESource* extension_source = NULL;
		ESourceRegistry* _tmp4_;
		ESource* _tmp5_;
		const gchar* _tmp6_;
		ESource* _tmp7_;
		ESource* _tmp8_;
		ESource* _tmp11_;
		ESource* _tmp12_;
		_tmp1_ = self->priv->registry;
		_tmp2_ = e_source_registry_ref_source (_tmp1_, uid);
		source = _tmp2_;
		_tmp3_ = e_source_camel_get_extension_name (protocol);
		extension_name = _tmp3_;
		_tmp4_ = self->priv->registry;
		_tmp5_ = source;
		_tmp6_ = extension_name;
		_tmp7_ = e_source_registry_find_extension (_tmp4_, _tmp5_, _tmp6_);
		extension_source = _tmp7_;
		_tmp8_ = extension_source;
		if (_tmp8_ != NULL) {
			ESource* _tmp9_;
			ESource* _tmp10_;
			_tmp9_ = extension_source;
			_tmp10_ = _g_object_ref0 (_tmp9_);
			_g_object_unref0 (source);
			source = _tmp10_;
		}
		_tmp11_ = source;
		e_source_camel_configure_service (_tmp11_, service);
		_tmp12_ = source;
		g_object_bind_property_with_closures ((GObject*) _tmp12_, "display-name", (GObject*) service, "display-name", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		if (G_TYPE_CHECK_INSTANCE_TYPE (service, camel_offline_store_get_type ())) {
			MailBackendAccount* account = NULL;
			MailBackendAccount* _tmp13_;
			GeeLinkedList* _tmp14_;
			MailBackendAccount* _tmp15_;
			MailBackendAccount* _tmp16_;
			_tmp13_ = mail_backend_account_new (service);
			account = _tmp13_;
			_tmp14_ = self->priv->accounts;
			_tmp15_ = account;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
			_tmp16_ = account;
			g_signal_emit (self, mail_backend_session_signals[MAIL_BACKEND_SESSION_ACCOUNT_ADDED_SIGNAL], 0, _tmp16_);
			_g_object_unref0 (account);
		}
		_g_object_unref0 (extension_source);
		_g_object_unref0 (source);
	}
	result = service;
	return result;
}

static void
mail_backend_session_real_remove_service (CamelSession* base,
                                          CamelService* service)
{
	MailBackendSession * self;
	self = (MailBackendSession*) base;
	g_return_if_fail (service != NULL);
	CAMEL_SESSION_CLASS (mail_backend_session_parent_class)->remove_service (G_TYPE_CHECK_INSTANCE_CAST (self, camel_session_get_type (), CamelSession), service);
	if (G_TYPE_CHECK_INSTANCE_TYPE (service, camel_offline_store_get_type ())) {
		gint account_index = 0;
		GeeLinkedList* _tmp0_;
		MailBackendAccount* _tmp1_;
		MailBackendAccount* _tmp2_;
		gint _tmp3_;
		_tmp0_ = self->priv->accounts;
		_tmp1_ = mail_backend_account_new (service);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, _tmp2_);
		_g_object_unref0 (_tmp2_);
		account_index = _tmp3_;
		if (account_index >= 0) {
			GeeLinkedList* _tmp4_;
			gpointer _tmp5_;
			MailBackendAccount* _tmp6_;
			_tmp4_ = self->priv->accounts;
			_tmp5_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp4_, account_index);
			_tmp6_ = (MailBackendAccount*) _tmp5_;
			g_signal_emit (self, mail_backend_session_signals[MAIL_BACKEND_SESSION_ACCOUNT_REMOVED_SIGNAL], 0, _tmp6_);
			_g_object_unref0 (_tmp6_);
		}
	}
}

GeeLinkedList*
mail_backend_session_get_accounts (MailBackendSession* self)
{
	GeeLinkedList* list = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (MAIL_BACKEND_TYPE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = self->priv->accounts;
	gee_collection_add_all ((GeeCollection*) list, (GeeCollection*) _tmp1_);
	result = list;
	return result;
}

static CamelFilterDriver*
mail_backend_session_real_get_filter_driver (CamelSession* base,
                                             const gchar* type,
                                             CamelFolder* for_folder,
                                             GError** error)
{
	MailBackendSession * self;
	CamelFilterDriver* filter_driver = NULL;
	CamelFilterDriver* _tmp0_;
	GObject* _tmp1_;
	CamelFilterDriver* result;
	self = (MailBackendSession*) base;
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = camel_filter_driver_new ((CamelSession*) self);
	filter_driver = _tmp0_;
	_tmp1_ = g_object_ref ((GObject*) filter_driver);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, camel_filter_driver_get_type (), CamelFilterDriver);
	_g_object_unref0 (filter_driver);
	return result;
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		MailBackendSession* self;
		self = _data29_->self;
		_g_object_unref0 (_data29_->addresses);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}

static void
___lambda10_ (Block29Data* _data29_,
              const gchar* key,
              const gchar* val)
{
	MailBackendSession* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	self = _data29_->self;
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = g_utf8_casefold (key, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _data29_->addresses, _tmp1_);
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = g_utf8_casefold (key, (gssize) -1);
		_tmp4_ = _tmp3_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data29_->addresses, _tmp4_);
		_g_free0 (_tmp4_);
	}
}

static void
____lambda10__gh_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	___lambda10_ (self, (const gchar*) key, (const gchar*) value);
}

static void
__lambda9_ (Block29Data* _data29_,
            ESource* source_item)
{
	MailBackendSession* self;
	ESourceMailIdentity* extension = NULL;
	ESourceExtension* _tmp0_;
	ESourceMailIdentity* _tmp1_;
	gchar* address = NULL;
	ESourceMailIdentity* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	GHashTable* aliases = NULL;
	ESourceMailIdentity* _tmp12_;
	GHashTable* _tmp13_;
	GHashTable* _tmp14_;
	self = _data29_->self;
	g_return_if_fail (source_item != NULL);
	_tmp0_ = e_source_get_extension (source_item, E_SOURCE_EXTENSION_MAIL_IDENTITY);
	extension = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_mail_identity_get_type (), ESourceMailIdentity);
	_tmp1_ = extension;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = extension;
	_tmp3_ = e_source_mail_identity_get_address (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	address = _tmp4_;
	_tmp5_ = address;
	_tmp6_ = g_utf8_casefold (_tmp5_, (gssize) -1);
	_tmp7_ = _tmp6_;
	_tmp8_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _data29_->addresses, _tmp7_);
	_g_free0 (_tmp7_);
	if (_tmp8_) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = address;
		_tmp10_ = g_utf8_casefold (_tmp9_, (gssize) -1);
		_tmp11_ = _tmp10_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data29_->addresses, _tmp11_);
		_g_free0 (_tmp11_);
	}
	_tmp12_ = extension;
	_tmp13_ = e_source_mail_identity_get_aliases_as_hash_table (_tmp12_);
	aliases = _tmp13_;
	_tmp14_ = aliases;
	if (_tmp14_ != NULL) {
		GHashTable* _tmp15_;
		_tmp15_ = aliases;
		g_hash_table_foreach (_tmp15_, ____lambda10__gh_func, _data29_);
	}
	_g_hash_table_unref0 (aliases);
	_g_free0 (address);
}

static void
___lambda9__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda9_ (self, (ESource*) data);
}

GeeArrayList*
mail_backend_session_get_own_addresses (MailBackendSession* self)
{
	Block29Data* _data29_;
	GeeArrayList* _tmp0_;
	GList* sources = NULL;
	ESourceRegistry* _tmp1_;
	GList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_data29_->addresses = _tmp0_;
	_tmp1_ = self->priv->registry;
	_tmp2_ = e_source_registry_list_enabled (_tmp1_, E_SOURCE_EXTENSION_MAIL_IDENTITY);
	sources = _tmp2_;
	g_list_foreach (sources, ___lambda9__gfunc, _data29_);
	_tmp3_ = _g_object_ref0 (_data29_->addresses);
	result = _tmp3_;
	(sources == NULL) ? NULL : (sources = (_g_list_free__g_object_unref0_ (sources), NULL));
	block29_data_unref (_data29_);
	_data29_ = NULL;
	return result;
}

static ESource*
mail_backend_session_get_mail_submission_source_from_email (MailBackendSession* self,
                                                            CamelInternetAddress* from,
                                                            GError** error)
{
	GList* sources = NULL;
	ESourceRegistry* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	ESource* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (from != NULL, NULL);
	_tmp0_ = self->priv->registry;
	_tmp1_ = e_source_registry_list_enabled (_tmp0_, E_SOURCE_EXTENSION_MAIL_IDENTITY);
	sources = _tmp1_;
	_tmp2_ = sources;
	{
		GList* source_item_collection = NULL;
		GList* source_item_it = NULL;
		source_item_collection = _tmp2_;
		for (source_item_it = source_item_collection; source_item_it != NULL; source_item_it = source_item_it->next) {
			ESource* source_item = NULL;
			source_item = (ESource*) source_item_it->data;
			{
				ESourceMailIdentity* mail_identity = NULL;
				ESource* _tmp3_;
				ESourceExtension* _tmp4_;
				ESource* _tmp5_;
				_tmp3_ = source_item;
				_tmp4_ = e_source_get_extension (_tmp3_, E_SOURCE_EXTENSION_MAIL_IDENTITY);
				mail_identity = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, e_source_mail_identity_get_type (), ESourceMailIdentity);
				_tmp5_ = source_item;
				if (e_source_has_extension (_tmp5_, E_SOURCE_EXTENSION_MAIL_SUBMISSION)) {
					gchar* address = NULL;
					ESourceMailIdentity* _tmp6_;
					const gchar* _tmp7_;
					gchar* _tmp8_;
					const gchar* _tmp9_;
					GHashTable* aliases = NULL;
					ESourceMailIdentity* _tmp12_;
					GHashTable* _tmp13_;
					GHashTable* _tmp14_;
					_tmp6_ = mail_identity;
					_tmp7_ = e_source_mail_identity_get_address (_tmp6_);
					_tmp8_ = g_strdup (_tmp7_);
					address = _tmp8_;
					_tmp9_ = address;
					if (camel_internet_address_find_address (from, _tmp9_, NULL) == 0) {
						ESource* _tmp10_;
						ESource* _tmp11_;
						_tmp10_ = source_item;
						_tmp11_ = _g_object_ref0 (_tmp10_);
						result = _tmp11_;
						_g_free0 (address);
						(sources == NULL) ? NULL : (sources = (_g_list_free__g_object_unref0_ (sources), NULL));
						return result;
					}
					_tmp12_ = mail_identity;
					_tmp13_ = e_source_mail_identity_get_aliases_as_hash_table (_tmp12_);
					aliases = _tmp13_;
					_tmp14_ = aliases;
					if (_tmp14_ != NULL) {
						GList* aliases_mails = NULL;
						GHashTable* _tmp15_;
						GList* _tmp16_;
						GList* _tmp17_;
						_tmp15_ = aliases;
						_tmp16_ = g_hash_table_get_keys (_tmp15_);
						aliases_mails = _tmp16_;
						_tmp17_ = aliases_mails;
						{
							GList* key_collection = NULL;
							GList* key_it = NULL;
							key_collection = _tmp17_;
							for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
								const gchar* key = NULL;
								key = (const gchar*) key_it->data;
								{
									const gchar* _tmp18_;
									_tmp18_ = key;
									if (camel_internet_address_find_address (from, _tmp18_, NULL) == 0) {
										ESource* _tmp19_;
										ESource* _tmp20_;
										_tmp19_ = source_item;
										_tmp20_ = _g_object_ref0 (_tmp19_);
										result = _tmp20_;
										(aliases_mails == NULL) ? NULL : (aliases_mails = (g_list_free (aliases_mails), NULL));
										_g_hash_table_unref0 (aliases);
										_g_free0 (address);
										(sources == NULL) ? NULL : (sources = (_g_list_free__g_object_unref0_ (sources), NULL));
										return result;
									}
								}
							}
						}
						(aliases_mails == NULL) ? NULL : (aliases_mails = (g_list_free (aliases_mails), NULL));
					}
					_g_hash_table_unref0 (aliases);
					_g_free0 (address);
				}
			}
		}
	}
	result = NULL;
	(sources == NULL) ? NULL : (sources = (_g_list_free__g_object_unref0_ (sources), NULL));
	return result;
}

static ESource*
mail_backend_session_get_transport_source_from_mail_submission_source (MailBackendSession* self,
                                                                       ESource* mail_submission_source,
                                                                       GError** error)
{
	ESourceMailSubmission* mail_submission = NULL;
	ESourceExtension* _tmp0_;
	ESourceRegistry* _tmp1_;
	ESourceMailSubmission* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ESource* _tmp5_;
	ESource* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mail_submission_source != NULL, NULL);
	if (!e_source_has_extension (mail_submission_source, E_SOURCE_EXTENSION_MAIL_SUBMISSION)) {
		result = NULL;
		return result;
	}
	_tmp0_ = e_source_get_extension (mail_submission_source, E_SOURCE_EXTENSION_MAIL_SUBMISSION);
	mail_submission = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_mail_submission_get_type (), ESourceMailSubmission);
	_tmp1_ = self->priv->registry;
	_tmp2_ = mail_submission;
	_tmp3_ = e_source_mail_submission_get_transport_uid (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = e_source_registry_ref_source (_tmp1_, _tmp4_);
	result = _tmp5_;
	return result;
}

static CamelTransport*
mail_backend_session_get_camel_transport_from_transport_source (MailBackendSession* self,
                                                                ESource* transport_source,
                                                                GError** error)
{
	ESourceMailTransport* mail_transport = NULL;
	ESourceExtension* _tmp0_;
	CamelService* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ESourceMailTransport* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	CamelService* _tmp7_;
	CamelTransport* _tmp8_;
	GError* _inner_error0_ = NULL;
	CamelTransport* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (transport_source != NULL, NULL);
	if (!e_source_has_extension (transport_source, E_SOURCE_EXTENSION_MAIL_TRANSPORT)) {
		result = NULL;
		return result;
	}
	_tmp0_ = e_source_get_extension (transport_source, E_SOURCE_EXTENSION_MAIL_TRANSPORT);
	mail_transport = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_mail_transport_get_type (), ESourceMailTransport);
	_tmp2_ = e_source_get_uid (transport_source);
	_tmp3_ = _tmp2_;
	_tmp4_ = mail_transport;
	_tmp5_ = e_source_backend_get_backend_name ((ESourceBackend*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = camel_session_add_service ((CamelSession*) self, _tmp3_, _tmp6_, CAMEL_PROVIDER_TRANSPORT, &_inner_error0_);
	_tmp1_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, camel_transport_get_type ()) ? ((CamelTransport*) _tmp1_) : NULL);
	result = _tmp8_;
	_g_object_unref0 (_tmp1_);
	return result;
}

static void
mail_backend_session_send_email_data_free (gpointer _data)
{
	MailBackendSessionSendEmailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->from);
	_g_object_unref0 (_data_->recipients);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailBackendSessionSendEmailData, _data_);
}

void
mail_backend_session_send_email (MailBackendSession* self,
                                 CamelMimeMessage* message,
                                 CamelInternetAddress* from,
                                 CamelAddress* recipients,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	MailBackendSessionSendEmailData* _data_;
	MailBackendSession* _tmp0_;
	CamelMimeMessage* _tmp1_;
	CamelInternetAddress* _tmp2_;
	CamelAddress* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (from != NULL);
	g_return_if_fail (recipients != NULL);
	_data_ = g_slice_new0 (MailBackendSessionSendEmailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_backend_session_send_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (message);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp1_;
	_tmp2_ = _g_object_ref0 (from);
	_g_object_unref0 (_data_->from);
	_data_->from = _tmp2_;
	_tmp3_ = _g_object_ref0 (recipients);
	_g_object_unref0 (_data_->recipients);
	_data_->recipients = _tmp3_;
	mail_backend_session_send_email_co (_data_);
}

gboolean
mail_backend_session_send_email_finish (MailBackendSession* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	gboolean result;
	MailBackendSessionSendEmailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
mail_backend_session_send_email_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	MailBackendSessionSendEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_backend_session_send_email_co (_data_);
}

static gboolean
mail_backend_session_send_email_co (MailBackendSessionSendEmailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = mail_backend_session_get_mail_submission_source_from_email (_data_->self, _data_->from, &_data_->_inner_error0_);
	_data_->mail_submission_source = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->mail_submission_source;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = g_error_new_literal (CAMEL_ERROR, CAMEL_ERROR_GENERIC, "Unable to retrieve source for mail submission.");
		_data_->_inner_error0_ = _data_->_tmp2_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->mail_submission_source);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->mail_submission_source;
	_data_->_tmp4_ = mail_backend_session_get_transport_source_from_mail_submission_source (_data_->self, _data_->_tmp3_, &_data_->_inner_error0_);
	_data_->transport_source = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->mail_submission_source);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->transport_source;
	if (_data_->_tmp5_ == NULL) {
		_data_->_tmp6_ = g_error_new_literal (CAMEL_ERROR, CAMEL_ERROR_GENERIC, "Unable to retrieve source for transport.");
		_data_->_inner_error0_ = _data_->_tmp6_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->transport_source);
		_g_object_unref0 (_data_->mail_submission_source);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->transport_source;
	_data_->_tmp8_ = mail_backend_session_get_camel_transport_from_transport_source (_data_->self, _data_->_tmp7_, &_data_->_inner_error0_);
	_data_->transport = _data_->_tmp8_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->transport_source);
		_g_object_unref0 (_data_->mail_submission_source);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->transport;
	if (_data_->_tmp9_ == NULL) {
		_data_->_tmp10_ = g_error_new_literal (CAMEL_SERVICE_ERROR, CAMEL_SERVICE_ERROR_UNAVAILABLE, "No camel service for sending email found.");
		_data_->_inner_error0_ = _data_->_tmp10_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->transport);
		_g_object_unref0 (_data_->transport_source);
		_g_object_unref0 (_data_->mail_submission_source);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->transport;
	_data_->_state_ = 1;
	camel_service_connect ((CamelService*) _data_->_tmp11_, G_PRIORITY_LOW, NULL, mail_backend_session_send_email_ready, _data_);
	return FALSE;
	_state_1:
	camel_service_connect_finish ((CamelService*) _data_->_tmp11_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->transport);
		_g_object_unref0 (_data_->transport_source);
		_g_object_unref0 (_data_->mail_submission_source);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->transport;
	_data_->_tmp13_ = FALSE;
	_data_->_state_ = 2;
	camel_transport_send_to (_data_->_tmp12_, _data_->message, (CamelAddress*) _data_->from, _data_->recipients, G_PRIORITY_LOW, NULL, mail_backend_session_send_email_ready, _data_);
	return FALSE;
	_state_2:
	camel_transport_send_to_finish (_data_->_tmp12_, _data_->_res_, &_data_->_tmp13_, &_data_->_inner_error0_);
	_data_->sent_message_saved = _data_->_tmp13_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->transport);
		_g_object_unref0 (_data_->transport_source);
		_g_object_unref0 (_data_->mail_submission_source);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->transport;
	_data_->_state_ = 3;
	camel_service_disconnect ((CamelService*) _data_->_tmp14_, TRUE, G_PRIORITY_LOW, NULL, mail_backend_session_send_email_ready, _data_);
	return FALSE;
	_state_3:
	camel_service_disconnect_finish ((CamelService*) _data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->transport);
		_g_object_unref0 (_data_->transport_source);
		_g_object_unref0 (_data_->mail_submission_source);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = _data_->transport_source;
	if (e_source_has_extension (_data_->_tmp15_, E_SOURCE_EXTENSION_AUTHENTICATION)) {
		_data_->_tmp16_ = _data_->transport_source;
		_data_->_tmp17_ = e_source_get_extension (_data_->_tmp16_, E_SOURCE_EXTENSION_AUTHENTICATION);
		_data_->transport_auth_extension = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, e_source_authentication_get_type (), ESourceAuthentication);
		_data_->_tmp21_ = _data_->transport_auth_extension;
		_data_->_tmp22_ = e_source_authentication_get_host (_data_->_tmp21_);
		_data_->_tmp23_ = _data_->_tmp22_;
		_data_->_tmp24_ = e_util_utf8_strstrcase (_data_->_tmp23_, ".gmail.com");
		if (_data_->_tmp24_ != NULL) {
			_data_->_tmp20_ = TRUE;
		} else {
			_data_->_tmp25_ = _data_->transport_auth_extension;
			_data_->_tmp26_ = e_source_authentication_get_host (_data_->_tmp25_);
			_data_->_tmp27_ = _data_->_tmp26_;
			_data_->_tmp28_ = e_util_utf8_strstrcase (_data_->_tmp27_, ".googlemail.com");
			_data_->_tmp20_ = _data_->_tmp28_ != NULL;
		}
		if (_data_->_tmp20_) {
			_data_->_tmp19_ = TRUE;
		} else {
			_data_->_tmp29_ = _data_->transport_auth_extension;
			_data_->_tmp30_ = e_source_authentication_get_host (_data_->_tmp29_);
			_data_->_tmp31_ = _data_->_tmp30_;
			_data_->_tmp32_ = e_util_utf8_strstrcase (_data_->_tmp31_, ".office365.com");
			_data_->_tmp19_ = _data_->_tmp32_ != NULL;
		}
		if (_data_->_tmp19_) {
			_data_->_tmp18_ = TRUE;
		} else {
			_data_->_tmp33_ = _data_->transport_auth_extension;
			_data_->_tmp34_ = e_source_authentication_get_host (_data_->_tmp33_);
			_data_->_tmp35_ = _data_->_tmp34_;
			_data_->_tmp36_ = e_util_utf8_strstrcase (_data_->_tmp35_, ".outlook.com");
			_data_->_tmp18_ = _data_->_tmp36_ != NULL;
		}
		if (_data_->_tmp18_) {
			_data_->sent_message_saved = TRUE;
		}
	}
	if (!_data_->sent_message_saved) {
		_data_->_tmp37_ = _data_->transport;
		_data_->_tmp38_ = camel_service_get_provider ((CamelService*) _data_->_tmp37_);
		_data_->provider = _data_->_tmp38_;
		_data_->_tmp40_ = _data_->provider;
		if (_data_->_tmp40_ != NULL) {
			_data_->_tmp41_ = _data_->provider;
			_data_->_tmp39_ = (_data_->_tmp41_->flags & CAMEL_PROVIDER_DISABLE_SENT_FOLDER) == CAMEL_PROVIDER_DISABLE_SENT_FOLDER;
		} else {
			_data_->_tmp39_ = FALSE;
		}
		if (_data_->_tmp39_) {
			g_debug ("Session.vala:464: Sent folder is disabled - sent message is not saved.");
		} else {
			{
				_data_->_tmp42_ = mail_backend_session_get_camel_store_from_email (_data_->self, _data_->from);
				_data_->camel_store = _data_->_tmp42_;
				_data_->_tmp43_ = _data_->camel_store;
				if (_data_->_tmp43_ == NULL) {
					_data_->_tmp44_ = g_error_new_literal (CAMEL_SERVICE_ERROR, CAMEL_SERVICE_ERROR_UNAVAILABLE, "No camel service for saving sent found.");
					_data_->_inner_error0_ = _data_->_tmp44_;
					_g_object_unref0 (_data_->camel_store);
					goto __catch0_g_error;
				}
				_data_->_tmp45_ = _data_->mail_submission_source;
				_data_->_tmp46_ = e_source_get_extension (_data_->_tmp45_, E_SOURCE_EXTENSION_MAIL_SUBMISSION);
				_data_->mail_submission_extension = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp46_, e_source_mail_submission_get_type (), ESourceMailSubmission);
				_data_->_tmp47_ = _data_->mail_submission_extension;
				_data_->_tmp48_ = e_source_mail_submission_dup_sent_folder (_data_->_tmp47_);
				_data_->sent_folder_uri = _data_->_tmp48_;
				_data_->_tmp49_ = _data_->sent_folder_uri;
				if (_data_->_tmp49_ != NULL) {
					_data_->_tmp50_ = _data_->sent_folder_uri;
					camel_url_decode (_data_->_tmp50_);
				}
				_data_->_tmp52_ = _data_->sent_folder_uri;
				if (_data_->_tmp52_ == NULL) {
					_data_->_tmp51_ = TRUE;
				} else {
					_data_->_tmp53_ = _data_->sent_folder_uri;
					_data_->_tmp51_ = g_strcmp0 (_data_->_tmp53_, "") == 0;
				}
				if (_data_->_tmp51_) {
					_data_->_tmp54_ = g_error_new_literal (CAMEL_FOLDER_ERROR, CAMEL_FOLDER_ERROR_INVALID_PATH, "Unable to fetch uri for sent folder.");
					_data_->_inner_error0_ = _data_->_tmp54_;
					_g_free0 (_data_->sent_folder_uri);
					_g_object_unref0 (_data_->camel_store);
					goto __catch0_g_error;
				}
				_data_->sent_folder = NULL;
				_data_->_tmp56_ = _data_->camel_store;
				_data_->_tmp57_ = _data_->camel_store;
				_data_->_tmp58_ = camel_service_get_uid ((CamelService*) _data_->_tmp57_);
				_data_->_tmp59_ = _data_->_tmp58_;
				_data_->_tmp60_ = _data_->sent_folder_uri;
				_data_->_tmp61_ = mail_utils_strip_folder_full_name (_data_->_tmp59_, _data_->_tmp60_);
				_data_->_tmp62_ = _data_->_tmp61_;
				_data_->_state_ = 4;
				camel_store_get_folder (_data_->_tmp56_, _data_->_tmp62_, CAMEL_STORE_FOLDER_NONE, 0, NULL, mail_backend_session_send_email_ready, _data_);
				return FALSE;
				_state_4:
				_data_->_tmp63_ = camel_store_get_folder_finish (_data_->_tmp56_, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp64_ = _data_->_tmp63_;
				_g_free0 (_data_->_tmp62_);
				_data_->_tmp55_ = _data_->_tmp64_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->sent_folder);
					_g_free0 (_data_->sent_folder_uri);
					_g_object_unref0 (_data_->camel_store);
					goto __catch0_g_error;
				}
				_data_->_tmp65_ = _data_->_tmp55_;
				_data_->_tmp55_ = NULL;
				_g_object_unref0 (_data_->sent_folder);
				_data_->sent_folder = _data_->_tmp65_;
				_data_->_tmp66_ = _data_->sent_folder;
				if (_data_->_tmp66_ == NULL) {
					_data_->_tmp67_ = g_error_new_literal (CAMEL_STORE_ERROR, CAMEL_STORE_ERROR_NO_FOLDER, "Unable to connect to sent folder.");
					_data_->_inner_error0_ = _data_->_tmp67_;
					_g_object_unref0 (_data_->_tmp55_);
					_g_object_unref0 (_data_->sent_folder);
					_g_free0 (_data_->sent_folder_uri);
					_g_object_unref0 (_data_->camel_store);
					goto __catch0_g_error;
				}
				_data_->_tmp68_ = mail_backend_session_message_info_new (CAMEL_MESSAGE_SEEN);
				_data_->message_info = _data_->_tmp68_;
				_data_->_tmp69_ = _data_->sent_folder;
				_data_->_tmp70_ = _data_->message_info;
				_data_->_state_ = 5;
				camel_folder_append_message (_data_->_tmp69_, _data_->message, (CamelMessageInfo*) _data_->_tmp70_, 0, NULL, mail_backend_session_send_email_ready, _data_);
				return FALSE;
				_state_5:
				camel_folder_append_message_finish (_data_->_tmp69_, _data_->_res_, NULL, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->message_info);
					_g_object_unref0 (_data_->_tmp55_);
					_g_object_unref0 (_data_->sent_folder);
					_g_free0 (_data_->sent_folder_uri);
					_g_object_unref0 (_data_->camel_store);
					goto __catch0_g_error;
				}
				_data_->sent_message_saved = TRUE;
				_g_object_unref0 (_data_->message_info);
				_g_object_unref0 (_data_->_tmp55_);
				_g_object_unref0 (_data_->sent_folder);
				_g_free0 (_data_->sent_folder_uri);
				_g_object_unref0 (_data_->camel_store);
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp71_ = _data_->e;
				_data_->_tmp72_ = _data_->_tmp71_->message;
				g_warning ("Session.vala:498: Unable to append message to Sent folder: %s", _data_->_tmp72_);
				_g_error_free0 (_data_->e);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				__vala_CamelProvider_free0 (_data_->provider);
				_g_object_unref0 (_data_->transport);
				_g_object_unref0 (_data_->transport_source);
				_g_object_unref0 (_data_->mail_submission_source);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		__vala_CamelProvider_free0 (_data_->provider);
	}
	_data_->_tmp73_ = _data_->transport;
	camel_session_remove_service ((CamelSession*) _data_->self, (CamelService*) _data_->_tmp73_);
	_data_->result = _data_->sent_message_saved;
	_g_object_unref0 (_data_->transport);
	_g_object_unref0 (_data_->transport_source);
	_g_object_unref0 (_data_->mail_submission_source);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

ESource*
mail_backend_session_ref_source (MailBackendSession* self,
                                 const gchar* source_uid)
{
	ESourceRegistry* _tmp0_;
	ESource* _tmp1_;
	ESource* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_uid != NULL, NULL);
	_tmp0_ = self->priv->registry;
	_tmp1_ = e_source_registry_ref_source (_tmp0_, source_uid);
	result = _tmp1_;
	return result;
}

static CamelStore*
mail_backend_session_get_camel_store_from_email (MailBackendSession* self,
                                                 CamelInternetAddress* from)
{
	GList* sources = NULL;
	ESourceRegistry* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	CamelStore* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (from != NULL, NULL);
	_tmp0_ = self->priv->registry;
	_tmp1_ = e_source_registry_list_enabled (_tmp0_, E_SOURCE_EXTENSION_MAIL_ACCOUNT);
	sources = _tmp1_;
	_tmp2_ = sources;
	{
		GList* source_item_collection = NULL;
		GList* source_item_it = NULL;
		source_item_collection = _tmp2_;
		for (source_item_it = source_item_collection; source_item_it != NULL; source_item_it = source_item_it->next) {
			ESource* source_item = NULL;
			source_item = (ESource*) source_item_it->data;
			{
				const gchar* account_uid = NULL;
				ESource* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				ESourceMailAccount* mail_account = NULL;
				ESource* _tmp7_;
				ESourceExtension* _tmp8_;
				gchar* identity_uid = NULL;
				ESourceMailAccount* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gboolean _tmp13_ = FALSE;
				const gchar* _tmp14_;
				ESource* identity_source = NULL;
				ESourceRegistry* _tmp16_;
				const gchar* _tmp17_;
				ESource* _tmp18_;
				gboolean _tmp19_ = FALSE;
				ESource* _tmp20_;
				ESourceMailIdentity* mail_identity = NULL;
				ESource* _tmp22_;
				ESourceExtension* _tmp23_;
				gchar* address = NULL;
				ESourceMailIdentity* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				const gchar* _tmp27_;
				GHashTable* aliases = NULL;
				ESourceMailIdentity* _tmp30_;
				GHashTable* _tmp31_;
				GHashTable* _tmp32_;
				_tmp3_ = source_item;
				_tmp4_ = e_source_get_uid (_tmp3_);
				_tmp5_ = _tmp4_;
				account_uid = _tmp5_;
				_tmp6_ = account_uid;
				if (g_strcmp0 (_tmp6_, "vfolder") == 0) {
					continue;
				}
				_tmp7_ = source_item;
				_tmp8_ = e_source_get_extension (_tmp7_, E_SOURCE_EXTENSION_MAIL_ACCOUNT);
				mail_account = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, e_source_mail_account_get_type (), ESourceMailAccount);
				_tmp9_ = mail_account;
				_tmp10_ = e_source_mail_account_get_identity_uid (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strdup (_tmp11_);
				identity_uid = _tmp12_;
				_tmp14_ = identity_uid;
				if (_tmp14_ == NULL) {
					_tmp13_ = TRUE;
				} else {
					const gchar* _tmp15_;
					_tmp15_ = identity_uid;
					_tmp13_ = g_strcmp0 (_tmp15_, "") == 0;
				}
				if (_tmp13_) {
					_g_free0 (identity_uid);
					continue;
				}
				_tmp16_ = self->priv->registry;
				_tmp17_ = identity_uid;
				_tmp18_ = e_source_registry_ref_source (_tmp16_, _tmp17_);
				identity_source = _tmp18_;
				_tmp20_ = identity_source;
				if (_tmp20_ == NULL) {
					_tmp19_ = TRUE;
				} else {
					ESource* _tmp21_;
					_tmp21_ = identity_source;
					_tmp19_ = !e_source_has_extension (_tmp21_, E_SOURCE_EXTENSION_MAIL_IDENTITY);
				}
				if (_tmp19_) {
					_g_object_unref0 (identity_source);
					_g_free0 (identity_uid);
					continue;
				}
				_tmp22_ = identity_source;
				_tmp23_ = e_source_get_extension (_tmp22_, E_SOURCE_EXTENSION_MAIL_IDENTITY);
				mail_identity = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, e_source_mail_identity_get_type (), ESourceMailIdentity);
				_tmp24_ = mail_identity;
				_tmp25_ = e_source_mail_identity_get_address (_tmp24_);
				_tmp26_ = g_strdup (_tmp25_);
				address = _tmp26_;
				_tmp27_ = address;
				if (camel_internet_address_find_address (from, _tmp27_, NULL) == 0) {
					const gchar* _tmp28_;
					CamelService* _tmp29_;
					_tmp28_ = account_uid;
					_tmp29_ = camel_session_ref_service ((CamelSession*) self, _tmp28_);
					result = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, camel_store_get_type (), CamelStore);
					_g_free0 (address);
					_g_object_unref0 (identity_source);
					_g_free0 (identity_uid);
					(sources == NULL) ? NULL : (sources = (_g_list_free__g_object_unref0_ (sources), NULL));
					return result;
				}
				_tmp30_ = mail_identity;
				_tmp31_ = e_source_mail_identity_get_aliases_as_hash_table (_tmp30_);
				aliases = _tmp31_;
				_tmp32_ = aliases;
				if (_tmp32_ != NULL) {
					GList* aliases_mails = NULL;
					GHashTable* _tmp33_;
					GList* _tmp34_;
					GList* _tmp35_;
					_tmp33_ = aliases;
					_tmp34_ = g_hash_table_get_keys (_tmp33_);
					aliases_mails = _tmp34_;
					_tmp35_ = aliases_mails;
					{
						GList* key_collection = NULL;
						GList* key_it = NULL;
						key_collection = _tmp35_;
						for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
							const gchar* key = NULL;
							key = (const gchar*) key_it->data;
							{
								const gchar* _tmp36_;
								_tmp36_ = key;
								if (camel_internet_address_find_address (from, _tmp36_, NULL) == 0) {
									const gchar* _tmp37_;
									CamelService* _tmp38_;
									_tmp37_ = account_uid;
									_tmp38_ = camel_session_ref_service ((CamelSession*) self, _tmp37_);
									result = G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, camel_store_get_type (), CamelStore);
									(aliases_mails == NULL) ? NULL : (aliases_mails = (g_list_free (aliases_mails), NULL));
									_g_hash_table_unref0 (aliases);
									_g_free0 (address);
									_g_object_unref0 (identity_source);
									_g_free0 (identity_uid);
									(sources == NULL) ? NULL : (sources = (_g_list_free__g_object_unref0_ (sources), NULL));
									return result;
								}
							}
						}
					}
					(aliases_mails == NULL) ? NULL : (aliases_mails = (g_list_free (aliases_mails), NULL));
				}
				_g_hash_table_unref0 (aliases);
				_g_free0 (address);
				_g_object_unref0 (identity_source);
				_g_free0 (identity_uid);
			}
		}
	}
	result = NULL;
	(sources == NULL) ? NULL : (sources = (_g_list_free__g_object_unref0_ (sources), NULL));
	return result;
}

static void
mail_backend_session_save_draft_data_free (gpointer _data)
{
	MailBackendSessionSaveDraftData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->from);
	_g_object_unref0 (_data_->recipients);
	_g_object_unref0 (_data_->ancestor_message_info);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailBackendSessionSaveDraftData, _data_);
}

void
mail_backend_session_save_draft (MailBackendSession* self,
                                 CamelMimeMessage* message,
                                 CamelInternetAddress* from,
                                 CamelAddress* recipients,
                                 CamelMessageInfo* ancestor_message_info,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	MailBackendSessionSaveDraftData* _data_;
	MailBackendSession* _tmp0_;
	CamelMimeMessage* _tmp1_;
	CamelInternetAddress* _tmp2_;
	CamelAddress* _tmp3_;
	CamelMessageInfo* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (from != NULL);
	g_return_if_fail (recipients != NULL);
	_data_ = g_slice_new0 (MailBackendSessionSaveDraftData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_backend_session_save_draft_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (message);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp1_;
	_tmp2_ = _g_object_ref0 (from);
	_g_object_unref0 (_data_->from);
	_data_->from = _tmp2_;
	_tmp3_ = _g_object_ref0 (recipients);
	_g_object_unref0 (_data_->recipients);
	_data_->recipients = _tmp3_;
	_tmp4_ = _g_object_ref0 (ancestor_message_info);
	_g_object_unref0 (_data_->ancestor_message_info);
	_data_->ancestor_message_info = _tmp4_;
	mail_backend_session_save_draft_co (_data_);
}

void
mail_backend_session_save_draft_finish (MailBackendSession* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	MailBackendSessionSaveDraftData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
mail_backend_session_save_draft_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	MailBackendSessionSaveDraftData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_backend_session_save_draft_co (_data_);
}

static gboolean
mail_backend_session_save_draft_co (MailBackendSessionSaveDraftData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = mail_backend_session_get_camel_store_from_email (_data_->self, _data_->from);
	_data_->camel_store = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->camel_store;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = g_error_new_literal (CAMEL_SERVICE_ERROR, CAMEL_SERVICE_ERROR_UNAVAILABLE, "No camel service for saving draft found.");
		_data_->_inner_error0_ = _data_->_tmp2_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->camel_store);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->camel_store;
	_data_->_tmp4_ = mail_backend_session_get_drafts_folder_uri_for_store (_data_->self, _data_->_tmp3_);
	_data_->drafts_folder_uri = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->drafts_folder_uri;
	if (_data_->_tmp6_ == NULL) {
		_data_->_tmp5_ = TRUE;
	} else {
		_data_->_tmp7_ = _data_->drafts_folder_uri;
		_data_->_tmp5_ = g_strcmp0 (_data_->_tmp7_, "") == 0;
	}
	if (_data_->_tmp5_) {
		_data_->_tmp8_ = g_error_new_literal (CAMEL_FOLDER_ERROR, CAMEL_FOLDER_ERROR_INVALID_PATH, "Unable to fetch uri for drafts folder.");
		_data_->_inner_error0_ = _data_->_tmp8_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->drafts_folder_uri);
		_g_object_unref0 (_data_->camel_store);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->drafts_folder = NULL;
	_data_->_tmp10_ = _data_->camel_store;
	_data_->_tmp11_ = _data_->camel_store;
	_data_->_tmp12_ = camel_service_get_uid ((CamelService*) _data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->_tmp14_ = _data_->drafts_folder_uri;
	_data_->_tmp15_ = mail_utils_strip_folder_full_name (_data_->_tmp13_, _data_->_tmp14_);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_state_ = 1;
	camel_store_get_folder (_data_->_tmp10_, _data_->_tmp16_, CAMEL_STORE_FOLDER_NONE, 0, NULL, mail_backend_session_save_draft_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp17_ = camel_store_get_folder_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp18_ = _data_->_tmp17_;
	_g_free0 (_data_->_tmp16_);
	_data_->_tmp9_ = _data_->_tmp18_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->drafts_folder);
		_g_free0 (_data_->drafts_folder_uri);
		_g_object_unref0 (_data_->camel_store);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = _data_->_tmp9_;
	_data_->_tmp9_ = NULL;
	_g_object_unref0 (_data_->drafts_folder);
	_data_->drafts_folder = _data_->_tmp19_;
	_data_->_tmp20_ = _data_->drafts_folder;
	if (_data_->_tmp20_ == NULL) {
		_data_->_tmp21_ = g_error_new_literal (CAMEL_STORE_ERROR, CAMEL_STORE_ERROR_NO_FOLDER, "Unable to connect to drafts folder.");
		_data_->_inner_error0_ = _data_->_tmp21_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp9_);
		_g_object_unref0 (_data_->drafts_folder);
		_g_free0 (_data_->drafts_folder_uri);
		_g_object_unref0 (_data_->camel_store);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp22_ = mail_backend_session_message_info_new (CAMEL_MESSAGE_DRAFT);
	_data_->message_info = _data_->_tmp22_;
	_data_->_tmp23_ = _data_->drafts_folder;
	_data_->_tmp24_ = _data_->message_info;
	_data_->_state_ = 2;
	camel_folder_append_message (_data_->_tmp23_, _data_->message, (CamelMessageInfo*) _data_->_tmp24_, 0, NULL, mail_backend_session_save_draft_ready, _data_);
	return FALSE;
	_state_2:
	camel_folder_append_message_finish (_data_->_tmp23_, _data_->_res_, NULL, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->message_info);
		_g_object_unref0 (_data_->_tmp9_);
		_g_object_unref0 (_data_->drafts_folder);
		_g_free0 (_data_->drafts_folder_uri);
		_g_object_unref0 (_data_->camel_store);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->ancestor_message_info != NULL) {
		g_object_get (_data_->ancestor_message_info, "flags", &_data_->_tmp26_, NULL);
		_data_->_tmp27_ = _data_->_tmp26_;
		_data_->_tmp25_ = (((gint) _data_->_tmp27_) & CAMEL_MESSAGE_DRAFT) == CAMEL_MESSAGE_DRAFT;
	} else {
		_data_->_tmp25_ = FALSE;
	}
	if (_data_->_tmp25_) {
		camel_message_info_set_flags (_data_->ancestor_message_info, (guint32) CAMEL_MESSAGE_DELETED, (guint32) (~0));
		_data_->_tmp28_ = _data_->drafts_folder;
		_data_->_state_ = 3;
		camel_folder_expunge (_data_->_tmp28_, G_PRIORITY_DEFAULT, NULL, mail_backend_session_save_draft_ready, _data_);
		return FALSE;
		_state_3:
		camel_folder_expunge_finish (_data_->_tmp28_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->message_info);
			_g_object_unref0 (_data_->_tmp9_);
			_g_object_unref0 (_data_->drafts_folder);
			_g_free0 (_data_->drafts_folder_uri);
			_g_object_unref0 (_data_->camel_store);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->message_info);
	_g_object_unref0 (_data_->_tmp9_);
	_g_object_unref0 (_data_->drafts_folder);
	_g_free0 (_data_->drafts_folder_uri);
	_g_object_unref0 (_data_->camel_store);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
mail_backend_session_check_for_signature_change (MailBackendSession* self,
                                                 ESource* source)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	if (e_source_has_extension (source, E_SOURCE_EXTENSION_MAIL_SIGNATURE)) {
		g_signal_emit (self, mail_backend_session_signals[MAIL_BACKEND_SESSION_SIGNATURE_CHANGED_SIGNAL], 0);
	}
}

static void
mail_backend_session_set_signature_uid_for_account_uid_data_free (gpointer _data)
{
	MailBackendSessionSetSignatureUidForAccountUidData* _data_;
	_data_ = _data;
	_g_free0 (_data_->account_uid);
	_g_free0 (_data_->signature_uid);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailBackendSessionSetSignatureUidForAccountUidData, _data_);
}

void
mail_backend_session_set_signature_uid_for_account_uid (MailBackendSession* self,
                                                        const gchar* account_uid,
                                                        const gchar* signature_uid,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	MailBackendSessionSetSignatureUidForAccountUidData* _data_;
	MailBackendSession* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account_uid != NULL);
	g_return_if_fail (signature_uid != NULL);
	_data_ = g_slice_new0 (MailBackendSessionSetSignatureUidForAccountUidData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_backend_session_set_signature_uid_for_account_uid_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (account_uid);
	_g_free0 (_data_->account_uid);
	_data_->account_uid = _tmp1_;
	_tmp2_ = g_strdup (signature_uid);
	_g_free0 (_data_->signature_uid);
	_data_->signature_uid = _tmp2_;
	mail_backend_session_set_signature_uid_for_account_uid_co (_data_);
}

void
mail_backend_session_set_signature_uid_for_account_uid_finish (MailBackendSession* self,
                                                               GAsyncResult* _res_)
{
	MailBackendSessionSetSignatureUidForAccountUidData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_backend_session_set_signature_uid_for_account_uid_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	MailBackendSessionSetSignatureUidForAccountUidData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_backend_session_set_signature_uid_for_account_uid_co (_data_);
}

static gboolean
mail_backend_session_set_signature_uid_for_account_uid_co (MailBackendSessionSetSignatureUidForAccountUidData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = mail_backend_session_get_identity_source_for_account_uid (_data_->self, _data_->account_uid);
	_data_->identity_source = _data_->_tmp0_;
	_data_->_tmp1_ = e_source_get_extension (_data_->identity_source, E_SOURCE_EXTENSION_MAIL_IDENTITY);
	_data_->identity_extension = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, e_source_mail_identity_get_type (), ESourceMailIdentity);
	e_source_mail_identity_set_signature_uid (_data_->identity_extension, _data_->signature_uid);
	{
		_data_->_state_ = 1;
		e_source_write (_data_->identity_source, NULL, mail_backend_session_set_signature_uid_for_account_uid_ready, _data_);
		return FALSE;
		_state_1:
		e_source_write_finish (_data_->identity_source, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = e_source_mail_identity_get_address (_data_->identity_extension);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_warning ("Session.vala:599: Failed to update default signature for '%s': %s", _data_->_tmp3_, _data_->_tmp5_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->identity_source);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->identity_source);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gchar*
mail_backend_session_get_signature_uid_for_sender (MailBackendSession* self,
                                                   const gchar* sender)
{
	CamelInternetAddress* sender_address = NULL;
	CamelInternetAddress* _tmp0_;
	CamelInternetAddress* _tmp1_;
	CamelStore* store = NULL;
	CamelInternetAddress* _tmp2_;
	CamelStore* _tmp3_;
	CamelStore* _tmp4_;
	ESource* identity_source = NULL;
	CamelStore* _tmp6_;
	ESource* _tmp7_;
	ESourceMailIdentity* identity_extension = NULL;
	ESource* _tmp8_;
	ESourceExtension* _tmp9_;
	ESourceMailIdentity* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sender != NULL, NULL);
	_tmp0_ = camel_internet_address_new ();
	sender_address = _tmp0_;
	_tmp1_ = sender_address;
	camel_address_unformat ((CamelAddress*) _tmp1_, sender);
	_tmp2_ = sender_address;
	_tmp3_ = mail_backend_session_get_camel_store_from_email (self, _tmp2_);
	store = _tmp3_;
	_tmp4_ = store;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("none");
		result = _tmp5_;
		_g_object_unref0 (store);
		_g_object_unref0 (sender_address);
		return result;
	}
	_tmp6_ = store;
	_tmp7_ = mail_backend_session_get_identity_source_for_service (self, (CamelService*) _tmp6_);
	identity_source = _tmp7_;
	_tmp8_ = identity_source;
	_tmp9_ = e_source_get_extension (_tmp8_, E_SOURCE_EXTENSION_MAIL_IDENTITY);
	identity_extension = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, e_source_mail_identity_get_type (), ESourceMailIdentity);
	_tmp10_ = identity_extension;
	_tmp11_ = e_source_mail_identity_get_signature_uid (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	_g_object_unref0 (identity_source);
	_g_object_unref0 (store);
	_g_object_unref0 (sender_address);
	return result;
}

static void
mail_backend_session_get_signature_for_uid_data_free (gpointer _data)
{
	MailBackendSessionGetSignatureForUidData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uid);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailBackendSessionGetSignatureForUidData, _data_);
}

void
mail_backend_session_get_signature_for_uid (MailBackendSession* self,
                                            const gchar* uid,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	MailBackendSessionGetSignatureForUidData* _data_;
	MailBackendSession* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	_data_ = g_slice_new0 (MailBackendSessionGetSignatureForUidData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_backend_session_get_signature_for_uid_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uid);
	_g_free0 (_data_->uid);
	_data_->uid = _tmp1_;
	mail_backend_session_get_signature_for_uid_co (_data_);
}

gchar*
mail_backend_session_get_signature_for_uid_finish (MailBackendSession* self,
                                                   GAsyncResult* _res_)
{
	gchar* result;
	MailBackendSessionGetSignatureForUidData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
mail_backend_session_get_signature_for_uid_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	MailBackendSessionGetSignatureForUidData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_backend_session_get_signature_for_uid_co (_data_);
}

static gboolean
mail_backend_session_get_signature_for_uid_co (MailBackendSessionGetSignatureForUidData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->registry;
	_data_->_tmp1_ = e_source_registry_ref_source (_data_->_tmp0_, _data_->uid);
	_data_->signature_source = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->signature_source;
	if (_data_->_tmp2_ == NULL) {
		g_warning ("Session.vala:621: Signature with uid '%s' not found.", _data_->uid);
		_data_->_tmp3_ = g_strdup ("");
		_data_->result = _data_->_tmp3_;
		_g_object_unref0 (_data_->signature_source);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp5_ = _data_->signature_source;
		_data_->_tmp6_ = NULL;
		_data_->_tmp7_ = 0UL;
		_data_->_state_ = 1;
		e_source_mail_signature_load (_data_->_tmp5_, G_PRIORITY_DEFAULT, NULL, mail_backend_session_get_signature_for_uid_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = e_source_mail_signature_load_finish (_data_->_tmp5_, _data_->_res_, &_data_->_tmp6_, &_data_->_tmp7_, &_data_->_inner_error0_);
		_g_free0 (_data_->signature);
		_data_->signature = _data_->_tmp6_;
		_data_->length = _data_->_tmp7_;
		_data_->_tmp4_ = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_data_->_tmp4_) {
			_data_->result = _data_->signature;
			_g_object_unref0 (_data_->signature_source);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_warning ("Session.vala:632: Failed to load signature: %s", _data_->_tmp10_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->signature);
		_g_object_unref0 (_data_->signature_source);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = g_strdup ("");
	_data_->result = _data_->_tmp11_;
	_g_free0 (_data_->signature);
	_g_object_unref0 (_data_->signature_source);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_backend_session_create_new_signature_data_free (gpointer _data)
{
	MailBackendSessionCreateNewSignatureData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailBackendSessionCreateNewSignatureData, _data_);
}

void
mail_backend_session_create_new_signature (MailBackendSession* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	MailBackendSessionCreateNewSignatureData* _data_;
	MailBackendSession* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailBackendSessionCreateNewSignatureData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_backend_session_create_new_signature_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_backend_session_create_new_signature_co (_data_);
}

ESource*
mail_backend_session_create_new_signature_finish (MailBackendSession* self,
                                                  GAsyncResult* _res_)
{
	ESource* result;
	MailBackendSessionCreateNewSignatureData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
mail_backend_session_create_new_signature_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	MailBackendSessionCreateNewSignatureData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_backend_session_create_new_signature_co (_data_);
}

static gboolean
mail_backend_session_create_new_signature_co (MailBackendSessionCreateNewSignatureData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = g_uuid_string_random ();
		_data_->uid = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->uid;
		_data_->_tmp2_ = g_strdup (_ ("New Signature"));
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = e_source_new_with_uid (_data_->_tmp1_, NULL, &_data_->_inner_error0_);
		e_source_set_display_name (_data_->_tmp3_, _data_->_tmp2_);
		_g_free0 (_data_->_tmp2_);
		_data_->signature_source = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->uid);
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->signature_source;
		e_source_get_extension (_data_->_tmp4_, E_SOURCE_EXTENSION_MAIL_SIGNATURE);
		_data_->_tmp5_ = _data_->self->priv->registry;
		_data_->_tmp6_ = _data_->signature_source;
		_data_->_state_ = 1;
		e_source_registry_commit_source (_data_->_tmp5_, _data_->_tmp6_, NULL, mail_backend_session_create_new_signature_ready, _data_);
		return FALSE;
		_state_1:
		e_source_registry_commit_source_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->signature_source);
			_g_free0 (_data_->uid);
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->signature_source;
		_data_->_tmp8_ = strlen ("");
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_state_ = 2;
		e_source_mail_signature_replace (_data_->_tmp7_, "", (gsize) _data_->_tmp9_, G_PRIORITY_DEFAULT, NULL, mail_backend_session_create_new_signature_ready, _data_);
		return FALSE;
		_state_2:
		e_source_mail_signature_replace_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->signature_source);
			_g_free0 (_data_->uid);
			goto __catch0_g_error;
		}
		_data_->_tmp10_ = _data_->self->priv->registry;
		_data_->_tmp11_ = _data_->uid;
		_data_->_tmp12_ = e_source_registry_ref_source (_data_->_tmp10_, _data_->_tmp11_);
		_data_->result = _data_->_tmp12_;
		_g_object_unref0 (_data_->signature_source);
		_g_free0 (_data_->uid);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->e;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_warning ("Session.vala:651: Failed to commit the new signature source: %s", _data_->_tmp14_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GList*
mail_backend_session_get_all_identity_sources (MailBackendSession* self)
{
	ESourceRegistry* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->registry;
	_tmp1_ = e_source_registry_list_enabled (_tmp0_, E_SOURCE_EXTENSION_MAIL_IDENTITY);
	result = _tmp1_;
	return result;
}

GList*
mail_backend_session_get_all_signature_sources (MailBackendSession* self)
{
	ESourceRegistry* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->registry;
	_tmp1_ = e_source_registry_list_enabled (_tmp0_, E_SOURCE_EXTENSION_MAIL_SIGNATURE);
	result = _tmp1_;
	return result;
}

static MailBackendSessionMessageInfo*
mail_backend_session_message_info_construct (GType object_type,
                                             CamelMessageFlags flags)
{
	MailBackendSessionMessageInfo * self = NULL;
	self = (MailBackendSessionMessageInfo*) g_object_new (object_type, "flags", flags, NULL);
	return self;
}

static MailBackendSessionMessageInfo*
mail_backend_session_message_info_new (CamelMessageFlags flags)
{
	return mail_backend_session_message_info_construct (MAIL_BACKEND_SESSION_TYPE_MESSAGE_INFO, flags);
}

static void
mail_backend_session_message_info_class_init (MailBackendSessionMessageInfoClass * klass,
                                              gpointer klass_data)
{
	mail_backend_session_message_info_parent_class = g_type_class_peek_parent (klass);
}

static void
mail_backend_session_message_info_instance_init (MailBackendSessionMessageInfo * self,
                                                 gpointer klass)
{
}

static GType
mail_backend_session_message_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailBackendSessionMessageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_backend_session_message_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailBackendSessionMessageInfo), 0, (GInstanceInitFunc) mail_backend_session_message_info_instance_init, NULL };
	GType mail_backend_session_message_info_type_id;
	mail_backend_session_message_info_type_id = g_type_register_static (camel_message_info_base_get_type (), "MailBackendSessionMessageInfo", &g_define_type_info, 0);
	return mail_backend_session_message_info_type_id;
}

static GType
mail_backend_session_message_info_get_type (void)
{
	static volatile gsize mail_backend_session_message_info_type_id__once = 0;
	if (g_once_init_enter (&mail_backend_session_message_info_type_id__once)) {
		GType mail_backend_session_message_info_type_id;
		mail_backend_session_message_info_type_id = mail_backend_session_message_info_get_type_once ();
		g_once_init_leave (&mail_backend_session_message_info_type_id__once, mail_backend_session_message_info_type_id);
	}
	return mail_backend_session_message_info_type_id__once;
}

static void
_mail_backend_session___lambda11_ (MailBackendSession* self,
                                   CamelService* service,
                                   CamelSessionAlertType type,
                                   const gchar* message)
{
	g_return_if_fail (service != NULL);
	g_return_if_fail (message != NULL);
	g_warning ("Session.vala:46: %s", message);
}

static void
__mail_backend_session___lambda11__camel_session_user_alert (CamelSession* _sender,
                                                             CamelService* service,
                                                             CamelSessionAlertType type,
                                                             const gchar* message,
                                                             gpointer self)
{
	_mail_backend_session___lambda11_ ((MailBackendSession*) self, service, type, message);
}

static void
_camel_session_set_online_g_network_monitor_network_changed (GNetworkMonitor* _sender,
                                                             gboolean network_available,
                                                             gpointer self)
{
	camel_session_set_online ((CamelSession*) self, network_available);
}

static GObject *
mail_backend_session_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailBackendSession * self;
	const gchar* _tmp0_;
	GeeLinkedList* _tmp1_;
	GNetworkMonitor* network_monitor = NULL;
	GNetworkMonitor* _tmp2_;
	GNetworkMonitor* _tmp3_;
	GNetworkMonitor* _tmp4_;
	parent_class = G_OBJECT_CLASS (mail_backend_session_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_BACKEND_TYPE_SESSION, MailBackendSession);
	_tmp0_ = e_get_user_data_dir ();
	camel_init (_tmp0_, FALSE);
	_tmp1_ = gee_linked_list_new (MAIL_BACKEND_TYPE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->accounts);
	self->priv->accounts = _tmp1_;
	g_signal_connect_object ((CamelSession*) self, "user-alert", (GCallback) __mail_backend_session___lambda11__camel_session_user_alert, self, 0);
	_tmp2_ = e_network_monitor_get_default ();
	network_monitor = _tmp2_;
	_tmp3_ = network_monitor;
	camel_session_set_network_monitor ((CamelSession*) self, _tmp3_);
	_tmp4_ = network_monitor;
	g_signal_connect_object (_tmp4_, "network-changed", (GCallback) _camel_session_set_online_g_network_monitor_network_changed, (CamelSession*) self, 0);
	camel_session_set_online ((CamelSession*) self, TRUE);
	return obj;
}

static void
mail_backend_session_class_init (MailBackendSessionClass * klass,
                                 gpointer klass_data)
{
	mail_backend_session_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailBackendSession_private_offset);
	((CamelSessionClass *) klass)->authenticate_sync = (gboolean (*) (CamelSession*, CamelService*, const gchar*, GCancellable*, GError**)) mail_backend_session_real_authenticate_sync;
	((CamelSessionClass *) klass)->get_oauth2_access_token_sync = (gboolean (*) (CamelSession*, CamelService*, gchar**, gint*, GCancellable*, GError**)) mail_backend_session_real_get_oauth2_access_token_sync;
	((CamelSessionClass *) klass)->add_service = (CamelService* (*) (CamelSession*, const gchar*, const gchar*, CamelProviderType, GError**)) mail_backend_session_real_add_service;
	((CamelSessionClass *) klass)->remove_service = (void (*) (CamelSession*, CamelService*)) mail_backend_session_real_remove_service;
	((CamelSessionClass *) klass)->get_filter_driver = (CamelFilterDriver* (*) (CamelSession*, const gchar*, CamelFolder*, GError**)) mail_backend_session_real_get_filter_driver;
	G_OBJECT_CLASS (klass)->constructor = mail_backend_session_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_backend_session_finalize;
	mail_backend_session_signals[MAIL_BACKEND_SESSION_ACCOUNT_ADDED_SIGNAL] = g_signal_new ("account-added", MAIL_BACKEND_TYPE_SESSION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, MAIL_BACKEND_TYPE_ACCOUNT);
	mail_backend_session_signals[MAIL_BACKEND_SESSION_ACCOUNT_REMOVED_SIGNAL] = g_signal_new ("account-removed", MAIL_BACKEND_TYPE_SESSION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, MAIL_BACKEND_TYPE_ACCOUNT);
	mail_backend_session_signals[MAIL_BACKEND_SESSION_SIGNATURE_CHANGED_SIGNAL] = g_signal_new ("signature-changed", MAIL_BACKEND_TYPE_SESSION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
mail_backend_session_instance_init (MailBackendSession * self,
                                    gpointer klass)
{
	self->priv = mail_backend_session_get_instance_private (self);
	self->priv->started = FALSE;
}

static void
mail_backend_session_finalize (GObject * obj)
{
	MailBackendSession * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_BACKEND_TYPE_SESSION, MailBackendSession);
	_g_object_unref0 (self->priv->registry);
	_g_object_unref0 (self->priv->accounts);
	G_OBJECT_CLASS (mail_backend_session_parent_class)->finalize (obj);
}

static GType
mail_backend_session_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailBackendSessionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_backend_session_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailBackendSession), 0, (GInstanceInitFunc) mail_backend_session_instance_init, NULL };
	GType mail_backend_session_type_id;
	mail_backend_session_type_id = g_type_register_static (camel_session_get_type (), "MailBackendSession", &g_define_type_info, 0);
	MailBackendSession_private_offset = g_type_add_instance_private (mail_backend_session_type_id, sizeof (MailBackendSessionPrivate));
	return mail_backend_session_type_id;
}

GType
mail_backend_session_get_type (void)
{
	static volatile gsize mail_backend_session_type_id__once = 0;
	if (g_once_init_enter (&mail_backend_session_type_id__once)) {
		GType mail_backend_session_type_id;
		mail_backend_session_type_id = mail_backend_session_get_type_once ();
		g_once_init_leave (&mail_backend_session_type_id__once, mail_backend_session_type_id);
	}
	return mail_backend_session_type_id__once;
}

