/* PageChecker.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PageChecker.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2017-2025 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "slingshot.h"
#include <handy.h>
#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_WIDGETS_PAGE_CHECKER_0_PROPERTY,
	SLINGSHOT_WIDGETS_PAGE_CHECKER_CAROUSEL_PROPERTY,
	SLINGSHOT_WIDGETS_PAGE_CHECKER_INDEX_PROPERTY,
	SLINGSHOT_WIDGETS_PAGE_CHECKER_NUM_PROPERTIES
};
static GParamSpec* slingshot_widgets_page_checker_properties[SLINGSHOT_WIDGETS_PAGE_CHECKER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SlingshotWidgetsPageCheckerPrivate {
	HdyCarousel* _carousel;
	gint _index;
};

static gint SlingshotWidgetsPageChecker_private_offset;
static gpointer slingshot_widgets_page_checker_parent_class = NULL;

static void slingshot_widgets_page_checker_update_opacity (SlingshotWidgetsPageChecker* self);
static GObject * slingshot_widgets_page_checker_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static void _slingshot_widgets_page_checker___lambda46_ (SlingshotWidgetsPageChecker* self);
static void __slingshot_widgets_page_checker___lambda46__g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void slingshot_widgets_page_checker_finalize (GObject * obj);
static GType slingshot_widgets_page_checker_get_type_once (void);
static void _vala_slingshot_widgets_page_checker_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_slingshot_widgets_page_checker_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);

static inline gpointer
slingshot_widgets_page_checker_get_instance_private (SlingshotWidgetsPageChecker* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotWidgetsPageChecker_private_offset);
}

SlingshotWidgetsPageChecker*
slingshot_widgets_page_checker_construct (GType object_type,
                                          HdyCarousel* carousel,
                                          gint index)
{
	SlingshotWidgetsPageChecker * self = NULL;
	g_return_val_if_fail (carousel != NULL, NULL);
	self = (SlingshotWidgetsPageChecker*) g_object_new (object_type, "carousel", carousel, "index", index, NULL);
	return self;
}

SlingshotWidgetsPageChecker*
slingshot_widgets_page_checker_new (HdyCarousel* carousel,
                                    gint index)
{
	return slingshot_widgets_page_checker_construct (SLINGSHOT_WIDGETS_TYPE_PAGE_CHECKER, carousel, index);
}

static void
slingshot_widgets_page_checker_update_opacity (SlingshotWidgetsPageChecker* self)
{
	gdouble progress = 0.0;
	HdyCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_carousel;
	_tmp1_ = hdy_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_index;
	progress = MAX (1 - fabs (_tmp2_ - _tmp3_), (gdouble) 0);
	gtk_widget_set_opacity ((GtkWidget*) self, SLINGSHOT_WIDGETS_PAGE_CHECKER_MIN_OPACITY + ((1 - SLINGSHOT_WIDGETS_PAGE_CHECKER_MIN_OPACITY) * progress));
}

HdyCarousel*
slingshot_widgets_page_checker_get_carousel (SlingshotWidgetsPageChecker* self)
{
	HdyCarousel* result;
	HdyCarousel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_carousel;
	result = _tmp0_;
	return result;
}

static void
slingshot_widgets_page_checker_set_carousel (SlingshotWidgetsPageChecker* self,
                                             HdyCarousel* value)
{
	HdyCarousel* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_page_checker_get_carousel (self);
	if (old_value != value) {
		self->priv->_carousel = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_page_checker_properties[SLINGSHOT_WIDGETS_PAGE_CHECKER_CAROUSEL_PROPERTY]);
	}
}

gint
slingshot_widgets_page_checker_get_index (SlingshotWidgetsPageChecker* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_index;
	return result;
}

static void
slingshot_widgets_page_checker_set_index (SlingshotWidgetsPageChecker* self,
                                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_widgets_page_checker_get_index (self);
	if (old_value != value) {
		self->priv->_index = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_widgets_page_checker_properties[SLINGSHOT_WIDGETS_PAGE_CHECKER_INDEX_PROPERTY]);
	}
}

static void
_slingshot_widgets_page_checker___lambda46_ (SlingshotWidgetsPageChecker* self)
{
	slingshot_widgets_page_checker_update_opacity (self);
}

static void
__slingshot_widgets_page_checker___lambda46__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	_slingshot_widgets_page_checker___lambda46_ ((SlingshotWidgetsPageChecker*) self);
}

static GObject *
slingshot_widgets_page_checker_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotWidgetsPageChecker * self;
	GtkStyleContext* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	HdyCarousel* _tmp3_;
	parent_class = G_OBJECT_CLASS (slingshot_widgets_page_checker_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_PAGE_CHECKER, SlingshotWidgetsPageChecker);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "switcher");
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("pager-checked-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp2_, NULL);
	_g_object_unref0 (_tmp2_);
	slingshot_widgets_page_checker_update_opacity (self);
	_tmp3_ = self->priv->_carousel;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::position", (GCallback) __slingshot_widgets_page_checker___lambda46__g_object_notify, self, 0);
	return obj;
}

static void
slingshot_widgets_page_checker_base_init (SlingshotWidgetsPageCheckerClass * klass)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GdkScreen* _tmp2_;
	GtkCssProvider* _tmp3_;
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	_tmp1_ = provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/io/elementary/desktop/wingpanel/applications-menu/PageChecker.css");
	_tmp2_ = gdk_screen_get_default ();
	_tmp3_ = provider;
	gtk_style_context_add_provider_for_screen (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (provider);
}

static void
slingshot_widgets_page_checker_class_init (SlingshotWidgetsPageCheckerClass * klass,
                                           gpointer klass_data)
{
	slingshot_widgets_page_checker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotWidgetsPageChecker_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_widgets_page_checker_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_widgets_page_checker_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_widgets_page_checker_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_widgets_page_checker_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_PAGE_CHECKER_CAROUSEL_PROPERTY, slingshot_widgets_page_checker_properties[SLINGSHOT_WIDGETS_PAGE_CHECKER_CAROUSEL_PROPERTY] = g_param_spec_object ("carousel", "carousel", "carousel", hdy_carousel_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_WIDGETS_PAGE_CHECKER_INDEX_PROPERTY, slingshot_widgets_page_checker_properties[SLINGSHOT_WIDGETS_PAGE_CHECKER_INDEX_PROPERTY] = g_param_spec_int ("index", "index", "index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
slingshot_widgets_page_checker_instance_init (SlingshotWidgetsPageChecker * self,
                                              gpointer klass)
{
	self->priv = slingshot_widgets_page_checker_get_instance_private (self);
}

static void
slingshot_widgets_page_checker_finalize (GObject * obj)
{
	SlingshotWidgetsPageChecker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_PAGE_CHECKER, SlingshotWidgetsPageChecker);
	G_OBJECT_CLASS (slingshot_widgets_page_checker_parent_class)->finalize (obj);
}

static GType
slingshot_widgets_page_checker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotWidgetsPageCheckerClass), (GBaseInitFunc) slingshot_widgets_page_checker_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_widgets_page_checker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotWidgetsPageChecker), 0, (GInstanceInitFunc) slingshot_widgets_page_checker_instance_init, NULL };
	GType slingshot_widgets_page_checker_type_id;
	slingshot_widgets_page_checker_type_id = g_type_register_static (gtk_button_get_type (), "SlingshotWidgetsPageChecker", &g_define_type_info, 0);
	SlingshotWidgetsPageChecker_private_offset = g_type_add_instance_private (slingshot_widgets_page_checker_type_id, sizeof (SlingshotWidgetsPageCheckerPrivate));
	return slingshot_widgets_page_checker_type_id;
}

GType
slingshot_widgets_page_checker_get_type (void)
{
	static volatile gsize slingshot_widgets_page_checker_type_id__once = 0;
	if (g_once_init_enter (&slingshot_widgets_page_checker_type_id__once)) {
		GType slingshot_widgets_page_checker_type_id;
		slingshot_widgets_page_checker_type_id = slingshot_widgets_page_checker_get_type_once ();
		g_once_init_leave (&slingshot_widgets_page_checker_type_id__once, slingshot_widgets_page_checker_type_id);
	}
	return slingshot_widgets_page_checker_type_id__once;
}

static void
_vala_slingshot_widgets_page_checker_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	SlingshotWidgetsPageChecker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_TYPE_PAGE_CHECKER, SlingshotWidgetsPageChecker);
	switch (property_id) {
		case SLINGSHOT_WIDGETS_PAGE_CHECKER_CAROUSEL_PROPERTY:
		g_value_set_object (value, slingshot_widgets_page_checker_get_carousel (self));
		break;
		case SLINGSHOT_WIDGETS_PAGE_CHECKER_INDEX_PROPERTY:
		g_value_set_int (value, slingshot_widgets_page_checker_get_index (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_widgets_page_checker_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	SlingshotWidgetsPageChecker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_TYPE_PAGE_CHECKER, SlingshotWidgetsPageChecker);
	switch (property_id) {
		case SLINGSHOT_WIDGETS_PAGE_CHECKER_CAROUSEL_PROPERTY:
		slingshot_widgets_page_checker_set_carousel (self, g_value_get_object (value));
		break;
		case SLINGSHOT_WIDGETS_PAGE_CHECKER_INDEX_PROPERTY:
		slingshot_widgets_page_checker_set_index (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

