/* ToolbarButton.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ToolbarButton.vala, do not modify */

/*
* Copyright (c) 2016 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ENOTES_TYPE_TOOLBAR_BUTTON (enotes_toolbar_button_get_type ())
#define ENOTES_TOOLBAR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_TOOLBAR_BUTTON, ENotesToolbarButton))
#define ENOTES_TOOLBAR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_TOOLBAR_BUTTON, ENotesToolbarButtonClass))
#define ENOTES_IS_TOOLBAR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_TOOLBAR_BUTTON))
#define ENOTES_IS_TOOLBAR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_TOOLBAR_BUTTON))
#define ENOTES_TOOLBAR_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_TOOLBAR_BUTTON, ENotesToolbarButtonClass))

typedef struct _ENotesToolbarButton ENotesToolbarButton;
typedef struct _ENotesToolbarButtonClass ENotesToolbarButtonClass;
typedef struct _ENotesToolbarButtonPrivate ENotesToolbarButtonPrivate;

#define ENOTES_TYPE_PLUGIN (enotes_plugin_get_type ())
#define ENOTES_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PLUGIN, ENotesPlugin))
#define ENOTES_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PLUGIN, ENotesPluginClass))
#define ENOTES_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PLUGIN))
#define ENOTES_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PLUGIN))
#define ENOTES_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PLUGIN, ENotesPluginClass))

typedef struct _ENotesPlugin ENotesPlugin;
typedef struct _ENotesPluginClass ENotesPluginClass;
enum  {
	ENOTES_TOOLBAR_BUTTON_0_PROPERTY,
	ENOTES_TOOLBAR_BUTTON_NUM_PROPERTIES
};
static GParamSpec* enotes_toolbar_button_properties[ENOTES_TOOLBAR_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define ENOTES_TYPE_IMAGE_TABLE (enotes_image_table_get_type ())
#define ENOTES_IMAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTable))
#define ENOTES_IMAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTableClass))
#define ENOTES_IS_IMAGE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_IMAGE_TABLE))
#define ENOTES_IS_IMAGE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_IMAGE_TABLE))
#define ENOTES_IMAGE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_IMAGE_TABLE, ENotesImageTableClass))

typedef struct _ENotesImageTable ENotesImageTable;
typedef struct _ENotesImageTableClass ENotesImageTableClass;

#define ENOTES_TYPE_APPLICATION (enotes_application_get_type ())
#define ENOTES_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_APPLICATION, ENotesApplication))
#define ENOTES_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))
#define ENOTES_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_APPLICATION))
#define ENOTES_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_APPLICATION))
#define ENOTES_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_APPLICATION, ENotesApplicationClass))

typedef struct _ENotesApplication ENotesApplication;
typedef struct _ENotesApplicationClass ENotesApplicationClass;
typedef struct _ENotesApplicationPrivate ENotesApplicationPrivate;

#define ENOTES_APPLICATION_TYPE_STATE (enotes_application_state_get_type ())
#define ENOTES_APPLICATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationState))
#define ENOTES_APPLICATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))
#define ENOTES_APPLICATION_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_APPLICATION_TYPE_STATE))
#define ENOTES_APPLICATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_APPLICATION_TYPE_STATE, ENotesApplicationStateClass))

typedef struct _ENotesApplicationState ENotesApplicationState;
typedef struct _ENotesApplicationStateClass ENotesApplicationStateClass;

#define ENOTES_TYPE_PAGE (enotes_page_get_type ())
#define ENOTES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE, ENotesPage))
#define ENOTES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE, ENotesPageClass))
#define ENOTES_IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE))
#define ENOTES_IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE))
#define ENOTES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE, ENotesPageClass))

typedef struct _ENotesPage ENotesPage;
typedef struct _ENotesPageClass ENotesPageClass;
typedef struct _ENotesPagePrivate ENotesPagePrivate;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

struct _ENotesToolbarButton {
	GtkButton parent_instance;
	ENotesToolbarButtonPrivate * priv;
};

struct _ENotesToolbarButtonClass {
	GtkButtonClass parent_class;
};

struct _ENotesToolbarButtonPrivate {
	GtkSourceBuffer* code_buffer;
	ENotesPlugin* plugin;
	gint type;
	gchar* first_half;
	gchar* second_half;
};

struct _Block5Data {
	int _ref_count_;
	ENotesToolbarButton* self;
	GtkSourceBuffer* code_buffer;
};

struct _ENotesApplication {
	GraniteApplication parent_instance;
	ENotesApplicationPrivate * priv;
	gboolean running;
	ENotesApplicationState* state;
};

struct _ENotesApplicationClass {
	GraniteApplicationClass parent_class;
};

struct _ENotesPage {
	GObject parent_instance;
	ENotesPagePrivate * priv;
	gint64 id;
	gint64 notebook_id;
	gchar* name;
	gchar* data;
	gchar* subtitle;
	gchar* html_cache;
	gint64 creation_date;
	gint64 modification_date;
	gboolean new_page;
	gboolean cache_changed;
	gchar* full_path;
};

struct _ENotesPageClass {
	GObjectClass parent_class;
};

static gint ENotesToolbarButton_private_offset;
static gpointer enotes_toolbar_button_parent_class = NULL;
VALA_EXTERN ENotesApplication* enotes_app;

VALA_EXTERN GType enotes_toolbar_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesToolbarButton, g_object_unref)
VALA_EXTERN GType enotes_plugin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPlugin, g_object_unref)
VALA_EXTERN ENotesToolbarButton* enotes_toolbar_button_new (const gchar* icon,
                                                const gchar* first_half,
                                                const gchar* second_half,
                                                const gchar* description,
                                                GtkSourceBuffer* code_buffer);
VALA_EXTERN ENotesToolbarButton* enotes_toolbar_button_construct (GType object_type,
                                                      const gchar* icon,
                                                      const gchar* first_half,
                                                      const gchar* second_half,
                                                      const gchar* description,
                                                      GtkSourceBuffer* code_buffer);
static void enotes_toolbar_button_connect_signal (ENotesToolbarButton* self);
VALA_EXTERN ENotesToolbarButton* enotes_toolbar_button_new_is_image_button (const gchar* icon,
                                                                const gchar* first_half,
                                                                const gchar* second_half,
                                                                const gchar* description,
                                                                GtkSourceBuffer* code_buffer);
VALA_EXTERN ENotesToolbarButton* enotes_toolbar_button_construct_is_image_button (GType object_type,
                                                                      const gchar* icon,
                                                                      const gchar* first_half,
                                                                      const gchar* second_half,
                                                                      const gchar* description,
                                                                      GtkSourceBuffer* code_buffer);
VALA_EXTERN ENotesToolbarButton* enotes_toolbar_button_new_from_plugin (ENotesPlugin* plugin,
                                                            GtkWidget* widget,
                                                            GtkSourceBuffer* code_buffer);
VALA_EXTERN ENotesToolbarButton* enotes_toolbar_button_construct_from_plugin (GType object_type,
                                                                  ENotesPlugin* plugin,
                                                                  GtkWidget* widget,
                                                                  GtkSourceBuffer* code_buffer);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN gchar* enotes_plugin_get_button_desctiption (ENotesPlugin* self);
static void __lambda39_ (Block5Data* _data5_,
                  const gchar* t);
static void ___lambda39__enotes_plugin_string_cooked (ENotesPlugin* _sender,
                                               const gchar* text,
                                               gpointer self);
static void __lambda10_ (ENotesToolbarButton* self);
VALA_EXTERN gchar* enotes_plugin_request_string (ENotesPlugin* self,
                                     const gchar* selection);
VALA_EXTERN gchar* word_wrapper_wrap_string (const gchar* original_text,
                                 const gchar* first_half,
                                 const gchar* second_half);
static void enotes_toolbar_button_change_text (ENotesToolbarButton* self,
                                        GtkTextIter* start,
                                        GtkTextIter* end,
                                        const gchar* text);
VALA_EXTERN GFile* enotes_file_manager_get_file_from_user (const gchar* filetype,
                                               GtkFileChooserAction* chooser_action);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType enotes_image_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesImageTable, database_table_unref)
VALA_EXTERN ENotesImageTable* enotes_image_table_get_instance (void);
VALA_EXTERN gint64 enotes_image_table_save (ENotesImageTable* self,
                                gint64 page_id,
                                GFile* file);
VALA_EXTERN GType enotes_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplication, g_object_unref)
VALA_EXTERN GType enotes_application_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesApplicationState, g_object_unref)
VALA_EXTERN GType enotes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPage, g_object_unref)
VALA_EXTERN ENotesPage* enotes_application_state_get_opened_page (ENotesApplicationState* self);
static gboolean enotes_toolbar_button_is_cursor_inside_word (ENotesToolbarButton* self,
                                                      GtkTextIter* cursor_position,
                                                      const gchar* first_half,
                                                      const gchar* second_half);
VALA_EXTERN gchar* word_wrapper_identify_word (GtkTextIter* start,
                                   GtkTextIter* end,
                                   const gchar* first_half,
                                   const gchar* second_half);
static void ___lambda10__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static GObject * enotes_toolbar_button_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void enotes_toolbar_button_finalize (GObject * obj);
static GType enotes_toolbar_button_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
enotes_toolbar_button_get_instance_private (ENotesToolbarButton* self)
{
	return G_STRUCT_MEMBER_P (self, ENotesToolbarButton_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 41 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	return self ? g_object_ref (self) : NULL;
#line 303 "ToolbarButton.c"
}

ENotesToolbarButton*
enotes_toolbar_button_construct (GType object_type,
                                 const gchar* icon,
                                 const gchar* first_half,
                                 const gchar* second_half,
                                 const gchar* description,
                                 GtkSourceBuffer* code_buffer)
{
	ENotesToolbarButton * self = NULL;
	GtkImage* image = NULL;
	GtkImage* _tmp0_;
	GtkSourceBuffer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 37 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (icon != NULL, NULL);
#line 37 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (first_half != NULL, NULL);
#line 37 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (second_half != NULL, NULL);
#line 37 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (description != NULL, NULL);
#line 37 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (code_buffer != NULL, NULL);
#line 37 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self = (ENotesToolbarButton*) g_object_new (object_type, NULL);
#line 38 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name (icon, (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
#line 38 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_object_ref_sink (_tmp0_);
#line 38 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	image = _tmp0_;
#line 39 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) image);
#line 41 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp1_ = _g_object_ref0 (code_buffer);
#line 41 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_g_object_unref0 (self->priv->code_buffer);
#line 41 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self->priv->code_buffer = _tmp1_;
#line 42 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp2_ = g_strdup (first_half);
#line 42 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_g_free0 (self->priv->first_half);
#line 42 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self->priv->first_half = _tmp2_;
#line 43 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp3_ = g_strdup (second_half);
#line 43 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_g_free0 (self->priv->second_half);
#line 43 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self->priv->second_half = _tmp3_;
#line 45 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) self, description);
#line 47 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	enotes_toolbar_button_connect_signal (self);
#line 37 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_g_object_unref0 (image);
#line 37 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	return self;
#line 366 "ToolbarButton.c"
}

ENotesToolbarButton*
enotes_toolbar_button_new (const gchar* icon,
                           const gchar* first_half,
                           const gchar* second_half,
                           const gchar* description,
                           GtkSourceBuffer* code_buffer)
{
#line 37 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	return enotes_toolbar_button_construct (ENOTES_TYPE_TOOLBAR_BUTTON, icon, first_half, second_half, description, code_buffer);
#line 378 "ToolbarButton.c"
}

ENotesToolbarButton*
enotes_toolbar_button_construct_is_image_button (GType object_type,
                                                 const gchar* icon,
                                                 const gchar* first_half,
                                                 const gchar* second_half,
                                                 const gchar* description,
                                                 GtkSourceBuffer* code_buffer)
{
	ENotesToolbarButton * self = NULL;
#line 50 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (icon != NULL, NULL);
#line 50 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (first_half != NULL, NULL);
#line 50 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (second_half != NULL, NULL);
#line 50 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (description != NULL, NULL);
#line 50 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (code_buffer != NULL, NULL);
#line 51 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self = (ENotesToolbarButton*) enotes_toolbar_button_construct (object_type, icon, first_half, second_half, description, code_buffer);
#line 52 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self->priv->type = 1;
#line 50 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	return self;
#line 406 "ToolbarButton.c"
}

ENotesToolbarButton*
enotes_toolbar_button_new_is_image_button (const gchar* icon,
                                           const gchar* first_half,
                                           const gchar* second_half,
                                           const gchar* description,
                                           GtkSourceBuffer* code_buffer)
{
#line 50 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	return enotes_toolbar_button_construct_is_image_button (ENOTES_TYPE_TOOLBAR_BUTTON, icon, first_half, second_half, description, code_buffer);
#line 418 "ToolbarButton.c"
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	return _data5_;
#line 428 "ToolbarButton.c"
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 438 "ToolbarButton.c"
		ENotesToolbarButton* self;
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		self = _data5_->self;
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_g_object_unref0 (_data5_->code_buffer);
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_g_object_unref0 (self);
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		g_slice_free (Block5Data, _data5_);
#line 448 "ToolbarButton.c"
	}
}

static void
__lambda39_ (Block5Data* _data5_,
             const gchar* t)
{
	ENotesToolbarButton* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 64 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self = _data5_->self;
#line 64 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_if_fail (t != NULL);
#line 65 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp0_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _data5_->code_buffer);
#line 65 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp1_ = _tmp0_;
#line 65 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	if (_tmp1_) {
#line 469 "ToolbarButton.c"
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		GtkTextIter _tmp2_ = {0};
		GtkTextIter _tmp3_ = {0};
#line 67 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _data5_->code_buffer, &_tmp2_, &_tmp3_);
#line 67 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		start = _tmp2_;
#line 67 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		end = _tmp3_;
#line 68 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		gtk_text_buffer_delete ((GtkTextBuffer*) _data5_->code_buffer, &start, &end);
#line 69 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) _data5_->code_buffer, t, -1);
#line 484 "ToolbarButton.c"
	} else {
#line 71 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) _data5_->code_buffer, t, -1);
#line 488 "ToolbarButton.c"
	}
}

static void
___lambda39__enotes_plugin_string_cooked (ENotesPlugin* _sender,
                                          const gchar* text,
                                          gpointer self)
{
#line 64 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	__lambda39_ (self, text);
#line 499 "ToolbarButton.c"
}

ENotesToolbarButton*
enotes_toolbar_button_construct_from_plugin (GType object_type,
                                             ENotesPlugin* plugin,
                                             GtkWidget* widget,
                                             GtkSourceBuffer* code_buffer)
{
	ENotesToolbarButton * self = NULL;
	Block5Data* _data5_;
	GtkSourceBuffer* _tmp0_;
	ENotesPlugin* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (widget != NULL, NULL);
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (code_buffer != NULL, NULL);
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_data5_->_ref_count_ = 1;
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp0_ = _g_object_ref0 (code_buffer);
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_g_object_unref0 (_data5_->code_buffer);
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_data5_->code_buffer = _tmp0_;
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self = (ENotesToolbarButton*) g_object_new (object_type, NULL);
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_data5_->self = g_object_ref (self);
#line 56 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp1_ = _g_object_ref0 (plugin);
#line 56 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_g_object_unref0 (self->priv->plugin);
#line 56 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self->priv->plugin = _tmp1_;
#line 57 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp2_ = _g_object_ref0 (_data5_->code_buffer);
#line 57 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_g_object_unref0 (self->priv->code_buffer);
#line 57 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self->priv->code_buffer = _tmp2_;
#line 58 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	gtk_container_add ((GtkContainer*) self, widget);
#line 59 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp3_ = enotes_plugin_get_button_desctiption (plugin);
#line 59 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp4_ = _tmp3_;
#line 59 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp4_);
#line 59 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_g_free0 (_tmp4_);
#line 61 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self->priv->type = 2;
#line 63 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	enotes_toolbar_button_connect_signal (self);
#line 64 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_signal_connect_data (plugin, "string-cooked", (GCallback) ___lambda39__enotes_plugin_string_cooked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	block5_data_unref (_data5_);
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_data5_ = NULL;
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	return self;
#line 569 "ToolbarButton.c"
}

ENotesToolbarButton*
enotes_toolbar_button_new_from_plugin (ENotesPlugin* plugin,
                                       GtkWidget* widget,
                                       GtkSourceBuffer* code_buffer)
{
#line 55 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	return enotes_toolbar_button_construct_from_plugin (ENOTES_TYPE_TOOLBAR_BUTTON, plugin, widget, code_buffer);
#line 579 "ToolbarButton.c"
}

static void
__lambda10_ (ENotesToolbarButton* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkSourceBuffer* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	GtkSourceBuffer* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
#line 79 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp0_ = self->priv->code_buffer;
#line 79 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp0_, &_tmp1_, &_tmp2_);
#line 79 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	start = _tmp1_;
#line 79 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	end = _tmp2_;
#line 81 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp3_ = self->priv->code_buffer;
#line 81 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp4_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp3_);
#line 81 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp5_ = _tmp4_;
#line 81 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	if (_tmp5_) {
#line 609 "ToolbarButton.c"
		gchar* text = NULL;
		GtkTextIter _tmp6_;
		gchar* _tmp7_;
#line 82 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_tmp6_ = end;
#line 82 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_tmp7_ = gtk_text_iter_get_text (&start, &_tmp6_);
#line 82 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		text = _tmp7_;
#line 83 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		if (self->priv->type == 2) {
#line 621 "ToolbarButton.c"
			ENotesPlugin* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
#line 84 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_tmp8_ = self->priv->plugin;
#line 84 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_tmp9_ = text;
#line 84 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_tmp10_ = enotes_plugin_request_string (_tmp8_, _tmp9_);
#line 84 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_tmp11_ = _tmp10_;
#line 84 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_g_free0 (_tmp11_);
#line 636 "ToolbarButton.c"
		} else {
			gchar* wrapped_text = NULL;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			GtkTextIter _tmp16_;
			GtkTextIter _tmp17_;
			const gchar* _tmp18_;
#line 86 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_tmp12_ = text;
#line 86 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_tmp13_ = self->priv->first_half;
#line 86 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_tmp14_ = self->priv->second_half;
#line 86 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_tmp15_ = word_wrapper_wrap_string (_tmp12_, _tmp13_, _tmp14_);
#line 86 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			wrapped_text = _tmp15_;
#line 87 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_tmp16_ = start;
#line 87 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_tmp17_ = end;
#line 87 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_tmp18_ = wrapped_text;
#line 87 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			enotes_toolbar_button_change_text (self, &_tmp16_, &_tmp17_, _tmp18_);
#line 83 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_g_free0 (wrapped_text);
#line 666 "ToolbarButton.c"
		}
#line 81 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_g_free0 (text);
#line 670 "ToolbarButton.c"
	} else {
#line 90 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		if (self->priv->type == 1) {
#line 674 "ToolbarButton.c"
			GFile* file = NULL;
			GtkFileChooserAction _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
#line 91 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_tmp19_ = GTK_FILE_CHOOSER_ACTION_OPEN;
#line 91 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_tmp20_ = enotes_file_manager_get_file_from_user ("image", &_tmp19_);
#line 91 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			file = _tmp20_;
#line 93 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_tmp21_ = file;
#line 93 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			if (_tmp21_ != NULL) {
#line 689 "ToolbarButton.c"
				gint64 image_id = 0LL;
				ENotesImageTable* _tmp22_;
				ENotesImageTable* _tmp23_;
				ENotesApplication* _tmp24_;
				ENotesApplicationState* _tmp25_;
				ENotesPage* _tmp26_;
				ENotesPage* _tmp27_;
				GFile* _tmp28_;
				gint64 _tmp29_;
				GtkSourceBuffer* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				GtkSourceBuffer* _tmp33_;
				GtkTextIter _tmp34_;
#line 94 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp22_ = enotes_image_table_get_instance ();
#line 94 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp23_ = _tmp22_;
#line 94 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp24_ = enotes_app;
#line 94 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp25_ = _tmp24_->state;
#line 94 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp26_ = enotes_application_state_get_opened_page (_tmp25_);
#line 94 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp27_ = _tmp26_;
#line 94 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp28_ = file;
#line 94 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp29_ = enotes_image_table_save (_tmp23_, _tmp27_->id, _tmp28_);
#line 94 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_database_table_unref0 (_tmp23_);
#line 94 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				image_id = _tmp29_;
#line 96 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp30_ = self->priv->code_buffer;
#line 96 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp31_ = g_strdup_printf ("<image %lld>", image_id);
#line 96 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp32_ = _tmp31_;
#line 96 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				gtk_text_buffer_insert ((GtkTextBuffer*) _tmp30_, &end, _tmp32_, -1);
#line 96 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_g_free0 (_tmp32_);
#line 97 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp33_ = self->priv->code_buffer;
#line 97 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp34_ = end;
#line 97 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				gtk_text_buffer_place_cursor ((GtkTextBuffer*) _tmp33_, &_tmp34_);
#line 740 "ToolbarButton.c"
			}
#line 90 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			_g_object_unref0 (file);
#line 744 "ToolbarButton.c"
		} else {
#line 99 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
			if (self->priv->type == 2) {
#line 748 "ToolbarButton.c"
				ENotesPlugin* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
#line 100 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp35_ = self->priv->plugin;
#line 100 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp36_ = enotes_plugin_request_string (_tmp35_, "");
#line 100 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp37_ = _tmp36_;
#line 100 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_g_free0 (_tmp37_);
#line 760 "ToolbarButton.c"
			} else {
				GtkTextIter cursor_position = {0};
				GtkSourceBuffer* _tmp38_;
				GtkSourceBuffer* _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				GtkTextIter _tmp42_ = {0};
				GtkTextIter _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
#line 103 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp38_ = self->priv->code_buffer;
#line 103 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp39_ = self->priv->code_buffer;
#line 103 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				g_object_get ((GtkTextBuffer*) _tmp39_, "cursor-position", &_tmp40_, NULL);
#line 103 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp41_ = _tmp40_;
#line 103 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) _tmp38_, &_tmp42_, _tmp41_);
#line 103 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				cursor_position = _tmp42_;
#line 105 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp43_ = cursor_position;
#line 105 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp44_ = self->priv->first_half;
#line 105 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				_tmp45_ = self->priv->second_half;
#line 105 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
				if (enotes_toolbar_button_is_cursor_inside_word (self, &_tmp43_, _tmp44_, _tmp45_)) {
#line 791 "ToolbarButton.c"
					GtkTextIter _tmp46_;
					GtkTextIter _tmp47_;
					gchar* word = NULL;
					const gchar* _tmp48_;
					const gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* wrapped_text = NULL;
					const gchar* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp53_;
					gchar* _tmp54_;
					GtkTextIter _tmp55_;
					GtkTextIter _tmp56_;
					const gchar* _tmp57_;
#line 107 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp46_ = cursor_position;
#line 107 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					end = _tmp46_;
#line 107 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp47_ = end;
#line 107 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					start = _tmp47_;
#line 108 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp48_ = self->priv->first_half;
#line 108 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp49_ = self->priv->second_half;
#line 108 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp50_ = word_wrapper_identify_word (&start, &end, _tmp48_, _tmp49_);
#line 108 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					word = _tmp50_;
#line 109 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp51_ = word;
#line 109 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp52_ = self->priv->first_half;
#line 109 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp53_ = self->priv->second_half;
#line 109 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp54_ = word_wrapper_wrap_string (_tmp51_, _tmp52_, _tmp53_);
#line 109 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					wrapped_text = _tmp54_;
#line 110 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp55_ = start;
#line 110 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp56_ = end;
#line 110 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp57_ = wrapped_text;
#line 110 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					enotes_toolbar_button_change_text (self, &_tmp55_, &_tmp56_, _tmp57_);
#line 105 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_g_free0 (wrapped_text);
#line 105 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_g_free0 (word);
#line 844 "ToolbarButton.c"
				} else {
					GtkSourceBuffer* _tmp58_;
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					gchar* _tmp61_;
					gchar* _tmp62_;
					GtkSourceBuffer* _tmp63_;
					GtkSourceBuffer* _tmp64_;
					gint _tmp65_;
					gint _tmp66_;
					GtkTextIter _tmp67_ = {0};
					const gchar* _tmp68_;
					gint _tmp69_;
					gint _tmp70_;
					GtkSourceBuffer* _tmp71_;
					GtkTextIter _tmp72_;
#line 113 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp58_ = self->priv->code_buffer;
#line 113 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp59_ = self->priv->first_half;
#line 113 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp60_ = self->priv->second_half;
#line 113 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp61_ = g_strconcat (_tmp59_, _tmp60_, NULL);
#line 113 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp62_ = _tmp61_;
#line 113 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) _tmp58_, _tmp62_, -1);
#line 113 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_g_free0 (_tmp62_);
#line 114 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp63_ = self->priv->code_buffer;
#line 114 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp64_ = self->priv->code_buffer;
#line 114 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					g_object_get ((GtkTextBuffer*) _tmp64_, "cursor-position", &_tmp65_, NULL);
#line 114 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp66_ = _tmp65_;
#line 114 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) _tmp63_, &_tmp67_, _tmp66_);
#line 114 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					cursor_position = _tmp67_;
#line 115 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp68_ = self->priv->second_half;
#line 115 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp69_ = strlen (_tmp68_);
#line 115 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp70_ = _tmp69_;
#line 115 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					gtk_text_iter_backward_chars (&cursor_position, _tmp70_);
#line 116 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp71_ = self->priv->code_buffer;
#line 116 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					_tmp72_ = cursor_position;
#line 116 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
					gtk_text_buffer_place_cursor ((GtkTextBuffer*) _tmp71_, &_tmp72_);
#line 901 "ToolbarButton.c"
				}
			}
		}
	}
}

static void
___lambda10__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 77 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	__lambda10_ ((ENotesToolbarButton*) self);
#line 914 "ToolbarButton.c"
}

static void
enotes_toolbar_button_connect_signal (ENotesToolbarButton* self)
{
#line 76 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_if_fail (self != NULL);
#line 77 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_signal_connect_object ((GtkButton*) self, "clicked", (GCallback) ___lambda10__gtk_button_clicked, self, 0);
#line 924 "ToolbarButton.c"
}

/**
     * Detects if cursor is inside a word
     */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 946 "ToolbarButton.c"
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1122 "glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 1122 "glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 1123 "glib-2.0.vapi"
	g_unichar_to_utf8 (self, str);
#line 1124 "glib-2.0.vapi"
	result = str;
#line 1124 "glib-2.0.vapi"
	return result;
#line 965 "ToolbarButton.c"
}

static gboolean
enotes_toolbar_button_is_cursor_inside_word (ENotesToolbarButton* self,
                                             GtkTextIter* cursor_position,
                                             const gchar* first_half,
                                             const gchar* second_half)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
#line 126 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 126 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (cursor_position != NULL, FALSE);
#line 126 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (first_half != NULL, FALSE);
#line 126 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_val_if_fail (second_half != NULL, FALSE);
#line 127 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	if (gtk_text_iter_inside_word (cursor_position)) {
#line 127 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_tmp2_ = TRUE;
#line 990 "ToolbarButton.c"
	} else {
#line 128 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_tmp2_ = g_unichar_isspace (gtk_text_iter_get_char (cursor_position));
#line 994 "ToolbarButton.c"
	}
#line 127 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	if (_tmp2_) {
#line 127 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_tmp1_ = TRUE;
#line 1000 "ToolbarButton.c"
	} else {
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 129 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_tmp3_ = g_unichar_to_string (gtk_text_iter_get_char (cursor_position));
#line 129 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_tmp4_ = _tmp3_;
#line 129 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_tmp1_ = string_contains (first_half, _tmp4_);
#line 129 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_g_free0 (_tmp4_);
#line 1012 "ToolbarButton.c"
	}
#line 127 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	if (_tmp1_) {
#line 127 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_tmp0_ = TRUE;
#line 1018 "ToolbarButton.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 130 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_tmp5_ = g_unichar_to_string (gtk_text_iter_get_char (cursor_position));
#line 130 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_tmp6_ = _tmp5_;
#line 130 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_tmp0_ = string_contains (second_half, _tmp6_);
#line 130 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
		_g_free0 (_tmp6_);
#line 1030 "ToolbarButton.c"
	}
#line 127 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	result = _tmp0_;
#line 127 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	return result;
#line 1036 "ToolbarButton.c"
}

/**
     * Replaces the content from  iter start to iter end with the informed text
     */
static void
enotes_toolbar_button_change_text (ENotesToolbarButton* self,
                                   GtkTextIter* start,
                                   GtkTextIter* end,
                                   const gchar* text)
{
	GtkSourceBuffer* _tmp0_;
	GtkSourceBuffer* _tmp1_;
#line 136 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_if_fail (self != NULL);
#line 136 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_if_fail (start != NULL);
#line 136 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_if_fail (end != NULL);
#line 136 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_return_if_fail (text != NULL);
#line 137 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp0_ = self->priv->code_buffer;
#line 137 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	gtk_text_buffer_delete ((GtkTextBuffer*) _tmp0_, start, end);
#line 138 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp1_ = self->priv->code_buffer;
#line 138 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) _tmp1_, text, -1);
#line 1066 "ToolbarButton.c"
}

static GObject *
enotes_toolbar_button_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ENotesToolbarButton * self;
	GtkStyleContext* _tmp0_;
#line 32 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	parent_class = G_OBJECT_CLASS (enotes_toolbar_button_parent_class);
#line 32 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 32 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_TOOLBAR_BUTTON, ENotesToolbarButton);
#line 33 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
#line 34 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 34 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	gtk_style_context_add_class (_tmp0_, "flat");
#line 32 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	return obj;
#line 1092 "ToolbarButton.c"
}

static void
enotes_toolbar_button_class_init (ENotesToolbarButtonClass * klass,
                                  gpointer klass_data)
{
#line 23 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	enotes_toolbar_button_parent_class = g_type_class_peek_parent (klass);
#line 23 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	g_type_class_adjust_private_offset (klass, &ENotesToolbarButton_private_offset);
#line 23 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	G_OBJECT_CLASS (klass)->constructor = enotes_toolbar_button_constructor;
#line 23 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_toolbar_button_finalize;
#line 1107 "ToolbarButton.c"
}

static void
enotes_toolbar_button_instance_init (ENotesToolbarButton * self,
                                     gpointer klass)
{
#line 23 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self->priv = enotes_toolbar_button_get_instance_private (self);
#line 27 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self->priv->type = 0;
#line 1118 "ToolbarButton.c"
}

static void
enotes_toolbar_button_finalize (GObject * obj)
{
	ENotesToolbarButton * self;
#line 23 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_TOOLBAR_BUTTON, ENotesToolbarButton);
#line 24 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_g_object_unref0 (self->priv->code_buffer);
#line 25 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_g_object_unref0 (self->priv->plugin);
#line 29 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_g_free0 (self->priv->first_half);
#line 30 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	_g_free0 (self->priv->second_half);
#line 23 "../Notes-up-2.0.6/src/Widgets/ToolbarButton.vala"
	G_OBJECT_CLASS (enotes_toolbar_button_parent_class)->finalize (obj);
#line 1137 "ToolbarButton.c"
}

static GType
enotes_toolbar_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesToolbarButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_toolbar_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesToolbarButton), 0, (GInstanceInitFunc) enotes_toolbar_button_instance_init, NULL };
	GType enotes_toolbar_button_type_id;
	enotes_toolbar_button_type_id = g_type_register_static (gtk_button_get_type (), "ENotesToolbarButton", &g_define_type_info, 0);
	ENotesToolbarButton_private_offset = g_type_add_instance_private (enotes_toolbar_button_type_id, sizeof (ENotesToolbarButtonPrivate));
	return enotes_toolbar_button_type_id;
}

GType
enotes_toolbar_button_get_type (void)
{
	static volatile gsize enotes_toolbar_button_type_id__once = 0;
	if (g_once_init_enter (&enotes_toolbar_button_type_id__once)) {
		GType enotes_toolbar_button_type_id;
		enotes_toolbar_button_type_id = enotes_toolbar_button_get_type_once ();
		g_once_init_leave (&enotes_toolbar_button_type_id__once, enotes_toolbar_button_type_id);
	}
	return enotes_toolbar_button_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

