// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef node_inspector_protocol_Target_h
#define node_inspector_protocol_Target_h

#include "src/node/inspector/protocol/Protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace node {
namespace inspector {
namespace protocol {
namespace Target {
using SessionID = String;
using TargetID = String;
class TargetInfo;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class  TargetInfo : public ::crdtp::ProtocolObject<TargetInfo> {
public:
    ~TargetInfo() override { }

    String getTargetId() { return m_targetId; }
    void setTargetId(const String& value) { m_targetId = value; }

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    String getTitle() { return m_title; }
    void setTitle(const String& value) { m_title = value; }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    bool getAttached() { return m_attached; }
    void setAttached(bool value) { m_attached = value; }

    bool getCanAccessOpener() { return m_canAccessOpener; }
    void setCanAccessOpener(bool value) { m_canAccessOpener = value; }

    template<int STATE>
    class TargetInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TargetIdSet = 1 << 1,
            TypeSet = 1 << 2,
            TitleSet = 1 << 3,
            UrlSet = 1 << 4,
            AttachedSet = 1 << 5,
            CanAccessOpenerSet = 1 << 6,
            AllFieldsSet = (TargetIdSet | TypeSet | TitleSet | UrlSet | AttachedSet | CanAccessOpenerSet | 0)};


        TargetInfoBuilder<STATE | TargetIdSet>& setTargetId(const String& value)
        {
            static_assert(!(STATE & TargetIdSet), "property targetId should not be set yet");
            m_result->setTargetId(value);
            return castState<TargetIdSet>();
        }

        TargetInfoBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        TargetInfoBuilder<STATE | TitleSet>& setTitle(const String& value)
        {
            static_assert(!(STATE & TitleSet), "property title should not be set yet");
            m_result->setTitle(value);
            return castState<TitleSet>();
        }

        TargetInfoBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        TargetInfoBuilder<STATE | AttachedSet>& setAttached(bool value)
        {
            static_assert(!(STATE & AttachedSet), "property attached should not be set yet");
            m_result->setAttached(value);
            return castState<AttachedSet>();
        }

        TargetInfoBuilder<STATE | CanAccessOpenerSet>& setCanAccessOpener(bool value)
        {
            static_assert(!(STATE & CanAccessOpenerSet), "property canAccessOpener should not be set yet");
            m_result->setCanAccessOpener(value);
            return castState<CanAccessOpenerSet>();
        }

        std::unique_ptr<TargetInfo> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class TargetInfo;
        TargetInfoBuilder() : m_result(new TargetInfo()) { }

        template<int STEP> TargetInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<TargetInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Target::TargetInfo> m_result;
    };

    static TargetInfoBuilder<0> create()
    {
        return TargetInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    TargetInfo()
    {
          m_attached = false;
          m_canAccessOpener = false;
    }

    String m_targetId;
    String m_type;
    String m_title;
    String m_url;
    bool m_attached;
    bool m_canAccessOpener;
};


// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse setAutoAttach(bool in_autoAttach, bool in_waitForDebuggerOnStart) = 0;

    virtual DispatchResponse disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void targetCreated(std::unique_ptr<protocol::Target::TargetInfo> targetInfo);
    void attachedToTarget(const String& sessionId, std::unique_ptr<protocol::Target::TargetInfo> targetInfo, bool waitingForDebugger);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Target
} // namespace node
} // namespace inspector
} // namespace protocol

#endif // !defined(node_inspector_protocol_Target_h)
