/*
 * Copyright 2022, Oak Ridge National Laboratory.
 * MGARD-X: MultiGrid Adaptive Reduction of Data Portable across GPUs and CPUs
 * Author: Jieyang Chen (chenj3@ornl.gov)
 * Date: March 17, 2022
 */

#include "mgard-x/DataRefactoring/SingleDimension/Coefficient/CoefficientsRestore.hpp"
// clang-format off
namespace mgard_x {

namespace data_refactoring {

namespace single_dimension {

template void CoefficientsRestore<1, float, OPENMP>(
    DIM current_dim, SubArray<1, float, OPENMP> ratio,
    SubArray<1, float, OPENMP> v,
    SubArray<1, float, OPENMP> coarse,
    SubArray<1, float, OPENMP> coeff, int queue_idx);

} // namespace single_dimension

} // namespace data_refactoring

} // namespace mgard_x
// clang-format on
