/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AMDGPU target                          *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 139;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AMDGPUInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AMDGPUInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AMDGPUInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AMDGPUInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(6),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_p0s64,
  GILLT_p1s64,
  GILLT_p2s32,
  GILLT_p3s32,
  GILLT_p4s64,
  GILLT_p5s32,
  GILLT_p6s32,
  GILLT_s1,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v3s32,
  GILLT_v3s64,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v5s32,
  GILLT_v6s32,
  GILLT_v7s32,
  GILLT_v8s16,
  GILLT_v8s32,
  GILLT_v8s64,
  GILLT_v9s32,
  GILLT_v10s32,
  GILLT_v11s32,
  GILLT_v12s32,
  GILLT_v16s16,
  GILLT_v16s32,
  GILLT_v16s64,
  GILLT_v32s16,
  GILLT_v32s32,
};
const static size_t NumTypeObjects = 34;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 64),
  LLT::pointer(1, 64),
  LLT::pointer(2, 32),
  LLT::pointer(3, 32),
  LLT::pointer(4, 64),
  LLT::pointer(5, 32),
  LLT::pointer(6, 32),
  LLT::scalar(1),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 16),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(3), 32),
  LLT::vector(ElementCount::getFixed(3), 64),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(5), 32),
  LLT::vector(ElementCount::getFixed(6), 32),
  LLT::vector(ElementCount::getFixed(7), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 32),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(9), 32),
  LLT::vector(ElementCount::getFixed(10), 32),
  LLT::vector(ElementCount::getFixed(11), 32),
  LLT::vector(ElementCount::getFixed(12), 32),
  LLT::vector(ElementCount::getFixed(16), 16),
  LLT::vector(ElementCount::getFixed(16), 32),
  LLT::vector(ElementCount::getFixed(16), 64),
  LLT::vector(ElementCount::getFixed(32), 16),
  LLT::vector(ElementCount::getFixed(32), 32),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_FalsePredicateBit = 123,
  Feature_isGFX6Bit = 55,
  Feature_isGFX6GFX7Bit = 11,
  Feature_isGFX6GFX7GFX10Bit = 120,
  Feature_isGFX7OnlyBit = 91,
  Feature_isGFX7GFX8GFX9Bit = 50,
  Feature_isGFX6GFX7GFX8GFX9Bit = 72,
  Feature_isGFX6GFX7GFX8GFX9GFX10Bit = 135,
  Feature_isNotGFX12PlusBit = 24,
  Feature_isGFX8GFX9GFX10GFX11Bit = 26,
  Feature_isGFX7PlusBit = 16,
  Feature_isGFX8PlusBit = 4,
  Feature_isGFX8OnlyBit = 27,
  Feature_isGFX9PlusBit = 0,
  Feature_isNotGFX9PlusBit = 61,
  Feature_isGFX90APlusBit = 43,
  Feature_isNotGFX90APlusBit = 28,
  Feature_isGFX908orGFX90ABit = 44,
  Feature_isGFX940PlusBit = 45,
  Feature_isNotGFX940PlusBit = 56,
  Feature_HasGFX950InstsBit = 33,
  Feature_isGFX8GFX9Bit = 19,
  Feature_isGFX10OnlyBit = 18,
  Feature_isGFX10PlusBit = 8,
  Feature_isGFX9GFX10Bit = 62,
  Feature_isGFX11OnlyBit = 69,
  Feature_isGFX11PlusBit = 1,
  Feature_isGFX12OnlyBit = 70,
  Feature_isGFX12PlusBit = 3,
  Feature_isGFX12PlusNot12_50Bit = 67,
  Feature_isGFX125xOnlyBit = 68,
  Feature_isGFX1250PlusBit = 7,
  Feature_isNotGFX1250PlusBit = 5,
  Feature_HasIEEEMinimumMaximumInstsBit = 21,
  Feature_HasMinimum3Maximum3F32Bit = 25,
  Feature_HasMinimum3Maximum3F16Bit = 30,
  Feature_HasMinimum3Maximum3PKF16Bit = 37,
  Feature_HasFlatAddressSpaceBit = 93,
  Feature_HasFlatBufferGlobalAtomicFaddF64InstBit = 110,
  Feature_HasAtomicFMinFMaxF32GlobalInstsBit = 104,
  Feature_HasAtomicFMinFMaxF64GlobalInstsBit = 109,
  Feature_HasAtomicFMinFMaxF32FlatInstsBit = 99,
  Feature_HasAtomicFMinFMaxF64FlatInstsBit = 100,
  Feature_HasLdsAtomicAddF64Bit = 138,
  Feature_HasFlatGlobalInstsBit = 94,
  Feature_HasFlatScratchInstsBit = 97,
  Feature_HasD16LoadStoreBit = 102,
  Feature_HasFlatScratchSVSModeBit = 98,
  Feature_HasGFX10_BEncodingBit = 54,
  Feature_HasUnpackedD16VMemBit = 115,
  Feature_HasPackedD16VMemBit = 116,
  Feature_HasUnrestrictedSOffsetBit = 113,
  Feature_D16PreservesUnusedBitsBit = 95,
  Feature_LDSRequiresM0InitBit = 131,
  Feature_NotLDSRequiresM0InitBit = 132,
  Feature_HasMTBUFInstsBit = 118,
  Feature_HasFormattedMUBUFInstsBit = 114,
  Feature_HasExportInstsBit = 10,
  Feature_HasLDSFPAtomicAddF32Bit = 137,
  Feature_HasAddNoCarryInstsBit = 71,
  Feature_NotHasAddNoCarryInstsBit = 128,
  Feature_HasXNACKEnabledBit = 90,
  Feature_Has16BitInstsBit = 12,
  Feature_NotHasTrue16BitInstsBit = 13,
  Feature_UseRealTrue16InstsBit = 14,
  Feature_UseFakeTrue16InstsBit = 15,
  Feature_HasVOP3PInstsBit = 84,
  Feature_HasMed3_16Bit = 129,
  Feature_HasMinMaxDenormModesBit = 122,
  Feature_NotHasMinMaxDenormModesBit = 124,
  Feature_HasSDWABit = 66,
  Feature_HasPackedFP32OpsBit = 48,
  Feature_HasImageInstsBit = 9,
  Feature_HasIntClampBit = 77,
  Feature_HasMadMixInstsBit = 85,
  Feature_HasScalarStoresBit = 51,
  Feature_has16BankLDSBit = 57,
  Feature_has32BankLDSBit = 29,
  Feature_HasFmaMixInstsBit = 87,
  Feature_HasDLInstsBit = 20,
  Feature_HasFmacF64InstBit = 127,
  Feature_HasDot1InstsBit = 41,
  Feature_HasDot2InstsBit = 38,
  Feature_HasDot3InstsBit = 76,
  Feature_HasDot4InstsBit = 75,
  Feature_HasDot5InstsBit = 73,
  Feature_HasDot6InstsBit = 74,
  Feature_HasDot7InstsBit = 40,
  Feature_HasDot8InstsBit = 88,
  Feature_HasDot9InstsBit = 34,
  Feature_HasDot10InstsBit = 39,
  Feature_HasDot11InstsBit = 89,
  Feature_HasGetWaveIdInstBit = 53,
  Feature_HasMAIInstsBit = 42,
  Feature_HasSMemRealTimeBit = 52,
  Feature_HasSMemTimeInstBit = 49,
  Feature_HasShaderCyclesRegisterBit = 92,
  Feature_HasShaderCyclesHiLoRegistersBit = 60,
  Feature_HasFP8InstsBit = 47,
  Feature_HasFP8ConversionInstsBit = 64,
  Feature_HasMadMacF32InstsBit = 22,
  Feature_HasFmaLegacy32Bit = 23,
  Feature_HasAtomicDsPkAdd16InstsBit = 136,
  Feature_HasAtomicFlatPkAdd16InstsBit = 112,
  Feature_HasAtomicFaddRtnInstsBit = 107,
  Feature_HasAtomicFaddNoRtnInstsBit = 105,
  Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit = 106,
  Feature_HasAtomicBufferGlobalPkAddF16InstsBit = 108,
  Feature_HasFlatAtomicFaddF32InstBit = 111,
  Feature_EnableFlatScratchBit = 96,
  Feature_DisableFlatScratchBit = 117,
  Feature_HasUnalignedAccessModeBit = 133,
  Feature_HasMADIntraFwdBugBit = 80,
  Feature_HasNotMADIntraFwdBugBit = 79,
  Feature_HasSALUFloatInstsBit = 2,
  Feature_NotHasSALUFloatInstsBit = 119,
  Feature_HasPseudoScalarTransBit = 35,
  Feature_HasBitOp3InstsBit = 82,
  Feature_HasTransposeLoadF4F6InstsBit = 103,
  Feature_HasPrngInstBit = 17,
  Feature_HasFP6BF6ConversionScaleInstsBit = 31,
  Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit = 32,
  Feature_HasCvtPkF16F32InstBit = 81,
  Feature_HasF32ToF16BF16ConversionSRInstsBit = 83,
  Feature_HasGDSBit = 134,
  Feature_HasCvtFP8VOP1BugBit = 63,
  Feature_HasNoCvtFP8VOP1BugBit = 65,
  Feature_HasAtomicCSubNoRtnInstsBit = 101,
  Feature_HasXF32InstsBit = 46,
  Feature_HasAshrPkInstsBit = 36,
  Feature_HasLshlAddU64InstBit = 78,
  Feature_HasLdsBarrierArriveAtomicBit = 130,
  Feature_HasSetPrioIncWgInstBit = 6,
  Feature_FP16DenormalsBit = 126,
  Feature_FP64DenormalsBit = 125,
  Feature_NoFP32DenormalsBit = 86,
  Feature_IEEEModeDisabledBit = 121,
  Feature_isWave32Bit = 58,
  Feature_isWave64Bit = 59,
};

PredicateBitset AMDGPUInstructionSelector::
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (false)
    Features.set(Feature_FalsePredicateBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS)
    Features.set(Feature_isGFX6Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX6GFX7Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7OnlyBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX6GFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX8GFX9GFX10Bit);
  if (Subtarget->getGeneration() <= AMDGPUSubtarget::GFX11)
    Features.set(Feature_isNotGFX12PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX8GFX9GFX10GFX11Bit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7PlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8PlusBit);
  if (Subtarget->getGeneration() ==AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX9PlusBit);
  if (Subtarget->getGeneration() < AMDGPUSubtarget::GFX9)
    Features.set(Feature_isNotGFX9PlusBit);
  if (Subtarget->hasGFX90AInsts())
    Features.set(Feature_isGFX90APlusBit);
  if (!Subtarget->hasGFX90AInsts())
    Features.set(Feature_isNotGFX90APlusBit);
  if (Subtarget->hasMAIInsts() && !Subtarget->hasGFX940Insts())
    Features.set(Feature_isGFX908orGFX90ABit);
  if (Subtarget->hasGFX940Insts())
    Features.set(Feature_isGFX940PlusBit);
  if (!Subtarget->hasGFX940Insts())
    Features.set(Feature_isNotGFX940PlusBit);
  if (Subtarget->hasGFX950Insts())
    Features.set(Feature_HasGFX950InstsBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX9GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX11OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX11PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX12)
    Features.set(Feature_isGFX12OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX12)
    Features.set(Feature_isGFX12PlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX12 && !Subtarget->hasGFX1250Insts())
    Features.set(Feature_isGFX12PlusNot12_50Bit);
  if (Subtarget->hasGFX1250Insts())
    Features.set(Feature_isGFX125xOnlyBit);
  if (Subtarget->hasGFX1250Insts())
    Features.set(Feature_isGFX1250PlusBit);
  if (!Subtarget->hasGFX1250Insts())
    Features.set(Feature_isNotGFX1250PlusBit);
  if (Subtarget->hasIEEEMinimumMaximumInsts())
    Features.set(Feature_HasIEEEMinimumMaximumInstsBit);
  if (Subtarget->hasMinimum3Maximum3F32())
    Features.set(Feature_HasMinimum3Maximum3F32Bit);
  if (Subtarget->hasMinimum3Maximum3F16())
    Features.set(Feature_HasMinimum3Maximum3F16Bit);
  if (Subtarget->hasMinimum3Maximum3PKF16())
    Features.set(Feature_HasMinimum3Maximum3PKF16Bit);
  if (Subtarget->hasFlatAddressSpace())
    Features.set(Feature_HasFlatAddressSpaceBit);
  if (Subtarget->hasFlatBufferGlobalAtomicFaddF64Inst())
    Features.set(Feature_HasFlatBufferGlobalAtomicFaddF64InstBit);
  if (Subtarget->hasAtomicFMinFMaxF32GlobalInsts())
    Features.set(Feature_HasAtomicFMinFMaxF32GlobalInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF64GlobalInsts())
    Features.set(Feature_HasAtomicFMinFMaxF64GlobalInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF32FlatInsts())
    Features.set(Feature_HasAtomicFMinFMaxF32FlatInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF64FlatInsts())
    Features.set(Feature_HasAtomicFMinFMaxF64FlatInstsBit);
  if (Subtarget->hasLdsAtomicAddF64())
    Features.set(Feature_HasLdsAtomicAddF64Bit);
  if (Subtarget->hasFlatGlobalInsts())
    Features.set(Feature_HasFlatGlobalInstsBit);
  if (Subtarget->hasFlatScratchInsts())
    Features.set(Feature_HasFlatScratchInstsBit);
  if (Subtarget->hasD16LoadStore())
    Features.set(Feature_HasD16LoadStoreBit);
  if (Subtarget->hasFlatScratchSVSMode())
    Features.set(Feature_HasFlatScratchSVSModeBit);
  if (Subtarget->hasGFX10_BEncoding())
    Features.set(Feature_HasGFX10_BEncodingBit);
  if (Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasUnpackedD16VMemBit);
  if (!Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasPackedD16VMemBit);
  if (!Subtarget->hasRestrictedSOffset())
    Features.set(Feature_HasUnrestrictedSOffsetBit);
  if (Subtarget->d16PreservesUnusedBits())
    Features.set(Feature_D16PreservesUnusedBitsBit);
  if (Subtarget->ldsRequiresM0Init())
    Features.set(Feature_LDSRequiresM0InitBit);
  if (!Subtarget->ldsRequiresM0Init())
    Features.set(Feature_NotLDSRequiresM0InitBit);
  if (Subtarget->hasMTBUFInsts())
    Features.set(Feature_HasMTBUFInstsBit);
  if (Subtarget->hasFormattedMUBUFInsts())
    Features.set(Feature_HasFormattedMUBUFInstsBit);
  if (Subtarget->hasExportInsts())
    Features.set(Feature_HasExportInstsBit);
  if (Subtarget->hasLDSFPAtomicAddF32())
    Features.set(Feature_HasLDSFPAtomicAddF32Bit);
  if (Subtarget->hasAddNoCarry())
    Features.set(Feature_HasAddNoCarryInstsBit);
  if (!Subtarget->hasAddNoCarry())
    Features.set(Feature_NotHasAddNoCarryInstsBit);
  if (Subtarget->isXNACKEnabled())
    Features.set(Feature_HasXNACKEnabledBit);
  if (Subtarget->has16BitInsts())
    Features.set(Feature_Has16BitInstsBit);
  if (!Subtarget->hasTrue16BitInsts())
    Features.set(Feature_NotHasTrue16BitInstsBit);
  if (Subtarget->useRealTrue16Insts())
    Features.set(Feature_UseRealTrue16InstsBit);
  if (Subtarget->hasTrue16BitInsts() && !Subtarget->useRealTrue16Insts())
    Features.set(Feature_UseFakeTrue16InstsBit);
  if (Subtarget->hasVOP3PInsts())
    Features.set(Feature_HasVOP3PInstsBit);
  if (Subtarget->hasMed3_16())
    Features.set(Feature_HasMed3_16Bit);
  if (Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_HasMinMaxDenormModesBit);
  if (!Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_NotHasMinMaxDenormModesBit);
  if (Subtarget->hasSDWA())
    Features.set(Feature_HasSDWABit);
  if (Subtarget->hasPackedFP32Ops())
    Features.set(Feature_HasPackedFP32OpsBit);
  if (Subtarget->hasImageInsts())
    Features.set(Feature_HasImageInstsBit);
  if (Subtarget->hasIntClamp())
    Features.set(Feature_HasIntClampBit);
  if (Subtarget->hasMadMixInsts())
    Features.set(Feature_HasMadMixInstsBit);
  if (Subtarget->hasScalarStores())
    Features.set(Feature_HasScalarStoresBit);
  if (Subtarget->getLDSBankCount() == 16)
    Features.set(Feature_has16BankLDSBit);
  if (Subtarget->getLDSBankCount() == 32)
    Features.set(Feature_has32BankLDSBit);
  if (Subtarget->hasFmaMixInsts())
    Features.set(Feature_HasFmaMixInstsBit);
  if (Subtarget->hasDLInsts())
    Features.set(Feature_HasDLInstsBit);
  if (Subtarget->hasFmacF64Inst())
    Features.set(Feature_HasFmacF64InstBit);
  if (Subtarget->hasDot1Insts())
    Features.set(Feature_HasDot1InstsBit);
  if (Subtarget->hasDot2Insts())
    Features.set(Feature_HasDot2InstsBit);
  if (Subtarget->hasDot3Insts())
    Features.set(Feature_HasDot3InstsBit);
  if (Subtarget->hasDot4Insts())
    Features.set(Feature_HasDot4InstsBit);
  if (Subtarget->hasDot5Insts())
    Features.set(Feature_HasDot5InstsBit);
  if (Subtarget->hasDot6Insts())
    Features.set(Feature_HasDot6InstsBit);
  if (Subtarget->hasDot7Insts())
    Features.set(Feature_HasDot7InstsBit);
  if (Subtarget->hasDot8Insts())
    Features.set(Feature_HasDot8InstsBit);
  if (Subtarget->hasDot9Insts())
    Features.set(Feature_HasDot9InstsBit);
  if (Subtarget->hasDot10Insts())
    Features.set(Feature_HasDot10InstsBit);
  if (Subtarget->hasDot11Insts())
    Features.set(Feature_HasDot11InstsBit);
  if (Subtarget->hasGetWaveIdInst())
    Features.set(Feature_HasGetWaveIdInstBit);
  if (Subtarget->hasMAIInsts())
    Features.set(Feature_HasMAIInstsBit);
  if (Subtarget->hasSMemRealTime())
    Features.set(Feature_HasSMemRealTimeBit);
  if (Subtarget->hasSMemTimeInst())
    Features.set(Feature_HasSMemTimeInstBit);
  if (Subtarget->hasShaderCyclesRegister())
    Features.set(Feature_HasShaderCyclesRegisterBit);
  if (Subtarget->hasShaderCyclesHiLoRegisters())
    Features.set(Feature_HasShaderCyclesHiLoRegistersBit);
  if (Subtarget->hasFP8Insts())
    Features.set(Feature_HasFP8InstsBit);
  if (Subtarget->hasFP8ConversionInsts())
    Features.set(Feature_HasFP8ConversionInstsBit);
  if (Subtarget->hasMadMacF32Insts())
    Features.set(Feature_HasMadMacF32InstsBit);
  if (Subtarget->hasGFX10_3Insts())
    Features.set(Feature_HasFmaLegacy32Bit);
  if (Subtarget->hasAtomicDsPkAdd16Insts())
    Features.set(Feature_HasAtomicDsPkAdd16InstsBit);
  if (Subtarget->hasAtomicFlatPkAdd16Insts())
    Features.set(Feature_HasAtomicFlatPkAdd16InstsBit);
  if (Subtarget->hasAtomicFaddRtnInsts())
    Features.set(Feature_HasAtomicFaddRtnInstsBit);
  if (Subtarget->hasAtomicFaddNoRtnInsts())
    Features.set(Feature_HasAtomicFaddNoRtnInstsBit);
  if (Subtarget->hasAtomicBufferGlobalPkAddF16NoRtnInsts() || Subtarget->hasAtomicBufferGlobalPkAddF16Insts())
    Features.set(Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit);
  if (Subtarget->hasAtomicBufferGlobalPkAddF16Insts())
    Features.set(Feature_HasAtomicBufferGlobalPkAddF16InstsBit);
  if (Subtarget->hasFlatAtomicFaddF32Inst())
    Features.set(Feature_HasFlatAtomicFaddF32InstBit);
  if (Subtarget->enableFlatScratch())
    Features.set(Feature_EnableFlatScratchBit);
  if (!Subtarget->enableFlatScratch())
    Features.set(Feature_DisableFlatScratchBit);
  if (Subtarget->hasUnalignedAccessMode())
    Features.set(Feature_HasUnalignedAccessModeBit);
  if (Subtarget->hasMADIntraFwdBug())
    Features.set(Feature_HasMADIntraFwdBugBit);
  if (!Subtarget->hasMADIntraFwdBug())
    Features.set(Feature_HasNotMADIntraFwdBugBit);
  if (Subtarget->hasSALUFloatInsts())
    Features.set(Feature_HasSALUFloatInstsBit);
  if (!Subtarget->hasSALUFloatInsts())
    Features.set(Feature_NotHasSALUFloatInstsBit);
  if (Subtarget->hasPseudoScalarTrans())
    Features.set(Feature_HasPseudoScalarTransBit);
  if (Subtarget->hasBitOp3Insts())
    Features.set(Feature_HasBitOp3InstsBit);
  if (Subtarget->hasTransposeLoadF4F6Insts())
    Features.set(Feature_HasTransposeLoadF4F6InstsBit);
  if (Subtarget->hasPrngInst())
    Features.set(Feature_HasPrngInstBit);
  if (Subtarget->hasFP6BF6ConversionScaleInsts())
    Features.set(Feature_HasFP6BF6ConversionScaleInstsBit);
  if (Subtarget->hasF16BF16ToFP6BF6ConversionScaleInsts())
    Features.set(Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit);
  if (Subtarget->hasCvtPkF16F32Inst())
    Features.set(Feature_HasCvtPkF16F32InstBit);
  if (Subtarget->hasF32ToF16BF16ConversionSRInsts())
    Features.set(Feature_HasF32ToF16BF16ConversionSRInstsBit);
  if (Subtarget->hasGDS())
    Features.set(Feature_HasGDSBit);
  if (Subtarget->hasCvtFP8VOP1Bug())
    Features.set(Feature_HasCvtFP8VOP1BugBit);
  if (!Subtarget->hasCvtFP8VOP1Bug())
    Features.set(Feature_HasNoCvtFP8VOP1BugBit);
  if (Subtarget->hasAtomicCSubNoRtnInsts())
    Features.set(Feature_HasAtomicCSubNoRtnInstsBit);
  if (Subtarget->hasXF32Insts())
    Features.set(Feature_HasXF32InstsBit);
  if (Subtarget->hasAshrPkInsts())
    Features.set(Feature_HasAshrPkInstsBit);
  if (Subtarget->hasLshlAddU64Inst())
    Features.set(Feature_HasLshlAddU64InstBit);
  if (Subtarget->hasLdsBarrierArriveAtomic())
    Features.set(Feature_HasLdsBarrierArriveAtomicBit);
  if (Subtarget->hasSetPrioIncWgInst())
    Features.set(Feature_HasSetPrioIncWgInstBit);
  if (Subtarget->isWave32())
    Features.set(Feature_isWave32Bit);
  if (Subtarget->isWave64())
    Features.set(Feature_isWave64Bit);
  return Features;
}

void AMDGPUInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AMDGPUSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AMDGPUInstructionSelector::
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP64FP16Denormals != DenormalMode::getPreserveSign())
    Features.set(Feature_FP16DenormalsBit);
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP64FP16Denormals != DenormalMode::getPreserveSign())
    Features.set(Feature_FP64DenormalsBit);
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP32Denormals == DenormalMode::getPreserveSign())
    Features.set(Feature_NoFP32DenormalsBit);
  if (!MF->getInfo<SIMachineFunctionInfo>()->getMode().IEEE)
    Features.set(Feature_IEEEModeDisabledBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_DisableFlatScratch,
  GIFBS_Has16BitInsts,
  GIFBS_HasAddNoCarryInsts,
  GIFBS_HasAshrPkInsts,
  GIFBS_HasAtomicBufferGlobalPkAddF16Insts,
  GIFBS_HasAtomicBufferGlobalPkAddF16NoRtnInsts,
  GIFBS_HasAtomicCSubNoRtnInsts,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts,
  GIFBS_HasAtomicFaddNoRtnInsts,
  GIFBS_HasAtomicFaddRtnInsts,
  GIFBS_HasAtomicFlatPkAdd16Insts,
  GIFBS_HasBitOp3Insts,
  GIFBS_HasCvtPkF16F32Inst,
  GIFBS_HasD16LoadStore,
  GIFBS_HasDLInsts,
  GIFBS_HasDot10Insts,
  GIFBS_HasDot1Insts,
  GIFBS_HasDot2Insts,
  GIFBS_HasDot3Insts,
  GIFBS_HasDot4Insts,
  GIFBS_HasDot5Insts,
  GIFBS_HasDot6Insts,
  GIFBS_HasDot7Insts,
  GIFBS_HasDot8Insts,
  GIFBS_HasF16BF16ToFP6BF6ConversionScaleInsts,
  GIFBS_HasF32ToF16BF16ConversionSRInsts,
  GIFBS_HasFP6BF6ConversionScaleInsts,
  GIFBS_HasFP8Insts,
  GIFBS_HasFlatAddressSpace,
  GIFBS_HasFlatAtomicFaddF32Inst,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst,
  GIFBS_HasFlatGlobalInsts,
  GIFBS_HasFmaLegacy32,
  GIFBS_HasFmaMixInsts,
  GIFBS_HasFmacF64Inst,
  GIFBS_HasFormattedMUBUFInsts,
  GIFBS_HasGDS,
  GIFBS_HasGFX10_BEncoding,
  GIFBS_HasGFX950Insts,
  GIFBS_HasGetWaveIdInst,
  GIFBS_HasIEEEMinimumMaximumInsts,
  GIFBS_HasIntClamp,
  GIFBS_HasLdsAtomicAddF64,
  GIFBS_HasLshlAddU64Inst,
  GIFBS_HasMAIInsts,
  GIFBS_HasMTBUFInsts,
  GIFBS_HasMadMacF32Insts,
  GIFBS_HasMinMaxDenormModes,
  GIFBS_HasMinimum3Maximum3F32,
  GIFBS_HasMinimum3Maximum3PKF16,
  GIFBS_HasPackedFP32Ops,
  GIFBS_HasPrngInst,
  GIFBS_HasPseudoScalarTrans,
  GIFBS_HasSALUFloatInsts,
  GIFBS_HasSMemRealTime,
  GIFBS_HasSMemTimeInst,
  GIFBS_HasSetPrioIncWgInst,
  GIFBS_HasShaderCyclesHiLoRegisters,
  GIFBS_HasShaderCyclesRegister,
  GIFBS_HasUnrestrictedSOffset,
  GIFBS_HasVOP3PInsts,
  GIFBS_HasXF32Insts,
  GIFBS_HasXNACKEnabled,
  GIFBS_IEEEModeDisabled,
  GIFBS_LDSRequiresM0Init,
  GIFBS_NotHasAddNoCarryInsts,
  GIFBS_NotHasTrue16BitInsts,
  GIFBS_NotLDSRequiresM0Init,
  GIFBS_UseFakeTrue16Insts,
  GIFBS_UseRealTrue16Insts,
  GIFBS_isGFX10Only,
  GIFBS_isGFX10Plus,
  GIFBS_isGFX11Only,
  GIFBS_isGFX11Plus,
  GIFBS_isGFX1250Plus,
  GIFBS_isGFX12Only,
  GIFBS_isGFX12Plus,
  GIFBS_isGFX12PlusNot12_50,
  GIFBS_isGFX6,
  GIFBS_isGFX6GFX7,
  GIFBS_isGFX6GFX7GFX8GFX9,
  GIFBS_isGFX7GFX8GFX9,
  GIFBS_isGFX7Only,
  GIFBS_isGFX7Plus,
  GIFBS_isGFX8GFX9,
  GIFBS_isGFX8GFX9GFX10GFX11,
  GIFBS_isGFX8Plus,
  GIFBS_isGFX908orGFX90A,
  GIFBS_isGFX90APlus,
  GIFBS_isGFX940Plus,
  GIFBS_isGFX9GFX10,
  GIFBS_isGFX9Plus,
  GIFBS_isNotGFX1250Plus,
  GIFBS_isNotGFX12Plus,
  GIFBS_isNotGFX90APlus,
  GIFBS_isNotGFX940Plus,
  GIFBS_isNotGFX9Plus,
  GIFBS_isWave32,
  GIFBS_isWave64,
  GIFBS_DisableFlatScratch_HasD16LoadStore,
  GIFBS_DisableFlatScratch_HasUnrestrictedSOffset,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts,
  GIFBS_FP16Denormals_NotHasMinMaxDenormModes,
  GIFBS_FalsePredicate_NotHasMinMaxDenormModes,
  GIFBS_Has16BitInsts_HasIntClamp,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_UseFakeTrue16Insts,
  GIFBS_Has16BitInsts_UseRealTrue16Insts,
  GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8Only,
  GIFBS_Has16BitInsts_isNotGFX90APlus,
  GIFBS_HasAddNoCarryInsts_HasIntClamp,
  GIFBS_HasAtomicBufferGlobalPkAddF16Insts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicBufferGlobalPkAddF16NoRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicCSubNoRtnInsts_isGFX12Plus,
  GIFBS_HasAtomicDsPkAdd16Insts_HasGDS,
  GIFBS_HasAtomicDsPkAdd16Insts_LDSRequiresM0Init,
  GIFBS_HasAtomicDsPkAdd16Insts_NotLDSRequiresM0Init,
  GIFBS_HasAtomicFMinFMaxF32FlatInsts_HasFlatAddressSpace,
  GIFBS_HasAtomicFMinFMaxF32FlatInsts_HasFlatGlobalInsts,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts_HasFlatGlobalInsts,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFMinFMaxF64FlatInsts_HasFlatAddressSpace,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts_HasFlatGlobalInsts,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFaddNoRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFaddRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasCvtFP8VOP1Bug_HasFP8ConversionInsts,
  GIFBS_HasDot11Insts_isGFX12Plus,
  GIFBS_HasDot9Insts_NotHasTrue16BitInsts,
  GIFBS_HasDot9Insts_UseFakeTrue16Insts,
  GIFBS_HasDot9Insts_UseRealTrue16Insts,
  GIFBS_HasExportInsts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_HasSDWA,
  GIFBS_HasFP8ConversionInsts_isGFX125xOnly,
  GIFBS_HasFP8ConversionInsts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_isGFX12PlusNot12_50,
  GIFBS_HasFP8ConversionInsts_isGFX940Plus,
  GIFBS_HasFP8Insts_isGFX90APlus,
  GIFBS_HasFlatAddressSpace_NotHasTrue16BitInsts,
  GIFBS_HasFlatAddressSpace_UseFakeTrue16Insts,
  GIFBS_HasFlatAddressSpace_isGFX12Plus,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst_HasUnrestrictedSOffset,
  GIFBS_HasFlatGlobalInsts_NotHasTrue16BitInsts,
  GIFBS_HasFlatGlobalInsts_UseFakeTrue16Insts,
  GIFBS_HasFlatGlobalInsts_isGFX12Plus,
  GIFBS_HasFmaMixInsts_NotHasTrue16BitInsts,
  GIFBS_HasFmaMixInsts_UseFakeTrue16Insts,
  GIFBS_HasFmaMixInsts_UseRealTrue16Insts,
  GIFBS_HasFormattedMUBUFInsts_HasPackedD16VMem,
  GIFBS_HasFormattedMUBUFInsts_HasUnpackedD16VMem,
  GIFBS_HasFormattedMUBUFInsts_HasUnrestrictedSOffset,
  GIFBS_HasGDS_HasLDSFPAtomicAddF32,
  GIFBS_HasGDS_isGFX11Plus,
  GIFBS_HasGDS_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_HasGFX950Insts_isGFX90APlus,
  GIFBS_HasIEEEMinimumMaximumInsts_NotHasTrue16BitInsts,
  GIFBS_HasIEEEMinimumMaximumInsts_UseFakeTrue16Insts,
  GIFBS_HasIEEEMinimumMaximumInsts_UseRealTrue16Insts,
  GIFBS_HasImageInsts_isGFX12Plus,
  GIFBS_HasLDSFPAtomicAddF32_LDSRequiresM0Init,
  GIFBS_HasLDSFPAtomicAddF32_NotLDSRequiresM0Init,
  GIFBS_HasLdsBarrierArriveAtomic_isGFX1250Plus,
  GIFBS_HasMADIntraFwdBug_isGFX11Only,
  GIFBS_HasMAIInsts_isGFX90APlus,
  GIFBS_HasMTBUFInsts_HasPackedD16VMem,
  GIFBS_HasMTBUFInsts_HasUnpackedD16VMem,
  GIFBS_HasMTBUFInsts_HasUnrestrictedSOffset,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals,
  GIFBS_HasMadMixInsts_NoFP32Denormals,
  GIFBS_HasMed3_16_NotHasTrue16BitInsts,
  GIFBS_HasMed3_16_UseFakeTrue16Insts,
  GIFBS_HasMed3_16_UseRealTrue16Insts,
  GIFBS_HasMinMaxDenormModes_isGFX12Plus,
  GIFBS_HasMinMaxDenormModes_isNotGFX12Plus,
  GIFBS_HasNotMADIntraFwdBug_isGFX9Plus,
  GIFBS_HasScalarStores_isGFX8Plus,
  GIFBS_HasTransposeLoadF4F6Insts_isWave32,
  GIFBS_HasUnalignedAccessMode_LDSRequiresM0Init,
  GIFBS_HasUnalignedAccessMode_NotLDSRequiresM0Init,
  GIFBS_HasVOP3PInsts_IEEEModeDisabled,
  GIFBS_HasVOP3PInsts_NotHasTrue16BitInsts,
  GIFBS_HasVOP3PInsts_UseFakeTrue16Insts,
  GIFBS_HasVOP3PInsts_UseRealTrue16Insts,
  GIFBS_HasXF32Insts_isGFX90APlus,
  GIFBS_HasXNACKEnabled_isGFX7Only,
  GIFBS_HasXNACKEnabled_isGFX9Plus,
  GIFBS_HasXNACKEnabled_isNotGFX9Plus,
  GIFBS_LDSRequiresM0Init_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_LDSRequiresM0Init_isGFX7Plus,
  GIFBS_NotHasTrue16BitInsts_NotLDSRequiresM0Init,
  GIFBS_NotHasTrue16BitInsts_isGFX10Plus,
  GIFBS_NotHasTrue16BitInsts_isGFX8Plus,
  GIFBS_NotHasTrue16BitInsts_isGFX9GFX10,
  GIFBS_NotHasTrue16BitInsts_isGFX9Plus,
  GIFBS_NotHasTrue16BitInsts_isNotGFX9Plus,
  GIFBS_NotLDSRequiresM0Init_UseFakeTrue16Insts,
  GIFBS_NotLDSRequiresM0Init_UseRealTrue16Insts,
  GIFBS_NotLDSRequiresM0Init_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_NotLDSRequiresM0Init_isGFX7Plus,
  GIFBS_UseFakeTrue16Insts_isGFX10Plus,
  GIFBS_UseFakeTrue16Insts_isGFX1250Plus,
  GIFBS_UseFakeTrue16Insts_isGFX8Plus,
  GIFBS_UseFakeTrue16Insts_isGFX9Plus,
  GIFBS_UseRealTrue16Insts_isGFX10Plus,
  GIFBS_UseRealTrue16Insts_isGFX1250Plus,
  GIFBS_UseRealTrue16Insts_isGFX8Plus,
  GIFBS_UseRealTrue16Insts_isGFX9Plus,
  GIFBS_has16BankLDS_isNotGFX90APlus,
  GIFBS_has32BankLDS_isNotGFX90APlus,
  GIFBS_isGFX11Only_isWave32,
  GIFBS_isGFX11Only_isWave64,
  GIFBS_isGFX1250Plus_isWave32,
  GIFBS_isGFX12Plus_isWave32,
  GIFBS_isGFX12Plus_isWave64,
  GIFBS_isGFX12PlusNot12_50_isWave64,
  GIFBS_isGFX90APlus_isGFX908orGFX90A,
  GIFBS_isGFX90APlus_isGFX940Plus,
  GIFBS_D16PreservesUnusedBits_HasFlatAddressSpace_UseRealTrue16Insts,
  GIFBS_D16PreservesUnusedBits_HasFlatGlobalInsts_UseRealTrue16Insts,
  GIFBS_DisableFlatScratch_HasD16LoadStore_HasUnrestrictedSOffset,
  GIFBS_EnableFlatScratch_HasD16LoadStore_HasFlatScratchInsts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_NotHasTrue16BitInsts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_UseFakeTrue16Insts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_UseRealTrue16Insts,
  GIFBS_FP64Denormals_NotHasMinMaxDenormModes_isGFX12Plus,
  GIFBS_FP64Denormals_NotHasMinMaxDenormModes_isNotGFX12Plus,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_UseFakeTrue16Insts,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_UseRealTrue16Insts,
  GIFBS_Has16BitInsts_IEEEModeDisabled_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_IEEEModeDisabled_UseFakeTrue16Insts,
  GIFBS_Has16BitInsts_IEEEModeDisabled_UseRealTrue16Insts,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Only,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX1250Plus,
  GIFBS_Has16BitInsts_has32BankLDS_isNotGFX90APlus,
  GIFBS_HasFP8ConversionInsts_HasNoCvtFP8VOP1Bug_HasSDWA,
  GIFBS_HasFP8ConversionInsts_NotHasTrue16BitInsts_isGFX9Plus,
  GIFBS_HasFP8ConversionInsts_UseFakeTrue16Insts_isGFX9Plus,
  GIFBS_HasFormattedMUBUFInsts_HasPackedD16VMem_HasUnrestrictedSOffset,
  GIFBS_HasMTBUFInsts_HasPackedD16VMem_HasUnrestrictedSOffset,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals_isGFX6GFX7GFX10,
  GIFBS_HasMadMixInsts_NoFP32Denormals_NotHasTrue16BitInsts,
  GIFBS_HasMadMixInsts_NoFP32Denormals_UseFakeTrue16Insts,
  GIFBS_HasMadMixInsts_NoFP32Denormals_UseRealTrue16Insts,
  GIFBS_HasTransposeLoadF4F6Insts_isGFX1250Plus_isWave32,
  GIFBS_EnableFlatScratch_HasD16LoadStore_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode_NotHasTrue16BitInsts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode_UseFakeTrue16Insts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode_UseRealTrue16Insts,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_NotHasTrue16BitInsts,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_UseFakeTrue16Insts,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_UseRealTrue16Insts,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_DisableFlatScratchBit, },
  {Feature_Has16BitInstsBit, },
  {Feature_HasAddNoCarryInstsBit, },
  {Feature_HasAshrPkInstsBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16InstsBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, },
  {Feature_HasAtomicFaddNoRtnInstsBit, },
  {Feature_HasAtomicFaddRtnInstsBit, },
  {Feature_HasAtomicFlatPkAdd16InstsBit, },
  {Feature_HasBitOp3InstsBit, },
  {Feature_HasCvtPkF16F32InstBit, },
  {Feature_HasD16LoadStoreBit, },
  {Feature_HasDLInstsBit, },
  {Feature_HasDot10InstsBit, },
  {Feature_HasDot1InstsBit, },
  {Feature_HasDot2InstsBit, },
  {Feature_HasDot3InstsBit, },
  {Feature_HasDot4InstsBit, },
  {Feature_HasDot5InstsBit, },
  {Feature_HasDot6InstsBit, },
  {Feature_HasDot7InstsBit, },
  {Feature_HasDot8InstsBit, },
  {Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit, },
  {Feature_HasF32ToF16BF16ConversionSRInstsBit, },
  {Feature_HasFP6BF6ConversionScaleInstsBit, },
  {Feature_HasFP8InstsBit, },
  {Feature_HasFlatAddressSpaceBit, },
  {Feature_HasFlatAtomicFaddF32InstBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, },
  {Feature_HasFlatGlobalInstsBit, },
  {Feature_HasFmaLegacy32Bit, },
  {Feature_HasFmaMixInstsBit, },
  {Feature_HasFmacF64InstBit, },
  {Feature_HasFormattedMUBUFInstsBit, },
  {Feature_HasGDSBit, },
  {Feature_HasGFX10_BEncodingBit, },
  {Feature_HasGFX950InstsBit, },
  {Feature_HasGetWaveIdInstBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, },
  {Feature_HasIntClampBit, },
  {Feature_HasLdsAtomicAddF64Bit, },
  {Feature_HasLshlAddU64InstBit, },
  {Feature_HasMAIInstsBit, },
  {Feature_HasMTBUFInstsBit, },
  {Feature_HasMadMacF32InstsBit, },
  {Feature_HasMinMaxDenormModesBit, },
  {Feature_HasMinimum3Maximum3F32Bit, },
  {Feature_HasMinimum3Maximum3PKF16Bit, },
  {Feature_HasPackedFP32OpsBit, },
  {Feature_HasPrngInstBit, },
  {Feature_HasPseudoScalarTransBit, },
  {Feature_HasSALUFloatInstsBit, },
  {Feature_HasSMemRealTimeBit, },
  {Feature_HasSMemTimeInstBit, },
  {Feature_HasSetPrioIncWgInstBit, },
  {Feature_HasShaderCyclesHiLoRegistersBit, },
  {Feature_HasShaderCyclesRegisterBit, },
  {Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasVOP3PInstsBit, },
  {Feature_HasXF32InstsBit, },
  {Feature_HasXNACKEnabledBit, },
  {Feature_IEEEModeDisabledBit, },
  {Feature_LDSRequiresM0InitBit, },
  {Feature_NotHasAddNoCarryInstsBit, },
  {Feature_NotHasTrue16BitInstsBit, },
  {Feature_NotLDSRequiresM0InitBit, },
  {Feature_UseFakeTrue16InstsBit, },
  {Feature_UseRealTrue16InstsBit, },
  {Feature_isGFX10OnlyBit, },
  {Feature_isGFX10PlusBit, },
  {Feature_isGFX11OnlyBit, },
  {Feature_isGFX11PlusBit, },
  {Feature_isGFX1250PlusBit, },
  {Feature_isGFX12OnlyBit, },
  {Feature_isGFX12PlusBit, },
  {Feature_isGFX12PlusNot12_50Bit, },
  {Feature_isGFX6Bit, },
  {Feature_isGFX6GFX7Bit, },
  {Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_isGFX7GFX8GFX9Bit, },
  {Feature_isGFX7OnlyBit, },
  {Feature_isGFX7PlusBit, },
  {Feature_isGFX8GFX9Bit, },
  {Feature_isGFX8GFX9GFX10GFX11Bit, },
  {Feature_isGFX8PlusBit, },
  {Feature_isGFX908orGFX90ABit, },
  {Feature_isGFX90APlusBit, },
  {Feature_isGFX940PlusBit, },
  {Feature_isGFX9GFX10Bit, },
  {Feature_isGFX9PlusBit, },
  {Feature_isNotGFX1250PlusBit, },
  {Feature_isNotGFX12PlusBit, },
  {Feature_isNotGFX90APlusBit, },
  {Feature_isNotGFX940PlusBit, },
  {Feature_isNotGFX9PlusBit, },
  {Feature_isWave32Bit, },
  {Feature_isWave64Bit, },
  {Feature_DisableFlatScratchBit, Feature_HasD16LoadStoreBit, },
  {Feature_DisableFlatScratchBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, },
  {Feature_FP16DenormalsBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_FalsePredicateBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_Has16BitInstsBit, Feature_HasIntClampBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8OnlyBit, },
  {Feature_Has16BitInstsBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasAddNoCarryInstsBit, Feature_HasIntClampBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16InstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasAtomicDsPkAdd16InstsBit, Feature_HasGDSBit, },
  {Feature_HasAtomicDsPkAdd16InstsBit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasAtomicDsPkAdd16InstsBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasAtomicFMinFMaxF32FlatInstsBit, Feature_HasFlatAddressSpaceBit, },
  {Feature_HasAtomicFMinFMaxF32FlatInstsBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFMinFMaxF64FlatInstsBit, Feature_HasFlatAddressSpaceBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFaddNoRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFaddRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasCvtFP8VOP1BugBit, Feature_HasFP8ConversionInstsBit, },
  {Feature_HasDot11InstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasDot9InstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasDot9InstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasDot9InstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasExportInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasSDWABit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX125xOnlyBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX12PlusNot12_50Bit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX940PlusBit, },
  {Feature_HasFP8InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_isGFX12PlusBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasFlatGlobalInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasFlatGlobalInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasFlatGlobalInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFmaMixInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasFmaMixInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasFmaMixInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasPackedD16VMemBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasUnpackedD16VMemBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasGDSBit, Feature_HasLDSFPAtomicAddF32Bit, },
  {Feature_HasGDSBit, Feature_isGFX11PlusBit, },
  {Feature_HasGDSBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_HasGFX950InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasImageInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasLDSFPAtomicAddF32Bit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasLDSFPAtomicAddF32Bit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasLdsBarrierArriveAtomicBit, Feature_isGFX1250PlusBit, },
  {Feature_HasMADIntraFwdBugBit, Feature_isGFX11OnlyBit, },
  {Feature_HasMAIInstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasPackedD16VMemBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasUnpackedD16VMemBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, },
  {Feature_HasMed3_16Bit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasMed3_16Bit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasMed3_16Bit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasMinMaxDenormModesBit, Feature_isGFX12PlusBit, },
  {Feature_HasMinMaxDenormModesBit, Feature_isNotGFX12PlusBit, },
  {Feature_HasNotMADIntraFwdBugBit, Feature_isGFX9PlusBit, },
  {Feature_HasScalarStoresBit, Feature_isGFX8PlusBit, },
  {Feature_HasTransposeLoadF4F6InstsBit, Feature_isWave32Bit, },
  {Feature_HasUnalignedAccessModeBit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasUnalignedAccessModeBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasVOP3PInstsBit, Feature_IEEEModeDisabledBit, },
  {Feature_HasVOP3PInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasVOP3PInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasVOP3PInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasXF32InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasXNACKEnabledBit, Feature_isGFX7OnlyBit, },
  {Feature_HasXNACKEnabledBit, Feature_isGFX9PlusBit, },
  {Feature_HasXNACKEnabledBit, Feature_isNotGFX9PlusBit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX10PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX8PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX9GFX10Bit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX9PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isNotGFX9PlusBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_UseRealTrue16InstsBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX10PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX1250PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX8PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX10PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX1250PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX8PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_has16BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_isGFX11OnlyBit, Feature_isWave32Bit, },
  {Feature_isGFX11OnlyBit, Feature_isWave64Bit, },
  {Feature_isGFX1250PlusBit, Feature_isWave32Bit, },
  {Feature_isGFX12PlusBit, Feature_isWave32Bit, },
  {Feature_isGFX12PlusBit, Feature_isWave64Bit, },
  {Feature_isGFX12PlusNot12_50Bit, Feature_isWave64Bit, },
  {Feature_isGFX90APlusBit, Feature_isGFX908orGFX90ABit, },
  {Feature_isGFX90APlusBit, Feature_isGFX940PlusBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_HasFlatAddressSpaceBit, Feature_UseRealTrue16InstsBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_HasFlatGlobalInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_DisableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_EnableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasFlatScratchInstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_FP64DenormalsBit, Feature_NotHasMinMaxDenormModesBit, Feature_isGFX12PlusBit, },
  {Feature_FP64DenormalsBit, Feature_NotHasMinMaxDenormModesBit, Feature_isNotGFX12PlusBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_UseRealTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_IEEEModeDisabledBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_IEEEModeDisabledBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_IEEEModeDisabledBit, Feature_UseRealTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX10OnlyBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX10PlusBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX1250PlusBit, },
  {Feature_Has16BitInstsBit, Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasNoCvtFP8VOP1BugBit, Feature_HasSDWABit, },
  {Feature_HasFP8ConversionInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX9PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_UseFakeTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasPackedD16VMemBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasPackedD16VMemBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, Feature_isGFX6GFX7GFX10Bit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasTransposeLoadF4F6InstsBit, Feature_isGFX1250PlusBit, Feature_isWave32Bit, },
  {Feature_EnableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, Feature_UseRealTrue16InstsBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_UseRealTrue16InstsBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_buf_soffset,
  GICP_gi_ds_128bit_8byte_aligned,
  GICP_gi_ds_1addr_1offset,
  GICP_gi_ds_64bit_4byte_aligned,
  GICP_gi_flat_offset,
  GICP_gi_flat_scratch_offset,
  GICP_gi_flat_scratch_saddr,
  GICP_gi_flat_scratch_svaddr,
  GICP_gi_global_offset,
  GICP_gi_global_saddr,
  GICP_gi_mubuf_addr64,
  GICP_gi_mubuf_offset,
  GICP_gi_mubuf_scratch_offen,
  GICP_gi_mubuf_scratch_offset,
  GICP_gi_smrd_buffer_imm,
  GICP_gi_smrd_buffer_imm32,
  GICP_gi_smrd_buffer_sgpr_imm,
  GICP_gi_smrd_imm,
  GICP_gi_smrd_imm32,
  GICP_gi_smrd_sgpr,
  GICP_gi_smrd_sgpr_imm,
  GICP_gi_swmmacindex16,
  GICP_gi_swmmacindex8,
  GICP_gi_vcsrc,
  GICP_gi_vinterpmods,
  GICP_gi_vinterpmods_hi,
  GICP_gi_vop3_mad_mix_mods,
  GICP_gi_vop3_mad_mix_mods_ext,
  GICP_gi_vop3_no_mods,
  GICP_gi_vop3mods,
  GICP_gi_vop3mods0,
  GICP_gi_vop3modsnoncanonicalizing,
  GICP_gi_vop3omods,
  GICP_gi_vop3opsel,
  GICP_gi_vop3opselmods,
  GICP_gi_vop3pmods,
  GICP_gi_vop3pmodsdot,
  GICP_gi_vop3pmodsneg,
  GICP_gi_vsrc0,
  GICP_gi_wmmamods,
  GICP_gi_wmmamodsf16Neg,
  GICP_gi_wmmamodsf16NegAbs,
  GICP_gi_wmmaopselvop3pmods,
  GICP_gi_wmmavisrc,
};
// See constructor for table contents

AMDGPUInstructionSelector::ComplexMatcherMemFn
AMDGPUInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &AMDGPUInstructionSelector::selectBUFSOffset, // gi_buf_soffset
  &AMDGPUInstructionSelector::selectDS128Bit8ByteAligned, // gi_ds_128bit_8byte_aligned
  &AMDGPUInstructionSelector::selectDS1Addr1Offset, // gi_ds_1addr_1offset
  &AMDGPUInstructionSelector::selectDS64Bit4ByteAligned, // gi_ds_64bit_4byte_aligned
  &AMDGPUInstructionSelector::selectFlatOffset, // gi_flat_offset
  &AMDGPUInstructionSelector::selectScratchOffset, // gi_flat_scratch_offset
  &AMDGPUInstructionSelector::selectScratchSAddr, // gi_flat_scratch_saddr
  &AMDGPUInstructionSelector::selectScratchSVAddr, // gi_flat_scratch_svaddr
  &AMDGPUInstructionSelector::selectGlobalOffset, // gi_global_offset
  &AMDGPUInstructionSelector::selectGlobalSAddr, // gi_global_saddr
  &AMDGPUInstructionSelector::selectMUBUFAddr64, // gi_mubuf_addr64
  &AMDGPUInstructionSelector::selectMUBUFOffset, // gi_mubuf_offset
  &AMDGPUInstructionSelector::selectMUBUFScratchOffen, // gi_mubuf_scratch_offen
  &AMDGPUInstructionSelector::selectMUBUFScratchOffset, // gi_mubuf_scratch_offset
  &AMDGPUInstructionSelector::selectSMRDBufferImm, // gi_smrd_buffer_imm
  &AMDGPUInstructionSelector::selectSMRDBufferImm32, // gi_smrd_buffer_imm32
  &AMDGPUInstructionSelector::selectSMRDBufferSgprImm, // gi_smrd_buffer_sgpr_imm
  &AMDGPUInstructionSelector::selectSmrdImm, // gi_smrd_imm
  &AMDGPUInstructionSelector::selectSmrdImm32, // gi_smrd_imm32
  &AMDGPUInstructionSelector::selectSmrdSgpr, // gi_smrd_sgpr
  &AMDGPUInstructionSelector::selectSmrdSgprImm, // gi_smrd_sgpr_imm
  &AMDGPUInstructionSelector::selectSWMMACIndex16, // gi_swmmacindex16
  &AMDGPUInstructionSelector::selectSWMMACIndex8, // gi_swmmacindex8
  &AMDGPUInstructionSelector::selectVCSRC, // gi_vcsrc
  &AMDGPUInstructionSelector::selectVINTERPMods, // gi_vinterpmods
  &AMDGPUInstructionSelector::selectVINTERPModsHi, // gi_vinterpmods_hi
  &AMDGPUInstructionSelector::selectVOP3PMadMixMods, // gi_vop3_mad_mix_mods
  &AMDGPUInstructionSelector::selectVOP3PMadMixModsExt, // gi_vop3_mad_mix_mods_ext
  &AMDGPUInstructionSelector::selectVOP3NoMods, // gi_vop3_no_mods
  &AMDGPUInstructionSelector::selectVOP3Mods, // gi_vop3mods
  &AMDGPUInstructionSelector::selectVOP3Mods0, // gi_vop3mods0
  &AMDGPUInstructionSelector::selectVOP3ModsNonCanonicalizing, // gi_vop3modsnoncanonicalizing
  &AMDGPUInstructionSelector::selectVOP3OMods, // gi_vop3omods
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opsel
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opselmods
  &AMDGPUInstructionSelector::selectVOP3PMods, // gi_vop3pmods
  &AMDGPUInstructionSelector::selectVOP3PModsDOT, // gi_vop3pmodsdot
  &AMDGPUInstructionSelector::selectVOP3PModsNeg, // gi_vop3pmodsneg
  &AMDGPUInstructionSelector::selectVSRC0, // gi_vsrc0
  &AMDGPUInstructionSelector::selectWMMAModsF32NegAbs, // gi_wmmamods
  &AMDGPUInstructionSelector::selectWMMAModsF16Neg, // gi_wmmamodsf16Neg
  &AMDGPUInstructionSelector::selectWMMAModsF16NegAbs, // gi_wmmamodsf16NegAbs
  &AMDGPUInstructionSelector::selectWMMAOpSelVOP3PMods, // gi_wmmaopselvop3pmods
  &AMDGPUInstructionSelector::selectWMMAVISrc, // gi_wmmavisrc
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_aligned_smrd_load = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_anonymous_13970,
  GICXXPred_MI_Predicate_anonymous_13973,
  GICXXPred_MI_Predicate_anonymous_13974,
  GICXXPred_MI_Predicate_anonymous_13975,
  GICXXPred_MI_Predicate_anonymous_13976,
  GICXXPred_MI_Predicate_anonymous_13977,
  GICXXPred_MI_Predicate_anonymous_13980,
  GICXXPred_MI_Predicate_anonymous_13981,
  GICXXPred_MI_Predicate_anonymous_13982,
  GICXXPred_MI_Predicate_anonymous_13983,
  GICXXPred_MI_Predicate_anonymous_13984,
  GICXXPred_MI_Predicate_anonymous_13985,
  GICXXPred_MI_Predicate_anonymous_13986,
  GICXXPred_MI_Predicate_anonymous_13987,
  GICXXPred_MI_Predicate_anonymous_13988,
  GICXXPred_MI_Predicate_anonymous_13989,
  GICXXPred_MI_Predicate_anonymous_13990,
  GICXXPred_MI_Predicate_anonymous_13991,
  GICXXPred_MI_Predicate_anonymous_13992,
  GICXXPred_MI_Predicate_anonymous_13993,
  GICXXPred_MI_Predicate_anonymous_13994,
  GICXXPred_MI_Predicate_anonymous_13995,
  GICXXPred_MI_Predicate_anonymous_13996,
  GICXXPred_MI_Predicate_anonymous_13997,
  GICXXPred_MI_Predicate_anonymous_13998,
  GICXXPred_MI_Predicate_anonymous_13999,
  GICXXPred_MI_Predicate_anonymous_14000,
  GICXXPred_MI_Predicate_anonymous_14001,
  GICXXPred_MI_Predicate_anonymous_14002,
  GICXXPred_MI_Predicate_anonymous_14003,
  GICXXPred_MI_Predicate_anonymous_14004,
  GICXXPred_MI_Predicate_anonymous_14005,
  GICXXPred_MI_Predicate_anonymous_14006,
  GICXXPred_MI_Predicate_anonymous_14007,
  GICXXPred_MI_Predicate_anonymous_14008,
  GICXXPred_MI_Predicate_anonymous_14009,
  GICXXPred_MI_Predicate_anonymous_14010,
  GICXXPred_MI_Predicate_anonymous_14011,
  GICXXPred_MI_Predicate_anonymous_14012,
  GICXXPred_MI_Predicate_anonymous_14013,
  GICXXPred_MI_Predicate_anonymous_14014,
  GICXXPred_MI_Predicate_anonymous_14015,
  GICXXPred_MI_Predicate_anonymous_14016,
  GICXXPred_MI_Predicate_anonymous_14017,
  GICXXPred_MI_Predicate_anonymous_14018,
  GICXXPred_MI_Predicate_anonymous_14019,
  GICXXPred_MI_Predicate_anonymous_14020,
  GICXXPred_MI_Predicate_anonymous_14021,
  GICXXPred_MI_Predicate_anonymous_14022,
  GICXXPred_MI_Predicate_anonymous_14023,
  GICXXPred_MI_Predicate_anonymous_14030,
  GICXXPred_MI_Predicate_anonymous_14042,
  GICXXPred_MI_Predicate_anonymous_18654,
  GICXXPred_MI_Predicate_anonymous_19769,
  GICXXPred_MI_Predicate_anonymous_19771,
  GICXXPred_MI_Predicate_anonymous_19775,
  GICXXPred_MI_Predicate_anonymous_19777,
  GICXXPred_MI_Predicate_anonymous_20176,
  GICXXPred_MI_Predicate_anonymous_20178,
  GICXXPred_MI_Predicate_anonymous_20180,
  GICXXPred_MI_Predicate_anonymous_20182,
  GICXXPred_MI_Predicate_anonymous_20184,
  GICXXPred_MI_Predicate_anonymous_20188,
  GICXXPred_MI_Predicate_anonymous_20190,
  GICXXPred_MI_Predicate_anonymous_20192,
  GICXXPred_MI_Predicate_anonymous_20194,
  GICXXPred_MI_Predicate_anonymous_20196,
  GICXXPred_MI_Predicate_anonymous_20459,
  GICXXPred_MI_Predicate_anonymous_20461,
  GICXXPred_MI_Predicate_anonymous_20704,
  GICXXPred_MI_Predicate_anonymous_20893,
  GICXXPred_MI_Predicate_anonymous_21435,
  GICXXPred_MI_Predicate_anonymous_21438,
  GICXXPred_MI_Predicate_anonymous_21441,
  GICXXPred_MI_Predicate_anonymous_21443,
  GICXXPred_MI_Predicate_anonymous_21446,
  GICXXPred_MI_Predicate_anonymous_21448,
  GICXXPred_MI_Predicate_anonymous_21451,
  GICXXPred_MI_Predicate_anonymous_21454,
  GICXXPred_MI_Predicate_anonymous_21458,
  GICXXPred_MI_Predicate_anonymous_21470,
  GICXXPred_MI_Predicate_anonymous_21903,
  GICXXPred_MI_Predicate_anonymous_22187,
  GICXXPred_MI_Predicate_anonymous_22190,
  GICXXPred_MI_Predicate_anonymous_22192,
  GICXXPred_MI_Predicate_anonymous_22194,
  GICXXPred_MI_Predicate_anonymous_22196,
  GICXXPred_MI_Predicate_anonymous_22198,
  GICXXPred_MI_Predicate_anonymous_22200,
  GICXXPred_MI_Predicate_anonymous_23942,
  GICXXPred_MI_Predicate_anonymous_23944,
  GICXXPred_MI_Predicate_anonymous_23948,
  GICXXPred_MI_Predicate_anonymous_23950,
  GICXXPred_MI_Predicate_anonymous_23952,
  GICXXPred_MI_Predicate_anonymous_23954,
  GICXXPred_MI_Predicate_anonymous_23958,
  GICXXPred_MI_Predicate_anonymous_23960,
  GICXXPred_MI_Predicate_anonymous_23962,
  GICXXPred_MI_Predicate_anonymous_23964,
  GICXXPred_MI_Predicate_anonymous_23966,
  GICXXPred_MI_Predicate_anonymous_23968,
  GICXXPred_MI_Predicate_anonymous_23970,
  GICXXPred_MI_Predicate_anonymous_23972,
  GICXXPred_MI_Predicate_anonymous_23976,
  GICXXPred_MI_Predicate_anonymous_23978,
  GICXXPred_MI_Predicate_anonymous_23980,
  GICXXPred_MI_Predicate_anonymous_23982,
  GICXXPred_MI_Predicate_anonymous_23986,
  GICXXPred_MI_Predicate_anonymous_23988,
  GICXXPred_MI_Predicate_anonymous_23992,
  GICXXPred_MI_Predicate_anonymous_23994,
  GICXXPred_MI_Predicate_anonymous_23996,
  GICXXPred_MI_Predicate_anonymous_23998,
  GICXXPred_MI_Predicate_anonymous_24002,
  GICXXPred_MI_Predicate_anonymous_24004,
  GICXXPred_MI_Predicate_anonymous_24006,
  GICXXPred_MI_Predicate_anonymous_24008,
  GICXXPred_MI_Predicate_anonymous_24010,
  GICXXPred_MI_Predicate_anonymous_24012,
  GICXXPred_MI_Predicate_anonymous_24014,
  GICXXPred_MI_Predicate_anonymous_24016,
  GICXXPred_MI_Predicate_anonymous_24020,
  GICXXPred_MI_Predicate_anonymous_24022,
  GICXXPred_MI_Predicate_anonymous_24024,
  GICXXPred_MI_Predicate_anonymous_24026,
  GICXXPred_MI_Predicate_anonymous_24030,
  GICXXPred_MI_Predicate_anonymous_24032,
  GICXXPred_MI_Predicate_anonymous_24034,
  GICXXPred_MI_Predicate_anonymous_24036,
  GICXXPred_MI_Predicate_anonymous_24038,
  GICXXPred_MI_Predicate_anonymous_24040,
  GICXXPred_MI_Predicate_anonymous_24044,
  GICXXPred_MI_Predicate_anonymous_24046,
  GICXXPred_MI_Predicate_anonymous_24048,
  GICXXPred_MI_Predicate_anonymous_24050,
  GICXXPred_MI_Predicate_anonymous_24052,
  GICXXPred_MI_Predicate_anonymous_24054,
  GICXXPred_MI_Predicate_anonymous_24058,
  GICXXPred_MI_Predicate_anonymous_24060,
  GICXXPred_MI_Predicate_anonymous_24064,
  GICXXPred_MI_Predicate_anonymous_24066,
  GICXXPred_MI_Predicate_anonymous_24068,
  GICXXPred_MI_Predicate_anonymous_24070,
  GICXXPred_MI_Predicate_anonymous_24090,
  GICXXPred_MI_Predicate_anonymous_24092,
  GICXXPred_MI_Predicate_anonymous_24126,
  GICXXPred_MI_Predicate_anonymous_24128,
  GICXXPred_MI_Predicate_anonymous_24148,
  GICXXPred_MI_Predicate_anonymous_24150,
  GICXXPred_MI_Predicate_anonymous_24188,
  GICXXPred_MI_Predicate_anonymous_24190,
  GICXXPred_MI_Predicate_anonymous_24194,
  GICXXPred_MI_Predicate_anonymous_24196,
  GICXXPred_MI_Predicate_anonymous_24198,
  GICXXPred_MI_Predicate_anonymous_24200,
  GICXXPred_MI_Predicate_anonymous_24202,
  GICXXPred_MI_Predicate_anonymous_24204,
  GICXXPred_MI_Predicate_anonymous_24206,
  GICXXPred_MI_Predicate_anonymous_24208,
  GICXXPred_MI_Predicate_anonymous_24212,
  GICXXPred_MI_Predicate_anonymous_24214,
  GICXXPred_MI_Predicate_anonymous_24216,
  GICXXPred_MI_Predicate_anonymous_24218,
  GICXXPred_MI_Predicate_anonymous_24222,
  GICXXPred_MI_Predicate_anonymous_24224,
  GICXXPred_MI_Predicate_anonymous_24226,
  GICXXPred_MI_Predicate_anonymous_24228,
  GICXXPred_MI_Predicate_anonymous_24230,
  GICXXPred_MI_Predicate_anonymous_24232,
  GICXXPred_MI_Predicate_anonymous_24236,
  GICXXPred_MI_Predicate_anonymous_24238,
  GICXXPred_MI_Predicate_anonymous_24240,
  GICXXPred_MI_Predicate_anonymous_24242,
  GICXXPred_MI_Predicate_anonymous_24244,
  GICXXPred_MI_Predicate_anonymous_24246,
  GICXXPred_MI_Predicate_anonymous_24248,
  GICXXPred_MI_Predicate_anonymous_24250,
  GICXXPred_MI_Predicate_anonymous_24252,
  GICXXPred_MI_Predicate_anonymous_24254,
  GICXXPred_MI_Predicate_anonymous_24258,
  GICXXPred_MI_Predicate_anonymous_24260,
  GICXXPred_MI_Predicate_anonymous_24262,
  GICXXPred_MI_Predicate_anonymous_24264,
  GICXXPred_MI_Predicate_anonymous_24266,
  GICXXPred_MI_Predicate_anonymous_24268,
  GICXXPred_MI_Predicate_anonymous_24270,
  GICXXPred_MI_Predicate_anonymous_24272,
  GICXXPred_MI_Predicate_anonymous_35534,
  GICXXPred_MI_Predicate_anonymous_35539,
  GICXXPred_MI_Predicate_anonymous_35541,
  GICXXPred_MI_Predicate_anonymous_35988,
  GICXXPred_MI_Predicate_anonymous_35990,
  GICXXPred_MI_Predicate_anonymous_36043,
  GICXXPred_MI_Predicate_anonymous_36058,
  GICXXPred_MI_Predicate_anonymous_36059,
  GICXXPred_MI_Predicate_anonymous_36062,
  GICXXPred_MI_Predicate_anonymous_36065,
  GICXXPred_MI_Predicate_anonymous_36068,
  GICXXPred_MI_Predicate_anonymous_36072,
  GICXXPred_MI_Predicate_anonymous_36075,
  GICXXPred_MI_Predicate_anonymous_36078,
  GICXXPred_MI_Predicate_anonymous_36080,
  GICXXPred_MI_Predicate_anonymous_36081,
  GICXXPred_MI_Predicate_anonymous_36090,
  GICXXPred_MI_Predicate_anonymous_36092,
  GICXXPred_MI_Predicate_anonymous_36100,
  GICXXPred_MI_Predicate_anonymous_36105,
  GICXXPred_MI_Predicate_anonymous_36109,
  GICXXPred_MI_Predicate_anonymous_36113,
  GICXXPred_MI_Predicate_anonymous_36123,
  GICXXPred_MI_Predicate_anonymous_36280,
  GICXXPred_MI_Predicate_anonymous_36283,
  GICXXPred_MI_Predicate_anonymous_36294,
  GICXXPred_MI_Predicate_anonymous_36361,
  GICXXPred_MI_Predicate_anonymous_36363,
  GICXXPred_MI_Predicate_anonymous_36426,
  GICXXPred_MI_Predicate_anonymous_36454,
  GICXXPred_MI_Predicate_anonymous_36456,
  GICXXPred_MI_Predicate_anonymous_36485,
  GICXXPred_MI_Predicate_anonymous_36487,
  GICXXPred_MI_Predicate_anonymous_36489,
  GICXXPred_MI_Predicate_anonymous_36491,
  GICXXPred_MI_Predicate_anonymous_36493,
  GICXXPred_MI_Predicate_anonymous_36523,
  GICXXPred_MI_Predicate_anonymous_36525,
  GICXXPred_MI_Predicate_bf16_fpround,
  GICXXPred_MI_Predicate_csh_mask_16,
  GICXXPred_MI_Predicate_csh_mask_32,
  GICXXPred_MI_Predicate_csh_mask_64,
  GICXXPred_MI_Predicate_fmaxnum_like_nnan,
  GICXXPred_MI_Predicate_fminnum_like_nnan,
  GICXXPred_MI_Predicate_is_canonicalized,
  GICXXPred_MI_Predicate_load_align_less_than_4_local,
  GICXXPred_MI_Predicate_load_align_less_than_4_local_m0,
  GICXXPred_MI_Predicate_or_disjoint,
  GICXXPred_MI_Predicate_shl1_add,
  GICXXPred_MI_Predicate_shl2_add,
  GICXXPred_MI_Predicate_shl3_add,
  GICXXPred_MI_Predicate_shl4_add,
  GICXXPred_MI_Predicate_shl_0_to_4,
  GICXXPred_MI_Predicate_smrd_extloadi8,
  GICXXPred_MI_Predicate_smrd_extloadi16,
  GICXXPred_MI_Predicate_smrd_load,
  GICXXPred_MI_Predicate_smrd_prefetch,
  GICXXPred_MI_Predicate_smrd_sextloadi8,
  GICXXPred_MI_Predicate_smrd_sextloadi16,
  GICXXPred_MI_Predicate_smrd_zextloadi8,
  GICXXPred_MI_Predicate_smrd_zextloadi16,
  GICXXPred_MI_Predicate_store_align_less_than_4_local,
  GICXXPred_MI_Predicate_store_align_less_than_4_local_m0,
};
bool AMDGPUInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_aligned_smrd_load: {
    
      auto &Ld = cast<GLoad>(MI);
      TypeSize Size = Ld.getMMO().getSize().getValue();
      return Size <= 4 || Ld.getMMO().getAlign().value() >= Size;
      
    llvm_unreachable("aligned_smrd_load should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_13970: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13973: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13974: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13975: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13976: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13977: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13980: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13981: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13982: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13983: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13984: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13985: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13986: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13987: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13988: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13989: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13990: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13991: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13992: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13993: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13994: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13995: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13996: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13997: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13998: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_13999: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14000: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14001: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14002: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14003: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14004: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14005: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14006: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14007: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14008: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14009: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14010: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14011: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14012: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14013: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14014: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14015: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14016: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14017: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14018: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14019: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14020: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14021: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14022: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14023: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14030: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14042: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_18654: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19769: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19771: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19775: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19777: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20176: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20178: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20180: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20182: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20184: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20188: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20190: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20192: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20194: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20196: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20459: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20461: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20704: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20893: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21435: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_21435 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_21438: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_21438 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_21441: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_21441 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_21443: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_21443 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_21446: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_21446 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_21448: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_21448 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_21451: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_21451 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_21454: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_21454 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_21458: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_21458 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_21470: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_21470 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_21903: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_21903 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_22187: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22190: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22192: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22194: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22196: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22198: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22200: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23942: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23944: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23948: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23950: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23952: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23954: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23958: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23960: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23962: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23964: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23966: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23968: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23970: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23972: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23976: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23978: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23980: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23982: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23986: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23988: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23992: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23994: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23996: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_23998: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24002: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24004: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24006: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24008: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24010: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24012: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24014: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24016: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24020: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24022: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24024: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24026: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24030: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24032: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24034: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24036: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24038: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24040: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24044: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24046: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24048: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24050: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24052: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24054: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24058: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24060: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24064: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24066: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24068: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24070: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24090: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24092: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24126: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24128: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24148: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24150: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24188: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24190: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24194: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24196: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24198: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24200: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24202: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24204: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24206: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24208: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24212: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24214: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24216: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24218: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24222: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24224: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24226: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24228: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24230: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24232: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24236: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24238: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24240: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24242: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24244: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24246: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24248: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24250: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24252: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24254: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24258: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24260: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24262: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24264: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24266: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24268: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24270: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_24272: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_35534: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_35539: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_35541: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_35988: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_35990: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36043: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36058: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36059: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36062: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36065: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36068: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36072: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36075: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36078: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36080: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36081: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36090: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36092: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36100: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36105: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36109: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36113: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36123: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36280: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36283: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36294: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36361: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36363: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36426: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
          MF.getSubtarget().getTargetLowering());
    
        return TLI->isCanonicalized(MI.getOperand(1).getReg(), MF) &&
          TLI->isCanonicalized(MI.getOperand(2).getReg(), MF);
      
    llvm_unreachable("anonymous_36426 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_36454: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36456: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36485: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
          MF.getSubtarget().getTargetLowering());
    
        return TLI->isCanonicalized(MI.getOperand(1).getReg(), MF);
      
    llvm_unreachable("anonymous_36485 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_36487: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36489: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36491: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36493: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36523: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_36525: {
    return true;
  }
  case GICXXPred_MI_Predicate_bf16_fpround: {
    return false;
  }
  case GICXXPred_MI_Predicate_csh_mask_16: {
     return isUnneededShiftMask(MI, 4); 
  }
  case GICXXPred_MI_Predicate_csh_mask_32: {
     return isUnneededShiftMask(MI, 5); 
  }
  case GICXXPred_MI_Predicate_csh_mask_64: {
     return isUnneededShiftMask(MI, 6); 
  }
  case GICXXPred_MI_Predicate_fmaxnum_like_nnan: {
    
        return isKnownNeverNaN(MI.getOperand(0).getReg(), MRI);
      
  }
  case GICXXPred_MI_Predicate_fminnum_like_nnan: {
    
        return isKnownNeverNaN(MI.getOperand(0).getReg(), MRI);
      
  }
  case GICXXPred_MI_Predicate_is_canonicalized: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
            MF.getSubtarget().getTargetLowering());
        const MachineOperand &Dst = MI.getOperand(0);
        assert(Dst.isDef());
        return TLI->isCanonicalized(Dst.getReg(), MF);
       
    llvm_unreachable("is_canonicalized should have returned");
  }
  case GICXXPred_MI_Predicate_load_align_less_than_4_local: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_load_align_less_than_4_local_m0: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_or_disjoint: {
    
        return MI.getFlag(MachineInstr::Disjoint);
      
  }
  case GICXXPred_MI_Predicate_shl1_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl2_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl3_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl4_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl_0_to_4: {
    
        int64_t Imm = 0;
        if (!mi_match(MI.getOperand(2).getReg(), MRI, m_ICst(Imm)) &&
            !mi_match(MI.getOperand(2).getReg(), MRI, m_Copy(m_ICst(Imm))))
          return false;
        return (uint64_t)Imm <= 4;
      
    llvm_unreachable("shl_0_to_4 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_extloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_extloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_extloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_extloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_load: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_load should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_prefetch: {
    
        return isInstrUniform(MI);
      
  }
  case GICXXPred_MI_Predicate_smrd_sextloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_sextloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_sextloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_sextloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_zextloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_zextloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_zextloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_zextloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_store_align_less_than_4_local: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_store_align_less_than_4_local_m0: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool AMDGPUInstructionSelector::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  const auto &Operands = State.RecordedOperands;
  Register Reg = MO.getReg();
  (void)Operands;
  (void)Reg;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_MFMALdScaleModifierOp,
  GICXXPred_I64_Predicate_NegSubInlineConst32,
  GICXXPred_I64_Predicate_NegSubInlineIntConst16,
  GICXXPred_I64_Predicate_SIMM16bit,
  GICXXPred_I64_Predicate_ShiftAmt32Imm,
  GICXXPred_I64_Predicate_SupportedRoundMode,
  GICXXPred_I64_Predicate_i32imm_one,
  GICXXPred_I64_Predicate_i32imm_zero,
  GICXXPred_I64_Predicate_i64imm_32bit,
};
bool AMDGPUInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask: {
    
      return isMask_32(Imm);
    
  }
  case GICXXPred_I64_Predicate_MFMALdScaleModifierOp: {
    
      return isUInt<2>(Imm);
    
  }
  case GICXXPred_I64_Predicate_NegSubInlineConst32: {
    
      return Imm < -16 && Imm >= -64;
    
  }
  case GICXXPred_I64_Predicate_NegSubInlineIntConst16: {
    
      return Imm < -16 && Imm >= -64;
    
  }
  case GICXXPred_I64_Predicate_SIMM16bit: {
    return isInt<16>(Imm) || isUInt<16>(Imm);
  }
  case GICXXPred_I64_Predicate_ShiftAmt32Imm: {
    
      return Imm < 32;
    
  }
  case GICXXPred_I64_Predicate_SupportedRoundMode: {
    
      return Imm == (int)RoundingMode::TowardZero ||
             Imm == (int)RoundingMode::NearestTiesToEven ||
             Imm == (int)RoundingMode::TowardPositive ||
             Imm == (int)RoundingMode::TowardNegative;
    
  }
  case GICXXPred_I64_Predicate_i32imm_one: {
    
      return Imm == 1;
    
  }
  case GICXXPred_I64_Predicate_i32imm_zero: {
    
      return Imm == 0;
    
  }
  case GICXXPred_I64_Predicate_i64imm_32bit: {
    
      return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_InlineImmFP32 = GICXXPred_Invalid + 1,
  GICXXPred_APFloat_Predicate_InlineImmFP64,
  GICXXPred_APFloat_Predicate_fpimm_neg_pow2_prefer_ldexp_f64,
  GICXXPred_APFloat_Predicate_fpimm_pos_pow2_prefer_ldexp_f64,
};
bool AMDGPUInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_InlineImmFP32: {
    
      return isInlineImmediate(Imm);
    
  }
  case GICXXPred_APFloat_Predicate_InlineImmFP64: {
    
      return isInlineImmediate(Imm);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm_neg_pow2_prefer_ldexp_f64: {
    
        if (!Imm.isNegative())
          return false;
        int Exp = Imm.getExactLog2Abs();
        // Prefer leaving the FP inline immediates as they are.
        // 0.5, 1.0, 2.0, 4.0
    
        // For f64 ldexp is always better than materializing a 64-bit
        // constant.
        return Exp != INT_MIN && (Exp < -1 || Exp > 2);
      
    llvm_unreachable("fpimm_neg_pow2_prefer_ldexp_f64 should have returned");
  }
  case GICXXPred_APFloat_Predicate_fpimm_pos_pow2_prefer_ldexp_f64: {
    
        if (Imm.isNegative())
          return false;
    
        int Exp = Imm.getExactLog2Abs();
        // Prefer leaving the FP inline immediates as they are.
        // 0.5, 1.0, 2.0, 4.0
    
        // For f64 ldexp is always better than materializing a 64-bit
        // constant.
        return Exp != INT_MIN && (Exp < -1 || Exp > 2);
      
    llvm_unreachable("fpimm_pos_pow2_prefer_ldexp_f64 should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_InlineImm64 = GICXXPred_Invalid + 1,
};
bool AMDGPUInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_InlineImm64: {
    
      return isInlineImmediate(Imm);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("AMDGPUInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderBitcastFPImm32,
  GICR_renderBitcastFPImm64,
  GICR_renderDstSelToOpSel3XFormXForm,
  GICR_renderDstSelToOpSelXForm,
  GICR_renderExtractCPol,
  GICR_renderExtractCpolSetGLC,
  GICR_renderExtractSWZ,
  GICR_renderFPPow2ToExponent,
  GICR_renderFrameIndex,
  GICR_renderNegateImm,
  GICR_renderOpSelTImm,
  GICR_renderPopcntImm,
  GICR_renderRoundMode,
  GICR_renderScaledMAIIntrinsicOperand,
  GICR_renderSrcAndDstSelToOpSelXForm_0_0,
  GICR_renderSrcAndDstSelToOpSelXForm_0_1,
  GICR_renderSrcAndDstSelToOpSelXForm_1_0,
  GICR_renderSrcAndDstSelToOpSelXForm_1_1,
  GICR_renderSrcAndDstSelToOpSelXForm_2_0,
  GICR_renderSrcSelToOpSelXForm,
  GICR_renderTruncTImm,
  GICR_renderZextBoolTImm,
};
AMDGPUInstructionSelector::CustomRendererFn
AMDGPUInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &AMDGPUInstructionSelector::renderBitcastFPImm32,
  &AMDGPUInstructionSelector::renderBitcastFPImm64,
  &AMDGPUInstructionSelector::renderDstSelToOpSel3XFormXForm,
  &AMDGPUInstructionSelector::renderDstSelToOpSelXForm,
  &AMDGPUInstructionSelector::renderExtractCPol,
  &AMDGPUInstructionSelector::renderExtractCpolSetGLC,
  &AMDGPUInstructionSelector::renderExtractSWZ,
  &AMDGPUInstructionSelector::renderFPPow2ToExponent,
  &AMDGPUInstructionSelector::renderFrameIndex,
  &AMDGPUInstructionSelector::renderNegateImm,
  &AMDGPUInstructionSelector::renderOpSelTImm,
  &AMDGPUInstructionSelector::renderPopcntImm,
  &AMDGPUInstructionSelector::renderRoundMode,
  &AMDGPUInstructionSelector::renderScaledMAIIntrinsicOperand,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_0_0,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_0_1,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_1_0,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_1_1,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_2_0,
  &AMDGPUInstructionSelector::renderSrcSelToOpSelXForm,
  &AMDGPUInstructionSelector::renderTruncTImm,
  &AMDGPUInstructionSelector::renderZextBoolTImm,
};

bool AMDGPUInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool AMDGPUInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("AMDGPUInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *AMDGPUInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*      0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(3710), /*)*//*default:*//*Label 169*/ GIMT_Encode4(787781),
     /*     10 */ /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(14638),
     /*     14 */ /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(37880),
     /*     18 */ /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(38503), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     46 */ /*TargetOpcode::G_AND*//*Label 3*/ GIMT_Encode4(38908),
     /*     50 */ /*TargetOpcode::G_OR*//*Label 4*/ GIMT_Encode4(40309),
     /*     54 */ /*TargetOpcode::G_XOR*//*Label 5*/ GIMT_Encode4(55821), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     74 */ /*TargetOpcode::G_FRAME_INDEX*//*Label 6*/ GIMT_Encode4(60688), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    106 */ /*TargetOpcode::G_BUILD_VECTOR*//*Label 7*/ GIMT_Encode4(60743), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    126 */ /*TargetOpcode::G_BITCAST*//*Label 8*/ GIMT_Encode4(65941), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    138 */ /*TargetOpcode::G_INTRINSIC_FPTRUNC_ROUND*//*Label 9*/ GIMT_Encode4(75105),
     /*    142 */ /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ GIMT_Encode4(75300), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    158 */ /*TargetOpcode::G_INTRINSIC_ROUNDEVEN*//*Label 11*/ GIMT_Encode4(75628),
     /*    162 */ /*TargetOpcode::G_READCYCLECOUNTER*//*Label 12*/ GIMT_Encode4(75956),
     /*    166 */ /*TargetOpcode::G_READSTEADYCOUNTER*//*Label 13*/ GIMT_Encode4(76096),
     /*    170 */ /*TargetOpcode::G_LOAD*//*Label 14*/ GIMT_Encode4(76154),
     /*    174 */ /*TargetOpcode::G_SEXTLOAD*//*Label 15*/ GIMT_Encode4(144694),
     /*    178 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 16*/ GIMT_Encode4(152156), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    194 */ /*TargetOpcode::G_STORE*//*Label 17*/ GIMT_Encode4(160026), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    206 */ /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 18*/ GIMT_Encode4(194651),
     /*    210 */ /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 19*/ GIMT_Encode4(195777),
     /*    214 */ /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 20*/ GIMT_Encode4(197989),
     /*    218 */ /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 21*/ GIMT_Encode4(200501),
     /*    222 */ /*TargetOpcode::G_ATOMICRMW_AND*//*Label 22*/ GIMT_Encode4(203013), GIMT_Encode4(0),
     /*    230 */ /*TargetOpcode::G_ATOMICRMW_OR*//*Label 23*/ GIMT_Encode4(205525),
     /*    234 */ /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 24*/ GIMT_Encode4(208037),
     /*    238 */ /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 25*/ GIMT_Encode4(210549),
     /*    242 */ /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 26*/ GIMT_Encode4(213061),
     /*    246 */ /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 27*/ GIMT_Encode4(215573),
     /*    250 */ /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 28*/ GIMT_Encode4(218085),
     /*    254 */ /*TargetOpcode::G_ATOMICRMW_FADD*//*Label 29*/ GIMT_Encode4(220597), GIMT_Encode4(0),
     /*    262 */ /*TargetOpcode::G_ATOMICRMW_FMAX*//*Label 30*/ GIMT_Encode4(222808),
     /*    266 */ /*TargetOpcode::G_ATOMICRMW_FMIN*//*Label 31*/ GIMT_Encode4(225454), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    278 */ /*TargetOpcode::G_ATOMICRMW_UINC_WRAP*//*Label 32*/ GIMT_Encode4(228100),
     /*    282 */ /*TargetOpcode::G_ATOMICRMW_UDEC_WRAP*//*Label 33*/ GIMT_Encode4(230612), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    294 */ /*TargetOpcode::G_FENCE*//*Label 34*/ GIMT_Encode4(233124),
     /*    298 */ /*TargetOpcode::G_PREFETCH*//*Label 35*/ GIMT_Encode4(233143), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    314 */ /*TargetOpcode::G_INTRINSIC*//*Label 36*/ GIMT_Encode4(233579),
     /*    318 */ /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 37*/ GIMT_Encode4(251720),
     /*    322 */ /*TargetOpcode::G_INTRINSIC_CONVERGENT*//*Label 38*/ GIMT_Encode4(256540),
     /*    326 */ /*TargetOpcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS*//*Label 39*/ GIMT_Encode4(281725),
     /*    330 */ /*TargetOpcode::G_ANYEXT*//*Label 40*/ GIMT_Encode4(283797),
     /*    334 */ /*TargetOpcode::G_TRUNC*//*Label 41*/ GIMT_Encode4(284451), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    350 */ /*TargetOpcode::G_CONSTANT*//*Label 42*/ GIMT_Encode4(284691),
     /*    354 */ /*TargetOpcode::G_FCONSTANT*//*Label 43*/ GIMT_Encode4(285417), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    366 */ /*TargetOpcode::G_SEXT*//*Label 44*/ GIMT_Encode4(285705), GIMT_Encode4(0),
     /*    374 */ /*TargetOpcode::G_ZEXT*//*Label 45*/ GIMT_Encode4(287140),
     /*    378 */ /*TargetOpcode::G_SHL*//*Label 46*/ GIMT_Encode4(290343),
     /*    382 */ /*TargetOpcode::G_LSHR*//*Label 47*/ GIMT_Encode4(292027),
     /*    386 */ /*TargetOpcode::G_ASHR*//*Label 48*/ GIMT_Encode4(293337), GIMT_Encode4(0),
     /*    394 */ /*TargetOpcode::G_FSHR*//*Label 49*/ GIMT_Encode4(294647),
     /*    398 */ /*TargetOpcode::G_ROTR*//*Label 50*/ GIMT_Encode4(294945), GIMT_Encode4(0),
     /*    406 */ /*TargetOpcode::G_ICMP*//*Label 51*/ GIMT_Encode4(295058),
     /*    410 */ /*TargetOpcode::G_FCMP*//*Label 52*/ GIMT_Encode4(296650), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    422 */ /*TargetOpcode::G_SELECT*//*Label 53*/ GIMT_Encode4(300813), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    466 */ /*TargetOpcode::G_UMULH*//*Label 54*/ GIMT_Encode4(301157),
     /*    470 */ /*TargetOpcode::G_SMULH*//*Label 55*/ GIMT_Encode4(301266),
     /*    474 */ /*TargetOpcode::G_UADDSAT*//*Label 56*/ GIMT_Encode4(301375),
     /*    478 */ /*TargetOpcode::G_SADDSAT*//*Label 57*/ GIMT_Encode4(301763),
     /*    482 */ /*TargetOpcode::G_USUBSAT*//*Label 58*/ GIMT_Encode4(302089),
     /*    486 */ /*TargetOpcode::G_SSUBSAT*//*Label 59*/ GIMT_Encode4(302477), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    530 */ /*TargetOpcode::G_FADD*//*Label 60*/ GIMT_Encode4(302803),
     /*    534 */ /*TargetOpcode::G_FSUB*//*Label 61*/ GIMT_Encode4(304161),
     /*    538 */ /*TargetOpcode::G_FMUL*//*Label 62*/ GIMT_Encode4(304525),
     /*    542 */ /*TargetOpcode::G_FMA*//*Label 63*/ GIMT_Encode4(305911),
     /*    546 */ /*TargetOpcode::G_FMAD*//*Label 64*/ GIMT_Encode4(307780), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    558 */ /*TargetOpcode::G_FPOW*//*Label 65*/ GIMT_Encode4(308726), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    570 */ /*TargetOpcode::G_FEXP2*//*Label 66*/ GIMT_Encode4(308844), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    582 */ /*TargetOpcode::G_FLOG2*//*Label 67*/ GIMT_Encode4(309067), GIMT_Encode4(0),
     /*    590 */ /*TargetOpcode::G_FLDEXP*//*Label 68*/ GIMT_Encode4(309290), GIMT_Encode4(0),
     /*    598 */ /*TargetOpcode::G_FNEG*//*Label 69*/ GIMT_Encode4(309653),
     /*    602 */ /*TargetOpcode::G_FPEXT*//*Label 70*/ GIMT_Encode4(311516),
     /*    606 */ /*TargetOpcode::G_FPTRUNC*//*Label 71*/ GIMT_Encode4(311916),
     /*    610 */ /*TargetOpcode::G_FPTOSI*//*Label 72*/ GIMT_Encode4(312852),
     /*    614 */ /*TargetOpcode::G_FPTOUI*//*Label 73*/ GIMT_Encode4(313578),
     /*    618 */ /*TargetOpcode::G_SITOFP*//*Label 74*/ GIMT_Encode4(314304),
     /*    622 */ /*TargetOpcode::G_UITOFP*//*Label 75*/ GIMT_Encode4(315037), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    634 */ /*TargetOpcode::G_FABS*//*Label 76*/ GIMT_Encode4(315770),
     /*    638 */ /*TargetOpcode::G_FCOPYSIGN*//*Label 77*/ GIMT_Encode4(316571),
     /*    642 */ /*TargetOpcode::G_IS_FPCLASS*//*Label 78*/ GIMT_Encode4(316996),
     /*    646 */ /*TargetOpcode::G_FCANONICALIZE*//*Label 79*/ GIMT_Encode4(317327),
     /*    650 */ /*TargetOpcode::G_FMINNUM*//*Label 80*/ GIMT_Encode4(318795),
     /*    654 */ /*TargetOpcode::G_FMAXNUM*//*Label 81*/ GIMT_Encode4(390574),
     /*    658 */ /*TargetOpcode::G_FMINNUM_IEEE*//*Label 82*/ GIMT_Encode4(462353),
     /*    662 */ /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 83*/ GIMT_Encode4(534132),
     /*    666 */ /*TargetOpcode::G_FMINIMUM*//*Label 84*/ GIMT_Encode4(605911),
     /*    670 */ /*TargetOpcode::G_FMAXIMUM*//*Label 85*/ GIMT_Encode4(608026),
     /*    674 */ /*TargetOpcode::G_FMINIMUMNUM*//*Label 86*/ GIMT_Encode4(610141),
     /*    678 */ /*TargetOpcode::G_FMAXIMUMNUM*//*Label 87*/ GIMT_Encode4(610569), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    694 */ /*TargetOpcode::G_GET_FPMODE*//*Label 88*/ GIMT_Encode4(610997), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    710 */ /*TargetOpcode::G_PTR_ADD*//*Label 89*/ GIMT_Encode4(611121), GIMT_Encode4(0),
     /*    718 */ /*TargetOpcode::G_SMIN*//*Label 90*/ GIMT_Encode4(611198),
     /*    722 */ /*TargetOpcode::G_SMAX*//*Label 91*/ GIMT_Encode4(617621),
     /*    726 */ /*TargetOpcode::G_UMIN*//*Label 92*/ GIMT_Encode4(624206),
     /*    730 */ /*TargetOpcode::G_UMAX*//*Label 93*/ GIMT_Encode4(630629),
     /*    734 */ /*TargetOpcode::G_ABS*//*Label 94*/ GIMT_Encode4(637052), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    746 */ /*TargetOpcode::G_BR*//*Label 95*/ GIMT_Encode4(637189), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    794 */ /*TargetOpcode::G_CTTZ_ZERO_UNDEF*//*Label 96*/ GIMT_Encode4(637223), GIMT_Encode4(0),
     /*    802 */ /*TargetOpcode::G_CTLZ_ZERO_UNDEF*//*Label 97*/ GIMT_Encode4(637322),
     /*    806 */ /*TargetOpcode::G_CTPOP*//*Label 98*/ GIMT_Encode4(637424),
     /*    810 */ /*TargetOpcode::G_BSWAP*//*Label 99*/ GIMT_Encode4(637639),
     /*    814 */ /*TargetOpcode::G_BITREVERSE*//*Label 100*/ GIMT_Encode4(639388),
     /*    818 */ /*TargetOpcode::G_FCEIL*//*Label 101*/ GIMT_Encode4(639636), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    866 */ /*TargetOpcode::G_FSQRT*//*Label 102*/ GIMT_Encode4(639964),
     /*    870 */ /*TargetOpcode::G_FFLOOR*//*Label 103*/ GIMT_Encode4(640256), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    906 */ /*TargetOpcode::G_STRICT_FADD*//*Label 104*/ GIMT_Encode4(640770),
     /*    910 */ /*TargetOpcode::G_STRICT_FSUB*//*Label 105*/ GIMT_Encode4(641732),
     /*    914 */ /*TargetOpcode::G_STRICT_FMUL*//*Label 106*/ GIMT_Encode4(642096), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    926 */ /*TargetOpcode::G_STRICT_FMA*//*Label 107*/ GIMT_Encode4(643364), GIMT_Encode4(0),
     /*    934 */ /*TargetOpcode::G_STRICT_FLDEXP*//*Label 108*/ GIMT_Encode4(644410), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  14338 */ /*AMDGPU::G_AMDGPU_ATOMIC_CMPXCHG*//*Label 109*/ GIMT_Encode4(644773),
     /*  14342 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_ADD*//*Label 110*/ GIMT_Encode4(647077),
     /*  14346 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_AND*//*Label 111*/ GIMT_Encode4(649461),
     /*  14350 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_CMPSWAP*//*Label 112*/ GIMT_Encode4(651845),
     /*  14354 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_COND_SUB_U32*//*Label 113*/ GIMT_Encode4(656139),
     /*  14358 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_DEC*//*Label 114*/ GIMT_Encode4(656756),
     /*  14362 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FADD*//*Label 115*/ GIMT_Encode4(659140),
     /*  14366 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMAX*//*Label 116*/ GIMT_Encode4(662782),
     /*  14370 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMIN*//*Label 117*/ GIMT_Encode4(666398),
     /*  14374 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_INC*//*Label 118*/ GIMT_Encode4(670014),
     /*  14378 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_OR*//*Label 119*/ GIMT_Encode4(672398),
     /*  14382 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMAX*//*Label 120*/ GIMT_Encode4(674782),
     /*  14386 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMIN*//*Label 121*/ GIMT_Encode4(677166),
     /*  14390 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SUB*//*Label 122*/ GIMT_Encode4(679550),
     /*  14394 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SWAP*//*Label 123*/ GIMT_Encode4(681934),
     /*  14398 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMAX*//*Label 124*/ GIMT_Encode4(685478),
     /*  14402 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMIN*//*Label 125*/ GIMT_Encode4(687862),
     /*  14406 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_XOR*//*Label 126*/ GIMT_Encode4(690246),
     /*  14410 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD*//*Label 127*/ GIMT_Encode4(692630),
     /*  14414 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT*//*Label 128*/ GIMT_Encode4(708002),
     /*  14418 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT_D16*//*Label 129*/ GIMT_Encode4(713006),
     /*  14422 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT_TFE*//*Label 130*/ GIMT_Encode4(720751),
     /*  14426 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SBYTE*//*Label 131*/ GIMT_Encode4(723319),
     /*  14430 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SBYTE_TFE*//*Label 132*/ GIMT_Encode4(723925),
     /*  14434 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SSHORT*//*Label 133*/ GIMT_Encode4(724531),
     /*  14438 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SSHORT_TFE*//*Label 134*/ GIMT_Encode4(725137),
     /*  14442 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_TFE*//*Label 135*/ GIMT_Encode4(725743),
     /*  14446 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_UBYTE*//*Label 136*/ GIMT_Encode4(728263),
     /*  14450 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_UBYTE_TFE*//*Label 137*/ GIMT_Encode4(728869),
     /*  14454 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_USHORT*//*Label 138*/ GIMT_Encode4(729475),
     /*  14458 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_USHORT_TFE*//*Label 139*/ GIMT_Encode4(730081),
     /*  14462 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE*//*Label 140*/ GIMT_Encode4(730687),
     /*  14466 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_BYTE*//*Label 141*/ GIMT_Encode4(745995),
     /*  14470 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT*//*Label 142*/ GIMT_Encode4(746597),
     /*  14474 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT_D16*//*Label 143*/ GIMT_Encode4(752193),
     /*  14478 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_SHORT*//*Label 144*/ GIMT_Encode4(759786), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  14494 */ /*AMDGPU::G_AMDGPU_CLAMP*//*Label 145*/ GIMT_Encode4(760388), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  14506 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE0*//*Label 146*/ GIMT_Encode4(761327),
     /*  14510 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE1*//*Label 147*/ GIMT_Encode4(761372),
     /*  14514 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE2*//*Label 148*/ GIMT_Encode4(761417),
     /*  14518 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE3*//*Label 149*/ GIMT_Encode4(761462),
     /*  14522 */ /*AMDGPU::G_AMDGPU_CVT_PK_I16_I32*//*Label 150*/ GIMT_Encode4(761507),
     /*  14526 */ /*AMDGPU::G_AMDGPU_FFBH_U32*//*Label 151*/ GIMT_Encode4(761537),
     /*  14530 */ /*AMDGPU::G_AMDGPU_FFBL_B32*//*Label 152*/ GIMT_Encode4(761639),
     /*  14534 */ /*AMDGPU::G_AMDGPU_FMAX_LEGACY*//*Label 153*/ GIMT_Encode4(761738),
     /*  14538 */ /*AMDGPU::G_AMDGPU_FMED3*//*Label 154*/ GIMT_Encode4(761811),
     /*  14542 */ /*AMDGPU::G_AMDGPU_FMIN_LEGACY*//*Label 155*/ GIMT_Encode4(762171), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  14574 */ /*AMDGPU::G_AMDGPU_RCP_IFLAG*//*Label 156*/ GIMT_Encode4(762244), GIMT_Encode4(0),
     /*  14582 */ /*AMDGPU::G_AMDGPU_SMED3*//*Label 157*/ GIMT_Encode4(762294),
     /*  14586 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD*//*Label 158*/ GIMT_Encode4(762600),
     /*  14590 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_SBYTE*//*Label 159*/ GIMT_Encode4(764902),
     /*  14594 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_SSHORT*//*Label 160*/ GIMT_Encode4(765040),
     /*  14598 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_UBYTE*//*Label 161*/ GIMT_Encode4(765178),
     /*  14602 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_USHORT*//*Label 162*/ GIMT_Encode4(765316),
     /*  14606 */ /*AMDGPU::G_AMDGPU_S_BUFFER_PREFETCH*//*Label 163*/ GIMT_Encode4(765454), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  14618 */ /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT*//*Label 164*/ GIMT_Encode4(765561),
     /*  14622 */ /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT_D16*//*Label 165*/ GIMT_Encode4(771141),
     /*  14626 */ /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT*//*Label 166*/ GIMT_Encode4(776570),
     /*  14630 */ /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT_D16*//*Label 167*/ GIMT_Encode4(782134),
     /*  14634 */ /*AMDGPU::G_AMDGPU_UMED3*//*Label 168*/ GIMT_Encode4(787475),
     /*  14638 */ // Label 0: @14638
     /*  14638 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(12), /*)*//*default:*//*Label 175*/ GIMT_Encode4(37879),
     /*  14649 */ /*GILLT_s1*//*Label 170*/ GIMT_Encode4(14669),
     /*  14653 */ /*GILLT_s16*//*Label 171*/ GIMT_Encode4(14788),
     /*  14657 */ /*GILLT_s32*//*Label 172*/ GIMT_Encode4(15779),
     /*  14661 */ /*GILLT_s64*//*Label 173*/ GIMT_Encode4(37138),
     /*  14665 */ /*GILLT_v2s16*//*Label 174*/ GIMT_Encode4(37609),
     /*  14669 */ // Label 170: @14669
     /*  14669 */ GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(14787),
     /*  14674 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  14677 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  14680 */   GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(14708), // Rule ID 7655 //
     /*  14685 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  14688 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  14692 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  14696 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  14696 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B64),
     /*  14699 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  14701 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  14703 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  14706 */     GIR_RootConstrainSelectedInstOperands,
     /*  14707 */     // GIR_Coverage, 7655,
     /*  14707 */     GIR_EraseRootFromParent_Done,
     /*  14708 */   // Label 177: @14708
     /*  14708 */   GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(14736), // Rule ID 7662 //
     /*  14713 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  14716 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  14720 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  14724 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  14724 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B32),
     /*  14727 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  14729 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  14731 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  14734 */     GIR_RootConstrainSelectedInstOperands,
     /*  14735 */     // GIR_Coverage, 7662,
     /*  14735 */     GIR_EraseRootFromParent_Done,
     /*  14736 */   // Label 178: @14736
     /*  14736 */   GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(14761), // Rule ID 7653 //
     /*  14741 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  14744 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  14748 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  14748 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B64),
     /*  14753 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  14759 */     GIR_RootConstrainSelectedInstOperands,
     /*  14760 */     // GIR_Coverage, 7653,
     /*  14760 */     GIR_Done,
     /*  14761 */   // Label 179: @14761
     /*  14761 */   GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(14786), // Rule ID 7660 //
     /*  14766 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  14769 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  14773 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  14773 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B32),
     /*  14778 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  14784 */     GIR_RootConstrainSelectedInstOperands,
     /*  14785 */     // GIR_Coverage, 7660,
     /*  14785 */     GIR_Done,
     /*  14786 */   // Label 180: @14786
     /*  14786 */   GIM_Reject,
     /*  14787 */ // Label 176: @14787
     /*  14787 */ GIM_Reject,
     /*  14788 */ // Label 171: @14788
     /*  14788 */ GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(15778),
     /*  14793 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  14796 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  14799 */   GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(14851), // Rule ID 7119 //
     /*  14804 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  14808 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14812 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*  14816 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  14820 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  14824 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  14828 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  14832 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_35534),
     /*  14836 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14838 */     // (add:{ *:[i16] } (trunc:{ *:[i16] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_35534>>), i16:{ *:[i16] }:$val)  =>  (V_BCNT_U32_B32_e64:{ *:[i16] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i16] }:$val)
     /*  14838 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  14841 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  14843 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // popcnt
     /*  14847 */     GIR_RootToRootCopy, /*OpIdx*/2, // val
     /*  14849 */     GIR_RootConstrainSelectedInstOperands,
     /*  14850 */     // GIR_Coverage, 7119,
     /*  14850 */     GIR_EraseRootFromParent_Done,
     /*  14851 */   // Label 182: @14851
     /*  14851 */   GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(14903), // Rule ID 11404 //
     /*  14856 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  14860 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14864 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*  14868 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  14872 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  14876 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  14880 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  14884 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_35534),
     /*  14888 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14890 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$val, (trunc:{ *:[i16] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_35534>>))  =>  (V_BCNT_U32_B32_e64:{ *:[i16] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i16] }:$val)
     /*  14890 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  14893 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  14895 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // popcnt
     /*  14899 */     GIR_RootToRootCopy, /*OpIdx*/1, // val
     /*  14901 */     GIR_RootConstrainSelectedInstOperands,
     /*  14902 */     // GIR_Coverage, 11404,
     /*  14902 */     GIR_EraseRootFromParent_Done,
     /*  14903 */   // Label 183: @14903
     /*  14903 */   GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(14946), // Rule ID 2569 //
     /*  14908 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX8GFX9),
     /*  14911 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  14915 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14919 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  14923 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  14927 */     // MIs[1] Operand 1
     /*  14927 */     // No operand predicates
     /*  14927 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14929 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } VSrc_b16:{ *:[i16] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1))
     /*  14929 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U16_e64),
     /*  14932 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  14934 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  14936 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  14941 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  14944 */     GIR_RootConstrainSelectedInstOperands,
     /*  14945 */     // GIR_Coverage, 2569,
     /*  14945 */     GIR_EraseRootFromParent_Done,
     /*  14946 */   // Label 184: @14946
     /*  14946 */   GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(14998), // Rule ID 2717 //
     /*  14951 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
     /*  14954 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  14958 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14962 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  14966 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  14970 */     // MIs[1] Operand 1
     /*  14970 */     // No operand predicates
     /*  14970 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14972 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
     /*  14972 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_e64),
     /*  14975 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  14977 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  14980 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  14982 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  14985 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  14990 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  14993 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  14996 */     GIR_RootConstrainSelectedInstOperands,
     /*  14997 */     // GIR_Coverage, 2717,
     /*  14997 */     GIR_EraseRootFromParent_Done,
     /*  14998 */   // Label 185: @14998
     /*  14998 */   GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(15050), // Rule ID 2720 //
     /*  15003 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  15006 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  15010 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15014 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15018 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  15022 */     // MIs[1] Operand 1
     /*  15022 */     // No operand predicates
     /*  15022 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15024 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_t16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 bf16 f16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
     /*  15024 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_t16_e64),
     /*  15027 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15029 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15032 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  15034 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15037 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  15042 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15045 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15048 */     GIR_RootConstrainSelectedInstOperands,
     /*  15049 */     // GIR_Coverage, 2720,
     /*  15049 */     GIR_EraseRootFromParent_Done,
     /*  15050 */   // Label 186: @15050
     /*  15050 */   GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(15102), // Rule ID 2723 //
     /*  15055 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  15058 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15062 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15066 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15070 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  15074 */     // MIs[1] Operand 1
     /*  15074 */     // No operand predicates
     /*  15074 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15076 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
     /*  15076 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_fake16_e64),
     /*  15079 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15081 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15084 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  15086 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15089 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  15094 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15097 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15100 */     GIR_RootConstrainSelectedInstOperands,
     /*  15101 */     // GIR_Coverage, 2723,
     /*  15101 */     GIR_EraseRootFromParent_Done,
     /*  15102 */   // Label 187: @15102
     /*  15102 */   GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(15152), // Rule ID 2613 //
     /*  15107 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9),
     /*  15110 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15114 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15118 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  15122 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15126 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  15130 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15132 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  15132 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_e64),
     /*  15135 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15137 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  15141 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  15145 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  15147 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15150 */     GIR_RootConstrainSelectedInstOperands,
     /*  15151 */     // GIR_Coverage, 2613,
     /*  15151 */     GIR_EraseRootFromParent_Done,
     /*  15152 */   // Label 188: @15152
     /*  15152 */   GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(15214), // Rule ID 2614 //
     /*  15157 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  15160 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  15164 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15168 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  15172 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15176 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  15180 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15182 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_t16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  15182 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_t16_e64),
     /*  15185 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15187 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15190 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  15194 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15197 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  15201 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15204 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  15206 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15209 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15212 */     GIR_RootConstrainSelectedInstOperands,
     /*  15213 */     // GIR_Coverage, 2614,
     /*  15213 */     GIR_EraseRootFromParent_Done,
     /*  15214 */   // Label 189: @15214
     /*  15214 */   GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(15276), // Rule ID 2615 //
     /*  15219 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  15222 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15226 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15230 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  15234 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15238 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  15242 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15244 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  15244 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_fake16_e64),
     /*  15247 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15249 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15252 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  15256 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15259 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  15263 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15266 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  15268 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15271 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15274 */     GIR_RootConstrainSelectedInstOperands,
     /*  15275 */     // GIR_Coverage, 2615,
     /*  15275 */     GIR_EraseRootFromParent_Done,
     /*  15276 */   // Label 190: @15276
     /*  15276 */   GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(15338), // Rule ID 2616 //
     /*  15281 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus),
     /*  15284 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15288 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15292 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  15296 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15300 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  15304 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15306 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  15306 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_e64),
     /*  15309 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15311 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15314 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  15318 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15321 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  15325 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15328 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  15330 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15333 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15336 */     GIR_RootConstrainSelectedInstOperands,
     /*  15337 */     // GIR_Coverage, 2616,
     /*  15337 */     GIR_EraseRootFromParent_Done,
     /*  15338 */   // Label 191: @15338
     /*  15338 */   GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(15388), // Rule ID 8740 //
     /*  15343 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9),
     /*  15346 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15350 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15354 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  15358 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15362 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  15366 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15368 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  15368 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_e64),
     /*  15371 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15373 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  15377 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  15381 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  15383 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15386 */     GIR_RootConstrainSelectedInstOperands,
     /*  15387 */     // GIR_Coverage, 8740,
     /*  15387 */     GIR_EraseRootFromParent_Done,
     /*  15388 */   // Label 192: @15388
     /*  15388 */   GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(15450), // Rule ID 8741 //
     /*  15393 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  15396 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  15400 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15404 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  15408 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15412 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  15416 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15418 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_t16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  15418 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_t16_e64),
     /*  15421 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15423 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15426 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  15430 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15433 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  15437 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15440 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  15442 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15445 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15448 */     GIR_RootConstrainSelectedInstOperands,
     /*  15449 */     // GIR_Coverage, 8741,
     /*  15449 */     GIR_EraseRootFromParent_Done,
     /*  15450 */   // Label 193: @15450
     /*  15450 */   GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(15512), // Rule ID 8742 //
     /*  15455 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  15458 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15462 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15466 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  15470 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15474 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  15478 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15480 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  15480 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_fake16_e64),
     /*  15483 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15485 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15488 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  15492 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15495 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  15499 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15502 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  15504 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15507 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15510 */     GIR_RootConstrainSelectedInstOperands,
     /*  15511 */     // GIR_Coverage, 8742,
     /*  15511 */     GIR_EraseRootFromParent_Done,
     /*  15512 */   // Label 194: @15512
     /*  15512 */   GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(15574), // Rule ID 8743 //
     /*  15517 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus),
     /*  15520 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15524 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15528 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  15532 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15536 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  15540 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15542 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  15542 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_e64),
     /*  15545 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15547 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15550 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  15554 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15557 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  15561 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15564 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  15566 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15569 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15572 */     GIR_RootConstrainSelectedInstOperands,
     /*  15573 */     // GIR_Coverage, 8743,
     /*  15573 */     GIR_EraseRootFromParent_Done,
     /*  15574 */   // Label 195: @15574
     /*  15574 */   GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(15633), // Rule ID 1088 //
     /*  15579 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
     /*  15582 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15586 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  15593 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  15600 */     // (add:{ *:[i16] } (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  15600 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_e64),
     /*  15603 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15605 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  15610 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  15615 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  15620 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  15625 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15628 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15631 */     GIR_RootConstrainSelectedInstOperands,
     /*  15632 */     // GIR_Coverage, 1088,
     /*  15632 */     GIR_EraseRootFromParent_Done,
     /*  15633 */   // Label 196: @15633
     /*  15633 */   GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(15692), // Rule ID 1089 //
     /*  15638 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts_isGFX10Plus),
     /*  15641 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  15645 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  15652 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  15659 */     // (add:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  15659 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_t16_e64),
     /*  15662 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15664 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  15669 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  15674 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  15679 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  15684 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15687 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15690 */     GIR_RootConstrainSelectedInstOperands,
     /*  15691 */     // GIR_Coverage, 1089,
     /*  15691 */     GIR_EraseRootFromParent_Done,
     /*  15692 */   // Label 197: @15692
     /*  15692 */   GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(15751), // Rule ID 1090 //
     /*  15697 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts_isGFX10Plus),
     /*  15700 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15704 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  15711 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  15718 */     // (add:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_fake16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  15718 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_fake16_e64),
     /*  15721 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15723 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  15728 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  15733 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  15738 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  15743 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15746 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15749 */     GIR_RootConstrainSelectedInstOperands,
     /*  15750 */     // GIR_Coverage, 1090,
     /*  15750 */     GIR_EraseRootFromParent_Done,
     /*  15751 */   // Label 198: @15751
     /*  15751 */   GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(15777), // Rule ID 931 //
     /*  15756 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX8GFX9),
     /*  15759 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15763 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_ADD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  15763 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U16_e64),
     /*  15766 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15768 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  15770 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  15772 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15775 */     GIR_RootConstrainSelectedInstOperands,
     /*  15776 */     // GIR_Coverage, 931,
     /*  15776 */     GIR_EraseRootFromParent_Done,
     /*  15777 */   // Label 199: @15777
     /*  15777 */   GIM_Reject,
     /*  15778 */ // Label 181: @15778
     /*  15778 */ GIM_Reject,
     /*  15779 */ // Label 172: @15779
     /*  15779 */ GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(37137),
     /*  15784 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  15787 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  15790 */   GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(16289), // Rule ID 8849 //
     /*  15795 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  15798 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  15800 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15804 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15808 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  15812 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  15815 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  15820 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  15824 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  15828 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  15830 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  15834 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  15838 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  15842 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  15846 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  15850 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  15854 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  15858 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  15862 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  15866 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  15870 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  15874 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  15878 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  15882 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  15886 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  15888 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  15892 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  15896 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  15899 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  15904 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  15908 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  15912 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  15914 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  15918 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15922 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  15926 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  15930 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  15934 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  15938 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  15942 */     // MIs[7] src0
     /*  15942 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  15947 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  15951 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  15962 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  15966 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15970 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  15974 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  15978 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  15982 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  15986 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  15990 */     // MIs[9] src1
     /*  15990 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  15995 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  15999 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  16010 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  16014 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  16018 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  16022 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  16026 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  16028 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  16032 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16036 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  16039 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  16044 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  16048 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  16052 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  16054 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  16058 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16062 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  16066 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  16070 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  16074 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16078 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  16082 */     // MIs[13] src0
     /*  16082 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16087 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  16091 */     GIM_CheckConstantInt, /*MI*/12, /*Op*/2, GIMT_Encode8(255),
     /*  16102 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  16106 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16110 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  16114 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  16118 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  16122 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16126 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  16130 */     // MIs[15] src1
     /*  16130 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  16135 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  16139 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  16150 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  16154 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  16158 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  16162 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  16166 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  16168 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  16172 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16176 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  16179 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  16184 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  16188 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  16192 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  16194 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  16198 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16202 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  16206 */     // MIs[18] src0
     /*  16206 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16211 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  16222 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  16226 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16230 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  16234 */     // MIs[19] src1
     /*  16234 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  16239 */     GIM_CheckConstantInt, /*MI*/19, /*Op*/2, GIMT_Encode8(255),
     /*  16250 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  16252 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  16252 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  16255 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16257 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  16260 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  16264 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  16267 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  16271 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  16274 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/2, // src2
     /*  16278 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16281 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16284 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16287 */     GIR_RootConstrainSelectedInstOperands,
     /*  16288 */     // GIR_Coverage, 8849,
     /*  16288 */     GIR_EraseRootFromParent_Done,
     /*  16289 */   // Label 201: @16289
     /*  16289 */   GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(16788), // Rule ID 8848 //
     /*  16294 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  16297 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  16299 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16303 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16307 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16311 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  16314 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  16319 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16323 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  16327 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  16329 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16333 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16337 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  16341 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  16345 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  16349 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  16353 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16357 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  16361 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  16365 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  16369 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  16373 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  16377 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  16381 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  16385 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  16387 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  16391 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16395 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  16398 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  16403 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  16407 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  16411 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  16413 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  16417 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16421 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  16425 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  16429 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  16433 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16437 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  16441 */     // MIs[7] src0
     /*  16441 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16446 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  16450 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  16461 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  16465 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16469 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  16473 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  16477 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  16481 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16485 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  16489 */     // MIs[9] src1
     /*  16489 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  16494 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  16498 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  16509 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  16513 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  16517 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  16521 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  16525 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  16527 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  16531 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16535 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  16538 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  16543 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  16547 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  16551 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  16553 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  16557 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16561 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  16565 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  16569 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  16573 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16577 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  16581 */     // MIs[13] src0
     /*  16581 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16586 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  16590 */     GIM_CheckConstantInt, /*MI*/12, /*Op*/2, GIMT_Encode8(255),
     /*  16601 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  16605 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16609 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  16613 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  16617 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  16621 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16625 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  16629 */     // MIs[15] src1
     /*  16629 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  16634 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  16638 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  16649 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  16653 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  16657 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  16661 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  16665 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  16667 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/2, // MIs[17]
     /*  16671 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16675 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  16678 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  16683 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  16687 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  16691 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  16693 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  16697 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16701 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  16705 */     // MIs[18] src0
     /*  16705 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16710 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  16721 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  16725 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16729 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  16733 */     // MIs[19] src1
     /*  16733 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  16738 */     GIM_CheckConstantInt, /*MI*/19, /*Op*/2, GIMT_Encode8(255),
     /*  16749 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  16751 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  16751 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  16754 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16756 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  16759 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  16763 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  16766 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  16770 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  16773 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/1, // src2
     /*  16777 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16780 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16783 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16786 */     GIR_RootConstrainSelectedInstOperands,
     /*  16787 */     // GIR_Coverage, 8848,
     /*  16787 */     GIR_EraseRootFromParent_Done,
     /*  16788 */   // Label 202: @16788
     /*  16788 */   GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(17287), // Rule ID 8847 //
     /*  16793 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  16796 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  16798 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16802 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16806 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16810 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  16813 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  16818 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16822 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  16826 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  16828 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16832 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16836 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  16840 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  16844 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  16848 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  16852 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16856 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  16860 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  16864 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  16868 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  16872 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  16876 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  16880 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  16884 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  16886 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  16890 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16894 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  16897 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  16902 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  16906 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  16910 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  16912 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  16916 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16920 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  16924 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  16928 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  16932 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16936 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  16940 */     // MIs[7] src0
     /*  16940 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16945 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  16949 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  16960 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  16964 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16968 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  16972 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  16976 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  16980 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16984 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  16988 */     // MIs[9] src1
     /*  16988 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  16993 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  16997 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  17008 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  17012 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17016 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  17020 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  17024 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  17026 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  17030 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17034 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  17038 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  17042 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  17044 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  17048 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17052 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  17055 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17060 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  17064 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  17068 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  17070 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  17074 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17078 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  17082 */     // MIs[13] src0
     /*  17082 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17087 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  17098 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  17102 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17106 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  17110 */     // MIs[14] src1
     /*  17110 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17115 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  17126 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  17130 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17134 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  17137 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17142 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  17146 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  17150 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  17152 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  17156 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17160 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  17164 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  17168 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  17172 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17176 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  17180 */     // MIs[17] src0
     /*  17180 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17185 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  17189 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  17200 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  17204 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17208 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  17212 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  17216 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  17220 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17224 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  17228 */     // MIs[19] src1
     /*  17228 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17233 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  17237 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  17248 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  17250 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  17250 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  17253 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  17255 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17258 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  17262 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17265 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  17269 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17272 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  17276 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17279 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17282 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17285 */     GIR_RootConstrainSelectedInstOperands,
     /*  17286 */     // GIR_Coverage, 8847,
     /*  17286 */     GIR_EraseRootFromParent_Done,
     /*  17287 */   // Label 203: @17287
     /*  17287 */   GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(17786), // Rule ID 8846 //
     /*  17292 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  17295 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  17297 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  17301 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17305 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17309 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  17312 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17317 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17321 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  17325 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  17327 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17331 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17335 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  17339 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  17343 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  17347 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  17351 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17355 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  17359 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  17363 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  17367 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  17371 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17375 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  17379 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  17383 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  17385 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17389 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17393 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  17396 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17401 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  17405 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  17409 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  17411 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  17415 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17419 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  17423 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  17427 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  17431 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17435 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  17439 */     // MIs[7] src0
     /*  17439 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17444 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  17448 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  17459 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  17463 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17467 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  17471 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  17475 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  17479 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17483 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  17487 */     // MIs[9] src1
     /*  17487 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17492 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  17496 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  17507 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  17511 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17515 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  17519 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  17523 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  17525 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  17529 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17533 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  17537 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  17541 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  17543 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  17547 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17551 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  17554 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17559 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  17563 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  17567 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  17569 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  17573 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17577 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  17581 */     // MIs[13] src0
     /*  17581 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17586 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  17597 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  17601 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17605 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  17609 */     // MIs[14] src1
     /*  17609 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17614 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  17625 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  17629 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17633 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  17636 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17641 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  17645 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  17649 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  17651 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  17655 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17659 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  17663 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  17667 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  17671 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17675 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  17679 */     // MIs[17] src0
     /*  17679 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17684 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  17688 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  17699 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  17703 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17707 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  17711 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  17715 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  17719 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17723 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  17727 */     // MIs[19] src1
     /*  17727 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17732 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  17736 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  17747 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  17749 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  17749 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  17752 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  17754 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17757 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  17761 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17764 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  17768 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17771 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  17775 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17778 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17781 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17784 */     GIR_RootConstrainSelectedInstOperands,
     /*  17785 */     // GIR_Coverage, 8846,
     /*  17785 */     GIR_EraseRootFromParent_Done,
     /*  17786 */   // Label 204: @17786
     /*  17786 */   GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(18285), // Rule ID 8845 //
     /*  17791 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  17794 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  17796 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  17800 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17804 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17808 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  17811 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17816 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17820 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  17824 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  17826 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17830 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17834 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  17838 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  17842 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  17846 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  17850 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17854 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  17858 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  17862 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  17866 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  17870 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17874 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  17878 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  17882 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  17884 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17888 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17892 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  17896 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  17900 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  17902 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  17906 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17910 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  17913 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17918 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  17922 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  17926 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  17928 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  17932 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17936 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  17940 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  17944 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  17948 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17952 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  17956 */     // MIs[8] src0
     /*  17956 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17961 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  17965 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(255),
     /*  17976 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  17980 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17984 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  17988 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  17992 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  17996 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18000 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  18004 */     // MIs[10] src1
     /*  18004 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18009 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  18013 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  18024 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  18028 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18032 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  18036 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  18040 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  18042 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  18046 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18050 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  18053 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18058 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  18062 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  18066 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  18068 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  18072 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18076 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  18080 */     // MIs[13] src0
     /*  18080 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18085 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  18096 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  18100 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18104 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  18108 */     // MIs[14] src1
     /*  18108 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18113 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  18124 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  18128 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18132 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  18135 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18140 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  18144 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  18148 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  18150 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  18154 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18158 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  18162 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  18166 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  18170 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18174 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  18178 */     // MIs[17] src0
     /*  18178 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18183 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  18187 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  18198 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  18202 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18206 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  18210 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  18214 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  18218 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18222 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  18226 */     // MIs[19] src1
     /*  18226 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18231 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  18235 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  18246 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  18248 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  18248 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  18251 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  18253 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18256 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  18260 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18263 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  18267 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18270 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  18274 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18277 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18280 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18283 */     GIR_RootConstrainSelectedInstOperands,
     /*  18284 */     // GIR_Coverage, 8845,
     /*  18284 */     GIR_EraseRootFromParent_Done,
     /*  18285 */   // Label 205: @18285
     /*  18285 */   GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(18784), // Rule ID 8844 //
     /*  18290 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  18293 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  18295 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  18299 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18303 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18307 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  18310 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18315 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  18319 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  18323 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  18325 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18329 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18333 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  18337 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  18341 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  18345 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  18349 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18353 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  18357 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  18361 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  18365 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  18369 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18373 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  18377 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  18381 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  18383 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18387 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18391 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  18395 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  18399 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  18401 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  18405 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18409 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  18412 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18417 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  18421 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  18425 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  18427 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  18431 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18435 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  18439 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  18443 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  18447 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18451 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  18455 */     // MIs[8] src0
     /*  18455 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18460 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  18464 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(255),
     /*  18475 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  18479 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18483 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  18487 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  18491 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  18495 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18499 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  18503 */     // MIs[10] src1
     /*  18503 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18508 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  18512 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  18523 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  18527 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18531 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  18535 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  18539 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  18541 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  18545 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18549 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  18552 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18557 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  18561 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  18565 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  18567 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  18571 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18575 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  18579 */     // MIs[13] src0
     /*  18579 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18584 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  18595 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  18599 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18603 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  18607 */     // MIs[14] src1
     /*  18607 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18612 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  18623 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  18627 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18631 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  18634 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18639 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  18643 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  18647 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  18649 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  18653 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18657 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  18661 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  18665 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  18669 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18673 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  18677 */     // MIs[17] src0
     /*  18677 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18682 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  18686 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  18697 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  18701 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18705 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  18709 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  18713 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  18717 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18721 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  18725 */     // MIs[19] src1
     /*  18725 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18730 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  18734 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  18745 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  18747 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  18747 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  18750 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  18752 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18755 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  18759 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18762 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  18766 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18769 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  18773 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18776 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18779 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18782 */     GIR_RootConstrainSelectedInstOperands,
     /*  18783 */     // GIR_Coverage, 8844,
     /*  18783 */     GIR_EraseRootFromParent_Done,
     /*  18784 */   // Label 206: @18784
     /*  18784 */   GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(19283), // Rule ID 8843 //
     /*  18789 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  18792 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  18794 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  18798 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18802 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18806 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  18809 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18814 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  18818 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  18822 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  18824 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18828 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18832 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  18836 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  18840 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  18844 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  18848 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18852 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  18856 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  18860 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  18864 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  18868 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18872 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  18876 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  18880 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  18882 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18886 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18890 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  18894 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  18898 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  18900 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  18904 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18908 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  18912 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  18916 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  18918 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  18922 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18926 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  18929 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18934 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  18938 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  18942 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  18944 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  18948 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18952 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  18956 */     // MIs[8] src0
     /*  18956 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18961 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  18972 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  18976 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18980 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  18984 */     // MIs[9] src1
     /*  18984 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18989 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  19000 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  19004 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19008 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  19011 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19016 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  19020 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  19024 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  19026 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  19030 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19034 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  19038 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  19042 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  19046 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19050 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  19054 */     // MIs[12] src0
     /*  19054 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19059 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  19063 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  19074 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  19078 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19082 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  19086 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  19090 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  19094 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19098 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  19102 */     // MIs[14] src1
     /*  19102 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19107 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  19111 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  19122 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  19126 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19130 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  19133 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19138 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  19142 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  19146 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  19148 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  19152 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19156 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  19160 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  19164 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  19168 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19172 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  19176 */     // MIs[17] src0
     /*  19176 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19181 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  19185 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  19196 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  19200 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19204 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  19208 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  19212 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  19216 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19220 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  19224 */     // MIs[19] src1
     /*  19224 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19229 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  19233 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  19244 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  19246 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  19246 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  19249 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  19251 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19254 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  19258 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19261 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  19265 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19268 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/2, // src2
     /*  19272 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19275 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19278 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19281 */     GIR_RootConstrainSelectedInstOperands,
     /*  19282 */     // GIR_Coverage, 8843,
     /*  19282 */     GIR_EraseRootFromParent_Done,
     /*  19283 */   // Label 207: @19283
     /*  19283 */   GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(19782), // Rule ID 8842 //
     /*  19288 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  19291 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  19293 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  19297 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19301 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19305 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  19308 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19313 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19317 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  19321 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  19323 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19327 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19331 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19335 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19339 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  19343 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  19347 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19351 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  19355 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  19359 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  19363 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  19367 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19371 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  19375 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19379 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  19381 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  19385 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19389 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  19393 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  19397 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  19399 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  19403 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19407 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  19411 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  19415 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  19417 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  19421 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19425 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  19428 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19433 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  19437 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  19441 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  19443 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  19447 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19451 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  19455 */     // MIs[8] src0
     /*  19455 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19460 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  19471 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  19475 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19479 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  19483 */     // MIs[9] src1
     /*  19483 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19488 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  19499 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  19503 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19507 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  19510 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19515 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  19519 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  19523 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  19525 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  19529 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19533 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  19537 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  19541 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  19545 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19549 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  19553 */     // MIs[12] src0
     /*  19553 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19558 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  19562 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  19573 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  19577 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19581 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  19585 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  19589 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  19593 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19597 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  19601 */     // MIs[14] src1
     /*  19601 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19606 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  19610 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  19621 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  19625 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19629 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  19632 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19637 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  19641 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  19645 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  19647 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  19651 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19655 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  19659 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  19663 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  19667 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19671 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  19675 */     // MIs[17] src0
     /*  19675 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19680 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  19684 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  19695 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  19699 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19703 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  19707 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  19711 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  19715 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19719 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  19723 */     // MIs[19] src1
     /*  19723 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19728 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  19732 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  19743 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  19745 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  19745 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  19748 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  19750 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19753 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  19757 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19760 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  19764 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19767 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src2
     /*  19771 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19774 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19777 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19780 */     GIR_RootConstrainSelectedInstOperands,
     /*  19781 */     // GIR_Coverage, 8842,
     /*  19781 */     GIR_EraseRootFromParent_Done,
     /*  19782 */   // Label 208: @19782
     /*  19782 */   GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(20281), // Rule ID 8841 //
     /*  19787 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  19790 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  19792 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  19796 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19800 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19804 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  19808 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19812 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  19814 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  19818 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19822 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  19825 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19830 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19834 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  19838 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  19840 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  19844 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19848 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  19852 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  19856 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  19860 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19864 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  19868 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19872 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  19876 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  19887 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  19891 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19895 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  19899 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  19903 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  19907 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19911 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  19915 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  19919 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  19923 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  19934 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  19938 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19942 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  19946 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  19950 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  19952 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  19956 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19960 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  19963 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19968 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  19972 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  19976 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  19978 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  19982 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19986 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  19990 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  19994 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  19998 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20002 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  20006 */     // MIs[10] src0
     /*  20006 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  20011 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  20015 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  20026 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  20030 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20034 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  20038 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  20042 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  20046 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20050 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  20054 */     // MIs[12] src1
     /*  20054 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  20059 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  20063 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  20074 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  20078 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20082 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  20086 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  20090 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  20092 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  20096 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20100 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  20103 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20108 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  20112 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  20116 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  20118 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  20122 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20126 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  20130 */     // MIs[15] src0
     /*  20130 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  20135 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  20146 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  20150 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20154 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  20158 */     // MIs[16] src1
     /*  20158 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  20163 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  20174 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  20178 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20182 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  20185 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20190 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  20194 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  20198 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  20200 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  20204 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20208 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  20212 */     // MIs[18] src0
     /*  20212 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  20217 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  20221 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  20225 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20229 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  20233 */     // MIs[19] src1
     /*  20233 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  20238 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  20242 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  20244 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  20244 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  20247 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  20249 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20252 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  20256 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20259 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  20263 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20266 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/2, // src2
     /*  20270 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20273 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20276 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20279 */     GIR_RootConstrainSelectedInstOperands,
     /*  20280 */     // GIR_Coverage, 8841,
     /*  20280 */     GIR_EraseRootFromParent_Done,
     /*  20281 */   // Label 209: @20281
     /*  20281 */   GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(20780), // Rule ID 8840 //
     /*  20286 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  20289 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  20291 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  20295 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20299 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20303 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  20307 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20311 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  20313 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  20317 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20321 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  20324 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20329 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20333 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  20337 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  20339 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  20343 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20347 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  20351 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  20355 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  20359 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20363 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  20367 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  20371 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  20375 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  20386 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  20390 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20394 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  20398 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  20402 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  20406 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20410 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  20414 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  20418 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  20422 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  20433 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  20437 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20441 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  20445 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  20449 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  20451 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  20455 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20459 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  20462 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20467 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  20471 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  20475 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  20477 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  20481 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20485 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  20489 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  20493 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  20497 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20501 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  20505 */     // MIs[10] src0
     /*  20505 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  20510 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  20514 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  20525 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  20529 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20533 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  20537 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  20541 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  20545 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20549 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  20553 */     // MIs[12] src1
     /*  20553 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  20558 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  20562 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  20573 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  20577 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20581 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  20585 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  20589 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  20591 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/2, // MIs[14]
     /*  20595 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20599 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  20602 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20607 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  20611 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  20615 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  20617 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  20621 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20625 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  20629 */     // MIs[15] src0
     /*  20629 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  20634 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  20645 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  20649 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20653 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  20657 */     // MIs[16] src1
     /*  20657 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  20662 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  20673 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  20677 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20681 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  20684 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20689 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  20693 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  20697 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  20699 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  20703 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20707 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  20711 */     // MIs[18] src0
     /*  20711 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  20716 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  20720 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  20724 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20728 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  20732 */     // MIs[19] src1
     /*  20732 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  20737 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  20741 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  20743 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  20743 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  20746 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  20748 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20751 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  20755 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20758 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  20762 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20765 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/1, // src2
     /*  20769 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20772 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20775 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20778 */     GIR_RootConstrainSelectedInstOperands,
     /*  20779 */     // GIR_Coverage, 8840,
     /*  20779 */     GIR_EraseRootFromParent_Done,
     /*  20780 */   // Label 210: @20780
     /*  20780 */   GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(21279), // Rule ID 8839 //
     /*  20785 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  20788 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  20790 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  20794 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20798 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20802 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  20806 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20810 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  20812 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  20816 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20820 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  20823 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20828 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20832 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  20836 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  20838 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  20842 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20846 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  20850 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  20854 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  20858 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20862 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  20866 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  20870 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  20874 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  20885 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  20889 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20893 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  20897 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  20901 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  20905 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20909 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  20913 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  20917 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  20921 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  20932 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  20936 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20940 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  20944 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  20948 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  20950 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  20954 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20958 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  20962 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  20966 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  20968 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  20972 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20976 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  20979 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20984 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  20988 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  20992 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  20994 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  20998 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21002 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  21006 */     // MIs[10] src0
     /*  21006 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21011 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  21022 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  21026 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21030 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  21034 */     // MIs[11] src1
     /*  21034 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21039 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  21050 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  21054 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21058 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  21061 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21066 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  21070 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  21074 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  21076 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  21080 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21084 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  21088 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  21092 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  21096 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21100 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  21104 */     // MIs[14] src0
     /*  21104 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21109 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  21113 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  21124 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  21128 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21132 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  21136 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  21140 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  21144 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21148 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  21152 */     // MIs[16] src1
     /*  21152 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21157 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  21161 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  21172 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  21176 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21180 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  21183 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21188 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  21192 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  21196 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  21198 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  21202 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21206 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  21210 */     // MIs[18] src0
     /*  21210 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21215 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  21219 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  21223 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21227 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  21231 */     // MIs[19] src1
     /*  21231 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21236 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  21240 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  21242 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  21242 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  21245 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  21247 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21250 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  21254 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21257 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  21261 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21264 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  21268 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21271 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21274 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21277 */     GIR_RootConstrainSelectedInstOperands,
     /*  21278 */     // GIR_Coverage, 8839,
     /*  21278 */     GIR_EraseRootFromParent_Done,
     /*  21279 */   // Label 211: @21279
     /*  21279 */   GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(21778), // Rule ID 8838 //
     /*  21284 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  21287 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  21289 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  21293 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21297 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21301 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21305 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21309 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  21311 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  21315 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21319 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  21322 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21327 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21331 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  21335 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  21337 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  21341 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21345 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  21349 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  21353 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21357 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21361 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  21365 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  21369 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  21373 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  21384 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  21388 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21392 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  21396 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  21400 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  21404 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21408 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  21412 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  21416 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  21420 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  21431 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  21435 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21439 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  21443 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  21447 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  21449 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  21453 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21457 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  21461 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  21465 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  21467 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  21471 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21475 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  21478 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21483 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  21487 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  21491 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  21493 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  21497 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21501 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  21505 */     // MIs[10] src0
     /*  21505 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21510 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  21521 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  21525 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21529 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  21533 */     // MIs[11] src1
     /*  21533 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21538 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  21549 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  21553 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21557 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  21560 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21565 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  21569 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  21573 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  21575 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  21579 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21583 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  21587 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  21591 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  21595 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21599 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  21603 */     // MIs[14] src0
     /*  21603 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21608 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  21612 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  21623 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  21627 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21631 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  21635 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  21639 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  21643 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21647 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  21651 */     // MIs[16] src1
     /*  21651 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21656 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  21660 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  21671 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  21675 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21679 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  21682 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21687 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  21691 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  21695 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  21697 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  21701 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21705 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  21709 */     // MIs[18] src0
     /*  21709 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21714 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  21718 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  21722 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21726 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  21730 */     // MIs[19] src1
     /*  21730 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21735 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  21739 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  21741 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  21741 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  21744 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  21746 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21749 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  21753 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21756 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  21760 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21763 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  21767 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21770 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21773 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21776 */     GIR_RootConstrainSelectedInstOperands,
     /*  21777 */     // GIR_Coverage, 8838,
     /*  21777 */     GIR_EraseRootFromParent_Done,
     /*  21778 */   // Label 212: @21778
     /*  21778 */   GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(22277), // Rule ID 8837 //
     /*  21783 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  21786 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  21788 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  21792 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21796 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21800 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21804 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21808 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  21810 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  21814 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21818 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  21822 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21826 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  21828 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  21832 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21836 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  21839 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21844 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  21848 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  21852 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  21854 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  21858 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21862 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  21866 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  21870 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  21874 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21878 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  21882 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  21886 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  21890 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(255),
     /*  21901 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  21905 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21909 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  21913 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  21917 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  21921 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21925 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  21929 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  21933 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  21937 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  21948 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  21952 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21956 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  21960 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  21964 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  21966 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  21970 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21974 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  21977 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21982 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  21986 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  21990 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  21992 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  21996 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22000 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  22004 */     // MIs[10] src0
     /*  22004 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  22009 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  22020 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  22024 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22028 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  22032 */     // MIs[11] src1
     /*  22032 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  22037 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  22048 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  22052 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22056 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  22059 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22064 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  22068 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  22072 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  22074 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  22078 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22082 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  22086 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  22090 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  22094 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22098 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  22102 */     // MIs[14] src0
     /*  22102 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  22107 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  22111 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  22122 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  22126 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22130 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  22134 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  22138 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  22142 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22146 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  22150 */     // MIs[16] src1
     /*  22150 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  22155 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  22159 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  22170 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  22174 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22178 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  22181 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22186 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  22190 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  22194 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  22196 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  22200 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22204 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  22208 */     // MIs[18] src0
     /*  22208 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  22213 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  22217 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  22221 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22225 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  22229 */     // MIs[19] src1
     /*  22229 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  22234 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  22238 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  22240 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  22240 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  22243 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  22245 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22248 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  22252 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22255 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  22259 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22262 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  22266 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22269 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22272 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22275 */     GIR_RootConstrainSelectedInstOperands,
     /*  22276 */     // GIR_Coverage, 8837,
     /*  22276 */     GIR_EraseRootFromParent_Done,
     /*  22277 */   // Label 213: @22277
     /*  22277 */   GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(22776), // Rule ID 8836 //
     /*  22282 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  22285 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  22287 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  22291 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22295 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22299 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22303 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22307 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  22309 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22313 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22317 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  22321 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  22325 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  22327 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  22331 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22335 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  22338 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22343 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  22347 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  22351 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  22353 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  22357 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22361 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  22365 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  22369 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  22373 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22377 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  22381 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  22385 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  22389 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(255),
     /*  22400 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  22404 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22408 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  22412 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  22416 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  22420 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22424 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  22428 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  22432 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  22436 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  22447 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  22451 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22455 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  22459 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  22463 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  22465 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  22469 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22473 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  22476 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22481 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  22485 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  22489 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  22491 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  22495 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22499 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  22503 */     // MIs[10] src0
     /*  22503 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  22508 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  22519 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  22523 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22527 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  22531 */     // MIs[11] src1
     /*  22531 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  22536 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  22547 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  22551 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22555 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  22558 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22563 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  22567 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  22571 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  22573 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  22577 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22581 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  22585 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  22589 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  22593 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22597 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  22601 */     // MIs[14] src0
     /*  22601 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  22606 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  22610 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  22621 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  22625 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22629 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  22633 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  22637 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  22641 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22645 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  22649 */     // MIs[16] src1
     /*  22649 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  22654 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  22658 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  22669 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  22673 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22677 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  22680 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22685 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  22689 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  22693 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  22695 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  22699 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22703 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  22707 */     // MIs[18] src0
     /*  22707 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  22712 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  22716 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  22720 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22724 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  22728 */     // MIs[19] src1
     /*  22728 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  22733 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  22737 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  22739 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  22739 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  22742 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  22744 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22747 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  22751 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22754 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  22758 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22761 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  22765 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22768 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22771 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22774 */     GIR_RootConstrainSelectedInstOperands,
     /*  22775 */     // GIR_Coverage, 8836,
     /*  22775 */     GIR_EraseRootFromParent_Done,
     /*  22776 */   // Label 214: @22776
     /*  22776 */   GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(23275), // Rule ID 8835 //
     /*  22781 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  22784 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  22786 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  22790 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22794 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22798 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22802 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22806 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  22808 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22812 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22816 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  22820 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  22824 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  22826 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  22830 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22834 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  22838 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  22842 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  22844 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22848 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22852 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  22855 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22860 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  22864 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  22868 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  22870 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  22874 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22878 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  22882 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  22886 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  22897 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  22901 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22905 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  22909 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  22913 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  22924 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  22928 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22932 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  22935 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22940 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  22944 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  22948 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  22950 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  22954 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22958 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  22962 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  22966 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  22970 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22974 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  22978 */     // MIs[9] src0
     /*  22978 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  22983 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  22987 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  22998 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  23002 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23006 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  23010 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  23014 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  23018 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23022 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  23026 */     // MIs[11] src1
     /*  23026 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  23031 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  23035 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  23046 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  23050 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23054 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  23057 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23062 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  23066 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  23070 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  23072 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  23076 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23080 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  23084 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  23088 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  23092 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23096 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  23100 */     // MIs[14] src0
     /*  23100 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23105 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  23109 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  23120 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  23124 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23128 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  23132 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  23136 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  23140 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23144 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  23148 */     // MIs[16] src1
     /*  23148 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  23153 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  23157 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  23168 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  23172 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23176 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  23179 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23184 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  23188 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  23192 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  23194 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  23198 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23202 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  23206 */     // MIs[18] src0
     /*  23206 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23211 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  23215 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  23219 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23223 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  23227 */     // MIs[19] src1
     /*  23227 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  23232 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  23236 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  23238 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  23238 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  23241 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  23243 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23246 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  23250 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23253 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  23257 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23260 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  23264 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23267 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23270 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23273 */     GIR_RootConstrainSelectedInstOperands,
     /*  23274 */     // GIR_Coverage, 8835,
     /*  23274 */     GIR_EraseRootFromParent_Done,
     /*  23275 */   // Label 215: @23275
     /*  23275 */   GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(23774), // Rule ID 2812 //
     /*  23280 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  23283 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  23285 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  23289 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23293 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23297 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  23301 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  23305 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  23307 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  23311 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23315 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  23319 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  23323 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  23325 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  23329 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23333 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  23337 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  23341 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  23343 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  23347 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23351 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  23354 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23359 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  23363 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  23367 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  23369 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  23373 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23377 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  23381 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  23385 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  23396 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  23400 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23404 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  23408 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  23412 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  23423 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  23427 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23431 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  23434 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23439 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  23443 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  23447 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  23449 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  23453 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23457 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  23461 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  23465 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  23469 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23473 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  23477 */     // MIs[9] src0
     /*  23477 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23482 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  23486 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  23497 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  23501 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23505 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  23509 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  23513 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  23517 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23521 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  23525 */     // MIs[11] src1
     /*  23525 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  23530 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  23534 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  23545 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  23549 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23553 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  23556 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23561 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  23565 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  23569 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  23571 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  23575 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23579 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  23583 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  23587 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  23591 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23595 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  23599 */     // MIs[14] src0
     /*  23599 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23604 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  23608 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  23619 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  23623 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23627 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  23631 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  23635 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  23639 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23643 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  23647 */     // MIs[16] src1
     /*  23647 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  23652 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  23656 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  23667 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  23671 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23675 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  23678 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23683 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  23687 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  23691 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  23693 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  23697 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23701 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  23705 */     // MIs[18] src0
     /*  23705 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23710 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  23714 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  23718 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23722 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  23726 */     // MIs[19] src1
     /*  23726 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  23731 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  23735 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  23737 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  23737 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  23740 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  23742 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23745 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  23749 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23752 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  23756 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23759 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
     /*  23763 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23766 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23769 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23772 */     GIR_RootConstrainSelectedInstOperands,
     /*  23773 */     // GIR_Coverage, 2812,
     /*  23773 */     GIR_EraseRootFromParent_Done,
     /*  23774 */   // Label 216: @23774
     /*  23774 */   GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(24249), // Rule ID 10129 //
     /*  23779 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  23782 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  23784 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  23788 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23792 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23796 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  23799 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  23804 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  23808 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  23812 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  23814 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  23818 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  23822 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  23826 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  23830 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  23834 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  23838 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  23842 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  23846 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  23850 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  23854 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  23858 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23862 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  23866 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  23870 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  23872 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  23876 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23880 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  23883 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  23888 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  23892 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  23896 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  23898 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  23902 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  23906 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  23910 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  23914 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23918 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  23922 */     // MIs[7] src0
     /*  23922 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  23927 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  23931 */     // MIs[6] Operand 2
     /*  23931 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  23942 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  23946 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  23950 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  23954 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  23958 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23962 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  23966 */     // MIs[9] src1
     /*  23966 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  23971 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  23975 */     // MIs[8] Operand 2
     /*  23975 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  23986 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  23990 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23994 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  23998 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  24002 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  24004 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  24008 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24012 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  24015 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24020 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  24024 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  24028 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  24030 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  24034 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24038 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  24042 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  24046 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24050 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  24054 */     // MIs[13] src0
     /*  24054 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24059 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  24063 */     // MIs[12] Operand 2
     /*  24063 */     GIM_CheckLiteralInt, /*MI*/12, /*Op*/2, GIMT_Encode8(8),
     /*  24074 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  24078 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24082 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  24086 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  24090 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24094 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  24098 */     // MIs[15] src1
     /*  24098 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  24103 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  24107 */     // MIs[14] Operand 2
     /*  24107 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  24118 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  24122 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24126 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  24130 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  24134 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  24136 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  24140 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24144 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  24147 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24152 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  24156 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  24160 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  24162 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  24166 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24170 */     // MIs[18] src0
     /*  24170 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24175 */     // MIs[18] Operand 2
     /*  24175 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  24186 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  24190 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24194 */     // MIs[19] src1
     /*  24194 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  24199 */     // MIs[19] Operand 2
     /*  24199 */     GIM_CheckLiteralInt, /*MI*/19, /*Op*/2, GIMT_Encode8(8),
     /*  24210 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  24212 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  24212 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  24215 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  24217 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24220 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  24224 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24227 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  24231 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24234 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/2, // src2
     /*  24238 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24241 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24244 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24247 */     GIR_RootConstrainSelectedInstOperands,
     /*  24248 */     // GIR_Coverage, 10129,
     /*  24248 */     GIR_EraseRootFromParent_Done,
     /*  24249 */   // Label 217: @24249
     /*  24249 */   GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(24724), // Rule ID 10128 //
     /*  24254 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  24257 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  24259 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  24263 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24267 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24271 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  24274 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24279 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  24283 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  24287 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  24289 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24293 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  24297 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  24301 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  24305 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  24309 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  24313 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  24317 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  24321 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  24325 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  24329 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  24333 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24337 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  24341 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  24345 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  24347 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  24351 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24355 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  24358 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24363 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  24367 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  24371 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  24373 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  24377 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24381 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  24385 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  24389 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24393 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  24397 */     // MIs[7] src0
     /*  24397 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24402 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  24406 */     // MIs[6] Operand 2
     /*  24406 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  24417 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  24421 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24425 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  24429 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  24433 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24437 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  24441 */     // MIs[9] src1
     /*  24441 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  24446 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  24450 */     // MIs[8] Operand 2
     /*  24450 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  24461 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  24465 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24469 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  24473 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  24477 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  24479 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  24483 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24487 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  24490 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24495 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  24499 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  24503 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  24505 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  24509 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24513 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  24517 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  24521 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24525 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  24529 */     // MIs[13] src0
     /*  24529 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24534 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  24538 */     // MIs[12] Operand 2
     /*  24538 */     GIM_CheckLiteralInt, /*MI*/12, /*Op*/2, GIMT_Encode8(8),
     /*  24549 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  24553 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24557 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  24561 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  24565 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24569 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  24573 */     // MIs[15] src1
     /*  24573 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  24578 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  24582 */     // MIs[14] Operand 2
     /*  24582 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  24593 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  24597 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24601 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  24605 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  24609 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  24611 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/2, // MIs[17]
     /*  24615 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24619 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  24622 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24627 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  24631 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  24635 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  24637 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  24641 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24645 */     // MIs[18] src0
     /*  24645 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24650 */     // MIs[18] Operand 2
     /*  24650 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  24661 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  24665 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24669 */     // MIs[19] src1
     /*  24669 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  24674 */     // MIs[19] Operand 2
     /*  24674 */     GIM_CheckLiteralInt, /*MI*/19, /*Op*/2, GIMT_Encode8(8),
     /*  24685 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  24687 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  24687 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  24690 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  24692 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24695 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  24699 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24702 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  24706 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24709 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/1, // src2
     /*  24713 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24716 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24719 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24722 */     GIR_RootConstrainSelectedInstOperands,
     /*  24723 */     // GIR_Coverage, 10128,
     /*  24723 */     GIR_EraseRootFromParent_Done,
     /*  24724 */   // Label 218: @24724
     /*  24724 */   GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(25199), // Rule ID 10127 //
     /*  24729 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  24732 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  24734 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  24738 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24742 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24746 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  24749 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24754 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  24758 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  24762 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  24764 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24768 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  24772 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  24776 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  24780 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  24784 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  24788 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  24792 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  24796 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  24800 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  24804 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  24808 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24812 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  24816 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  24820 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  24822 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  24826 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24830 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  24833 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24838 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  24842 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  24846 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  24848 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  24852 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24856 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  24860 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  24864 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24868 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  24872 */     // MIs[7] src0
     /*  24872 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24877 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  24881 */     // MIs[6] Operand 2
     /*  24881 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  24892 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  24896 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24900 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  24904 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  24908 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24912 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  24916 */     // MIs[9] src1
     /*  24916 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  24921 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  24925 */     // MIs[8] Operand 2
     /*  24925 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  24936 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  24940 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24944 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  24948 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  24952 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  24954 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  24958 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24962 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  24966 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  24970 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  24972 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  24976 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24980 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  24983 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24988 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  24992 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  24996 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  24998 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  25002 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25006 */     // MIs[13] src0
     /*  25006 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25011 */     // MIs[13] Operand 2
     /*  25011 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  25022 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  25026 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25030 */     // MIs[14] src1
     /*  25030 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25035 */     // MIs[14] Operand 2
     /*  25035 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  25046 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  25050 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25054 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  25057 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25062 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  25066 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  25070 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  25072 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  25076 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25080 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  25084 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  25088 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25092 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  25096 */     // MIs[17] src0
     /*  25096 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25101 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  25105 */     // MIs[16] Operand 2
     /*  25105 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  25116 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  25120 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25124 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  25128 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  25132 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25136 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  25140 */     // MIs[19] src1
     /*  25140 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25145 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  25149 */     // MIs[18] Operand 2
     /*  25149 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  25160 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  25162 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  25162 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  25165 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  25167 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25170 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  25174 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25177 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  25181 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25184 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  25188 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25191 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25194 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25197 */     GIR_RootConstrainSelectedInstOperands,
     /*  25198 */     // GIR_Coverage, 10127,
     /*  25198 */     GIR_EraseRootFromParent_Done,
     /*  25199 */   // Label 219: @25199
     /*  25199 */   GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(25674), // Rule ID 10126 //
     /*  25204 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  25207 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  25209 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  25213 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25217 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25221 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  25224 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25229 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  25233 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  25237 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  25239 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25243 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25247 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  25251 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  25255 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  25259 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  25263 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25267 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  25271 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  25275 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  25279 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  25283 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25287 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  25291 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  25295 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  25297 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  25301 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25305 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  25308 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25313 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  25317 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  25321 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  25323 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  25327 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25331 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  25335 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  25339 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25343 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  25347 */     // MIs[7] src0
     /*  25347 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25352 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  25356 */     // MIs[6] Operand 2
     /*  25356 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  25367 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  25371 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25375 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  25379 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  25383 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25387 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  25391 */     // MIs[9] src1
     /*  25391 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25396 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  25400 */     // MIs[8] Operand 2
     /*  25400 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  25411 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  25415 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25419 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  25423 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  25427 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  25429 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  25433 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25437 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  25441 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  25445 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  25447 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  25451 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25455 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  25458 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25463 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  25467 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  25471 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  25473 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  25477 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25481 */     // MIs[13] src0
     /*  25481 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25486 */     // MIs[13] Operand 2
     /*  25486 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  25497 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  25501 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25505 */     // MIs[14] src1
     /*  25505 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25510 */     // MIs[14] Operand 2
     /*  25510 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  25521 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  25525 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25529 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  25532 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25537 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  25541 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  25545 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  25547 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  25551 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25555 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  25559 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  25563 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25567 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  25571 */     // MIs[17] src0
     /*  25571 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25576 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  25580 */     // MIs[16] Operand 2
     /*  25580 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  25591 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  25595 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25599 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  25603 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  25607 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25611 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  25615 */     // MIs[19] src1
     /*  25615 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25620 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  25624 */     // MIs[18] Operand 2
     /*  25624 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  25635 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  25637 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  25637 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  25640 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  25642 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25645 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  25649 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25652 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  25656 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25659 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  25663 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25666 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25669 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25672 */     GIR_RootConstrainSelectedInstOperands,
     /*  25673 */     // GIR_Coverage, 10126,
     /*  25673 */     GIR_EraseRootFromParent_Done,
     /*  25674 */   // Label 220: @25674
     /*  25674 */   GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(26149), // Rule ID 10125 //
     /*  25679 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  25682 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  25684 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  25688 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25692 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25696 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  25699 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25704 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  25708 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  25712 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  25714 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25718 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25722 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  25726 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  25730 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  25734 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  25738 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25742 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  25746 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  25750 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  25754 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  25758 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25762 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  25766 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  25770 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  25772 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  25776 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25780 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  25784 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  25788 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  25790 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  25794 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25798 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  25801 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25806 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  25810 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  25814 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  25816 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  25820 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25824 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  25828 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  25832 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25836 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  25840 */     // MIs[8] src0
     /*  25840 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25845 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  25849 */     // MIs[7] Operand 2
     /*  25849 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(8),
     /*  25860 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  25864 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25868 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  25872 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  25876 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25880 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  25884 */     // MIs[10] src1
     /*  25884 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25889 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  25893 */     // MIs[9] Operand 2
     /*  25893 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  25904 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  25908 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25912 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  25916 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  25920 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  25922 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  25926 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25930 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  25933 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25938 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  25942 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  25946 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  25948 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  25952 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25956 */     // MIs[13] src0
     /*  25956 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25961 */     // MIs[13] Operand 2
     /*  25961 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  25972 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  25976 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25980 */     // MIs[14] src1
     /*  25980 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25985 */     // MIs[14] Operand 2
     /*  25985 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  25996 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  26000 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26004 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  26007 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26012 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  26016 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  26020 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  26022 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  26026 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26030 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  26034 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  26038 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26042 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  26046 */     // MIs[17] src0
     /*  26046 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26051 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  26055 */     // MIs[16] Operand 2
     /*  26055 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  26066 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  26070 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26074 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  26078 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  26082 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26086 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  26090 */     // MIs[19] src1
     /*  26090 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26095 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  26099 */     // MIs[18] Operand 2
     /*  26099 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  26110 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  26112 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  26112 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  26115 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  26117 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26120 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  26124 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26127 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  26131 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26134 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  26138 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26141 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26144 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26147 */     GIR_RootConstrainSelectedInstOperands,
     /*  26148 */     // GIR_Coverage, 10125,
     /*  26148 */     GIR_EraseRootFromParent_Done,
     /*  26149 */   // Label 221: @26149
     /*  26149 */   GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(26624), // Rule ID 10124 //
     /*  26154 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  26157 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  26159 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  26163 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26167 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26171 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  26174 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26179 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  26183 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  26187 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  26189 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  26193 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26197 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  26201 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  26205 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  26209 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  26213 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26217 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  26221 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  26225 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  26229 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  26233 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26237 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  26241 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  26245 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  26247 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  26251 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26255 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  26259 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  26263 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  26265 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  26269 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26273 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  26276 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26281 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  26285 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  26289 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  26291 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  26295 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26299 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  26303 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  26307 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26311 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  26315 */     // MIs[8] src0
     /*  26315 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26320 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  26324 */     // MIs[7] Operand 2
     /*  26324 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(8),
     /*  26335 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  26339 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26343 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  26347 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  26351 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26355 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  26359 */     // MIs[10] src1
     /*  26359 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26364 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  26368 */     // MIs[9] Operand 2
     /*  26368 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  26379 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  26383 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26387 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  26391 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  26395 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  26397 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  26401 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26405 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  26408 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26413 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  26417 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  26421 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  26423 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  26427 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26431 */     // MIs[13] src0
     /*  26431 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26436 */     // MIs[13] Operand 2
     /*  26436 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  26447 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  26451 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26455 */     // MIs[14] src1
     /*  26455 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26460 */     // MIs[14] Operand 2
     /*  26460 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  26471 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  26475 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26479 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  26482 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26487 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  26491 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  26495 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  26497 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  26501 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26505 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  26509 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  26513 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26517 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  26521 */     // MIs[17] src0
     /*  26521 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26526 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  26530 */     // MIs[16] Operand 2
     /*  26530 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  26541 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  26545 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26549 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  26553 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  26557 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26561 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  26565 */     // MIs[19] src1
     /*  26565 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26570 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  26574 */     // MIs[18] Operand 2
     /*  26574 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  26585 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  26587 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  26587 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  26590 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  26592 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26595 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  26599 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26602 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  26606 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26609 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  26613 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26616 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26619 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26622 */     GIR_RootConstrainSelectedInstOperands,
     /*  26623 */     // GIR_Coverage, 10124,
     /*  26623 */     GIR_EraseRootFromParent_Done,
     /*  26624 */   // Label 222: @26624
     /*  26624 */   GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(27099), // Rule ID 10123 //
     /*  26629 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  26632 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  26634 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  26638 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26642 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26646 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  26649 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26654 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  26658 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  26662 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  26664 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  26668 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26672 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  26676 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  26680 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  26684 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  26688 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26692 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  26696 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  26700 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  26704 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  26708 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26712 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  26716 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  26720 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  26722 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  26726 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26730 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  26734 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  26738 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  26740 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  26744 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26748 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  26752 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  26756 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  26758 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  26762 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26766 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  26769 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26774 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  26778 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  26782 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  26784 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  26788 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26792 */     // MIs[8] src0
     /*  26792 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26797 */     // MIs[8] Operand 2
     /*  26797 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  26808 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  26812 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26816 */     // MIs[9] src1
     /*  26816 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26821 */     // MIs[9] Operand 2
     /*  26821 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  26832 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  26836 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26840 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  26843 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26848 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  26852 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  26856 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  26858 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  26862 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26866 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  26870 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  26874 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26878 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  26882 */     // MIs[12] src0
     /*  26882 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26887 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  26891 */     // MIs[11] Operand 2
     /*  26891 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  26902 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  26906 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26910 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  26914 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  26918 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26922 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  26926 */     // MIs[14] src1
     /*  26926 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26931 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  26935 */     // MIs[13] Operand 2
     /*  26935 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  26946 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  26950 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26954 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  26957 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26962 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  26966 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  26970 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  26972 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  26976 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26980 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  26984 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  26988 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26992 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  26996 */     // MIs[17] src0
     /*  26996 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27001 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  27005 */     // MIs[16] Operand 2
     /*  27005 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  27016 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  27020 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27024 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  27028 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  27032 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27036 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  27040 */     // MIs[19] src1
     /*  27040 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27045 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  27049 */     // MIs[18] Operand 2
     /*  27049 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  27060 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  27062 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  27062 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  27065 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  27067 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27070 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  27074 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27077 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  27081 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27084 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/2, // src2
     /*  27088 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27091 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27094 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27097 */     GIR_RootConstrainSelectedInstOperands,
     /*  27098 */     // GIR_Coverage, 10123,
     /*  27098 */     GIR_EraseRootFromParent_Done,
     /*  27099 */   // Label 223: @27099
     /*  27099 */   GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(27574), // Rule ID 10122 //
     /*  27104 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  27107 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  27109 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  27113 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27117 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27121 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  27124 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27129 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27133 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  27137 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  27139 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  27143 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27147 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  27151 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27155 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  27159 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  27163 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27167 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  27171 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  27175 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  27179 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  27183 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27187 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  27191 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  27195 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  27197 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  27201 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27205 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  27209 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  27213 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  27215 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27219 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27223 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  27227 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  27231 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  27233 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  27237 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27241 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  27244 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27249 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  27253 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  27257 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  27259 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  27263 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27267 */     // MIs[8] src0
     /*  27267 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27272 */     // MIs[8] Operand 2
     /*  27272 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  27283 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  27287 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27291 */     // MIs[9] src1
     /*  27291 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27296 */     // MIs[9] Operand 2
     /*  27296 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  27307 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  27311 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27315 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  27318 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27323 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  27327 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  27331 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  27333 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  27337 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27341 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  27345 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  27349 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27353 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  27357 */     // MIs[12] src0
     /*  27357 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27362 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  27366 */     // MIs[11] Operand 2
     /*  27366 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  27377 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  27381 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27385 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  27389 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  27393 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27397 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  27401 */     // MIs[14] src1
     /*  27401 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27406 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  27410 */     // MIs[13] Operand 2
     /*  27410 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  27421 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  27425 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27429 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  27432 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27437 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  27441 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  27445 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  27447 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  27451 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27455 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  27459 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  27463 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27467 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  27471 */     // MIs[17] src0
     /*  27471 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27476 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  27480 */     // MIs[16] Operand 2
     /*  27480 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  27491 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  27495 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27499 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  27503 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  27507 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27511 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  27515 */     // MIs[19] src1
     /*  27515 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27520 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  27524 */     // MIs[18] Operand 2
     /*  27524 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  27535 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  27537 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  27537 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  27540 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  27542 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27545 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  27549 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27552 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  27556 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27559 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src2
     /*  27563 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27566 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27569 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27572 */     GIR_RootConstrainSelectedInstOperands,
     /*  27573 */     // GIR_Coverage, 10122,
     /*  27573 */     GIR_EraseRootFromParent_Done,
     /*  27574 */   // Label 224: @27574
     /*  27574 */   GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(28049), // Rule ID 10121 //
     /*  27579 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  27582 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  27584 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  27588 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27592 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27596 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27600 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27604 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  27606 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  27610 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27614 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  27617 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27622 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27626 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  27630 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  27632 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  27636 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27640 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  27644 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  27648 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27652 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  27656 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  27660 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  27664 */     // MIs[3] Operand 2
     /*  27664 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  27675 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  27679 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27683 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  27687 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27691 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27695 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  27699 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  27703 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  27707 */     // MIs[5] Operand 2
     /*  27707 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  27718 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  27722 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27726 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  27730 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  27734 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  27736 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  27740 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27744 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  27747 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27752 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  27756 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  27760 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  27762 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  27766 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27770 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  27774 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  27778 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27782 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  27786 */     // MIs[10] src0
     /*  27786 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  27791 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  27795 */     // MIs[9] Operand 2
     /*  27795 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  27806 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  27810 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27814 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  27818 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  27822 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27826 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  27830 */     // MIs[12] src1
     /*  27830 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  27835 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  27839 */     // MIs[11] Operand 2
     /*  27839 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  27850 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  27854 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27858 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  27862 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  27866 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  27868 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  27872 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27876 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  27879 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27884 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  27888 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  27892 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  27894 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  27898 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27902 */     // MIs[15] src0
     /*  27902 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  27907 */     // MIs[15] Operand 2
     /*  27907 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  27918 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  27922 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27926 */     // MIs[16] src1
     /*  27926 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  27931 */     // MIs[16] Operand 2
     /*  27931 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  27942 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  27946 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27950 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  27953 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27958 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  27962 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  27966 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  27968 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  27972 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27976 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  27980 */     // MIs[18] src0
     /*  27980 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  27985 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  27989 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  27993 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27997 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  28001 */     // MIs[19] src1
     /*  28001 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  28006 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  28010 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  28012 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  28012 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  28015 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  28017 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28020 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  28024 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28027 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  28031 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28034 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/2, // src2
     /*  28038 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28041 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28044 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28047 */     GIR_RootConstrainSelectedInstOperands,
     /*  28048 */     // GIR_Coverage, 10121,
     /*  28048 */     GIR_EraseRootFromParent_Done,
     /*  28049 */   // Label 225: @28049
     /*  28049 */   GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(28524), // Rule ID 10120 //
     /*  28054 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  28057 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  28059 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  28063 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28067 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28071 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  28075 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  28079 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  28081 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28085 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28089 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  28092 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28097 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  28101 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  28105 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  28107 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  28111 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28115 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  28119 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  28123 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28127 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  28131 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  28135 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  28139 */     // MIs[3] Operand 2
     /*  28139 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  28150 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  28154 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28158 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  28162 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28166 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28170 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  28174 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  28178 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  28182 */     // MIs[5] Operand 2
     /*  28182 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  28193 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  28197 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28201 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  28205 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  28209 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  28211 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  28215 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28219 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  28222 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28227 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  28231 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  28235 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  28237 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  28241 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28245 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  28249 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  28253 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28257 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  28261 */     // MIs[10] src0
     /*  28261 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  28266 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  28270 */     // MIs[9] Operand 2
     /*  28270 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  28281 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  28285 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28289 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  28293 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  28297 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28301 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  28305 */     // MIs[12] src1
     /*  28305 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  28310 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  28314 */     // MIs[11] Operand 2
     /*  28314 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  28325 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  28329 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28333 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  28337 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  28341 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  28343 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/2, // MIs[14]
     /*  28347 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28351 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  28354 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28359 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  28363 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  28367 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  28369 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  28373 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28377 */     // MIs[15] src0
     /*  28377 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  28382 */     // MIs[15] Operand 2
     /*  28382 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  28393 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  28397 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28401 */     // MIs[16] src1
     /*  28401 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  28406 */     // MIs[16] Operand 2
     /*  28406 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  28417 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  28421 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28425 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  28428 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28433 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  28437 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  28441 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  28443 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  28447 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  28451 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  28455 */     // MIs[18] src0
     /*  28455 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  28460 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  28464 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  28468 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  28472 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  28476 */     // MIs[19] src1
     /*  28476 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  28481 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  28485 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  28487 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  28487 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  28490 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  28492 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28495 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  28499 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28502 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  28506 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28509 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/1, // src2
     /*  28513 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28516 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28519 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28522 */     GIR_RootConstrainSelectedInstOperands,
     /*  28523 */     // GIR_Coverage, 10120,
     /*  28523 */     GIR_EraseRootFromParent_Done,
     /*  28524 */   // Label 226: @28524
     /*  28524 */   GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(28999), // Rule ID 10119 //
     /*  28529 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  28532 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  28534 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  28538 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28542 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28546 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  28550 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  28554 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  28556 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28560 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28564 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  28567 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28572 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  28576 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  28580 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  28582 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  28586 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28590 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  28594 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  28598 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28602 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  28606 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  28610 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  28614 */     // MIs[3] Operand 2
     /*  28614 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  28625 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  28629 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28633 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  28637 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28641 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28645 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  28649 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  28653 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  28657 */     // MIs[5] Operand 2
     /*  28657 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  28668 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  28672 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28676 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  28680 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  28684 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  28686 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  28690 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28694 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  28698 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  28702 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  28704 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  28708 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28712 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  28715 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28720 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  28724 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  28728 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  28730 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  28734 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28738 */     // MIs[10] src0
     /*  28738 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  28743 */     // MIs[10] Operand 2
     /*  28743 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  28754 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  28758 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28762 */     // MIs[11] src1
     /*  28762 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  28767 */     // MIs[11] Operand 2
     /*  28767 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  28778 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  28782 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28786 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  28789 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28794 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  28798 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  28802 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  28804 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  28808 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28812 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  28816 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  28820 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28824 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  28828 */     // MIs[14] src0
     /*  28828 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  28833 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  28837 */     // MIs[13] Operand 2
     /*  28837 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  28848 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  28852 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28856 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  28860 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  28864 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28868 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  28872 */     // MIs[16] src1
     /*  28872 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  28877 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  28881 */     // MIs[15] Operand 2
     /*  28881 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  28892 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  28896 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28900 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  28903 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28908 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  28912 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  28916 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  28918 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  28922 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  28926 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  28930 */     // MIs[18] src0
     /*  28930 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  28935 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  28939 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  28943 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  28947 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  28951 */     // MIs[19] src1
     /*  28951 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  28956 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  28960 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  28962 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  28962 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  28965 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  28967 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28970 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  28974 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28977 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  28981 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28984 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  28988 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28991 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28994 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28997 */     GIR_RootConstrainSelectedInstOperands,
     /*  28998 */     // GIR_Coverage, 10119,
     /*  28998 */     GIR_EraseRootFromParent_Done,
     /*  28999 */   // Label 227: @28999
     /*  28999 */   GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(29474), // Rule ID 10118 //
     /*  29004 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  29007 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  29009 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  29013 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29017 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29021 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  29025 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  29029 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  29031 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29035 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29039 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  29042 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29047 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  29051 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  29055 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  29057 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  29061 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29065 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  29069 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  29073 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29077 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  29081 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  29085 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  29089 */     // MIs[3] Operand 2
     /*  29089 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  29100 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  29104 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29108 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  29112 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  29116 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29120 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  29124 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  29128 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  29132 */     // MIs[5] Operand 2
     /*  29132 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  29143 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  29147 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29151 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  29155 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  29159 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  29161 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  29165 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29169 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  29173 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  29177 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  29179 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  29183 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29187 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  29190 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29195 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  29199 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  29203 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  29205 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  29209 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29213 */     // MIs[10] src0
     /*  29213 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29218 */     // MIs[10] Operand 2
     /*  29218 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  29229 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  29233 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29237 */     // MIs[11] src1
     /*  29237 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29242 */     // MIs[11] Operand 2
     /*  29242 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  29253 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  29257 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29261 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  29264 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29269 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  29273 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  29277 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  29279 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  29283 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29287 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  29291 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  29295 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29299 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  29303 */     // MIs[14] src0
     /*  29303 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29308 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  29312 */     // MIs[13] Operand 2
     /*  29312 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  29323 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  29327 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29331 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  29335 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  29339 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29343 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  29347 */     // MIs[16] src1
     /*  29347 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29352 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  29356 */     // MIs[15] Operand 2
     /*  29356 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  29367 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  29371 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29375 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  29378 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29383 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  29387 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  29391 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  29393 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  29397 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29401 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  29405 */     // MIs[18] src0
     /*  29405 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29410 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  29414 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  29418 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29422 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  29426 */     // MIs[19] src1
     /*  29426 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29431 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  29435 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  29437 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  29437 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  29440 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  29442 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29445 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  29449 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29452 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  29456 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29459 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  29463 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29466 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29469 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29472 */     GIR_RootConstrainSelectedInstOperands,
     /*  29473 */     // GIR_Coverage, 10118,
     /*  29473 */     GIR_EraseRootFromParent_Done,
     /*  29474 */   // Label 228: @29474
     /*  29474 */   GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(29949), // Rule ID 10117 //
     /*  29479 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  29482 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  29484 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  29488 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29492 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29496 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  29500 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  29504 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  29506 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29510 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29514 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  29518 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  29522 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  29524 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  29528 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29532 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  29535 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29540 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  29544 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  29548 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  29550 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  29554 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29558 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  29562 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  29566 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29570 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  29574 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  29578 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  29582 */     // MIs[4] Operand 2
     /*  29582 */     GIM_CheckLiteralInt, /*MI*/4, /*Op*/2, GIMT_Encode8(8),
     /*  29593 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  29597 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29601 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  29605 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  29609 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29613 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  29617 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  29621 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  29625 */     // MIs[6] Operand 2
     /*  29625 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  29636 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  29640 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29644 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  29648 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  29652 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  29654 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  29658 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29662 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  29665 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29670 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  29674 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  29678 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  29680 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  29684 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29688 */     // MIs[10] src0
     /*  29688 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  29693 */     // MIs[10] Operand 2
     /*  29693 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  29704 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  29708 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29712 */     // MIs[11] src1
     /*  29712 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  29717 */     // MIs[11] Operand 2
     /*  29717 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  29728 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  29732 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29736 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  29739 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29744 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  29748 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  29752 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  29754 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  29758 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29762 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  29766 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  29770 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29774 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  29778 */     // MIs[14] src0
     /*  29778 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  29783 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  29787 */     // MIs[13] Operand 2
     /*  29787 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  29798 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  29802 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29806 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  29810 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  29814 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29818 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  29822 */     // MIs[16] src1
     /*  29822 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  29827 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  29831 */     // MIs[15] Operand 2
     /*  29831 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  29842 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  29846 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29850 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  29853 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29858 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  29862 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  29866 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  29868 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  29872 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29876 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  29880 */     // MIs[18] src0
     /*  29880 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  29885 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  29889 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  29893 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29897 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  29901 */     // MIs[19] src1
     /*  29901 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  29906 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  29910 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  29912 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  29912 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  29915 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  29917 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29920 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  29924 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29927 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  29931 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29934 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  29938 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29941 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29944 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29947 */     GIR_RootConstrainSelectedInstOperands,
     /*  29948 */     // GIR_Coverage, 10117,
     /*  29948 */     GIR_EraseRootFromParent_Done,
     /*  29949 */   // Label 229: @29949
     /*  29949 */   GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(30424), // Rule ID 10116 //
     /*  29954 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  29957 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  29959 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  29963 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29967 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29971 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  29975 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  29979 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  29981 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29985 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29989 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  29993 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  29997 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  29999 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  30003 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30007 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  30010 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30015 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  30019 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  30023 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  30025 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  30029 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30033 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  30037 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  30041 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30045 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  30049 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  30053 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  30057 */     // MIs[4] Operand 2
     /*  30057 */     GIM_CheckLiteralInt, /*MI*/4, /*Op*/2, GIMT_Encode8(8),
     /*  30068 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  30072 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30076 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  30080 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  30084 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30088 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  30092 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  30096 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  30100 */     // MIs[6] Operand 2
     /*  30100 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  30111 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  30115 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30119 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  30123 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  30127 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  30129 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  30133 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30137 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  30140 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30145 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  30149 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  30153 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  30155 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  30159 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30163 */     // MIs[10] src0
     /*  30163 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  30168 */     // MIs[10] Operand 2
     /*  30168 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  30179 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  30183 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30187 */     // MIs[11] src1
     /*  30187 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  30192 */     // MIs[11] Operand 2
     /*  30192 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  30203 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  30207 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30211 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  30214 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30219 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  30223 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  30227 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  30229 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  30233 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30237 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  30241 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  30245 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30249 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  30253 */     // MIs[14] src0
     /*  30253 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  30258 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  30262 */     // MIs[13] Operand 2
     /*  30262 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  30273 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  30277 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30281 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  30285 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  30289 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30293 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  30297 */     // MIs[16] src1
     /*  30297 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  30302 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  30306 */     // MIs[15] Operand 2
     /*  30306 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  30317 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  30321 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30325 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  30328 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30333 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  30337 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  30341 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  30343 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  30347 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30351 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  30355 */     // MIs[18] src0
     /*  30355 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  30360 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  30364 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  30368 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30372 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  30376 */     // MIs[19] src1
     /*  30376 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  30381 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  30385 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  30387 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  30387 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  30390 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  30392 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30395 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  30399 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30402 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  30406 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30409 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  30413 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30416 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30419 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30422 */     GIR_RootConstrainSelectedInstOperands,
     /*  30423 */     // GIR_Coverage, 10116,
     /*  30423 */     GIR_EraseRootFromParent_Done,
     /*  30424 */   // Label 230: @30424
     /*  30424 */   GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(30899), // Rule ID 10115 //
     /*  30429 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  30432 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  30434 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  30438 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30442 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30446 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  30450 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  30454 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  30456 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30460 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30464 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  30468 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  30472 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  30474 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  30478 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30482 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  30486 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  30490 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  30492 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  30496 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30500 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  30503 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30508 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  30512 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  30516 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  30518 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  30522 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30526 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  30530 */     // MIs[5] Operand 2
     /*  30530 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  30541 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  30545 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30549 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  30553 */     // MIs[6] Operand 2
     /*  30553 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  30564 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  30568 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30572 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  30575 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30580 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  30584 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  30588 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  30590 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  30594 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30598 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  30602 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  30606 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30610 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  30614 */     // MIs[9] src0
     /*  30614 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  30619 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  30623 */     // MIs[8] Operand 2
     /*  30623 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  30634 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  30638 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30642 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  30646 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  30650 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30654 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  30658 */     // MIs[11] src1
     /*  30658 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30663 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  30667 */     // MIs[10] Operand 2
     /*  30667 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  30678 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  30682 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30686 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  30689 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30694 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  30698 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  30702 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  30704 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  30708 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30712 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  30716 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  30720 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30724 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  30728 */     // MIs[14] src0
     /*  30728 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  30733 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  30737 */     // MIs[13] Operand 2
     /*  30737 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  30748 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  30752 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30756 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  30760 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  30764 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30768 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  30772 */     // MIs[16] src1
     /*  30772 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30777 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  30781 */     // MIs[15] Operand 2
     /*  30781 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  30792 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  30796 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30800 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  30803 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30808 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  30812 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  30816 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  30818 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  30822 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30826 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  30830 */     // MIs[18] src0
     /*  30830 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  30835 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  30839 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  30843 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30847 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  30851 */     // MIs[19] src1
     /*  30851 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  30856 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  30860 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  30862 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  30862 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  30865 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  30867 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30870 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  30874 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30877 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  30881 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30884 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  30888 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30891 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30894 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30897 */     GIR_RootConstrainSelectedInstOperands,
     /*  30898 */     // GIR_Coverage, 10115,
     /*  30898 */     GIR_EraseRootFromParent_Done,
     /*  30899 */   // Label 231: @30899
     /*  30899 */   GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(31374), // Rule ID 2828 //
     /*  30904 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  30907 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  30909 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  30913 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30917 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30921 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  30925 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  30929 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  30931 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30935 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30939 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  30943 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  30947 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  30949 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  30953 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30957 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  30961 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  30965 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  30967 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  30971 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30975 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  30978 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30983 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  30987 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  30991 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  30993 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  30997 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31001 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  31005 */     // MIs[5] Operand 2
     /*  31005 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  31016 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  31020 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31024 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  31028 */     // MIs[6] Operand 2
     /*  31028 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  31039 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  31043 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31047 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  31050 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31055 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  31059 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  31063 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  31065 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  31069 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31073 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  31077 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  31081 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31085 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  31089 */     // MIs[9] src0
     /*  31089 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31094 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  31098 */     // MIs[8] Operand 2
     /*  31098 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  31109 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  31113 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31117 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  31121 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  31125 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31129 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  31133 */     // MIs[11] src1
     /*  31133 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  31138 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  31142 */     // MIs[10] Operand 2
     /*  31142 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  31153 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  31157 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31161 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  31164 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31169 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  31173 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  31177 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  31179 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  31183 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31187 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  31191 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  31195 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31199 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  31203 */     // MIs[14] src0
     /*  31203 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31208 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  31212 */     // MIs[13] Operand 2
     /*  31212 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  31223 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  31227 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31231 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  31235 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  31239 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31243 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  31247 */     // MIs[16] src1
     /*  31247 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  31252 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  31256 */     // MIs[15] Operand 2
     /*  31256 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  31267 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  31271 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31275 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  31278 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31283 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  31287 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  31291 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  31293 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  31297 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  31301 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  31305 */     // MIs[18] src0
     /*  31305 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31310 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  31314 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  31318 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  31322 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  31326 */     // MIs[19] src1
     /*  31326 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  31331 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  31335 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  31337 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  31337 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  31340 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  31342 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31345 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  31349 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31352 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  31356 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31359 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
     /*  31363 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31366 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31369 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31372 */     GIR_RootConstrainSelectedInstOperands,
     /*  31373 */     // GIR_Coverage, 2828,
     /*  31373 */     GIR_EraseRootFromParent_Done,
     /*  31374 */   // Label 232: @31374
     /*  31374 */   GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(31597), // Rule ID 8772 //
     /*  31379 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  31382 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  31386 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31390 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31394 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  31397 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  31402 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  31406 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  31410 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  31412 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  31416 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31420 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  31424 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  31428 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
     /*  31439 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  31443 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31447 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  31451 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  31455 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
     /*  31466 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  31470 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31474 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  31478 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  31482 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  31484 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  31488 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31492 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  31495 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  31500 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  31504 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  31508 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  31510 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  31514 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31518 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  31522 */     // MIs[6] src0
     /*  31522 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  31527 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  31531 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  31535 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31539 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  31543 */     // MIs[7] src1
     /*  31543 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  31548 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  31552 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  31554 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  31554 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  31557 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  31559 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31562 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  31566 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31569 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  31573 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31576 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // src2
     /*  31580 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31583 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31586 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31589 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31592 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31595 */     GIR_RootConstrainSelectedInstOperands,
     /*  31596 */     // GIR_Coverage, 8772,
     /*  31596 */     GIR_EraseRootFromParent_Done,
     /*  31597 */   // Label 233: @31597
     /*  31597 */   GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(31820), // Rule ID 8773 //
     /*  31602 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  31605 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  31609 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31613 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31617 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  31620 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  31625 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  31629 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  31633 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  31635 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  31639 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31643 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  31647 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  31651 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
     /*  31662 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  31666 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31670 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  31674 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  31678 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
     /*  31689 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  31693 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31697 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  31701 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  31705 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  31707 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  31711 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31715 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  31718 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  31723 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  31727 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  31731 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  31733 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  31737 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31741 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  31745 */     // MIs[6] src0
     /*  31745 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  31750 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  31754 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  31758 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31762 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  31766 */     // MIs[7] src1
     /*  31766 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  31771 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  31775 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  31777 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  31777 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  31780 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  31782 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31785 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  31789 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31792 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  31796 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31799 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src2
     /*  31803 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31806 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31809 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31812 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31815 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31818 */     GIR_RootConstrainSelectedInstOperands,
     /*  31819 */     // GIR_Coverage, 8773,
     /*  31819 */     GIR_EraseRootFromParent_Done,
     /*  31820 */   // Label 234: @31820
     /*  31820 */   GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(32043), // Rule ID 2804 //
     /*  31825 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  31828 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  31832 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31836 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31840 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  31844 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  31848 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  31850 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31854 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31858 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  31861 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  31866 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  31870 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  31874 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  31876 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  31880 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31884 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  31888 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  31892 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  31896 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  31900 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31904 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  31908 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  31912 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  31916 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  31920 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31924 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  31927 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  31932 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  31936 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  31940 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  31942 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  31946 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31950 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  31954 */     // MIs[6] src0
     /*  31954 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  31959 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(65535),
     /*  31970 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  31974 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31978 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  31982 */     // MIs[7] src1
     /*  31982 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  31987 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(65535),
     /*  31998 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  32000 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  32000 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  32003 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  32005 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32008 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  32012 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32015 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  32019 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32022 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  32026 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32029 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32032 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32035 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32038 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32041 */     GIR_RootConstrainSelectedInstOperands,
     /*  32042 */     // GIR_Coverage, 2804,
     /*  32042 */     GIR_EraseRootFromParent_Done,
     /*  32043 */   // Label 235: @32043
     /*  32043 */   GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(32266), // Rule ID 8771 //
     /*  32048 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  32051 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  32055 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32059 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32063 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  32067 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  32071 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  32073 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  32077 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32081 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  32084 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  32089 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  32093 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  32097 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  32099 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  32103 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32107 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32111 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  32115 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  32119 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  32123 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32127 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  32131 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  32135 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  32139 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  32143 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32147 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  32150 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  32155 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  32159 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  32163 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  32165 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32169 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32173 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  32177 */     // MIs[6] src0
     /*  32177 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32182 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(65535),
     /*  32193 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  32197 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32201 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  32205 */     // MIs[7] src1
     /*  32205 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  32210 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(65535),
     /*  32221 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  32223 */     // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  32223 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  32226 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  32228 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32231 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  32235 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32238 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  32242 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32245 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
     /*  32249 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32252 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32255 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32258 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32261 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32264 */     GIR_RootConstrainSelectedInstOperands,
     /*  32265 */     // GIR_Coverage, 8771,
     /*  32265 */     GIR_EraseRootFromParent_Done,
     /*  32266 */   // Label 236: @32266
     /*  32266 */   GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(32481), // Rule ID 8804 //
     /*  32271 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  32274 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  32278 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32282 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32286 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  32289 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32294 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  32298 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  32302 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  32304 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  32308 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32312 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  32316 */     // MIs[2] Operand 2
     /*  32316 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*  32327 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  32331 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32335 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32339 */     // MIs[3] Operand 2
     /*  32339 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*  32350 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  32354 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32358 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  32362 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  32366 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  32368 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  32372 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32376 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  32379 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32384 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  32388 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  32392 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  32394 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32398 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32402 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  32406 */     // MIs[6] src0
     /*  32406 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  32411 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  32415 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  32419 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32423 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  32427 */     // MIs[7] src1
     /*  32427 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32432 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  32436 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  32438 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  32438 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  32441 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  32443 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32446 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  32450 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32453 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  32457 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32460 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // src2
     /*  32464 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32467 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32470 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32473 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32476 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32479 */     GIR_RootConstrainSelectedInstOperands,
     /*  32480 */     // GIR_Coverage, 8804,
     /*  32480 */     GIR_EraseRootFromParent_Done,
     /*  32481 */   // Label 237: @32481
     /*  32481 */   GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(32696), // Rule ID 8805 //
     /*  32486 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  32489 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  32493 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32497 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32501 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  32504 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32509 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  32513 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  32517 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  32519 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  32523 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32527 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  32531 */     // MIs[2] Operand 2
     /*  32531 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*  32542 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  32546 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32550 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32554 */     // MIs[3] Operand 2
     /*  32554 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*  32565 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  32569 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32573 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  32577 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  32581 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  32583 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  32587 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32591 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  32594 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32599 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  32603 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  32607 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  32609 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32613 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32617 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  32621 */     // MIs[6] src0
     /*  32621 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  32626 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  32630 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  32634 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32638 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  32642 */     // MIs[7] src1
     /*  32642 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32647 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  32651 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  32653 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  32653 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  32656 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  32658 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32661 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  32665 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32668 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  32672 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32675 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src2
     /*  32679 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32682 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32685 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32688 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32691 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32694 */     GIR_RootConstrainSelectedInstOperands,
     /*  32695 */     // GIR_Coverage, 8805,
     /*  32695 */     GIR_EraseRootFromParent_Done,
     /*  32696 */   // Label 238: @32696
     /*  32696 */   GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(32911), // Rule ID 2808 //
     /*  32701 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  32704 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  32708 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32712 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32716 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  32720 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  32724 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  32726 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32730 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32734 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  32737 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32742 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  32746 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  32750 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  32752 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  32756 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32760 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32764 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  32768 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  32772 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  32776 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32780 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  32784 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  32788 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  32792 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  32796 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32800 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  32803 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32808 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  32812 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  32816 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  32818 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32822 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32826 */     // MIs[6] src0
     /*  32826 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32831 */     // MIs[6] Operand 2
     /*  32831 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(16),
     /*  32842 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  32846 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32850 */     // MIs[7] src1
     /*  32850 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  32855 */     // MIs[7] Operand 2
     /*  32855 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(16),
     /*  32866 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  32868 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  32868 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  32871 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  32873 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32876 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  32880 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32883 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  32887 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32890 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  32894 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32897 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32900 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32903 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32906 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32909 */     GIR_RootConstrainSelectedInstOperands,
     /*  32910 */     // GIR_Coverage, 2808,
     /*  32910 */     GIR_EraseRootFromParent_Done,
     /*  32911 */   // Label 239: @32911
     /*  32911 */   GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(33126), // Rule ID 8803 //
     /*  32916 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  32919 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  32923 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32927 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32931 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  32935 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  32939 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  32941 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  32945 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32949 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  32952 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32957 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  32961 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  32965 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  32967 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  32971 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32975 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32979 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  32983 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  32987 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  32991 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32995 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  32999 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  33003 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  33007 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  33011 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33015 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  33018 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  33023 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  33027 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  33031 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  33033 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33037 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  33041 */     // MIs[6] src0
     /*  33041 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33046 */     // MIs[6] Operand 2
     /*  33046 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(16),
     /*  33057 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  33061 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  33065 */     // MIs[7] src1
     /*  33065 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  33070 */     // MIs[7] Operand 2
     /*  33070 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(16),
     /*  33081 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  33083 */     // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33083 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  33086 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33088 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33091 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  33095 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33098 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  33102 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33105 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
     /*  33109 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33112 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33115 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33118 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33121 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33124 */     GIR_RootConstrainSelectedInstOperands,
     /*  33125 */     // GIR_Coverage, 8803,
     /*  33125 */     GIR_EraseRootFromParent_Done,
     /*  33126 */   // Label 240: @33126
     /*  33126 */   GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(33179), // Rule ID 7809 //
     /*  33131 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  33135 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33139 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  33143 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33147 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33151 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  33155 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  33159 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13991),
     /*  33163 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33165 */     // (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$a), -1:{ *:[i32] })<<P:Predicate_anonymous_13991>>  =>  (S_BFM_B32:{ *:[i32] } ?:{ *:[i32] }:$a, 0:{ *:[i32] })
     /*  33165 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_BFM_B32),
     /*  33168 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  33170 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // a
     /*  33174 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33177 */     GIR_RootConstrainSelectedInstOperands,
     /*  33178 */     // GIR_Coverage, 7809,
     /*  33178 */     GIR_EraseRootFromParent_Done,
     /*  33179 */   // Label 241: @33179
     /*  33179 */   GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(33232), // Rule ID 7811 //
     /*  33184 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33188 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33192 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  33196 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33200 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33204 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  33208 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  33212 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20182),
     /*  33216 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33218 */     // (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$a), -1:{ *:[i32] })<<P:Predicate_anonymous_20182>>  =>  (V_BFM_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$a, 0:{ *:[i32] })
     /*  33218 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFM_B32_e64),
     /*  33221 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33223 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // a
     /*  33227 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33230 */     GIR_RootConstrainSelectedInstOperands,
     /*  33231 */     // GIR_Coverage, 7811,
     /*  33231 */     GIR_EraseRootFromParent_Done,
     /*  33232 */   // Label 242: @33232
     /*  33232 */   GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(33342), // Rule ID 7612 //
     /*  33237 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33241 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33245 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  33249 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*  33253 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33257 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  33261 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33263 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33267 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /*  33271 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  33275 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  33279 */     // MIs[2] Operand 1
     /*  33279 */     GIM_CheckCmpPredicate, /*MI*/2, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGT),
     /*  33284 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  33288 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  33292 */     // MIs[3] src0
     /*  33292 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  33297 */     // MIs[3] src1
     /*  33297 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  33302 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/3, // MIs[4]
     /*  33306 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  33310 */     // MIs[4] src1
     /*  33310 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  33315 */     // MIs[4] src0
     /*  33315 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  33320 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  33322 */     // (add:{ *:[i32] } (select:{ *:[i32] } (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETUGT:{ *:[Other] }), (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (sub:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_select_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33322 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  33325 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33327 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  33331 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // src1
     /*  33335 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  33337 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33340 */     GIR_RootConstrainSelectedInstOperands,
     /*  33341 */     // GIR_Coverage, 7612,
     /*  33341 */     GIR_EraseRootFromParent_Done,
     /*  33342 */   // Label 243: @33342
     /*  33342 */   GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(33452), // Rule ID 11445 //
     /*  33347 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33351 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  33355 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  33359 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*  33363 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33367 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  33371 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33373 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33377 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /*  33381 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  33385 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  33389 */     // MIs[2] Operand 1
     /*  33389 */     GIM_CheckCmpPredicate, /*MI*/2, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGT),
     /*  33394 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  33398 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  33402 */     // MIs[3] src0
     /*  33402 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  33407 */     // MIs[3] src1
     /*  33407 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  33412 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/3, // MIs[4]
     /*  33416 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  33420 */     // MIs[4] src1
     /*  33420 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  33425 */     // MIs[4] src0
     /*  33425 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  33430 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  33432 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (select:{ *:[i32] } (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETUGT:{ *:[Other] }), (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (sub:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_select_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33432 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  33435 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33437 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  33441 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // src1
     /*  33445 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  33447 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33450 */     GIR_RootConstrainSelectedInstOperands,
     /*  33451 */     // GIR_Coverage, 11445,
     /*  33451 */     GIR_EraseRootFromParent_Done,
     /*  33452 */   // Label 244: @33452
     /*  33452 */   GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(33545), // Rule ID 2640 //
     /*  33457 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  33460 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33464 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33468 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  33472 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33476 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33480 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33482 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  33486 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  33490 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33494 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  33498 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  33502 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
     /*  33506 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  33510 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  33514 */     // MIs[3] Operand 1
     /*  33514 */     // No operand predicates
     /*  33514 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  33518 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
     /*  33522 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21435),
     /*  33526 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  33528 */     // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_21436>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_21435>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  33528 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  33531 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33533 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  33537 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  33541 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  33543 */     GIR_RootConstrainSelectedInstOperands,
     /*  33544 */     // GIR_Coverage, 2640,
     /*  33544 */     GIR_EraseRootFromParent_Done,
     /*  33545 */   // Label 245: @33545
     /*  33545 */   GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(33638), // Rule ID 8745 //
     /*  33550 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  33553 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33557 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
     /*  33561 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  33565 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  33569 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33573 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33577 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33579 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  33583 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  33587 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33591 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  33595 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  33599 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
     /*  33603 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  33607 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  33611 */     // MIs[3] Operand 1
     /*  33611 */     // No operand predicates
     /*  33611 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  33615 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21435),
     /*  33619 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  33621 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_21436>>)<<P:1:Predicate_anonymous_21435>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  33621 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  33624 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33626 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  33630 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  33634 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  33636 */     GIR_RootConstrainSelectedInstOperands,
     /*  33637 */     // GIR_Coverage, 8745,
     /*  33637 */     GIR_EraseRootFromParent_Done,
     /*  33638 */   // Label 246: @33638
     /*  33638 */   GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(33693), // Rule ID 7548 //
     /*  33643 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33647 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33651 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33655 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  33658 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  33663 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33667 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  33671 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33673 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i32:{ *:[i32] }:$src2)  =>  (V_MAD_I32_I24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33673 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_I32_I24_e64),
     /*  33676 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33678 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  33682 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  33686 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  33688 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33691 */     GIR_RootConstrainSelectedInstOperands,
     /*  33692 */     // GIR_Coverage, 7548,
     /*  33692 */     GIR_EraseRootFromParent_Done,
     /*  33693 */   // Label 247: @33693
     /*  33693 */   GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(33748), // Rule ID 7550 //
     /*  33698 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33702 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33706 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33710 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  33713 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  33718 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33722 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  33726 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33728 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i32:{ *:[i32] }:$src2)  =>  (V_MAD_U32_U24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33728 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_U24_e64),
     /*  33731 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33733 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  33737 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  33741 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  33743 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33746 */     GIR_RootConstrainSelectedInstOperands,
     /*  33747 */     // GIR_Coverage, 7550,
     /*  33747 */     GIR_EraseRootFromParent_Done,
     /*  33748 */   // Label 248: @33748
     /*  33748 */   GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(33813), // Rule ID 82 //
     /*  33753 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  33756 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  33760 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33764 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  33768 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33772 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33776 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33778 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  33783 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  33787 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  33791 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl1_add),
     /*  33795 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33797 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  33797 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL1_ADD_U32),
     /*  33800 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  33802 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  33806 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  33808 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  33811 */     GIR_RootConstrainSelectedInstOperands,
     /*  33812 */     // GIR_Coverage, 82,
     /*  33812 */     GIR_EraseRootFromParent_Done,
     /*  33813 */   // Label 249: @33813
     /*  33813 */   GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(33878), // Rule ID 83 //
     /*  33818 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  33821 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  33825 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33829 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  33833 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33837 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33841 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33843 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  33848 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*  33852 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  33856 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl2_add),
     /*  33860 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33862 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  33862 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL2_ADD_U32),
     /*  33865 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  33867 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  33871 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  33873 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  33876 */     GIR_RootConstrainSelectedInstOperands,
     /*  33877 */     // GIR_Coverage, 83,
     /*  33877 */     GIR_EraseRootFromParent_Done,
     /*  33878 */   // Label 250: @33878
     /*  33878 */   GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(33943), // Rule ID 84 //
     /*  33883 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  33886 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  33890 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33894 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  33898 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33902 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33906 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33908 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  33913 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*  33917 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  33921 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl3_add),
     /*  33925 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33927 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  33927 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL3_ADD_U32),
     /*  33930 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  33932 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  33936 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  33938 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  33941 */     GIR_RootConstrainSelectedInstOperands,
     /*  33942 */     // GIR_Coverage, 84,
     /*  33942 */     GIR_EraseRootFromParent_Done,
     /*  33943 */   // Label 251: @33943
     /*  33943 */   GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(34008), // Rule ID 85 //
     /*  33948 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  33951 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  33955 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33959 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  33963 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33967 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33971 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33973 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  33978 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 4,
     /*  33982 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  33986 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl4_add),
     /*  33990 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33992 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  33992 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL4_ADD_U32),
     /*  33995 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  33997 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34001 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  34003 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  34006 */     GIR_RootConstrainSelectedInstOperands,
     /*  34007 */     // GIR_Coverage, 85,
     /*  34007 */     GIR_EraseRootFromParent_Done,
     /*  34008 */   // Label 252: @34008
     /*  34008 */   GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(34091), // Rule ID 7611 //
     /*  34013 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34017 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34021 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34025 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34029 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34033 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34035 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34039 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  34043 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34047 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34051 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  34055 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  34059 */     // MIs[3] src0
     /*  34059 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  34064 */     // MIs[3] src1
     /*  34064 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34069 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  34071 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34071 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  34074 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34076 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  34080 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  34084 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  34086 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34089 */     GIR_RootConstrainSelectedInstOperands,
     /*  34090 */     // GIR_Coverage, 7611,
     /*  34090 */     GIR_EraseRootFromParent_Done,
     /*  34091 */   // Label 253: @34091
     /*  34091 */   GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(34174), // Rule ID 11438 //
     /*  34096 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34100 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34104 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34108 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34112 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34116 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34118 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34122 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  34126 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34130 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34134 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  34138 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  34142 */     // MIs[3] src1
     /*  34142 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34147 */     // MIs[3] src0
     /*  34147 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  34152 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  34154 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34154 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  34157 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34159 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  34163 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  34167 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  34169 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34172 */     GIR_RootConstrainSelectedInstOperands,
     /*  34173 */     // GIR_Coverage, 11438,
     /*  34173 */     GIR_EraseRootFromParent_Done,
     /*  34174 */   // Label 254: @34174
     /*  34174 */   GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(34257), // Rule ID 11439 //
     /*  34179 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34183 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34187 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34191 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34195 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34199 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34201 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34205 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  34209 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34213 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34217 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  34221 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  34225 */     // MIs[3] src0
     /*  34225 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34230 */     // MIs[3] src1
     /*  34230 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  34235 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  34237 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34237 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  34240 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34242 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  34246 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  34250 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  34252 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34255 */     GIR_RootConstrainSelectedInstOperands,
     /*  34256 */     // GIR_Coverage, 11439,
     /*  34256 */     GIR_EraseRootFromParent_Done,
     /*  34257 */   // Label 255: @34257
     /*  34257 */   GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(34340), // Rule ID 11440 //
     /*  34262 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34266 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34270 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34274 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34278 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34282 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34284 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34288 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  34292 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34296 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34300 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  34304 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  34308 */     // MIs[3] src1
     /*  34308 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  34313 */     // MIs[3] src0
     /*  34313 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34318 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  34320 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34320 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  34323 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34325 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  34329 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  34333 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  34335 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34338 */     GIR_RootConstrainSelectedInstOperands,
     /*  34339 */     // GIR_Coverage, 11440,
     /*  34339 */     GIR_EraseRootFromParent_Done,
     /*  34340 */   // Label 256: @34340
     /*  34340 */   GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(34405), // Rule ID 8662 //
     /*  34345 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  34348 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34352 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34356 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34360 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  34364 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34368 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34372 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34374 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34379 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  34383 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl1_add),
     /*  34387 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34389 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  34389 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL1_ADD_U32),
     /*  34392 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  34394 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34398 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  34400 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  34403 */     GIR_RootConstrainSelectedInstOperands,
     /*  34404 */     // GIR_Coverage, 8662,
     /*  34404 */     GIR_EraseRootFromParent_Done,
     /*  34405 */   // Label 257: @34405
     /*  34405 */   GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(34470), // Rule ID 8663 //
     /*  34410 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  34413 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34417 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34421 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34425 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  34429 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34433 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34437 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34439 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34444 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*  34448 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl2_add),
     /*  34452 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34454 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  34454 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL2_ADD_U32),
     /*  34457 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  34459 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34463 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  34465 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  34468 */     GIR_RootConstrainSelectedInstOperands,
     /*  34469 */     // GIR_Coverage, 8663,
     /*  34469 */     GIR_EraseRootFromParent_Done,
     /*  34470 */   // Label 258: @34470
     /*  34470 */   GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(34535), // Rule ID 8664 //
     /*  34475 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  34478 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34482 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34486 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34490 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  34494 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34498 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34502 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34504 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34509 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*  34513 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl3_add),
     /*  34517 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34519 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  34519 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL3_ADD_U32),
     /*  34522 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  34524 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34528 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  34530 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  34533 */     GIR_RootConstrainSelectedInstOperands,
     /*  34534 */     // GIR_Coverage, 8664,
     /*  34534 */     GIR_EraseRootFromParent_Done,
     /*  34535 */   // Label 259: @34535
     /*  34535 */   GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(34600), // Rule ID 8665 //
     /*  34540 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  34543 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34547 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34551 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34555 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  34559 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34563 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34567 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34569 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34574 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 4,
     /*  34578 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl4_add),
     /*  34582 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34584 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  34584 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL4_ADD_U32),
     /*  34587 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  34589 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34593 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  34595 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  34598 */     GIR_RootConstrainSelectedInstOperands,
     /*  34599 */     // GIR_Coverage, 8665,
     /*  34599 */     GIR_EraseRootFromParent_Done,
     /*  34600 */   // Label 260: @34600
     /*  34600 */   GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(34655), // Rule ID 11405 //
     /*  34605 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34609 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34613 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34617 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  34620 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  34625 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34629 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  34633 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34635 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3191:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_I32_I24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34635 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_I32_I24_e64),
     /*  34638 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34640 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  34644 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  34648 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  34650 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34653 */     GIR_RootConstrainSelectedInstOperands,
     /*  34654 */     // GIR_Coverage, 11405,
     /*  34654 */     GIR_EraseRootFromParent_Done,
     /*  34655 */   // Label 261: @34655
     /*  34655 */   GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(34710), // Rule ID 11407 //
     /*  34660 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34664 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34668 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34672 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  34675 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  34680 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34684 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  34688 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34690 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3192:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U32_U24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34690 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_U24_e64),
     /*  34693 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34695 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  34699 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  34703 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  34705 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34708 */     GIR_RootConstrainSelectedInstOperands,
     /*  34709 */     // GIR_Coverage, 11407,
     /*  34709 */     GIR_EraseRootFromParent_Done,
     /*  34710 */   // Label 262: @34710
     /*  34710 */   GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(34793), // Rule ID 11441 //
     /*  34715 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34719 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34723 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34727 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34731 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34735 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34737 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34741 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  34745 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34749 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34753 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  34757 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  34761 */     // MIs[3] src0
     /*  34761 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  34766 */     // MIs[3] src1
     /*  34766 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34771 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  34773 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34773 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  34776 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34778 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  34782 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  34786 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  34788 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34791 */     GIR_RootConstrainSelectedInstOperands,
     /*  34792 */     // GIR_Coverage, 11441,
     /*  34792 */     GIR_EraseRootFromParent_Done,
     /*  34793 */   // Label 263: @34793
     /*  34793 */   GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(34876), // Rule ID 11442 //
     /*  34798 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34802 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34806 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34810 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34814 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34818 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34820 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34824 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  34828 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34832 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34836 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  34840 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  34844 */     // MIs[3] src1
     /*  34844 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34849 */     // MIs[3] src0
     /*  34849 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  34854 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  34856 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34856 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  34859 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34861 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  34865 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  34869 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  34871 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34874 */     GIR_RootConstrainSelectedInstOperands,
     /*  34875 */     // GIR_Coverage, 11442,
     /*  34875 */     GIR_EraseRootFromParent_Done,
     /*  34876 */   // Label 264: @34876
     /*  34876 */   GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(34959), // Rule ID 11443 //
     /*  34881 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34885 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34889 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34893 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34897 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34901 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34903 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34907 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  34911 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34915 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34919 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  34923 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  34927 */     // MIs[3] src0
     /*  34927 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34932 */     // MIs[3] src1
     /*  34932 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  34937 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  34939 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34939 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  34942 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34944 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  34948 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  34952 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  34954 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34957 */     GIR_RootConstrainSelectedInstOperands,
     /*  34958 */     // GIR_Coverage, 11443,
     /*  34958 */     GIR_EraseRootFromParent_Done,
     /*  34959 */   // Label 265: @34959
     /*  34959 */   GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(35042), // Rule ID 11444 //
     /*  34964 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34968 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34972 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34976 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34980 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34984 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34986 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34990 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  34994 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34998 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35002 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35006 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  35010 */     // MIs[3] src1
     /*  35010 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35015 */     // MIs[3] src0
     /*  35015 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35020 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35022 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35022 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35025 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35027 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  35031 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  35035 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  35037 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35040 */     GIR_RootConstrainSelectedInstOperands,
     /*  35041 */     // GIR_Coverage, 11444,
     /*  35041 */     GIR_EraseRootFromParent_Done,
     /*  35042 */   // Label 266: @35042
     /*  35042 */   GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(35207), // Rule ID 8755 //
     /*  35047 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  35050 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35054 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:11:z
     /*  35058 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35062 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35066 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  35070 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35074 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35078 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35080 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:11:x
     /*  35084 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:11:y
     /*  35088 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21470),
     /*  35092 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35094 */     // (add:{ *:[i32] } VGPR_32:{ *:[i32] }:$src2:$pred:11:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:11:x, i32:{ *:[i32] }:$src1:$pred:11:y)<<P:Predicate_anonymous_21471>>)<<P:11:Predicate_anonymous_21470>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  35094 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  35097 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  35101 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35106 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  35108 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  35111 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  35115 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35120 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  35124 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  35127 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  35130 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  35133 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  35138 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35143 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35148 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  35151 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  35154 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  35158 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35163 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  35168 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35172 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  35176 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  35179 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  35182 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  35184 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  35187 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  35189 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  35196 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35201 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  35206 */     // GIR_Coverage, 8755,
     /*  35206 */     GIR_EraseRootFromParent_Done,
     /*  35207 */   // Label 267: @35207
     /*  35207 */   GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(35372), // Rule ID 8759 //
     /*  35212 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  35215 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35219 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:14:z
     /*  35223 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35227 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35231 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  35235 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35239 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35243 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35245 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:14:x
     /*  35249 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:14:y
     /*  35253 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21470),
     /*  35257 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35259 */     // (add:{ *:[i32] } VGPR_32:{ *:[i32] }:$src2:$pred:14:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:14:x, i32:{ *:[i32] }:$src1:$pred:14:y)<<P:Predicate_anonymous_21471>>)<<P:14:Predicate_anonymous_21470>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  35259 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  35262 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  35266 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35271 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  35273 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  35276 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  35280 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35285 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  35289 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  35292 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  35295 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  35298 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  35303 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35308 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35313 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  35316 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  35319 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  35323 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35328 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  35333 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35337 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  35341 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  35344 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  35347 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  35349 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  35352 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  35354 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  35361 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35366 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  35371 */     // GIR_Coverage, 8759,
     /*  35371 */     GIR_EraseRootFromParent_Done,
     /*  35372 */   // Label 268: @35372
     /*  35372 */   GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(35437), // Rule ID 2643 //
     /*  35377 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35380 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35384 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35388 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  35392 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35396 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35400 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35402 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
     /*  35406 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
     /*  35410 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:3:z
     /*  35414 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21441),
     /*  35418 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35420 */     // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_21439>>, i32:{ *:[i32] }:$src2:$pred:3:z)<<P:3:Predicate_anonymous_21441>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  35420 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD3_U32_e64),
     /*  35423 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35425 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35429 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  35433 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35435 */     GIR_RootConstrainSelectedInstOperands,
     /*  35436 */     // GIR_Coverage, 2643,
     /*  35436 */     GIR_EraseRootFromParent_Done,
     /*  35437 */   // Label 269: @35437
     /*  35437 */   GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(35602), // Rule ID 2662 //
     /*  35442 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  35445 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35449 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35453 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  35457 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35461 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35465 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35467 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:11:x
     /*  35471 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:11:y
     /*  35475 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:11:z
     /*  35479 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35483 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21470),
     /*  35487 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35489 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:11:x, i32:{ *:[i32] }:$src1:$pred:11:y)<<P:Predicate_anonymous_21471>>, VGPR_32:{ *:[i32] }:$src2:$pred:11:z)<<P:11:Predicate_anonymous_21470>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  35489 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  35492 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  35496 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35501 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  35503 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  35506 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  35510 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35515 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  35519 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  35522 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  35525 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  35528 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  35533 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35538 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35543 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  35546 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  35549 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  35553 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35558 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  35563 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35567 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  35571 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  35574 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  35577 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  35579 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  35582 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  35584 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  35591 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35596 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  35601 */     // GIR_Coverage, 2662,
     /*  35601 */     GIR_EraseRootFromParent_Done,
     /*  35602 */   // Label 270: @35602
     /*  35602 */   GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(35767), // Rule ID 2667 //
     /*  35607 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  35610 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35614 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35618 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  35622 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35626 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35630 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35632 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:14:x
     /*  35636 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:14:y
     /*  35640 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:14:z
     /*  35644 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35648 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21470),
     /*  35652 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35654 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:14:x, i32:{ *:[i32] }:$src1:$pred:14:y)<<P:Predicate_anonymous_21471>>, VGPR_32:{ *:[i32] }:$src2:$pred:14:z)<<P:14:Predicate_anonymous_21470>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  35654 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  35657 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  35661 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35666 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  35668 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  35671 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  35675 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35680 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  35684 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  35687 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  35690 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  35693 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  35698 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35703 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35708 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  35711 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  35714 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  35718 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35723 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  35728 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35732 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  35736 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  35739 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  35742 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  35744 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  35747 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  35749 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  35756 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35761 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  35766 */     // GIR_Coverage, 2667,
     /*  35766 */     GIR_EraseRootFromParent_Done,
     /*  35767 */   // Label 271: @35767
     /*  35767 */   GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(35928), // Rule ID 2661 //
     /*  35772 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  35775 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35779 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35783 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  35787 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35791 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35795 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35797 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
     /*  35801 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
     /*  35805 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:10:z
     /*  35809 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21470),
     /*  35813 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35815 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:10:x, i32:{ *:[i32] }:$src1:$pred:10:y)<<P:Predicate_anonymous_21471>>, i32:{ *:[i32] }:$src2:$pred:10:z)<<P:10:Predicate_anonymous_21470>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  35815 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  35818 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  35822 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35827 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  35829 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  35832 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  35836 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35841 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  35845 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  35848 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  35851 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  35854 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  35859 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  35864 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  35869 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  35872 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  35875 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  35879 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35884 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  35889 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35893 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  35897 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  35900 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  35903 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  35905 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  35908 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  35910 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  35917 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35922 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  35927 */     // GIR_Coverage, 2661,
     /*  35927 */     GIR_EraseRootFromParent_Done,
     /*  35928 */   // Label 272: @35928
     /*  35928 */   GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(36089), // Rule ID 2666 //
     /*  35933 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  35936 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35940 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35944 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  35948 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35952 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35956 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35958 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:13:x
     /*  35962 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:13:y
     /*  35966 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:13:z
     /*  35970 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21470),
     /*  35974 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35976 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:13:x, i32:{ *:[i32] }:$src1:$pred:13:y)<<P:Predicate_anonymous_21471>>, i32:{ *:[i32] }:$src2:$pred:13:z)<<P:13:Predicate_anonymous_21470>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  35976 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  35979 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  35983 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35988 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  35990 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  35993 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  35997 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36002 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  36006 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  36009 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  36012 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  36015 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  36020 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  36025 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  36030 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  36033 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  36036 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  36040 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36045 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  36050 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36054 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36058 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  36061 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  36064 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  36066 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  36069 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  36071 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  36078 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36083 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36088 */     // GIR_Coverage, 2666,
     /*  36088 */     GIR_EraseRootFromParent_Done,
     /*  36089 */   // Label 273: @36089
     /*  36089 */   GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(36154), // Rule ID 2639 //
     /*  36094 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36097 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36101 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36105 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  36109 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36113 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36117 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36119 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  36123 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
     /*  36127 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
     /*  36131 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21435),
     /*  36135 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36137 */     // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_21436>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_21435>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  36137 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  36140 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36142 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36146 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36150 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  36152 */     GIR_RootConstrainSelectedInstOperands,
     /*  36153 */     // GIR_Coverage, 2639,
     /*  36153 */     GIR_EraseRootFromParent_Done,
     /*  36154 */   // Label 274: @36154
     /*  36154 */   GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(36219), // Rule ID 2649 //
     /*  36159 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36162 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36166 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36170 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  36174 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36178 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36182 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36184 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
     /*  36188 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
     /*  36192 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:8:z
     /*  36196 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21454),
     /*  36200 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36202 */     // (add:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_anonymous_21455>>, i32:{ *:[i32] }:$src2:$pred:8:z)<<P:8:Predicate_anonymous_21454>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  36202 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XAD_U32_e64),
     /*  36205 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36207 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36211 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36215 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  36217 */     GIR_RootConstrainSelectedInstOperands,
     /*  36218 */     // GIR_Coverage, 2649,
     /*  36218 */     GIR_EraseRootFromParent_Done,
     /*  36219 */   // Label 275: @36219
     /*  36219 */   GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(36259), // Rule ID 7117 //
     /*  36224 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36228 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36232 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  36236 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36240 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_35534),
     /*  36244 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36246 */     // (add:{ *:[i32] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_35534>>, i32:{ *:[i32] }:$val)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i32] }:$val)
     /*  36246 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  36249 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36251 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // popcnt
     /*  36255 */     GIR_RootToRootCopy, /*OpIdx*/2, // val
     /*  36257 */     GIR_RootConstrainSelectedInstOperands,
     /*  36258 */     // GIR_Coverage, 7117,
     /*  36258 */     GIR_EraseRootFromParent_Done,
     /*  36259 */   // Label 276: @36259
     /*  36259 */   GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(36324), // Rule ID 8746 //
     /*  36264 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36267 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36271 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:3:z
     /*  36275 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36279 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  36283 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36287 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36291 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36293 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
     /*  36297 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
     /*  36301 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21441),
     /*  36305 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36307 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:3:z, (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_21439>>)<<P:3:Predicate_anonymous_21441>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  36307 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD3_U32_e64),
     /*  36310 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36312 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36316 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36320 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36322 */     GIR_RootConstrainSelectedInstOperands,
     /*  36323 */     // GIR_Coverage, 8746,
     /*  36323 */     GIR_EraseRootFromParent_Done,
     /*  36324 */   // Label 277: @36324
     /*  36324 */   GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(36485), // Rule ID 8754 //
     /*  36329 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  36332 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36336 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:10:z
     /*  36340 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36344 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  36348 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36352 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36356 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36358 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
     /*  36362 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
     /*  36366 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21470),
     /*  36370 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36372 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:10:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:10:x, i32:{ *:[i32] }:$src1:$pred:10:y)<<P:Predicate_anonymous_21471>>)<<P:10:Predicate_anonymous_21470>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  36372 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  36375 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  36379 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36384 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  36386 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  36389 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  36393 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36398 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  36402 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  36405 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  36408 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  36411 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  36416 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  36421 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  36426 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  36429 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  36432 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  36436 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36441 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  36446 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36450 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36454 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  36457 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  36460 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  36462 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  36465 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  36467 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  36474 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36479 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36484 */     // GIR_Coverage, 8754,
     /*  36484 */     GIR_EraseRootFromParent_Done,
     /*  36485 */   // Label 278: @36485
     /*  36485 */   GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(36646), // Rule ID 8758 //
     /*  36490 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  36493 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36497 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:13:z
     /*  36501 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36505 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  36509 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36513 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36517 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36519 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:13:x
     /*  36523 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:13:y
     /*  36527 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21470),
     /*  36531 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36533 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:13:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:13:x, i32:{ *:[i32] }:$src1:$pred:13:y)<<P:Predicate_anonymous_21471>>)<<P:13:Predicate_anonymous_21470>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  36533 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  36536 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  36540 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36545 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  36547 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  36550 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  36554 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36559 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  36563 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  36566 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  36569 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  36572 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  36577 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  36582 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  36587 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  36590 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  36593 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  36597 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36602 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  36607 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36611 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36615 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  36618 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  36621 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  36623 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  36626 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  36628 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  36635 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36640 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36645 */     // GIR_Coverage, 8758,
     /*  36645 */     GIR_EraseRootFromParent_Done,
     /*  36646 */   // Label 279: @36646
     /*  36646 */   GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(36711), // Rule ID 8744 //
     /*  36651 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36654 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36658 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
     /*  36662 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36666 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  36670 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36674 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36678 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36680 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  36684 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
     /*  36688 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21435),
     /*  36692 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36694 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_21436>>)<<P:1:Predicate_anonymous_21435>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  36694 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  36697 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36699 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36703 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36707 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36709 */     GIR_RootConstrainSelectedInstOperands,
     /*  36710 */     // GIR_Coverage, 8744,
     /*  36710 */     GIR_EraseRootFromParent_Done,
     /*  36711 */   // Label 280: @36711
     /*  36711 */   GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(36776), // Rule ID 8751 //
     /*  36716 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36719 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36723 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:8:z
     /*  36727 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36731 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  36735 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36739 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36743 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36745 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
     /*  36749 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
     /*  36753 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21454),
     /*  36757 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36759 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:8:z, (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_anonymous_21455>>)<<P:8:Predicate_anonymous_21454>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  36759 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XAD_U32_e64),
     /*  36762 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36764 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36768 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36772 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  36774 */     GIR_RootConstrainSelectedInstOperands,
     /*  36775 */     // GIR_Coverage, 8751,
     /*  36775 */     GIR_EraseRootFromParent_Done,
     /*  36776 */   // Label 281: @36776
     /*  36776 */   GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(36816), // Rule ID 11403 //
     /*  36781 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36785 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36789 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  36793 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36797 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_35534),
     /*  36801 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36803 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$val, (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_35534>>)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i32] }:$val)
     /*  36803 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  36806 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36808 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // popcnt
     /*  36812 */     GIR_RootToRootCopy, /*OpIdx*/1, // val
     /*  36814 */     GIR_RootConstrainSelectedInstOperands,
     /*  36815 */     // GIR_Coverage, 11403,
     /*  36815 */     GIR_EraseRootFromParent_Done,
     /*  36816 */   // Label 282: @36816
     /*  36816 */   GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(36860), // Rule ID 7804 //
     /*  36821 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36825 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36829 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  36833 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
     /*  36837 */     // MIs[1] Operand 1
     /*  36837 */     // No operand predicates
     /*  36837 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13991),
     /*  36841 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36843 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_13991>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SReg_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i1 i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
     /*  36843 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_I32),
     /*  36846 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  36848 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  36850 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  36855 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  36858 */     GIR_RootConstrainSelectedInstOperands,
     /*  36859 */     // GIR_Coverage, 7804,
     /*  36859 */     GIR_EraseRootFromParent_Done,
     /*  36860 */   // Label 283: @36860
     /*  36860 */   GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(36907), // Rule ID 7805 //
     /*  36865 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
     /*  36868 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36872 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36876 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  36880 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
     /*  36884 */     // MIs[1] Operand 1
     /*  36884 */     // No operand predicates
     /*  36884 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20182),
     /*  36888 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36890 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_20182>>  =>  (V_SUB_U32_e64:{ *:[i32] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
     /*  36890 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U32_e64),
     /*  36893 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36895 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  36897 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  36902 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36905 */     GIR_RootConstrainSelectedInstOperands,
     /*  36906 */     // GIR_Coverage, 7805,
     /*  36906 */     GIR_EraseRootFromParent_Done,
     /*  36907 */   // Label 284: @36907
     /*  36907 */   GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(36962), // Rule ID 7806 //
     /*  36912 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasAddNoCarryInsts),
     /*  36915 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36919 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36923 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  36927 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
     /*  36931 */     // MIs[1] Operand 1
     /*  36931 */     // No operand predicates
     /*  36931 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20182),
     /*  36935 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36937 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_20182>>  =>  (V_SUB_CO_U32_e64:{ *:[i32] }:{ *:[i1] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
     /*  36937 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  36940 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_CO_U32_e64),
     /*  36943 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36945 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  36950 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  36952 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  36957 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  36960 */     GIR_RootConstrainSelectedInstOperands,
     /*  36961 */     // GIR_Coverage, 7806,
     /*  36961 */     GIR_EraseRootFromParent_Done,
     /*  36962 */   // Label 285: @36962
     /*  36962 */   GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(36996), // Rule ID 43 //
     /*  36967 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36971 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36975 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  36979 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13991),
     /*  36983 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_13991>>  =>  (S_ADD_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  36983 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_ADD_I32),
     /*  36988 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  36994 */     GIR_RootConstrainSelectedInstOperands,
     /*  36995 */     // GIR_Coverage, 43,
     /*  36995 */     GIR_Done,
     /*  36996 */   // Label 286: @36996
     /*  36996 */   GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(37026), // Rule ID 2530 //
     /*  37001 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
     /*  37004 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37008 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20182),
     /*  37012 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_20182>>  =>  (V_ADD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  37012 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U32_e64),
     /*  37015 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37017 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  37019 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  37021 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37024 */     GIR_RootConstrainSelectedInstOperands,
     /*  37025 */     // GIR_Coverage, 2530,
     /*  37025 */     GIR_EraseRootFromParent_Done,
     /*  37026 */   // Label 287: @37026
     /*  37026 */   GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(37064), // Rule ID 2532 //
     /*  37031 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX6GFX7GFX8GFX9),
     /*  37034 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37038 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20182),
     /*  37042 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_20182>>  =>  (V_ADD_CO_U32_e64:{ *:[i32] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  37042 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  37045 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_CO_U32_e64),
     /*  37048 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37050 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37055 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  37057 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  37059 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37062 */     GIR_RootConstrainSelectedInstOperands,
     /*  37063 */     // GIR_Coverage, 2532,
     /*  37063 */     GIR_EraseRootFromParent_Done,
     /*  37064 */   // Label 288: @37064
     /*  37064 */   GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(37100), // Rule ID 828 //
     /*  37069 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37073 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37077 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  37081 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37085 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37087 */     // (add:{ *:[i32] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  37087 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  37090 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37092 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37096 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  37098 */     GIR_RootConstrainSelectedInstOperands,
     /*  37099 */     // GIR_Coverage, 828,
     /*  37099 */     GIR_EraseRootFromParent_Done,
     /*  37100 */   // Label 289: @37100
     /*  37100 */   GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(37136), // Rule ID 8677 //
     /*  37105 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37109 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37113 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  37117 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37121 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37123 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src1, (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0))  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  37123 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  37126 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37128 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37132 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  37134 */     GIR_RootConstrainSelectedInstOperands,
     /*  37135 */     // GIR_Coverage, 8677,
     /*  37135 */     GIR_EraseRootFromParent_Done,
     /*  37136 */   // Label 290: @37136
     /*  37136 */   GIM_Reject,
     /*  37137 */ // Label 200: @37137
     /*  37137 */ GIM_Reject,
     /*  37138 */ // Label 173: @37138
     /*  37138 */ GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(37608),
     /*  37143 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  37146 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  37149 */   GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(37215), // Rule ID 2664 //
     /*  37154 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  37157 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37161 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37165 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  37169 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  37172 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  37177 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37181 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  37185 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37187 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 3192:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i64:{ *:[i64] }:$src2)  =>  (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  37187 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  37190 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  37193 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37195 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37200 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  37204 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  37208 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  37210 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37213 */     GIR_RootConstrainSelectedInstOperands,
     /*  37214 */     // GIR_Coverage, 2664,
     /*  37214 */     GIR_EraseRootFromParent_Done,
     /*  37215 */   // Label 292: @37215
     /*  37215 */   GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(37281), // Rule ID 2669 //
     /*  37220 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  37223 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37227 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37231 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  37235 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  37238 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  37243 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37247 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  37251 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37253 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 3192:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i64:{ *:[i64] }:$src2)  =>  (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  37253 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  37256 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  37259 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37261 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37266 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  37270 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  37274 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  37276 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37279 */     GIR_RootConstrainSelectedInstOperands,
     /*  37280 */     // GIR_Coverage, 2669,
     /*  37280 */     GIR_EraseRootFromParent_Done,
     /*  37281 */   // Label 293: @37281
     /*  37281 */   GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(37347), // Rule ID 8756 //
     /*  37286 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  37289 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37293 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37297 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  37301 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  37304 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  37309 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37313 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  37317 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37319 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src2, (intrinsic_wo_chain:{ *:[i64] } 3192:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  37319 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  37322 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  37325 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37327 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37332 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  37336 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  37340 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  37342 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37345 */     GIR_RootConstrainSelectedInstOperands,
     /*  37346 */     // GIR_Coverage, 8756,
     /*  37346 */     GIR_EraseRootFromParent_Done,
     /*  37347 */   // Label 294: @37347
     /*  37347 */   GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(37413), // Rule ID 8760 //
     /*  37352 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  37355 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37359 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37363 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  37367 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  37370 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  37375 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37379 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  37383 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37385 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src2, (intrinsic_wo_chain:{ *:[i64] } 3192:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  37385 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  37388 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  37391 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37393 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37398 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  37402 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  37406 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  37408 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37411 */     GIR_RootConstrainSelectedInstOperands,
     /*  37412 */     // GIR_Coverage, 8760,
     /*  37412 */     GIR_EraseRootFromParent_Done,
     /*  37413 */   // Label 295: @37413
     /*  37413 */   GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(37482), // Rule ID 2651 //
     /*  37418 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLshlAddU64Inst),
     /*  37421 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37425 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37429 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  37433 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  37437 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37441 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37443 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
     /*  37447 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
     /*  37451 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl_0_to_4),
     /*  37455 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:9:z
     /*  37459 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21458),
     /*  37463 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37465 */     // (add:{ *:[i64] } (shl:{ *:[i64] } i64:{ *:[i64] }:$src0:$pred:9:x, i32:{ *:[i32] }:$src1:$pred:9:y)<<P:Predicate_shl_0_to_4>><<P:Predicate_anonymous_21459>>, i64:{ *:[i64] }:$src2:$pred:9:z)<<P:9:Predicate_anonymous_21458>>  =>  (V_LSHL_ADD_U64_e64:{ *:[i64] } VSrc_b64:{ *:[i64] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b64:{ *:[i64] }:$src2)
     /*  37465 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U64_e64),
     /*  37468 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37470 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37474 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37478 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  37480 */     GIR_RootConstrainSelectedInstOperands,
     /*  37481 */     // GIR_Coverage, 2651,
     /*  37481 */     GIR_EraseRootFromParent_Done,
     /*  37482 */   // Label 296: @37482
     /*  37482 */   GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(37551), // Rule ID 8752 //
     /*  37487 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLshlAddU64Inst),
     /*  37490 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37494 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:9:z
     /*  37498 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37502 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  37506 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  37510 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37514 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37516 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
     /*  37520 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
     /*  37524 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl_0_to_4),
     /*  37528 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21458),
     /*  37532 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37534 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src2:$pred:9:z, (shl:{ *:[i64] } i64:{ *:[i64] }:$src0:$pred:9:x, i32:{ *:[i32] }:$src1:$pred:9:y)<<P:Predicate_shl_0_to_4>><<P:Predicate_anonymous_21459>>)<<P:9:Predicate_anonymous_21458>>  =>  (V_LSHL_ADD_U64_e64:{ *:[i64] } VSrc_b64:{ *:[i64] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b64:{ *:[i64] }:$src2)
     /*  37534 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U64_e64),
     /*  37537 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37539 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37543 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37547 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  37549 */     GIR_RootConstrainSelectedInstOperands,
     /*  37550 */     // GIR_Coverage, 8752,
     /*  37550 */     GIR_EraseRootFromParent_Done,
     /*  37551 */   // Label 297: @37551
     /*  37551 */   GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(37581), // Rule ID 1367 //
     /*  37556 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37560 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20182),
     /*  37564 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_20182>>  =>  (V_ADD_U64_PSEUDO:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  37564 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U64_PSEUDO),
     /*  37569 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::VCC), GIMT_Encode2(RegState::Dead),
     /*  37575 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  37579 */     GIR_RootConstrainSelectedInstOperands,
     /*  37580 */     // GIR_Coverage, 1367,
     /*  37580 */     GIR_Done,
     /*  37581 */   // Label 298: @37581
     /*  37581 */   GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(37607), // Rule ID 1369 //
     /*  37586 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  37590 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13991),
     /*  37594 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_13991>>  =>  (S_ADD_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  37594 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_ADD_U64_PSEUDO),
     /*  37599 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  37605 */     GIR_RootConstrainSelectedInstOperands,
     /*  37606 */     // GIR_Coverage, 1369,
     /*  37606 */     GIR_Done,
     /*  37607 */   // Label 299: @37607
     /*  37607 */   GIM_Reject,
     /*  37608 */ // Label 291: @37608
     /*  37608 */ GIM_Reject,
     /*  37609 */ // Label 174: @37609
     /*  37609 */ GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(37878),
     /*  37614 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  37617 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  37620 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37624 */   GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(37720), // Rule ID 8727 //
     /*  37629 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37633 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  37637 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  37641 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  37645 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37647 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  37654 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  37661 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  37668 */     // (add:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src2, i32:{ *:[i32] }:$src2_modifiers), (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers)))  =>  (V_PK_MAD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src2_modifiers, v2i16:{ *:[v2i16] }:$src2)
     /*  37668 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MAD_U16),
     /*  37671 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37673 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src0_modifiers
     /*  37678 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src0
     /*  37683 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src1_modifiers
     /*  37688 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src1
     /*  37693 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src2_modifiers
     /*  37698 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src2
     /*  37703 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37706 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37709 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37712 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37715 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37718 */     GIR_RootConstrainSelectedInstOperands,
     /*  37719 */     // GIR_Coverage, 8727,
     /*  37719 */     GIR_EraseRootFromParent_Done,
     /*  37720 */   // Label 301: @37720
     /*  37720 */   GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(37816), // Rule ID 1109 //
     /*  37725 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37729 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  37733 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  37737 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  37741 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37743 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  37750 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  37757 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  37764 */     // (add:{ *:[v2i16] } (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers)), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src2, i32:{ *:[i32] }:$src2_modifiers))  =>  (V_PK_MAD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src2_modifiers, v2i16:{ *:[v2i16] }:$src2)
     /*  37764 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MAD_U16),
     /*  37767 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37769 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  37774 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  37779 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  37784 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  37789 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src2_modifiers
     /*  37794 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src2
     /*  37799 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37802 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37805 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37808 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37811 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37814 */     GIR_RootConstrainSelectedInstOperands,
     /*  37815 */     // GIR_Coverage, 1109,
     /*  37815 */     GIR_EraseRootFromParent_Done,
     /*  37816 */   // Label 302: @37816
     /*  37816 */   GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(37877), // Rule ID 1120 //
     /*  37821 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  37828 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  37835 */     // (add:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_ADD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
     /*  37835 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_ADD_U16),
     /*  37838 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37840 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  37845 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  37850 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  37855 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  37860 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37863 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37866 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37869 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37872 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37875 */     GIR_RootConstrainSelectedInstOperands,
     /*  37876 */     // GIR_Coverage, 1120,
     /*  37876 */     GIR_EraseRootFromParent_Done,
     /*  37877 */   // Label 303: @37877
     /*  37877 */   GIM_Reject,
     /*  37878 */ // Label 300: @37878
     /*  37878 */ GIM_Reject,
     /*  37879 */ // Label 175: @37879
     /*  37879 */ GIM_Reject,
     /*  37880 */ // Label 1: @37880
     /*  37880 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(12), /*)*//*default:*//*Label 309*/ GIMT_Encode4(38502),
     /*  37891 */ /*GILLT_s1*//*Label 304*/ GIMT_Encode4(37911),
     /*  37895 */ /*GILLT_s16*//*Label 305*/ GIMT_Encode4(38030),
     /*  37899 */ /*GILLT_s32*//*Label 306*/ GIMT_Encode4(38246),
     /*  37903 */ /*GILLT_s64*//*Label 307*/ GIMT_Encode4(38361),
     /*  37907 */ /*GILLT_v2s16*//*Label 308*/ GIMT_Encode4(38430),
     /*  37911 */ // Label 304: @37911
     /*  37911 */ GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(38029),
     /*  37916 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  37919 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  37922 */   GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(37950), // Rule ID 7656 //
     /*  37927 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  37930 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  37934 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  37938 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  37938 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B64),
     /*  37941 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  37943 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  37945 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  37948 */     GIR_RootConstrainSelectedInstOperands,
     /*  37949 */     // GIR_Coverage, 7656,
     /*  37949 */     GIR_EraseRootFromParent_Done,
     /*  37950 */   // Label 311: @37950
     /*  37950 */   GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(37978), // Rule ID 7663 //
     /*  37955 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  37958 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  37962 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  37966 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  37966 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B32),
     /*  37969 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  37971 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  37973 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  37976 */     GIR_RootConstrainSelectedInstOperands,
     /*  37977 */     // GIR_Coverage, 7663,
     /*  37977 */     GIR_EraseRootFromParent_Done,
     /*  37978 */   // Label 312: @37978
     /*  37978 */   GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(38003), // Rule ID 7654 //
     /*  37983 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  37986 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  37990 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  37990 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B64),
     /*  37995 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  38001 */     GIR_RootConstrainSelectedInstOperands,
     /*  38002 */     // GIR_Coverage, 7654,
     /*  38002 */     GIR_Done,
     /*  38003 */   // Label 313: @38003
     /*  38003 */   GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(38028), // Rule ID 7661 //
     /*  38008 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  38011 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38015 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  38015 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B32),
     /*  38020 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  38026 */     GIR_RootConstrainSelectedInstOperands,
     /*  38027 */     // GIR_Coverage, 7661,
     /*  38027 */     GIR_Done,
     /*  38028 */   // Label 314: @38028
     /*  38028 */   GIM_Reject,
     /*  38029 */ // Label 310: @38029
     /*  38029 */ GIM_Reject,
     /*  38030 */ // Label 305: @38030
     /*  38030 */ GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(38245),
     /*  38035 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  38038 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  38041 */   GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(38100), // Rule ID 1091 //
     /*  38046 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
     /*  38049 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38053 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  38060 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  38067 */     // (sub:{ *:[i16] } (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  38067 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_e64),
     /*  38070 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38072 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  38077 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  38082 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  38087 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  38092 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38095 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38098 */     GIR_RootConstrainSelectedInstOperands,
     /*  38099 */     // GIR_Coverage, 1091,
     /*  38099 */     GIR_EraseRootFromParent_Done,
     /*  38100 */   // Label 316: @38100
     /*  38100 */   GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(38159), // Rule ID 1092 //
     /*  38105 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts_isGFX10Plus),
     /*  38108 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  38112 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  38119 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  38126 */     // (sub:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  38126 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_t16_e64),
     /*  38129 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38131 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  38136 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  38141 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  38146 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  38151 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38154 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38157 */     GIR_RootConstrainSelectedInstOperands,
     /*  38158 */     // GIR_Coverage, 1092,
     /*  38158 */     GIR_EraseRootFromParent_Done,
     /*  38159 */   // Label 317: @38159
     /*  38159 */   GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(38218), // Rule ID 1093 //
     /*  38164 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts_isGFX10Plus),
     /*  38167 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38171 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  38178 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  38185 */     // (sub:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_fake16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  38185 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_fake16_e64),
     /*  38188 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38190 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  38195 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  38200 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  38205 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  38210 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38213 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38216 */     GIR_RootConstrainSelectedInstOperands,
     /*  38217 */     // GIR_Coverage, 1093,
     /*  38217 */     GIR_EraseRootFromParent_Done,
     /*  38218 */   // Label 318: @38218
     /*  38218 */   GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(38244), // Rule ID 932 //
     /*  38223 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX8GFX9),
     /*  38226 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38230 */     // (sub:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  38230 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U16_e64),
     /*  38233 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38235 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38237 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  38239 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38242 */     GIR_RootConstrainSelectedInstOperands,
     /*  38243 */     // GIR_Coverage, 932,
     /*  38243 */     GIR_EraseRootFromParent_Done,
     /*  38244 */   // Label 319: @38244
     /*  38244 */   GIM_Reject,
     /*  38245 */ // Label 315: @38245
     /*  38245 */ GIM_Reject,
     /*  38246 */ // Label 306: @38246
     /*  38246 */ GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(38360),
     /*  38251 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  38254 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  38257 */   GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(38291), // Rule ID 44 //
     /*  38262 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38266 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38270 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38274 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13992),
     /*  38278 */     // (sub:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_13992>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  38278 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_I32),
     /*  38283 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  38289 */     GIR_RootConstrainSelectedInstOperands,
     /*  38290 */     // GIR_Coverage, 44,
     /*  38290 */     GIR_Done,
     /*  38291 */   // Label 321: @38291
     /*  38291 */   GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(38321), // Rule ID 2531 //
     /*  38296 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
     /*  38299 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38303 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20184),
     /*  38307 */     // (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_20184>>  =>  (V_SUB_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  38307 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U32_e64),
     /*  38310 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38312 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38314 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  38316 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38319 */     GIR_RootConstrainSelectedInstOperands,
     /*  38320 */     // GIR_Coverage, 2531,
     /*  38320 */     GIR_EraseRootFromParent_Done,
     /*  38321 */   // Label 322: @38321
     /*  38321 */   GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(38359), // Rule ID 2533 //
     /*  38326 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX6GFX7GFX8GFX9),
     /*  38329 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38333 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20184),
     /*  38337 */     // (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_20184>>  =>  (V_SUB_CO_U32_e64:{ *:[i32] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  38337 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  38340 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_CO_U32_e64),
     /*  38343 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38345 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38350 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38352 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  38354 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38357 */     GIR_RootConstrainSelectedInstOperands,
     /*  38358 */     // GIR_Coverage, 2533,
     /*  38358 */     GIR_EraseRootFromParent_Done,
     /*  38359 */   // Label 323: @38359
     /*  38359 */   GIM_Reject,
     /*  38360 */ // Label 320: @38360
     /*  38360 */ GIM_Reject,
     /*  38361 */ // Label 307: @38361
     /*  38361 */ GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(38429),
     /*  38366 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  38369 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  38372 */   GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(38402), // Rule ID 1368 //
     /*  38377 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38381 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20184),
     /*  38385 */     // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_20184>>  =>  (V_SUB_U64_PSEUDO:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  38385 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U64_PSEUDO),
     /*  38390 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::VCC), GIMT_Encode2(RegState::Dead),
     /*  38396 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  38400 */     GIR_RootConstrainSelectedInstOperands,
     /*  38401 */     // GIR_Coverage, 1368,
     /*  38401 */     GIR_Done,
     /*  38402 */   // Label 325: @38402
     /*  38402 */   GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(38428), // Rule ID 1370 //
     /*  38407 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  38411 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13992),
     /*  38415 */     // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_13992>>  =>  (S_SUB_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  38415 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_U64_PSEUDO),
     /*  38420 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  38426 */     GIR_RootConstrainSelectedInstOperands,
     /*  38427 */     // GIR_Coverage, 1370,
     /*  38427 */     GIR_Done,
     /*  38428 */   // Label 326: @38428
     /*  38428 */   GIM_Reject,
     /*  38429 */ // Label 324: @38429
     /*  38429 */ GIM_Reject,
     /*  38430 */ // Label 308: @38430
     /*  38430 */ GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(38501), // Rule ID 1128 //
     /*  38435 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  38438 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  38441 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38445 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  38452 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  38459 */   // (sub:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_SUB_I16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
     /*  38459 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_SUB_I16),
     /*  38462 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38464 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  38469 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  38474 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  38479 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  38484 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38487 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38490 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38493 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38496 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38499 */   GIR_RootConstrainSelectedInstOperands,
     /*  38500 */   // GIR_Coverage, 1128,
     /*  38500 */   GIR_EraseRootFromParent_Done,
     /*  38501 */ // Label 327: @38501
     /*  38501 */ GIM_Reject,
     /*  38502 */ // Label 309: @38502
     /*  38502 */ GIM_Reject,
     /*  38503 */ // Label 2: @38503
     /*  38503 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(8), GIMT_Encode2(12), /*)*//*default:*//*Label 332*/ GIMT_Encode4(38907),
     /*  38514 */ /*GILLT_s16*//*Label 328*/ GIMT_Encode4(38530),
     /*  38518 */ /*GILLT_s32*//*Label 329*/ GIMT_Encode4(38704),
     /*  38522 */ /*GILLT_s64*//*Label 330*/ GIMT_Encode4(38805),
     /*  38526 */ /*GILLT_v2s16*//*Label 331*/ GIMT_Encode4(38835),
     /*  38530 */ // Label 328: @38530
     /*  38530 */ GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(38703),
     /*  38535 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  38538 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  38541 */   GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(38600), // Rule ID 894 //
     /*  38546 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Only),
     /*  38549 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38553 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  38560 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  38567 */     // (mul:{ *:[i16] } (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_MUL_LO_U16_opsel_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  38567 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_opsel_e64),
     /*  38570 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38572 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  38577 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  38582 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  38587 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  38592 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38595 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38598 */     GIR_RootConstrainSelectedInstOperands,
     /*  38599 */     // GIR_Coverage, 894,
     /*  38599 */     GIR_EraseRootFromParent_Done,
     /*  38600 */   // Label 334: @38600
     /*  38600 */   GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(38656), // Rule ID 895 //
     /*  38605 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  38608 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  38612 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  38619 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  38626 */     // (mul:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_MUL_LO_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  38626 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_t16_e64),
     /*  38629 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38631 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  38636 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  38641 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  38646 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  38651 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38654 */     GIR_RootConstrainSelectedInstOperands,
     /*  38655 */     // GIR_Coverage, 895,
     /*  38655 */     GIR_EraseRootFromParent_Done,
     /*  38656 */   // Label 335: @38656
     /*  38656 */   GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(38679), // Rule ID 893 //
     /*  38661 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts),
     /*  38664 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38668 */     // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  38668 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_e64),
     /*  38673 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  38677 */     GIR_RootConstrainSelectedInstOperands,
     /*  38678 */     // GIR_Coverage, 893,
     /*  38678 */     GIR_Done,
     /*  38679 */   // Label 336: @38679
     /*  38679 */   GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(38702), // Rule ID 896 //
     /*  38684 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  38687 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38691 */     // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  38691 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_fake16_e64),
     /*  38696 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  38700 */     GIR_RootConstrainSelectedInstOperands,
     /*  38701 */     // GIR_Coverage, 896,
     /*  38701 */     GIR_Done,
     /*  38702 */   // Label 337: @38702
     /*  38702 */   GIM_Reject,
     /*  38703 */ // Label 333: @38703
     /*  38703 */ GIM_Reject,
     /*  38704 */ // Label 329: @38704
     /*  38704 */ GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(38804),
     /*  38709 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  38712 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  38715 */   GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(38735), // Rule ID 81 //
     /*  38720 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38724 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13999),
     /*  38728 */     // (mul:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_13999>>  =>  (S_MUL_I32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  38728 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_MUL_I32),
     /*  38733 */     GIR_RootConstrainSelectedInstOperands,
     /*  38734 */     // GIR_Coverage, 81,
     /*  38734 */     GIR_Done,
     /*  38735 */   // Label 339: @38735
     /*  38735 */   GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(38769), // Rule ID 960 //
     /*  38740 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38744 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20704),
     /*  38748 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3mods0),
     /*  38755 */     // (mul:{ *:[i32] } (VOP3Mods0:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_20704>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  38755 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U32_e64),
     /*  38758 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38760 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  38765 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  38767 */     GIR_RootConstrainSelectedInstOperands,
     /*  38768 */     // GIR_Coverage, 960,
     /*  38768 */     GIR_EraseRootFromParent_Done,
     /*  38769 */   // Label 340: @38769
     /*  38769 */   GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(38803), // Rule ID 8717 //
     /*  38774 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38778 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20704),
     /*  38782 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3mods0),
     /*  38789 */     // (mul:{ *:[i32] } i32:{ *:[i32] }:$src1, (VOP3Mods0:{ *:[i32] } i32:{ *:[i32] }:$src0))<<P:Predicate_anonymous_20704>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  38789 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U32_e64),
     /*  38792 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38794 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  38799 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  38801 */     GIR_RootConstrainSelectedInstOperands,
     /*  38802 */     // GIR_Coverage, 8717,
     /*  38802 */     GIR_EraseRootFromParent_Done,
     /*  38803 */   // Label 341: @38803
     /*  38803 */   GIM_Reject,
     /*  38804 */ // Label 338: @38804
     /*  38804 */ GIM_Reject,
     /*  38805 */ // Label 330: @38805
     /*  38805 */ GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(38834), // Rule ID 51 //
     /*  38810 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX12Plus),
     /*  38813 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  38816 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  38819 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  38823 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_13999),
     /*  38827 */   // (mul:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_13999>>  =>  (S_MUL_U64:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  38827 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_MUL_U64),
     /*  38832 */   GIR_RootConstrainSelectedInstOperands,
     /*  38833 */   // GIR_Coverage, 51,
     /*  38833 */   GIR_Done,
     /*  38834 */ // Label 342: @38834
     /*  38834 */ GIM_Reject,
     /*  38835 */ // Label 331: @38835
     /*  38835 */ GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(38906), // Rule ID 1121 //
     /*  38840 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  38843 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  38846 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38850 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  38857 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  38864 */   // (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_MUL_LO_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
     /*  38864 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MUL_LO_U16),
     /*  38867 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38869 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  38874 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  38879 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  38884 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  38889 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38892 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38895 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38898 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38901 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38904 */   GIR_RootConstrainSelectedInstOperands,
     /*  38905 */   // GIR_Coverage, 1121,
     /*  38905 */   GIR_EraseRootFromParent_Done,
     /*  38906 */ // Label 343: @38906
     /*  38906 */ GIM_Reject,
     /*  38907 */ // Label 332: @38907
     /*  38907 */ GIM_Reject,
     /*  38908 */ // Label 3: @38908
     /*  38908 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(17), /*)*//*default:*//*Label 351*/ GIMT_Encode4(40308),
     /*  38919 */ /*GILLT_s1*//*Label 344*/ GIMT_Encode4(38959),
     /*  38923 */ /*GILLT_s16*//*Label 345*/ GIMT_Encode4(39022),
     /*  38927 */ /*GILLT_s32*//*Label 346*/ GIMT_Encode4(39262),
     /*  38931 */ /*GILLT_s64*//*Label 347*/ GIMT_Encode4(39786),
     /*  38935 */ /*GILLT_v2s16*//*Label 348*/ GIMT_Encode4(39911),
     /*  38939 */ /*GILLT_v2s32*//*Label 349*/ GIMT_Encode4(40062), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  38955 */ /*GILLT_v4s16*//*Label 350*/ GIMT_Encode4(40185),
     /*  38959 */ // Label 344: @38959
     /*  38959 */ GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(39021),
     /*  38964 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  38967 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  38970 */   GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(38995), // Rule ID 7650 //
     /*  38975 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  38978 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  38982 */     // (and:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_AND_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  38982 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B64),
     /*  38987 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  38993 */     GIR_RootConstrainSelectedInstOperands,
     /*  38994 */     // GIR_Coverage, 7650,
     /*  38994 */     GIR_Done,
     /*  38995 */   // Label 353: @38995
     /*  38995 */   GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(39020), // Rule ID 7657 //
     /*  39000 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  39003 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39007 */     // (and:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_AND_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  39007 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B32),
     /*  39012 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  39018 */     GIR_RootConstrainSelectedInstOperands,
     /*  39019 */     // GIR_Coverage, 7657,
     /*  39019 */     GIR_Done,
     /*  39020 */   // Label 354: @39020
     /*  39020 */   GIM_Reject,
     /*  39021 */ // Label 352: @39021
     /*  39021 */ GIM_Reject,
     /*  39022 */ // Label 345: @39022
     /*  39022 */ GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(39261),
     /*  39027 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  39030 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  39033 */   GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(39084), // Rule ID 8729 //
     /*  39038 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39042 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  39046 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  39050 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  39054 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  39058 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  39062 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14000),
     /*  39066 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39068 */     // (and:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }), i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_14000>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  39068 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  39071 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  39073 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  39075 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  39079 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  39082 */     GIR_RootConstrainSelectedInstOperands,
     /*  39083 */     // GIR_Coverage, 8729,
     /*  39083 */     GIR_EraseRootFromParent_Done,
     /*  39084 */   // Label 356: @39084
     /*  39084 */   GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(39135), // Rule ID 1911 //
     /*  39089 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39093 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  39097 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  39101 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  39105 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  39109 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  39113 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14000),
     /*  39117 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39119 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }))<<P:Predicate_anonymous_14000>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  39119 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  39122 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  39124 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  39126 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  39130 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  39133 */     GIR_RootConstrainSelectedInstOperands,
     /*  39134 */     // GIR_Coverage, 1911,
     /*  39134 */     GIR_EraseRootFromParent_Done,
     /*  39135 */   // Label 357: @39135
     /*  39135 */   GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(39158), // Rule ID 2560 //
     /*  39140 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts),
     /*  39143 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39147 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
     /*  39147 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  39152 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  39156 */     GIR_RootConstrainSelectedInstOperands,
     /*  39157 */     // GIR_Coverage, 2560,
     /*  39157 */     GIR_Done,
     /*  39158 */   // Label 358: @39158
     /*  39158 */   GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(39181), // Rule ID 2563 //
     /*  39163 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  39166 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39170 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
     /*  39170 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  39175 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  39179 */     GIR_RootConstrainSelectedInstOperands,
     /*  39180 */     // GIR_Coverage, 2563,
     /*  39180 */     GIR_Done,
     /*  39181 */   // Label 359: @39181
     /*  39181 */   GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(39237), // Rule ID 925 //
     /*  39186 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  39189 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  39193 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  39200 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  39207 */     // (and:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_AND_B16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  39207 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B16_t16_e64),
     /*  39210 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39212 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39217 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39222 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39227 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39232 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39235 */     GIR_RootConstrainSelectedInstOperands,
     /*  39236 */     // GIR_Coverage, 925,
     /*  39236 */     GIR_EraseRootFromParent_Done,
     /*  39237 */   // Label 360: @39237
     /*  39237 */   GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(39260), // Rule ID 926 //
     /*  39242 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  39245 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39249 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  39249 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B16_fake16_e64),
     /*  39254 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  39258 */     GIR_RootConstrainSelectedInstOperands,
     /*  39259 */     // GIR_Coverage, 926,
     /*  39259 */     GIR_Done,
     /*  39260 */   // Label 361: @39260
     /*  39260 */   GIM_Reject,
     /*  39261 */ // Label 355: @39261
     /*  39261 */ GIM_Reject,
     /*  39262 */ // Label 346: @39262
     /*  39262 */ GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(39785),
     /*  39267 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  39270 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  39273 */   GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(39348), // Rule ID 11446 //
     /*  39278 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39282 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  39286 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  39290 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  39294 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  39298 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  39300 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  39304 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  39308 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  39312 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  39316 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  39318 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
     /*  39322 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  39326 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20192),
     /*  39330 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  39332 */     // (and:{ *:[i32] } (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_add_oneuse>>, i32:{ *:[i32] }:$src)<<P:Predicate_anonymous_20192>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  39332 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  39335 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39337 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /*  39339 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39342 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  39346 */     GIR_RootConstrainSelectedInstOperands,
     /*  39347 */     // GIR_Coverage, 11446,
     /*  39347 */     GIR_EraseRootFromParent_Done,
     /*  39348 */   // Label 363: @39348
     /*  39348 */   GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(39423), // Rule ID 11447 //
     /*  39353 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39357 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  39361 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  39365 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  39369 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  39373 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  39375 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  39379 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  39383 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  39387 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  39391 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  39393 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, uint8_t(-1),
     /*  39397 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  39401 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20192),
     /*  39405 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  39407 */     // (and:{ *:[i32] } (xor:{ *:[i32] } (shl:{ *:[i32] } -1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_xor_oneuse>>, i32:{ *:[i32] }:$src)<<P:Predicate_anonymous_20192>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  39407 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  39410 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39412 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /*  39414 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39417 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  39421 */     GIR_RootConstrainSelectedInstOperands,
     /*  39422 */     // GIR_Coverage, 11447,
     /*  39422 */     GIR_EraseRootFromParent_Done,
     /*  39423 */   // Label 364: @39423
     /*  39423 */   GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(39498), // Rule ID 7813 //
     /*  39428 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39432 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  39436 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  39440 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  39444 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  39448 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  39450 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  39454 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  39458 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  39462 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  39466 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  39468 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
     /*  39472 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  39476 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20192),
     /*  39480 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  39482 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src, (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_add_oneuse>>)<<P:Predicate_anonymous_20192>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  39482 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  39485 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39487 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  39489 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39492 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  39496 */     GIR_RootConstrainSelectedInstOperands,
     /*  39497 */     // GIR_Coverage, 7813,
     /*  39497 */     GIR_EraseRootFromParent_Done,
     /*  39498 */   // Label 365: @39498
     /*  39498 */   GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(39573), // Rule ID 7814 //
     /*  39503 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39507 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  39511 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  39515 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  39519 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  39523 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  39525 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  39529 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  39533 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  39537 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  39541 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  39543 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, uint8_t(-1),
     /*  39547 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  39551 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20192),
     /*  39555 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  39557 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src, (xor:{ *:[i32] } (shl:{ *:[i32] } -1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_xor_oneuse>>)<<P:Predicate_anonymous_20192>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  39557 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  39560 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39562 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  39564 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39567 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  39571 */     GIR_RootConstrainSelectedInstOperands,
     /*  39572 */     // GIR_Coverage, 7814,
     /*  39572 */     GIR_EraseRootFromParent_Done,
     /*  39573 */   // Label 366: @39573
     /*  39573 */   GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(39624), // Rule ID 8658 //
     /*  39578 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39582 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  39586 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  39590 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  39594 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  39598 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  39602 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14000),
     /*  39606 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39608 */     // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }), i32:{ *:[i32] }:$src0)<<P:Predicate_anonymous_14000>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  39608 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  39611 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  39613 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  39615 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  39619 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  39622 */     GIR_RootConstrainSelectedInstOperands,
     /*  39623 */     // GIR_Coverage, 8658,
     /*  39623 */     GIR_EraseRootFromParent_Done,
     /*  39624 */   // Label 367: @39624
     /*  39624 */   GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(39675), // Rule ID 64 //
     /*  39629 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39633 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  39637 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  39641 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  39645 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  39649 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  39653 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14000),
     /*  39657 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39659 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }))<<P:Predicate_anonymous_14000>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  39659 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  39662 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  39664 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  39666 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  39670 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  39673 */     GIR_RootConstrainSelectedInstOperands,
     /*  39674 */     // GIR_Coverage, 64,
     /*  39674 */     GIR_EraseRootFromParent_Done,
     /*  39675 */   // Label 368: @39675
     /*  39675 */   GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(39738), // Rule ID 7812 //
     /*  39680 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39684 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  39688 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  39692 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  39696 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  39700 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  39704 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  39708 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask),
     /*  39712 */     // MIs[2] Operand 1
     /*  39712 */     // No operand predicates
     /*  39712 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20192),
     /*  39716 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  39718 */     // (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src, i32:{ *:[i32] }:$rshift), (imm:{ *:[i32] })<<P:Predicate_IMMZeroBasedBitfieldMask>>:$mask)<<P:Predicate_anonymous_20192>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, ?:{ *:[i32] }:$rshift, (IMMPopCount:{ *:[i32] } ?:{ *:[i32] }:$mask))
     /*  39718 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  39721 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39723 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  39727 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rshift
     /*  39731 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/2, /*Renderer*/GIMT_Encode2(GICR_renderPopcntImm), // mask
     /*  39736 */     GIR_RootConstrainSelectedInstOperands,
     /*  39737 */     // GIR_Coverage, 7812,
     /*  39737 */     GIR_EraseRootFromParent_Done,
     /*  39738 */   // Label 369: @39738
     /*  39738 */   GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(39764), // Rule ID 52 //
     /*  39743 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39747 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14000),
     /*  39751 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_14000>>  =>  (S_AND_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  39751 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B32),
     /*  39756 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  39762 */     GIR_RootConstrainSelectedInstOperands,
     /*  39763 */     // GIR_Coverage, 52,
     /*  39763 */     GIR_Done,
     /*  39764 */   // Label 370: @39764
     /*  39764 */   GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(39784), // Rule ID 825 //
     /*  39769 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39773 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_AND_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  39773 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  39778 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  39782 */     GIR_RootConstrainSelectedInstOperands,
     /*  39783 */     // GIR_Coverage, 825,
     /*  39783 */     GIR_Done,
     /*  39784 */   // Label 371: @39784
     /*  39784 */   GIM_Reject,
     /*  39785 */ // Label 362: @39785
     /*  39785 */ GIM_Reject,
     /*  39786 */ // Label 347: @39786
     /*  39786 */ GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(39910),
     /*  39791 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  39794 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  39797 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14000),
     /*  39801 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  39805 */   GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(39848), // Rule ID 8659 //
     /*  39810 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  39814 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  39818 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  39822 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  39826 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  39830 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39832 */     // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] }), i64:{ *:[i64] }:$src0)<<P:Predicate_anonymous_14000>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  39832 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  39835 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  39837 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  39839 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  39843 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  39846 */     GIR_RootConstrainSelectedInstOperands,
     /*  39847 */     // GIR_Coverage, 8659,
     /*  39847 */     GIR_EraseRootFromParent_Done,
     /*  39848 */   // Label 373: @39848
     /*  39848 */   GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(39891), // Rule ID 65 //
     /*  39853 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  39857 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  39861 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  39865 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  39869 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  39873 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39875 */     // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] }))<<P:Predicate_anonymous_14000>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  39875 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  39878 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  39880 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  39882 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  39886 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  39889 */     GIR_RootConstrainSelectedInstOperands,
     /*  39890 */     // GIR_Coverage, 65,
     /*  39890 */     GIR_EraseRootFromParent_Done,
     /*  39891 */   // Label 374: @39891
     /*  39891 */   GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(39909), // Rule ID 53 //
     /*  39896 */     // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_14000>>  =>  (S_AND_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  39896 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B64),
     /*  39901 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  39907 */     GIR_RootConstrainSelectedInstOperands,
     /*  39908 */     // GIR_Coverage, 53,
     /*  39908 */     GIR_Done,
     /*  39909 */   // Label 375: @39909
     /*  39909 */   GIM_Reject,
     /*  39910 */ // Label 372: @39910
     /*  39910 */ GIM_Reject,
     /*  39911 */ // Label 348: @39911
     /*  39911 */ GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(40061),
     /*  39916 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  39919 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  39922 */   GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(39981), // Rule ID 8730 //
     /*  39927 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39931 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  39935 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  39939 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  39943 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  39947 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  39951 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  39957 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  39959 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14000),
     /*  39963 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  39965 */     // (and:{ *:[v2i16] } (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] }), v2i16:{ *:[v2i16] }:$src0)<<P:Predicate_anonymous_14000>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
     /*  39965 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  39968 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  39970 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  39972 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  39976 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  39979 */     GIR_RootConstrainSelectedInstOperands,
     /*  39980 */     // GIR_Coverage, 8730,
     /*  39980 */     GIR_EraseRootFromParent_Done,
     /*  39981 */   // Label 377: @39981
     /*  39981 */   GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(40040), // Rule ID 1912 //
     /*  39986 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39990 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  39994 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  39998 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  40002 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  40006 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  40010 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  40016 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  40018 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14000),
     /*  40022 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40024 */     // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] }))<<P:Predicate_anonymous_14000>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
     /*  40024 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  40027 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40029 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  40031 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40035 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40038 */     GIR_RootConstrainSelectedInstOperands,
     /*  40039 */     // GIR_Coverage, 1912,
     /*  40039 */     GIR_EraseRootFromParent_Done,
     /*  40040 */   // Label 378: @40040
     /*  40040 */   GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(40060), // Rule ID 2566 //
     /*  40045 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40049 */     // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
     /*  40049 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  40054 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40058 */     GIR_RootConstrainSelectedInstOperands,
     /*  40059 */     // GIR_Coverage, 2566,
     /*  40059 */     GIR_Done,
     /*  40060 */   // Label 379: @40060
     /*  40060 */   GIM_Reject,
     /*  40061 */ // Label 376: @40061
     /*  40061 */ GIM_Reject,
     /*  40062 */ // Label 349: @40062
     /*  40062 */ GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(40184),
     /*  40067 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  40070 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  40073 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14000),
     /*  40077 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  40081 */   GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(40132), // Rule ID 8732 //
     /*  40086 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40090 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40094 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  40098 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  40102 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  40106 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  40112 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  40114 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40116 */     // (and:{ *:[v2i32] } (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] }), v2i32:{ *:[v2i32] }:$src0)<<P:Predicate_anonymous_14000>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
     /*  40116 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  40119 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40121 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  40123 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40127 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40130 */     GIR_RootConstrainSelectedInstOperands,
     /*  40131 */     // GIR_Coverage, 8732,
     /*  40131 */     GIR_EraseRootFromParent_Done,
     /*  40132 */   // Label 381: @40132
     /*  40132 */   GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(40183), // Rule ID 1914 //
     /*  40137 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  40141 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40145 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  40149 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  40153 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  40157 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  40163 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  40165 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40167 */     // (and:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src0, (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] }))<<P:Predicate_anonymous_14000>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
     /*  40167 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  40170 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40172 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  40174 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40178 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40181 */     GIR_RootConstrainSelectedInstOperands,
     /*  40182 */     // GIR_Coverage, 1914,
     /*  40182 */     GIR_EraseRootFromParent_Done,
     /*  40183 */   // Label 382: @40183
     /*  40183 */   GIM_Reject,
     /*  40184 */ // Label 380: @40184
     /*  40184 */ GIM_Reject,
     /*  40185 */ // Label 350: @40185
     /*  40185 */ GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(40307),
     /*  40190 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  40193 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  40196 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14000),
     /*  40200 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  40204 */   GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(40255), // Rule ID 8731 //
     /*  40209 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40213 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40217 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  40221 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  40225 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  40229 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  40235 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  40237 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40239 */     // (and:{ *:[v4i16] } (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] }), v4i16:{ *:[v4i16] }:$src0)<<P:Predicate_anonymous_14000>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
     /*  40239 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  40242 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40244 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  40246 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40250 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40253 */     GIR_RootConstrainSelectedInstOperands,
     /*  40254 */     // GIR_Coverage, 8731,
     /*  40254 */     GIR_EraseRootFromParent_Done,
     /*  40255 */   // Label 384: @40255
     /*  40255 */   GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(40306), // Rule ID 1913 //
     /*  40260 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  40264 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40268 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  40272 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  40276 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  40280 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  40286 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  40288 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40290 */     // (and:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src0, (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] }))<<P:Predicate_anonymous_14000>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
     /*  40290 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  40293 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40295 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  40297 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40301 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40304 */     GIR_RootConstrainSelectedInstOperands,
     /*  40305 */     // GIR_Coverage, 1913,
     /*  40305 */     GIR_EraseRootFromParent_Done,
     /*  40306 */   // Label 385: @40306
     /*  40306 */   GIM_Reject,
     /*  40307 */ // Label 383: @40307
     /*  40307 */ GIM_Reject,
     /*  40308 */ // Label 351: @40308
     /*  40308 */ GIM_Reject,
     /*  40309 */ // Label 4: @40309
     /*  40309 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(17), /*)*//*default:*//*Label 393*/ GIMT_Encode4(55820),
     /*  40320 */ /*GILLT_s1*//*Label 386*/ GIMT_Encode4(40360),
     /*  40324 */ /*GILLT_s16*//*Label 387*/ GIMT_Encode4(40423),
     /*  40328 */ /*GILLT_s32*//*Label 388*/ GIMT_Encode4(40663),
     /*  40332 */ /*GILLT_s64*//*Label 389*/ GIMT_Encode4(46234),
     /*  40336 */ /*GILLT_v2s16*//*Label 390*/ GIMT_Encode4(55423),
     /*  40340 */ /*GILLT_v2s32*//*Label 391*/ GIMT_Encode4(55574), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  40356 */ /*GILLT_v4s16*//*Label 392*/ GIMT_Encode4(55697),
     /*  40360 */ // Label 386: @40360
     /*  40360 */ GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(40422),
     /*  40365 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  40368 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  40371 */   GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(40396), // Rule ID 7651 //
     /*  40376 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  40379 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  40383 */     // (or:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_OR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  40383 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B64),
     /*  40388 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  40394 */     GIR_RootConstrainSelectedInstOperands,
     /*  40395 */     // GIR_Coverage, 7651,
     /*  40395 */     GIR_Done,
     /*  40396 */   // Label 395: @40396
     /*  40396 */   GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(40421), // Rule ID 7658 //
     /*  40401 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  40404 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40408 */     // (or:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_OR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  40408 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B32),
     /*  40413 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  40419 */     GIR_RootConstrainSelectedInstOperands,
     /*  40420 */     // GIR_Coverage, 7658,
     /*  40420 */     GIR_Done,
     /*  40421 */   // Label 396: @40421
     /*  40421 */   GIM_Reject,
     /*  40422 */ // Label 394: @40422
     /*  40422 */ GIM_Reject,
     /*  40423 */ // Label 387: @40423
     /*  40423 */ GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(40662),
     /*  40428 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  40431 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  40434 */   GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(40485), // Rule ID 8733 //
     /*  40439 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40443 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40447 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40451 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  40455 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  40459 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  40463 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14001),
     /*  40467 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  40469 */     // (or:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }), i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_14001>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  40469 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
     /*  40472 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40474 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  40476 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40480 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40483 */     GIR_RootConstrainSelectedInstOperands,
     /*  40484 */     // GIR_Coverage, 8733,
     /*  40484 */     GIR_EraseRootFromParent_Done,
     /*  40485 */   // Label 398: @40485
     /*  40485 */   GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(40536), // Rule ID 1915 //
     /*  40490 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40494 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  40498 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40502 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  40506 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  40510 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  40514 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14001),
     /*  40518 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  40520 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }))<<P:Predicate_anonymous_14001>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  40520 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
     /*  40523 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40525 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  40527 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40531 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40534 */     GIR_RootConstrainSelectedInstOperands,
     /*  40535 */     // GIR_Coverage, 1915,
     /*  40535 */     GIR_EraseRootFromParent_Done,
     /*  40536 */   // Label 399: @40536
     /*  40536 */   GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(40559), // Rule ID 2561 //
     /*  40541 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts),
     /*  40544 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40548 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
     /*  40548 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B32_e64),
     /*  40553 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40557 */     GIR_RootConstrainSelectedInstOperands,
     /*  40558 */     // GIR_Coverage, 2561,
     /*  40558 */     GIR_Done,
     /*  40559 */   // Label 400: @40559
     /*  40559 */   GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(40582), // Rule ID 2564 //
     /*  40564 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  40567 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40571 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
     /*  40571 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B32_e64),
     /*  40576 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40580 */     GIR_RootConstrainSelectedInstOperands,
     /*  40581 */     // GIR_Coverage, 2564,
     /*  40581 */     GIR_Done,
     /*  40582 */   // Label 401: @40582
     /*  40582 */   GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(40638), // Rule ID 927 //
     /*  40587 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  40590 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  40594 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  40601 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  40608 */     // (or:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_OR_B16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  40608 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B16_t16_e64),
     /*  40611 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40613 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  40618 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  40623 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  40628 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  40633 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40636 */     GIR_RootConstrainSelectedInstOperands,
     /*  40637 */     // GIR_Coverage, 927,
     /*  40637 */     GIR_EraseRootFromParent_Done,
     /*  40638 */   // Label 402: @40638
     /*  40638 */   GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(40661), // Rule ID 928 //
     /*  40643 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  40646 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40650 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  40650 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B16_fake16_e64),
     /*  40655 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40659 */     GIR_RootConstrainSelectedInstOperands,
     /*  40660 */     // GIR_Coverage, 928,
     /*  40660 */     GIR_Done,
     /*  40661 */   // Label 403: @40661
     /*  40661 */   GIM_Reject,
     /*  40662 */ // Label 397: @40662
     /*  40662 */ GIM_Reject,
     /*  40663 */ // Label 388: @40663
     /*  40663 */ GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(46233),
     /*  40668 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  40671 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  40674 */   GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(40855), // Rule ID 8763 //
     /*  40679 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  40682 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40686 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40690 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  40694 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  40698 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  40702 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  40706 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  40710 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  40714 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  40718 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  40722 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  40726 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  40730 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  40734 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  40738 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-128),
     /*  40742 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 127,
     /*  40746 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
     /*  40757 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  40761 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  40765 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  40769 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  40773 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  40777 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  40781 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  40785 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  40789 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  40793 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  40797 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  40801 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  40805 */     // MIs[6] src2
     /*  40805 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  40810 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, uint8_t(-128),
     /*  40814 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/3, 127,
     /*  40818 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
     /*  40822 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  40824 */     // (or:{ *:[i32] } (and:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 255:{ *:[i32] }), (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 8:{ *:[i32] }))  =>  (V_ASHR_PK_I8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  40824 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_I8_I32_e64),
     /*  40827 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40829 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40832 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  40836 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40839 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  40843 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40846 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  40850 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40853 */     GIR_RootConstrainSelectedInstOperands,
     /*  40854 */     // GIR_Coverage, 8763,
     /*  40854 */     GIR_EraseRootFromParent_Done,
     /*  40855 */   // Label 405: @40855
     /*  40855 */   GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(41036), // Rule ID 2749 //
     /*  40860 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  40863 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40867 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40871 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  40875 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  40879 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  40883 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  40887 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  40891 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  40895 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  40899 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  40903 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  40907 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  40911 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  40915 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  40919 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-128),
     /*  40923 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 127,
     /*  40927 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
     /*  40931 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  40935 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  40939 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  40943 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  40947 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  40951 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  40955 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  40959 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  40963 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  40967 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  40971 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  40975 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  40979 */     // MIs[6] src2
     /*  40979 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  40984 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, uint8_t(-128),
     /*  40988 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/3, 127,
     /*  40992 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(255),
     /*  41003 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  41005 */     // (or:{ *:[i32] } (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 8:{ *:[i32] }), (and:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 255:{ *:[i32] }))  =>  (V_ASHR_PK_I8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  41005 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_I8_I32_e64),
     /*  41008 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41010 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41013 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src0
     /*  41017 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41020 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  41024 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41027 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  41031 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41034 */     GIR_RootConstrainSelectedInstOperands,
     /*  41035 */     // GIR_Coverage, 2749,
     /*  41035 */     GIR_EraseRootFromParent_Done,
     /*  41036 */   // Label 406: @41036
     /*  41036 */   GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(41204), // Rule ID 8764 //
     /*  41041 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  41044 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41048 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41052 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  41056 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41060 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41064 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  41068 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41072 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  41076 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41080 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41084 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 0,
     /*  41088 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/3, GIMT_Encode8(255),
     /*  41099 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  41103 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  41107 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  41111 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  41115 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  41119 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  41123 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  41127 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  41131 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  41135 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  41139 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  41143 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  41147 */     // MIs[5] src2
     /*  41147 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  41152 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 0,
     /*  41156 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/3, GIMT_Encode8(255),
     /*  41167 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 8,
     /*  41171 */     GIM_CheckIsSafeToFold, /*NumInsns*/5,
     /*  41173 */     // (or:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }), (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }), 8:{ *:[i32] }))  =>  (V_ASHR_PK_U8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  41173 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_U8_I32_e64),
     /*  41176 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41178 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41181 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  41185 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41188 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src1
     /*  41192 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41195 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
     /*  41199 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41202 */     GIR_RootConstrainSelectedInstOperands,
     /*  41203 */     // GIR_Coverage, 8764,
     /*  41203 */     GIR_EraseRootFromParent_Done,
     /*  41204 */   // Label 407: @41204
     /*  41204 */   GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(41372), // Rule ID 2750 //
     /*  41209 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  41212 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41216 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41220 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  41224 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41228 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41232 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41236 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  41240 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41244 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41248 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  41252 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  41256 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  41260 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  41264 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  41268 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 0,
     /*  41272 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/3, GIMT_Encode8(255),
     /*  41283 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
     /*  41287 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  41291 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  41295 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  41299 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  41303 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  41307 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  41311 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  41315 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  41319 */     // MIs[5] src2
     /*  41319 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  41324 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 0,
     /*  41328 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/3, GIMT_Encode8(255),
     /*  41339 */     GIM_CheckIsSafeToFold, /*NumInsns*/5,
     /*  41341 */     // (or:{ *:[i32] } (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }), 8:{ *:[i32] }), (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }))  =>  (V_ASHR_PK_U8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  41341 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_U8_I32_e64),
     /*  41344 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41346 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41349 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  41353 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41356 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  41360 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41363 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  41367 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41370 */     GIR_RootConstrainSelectedInstOperands,
     /*  41371 */     // GIR_Coverage, 2750,
     /*  41371 */     GIR_EraseRootFromParent_Done,
     /*  41372 */   // Label 408: @41372
     /*  41372 */   GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(41519), // Rule ID 11415 //
     /*  41377 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41381 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41385 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  41389 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41393 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41397 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41401 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41405 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41409 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41413 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  41417 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  41421 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  41425 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  41429 */     // MIs[3] x
     /*  41429 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  41434 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  41438 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  41440 */     // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  41440 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  41443 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41447 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41452 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  41456 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41461 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  41464 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41468 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41473 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/2, // y
     /*  41477 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41482 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  41485 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41489 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41494 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  41498 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41503 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41506 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41508 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  41511 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  41514 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  41517 */     GIR_RootConstrainSelectedInstOperands,
     /*  41518 */     // GIR_Coverage, 11415,
     /*  41518 */     GIR_EraseRootFromParent_Done,
     /*  41519 */   // Label 409: @41519
     /*  41519 */   GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(41666), // Rule ID 11414 //
     /*  41524 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41528 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41532 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  41536 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41540 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41544 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41548 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41552 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41556 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41560 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  41564 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  41568 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  41572 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  41576 */     // MIs[3] x
     /*  41576 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  41581 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  41585 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  41587 */     // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  41587 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  41590 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41594 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41599 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  41603 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41608 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  41611 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41615 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41620 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/1, // y
     /*  41624 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41629 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  41632 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41636 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41641 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  41645 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41650 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41653 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41655 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  41658 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  41661 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  41664 */     GIR_RootConstrainSelectedInstOperands,
     /*  41665 */     // GIR_Coverage, 11414,
     /*  41665 */     GIR_EraseRootFromParent_Done,
     /*  41666 */   // Label 410: @41666
     /*  41666 */   GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(41813), // Rule ID 11413 //
     /*  41671 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41675 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41679 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  41683 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41687 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41691 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  41695 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41699 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41703 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41707 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  41711 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  41715 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  41719 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  41723 */     // MIs[3] x
     /*  41723 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  41728 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  41732 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  41734 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  41734 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  41737 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41741 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41746 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  41750 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41755 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  41758 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41762 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41767 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/2, // y
     /*  41771 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41776 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  41779 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41783 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41788 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  41792 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41797 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41800 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41802 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  41805 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  41808 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  41811 */     GIR_RootConstrainSelectedInstOperands,
     /*  41812 */     // GIR_Coverage, 11413,
     /*  41812 */     GIR_EraseRootFromParent_Done,
     /*  41813 */   // Label 411: @41813
     /*  41813 */   GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(41960), // Rule ID 11412 //
     /*  41818 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41822 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41826 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  41830 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41834 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41838 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  41842 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41846 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41850 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41854 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  41858 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  41862 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  41866 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  41870 */     // MIs[3] x
     /*  41870 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  41875 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  41879 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  41881 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  41881 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  41884 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41888 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41893 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  41897 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41902 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  41905 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41909 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41914 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/1, // y
     /*  41918 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41923 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  41926 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  41930 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  41935 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  41939 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41944 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  41947 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41949 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  41952 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  41955 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  41958 */     GIR_RootConstrainSelectedInstOperands,
     /*  41959 */     // GIR_Coverage, 11412,
     /*  41959 */     GIR_EraseRootFromParent_Done,
     /*  41960 */   // Label 412: @41960
     /*  41960 */   GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(42107), // Rule ID 11409 //
     /*  41965 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41969 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41973 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  41977 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41981 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41985 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  41989 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  41993 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41997 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42001 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  42005 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42009 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  42013 */     // MIs[3] x
     /*  42013 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  42018 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
     /*  42022 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  42026 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  42028 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  42028 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  42031 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42035 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42040 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  42044 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42049 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  42052 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42056 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42061 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  42065 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42070 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  42073 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42077 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42082 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  42086 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42091 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  42094 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42096 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  42099 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  42102 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  42105 */     GIR_RootConstrainSelectedInstOperands,
     /*  42106 */     // GIR_Coverage, 11409,
     /*  42106 */     GIR_EraseRootFromParent_Done,
     /*  42107 */   // Label 413: @42107
     /*  42107 */   GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(42254), // Rule ID 11411 //
     /*  42112 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42116 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42120 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42124 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42128 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42132 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  42136 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42140 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  42144 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42148 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  42152 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42156 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  42160 */     // MIs[3] x
     /*  42160 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  42165 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
     /*  42169 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  42173 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  42175 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  42175 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  42178 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42182 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42187 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  42191 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42196 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  42199 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42203 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42208 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  42212 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42217 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  42220 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42224 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42229 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  42233 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42238 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  42241 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42243 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  42246 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  42249 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  42252 */     GIR_RootConstrainSelectedInstOperands,
     /*  42253 */     // GIR_Coverage, 11411,
     /*  42253 */     GIR_EraseRootFromParent_Done,
     /*  42254 */   // Label 414: @42254
     /*  42254 */   GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(42401), // Rule ID 7552 //
     /*  42259 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42263 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42267 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42271 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42275 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42279 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  42283 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42287 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  42291 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42295 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  42299 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42303 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  42307 */     // MIs[3] x
     /*  42307 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  42312 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
     /*  42316 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  42320 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  42322 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  42322 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  42325 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42329 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42334 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  42338 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42343 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  42346 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42350 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42355 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  42359 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42364 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  42367 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42371 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42376 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  42380 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42385 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  42388 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42390 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  42393 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  42396 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  42399 */     GIR_RootConstrainSelectedInstOperands,
     /*  42400 */     // GIR_Coverage, 7552,
     /*  42400 */     GIR_EraseRootFromParent_Done,
     /*  42401 */   // Label 415: @42401
     /*  42401 */   GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(42548), // Rule ID 11410 //
     /*  42406 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42410 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42414 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42418 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42422 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42426 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  42430 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42434 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  42438 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42442 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  42446 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42450 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  42454 */     // MIs[3] x
     /*  42454 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  42459 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, uint8_t(-1),
     /*  42463 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  42467 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  42469 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  42469 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  42472 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42476 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42481 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  42485 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42490 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  42493 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42497 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42502 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  42506 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42511 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  42514 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42518 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42523 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  42527 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42532 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  42535 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42537 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  42540 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  42543 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  42546 */     GIR_RootConstrainSelectedInstOperands,
     /*  42547 */     // GIR_Coverage, 11410,
     /*  42547 */     GIR_EraseRootFromParent_Done,
     /*  42548 */   // Label 416: @42548
     /*  42548 */   GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(42641), // Rule ID 2646 //
     /*  42553 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  42556 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42560 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42564 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  42568 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42572 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42576 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  42578 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
     /*  42582 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42586 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42590 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  42594 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42598 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
     /*  42602 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  42606 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  42610 */     // MIs[3] Operand 1
     /*  42610 */     // No operand predicates
     /*  42610 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  42614 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:5:z
     /*  42618 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21446),
     /*  42622 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  42624 */     // (or:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:5:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_21436>>, i32:{ *:[i32] }:$src2:$pred:5:z)<<P:5:Predicate_anonymous_21446>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  42624 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
     /*  42627 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42629 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  42633 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  42637 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  42639 */     GIR_RootConstrainSelectedInstOperands,
     /*  42640 */     // GIR_Coverage, 2646,
     /*  42640 */     GIR_EraseRootFromParent_Done,
     /*  42641 */   // Label 417: @42641
     /*  42641 */   GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(42734), // Rule ID 8748 //
     /*  42646 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  42649 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42653 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:5:z
     /*  42657 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  42661 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  42665 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42669 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42673 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  42675 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
     /*  42679 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42683 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42687 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  42691 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42695 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
     /*  42699 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  42703 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  42707 */     // MIs[3] Operand 1
     /*  42707 */     // No operand predicates
     /*  42707 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  42711 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21446),
     /*  42715 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  42717 */     // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:5:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:5:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_21436>>)<<P:5:Predicate_anonymous_21446>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  42717 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
     /*  42720 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42722 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  42726 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  42730 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  42732 */     GIR_RootConstrainSelectedInstOperands,
     /*  42733 */     // GIR_Coverage, 8748,
     /*  42733 */     GIR_EraseRootFromParent_Done,
     /*  42734 */   // Label 418: @42734
     /*  42734 */   GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(42919), // Rule ID 11460 //
     /*  42739 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42743 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42747 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42751 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42755 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42759 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  42763 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  42767 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  42771 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42775 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  42779 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42783 */     // MIs[3] x
     /*  42783 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  42788 */     // MIs[3] z
     /*  42788 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  42793 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  42797 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  42799 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  42799 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  42802 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42806 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42811 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  42815 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42820 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  42823 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42827 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42832 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  42836 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42841 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  42844 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42848 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42853 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  42857 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42862 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  42865 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42869 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42874 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  42878 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42883 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  42886 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  42890 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42895 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  42898 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  42901 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  42903 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  42906 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42908 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  42911 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  42914 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  42917 */     GIR_RootConstrainSelectedInstOperands,
     /*  42918 */     // GIR_Coverage, 11460,
     /*  42918 */     GIR_EraseRootFromParent_Done,
     /*  42919 */   // Label 419: @42919
     /*  42919 */   GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(43104), // Rule ID 11461 //
     /*  42924 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42928 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42932 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42936 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42940 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42944 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  42948 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  42952 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  42956 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42960 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  42964 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42968 */     // MIs[3] z
     /*  42968 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  42973 */     // MIs[3] x
     /*  42973 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  42978 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  42982 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  42984 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  42984 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  42987 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42991 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42996 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  43000 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43005 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  43008 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43012 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43017 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  43021 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43026 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43029 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43033 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43038 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  43042 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43047 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43050 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43054 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43059 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  43063 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43068 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43071 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  43075 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43080 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  43083 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  43086 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  43088 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  43091 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43093 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  43096 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  43099 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  43102 */     GIR_RootConstrainSelectedInstOperands,
     /*  43103 */     // GIR_Coverage, 11461,
     /*  43103 */     GIR_EraseRootFromParent_Done,
     /*  43104 */   // Label 420: @43104
     /*  43104 */   GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(43289), // Rule ID 11462 //
     /*  43109 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43113 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43117 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43121 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43125 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43129 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43133 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  43137 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43141 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43145 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43149 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43153 */     // MIs[3] x
     /*  43153 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  43158 */     // MIs[3] z
     /*  43158 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  43163 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  43167 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43169 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  43169 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  43172 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43176 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43181 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  43185 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43190 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  43193 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43197 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43202 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  43206 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43211 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43214 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43218 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43223 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  43227 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43232 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43235 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43239 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43244 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  43248 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43253 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43256 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  43260 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43265 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  43268 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  43271 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  43273 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  43276 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43278 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  43281 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  43284 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  43287 */     GIR_RootConstrainSelectedInstOperands,
     /*  43288 */     // GIR_Coverage, 11462,
     /*  43288 */     GIR_EraseRootFromParent_Done,
     /*  43289 */   // Label 421: @43289
     /*  43289 */   GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(43474), // Rule ID 11463 //
     /*  43294 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43298 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43302 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43306 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43310 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43314 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43318 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  43322 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43326 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43330 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43334 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43338 */     // MIs[3] z
     /*  43338 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  43343 */     // MIs[3] x
     /*  43343 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  43348 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  43352 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43354 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  43354 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  43357 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43361 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43366 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  43370 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43375 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  43378 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43382 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43387 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  43391 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43396 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43399 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43403 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43408 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  43412 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43417 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43420 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43424 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43429 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  43433 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43438 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43441 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  43445 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43450 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  43453 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  43456 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  43458 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  43461 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43463 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  43466 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  43469 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  43472 */     GIR_RootConstrainSelectedInstOperands,
     /*  43473 */     // GIR_Coverage, 11463,
     /*  43473 */     GIR_EraseRootFromParent_Done,
     /*  43474 */   // Label 422: @43474
     /*  43474 */   GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(43659), // Rule ID 11456 //
     /*  43479 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43483 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43487 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43491 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43495 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43499 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  43503 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  43507 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43511 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43515 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43519 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43523 */     // MIs[3] x
     /*  43523 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  43528 */     // MIs[3] z
     /*  43528 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  43533 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  43537 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43539 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  43539 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  43542 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43546 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43551 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  43555 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43560 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  43563 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43567 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43572 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  43576 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43581 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43584 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43588 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43593 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  43597 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43602 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43605 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43609 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43614 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  43618 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43623 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43626 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  43630 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43635 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  43638 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  43641 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  43643 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  43646 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43648 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  43651 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  43654 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  43657 */     GIR_RootConstrainSelectedInstOperands,
     /*  43658 */     // GIR_Coverage, 11456,
     /*  43658 */     GIR_EraseRootFromParent_Done,
     /*  43659 */   // Label 423: @43659
     /*  43659 */   GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(43844), // Rule ID 11457 //
     /*  43664 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43668 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43672 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43676 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43680 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43684 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  43688 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  43692 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43696 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43700 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43704 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43708 */     // MIs[3] z
     /*  43708 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  43713 */     // MIs[3] x
     /*  43713 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  43718 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  43722 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43724 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  43724 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  43727 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43731 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43736 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  43740 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43745 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  43748 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43752 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43757 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  43761 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43766 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43769 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43773 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43778 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  43782 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43787 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43790 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43794 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43799 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  43803 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43808 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43811 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  43815 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43820 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  43823 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  43826 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  43828 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  43831 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43833 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  43836 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  43839 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  43842 */     GIR_RootConstrainSelectedInstOperands,
     /*  43843 */     // GIR_Coverage, 11457,
     /*  43843 */     GIR_EraseRootFromParent_Done,
     /*  43844 */   // Label 424: @43844
     /*  43844 */   GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(44029), // Rule ID 11458 //
     /*  43849 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43853 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43857 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43861 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43865 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43869 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  43873 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  43877 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43881 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43885 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43889 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43893 */     // MIs[3] x
     /*  43893 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  43898 */     // MIs[3] z
     /*  43898 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  43903 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  43907 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43909 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  43909 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  43912 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43916 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43921 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  43925 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43930 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  43933 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43937 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43942 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  43946 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43951 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43954 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43958 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43963 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  43967 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43972 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43975 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43979 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43984 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  43988 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43993 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43996 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  44000 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44005 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  44008 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  44011 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  44013 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44016 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44018 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44021 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  44024 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  44027 */     GIR_RootConstrainSelectedInstOperands,
     /*  44028 */     // GIR_Coverage, 11458,
     /*  44028 */     GIR_EraseRootFromParent_Done,
     /*  44029 */   // Label 425: @44029
     /*  44029 */   GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(44214), // Rule ID 11459 //
     /*  44034 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44038 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44042 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44046 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44050 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44054 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  44058 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  44062 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44066 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44070 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  44074 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44078 */     // MIs[3] z
     /*  44078 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  44083 */     // MIs[3] x
     /*  44083 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  44088 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  44092 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44094 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  44094 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  44097 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44101 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44106 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  44110 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44115 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  44118 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44122 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44127 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  44131 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44136 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44139 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44143 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44148 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  44152 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44157 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44160 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44164 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44169 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  44173 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44178 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44181 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  44185 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44190 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  44193 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  44196 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  44198 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44201 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44203 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44206 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  44209 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  44212 */     GIR_RootConstrainSelectedInstOperands,
     /*  44213 */     // GIR_Coverage, 11459,
     /*  44213 */     GIR_EraseRootFromParent_Done,
     /*  44214 */   // Label 426: @44214
     /*  44214 */   GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(44399), // Rule ID 11450 //
     /*  44219 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44223 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44227 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44231 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44235 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44239 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  44243 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44247 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44251 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44255 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  44259 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  44263 */     // MIs[3] x
     /*  44263 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  44268 */     // MIs[3] z
     /*  44268 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  44273 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  44277 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44279 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  44279 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  44282 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44286 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44291 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  44295 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44300 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  44303 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44307 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44312 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  44316 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44321 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44324 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44328 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44333 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  44337 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44342 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44345 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44349 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44354 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  44358 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44363 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44366 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  44370 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44375 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  44378 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  44381 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  44383 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44386 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44388 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44391 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  44394 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  44397 */     GIR_RootConstrainSelectedInstOperands,
     /*  44398 */     // GIR_Coverage, 11450,
     /*  44398 */     GIR_EraseRootFromParent_Done,
     /*  44399 */   // Label 427: @44399
     /*  44399 */   GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(44584), // Rule ID 11451 //
     /*  44404 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44408 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44412 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44416 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44420 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44424 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  44428 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44432 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44436 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44440 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  44444 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  44448 */     // MIs[3] z
     /*  44448 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  44453 */     // MIs[3] x
     /*  44453 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  44458 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  44462 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44464 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  44464 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  44467 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44471 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44476 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  44480 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44485 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  44488 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44492 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44497 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  44501 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44506 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44509 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44513 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44518 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  44522 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44527 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44530 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44534 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44539 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  44543 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44548 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44551 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  44555 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44560 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  44563 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  44566 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  44568 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44571 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44573 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44576 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  44579 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  44582 */     GIR_RootConstrainSelectedInstOperands,
     /*  44583 */     // GIR_Coverage, 11451,
     /*  44583 */     GIR_EraseRootFromParent_Done,
     /*  44584 */   // Label 428: @44584
     /*  44584 */   GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(44769), // Rule ID 11454 //
     /*  44589 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44593 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44597 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44601 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44605 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44609 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  44613 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44617 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44621 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44625 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  44629 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  44633 */     // MIs[3] x
     /*  44633 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  44638 */     // MIs[3] z
     /*  44638 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  44643 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  44647 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44649 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  44649 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  44652 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44656 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44661 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  44665 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44670 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  44673 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44677 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44682 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  44686 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44691 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44694 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44698 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44703 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  44707 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44712 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44715 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44719 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44724 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  44728 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44733 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44736 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  44740 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44745 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  44748 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  44751 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  44753 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44756 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44758 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44761 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  44764 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  44767 */     GIR_RootConstrainSelectedInstOperands,
     /*  44768 */     // GIR_Coverage, 11454,
     /*  44768 */     GIR_EraseRootFromParent_Done,
     /*  44769 */   // Label 429: @44769
     /*  44769 */   GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(44954), // Rule ID 11455 //
     /*  44774 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44778 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44782 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44786 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44790 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44794 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  44798 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44802 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44806 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44810 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  44814 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  44818 */     // MIs[3] z
     /*  44818 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  44823 */     // MIs[3] x
     /*  44823 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  44828 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  44832 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44834 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  44834 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  44837 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44841 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44846 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  44850 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44855 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  44858 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44862 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44867 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  44871 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44876 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44879 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44883 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44888 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  44892 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44897 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44900 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44904 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44909 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  44913 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44918 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44921 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  44925 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44930 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  44933 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  44936 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  44938 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44941 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44943 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44946 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  44949 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  44952 */     GIR_RootConstrainSelectedInstOperands,
     /*  44953 */     // GIR_Coverage, 11455,
     /*  44953 */     GIR_EraseRootFromParent_Done,
     /*  44954 */   // Label 430: @44954
     /*  44954 */   GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(45139), // Rule ID 7816 //
     /*  44959 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44963 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44967 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44971 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44975 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44979 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  44983 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44987 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44991 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44995 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  44999 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45003 */     // MIs[3] x
     /*  45003 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  45008 */     // MIs[3] z
     /*  45008 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  45013 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  45017 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45019 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45019 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45022 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45026 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45031 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  45035 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45040 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45043 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45047 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45052 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  45056 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45061 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45064 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45068 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45073 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  45077 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45082 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45085 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45089 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45094 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  45098 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45103 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45106 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45110 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45115 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45118 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45121 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45123 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45126 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45128 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45131 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45134 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45137 */     GIR_RootConstrainSelectedInstOperands,
     /*  45138 */     // GIR_Coverage, 7816,
     /*  45138 */     GIR_EraseRootFromParent_Done,
     /*  45139 */   // Label 431: @45139
     /*  45139 */   GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(45324), // Rule ID 11449 //
     /*  45144 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45148 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45152 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45156 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45160 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45164 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  45168 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45172 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45176 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45180 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  45184 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45188 */     // MIs[3] z
     /*  45188 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  45193 */     // MIs[3] x
     /*  45193 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  45198 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  45202 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45204 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45204 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45207 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45211 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45216 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  45220 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45225 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45228 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45232 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45237 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  45241 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45246 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45249 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45253 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45258 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  45262 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45267 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45270 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45274 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45279 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  45283 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45288 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45291 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45295 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45300 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45303 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45306 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45308 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45311 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45313 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45316 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45319 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45322 */     GIR_RootConstrainSelectedInstOperands,
     /*  45323 */     // GIR_Coverage, 11449,
     /*  45323 */     GIR_EraseRootFromParent_Done,
     /*  45324 */   // Label 432: @45324
     /*  45324 */   GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(45509), // Rule ID 11452 //
     /*  45329 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45333 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45337 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45341 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45345 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45349 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  45353 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45357 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45361 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45365 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  45369 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45373 */     // MIs[3] x
     /*  45373 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  45378 */     // MIs[3] z
     /*  45378 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  45383 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  45387 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45389 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45389 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45392 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45396 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45401 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  45405 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45410 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45413 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45417 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45422 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  45426 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45431 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45434 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45438 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45443 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  45447 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45452 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45455 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45459 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45464 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  45468 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45473 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45476 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45480 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45485 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45488 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45491 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45493 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45496 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45498 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45501 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45504 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45507 */     GIR_RootConstrainSelectedInstOperands,
     /*  45508 */     // GIR_Coverage, 11452,
     /*  45508 */     GIR_EraseRootFromParent_Done,
     /*  45509 */   // Label 433: @45509
     /*  45509 */   GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(45694), // Rule ID 11453 //
     /*  45514 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45518 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45522 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45526 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45530 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45534 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  45538 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45542 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45546 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45550 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  45554 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45558 */     // MIs[3] z
     /*  45558 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  45563 */     // MIs[3] x
     /*  45563 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  45568 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  45572 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45574 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))<<P:Predicate_anonymous_20194>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45574 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45577 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45581 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45586 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  45590 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45595 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45598 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45602 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45607 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  45611 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45616 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45619 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45623 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45628 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  45632 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45637 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45640 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45644 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45649 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  45653 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45658 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45661 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45665 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45670 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45673 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45676 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45678 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45681 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45683 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45686 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45689 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45692 */     GIR_RootConstrainSelectedInstOperands,
     /*  45693 */     // GIR_Coverage, 11453,
     /*  45693 */     GIR_EraseRootFromParent_Done,
     /*  45694 */   // Label 434: @45694
     /*  45694 */   GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(45745), // Rule ID 8660 //
     /*  45699 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  45703 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45707 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  45711 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45715 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45719 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  45723 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14001),
     /*  45727 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  45729 */     // (or:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }), i32:{ *:[i32] }:$src0)<<P:Predicate_anonymous_14001>>  =>  (S_ORN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  45729 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
     /*  45732 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  45734 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  45736 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  45740 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  45743 */     GIR_RootConstrainSelectedInstOperands,
     /*  45744 */     // GIR_Coverage, 8660,
     /*  45744 */     GIR_EraseRootFromParent_Done,
     /*  45745 */   // Label 435: @45745
     /*  45745 */   GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(45796), // Rule ID 66 //
     /*  45750 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  45754 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  45758 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  45762 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45766 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45770 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  45774 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14001),
     /*  45778 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  45780 */     // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }))<<P:Predicate_anonymous_14001>>  =>  (S_ORN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  45780 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
     /*  45783 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  45785 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  45787 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  45791 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  45794 */     GIR_RootConstrainSelectedInstOperands,
     /*  45795 */     // GIR_Coverage, 66,
     /*  45795 */     GIR_EraseRootFromParent_Done,
     /*  45796 */   // Label 436: @45796
     /*  45796 */   GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(45861), // Rule ID 2647 //
     /*  45801 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  45804 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45808 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45812 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45816 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45820 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45824 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  45826 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
     /*  45830 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
     /*  45834 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:6:z
     /*  45838 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21448),
     /*  45842 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  45844 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:6:x, i32:{ *:[i32] }:$src1:$pred:6:y)<<P:Predicate_anonymous_21449>>, i32:{ *:[i32] }:$src2:$pred:6:z)<<P:6:Predicate_anonymous_21448>>  =>  (V_AND_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  45844 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_OR_B32_e64),
     /*  45847 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45849 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  45853 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  45857 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  45859 */     GIR_RootConstrainSelectedInstOperands,
     /*  45860 */     // GIR_Coverage, 2647,
     /*  45860 */     GIR_EraseRootFromParent_Done,
     /*  45861 */   // Label 437: @45861
     /*  45861 */   GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(45926), // Rule ID 2648 //
     /*  45866 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  45869 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45873 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45877 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45881 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45885 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45889 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  45891 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
     /*  45895 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
     /*  45899 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:7:z
     /*  45903 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21451),
     /*  45907 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  45909 */     // (or:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:7:x, i32:{ *:[i32] }:$src1:$pred:7:y)<<P:Predicate_anonymous_21452>>, i32:{ *:[i32] }:$src2:$pred:7:z)<<P:7:Predicate_anonymous_21451>>  =>  (V_OR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  45909 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR3_B32_e64),
     /*  45912 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45914 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  45918 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  45922 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  45924 */     GIR_RootConstrainSelectedInstOperands,
     /*  45925 */     // GIR_Coverage, 2648,
     /*  45925 */     GIR_EraseRootFromParent_Done,
     /*  45926 */   // Label 438: @45926
     /*  45926 */   GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(45991), // Rule ID 2645 //
     /*  45931 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  45934 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45938 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45942 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  45946 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45950 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45954 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  45956 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
     /*  45960 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
     /*  45964 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:5:z
     /*  45968 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21446),
     /*  45972 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  45974 */     // (or:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, i32:{ *:[i32] }:$src1:$pred:5:y)<<P:Predicate_anonymous_21436>>, i32:{ *:[i32] }:$src2:$pred:5:z)<<P:5:Predicate_anonymous_21446>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  45974 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
     /*  45977 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45979 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  45983 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  45987 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  45989 */     GIR_RootConstrainSelectedInstOperands,
     /*  45990 */     // GIR_Coverage, 2645,
     /*  45990 */     GIR_EraseRootFromParent_Done,
     /*  45991 */   // Label 439: @45991
     /*  45991 */   GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(46056), // Rule ID 8749 //
     /*  45996 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  45999 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46003 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:6:z
     /*  46007 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  46011 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46015 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46019 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46023 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  46025 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
     /*  46029 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
     /*  46033 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21448),
     /*  46037 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  46039 */     // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:6:z, (and:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:6:x, i32:{ *:[i32] }:$src1:$pred:6:y)<<P:Predicate_anonymous_21449>>)<<P:6:Predicate_anonymous_21448>>  =>  (V_AND_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  46039 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_OR_B32_e64),
     /*  46042 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46044 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  46048 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  46052 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  46054 */     GIR_RootConstrainSelectedInstOperands,
     /*  46055 */     // GIR_Coverage, 8749,
     /*  46055 */     GIR_EraseRootFromParent_Done,
     /*  46056 */   // Label 440: @46056
     /*  46056 */   GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(46121), // Rule ID 8750 //
     /*  46061 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  46064 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46068 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:7:z
     /*  46072 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  46076 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /*  46080 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46084 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46088 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  46090 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
     /*  46094 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
     /*  46098 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21451),
     /*  46102 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  46104 */     // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:7:z, (or:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:7:x, i32:{ *:[i32] }:$src1:$pred:7:y)<<P:Predicate_anonymous_21452>>)<<P:7:Predicate_anonymous_21451>>  =>  (V_OR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  46104 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR3_B32_e64),
     /*  46107 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46109 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  46113 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  46117 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  46119 */     GIR_RootConstrainSelectedInstOperands,
     /*  46120 */     // GIR_Coverage, 8750,
     /*  46120 */     GIR_EraseRootFromParent_Done,
     /*  46121 */   // Label 441: @46121
     /*  46121 */   GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(46186), // Rule ID 8747 //
     /*  46126 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  46129 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46133 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:5:z
     /*  46137 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  46141 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  46145 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46149 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46153 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  46155 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
     /*  46159 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
     /*  46163 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21446),
     /*  46167 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  46169 */     // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:5:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, i32:{ *:[i32] }:$src1:$pred:5:y)<<P:Predicate_anonymous_21436>>)<<P:5:Predicate_anonymous_21446>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  46169 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
     /*  46172 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46174 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  46178 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  46182 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  46184 */     GIR_RootConstrainSelectedInstOperands,
     /*  46185 */     // GIR_Coverage, 8747,
     /*  46185 */     GIR_EraseRootFromParent_Done,
     /*  46186 */   // Label 442: @46186
     /*  46186 */   GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(46212), // Rule ID 54 //
     /*  46191 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  46195 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14001),
     /*  46199 */     // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_14001>>  =>  (S_OR_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  46199 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B32),
     /*  46204 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  46210 */     GIR_RootConstrainSelectedInstOperands,
     /*  46211 */     // GIR_Coverage, 54,
     /*  46211 */     GIR_Done,
     /*  46212 */   // Label 443: @46212
     /*  46212 */   GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(46232), // Rule ID 826 //
     /*  46217 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46221 */     // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_OR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  46221 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B32_e64),
     /*  46226 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  46230 */     GIR_RootConstrainSelectedInstOperands,
     /*  46231 */     // GIR_Coverage, 826,
     /*  46231 */     GIR_Done,
     /*  46232 */   // Label 444: @46232
     /*  46232 */   GIM_Reject,
     /*  46233 */ // Label 404: @46233
     /*  46233 */ GIM_Reject,
     /*  46234 */ // Label 389: @46234
     /*  46234 */ GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(55422),
     /*  46239 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  46242 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  46245 */   GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(46560), // Rule ID 11423 //
     /*  46250 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  46254 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46258 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46262 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  46266 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  46270 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  46274 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  46278 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*  46282 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  46286 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  46290 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  46294 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46298 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  46302 */     // MIs[3] x
     /*  46302 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  46307 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_20194),
     /*  46311 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  46313 */     // (or:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_20194>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
     /*  46313 */     GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
     /*  46316 */     GIR_BuildMI, /*InsnID*/8, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46320 */     GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46325 */     GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // z
     /*  46331 */     GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46336 */     GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  46341 */     GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
     /*  46344 */     GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46348 */     GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46353 */     GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(11), // y
     /*  46359 */     GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46364 */     GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  46369 */     GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
     /*  46372 */     GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46376 */     GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46381 */     GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(11), // x
     /*  46387 */     GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46392 */     GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  46397 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  46400 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  46404 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46409 */     GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/5,
     /*  46412 */     GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/6,
     /*  46415 */     GIR_AddSimpleTempRegister, /*InsnID*/5, /*TempRegID*/7,
     /*  46418 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
     /*  46420 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  46423 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46427 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46432 */     GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), // z
     /*  46438 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46443 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  46448 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  46451 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46455 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46460 */     GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(3), 