/* Utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
 * Copyright 2012 Tom Beckmann, Rico Tzschichholz
 * Copyright 2018-2025 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <meta/workspace.h>
#include <meta/window.h>
#include <float.h>
#include <math.h>
#include <meta/prefs.h>
#include <clutter/clutter.h>
#include <meta/meta-window-actor.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_UTILS (greeter_compositor_utils_get_type ())
#define GREETER_COMPOSITOR_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_UTILS, GreeterCompositorUtils))
#define GREETER_COMPOSITOR_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_UTILS, GreeterCompositorUtilsClass))
#define GREETER_COMPOSITOR_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_UTILS))
#define GREETER_COMPOSITOR_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_UTILS))
#define GREETER_COMPOSITOR_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_UTILS, GreeterCompositorUtilsClass))

typedef struct _GreeterCompositorUtils GreeterCompositorUtils;
typedef struct _GreeterCompositorUtilsClass GreeterCompositorUtilsClass;
typedef struct _GreeterCompositorUtilsPrivate GreeterCompositorUtilsPrivate;
typedef void (*GreeterCompositorUtilsWindowActorReadyCallback) (MetaWindowActor* window_actor, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block22Data Block22Data;
typedef struct _Block23Data Block23Data;
typedef struct _Block24Data Block24Data;
typedef struct _Block25Data Block25Data;
#define _gtk_widget_path_unref0(var) ((var == NULL) ? NULL : (var = (gtk_widget_path_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _GreeterCompositorParamSpecUtils GreeterCompositorParamSpecUtils;

struct _GreeterCompositorUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GreeterCompositorUtilsPrivate * priv;
};

struct _GreeterCompositorUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (GreeterCompositorUtils *self);
};

struct _Block22Data {
	int _ref_count_;
	MetaWindowActor* window_actor;
	MetaWindow* window;
	GreeterCompositorUtilsWindowActorReadyCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _Block23Data {
	int _ref_count_;
	GreeterCompositorUtilsWindowActorReadyCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _Block24Data {
	int _ref_count_;
	Block23Data * _data23_;
	MetaWindowActor* window_actor;
};

struct _Block25Data {
	int _ref_count_;
	Block24Data * _data24_;
	gulong show_handler;
};

struct _GreeterCompositorParamSpecUtils {
	GParamSpec parent_instance;
};

static gpointer greeter_compositor_utils_parent_class = NULL;
static GHashTable* greeter_compositor_utils_icon_pixbuf_cache;
static GHashTable* greeter_compositor_utils_icon_pixbuf_cache = NULL;
static GtkStyleContext* greeter_compositor_utils_selection_style_context;
static GtkStyleContext* greeter_compositor_utils_selection_style_context = NULL;

VALA_EXTERN gpointer greeter_compositor_utils_ref (gpointer instance);
VALA_EXTERN void greeter_compositor_utils_unref (gpointer instance);
VALA_EXTERN GParamSpec* greeter_compositor_param_spec_utils (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
VALA_EXTERN void greeter_compositor_value_set_utils (GValue* value,
                                         gpointer v_object);
VALA_EXTERN void greeter_compositor_value_take_utils (GValue* value,
                                          gpointer v_object);
VALA_EXTERN gpointer greeter_compositor_value_get_utils (const GValue* value);
VALA_EXTERN GType greeter_compositor_utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorUtils, greeter_compositor_utils_unref)
VALA_EXTERN guint greeter_compositor_utils_get_n_windows (MetaWorkspace* workspace);
VALA_EXTERN gint greeter_compositor_utils_scale_to_int (gint value,
                                            gfloat scale_factor);
VALA_EXTERN guint greeter_compositor_utils_get_animation_duration (guint duration);
VALA_EXTERN void greeter_compositor_utils_clutter_actor_reparent (ClutterActor* actor,
                                                      ClutterActor* new_parent);
VALA_EXTERN void greeter_compositor_utils_wait_for_window_actor (MetaWindow* window,
                                                     GreeterCompositorUtilsWindowActorReadyCallback callback,
                                                     gpointer callback_target,
                                                     GDestroyNotify callback_target_destroy_notify);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static gboolean __lambda17_ (Block22Data* _data22_);
static gboolean ___lambda17__gsource_func (gpointer self);
VALA_EXTERN void greeter_compositor_utils_wait_for_window_actor_visible (MetaWindow* window,
                                                             GreeterCompositorUtilsWindowActorReadyCallback callback,
                                                             gpointer callback_target,
                                                             GDestroyNotify callback_target_destroy_notify);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void __lambda18_ (Block23Data* _data23_,
                  MetaWindowActor* window_actor);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static void ___lambda19_ (Block25Data* _data25_);
static void ____lambda19__clutter_actor_show (ClutterActor* _sender,
                                       gpointer self);
static void ___lambda18__greeter_compositor_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                                        gpointer self);
VALA_EXTERN void greeter_compositor_utils_get_theme_accent_color (GdkRGBA* result);
VALA_EXTERN GreeterCompositorUtils* greeter_compositor_utils_new (void);
VALA_EXTERN GreeterCompositorUtils* greeter_compositor_utils_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void greeter_compositor_utils_finalize (GreeterCompositorUtils * obj);
static GType greeter_compositor_utils_get_type_once (void);

/**
         * Get the number of toplevel windows on a workspace excluding those that are
         * on all workspaces
         *
         * @param workspace The workspace on which to count the windows
         */
guint
greeter_compositor_utils_get_n_windows (MetaWorkspace* workspace)
{
	gint n = 0;
	GList* _tmp0_;
	guint result;
	g_return_val_if_fail (workspace != NULL, 0U);
	n = 0;
	_tmp0_ = meta_workspace_list_windows (workspace);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp1_;
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				MetaWindow* _tmp4_;
				MetaWindowType _tmp5_;
				MetaWindowType _tmp6_;
				_tmp1_ = window;
				if (meta_window_is_on_all_workspaces (_tmp1_)) {
					continue;
				}
				_tmp4_ = window;
				_tmp5_ = meta_window_get_window_type (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_ == META_WINDOW_NORMAL) {
					_tmp3_ = TRUE;
				} else {
					MetaWindow* _tmp7_;
					MetaWindowType _tmp8_;
					MetaWindowType _tmp9_;
					_tmp7_ = window;
					_tmp8_ = meta_window_get_window_type (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp3_ = _tmp9_ == META_WINDOW_DIALOG;
				}
				if (_tmp3_) {
					_tmp2_ = TRUE;
				} else {
					MetaWindow* _tmp10_;
					MetaWindowType _tmp11_;
					MetaWindowType _tmp12_;
					_tmp10_ = window;
					_tmp11_ = meta_window_get_window_type (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp2_ = _tmp12_ == META_WINDOW_MODAL_DIALOG;
				}
				if (_tmp2_) {
					gint _tmp13_;
					_tmp13_ = n;
					n = _tmp13_ + 1;
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	result = (guint) n;
	return result;
}

/**
         * Multiplies an integer by a floating scaling factor, and then
         * returns the result rounded to the nearest integer
         */
gint
greeter_compositor_utils_scale_to_int (gint value,
                                       gfloat scale_factor)
{
	gint result;
	result = (gint) round ((gdouble) (((gfloat) value) * scale_factor));
	return result;
}

/**
         * Utility that returns the given duration or 0 if animations are disabled.
         */
guint
greeter_compositor_utils_get_animation_duration (guint duration)
{
	guint _tmp0_ = 0U;
	guint result;
	if (meta_prefs_get_gnome_animations ()) {
		_tmp0_ = duration;
	} else {
		_tmp0_ = (guint) 0;
	}
	result = _tmp0_;
	return result;
}

void
greeter_compositor_utils_clutter_actor_reparent (ClutterActor* actor,
                                                 ClutterActor* new_parent)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (actor != NULL);
	g_return_if_fail (new_parent != NULL);
	if (actor == new_parent) {
		return;
	}
	g_object_ref ((GObject*) actor);
	_tmp0_ = clutter_actor_get_parent (actor);
	clutter_actor_remove_child (_tmp0_, actor);
	clutter_actor_add_child (new_parent, actor);
	g_object_unref ((GObject*) actor);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		_g_object_unref0 (_data22_->window);
		(_data22_->callback_target_destroy_notify == NULL) ? NULL : (_data22_->callback_target_destroy_notify (_data22_->callback_target), NULL);
		_data22_->callback = NULL;
		_data22_->callback_target = NULL;
		_data22_->callback_target_destroy_notify = NULL;
		g_slice_free (Block22Data, _data22_);
	}
}

static gboolean
__lambda17_ (Block22Data* _data22_)
{
	GObject* _tmp0_;
	MetaWindowActor* _tmp1_;
	gboolean result;
	_tmp0_ = meta_window_get_compositor_private (_data22_->window);
	_data22_->window_actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, meta_window_actor_get_type (), MetaWindowActor);
	_tmp1_ = _data22_->window_actor;
	if (_tmp1_ != NULL) {
		MetaWindowActor* _tmp2_;
		_tmp2_ = _data22_->window_actor;
		_data22_->callback (_tmp2_, _data22_->callback_target);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda17__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda17_ (self);
	return result;
}

void
greeter_compositor_utils_wait_for_window_actor (MetaWindow* window,
                                                GreeterCompositorUtilsWindowActorReadyCallback callback,
                                                gpointer callback_target,
                                                GDestroyNotify callback_target_destroy_notify)
{
	Block22Data* _data22_;
	MetaWindow* _tmp0_;
	GObject* _tmp1_;
	MetaWindowActor* _tmp2_;
	g_return_if_fail (window != NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data22_->window);
	_data22_->window = _tmp0_;
	(_data22_->callback_target_destroy_notify == NULL) ? NULL : (_data22_->callback_target_destroy_notify (_data22_->callback_target), NULL);
	_data22_->callback = NULL;
	_data22_->callback_target = NULL;
	_data22_->callback_target_destroy_notify = NULL;
	_data22_->callback = callback;
	_data22_->callback_target = callback_target;
	_data22_->callback_target_destroy_notify = callback_target_destroy_notify;
	_tmp1_ = meta_window_get_compositor_private (_data22_->window);
	_data22_->window_actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, meta_window_actor_get_type (), MetaWindowActor);
	_tmp2_ = _data22_->window_actor;
	if (_tmp2_ != NULL) {
		MetaWindowActor* _tmp3_;
		_tmp3_ = _data22_->window_actor;
		_data22_->callback (_tmp3_, _data22_->callback_target);
		block22_data_unref (_data22_);
		_data22_ = NULL;
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda17__gsource_func, block22_data_ref (_data22_), block22_data_unref);
	block22_data_unref (_data22_);
	_data22_ = NULL;
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		(_data23_->callback_target_destroy_notify == NULL) ? NULL : (_data23_->callback_target_destroy_notify (_data23_->callback_target), NULL);
		_data23_->callback = NULL;
		_data23_->callback_target = NULL;
		_data23_->callback_target_destroy_notify = NULL;
		g_slice_free (Block23Data, _data23_);
	}
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		_g_object_unref0 (_data24_->window_actor);
		block23_data_unref (_data24_->_data23_);
		_data24_->_data23_ = NULL;
		g_slice_free (Block24Data, _data24_);
	}
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		block24_data_unref (_data25_->_data24_);
		_data25_->_data24_ = NULL;
		g_slice_free (Block25Data, _data25_);
	}
}

static void
___lambda19_ (Block25Data* _data25_)
{
	Block24Data* _data24_;
	Block23Data* _data23_;
	_data24_ = _data25_->_data24_;
	_data23_ = _data24_->_data23_;
	g_signal_handler_disconnect ((GObject*) _data24_->window_actor, _data25_->show_handler);
	_data23_->callback (_data24_->window_actor, _data23_->callback_target);
}

static void
____lambda19__clutter_actor_show (ClutterActor* _sender,
                                  gpointer self)
{
	___lambda19_ (self);
}

static void
__lambda18_ (Block23Data* _data23_,
             MetaWindowActor* window_actor)
{
	Block24Data* _data24_;
	MetaWindowActor* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (window_actor != NULL);
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->_data23_ = block23_data_ref (_data23_);
	_tmp0_ = _g_object_ref0 (window_actor);
	_g_object_unref0 (_data24_->window_actor);
	_data24_->window_actor = _tmp0_;
	g_object_get ((ClutterActor*) _data24_->window_actor, "visible", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_data23_->callback (_data24_->window_actor, _data23_->callback_target);
	} else {
		Block25Data* _data25_;
		gulong _tmp3_;
		_data25_ = g_slice_new0 (Block25Data);
		_data25_->_ref_count_ = 1;
		_data25_->_data24_ = block24_data_ref (_data24_);
		_data25_->show_handler = (gulong) 0;
		_tmp3_ = g_signal_connect_data ((ClutterActor*) _data24_->window_actor, "show", (GCallback) ____lambda19__clutter_actor_show, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
		_data25_->show_handler = _tmp3_;
		block25_data_unref (_data25_);
		_data25_ = NULL;
	}
	block24_data_unref (_data24_);
	_data24_ = NULL;
}

static void
___lambda18__greeter_compositor_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                                   gpointer self)
{
	__lambda18_ (self, window_actor);
}

void
greeter_compositor_utils_wait_for_window_actor_visible (MetaWindow* window,
                                                        GreeterCompositorUtilsWindowActorReadyCallback callback,
                                                        gpointer callback_target,
                                                        GDestroyNotify callback_target_destroy_notify)
{
	Block23Data* _data23_;
	g_return_if_fail (window != NULL);
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	(_data23_->callback_target_destroy_notify == NULL) ? NULL : (_data23_->callback_target_destroy_notify (_data23_->callback_target), NULL);
	_data23_->callback = NULL;
	_data23_->callback_target = NULL;
	_data23_->callback_target_destroy_notify = NULL;
	_data23_->callback = callback;
	_data23_->callback_target = callback_target;
	_data23_->callback_target_destroy_notify = callback_target_destroy_notify;
	greeter_compositor_utils_wait_for_window_actor (window, ___lambda18__greeter_compositor_utils_window_actor_ready_callback, block23_data_ref (_data23_), block23_data_unref);
	block23_data_unref (_data23_);
	_data23_ = NULL;
}

void
greeter_compositor_utils_get_theme_accent_color (GdkRGBA* result)
{
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp7_;
	GValue _tmp8_ = {0};
	GValue _tmp9_;
	GdkRGBA* _tmp10_;
	GdkRGBA _tmp11_ = {0};
	GdkRGBA _tmp12_;
	_tmp0_ = greeter_compositor_utils_selection_style_context;
	if (_tmp0_ == NULL) {
		GtkWidgetPath* label_widget_path = NULL;
		GtkWidgetPath* _tmp1_;
		GtkWidgetPath* _tmp2_;
		GtkWidgetPath* _tmp3_;
		GtkStyleContext* _tmp4_;
		GtkStyleContext* _tmp5_;
		GtkWidgetPath* _tmp6_;
		_tmp1_ = gtk_widget_path_new ();
		label_widget_path = _tmp1_;
		_tmp2_ = label_widget_path;
		gtk_widget_path_append_type (_tmp2_, g_type_from_name ("label"));
		_tmp3_ = label_widget_path;
		gtk_widget_path_iter_set_object_name (_tmp3_, -1, "selection");
		_tmp4_ = gtk_style_context_new ();
		_g_object_unref0 (greeter_compositor_utils_selection_style_context);
		greeter_compositor_utils_selection_style_context = _tmp4_;
		_tmp5_ = greeter_compositor_utils_selection_style_context;
		_tmp6_ = label_widget_path;
		gtk_style_context_set_path (_tmp5_, _tmp6_);
		_gtk_widget_path_unref0 (label_widget_path);
	}
	_tmp7_ = greeter_compositor_utils_selection_style_context;
	gtk_style_context_get_property (_tmp7_, GTK_STYLE_PROPERTY_BACKGROUND_COLOR, GTK_STATE_FLAG_NORMAL, &_tmp8_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_value_get_boxed (&_tmp8_);
	_tmp12_ = (G_VALUE_HOLDS (&_tmp8_, gdk_rgba_get_type ()) && _tmp10_) ? (*_tmp10_) : (g_warning ("Invalid GValue unboxing (wrong type or NULL)"), _tmp11_);
	G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
	*result = _tmp12_;
	return;
}

GreeterCompositorUtils*
greeter_compositor_utils_construct (GType object_type)
{
	GreeterCompositorUtils* self = NULL;
	self = (GreeterCompositorUtils*) g_type_create_instance (object_type);
	return self;
}

GreeterCompositorUtils*
greeter_compositor_utils_new (void)
{
	return greeter_compositor_utils_construct (GREETER_COMPOSITOR_TYPE_UTILS);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
greeter_compositor_value_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
greeter_compositor_value_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		greeter_compositor_utils_unref (value->data[0].v_pointer);
	}
}

static void
greeter_compositor_value_utils_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = greeter_compositor_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
greeter_compositor_value_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
greeter_compositor_value_utils_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GreeterCompositorUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = greeter_compositor_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
greeter_compositor_value_utils_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	GreeterCompositorUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = greeter_compositor_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
greeter_compositor_param_spec_utils (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	GreeterCompositorParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GREETER_COMPOSITOR_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
greeter_compositor_value_get_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GREETER_COMPOSITOR_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
greeter_compositor_value_set_utils (GValue* value,
                                    gpointer v_object)
{
	GreeterCompositorUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GREETER_COMPOSITOR_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GREETER_COMPOSITOR_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		greeter_compositor_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		greeter_compositor_utils_unref (old);
	}
}

void
greeter_compositor_value_take_utils (GValue* value,
                                     gpointer v_object)
{
	GreeterCompositorUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GREETER_COMPOSITOR_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GREETER_COMPOSITOR_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		greeter_compositor_utils_unref (old);
	}
}

static void
greeter_compositor_utils_base_init (GreeterCompositorUtilsClass * klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (greeter_compositor_utils_icon_pixbuf_cache);
	greeter_compositor_utils_icon_pixbuf_cache = _tmp2_;
}

static void
greeter_compositor_utils_class_init (GreeterCompositorUtilsClass * klass,
                                     gpointer klass_data)
{
	greeter_compositor_utils_parent_class = g_type_class_peek_parent (klass);
	((GreeterCompositorUtilsClass *) klass)->finalize = greeter_compositor_utils_finalize;
}

static void
greeter_compositor_utils_instance_init (GreeterCompositorUtils * self,
                                        gpointer klass)
{
	self->ref_count = 1;
}

static void
greeter_compositor_utils_finalize (GreeterCompositorUtils * obj)
{
	GreeterCompositorUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_UTILS, GreeterCompositorUtils);
	g_signal_handlers_destroy (self);
}

static GType
greeter_compositor_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { greeter_compositor_value_utils_init, greeter_compositor_value_utils_free_value, greeter_compositor_value_utils_copy_value, greeter_compositor_value_utils_peek_pointer, "p", greeter_compositor_value_utils_collect_value, "p", greeter_compositor_value_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorUtilsClass), (GBaseInitFunc) greeter_compositor_utils_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorUtils), 0, (GInstanceInitFunc) greeter_compositor_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType greeter_compositor_utils_type_id;
	greeter_compositor_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GreeterCompositorUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return greeter_compositor_utils_type_id;
}

GType
greeter_compositor_utils_get_type (void)
{
	static volatile gsize greeter_compositor_utils_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_utils_type_id__once)) {
		GType greeter_compositor_utils_type_id;
		greeter_compositor_utils_type_id = greeter_compositor_utils_get_type_once ();
		g_once_init_leave (&greeter_compositor_utils_type_id__once, greeter_compositor_utils_type_id);
	}
	return greeter_compositor_utils_type_id__once;
}

gpointer
greeter_compositor_utils_ref (gpointer instance)
{
	GreeterCompositorUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
greeter_compositor_utils_unref (gpointer instance)
{
	GreeterCompositorUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GREETER_COMPOSITOR_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

