/* libguestfs generated file
 * WARNING: THIS FILE IS GENERATED FROM THE FOLLOWING FILES:
 *          generator/erlang.ml
 *          and from the code in the generator/ subdirectory.
 * ANY CHANGES YOU MAKE TO THIS FILE WILL BE LOST.
 *
 * Copyright (C) 2009-2025 Red Hat Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <errno.h>

#include <ei.h>

#include "guestfs.h"
#include "guestfs-utils.h"

#include "actions.h"

int
dispatch (ei_x_buff *retbuff, const char *buff, int *index)
{
  int arity;
  char fun[MAXATOMLEN];

  if (ei_decode_tuple_header (buff, index, &arity) != 0) return -1;
  if (ei_decode_atom (buff, index, fun) != 0) return -1;

  /* XXX We should use gperf here. */
  if (atom_equals (fun, "acl_delete_def_file"))
    return run_acl_delete_def_file (retbuff, buff, index);
  else if (atom_equals (fun, "acl_get_file"))
    return run_acl_get_file (retbuff, buff, index);
  else if (atom_equals (fun, "acl_set_file"))
    return run_acl_set_file (retbuff, buff, index);
  else if (atom_equals (fun, "add_cdrom"))
    return run_add_cdrom (retbuff, buff, index);
  else if (atom_equals (fun, "add_domain"))
    return run_add_domain (retbuff, buff, index);
  else if (atom_equals (fun, "add_drive"))
    return run_add_drive (retbuff, buff, index);
  else if (atom_equals (fun, "add_drive_ro"))
    return run_add_drive_ro (retbuff, buff, index);
  else if (atom_equals (fun, "add_drive_ro_with_if"))
    return run_add_drive_ro_with_if (retbuff, buff, index);
  else if (atom_equals (fun, "add_drive_scratch"))
    return run_add_drive_scratch (retbuff, buff, index);
  else if (atom_equals (fun, "add_drive_with_if"))
    return run_add_drive_with_if (retbuff, buff, index);
  else if (atom_equals (fun, "add_libvirt_dom"))
    return run_add_libvirt_dom (retbuff, buff, index);
  else if (atom_equals (fun, "aug_clear"))
    return run_aug_clear (retbuff, buff, index);
  else if (atom_equals (fun, "aug_close"))
    return run_aug_close (retbuff, buff, index);
  else if (atom_equals (fun, "aug_defnode"))
    return run_aug_defnode (retbuff, buff, index);
  else if (atom_equals (fun, "aug_defvar"))
    return run_aug_defvar (retbuff, buff, index);
  else if (atom_equals (fun, "aug_get"))
    return run_aug_get (retbuff, buff, index);
  else if (atom_equals (fun, "aug_init"))
    return run_aug_init (retbuff, buff, index);
  else if (atom_equals (fun, "aug_insert"))
    return run_aug_insert (retbuff, buff, index);
  else if (atom_equals (fun, "aug_label"))
    return run_aug_label (retbuff, buff, index);
  else if (atom_equals (fun, "aug_load"))
    return run_aug_load (retbuff, buff, index);
  else if (atom_equals (fun, "aug_ls"))
    return run_aug_ls (retbuff, buff, index);
  else if (atom_equals (fun, "aug_match"))
    return run_aug_match (retbuff, buff, index);
  else if (atom_equals (fun, "aug_mv"))
    return run_aug_mv (retbuff, buff, index);
  else if (atom_equals (fun, "aug_rm"))
    return run_aug_rm (retbuff, buff, index);
  else if (atom_equals (fun, "aug_save"))
    return run_aug_save (retbuff, buff, index);
  else if (atom_equals (fun, "aug_set"))
    return run_aug_set (retbuff, buff, index);
  else if (atom_equals (fun, "aug_setm"))
    return run_aug_setm (retbuff, buff, index);
  else if (atom_equals (fun, "aug_transform"))
    return run_aug_transform (retbuff, buff, index);
  else if (atom_equals (fun, "available"))
    return run_available (retbuff, buff, index);
  else if (atom_equals (fun, "available_all_groups"))
    return run_available_all_groups (retbuff, buff, index);
  else if (atom_equals (fun, "base64_in"))
    return run_base64_in (retbuff, buff, index);
  else if (atom_equals (fun, "base64_out"))
    return run_base64_out (retbuff, buff, index);
  else if (atom_equals (fun, "blkdiscard"))
    return run_blkdiscard (retbuff, buff, index);
  else if (atom_equals (fun, "blkdiscardzeroes"))
    return run_blkdiscardzeroes (retbuff, buff, index);
  else if (atom_equals (fun, "blkid"))
    return run_blkid (retbuff, buff, index);
  else if (atom_equals (fun, "blockdev_flushbufs"))
    return run_blockdev_flushbufs (retbuff, buff, index);
  else if (atom_equals (fun, "blockdev_getbsz"))
    return run_blockdev_getbsz (retbuff, buff, index);
  else if (atom_equals (fun, "blockdev_getro"))
    return run_blockdev_getro (retbuff, buff, index);
  else if (atom_equals (fun, "blockdev_getsize64"))
    return run_blockdev_getsize64 (retbuff, buff, index);
  else if (atom_equals (fun, "blockdev_getss"))
    return run_blockdev_getss (retbuff, buff, index);
  else if (atom_equals (fun, "blockdev_getsz"))
    return run_blockdev_getsz (retbuff, buff, index);
  else if (atom_equals (fun, "blockdev_rereadpt"))
    return run_blockdev_rereadpt (retbuff, buff, index);
  else if (atom_equals (fun, "blockdev_setbsz"))
    return run_blockdev_setbsz (retbuff, buff, index);
  else if (atom_equals (fun, "blockdev_setra"))
    return run_blockdev_setra (retbuff, buff, index);
  else if (atom_equals (fun, "blockdev_setro"))
    return run_blockdev_setro (retbuff, buff, index);
  else if (atom_equals (fun, "blockdev_setrw"))
    return run_blockdev_setrw (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_balance_cancel"))
    return run_btrfs_balance_cancel (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_balance_pause"))
    return run_btrfs_balance_pause (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_balance_resume"))
    return run_btrfs_balance_resume (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_balance_status"))
    return run_btrfs_balance_status (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_device_add"))
    return run_btrfs_device_add (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_device_delete"))
    return run_btrfs_device_delete (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_filesystem_balance"))
    return run_btrfs_filesystem_balance (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_filesystem_defragment"))
    return run_btrfs_filesystem_defragment (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_filesystem_resize"))
    return run_btrfs_filesystem_resize (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_filesystem_show"))
    return run_btrfs_filesystem_show (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_filesystem_sync"))
    return run_btrfs_filesystem_sync (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_fsck"))
    return run_btrfs_fsck (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_image"))
    return run_btrfs_image (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_qgroup_assign"))
    return run_btrfs_qgroup_assign (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_qgroup_create"))
    return run_btrfs_qgroup_create (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_qgroup_destroy"))
    return run_btrfs_qgroup_destroy (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_qgroup_limit"))
    return run_btrfs_qgroup_limit (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_qgroup_remove"))
    return run_btrfs_qgroup_remove (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_qgroup_show"))
    return run_btrfs_qgroup_show (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_quota_enable"))
    return run_btrfs_quota_enable (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_quota_rescan"))
    return run_btrfs_quota_rescan (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_replace"))
    return run_btrfs_replace (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_rescue_chunk_recover"))
    return run_btrfs_rescue_chunk_recover (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_rescue_super_recover"))
    return run_btrfs_rescue_super_recover (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_scrub_cancel"))
    return run_btrfs_scrub_cancel (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_scrub_full"))
    return run_btrfs_scrub_full (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_scrub_resume"))
    return run_btrfs_scrub_resume (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_scrub_start"))
    return run_btrfs_scrub_start (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_scrub_status"))
    return run_btrfs_scrub_status (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_set_seeding"))
    return run_btrfs_set_seeding (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_subvolume_create"))
    return run_btrfs_subvolume_create (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_subvolume_delete"))
    return run_btrfs_subvolume_delete (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_subvolume_get_default"))
    return run_btrfs_subvolume_get_default (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_subvolume_list"))
    return run_btrfs_subvolume_list (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_subvolume_set_default"))
    return run_btrfs_subvolume_set_default (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_subvolume_show"))
    return run_btrfs_subvolume_show (retbuff, buff, index);
  else if (atom_equals (fun, "btrfs_subvolume_snapshot"))
    return run_btrfs_subvolume_snapshot (retbuff, buff, index);
  else if (atom_equals (fun, "btrfstune_enable_extended_inode_refs"))
    return run_btrfstune_enable_extended_inode_refs (retbuff, buff, index);
  else if (atom_equals (fun, "btrfstune_enable_skinny_metadata_extent_refs"))
    return run_btrfstune_enable_skinny_metadata_extent_refs (retbuff, buff, index);
  else if (atom_equals (fun, "btrfstune_seeding"))
    return run_btrfstune_seeding (retbuff, buff, index);
  else if (atom_equals (fun, "c_pointer"))
    return run_c_pointer (retbuff, buff, index);
  else if (atom_equals (fun, "canonical_device_name"))
    return run_canonical_device_name (retbuff, buff, index);
  else if (atom_equals (fun, "cap_get_file"))
    return run_cap_get_file (retbuff, buff, index);
  else if (atom_equals (fun, "cap_set_file"))
    return run_cap_set_file (retbuff, buff, index);
  else if (atom_equals (fun, "case_sensitive_path"))
    return run_case_sensitive_path (retbuff, buff, index);
  else if (atom_equals (fun, "cat"))
    return run_cat (retbuff, buff, index);
  else if (atom_equals (fun, "checksum"))
    return run_checksum (retbuff, buff, index);
  else if (atom_equals (fun, "checksum_device"))
    return run_checksum_device (retbuff, buff, index);
  else if (atom_equals (fun, "checksums_out"))
    return run_checksums_out (retbuff, buff, index);
  else if (atom_equals (fun, "chmod"))
    return run_chmod (retbuff, buff, index);
  else if (atom_equals (fun, "chown"))
    return run_chown (retbuff, buff, index);
  else if (atom_equals (fun, "clear_backend_setting"))
    return run_clear_backend_setting (retbuff, buff, index);
  else if (atom_equals (fun, "clevis_luks_unlock"))
    return run_clevis_luks_unlock (retbuff, buff, index);
  else if (atom_equals (fun, "command"))
    return run_command (retbuff, buff, index);
  else if (atom_equals (fun, "command_lines"))
    return run_command_lines (retbuff, buff, index);
  else if (atom_equals (fun, "command_out"))
    return run_command_out (retbuff, buff, index);
  else if (atom_equals (fun, "compress_device_out"))
    return run_compress_device_out (retbuff, buff, index);
  else if (atom_equals (fun, "compress_out"))
    return run_compress_out (retbuff, buff, index);
  else if (atom_equals (fun, "config"))
    return run_config (retbuff, buff, index);
  else if (atom_equals (fun, "copy_attributes"))
    return run_copy_attributes (retbuff, buff, index);
  else if (atom_equals (fun, "copy_device_to_device"))
    return run_copy_device_to_device (retbuff, buff, index);
  else if (atom_equals (fun, "copy_device_to_file"))
    return run_copy_device_to_file (retbuff, buff, index);
  else if (atom_equals (fun, "copy_file_to_device"))
    return run_copy_file_to_device (retbuff, buff, index);
  else if (atom_equals (fun, "copy_file_to_file"))
    return run_copy_file_to_file (retbuff, buff, index);
  else if (atom_equals (fun, "copy_in"))
    return run_copy_in (retbuff, buff, index);
  else if (atom_equals (fun, "copy_out"))
    return run_copy_out (retbuff, buff, index);
  else if (atom_equals (fun, "copy_size"))
    return run_copy_size (retbuff, buff, index);
  else if (atom_equals (fun, "cp"))
    return run_cp (retbuff, buff, index);
  else if (atom_equals (fun, "cp_a"))
    return run_cp_a (retbuff, buff, index);
  else if (atom_equals (fun, "cp_r"))
    return run_cp_r (retbuff, buff, index);
  else if (atom_equals (fun, "cpio_out"))
    return run_cpio_out (retbuff, buff, index);
  else if (atom_equals (fun, "cryptsetup_close"))
    return run_cryptsetup_close (retbuff, buff, index);
  else if (atom_equals (fun, "cryptsetup_open"))
    return run_cryptsetup_open (retbuff, buff, index);
  else if (atom_equals (fun, "dd"))
    return run_dd (retbuff, buff, index);
  else if (atom_equals (fun, "debug"))
    return run_debug (retbuff, buff, index);
  else if (atom_equals (fun, "debug_drives"))
    return run_debug_drives (retbuff, buff, index);
  else if (atom_equals (fun, "debug_upload"))
    return run_debug_upload (retbuff, buff, index);
  else if (atom_equals (fun, "device_index"))
    return run_device_index (retbuff, buff, index);
  else if (atom_equals (fun, "device_name"))
    return run_device_name (retbuff, buff, index);
  else if (atom_equals (fun, "df"))
    return run_df (retbuff, buff, index);
  else if (atom_equals (fun, "df_h"))
    return run_df_h (retbuff, buff, index);
  else if (atom_equals (fun, "disk_create"))
    return run_disk_create (retbuff, buff, index);
  else if (atom_equals (fun, "disk_format"))
    return run_disk_format (retbuff, buff, index);
  else if (atom_equals (fun, "disk_has_backing_file"))
    return run_disk_has_backing_file (retbuff, buff, index);
  else if (atom_equals (fun, "disk_virtual_size"))
    return run_disk_virtual_size (retbuff, buff, index);
  else if (atom_equals (fun, "dmesg"))
    return run_dmesg (retbuff, buff, index);
  else if (atom_equals (fun, "download"))
    return run_download (retbuff, buff, index);
  else if (atom_equals (fun, "download_blocks"))
    return run_download_blocks (retbuff, buff, index);
  else if (atom_equals (fun, "download_inode"))
    return run_download_inode (retbuff, buff, index);
  else if (atom_equals (fun, "download_offset"))
    return run_download_offset (retbuff, buff, index);
  else if (atom_equals (fun, "drop_caches"))
    return run_drop_caches (retbuff, buff, index);
  else if (atom_equals (fun, "du"))
    return run_du (retbuff, buff, index);
  else if (atom_equals (fun, "e2fsck"))
    return run_e2fsck (retbuff, buff, index);
  else if (atom_equals (fun, "e2fsck_f"))
    return run_e2fsck_f (retbuff, buff, index);
  else if (atom_equals (fun, "echo_daemon"))
    return run_echo_daemon (retbuff, buff, index);
  else if (atom_equals (fun, "egrep"))
    return run_egrep (retbuff, buff, index);
  else if (atom_equals (fun, "egrepi"))
    return run_egrepi (retbuff, buff, index);
  else if (atom_equals (fun, "equal"))
    return run_equal (retbuff, buff, index);
  else if (atom_equals (fun, "exists"))
    return run_exists (retbuff, buff, index);
  else if (atom_equals (fun, "extlinux"))
    return run_extlinux (retbuff, buff, index);
  else if (atom_equals (fun, "f2fs_expand"))
    return run_f2fs_expand (retbuff, buff, index);
  else if (atom_equals (fun, "fallocate"))
    return run_fallocate (retbuff, buff, index);
  else if (atom_equals (fun, "fallocate64"))
    return run_fallocate64 (retbuff, buff, index);
  else if (atom_equals (fun, "feature_available"))
    return run_feature_available (retbuff, buff, index);
  else if (atom_equals (fun, "fgrep"))
    return run_fgrep (retbuff, buff, index);
  else if (atom_equals (fun, "fgrepi"))
    return run_fgrepi (retbuff, buff, index);
  else if (atom_equals (fun, "file"))
    return run_file (retbuff, buff, index);
  else if (atom_equals (fun, "file_architecture"))
    return run_file_architecture (retbuff, buff, index);
  else if (atom_equals (fun, "filesize"))
    return run_filesize (retbuff, buff, index);
  else if (atom_equals (fun, "filesystem_available"))
    return run_filesystem_available (retbuff, buff, index);
  else if (atom_equals (fun, "filesystem_walk"))
    return run_filesystem_walk (retbuff, buff, index);
  else if (atom_equals (fun, "fill"))
    return run_fill (retbuff, buff, index);
  else if (atom_equals (fun, "fill_dir"))
    return run_fill_dir (retbuff, buff, index);
  else if (atom_equals (fun, "fill_pattern"))
    return run_fill_pattern (retbuff, buff, index);
  else if (atom_equals (fun, "find"))
    return run_find (retbuff, buff, index);
  else if (atom_equals (fun, "find0"))
    return run_find0 (retbuff, buff, index);
  else if (atom_equals (fun, "find_inode"))
    return run_find_inode (retbuff, buff, index);
  else if (atom_equals (fun, "findfs_label"))
    return run_findfs_label (retbuff, buff, index);
  else if (atom_equals (fun, "findfs_partlabel"))
    return run_findfs_partlabel (retbuff, buff, index);
  else if (atom_equals (fun, "findfs_partuuid"))
    return run_findfs_partuuid (retbuff, buff, index);
  else if (atom_equals (fun, "findfs_uuid"))
    return run_findfs_uuid (retbuff, buff, index);
  else if (atom_equals (fun, "fsck"))
    return run_fsck (retbuff, buff, index);
  else if (atom_equals (fun, "fstrim"))
    return run_fstrim (retbuff, buff, index);
  else if (atom_equals (fun, "get_append"))
    return run_get_append (retbuff, buff, index);
  else if (atom_equals (fun, "get_attach_method"))
    return run_get_attach_method (retbuff, buff, index);
  else if (atom_equals (fun, "get_autosync"))
    return run_get_autosync (retbuff, buff, index);
  else if (atom_equals (fun, "get_backend"))
    return run_get_backend (retbuff, buff, index);
  else if (atom_equals (fun, "get_backend_setting"))
    return run_get_backend_setting (retbuff, buff, index);
  else if (atom_equals (fun, "get_backend_settings"))
    return run_get_backend_settings (retbuff, buff, index);
  else if (atom_equals (fun, "get_cachedir"))
    return run_get_cachedir (retbuff, buff, index);
  else if (atom_equals (fun, "get_direct"))
    return run_get_direct (retbuff, buff, index);
  else if (atom_equals (fun, "get_e2attrs"))
    return run_get_e2attrs (retbuff, buff, index);
  else if (atom_equals (fun, "get_e2generation"))
    return run_get_e2generation (retbuff, buff, index);
  else if (atom_equals (fun, "get_e2label"))
    return run_get_e2label (retbuff, buff, index);
  else if (atom_equals (fun, "get_e2uuid"))
    return run_get_e2uuid (retbuff, buff, index);
  else if (atom_equals (fun, "get_hv"))
    return run_get_hv (retbuff, buff, index);
  else if (atom_equals (fun, "get_identifier"))
    return run_get_identifier (retbuff, buff, index);
  else if (atom_equals (fun, "get_libvirt_requested_credential_challenge"))
    return run_get_libvirt_requested_credential_challenge (retbuff, buff, index);
  else if (atom_equals (fun, "get_libvirt_requested_credential_defresult"))
    return run_get_libvirt_requested_credential_defresult (retbuff, buff, index);
  else if (atom_equals (fun, "get_libvirt_requested_credential_prompt"))
    return run_get_libvirt_requested_credential_prompt (retbuff, buff, index);
  else if (atom_equals (fun, "get_libvirt_requested_credentials"))
    return run_get_libvirt_requested_credentials (retbuff, buff, index);
  else if (atom_equals (fun, "get_memsize"))
    return run_get_memsize (retbuff, buff, index);
  else if (atom_equals (fun, "get_network"))
    return run_get_network (retbuff, buff, index);
  else if (atom_equals (fun, "get_path"))
    return run_get_path (retbuff, buff, index);
  else if (atom_equals (fun, "get_pgroup"))
    return run_get_pgroup (retbuff, buff, index);
  else if (atom_equals (fun, "get_pid"))
    return run_get_pid (retbuff, buff, index);
  else if (atom_equals (fun, "get_program"))
    return run_get_program (retbuff, buff, index);
  else if (atom_equals (fun, "get_qemu"))
    return run_get_qemu (retbuff, buff, index);
  else if (atom_equals (fun, "get_recovery_proc"))
    return run_get_recovery_proc (retbuff, buff, index);
  else if (atom_equals (fun, "get_selinux"))
    return run_get_selinux (retbuff, buff, index);
  else if (atom_equals (fun, "get_smp"))
    return run_get_smp (retbuff, buff, index);
  else if (atom_equals (fun, "get_sockdir"))
    return run_get_sockdir (retbuff, buff, index);
  else if (atom_equals (fun, "get_state"))
    return run_get_state (retbuff, buff, index);
  else if (atom_equals (fun, "get_tmpdir"))
    return run_get_tmpdir (retbuff, buff, index);
  else if (atom_equals (fun, "get_trace"))
    return run_get_trace (retbuff, buff, index);
  else if (atom_equals (fun, "get_umask"))
    return run_get_umask (retbuff, buff, index);
  else if (atom_equals (fun, "get_verbose"))
    return run_get_verbose (retbuff, buff, index);
  else if (atom_equals (fun, "getcon"))
    return run_getcon (retbuff, buff, index);
  else if (atom_equals (fun, "getxattr"))
    return run_getxattr (retbuff, buff, index);
  else if (atom_equals (fun, "getxattrs"))
    return run_getxattrs (retbuff, buff, index);
  else if (atom_equals (fun, "glob_expand"))
    return run_glob_expand (retbuff, buff, index);
  else if (atom_equals (fun, "grep"))
    return run_grep (retbuff, buff, index);
  else if (atom_equals (fun, "grepi"))
    return run_grepi (retbuff, buff, index);
  else if (atom_equals (fun, "grub_install"))
    return run_grub_install (retbuff, buff, index);
  else if (atom_equals (fun, "head"))
    return run_head (retbuff, buff, index);
  else if (atom_equals (fun, "head_n"))
    return run_head_n (retbuff, buff, index);
  else if (atom_equals (fun, "hexdump"))
    return run_hexdump (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_close"))
    return run_hivex_close (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_commit"))
    return run_hivex_commit (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_node_add_child"))
    return run_hivex_node_add_child (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_node_children"))
    return run_hivex_node_children (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_node_delete_child"))
    return run_hivex_node_delete_child (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_node_get_child"))
    return run_hivex_node_get_child (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_node_get_value"))
    return run_hivex_node_get_value (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_node_name"))
    return run_hivex_node_name (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_node_parent"))
    return run_hivex_node_parent (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_node_set_value"))
    return run_hivex_node_set_value (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_node_values"))
    return run_hivex_node_values (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_open"))
    return run_hivex_open (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_root"))
    return run_hivex_root (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_value_key"))
    return run_hivex_value_key (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_value_string"))
    return run_hivex_value_string (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_value_type"))
    return run_hivex_value_type (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_value_utf8"))
    return run_hivex_value_utf8 (retbuff, buff, index);
  else if (atom_equals (fun, "hivex_value_value"))
    return run_hivex_value_value (retbuff, buff, index);
  else if (atom_equals (fun, "initrd_cat"))
    return run_initrd_cat (retbuff, buff, index);
  else if (atom_equals (fun, "initrd_list"))
    return run_initrd_list (retbuff, buff, index);
  else if (atom_equals (fun, "inotify_add_watch"))
    return run_inotify_add_watch (retbuff, buff, index);
  else if (atom_equals (fun, "inotify_close"))
    return run_inotify_close (retbuff, buff, index);
  else if (atom_equals (fun, "inotify_files"))
    return run_inotify_files (retbuff, buff, index);
  else if (atom_equals (fun, "inotify_init"))
    return run_inotify_init (retbuff, buff, index);
  else if (atom_equals (fun, "inotify_read"))
    return run_inotify_read (retbuff, buff, index);
  else if (atom_equals (fun, "inotify_rm_watch"))
    return run_inotify_rm_watch (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_arch"))
    return run_inspect_get_arch (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_build_id"))
    return run_inspect_get_build_id (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_distro"))
    return run_inspect_get_distro (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_drive_mappings"))
    return run_inspect_get_drive_mappings (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_filesystems"))
    return run_inspect_get_filesystems (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_format"))
    return run_inspect_get_format (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_hostname"))
    return run_inspect_get_hostname (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_icon"))
    return run_inspect_get_icon (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_major_version"))
    return run_inspect_get_major_version (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_minor_version"))
    return run_inspect_get_minor_version (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_mountpoints"))
    return run_inspect_get_mountpoints (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_osinfo"))
    return run_inspect_get_osinfo (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_package_format"))
    return run_inspect_get_package_format (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_package_management"))
    return run_inspect_get_package_management (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_product_name"))
    return run_inspect_get_product_name (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_product_variant"))
    return run_inspect_get_product_variant (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_roots"))
    return run_inspect_get_roots (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_type"))
    return run_inspect_get_type (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_windows_current_control_set"))
    return run_inspect_get_windows_current_control_set (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_windows_software_hive"))
    return run_inspect_get_windows_software_hive (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_windows_system_hive"))
    return run_inspect_get_windows_system_hive (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_get_windows_systemroot"))
    return run_inspect_get_windows_systemroot (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_is_live"))
    return run_inspect_is_live (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_is_multipart"))
    return run_inspect_is_multipart (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_is_netinst"))
    return run_inspect_is_netinst (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_list_applications"))
    return run_inspect_list_applications (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_list_applications2"))
    return run_inspect_list_applications2 (retbuff, buff, index);
  else if (atom_equals (fun, "inspect_os"))
    return run_inspect_os (retbuff, buff, index);
  else if (atom_equals (fun, "internal_exit"))
    return run_internal_exit (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test"))
    return run_internal_test (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_63_optargs"))
    return run_internal_test_63_optargs (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_close_output"))
    return run_internal_test_close_output (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_only_optargs"))
    return run_internal_test_only_optargs (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rbool"))
    return run_internal_test_rbool (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rboolerr"))
    return run_internal_test_rboolerr (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rbufferout"))
    return run_internal_test_rbufferout (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rbufferouterr"))
    return run_internal_test_rbufferouterr (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rconstoptstring"))
    return run_internal_test_rconstoptstring (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rconstoptstringerr"))
    return run_internal_test_rconstoptstringerr (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rconststring"))
    return run_internal_test_rconststring (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rconststringerr"))
    return run_internal_test_rconststringerr (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rhashtable"))
    return run_internal_test_rhashtable (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rhashtableerr"))
    return run_internal_test_rhashtableerr (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rint"))
    return run_internal_test_rint (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rint64"))
    return run_internal_test_rint64 (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rint64err"))
    return run_internal_test_rint64err (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rinterr"))
    return run_internal_test_rinterr (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rstring"))
    return run_internal_test_rstring (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rstringerr"))
    return run_internal_test_rstringerr (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rstringlist"))
    return run_internal_test_rstringlist (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rstringlisterr"))
    return run_internal_test_rstringlisterr (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rstruct"))
    return run_internal_test_rstruct (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rstructerr"))
    return run_internal_test_rstructerr (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rstructlist"))
    return run_internal_test_rstructlist (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_rstructlisterr"))
    return run_internal_test_rstructlisterr (retbuff, buff, index);
  else if (atom_equals (fun, "internal_test_set_output"))
    return run_internal_test_set_output (retbuff, buff, index);
  else if (atom_equals (fun, "is_blockdev"))
    return run_is_blockdev (retbuff, buff, index);
  else if (atom_equals (fun, "is_busy"))
    return run_is_busy (retbuff, buff, index);
  else if (atom_equals (fun, "is_chardev"))
    return run_is_chardev (retbuff, buff, index);
  else if (atom_equals (fun, "is_config"))
    return run_is_config (retbuff, buff, index);
  else if (atom_equals (fun, "is_dir"))
    return run_is_dir (retbuff, buff, index);
  else if (atom_equals (fun, "is_fifo"))
    return run_is_fifo (retbuff, buff, index);
  else if (atom_equals (fun, "is_file"))
    return run_is_file (retbuff, buff, index);
  else if (atom_equals (fun, "is_launching"))
    return run_is_launching (retbuff, buff, index);
  else if (atom_equals (fun, "is_lv"))
    return run_is_lv (retbuff, buff, index);
  else if (atom_equals (fun, "is_ready"))
    return run_is_ready (retbuff, buff, index);
  else if (atom_equals (fun, "is_socket"))
    return run_is_socket (retbuff, buff, index);
  else if (atom_equals (fun, "is_symlink"))
    return run_is_symlink (retbuff, buff, index);
  else if (atom_equals (fun, "is_whole_device"))
    return run_is_whole_device (retbuff, buff, index);
  else if (atom_equals (fun, "is_zero"))
    return run_is_zero (retbuff, buff, index);
  else if (atom_equals (fun, "is_zero_device"))
    return run_is_zero_device (retbuff, buff, index);
  else if (atom_equals (fun, "isoinfo"))
    return run_isoinfo (retbuff, buff, index);
  else if (atom_equals (fun, "isoinfo_device"))
    return run_isoinfo_device (retbuff, buff, index);
  else if (atom_equals (fun, "journal_close"))
    return run_journal_close (retbuff, buff, index);
  else if (atom_equals (fun, "journal_get"))
    return run_journal_get (retbuff, buff, index);
  else if (atom_equals (fun, "journal_get_data_threshold"))
    return run_journal_get_data_threshold (retbuff, buff, index);
  else if (atom_equals (fun, "journal_get_realtime_usec"))
    return run_journal_get_realtime_usec (retbuff, buff, index);
  else if (atom_equals (fun, "journal_next"))
    return run_journal_next (retbuff, buff, index);
  else if (atom_equals (fun, "journal_open"))
    return run_journal_open (retbuff, buff, index);
  else if (atom_equals (fun, "journal_set_data_threshold"))
    return run_journal_set_data_threshold (retbuff, buff, index);
  else if (atom_equals (fun, "journal_skip"))
    return run_journal_skip (retbuff, buff, index);
  else if (atom_equals (fun, "kill_subprocess"))
    return run_kill_subprocess (retbuff, buff, index);
  else if (atom_equals (fun, "launch"))
    return run_launch (retbuff, buff, index);
  else if (atom_equals (fun, "lchown"))
    return run_lchown (retbuff, buff, index);
  else if (atom_equals (fun, "ldmtool_create_all"))
    return run_ldmtool_create_all (retbuff, buff, index);
  else if (atom_equals (fun, "ldmtool_diskgroup_disks"))
    return run_ldmtool_diskgroup_disks (retbuff, buff, index);
  else if (atom_equals (fun, "ldmtool_diskgroup_name"))
    return run_ldmtool_diskgroup_name (retbuff, buff, index);
  else if (atom_equals (fun, "ldmtool_diskgroup_volumes"))
    return run_ldmtool_diskgroup_volumes (retbuff, buff, index);
  else if (atom_equals (fun, "ldmtool_remove_all"))
    return run_ldmtool_remove_all (retbuff, buff, index);
  else if (atom_equals (fun, "ldmtool_scan"))
    return run_ldmtool_scan (retbuff, buff, index);
  else if (atom_equals (fun, "ldmtool_scan_devices"))
    return run_ldmtool_scan_devices (retbuff, buff, index);
  else if (atom_equals (fun, "ldmtool_volume_hint"))
    return run_ldmtool_volume_hint (retbuff, buff, index);
  else if (atom_equals (fun, "ldmtool_volume_partitions"))
    return run_ldmtool_volume_partitions (retbuff, buff, index);
  else if (atom_equals (fun, "ldmtool_volume_type"))
    return run_ldmtool_volume_type (retbuff, buff, index);
  else if (atom_equals (fun, "lgetxattr"))
    return run_lgetxattr (retbuff, buff, index);
  else if (atom_equals (fun, "lgetxattrs"))
    return run_lgetxattrs (retbuff, buff, index);
  else if (atom_equals (fun, "list_9p"))
    return run_list_9p (retbuff, buff, index);
  else if (atom_equals (fun, "list_devices"))
    return run_list_devices (retbuff, buff, index);
  else if (atom_equals (fun, "list_disk_labels"))
    return run_list_disk_labels (retbuff, buff, index);
  else if (atom_equals (fun, "list_dm_devices"))
    return run_list_dm_devices (retbuff, buff, index);
  else if (atom_equals (fun, "list_filesystems"))
    return run_list_filesystems (retbuff, buff, index);
  else if (atom_equals (fun, "list_ldm_partitions"))
    return run_list_ldm_partitions (retbuff, buff, index);
  else if (atom_equals (fun, "list_ldm_volumes"))
    return run_list_ldm_volumes (retbuff, buff, index);
  else if (atom_equals (fun, "list_md_devices"))
    return run_list_md_devices (retbuff, buff, index);
  else if (atom_equals (fun, "list_partitions"))
    return run_list_partitions (retbuff, buff, index);
  else if (atom_equals (fun, "ll"))
    return run_ll (retbuff, buff, index);
  else if (atom_equals (fun, "llz"))
    return run_llz (retbuff, buff, index);
  else if (atom_equals (fun, "ln"))
    return run_ln (retbuff, buff, index);
  else if (atom_equals (fun, "ln_f"))
    return run_ln_f (retbuff, buff, index);
  else if (atom_equals (fun, "ln_s"))
    return run_ln_s (retbuff, buff, index);
  else if (atom_equals (fun, "ln_sf"))
    return run_ln_sf (retbuff, buff, index);
  else if (atom_equals (fun, "lremovexattr"))
    return run_lremovexattr (retbuff, buff, index);
  else if (atom_equals (fun, "ls"))
    return run_ls (retbuff, buff, index);
  else if (atom_equals (fun, "ls0"))
    return run_ls0 (retbuff, buff, index);
  else if (atom_equals (fun, "lsetxattr"))
    return run_lsetxattr (retbuff, buff, index);
  else if (atom_equals (fun, "lstat"))
    return run_lstat (retbuff, buff, index);
  else if (atom_equals (fun, "lstatlist"))
    return run_lstatlist (retbuff, buff, index);
  else if (atom_equals (fun, "lstatns"))
    return run_lstatns (retbuff, buff, index);
  else if (atom_equals (fun, "lstatnslist"))
    return run_lstatnslist (retbuff, buff, index);
  else if (atom_equals (fun, "luks_add_key"))
    return run_luks_add_key (retbuff, buff, index);
  else if (atom_equals (fun, "luks_close"))
    return run_luks_close (retbuff, buff, index);
  else if (atom_equals (fun, "luks_format"))
    return run_luks_format (retbuff, buff, index);
  else if (atom_equals (fun, "luks_format_cipher"))
    return run_luks_format_cipher (retbuff, buff, index);
  else if (atom_equals (fun, "luks_kill_slot"))
    return run_luks_kill_slot (retbuff, buff, index);
  else if (atom_equals (fun, "luks_open"))
    return run_luks_open (retbuff, buff, index);
  else if (atom_equals (fun, "luks_open_ro"))
    return run_luks_open_ro (retbuff, buff, index);
  else if (atom_equals (fun, "luks_uuid"))
    return run_luks_uuid (retbuff, buff, index);
  else if (atom_equals (fun, "lvcreate"))
    return run_lvcreate (retbuff, buff, index);
  else if (atom_equals (fun, "lvcreate_free"))
    return run_lvcreate_free (retbuff, buff, index);
  else if (atom_equals (fun, "lvm_canonical_lv_name"))
    return run_lvm_canonical_lv_name (retbuff, buff, index);
  else if (atom_equals (fun, "lvm_clear_filter"))
    return run_lvm_clear_filter (retbuff, buff, index);
  else if (atom_equals (fun, "lvm_remove_all"))
    return run_lvm_remove_all (retbuff, buff, index);
  else if (atom_equals (fun, "lvm_scan"))
    return run_lvm_scan (retbuff, buff, index);
  else if (atom_equals (fun, "lvm_set_filter"))
    return run_lvm_set_filter (retbuff, buff, index);
  else if (atom_equals (fun, "lvremove"))
    return run_lvremove (retbuff, buff, index);
  else if (atom_equals (fun, "lvrename"))
    return run_lvrename (retbuff, buff, index);
  else if (atom_equals (fun, "lvresize"))
    return run_lvresize (retbuff, buff, index);
  else if (atom_equals (fun, "lvresize_free"))
    return run_lvresize_free (retbuff, buff, index);
  else if (atom_equals (fun, "lvs"))
    return run_lvs (retbuff, buff, index);
  else if (atom_equals (fun, "lvs_full"))
    return run_lvs_full (retbuff, buff, index);
  else if (atom_equals (fun, "lvuuid"))
    return run_lvuuid (retbuff, buff, index);
  else if (atom_equals (fun, "lxattrlist"))
    return run_lxattrlist (retbuff, buff, index);
  else if (atom_equals (fun, "max_disks"))
    return run_max_disks (retbuff, buff, index);
  else if (atom_equals (fun, "md_create"))
    return run_md_create (retbuff, buff, index);
  else if (atom_equals (fun, "md_detail"))
    return run_md_detail (retbuff, buff, index);
  else if (atom_equals (fun, "md_stat"))
    return run_md_stat (retbuff, buff, index);
  else if (atom_equals (fun, "md_stop"))
    return run_md_stop (retbuff, buff, index);
  else if (atom_equals (fun, "mkdir"))
    return run_mkdir (retbuff, buff, index);
  else if (atom_equals (fun, "mkdir_mode"))
    return run_mkdir_mode (retbuff, buff, index);
  else if (atom_equals (fun, "mkdir_p"))
    return run_mkdir_p (retbuff, buff, index);
  else if (atom_equals (fun, "mkdtemp"))
    return run_mkdtemp (retbuff, buff, index);
  else if (atom_equals (fun, "mke2fs"))
    return run_mke2fs (retbuff, buff, index);
  else if (atom_equals (fun, "mke2fs_J"))
    return run_mke2fs_J (retbuff, buff, index);
  else if (atom_equals (fun, "mke2fs_JL"))
    return run_mke2fs_JL (retbuff, buff, index);
  else if (atom_equals (fun, "mke2fs_JU"))
    return run_mke2fs_JU (retbuff, buff, index);
  else if (atom_equals (fun, "mke2journal"))
    return run_mke2journal (retbuff, buff, index);
  else if (atom_equals (fun, "mke2journal_L"))
    return run_mke2journal_L (retbuff, buff, index);
  else if (atom_equals (fun, "mke2journal_U"))
    return run_mke2journal_U (retbuff, buff, index);
  else if (atom_equals (fun, "mkfifo"))
    return run_mkfifo (retbuff, buff, index);
  else if (atom_equals (fun, "mkfs"))
    return run_mkfs (retbuff, buff, index);
  else if (atom_equals (fun, "mkfs_b"))
    return run_mkfs_b (retbuff, buff, index);
  else if (atom_equals (fun, "mkfs_btrfs"))
    return run_mkfs_btrfs (retbuff, buff, index);
  else if (atom_equals (fun, "mklost_and_found"))
    return run_mklost_and_found (retbuff, buff, index);
  else if (atom_equals (fun, "mkmountpoint"))
    return run_mkmountpoint (retbuff, buff, index);
  else if (atom_equals (fun, "mknod"))
    return run_mknod (retbuff, buff, index);
  else if (atom_equals (fun, "mknod_b"))
    return run_mknod_b (retbuff, buff, index);
  else if (atom_equals (fun, "mknod_c"))
    return run_mknod_c (retbuff, buff, index);
  else if (atom_equals (fun, "mksquashfs"))
    return run_mksquashfs (retbuff, buff, index);
  else if (atom_equals (fun, "mkswap"))
    return run_mkswap (retbuff, buff, index);
  else if (atom_equals (fun, "mkswap_L"))
    return run_mkswap_L (retbuff, buff, index);
  else if (atom_equals (fun, "mkswap_U"))
    return run_mkswap_U (retbuff, buff, index);
  else if (atom_equals (fun, "mkswap_file"))
    return run_mkswap_file (retbuff, buff, index);
  else if (atom_equals (fun, "mktemp"))
    return run_mktemp (retbuff, buff, index);
  else if (atom_equals (fun, "modprobe"))
    return run_modprobe (retbuff, buff, index);
  else if (atom_equals (fun, "mount"))
    return run_mount (retbuff, buff, index);
  else if (atom_equals (fun, "mount_9p"))
    return run_mount_9p (retbuff, buff, index);
  else if (atom_equals (fun, "mount_local"))
    return run_mount_local (retbuff, buff, index);
  else if (atom_equals (fun, "mount_local_run"))
    return run_mount_local_run (retbuff, buff, index);
  else if (atom_equals (fun, "mount_loop"))
    return run_mount_loop (retbuff, buff, index);
  else if (atom_equals (fun, "mount_options"))
    return run_mount_options (retbuff, buff, index);
  else if (atom_equals (fun, "mount_ro"))
    return run_mount_ro (retbuff, buff, index);
  else if (atom_equals (fun, "mount_vfs"))
    return run_mount_vfs (retbuff, buff, index);
  else if (atom_equals (fun, "mountable_device"))
    return run_mountable_device (retbuff, buff, index);
  else if (atom_equals (fun, "mountable_subvolume"))
    return run_mountable_subvolume (retbuff, buff, index);
  else if (atom_equals (fun, "mountpoints"))
    return run_mountpoints (retbuff, buff, index);
  else if (atom_equals (fun, "mounts"))
    return run_mounts (retbuff, buff, index);
  else if (atom_equals (fun, "mv"))
    return run_mv (retbuff, buff, index);
  else if (atom_equals (fun, "nr_devices"))
    return run_nr_devices (retbuff, buff, index);
  else if (atom_equals (fun, "ntfs_3g_probe"))
    return run_ntfs_3g_probe (retbuff, buff, index);
  else if (atom_equals (fun, "ntfscat_i"))
    return run_ntfscat_i (retbuff, buff, index);
  else if (atom_equals (fun, "ntfsclone_in"))
    return run_ntfsclone_in (retbuff, buff, index);
  else if (atom_equals (fun, "ntfsclone_out"))
    return run_ntfsclone_out (retbuff, buff, index);
  else if (atom_equals (fun, "ntfsfix"))
    return run_ntfsfix (retbuff, buff, index);
  else if (atom_equals (fun, "ntfsresize"))
    return run_ntfsresize (retbuff, buff, index);
  else if (atom_equals (fun, "ntfsresize_size"))
    return run_ntfsresize_size (retbuff, buff, index);
  else if (atom_equals (fun, "parse_environment"))
    return run_parse_environment (retbuff, buff, index);
  else if (atom_equals (fun, "parse_environment_list"))
    return run_parse_environment_list (retbuff, buff, index);
  else if (atom_equals (fun, "part_add"))
    return run_part_add (retbuff, buff, index);
  else if (atom_equals (fun, "part_del"))
    return run_part_del (retbuff, buff, index);
  else if (atom_equals (fun, "part_disk"))
    return run_part_disk (retbuff, buff, index);
  else if (atom_equals (fun, "part_expand_gpt"))
    return run_part_expand_gpt (retbuff, buff, index);
  else if (atom_equals (fun, "part_get_bootable"))
    return run_part_get_bootable (retbuff, buff, index);
  else if (atom_equals (fun, "part_get_disk_guid"))
    return run_part_get_disk_guid (retbuff, buff, index);
  else if (atom_equals (fun, "part_get_gpt_attributes"))
    return run_part_get_gpt_attributes (retbuff, buff, index);
  else if (atom_equals (fun, "part_get_gpt_guid"))
    return run_part_get_gpt_guid (retbuff, buff, index);
  else if (atom_equals (fun, "part_get_gpt_type"))
    return run_part_get_gpt_type (retbuff, buff, index);
  else if (atom_equals (fun, "part_get_mbr_id"))
    return run_part_get_mbr_id (retbuff, buff, index);
  else if (atom_equals (fun, "part_get_mbr_part_type"))
    return run_part_get_mbr_part_type (retbuff, buff, index);
  else if (atom_equals (fun, "part_get_name"))
    return run_part_get_name (retbuff, buff, index);
  else if (atom_equals (fun, "part_get_parttype"))
    return run_part_get_parttype (retbuff, buff, index);
  else if (atom_equals (fun, "part_init"))
    return run_part_init (retbuff, buff, index);
  else if (atom_equals (fun, "part_list"))
    return run_part_list (retbuff, buff, index);
  else if (atom_equals (fun, "part_resize"))
    return run_part_resize (retbuff, buff, index);
  else if (atom_equals (fun, "part_set_bootable"))
    return run_part_set_bootable (retbuff, buff, index);
  else if (atom_equals (fun, "part_set_disk_guid"))
    return run_part_set_disk_guid (retbuff, buff, index);
  else if (atom_equals (fun, "part_set_disk_guid_random"))
    return run_part_set_disk_guid_random (retbuff, buff, index);
  else if (atom_equals (fun, "part_set_gpt_attributes"))
    return run_part_set_gpt_attributes (retbuff, buff, index);
  else if (atom_equals (fun, "part_set_gpt_guid"))
    return run_part_set_gpt_guid (retbuff, buff, index);
  else if (atom_equals (fun, "part_set_gpt_type"))
    return run_part_set_gpt_type (retbuff, buff, index);
  else if (atom_equals (fun, "part_set_mbr_id"))
    return run_part_set_mbr_id (retbuff, buff, index);
  else if (atom_equals (fun, "part_set_name"))
    return run_part_set_name (retbuff, buff, index);
  else if (atom_equals (fun, "part_to_dev"))
    return run_part_to_dev (retbuff, buff, index);
  else if (atom_equals (fun, "part_to_partnum"))
    return run_part_to_partnum (retbuff, buff, index);
  else if (atom_equals (fun, "ping_daemon"))
    return run_ping_daemon (retbuff, buff, index);
  else if (atom_equals (fun, "pread"))
    return run_pread (retbuff, buff, index);
  else if (atom_equals (fun, "pread_device"))
    return run_pread_device (retbuff, buff, index);
  else if (atom_equals (fun, "pvchange_uuid"))
    return run_pvchange_uuid (retbuff, buff, index);
  else if (atom_equals (fun, "pvchange_uuid_all"))
    return run_pvchange_uuid_all (retbuff, buff, index);
  else if (atom_equals (fun, "pvcreate"))
    return run_pvcreate (retbuff, buff, index);
  else if (atom_equals (fun, "pvremove"))
    return run_pvremove (retbuff, buff, index);
  else if (atom_equals (fun, "pvresize"))
    return run_pvresize (retbuff, buff, index);
  else if (atom_equals (fun, "pvresize_size"))
    return run_pvresize_size (retbuff, buff, index);
  else if (atom_equals (fun, "pvs"))
    return run_pvs (retbuff, buff, index);
  else if (atom_equals (fun, "pvs_full"))
    return run_pvs_full (retbuff, buff, index);
  else if (atom_equals (fun, "pvuuid"))
    return run_pvuuid (retbuff, buff, index);
  else if (atom_equals (fun, "pwrite"))
    return run_pwrite (retbuff, buff, index);
  else if (atom_equals (fun, "pwrite_device"))
    return run_pwrite_device (retbuff, buff, index);
  else if (atom_equals (fun, "read_file"))
    return run_read_file (retbuff, buff, index);
  else if (atom_equals (fun, "read_lines"))
    return run_read_lines (retbuff, buff, index);
  else if (atom_equals (fun, "readdir"))
    return run_readdir (retbuff, buff, index);
  else if (atom_equals (fun, "readlink"))
    return run_readlink (retbuff, buff, index);
  else if (atom_equals (fun, "readlinklist"))
    return run_readlinklist (retbuff, buff, index);
  else if (atom_equals (fun, "realpath"))
    return run_realpath (retbuff, buff, index);
  else if (atom_equals (fun, "remount"))
    return run_remount (retbuff, buff, index);
  else if (atom_equals (fun, "remove_drive"))
    return run_remove_drive (retbuff, buff, index);
  else if (atom_equals (fun, "removexattr"))
    return run_removexattr (retbuff, buff, index);
  else if (atom_equals (fun, "rename"))
    return run_rename (retbuff, buff, index);
  else if (atom_equals (fun, "resize2fs"))
    return run_resize2fs (retbuff, buff, index);
  else if (atom_equals (fun, "resize2fs_M"))
    return run_resize2fs_M (retbuff, buff, index);
  else if (atom_equals (fun, "resize2fs_size"))
    return run_resize2fs_size (retbuff, buff, index);
  else if (atom_equals (fun, "rm"))
    return run_rm (retbuff, buff, index);
  else if (atom_equals (fun, "rm_f"))
    return run_rm_f (retbuff, buff, index);
  else if (atom_equals (fun, "rm_rf"))
    return run_rm_rf (retbuff, buff, index);
  else if (atom_equals (fun, "rmdir"))
    return run_rmdir (retbuff, buff, index);
  else if (atom_equals (fun, "rmmountpoint"))
    return run_rmmountpoint (retbuff, buff, index);
  else if (atom_equals (fun, "rsync"))
    return run_rsync (retbuff, buff, index);
  else if (atom_equals (fun, "rsync_in"))
    return run_rsync_in (retbuff, buff, index);
  else if (atom_equals (fun, "rsync_out"))
    return run_rsync_out (retbuff, buff, index);
  else if (atom_equals (fun, "scrub_device"))
    return run_scrub_device (retbuff, buff, index);
  else if (atom_equals (fun, "scrub_file"))
    return run_scrub_file (retbuff, buff, index);
  else if (atom_equals (fun, "scrub_freespace"))
    return run_scrub_freespace (retbuff, buff, index);
  else if (atom_equals (fun, "selinux_relabel"))
    return run_selinux_relabel (retbuff, buff, index);
  else if (atom_equals (fun, "set_append"))
    return run_set_append (retbuff, buff, index);
  else if (atom_equals (fun, "set_attach_method"))
    return run_set_attach_method (retbuff, buff, index);
  else if (atom_equals (fun, "set_autosync"))
    return run_set_autosync (retbuff, buff, index);
  else if (atom_equals (fun, "set_backend"))
    return run_set_backend (retbuff, buff, index);
  else if (atom_equals (fun, "set_backend_setting"))
    return run_set_backend_setting (retbuff, buff, index);
  else if (atom_equals (fun, "set_backend_settings"))
    return run_set_backend_settings (retbuff, buff, index);
  else if (atom_equals (fun, "set_cachedir"))
    return run_set_cachedir (retbuff, buff, index);
  else if (atom_equals (fun, "set_direct"))
    return run_set_direct (retbuff, buff, index);
  else if (atom_equals (fun, "set_e2attrs"))
    return run_set_e2attrs (retbuff, buff, index);
  else if (atom_equals (fun, "set_e2generation"))
    return run_set_e2generation (retbuff, buff, index);
  else if (atom_equals (fun, "set_e2label"))
    return run_set_e2label (retbuff, buff, index);
  else if (atom_equals (fun, "set_e2uuid"))
    return run_set_e2uuid (retbuff, buff, index);
  else if (atom_equals (fun, "set_hv"))
    return run_set_hv (retbuff, buff, index);
  else if (atom_equals (fun, "set_identifier"))
    return run_set_identifier (retbuff, buff, index);
  else if (atom_equals (fun, "set_label"))
    return run_set_label (retbuff, buff, index);
  else if (atom_equals (fun, "set_libvirt_requested_credential"))
    return run_set_libvirt_requested_credential (retbuff, buff, index);
  else if (atom_equals (fun, "set_libvirt_supported_credentials"))
    return run_set_libvirt_supported_credentials (retbuff, buff, index);
  else if (atom_equals (fun, "set_memsize"))
    return run_set_memsize (retbuff, buff, index);
  else if (atom_equals (fun, "set_network"))
    return run_set_network (retbuff, buff, index);
  else if (atom_equals (fun, "set_path"))
    return run_set_path (retbuff, buff, index);
  else if (atom_equals (fun, "set_pgroup"))
    return run_set_pgroup (retbuff, buff, index);
  else if (atom_equals (fun, "set_program"))
    return run_set_program (retbuff, buff, index);
  else if (atom_equals (fun, "set_qemu"))
    return run_set_qemu (retbuff, buff, index);
  else if (atom_equals (fun, "set_recovery_proc"))
    return run_set_recovery_proc (retbuff, buff, index);
  else if (atom_equals (fun, "set_selinux"))
    return run_set_selinux (retbuff, buff, index);
  else if (atom_equals (fun, "set_smp"))
    return run_set_smp (retbuff, buff, index);
  else if (atom_equals (fun, "set_tmpdir"))
    return run_set_tmpdir (retbuff, buff, index);
  else if (atom_equals (fun, "set_trace"))
    return run_set_trace (retbuff, buff, index);
  else if (atom_equals (fun, "set_uuid"))
    return run_set_uuid (retbuff, buff, index);
  else if (atom_equals (fun, "set_uuid_random"))
    return run_set_uuid_random (retbuff, buff, index);
  else if (atom_equals (fun, "set_verbose"))
    return run_set_verbose (retbuff, buff, index);
  else if (atom_equals (fun, "setcon"))
    return run_setcon (retbuff, buff, index);
  else if (atom_equals (fun, "setxattr"))
    return run_setxattr (retbuff, buff, index);
  else if (atom_equals (fun, "sfdisk"))
    return run_sfdisk (retbuff, buff, index);
  else if (atom_equals (fun, "sfdiskM"))
    return run_sfdiskM (retbuff, buff, index);
  else if (atom_equals (fun, "sfdisk_N"))
    return run_sfdisk_N (retbuff, buff, index);
  else if (atom_equals (fun, "sfdisk_disk_geometry"))
    return run_sfdisk_disk_geometry (retbuff, buff, index);
  else if (atom_equals (fun, "sfdisk_kernel_geometry"))
    return run_sfdisk_kernel_geometry (retbuff, buff, index);
  else if (atom_equals (fun, "sfdisk_l"))
    return run_sfdisk_l (retbuff, buff, index);
  else if (atom_equals (fun, "sh"))
    return run_sh (retbuff, buff, index);
  else if (atom_equals (fun, "sh_lines"))
    return run_sh_lines (retbuff, buff, index);
  else if (atom_equals (fun, "sh_out"))
    return run_sh_out (retbuff, buff, index);
  else if (atom_equals (fun, "shutdown"))
    return run_shutdown (retbuff, buff, index);
  else if (atom_equals (fun, "sleep"))
    return run_sleep (retbuff, buff, index);
  else if (atom_equals (fun, "stat"))
    return run_stat (retbuff, buff, index);
  else if (atom_equals (fun, "statns"))
    return run_statns (retbuff, buff, index);
  else if (atom_equals (fun, "statvfs"))
    return run_statvfs (retbuff, buff, index);
  else if (atom_equals (fun, "strings"))
    return run_strings (retbuff, buff, index);
  else if (atom_equals (fun, "strings_e"))
    return run_strings_e (retbuff, buff, index);
  else if (atom_equals (fun, "swapoff_device"))
    return run_swapoff_device (retbuff, buff, index);
  else if (atom_equals (fun, "swapoff_file"))
    return run_swapoff_file (retbuff, buff, index);
  else if (atom_equals (fun, "swapoff_label"))
    return run_swapoff_label (retbuff, buff, index);
  else if (atom_equals (fun, "swapoff_uuid"))
    return run_swapoff_uuid (retbuff, buff, index);
  else if (atom_equals (fun, "swapon_device"))
    return run_swapon_device (retbuff, buff, index);
  else if (atom_equals (fun, "swapon_file"))
    return run_swapon_file (retbuff, buff, index);
  else if (atom_equals (fun, "swapon_label"))
    return run_swapon_label (retbuff, buff, index);
  else if (atom_equals (fun, "swapon_uuid"))
    return run_swapon_uuid (retbuff, buff, index);
  else if (atom_equals (fun, "sync"))
    return run_sync (retbuff, buff, index);
  else if (atom_equals (fun, "syslinux"))
    return run_syslinux (retbuff, buff, index);
  else if (atom_equals (fun, "tail"))
    return run_tail (retbuff, buff, index);
  else if (atom_equals (fun, "tail_n"))
    return run_tail_n (retbuff, buff, index);
  else if (atom_equals (fun, "tar_in"))
    return run_tar_in (retbuff, buff, index);
  else if (atom_equals (fun, "tar_out"))
    return run_tar_out (retbuff, buff, index);
  else if (atom_equals (fun, "tgz_in"))
    return run_tgz_in (retbuff, buff, index);
  else if (atom_equals (fun, "tgz_out"))
    return run_tgz_out (retbuff, buff, index);
  else if (atom_equals (fun, "touch"))
    return run_touch (retbuff, buff, index);
  else if (atom_equals (fun, "truncate"))
    return run_truncate (retbuff, buff, index);
  else if (atom_equals (fun, "truncate_size"))
    return run_truncate_size (retbuff, buff, index);
  else if (atom_equals (fun, "tune2fs"))
    return run_tune2fs (retbuff, buff, index);
  else if (atom_equals (fun, "tune2fs_l"))
    return run_tune2fs_l (retbuff, buff, index);
  else if (atom_equals (fun, "txz_in"))
    return run_txz_in (retbuff, buff, index);
  else if (atom_equals (fun, "txz_out"))
    return run_txz_out (retbuff, buff, index);
  else if (atom_equals (fun, "umask"))
    return run_umask (retbuff, buff, index);
  else if (atom_equals (fun, "umount"))
    return run_umount (retbuff, buff, index);
  else if (atom_equals (fun, "umount_all"))
    return run_umount_all (retbuff, buff, index);
  else if (atom_equals (fun, "umount_local"))
    return run_umount_local (retbuff, buff, index);
  else if (atom_equals (fun, "upload"))
    return run_upload (retbuff, buff, index);
  else if (atom_equals (fun, "upload_offset"))
    return run_upload_offset (retbuff, buff, index);
  else if (atom_equals (fun, "user_cancel"))
    return run_user_cancel (retbuff, buff, index);
  else if (atom_equals (fun, "utimens"))
    return run_utimens (retbuff, buff, index);
  else if (atom_equals (fun, "utsname"))
    return run_utsname (retbuff, buff, index);
  else if (atom_equals (fun, "version"))
    return run_version (retbuff, buff, index);
  else if (atom_equals (fun, "vfs_label"))
    return run_vfs_label (retbuff, buff, index);
  else if (atom_equals (fun, "vfs_minimum_size"))
    return run_vfs_minimum_size (retbuff, buff, index);
  else if (atom_equals (fun, "vfs_type"))
    return run_vfs_type (retbuff, buff, index);
  else if (atom_equals (fun, "vfs_uuid"))
    return run_vfs_uuid (retbuff, buff, index);
  else if (atom_equals (fun, "vg_activate"))
    return run_vg_activate (retbuff, buff, index);
  else if (atom_equals (fun, "vg_activate_all"))
    return run_vg_activate_all (retbuff, buff, index);
  else if (atom_equals (fun, "vgchange_uuid"))
    return run_vgchange_uuid (retbuff, buff, index);
  else if (atom_equals (fun, "vgchange_uuid_all"))
    return run_vgchange_uuid_all (retbuff, buff, index);
  else if (atom_equals (fun, "vgcreate"))
    return run_vgcreate (retbuff, buff, index);
  else if (atom_equals (fun, "vglvuuids"))
    return run_vglvuuids (retbuff, buff, index);
  else if (atom_equals (fun, "vgmeta"))
    return run_vgmeta (retbuff, buff, index);
  else if (atom_equals (fun, "vgpvuuids"))
    return run_vgpvuuids (retbuff, buff, index);
  else if (atom_equals (fun, "vgremove"))
    return run_vgremove (retbuff, buff, index);
  else if (atom_equals (fun, "vgrename"))
    return run_vgrename (retbuff, buff, index);
  else if (atom_equals (fun, "vgs"))
    return run_vgs (retbuff, buff, index);
  else if (atom_equals (fun, "vgs_full"))
    return run_vgs_full (retbuff, buff, index);
  else if (atom_equals (fun, "vgscan"))
    return run_vgscan (retbuff, buff, index);
  else if (atom_equals (fun, "vguuid"))
    return run_vguuid (retbuff, buff, index);
  else if (atom_equals (fun, "wait_ready"))
    return run_wait_ready (retbuff, buff, index);
  else if (atom_equals (fun, "wc_c"))
    return run_wc_c (retbuff, buff, index);
  else if (atom_equals (fun, "wc_l"))
    return run_wc_l (retbuff, buff, index);
  else if (atom_equals (fun, "wc_w"))
    return run_wc_w (retbuff, buff, index);
  else if (atom_equals (fun, "wipefs"))
    return run_wipefs (retbuff, buff, index);
  else if (atom_equals (fun, "write"))
    return run_write (retbuff, buff, index);
  else if (atom_equals (fun, "write_append"))
    return run_write_append (retbuff, buff, index);
  else if (atom_equals (fun, "write_file"))
    return run_write_file (retbuff, buff, index);
  else if (atom_equals (fun, "xfs_admin"))
    return run_xfs_admin (retbuff, buff, index);
  else if (atom_equals (fun, "xfs_growfs"))
    return run_xfs_growfs (retbuff, buff, index);
  else if (atom_equals (fun, "xfs_info"))
    return run_xfs_info (retbuff, buff, index);
  else if (atom_equals (fun, "xfs_repair"))
    return run_xfs_repair (retbuff, buff, index);
  else if (atom_equals (fun, "yara_destroy"))
    return run_yara_destroy (retbuff, buff, index);
  else if (atom_equals (fun, "yara_load"))
    return run_yara_load (retbuff, buff, index);
  else if (atom_equals (fun, "yara_scan"))
    return run_yara_scan (retbuff, buff, index);
  else if (atom_equals (fun, "zegrep"))
    return run_zegrep (retbuff, buff, index);
  else if (atom_equals (fun, "zegrepi"))
    return run_zegrepi (retbuff, buff, index);
  else if (atom_equals (fun, "zero"))
    return run_zero (retbuff, buff, index);
  else if (atom_equals (fun, "zero_device"))
    return run_zero_device (retbuff, buff, index);
  else if (atom_equals (fun, "zero_free_space"))
    return run_zero_free_space (retbuff, buff, index);
  else if (atom_equals (fun, "zerofree"))
    return run_zerofree (retbuff, buff, index);
  else if (atom_equals (fun, "zfgrep"))
    return run_zfgrep (retbuff, buff, index);
  else if (atom_equals (fun, "zfgrepi"))
    return run_zfgrepi (retbuff, buff, index);
  else if (atom_equals (fun, "zfile"))
    return run_zfile (retbuff, buff, index);
  else if (atom_equals (fun, "zgrep"))
    return run_zgrep (retbuff, buff, index);
  else if (atom_equals (fun, "zgrepi"))
    return run_zgrepi (retbuff, buff, index);
  else return unknown_function (retbuff, fun);
}
