/* Generated by wayland-scanner 1.24.0 */

#ifndef REMOTE_ACCESS_SERVER_PROTOCOL_H
#define REMOTE_ACCESS_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_remote_access The remote_access protocol
 * @section page_ifaces_remote_access Interfaces
 * - @subpage page_iface_org_kde_kwin_remote_access_manager - Protocol for managing rendered GBM buffers passing
 * - @subpage page_iface_org_kde_kwin_remote_buffer - This interface allows finer control of remote buffer lifecycle
 * @section page_copyright_remote_access Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2016 Oleg Chernovskiy
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_kwin_remote_access_manager;
struct org_kde_kwin_remote_buffer;
struct wl_output;

#ifndef ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_INTERFACE
#define ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_INTERFACE
/**
 * @page page_iface_org_kde_kwin_remote_access_manager org_kde_kwin_remote_access_manager
 * @section page_iface_org_kde_kwin_remote_access_manager_desc Description
 * @section page_iface_org_kde_kwin_remote_access_manager_api API
 * See @ref iface_org_kde_kwin_remote_access_manager.
 */
/**
 * @defgroup iface_org_kde_kwin_remote_access_manager The org_kde_kwin_remote_access_manager interface
 */
extern const struct wl_interface org_kde_kwin_remote_access_manager_interface;
#endif
#ifndef ORG_KDE_KWIN_REMOTE_BUFFER_INTERFACE
#define ORG_KDE_KWIN_REMOTE_BUFFER_INTERFACE
/**
 * @page page_iface_org_kde_kwin_remote_buffer org_kde_kwin_remote_buffer
 * @section page_iface_org_kde_kwin_remote_buffer_desc Description
 * @section page_iface_org_kde_kwin_remote_buffer_api API
 * See @ref iface_org_kde_kwin_remote_buffer.
 */
/**
 * @defgroup iface_org_kde_kwin_remote_buffer The org_kde_kwin_remote_buffer interface
 */
extern const struct wl_interface org_kde_kwin_remote_buffer_interface;
#endif

/**
 * @ingroup iface_org_kde_kwin_remote_access_manager
 * @struct org_kde_kwin_remote_access_manager_interface
 */
struct org_kde_kwin_remote_access_manager_interface {
	/**
	 * Answer on buffer_ready event, retrieves new buffer from server
	 *
	 * 
	 * @param internal_buffer_id The internal buffer id of the buffer to create
	 */
	void (*get_buffer)(struct wl_client *client,
			   struct wl_resource *resource,
			   uint32_t buffer,
			   int32_t internal_buffer_id);
	/**
	 * release org_kde_kwin_remote_access_manager interface
	 *
	 * 
	 */
	void (*release)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_BUFFER_READY 0

/**
 * @ingroup iface_org_kde_kwin_remote_access_manager
 */
#define ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_BUFFER_READY_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_remote_access_manager
 */
#define ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_GET_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_remote_access_manager
 */
#define ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_RELEASE_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_remote_access_manager
 * Sends an buffer_ready event to the client owning the resource.
 * @param resource_ The client's resource
 * @param id unique id of created buffer (you can use server-side fd number)
 * @param output screen that this buffer belongs to
 */
static inline void
org_kde_kwin_remote_access_manager_send_buffer_ready(struct wl_resource *resource_, int32_t id, struct wl_resource *output)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_REMOTE_ACCESS_MANAGER_BUFFER_READY, id, output);
}

/**
 * @ingroup iface_org_kde_kwin_remote_buffer
 * @struct org_kde_kwin_remote_buffer_interface
 */
struct org_kde_kwin_remote_buffer_interface {
	/**
	 * This request comes once client no longer needs this buffer.
	 *
	 * 
	 */
	void (*release)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ORG_KDE_KWIN_REMOTE_BUFFER_GBM_HANDLE 0

/**
 * @ingroup iface_org_kde_kwin_remote_buffer
 */
#define ORG_KDE_KWIN_REMOTE_BUFFER_GBM_HANDLE_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_remote_buffer
 */
#define ORG_KDE_KWIN_REMOTE_BUFFER_RELEASE_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_remote_buffer
 * Sends an gbm_handle event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_kwin_remote_buffer_send_gbm_handle(struct wl_resource *resource_, int32_t fd, uint32_t width, uint32_t height, uint32_t stride, uint32_t format)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_REMOTE_BUFFER_GBM_HANDLE, fd, width, height, stride, format);
}

#ifdef  __cplusplus
}
#endif

#endif
