/* player.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from player.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
   This file is part of GNOME Reversi, also known as Iagno.

   Copyright 2013, 2014 Michael Catanzaro
   Copyright 2014, 2019 Arnaud Bonatti

   GNOME Reversi is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Reversi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME Reversi.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

#define TYPE_PLAYER (player_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

VALA_EXTERN GType player_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* player_to_string (Player self);
VALA_EXTERN Player player_from_char (gchar c);
VALA_EXTERN Player player_flip_color (Player p);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
player_to_string (Player self)
{
	gchar* result;
	switch (self) {
		case PLAYER_LIGHT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("L");
			result = _tmp0_;
			return result;
		}
		case PLAYER_DARK:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("D");
			result = _tmp1_;
			return result;
		}
		case PLAYER_NONE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (".");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

Player
player_from_char (gchar c)
{
	Player result;
	_vala_return_val_if_fail (((c == 'L') || (c == 'D')) || (c == '.'), "c == 'L' || c == 'D' || c == '.'", 0);
	switch (c) {
		case 'L':
		{
			result = PLAYER_LIGHT;
			return result;
		}
		case 'D':
		{
			result = PLAYER_DARK;
			return result;
		}
		case '.':
		{
			result = PLAYER_NONE;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

inline Player
player_flip_color (Player p)
{
	Player _tmp0_ = 0;
	Player result;
	_vala_return_val_if_fail (p != PLAYER_NONE, "p != Player.NONE", 0);
	if (p == PLAYER_LIGHT) {
		_tmp0_ = PLAYER_DARK;
	} else {
		_tmp0_ = PLAYER_LIGHT;
	}
	result = _tmp0_;
	return result;
}

static GType
player_get_type_once (void)
{
	static const GEnumValue values[] = {{PLAYER_NONE, "PLAYER_NONE", "none"}, {PLAYER_DARK, "PLAYER_DARK", "dark"}, {PLAYER_LIGHT, "PLAYER_LIGHT", "light"}, {0, NULL, NULL}};
	GType player_type_id;
	player_type_id = g_enum_register_static ("Player", values);
	return player_type_id;
}

GType
player_get_type (void)
{
	static volatile gsize player_type_id__once = 0;
	if (g_once_init_enter (&player_type_id__once)) {
		GType player_type_id;
		player_type_id = player_get_type_once ();
		g_once_init_leave (&player_type_id__once, player_type_id);
	}
	return player_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

