/* overlayed-list.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from overlayed-list.vala, do not modify */

/*
  This file is part of GNOME Reversi

  GNOME Reversi is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  GNOME Reversi is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNOME Reversi.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_OVERLAYED_LIST (overlayed_list_get_type ())
#define OVERLAYED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OVERLAYED_LIST, OverlayedList))
#define OVERLAYED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OVERLAYED_LIST, OverlayedListClass))
#define IS_OVERLAYED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OVERLAYED_LIST))
#define IS_OVERLAYED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OVERLAYED_LIST))
#define OVERLAYED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OVERLAYED_LIST, OverlayedListClass))

typedef struct _OverlayedList OverlayedList;
typedef struct _OverlayedListClass OverlayedListClass;
typedef struct _OverlayedListPrivate OverlayedListPrivate;
enum  {
	OVERLAYED_LIST_0_PROPERTY,
	OVERLAYED_LIST_EDIT_MODE_ACTION_PREFIX_PROPERTY,
	OVERLAYED_LIST_FIRST_MODE_NAME_PROPERTY,
	OVERLAYED_LIST_SECOND_MODE_NAME_PROPERTY,
	OVERLAYED_LIST_NEEDS_SHADOWS_PROPERTY,
	OVERLAYED_LIST_BIG_PLACEHOLDER_PROPERTY,
	OVERLAYED_LIST_N_ITEMS_PROPERTY,
	OVERLAYED_LIST_NUM_PROPERTIES
};
static GParamSpec* overlayed_list_properties[OVERLAYED_LIST_NUM_PROPERTIES];
typedef enum  {
	OVERLAYED_LIST_SELECTION_STATE_EMPTY,
	OVERLAYED_LIST_SELECTION_STATE_UNIQUE,
	OVERLAYED_LIST_SELECTION_STATE_FIRST,
	OVERLAYED_LIST_SELECTION_STATE_LAST,
	OVERLAYED_LIST_SELECTION_STATE_MIDDLE,
	OVERLAYED_LIST_SELECTION_STATE_MULTIPLE,
	OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_FIRST,
	OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_LAST,
	OVERLAYED_LIST_SELECTION_STATE_ALL
} OverlayedListSelectionState;

#define OVERLAYED_LIST_TYPE_SELECTION_STATE (overlayed_list_selection_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_REGISTRY_PLACEHOLDER (registry_placeholder_get_type ())
#define REGISTRY_PLACEHOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_PLACEHOLDER, RegistryPlaceholder))
#define REGISTRY_PLACEHOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_PLACEHOLDER, RegistryPlaceholderClass))
#define IS_REGISTRY_PLACEHOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_PLACEHOLDER))
#define IS_REGISTRY_PLACEHOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_PLACEHOLDER))
#define REGISTRY_PLACEHOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_PLACEHOLDER, RegistryPlaceholderClass))

typedef struct _RegistryPlaceholder RegistryPlaceholder;
typedef struct _RegistryPlaceholderClass RegistryPlaceholderClass;
typedef struct _Block4Data Block4Data;

#define TYPE_OVERLAYED_LIST_ROW (overlayed_list_row_get_type ())
#define OVERLAYED_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OVERLAYED_LIST_ROW, OverlayedListRow))
#define OVERLAYED_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OVERLAYED_LIST_ROW, OverlayedListRowClass))
#define IS_OVERLAYED_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OVERLAYED_LIST_ROW))
#define IS_OVERLAYED_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OVERLAYED_LIST_ROW))
#define OVERLAYED_LIST_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OVERLAYED_LIST_ROW, OverlayedListRowClass))

typedef struct _OverlayedListRow OverlayedListRow;
typedef struct _OverlayedListRowClass OverlayedListRowClass;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
enum  {
	OVERLAYED_LIST_SELECTION_CHANGED_SIGNAL,
	OVERLAYED_LIST_NUM_SIGNALS
};
static guint overlayed_list_signals[OVERLAYED_LIST_NUM_SIGNALS] = {0};
typedef struct _OverlayedListRowPrivate OverlayedListRowPrivate;
enum  {
	OVERLAYED_LIST_ROW_0_PROPERTY,
	OVERLAYED_LIST_ROW_NUM_PROPERTIES
};
static GParamSpec* overlayed_list_row_properties[OVERLAYED_LIST_ROW_NUM_PROPERTIES];

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _OverlayedList {
	GtkOverlay parent_instance;
	OverlayedListPrivate * priv;
	GtkListBox* main_list_box;
	GListStore* main_list_store;
	gchar* placeholder_icon;
	gchar* placeholder_text;
	gulong content_changed_handler;
};

struct _OverlayedListClass {
	GtkOverlayClass parent_class;
	void (*reset) (OverlayedList* self);
};

struct _OverlayedListPrivate {
	GtkStyleContext* main_list_box_context;
	GtkScrolledWindow* scrolled;
	GtkBox* edit_mode_box;
	GtkModelButton* enter_edit_mode_button;
	GtkModelButton* leave_edit_mode_button;
	gboolean _big_placeholder;
	GtkStyleContext* main_context;
	guint _n_items;
	gboolean is_editable;
	gboolean has_empty_list_class;
};

struct _Block4Data {
	int _ref_count_;
	gint* indices;
	gint indices_length1;
	gint _indices_size_;
};

struct _Block5Data {
	int _ref_count_;
	guint n_selected_rows;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	guint first_items;
	guint last_items;
	guint first_of_the_last_items_index;
};

struct _OverlayedListRow {
	GtkListBoxRow parent_instance;
	OverlayedListRowPrivate * priv;
};

struct _OverlayedListRowClass {
	GtkListBoxRowClass parent_class;
	gboolean (*handle_copy_text) (OverlayedListRow* self, gchar** copy_text);
};

static gint OverlayedList_private_offset;
static gpointer overlayed_list_parent_class = NULL;
static AdaptativeWidgetIface * overlayed_list_adaptative_widget_parent_iface = NULL;
static gpointer overlayed_list_row_parent_class = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType overlayed_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OverlayedList, g_object_unref)
VALA_EXTERN void overlayed_list_reset (OverlayedList* self);
VALA_EXTERN GType overlayed_list_selection_state_get_type (void) G_GNUC_CONST ;
static GtkWidget* overlayed_list_create_rows (OverlayedList* self,
                                       GObject* item);
VALA_EXTERN void overlayed_list_add_placeholder (OverlayedList* self);
VALA_EXTERN GType registry_placeholder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RegistryPlaceholder, g_object_unref)
static gboolean overlayed_list_get_big_placeholder (OverlayedList* self);
VALA_EXTERN RegistryPlaceholder* registry_placeholder_new (const gchar* _icon_name,
                                               const gchar* _label,
                                               gboolean _big);
VALA_EXTERN RegistryPlaceholder* registry_placeholder_construct (GType object_type,
                                                     const gchar* _icon_name,
                                                     const gchar* _label,
                                                     gboolean _big);
static void overlayed_list_real_set_window_size (AdaptativeWidget* base,
                                          AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_thin (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_flat (AdaptativeWidgetWindowSize window_size);
static inline void overlayed_list_set_horizontal (GtkStyleContext** main_context,
                                    GtkBox* edit_mode_box);
static inline void overlayed_list_set_vertical (GtkStyleContext** main_context,
                                  GtkBox* edit_mode_box);
VALA_EXTERN gboolean overlayed_list_next_match (OverlayedList* self);
static inline gboolean _overlayed_list_next_match (GtkListBox* main_list_box);
static inline void _overlayed_list_scroll_bottom (GtkListBox* main_list_box);
VALA_EXTERN gboolean overlayed_list_previous_match (OverlayedList* self);
static inline gboolean _overlayed_list_previous_match (GtkListBox* main_list_box);
VALA_EXTERN void overlayed_list_select_all (OverlayedList* self);
VALA_EXTERN void overlayed_list_unselect_all (OverlayedList* self);
VALA_EXTERN void overlayed_list_select_row_for_real (OverlayedList* self,
                                         GtkListBoxRow* row);
VALA_EXTERN gint* overlayed_list_get_selected_rows_indices (OverlayedList* self,
                                                gint* result_length1);
static inline gint* _overlayed_list_get_selected_rows_indices (GtkListBox* main_list_box,
                                                 gint* result_length1);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda4_ (Block4Data* _data4_,
                 GtkListBox* _list_box,
                 GtkListBoxRow* selected_row);
static void _vala_array_add1 (gint* * array,
                       gint* length,
                       gint* size,
                       gint value);
static void ___lambda4__gtk_list_box_foreach_func (GtkListBox* box,
                                            GtkListBoxRow* row,
                                            gpointer self);
static gint* _vala_array_dup16 (gint* self,
                         gssize length);
VALA_EXTERN void overlayed_list_scroll_top (OverlayedList* self);
static inline void _overlayed_list_scroll_top (GtkListBox* main_list_box);
VALA_EXTERN void overlayed_list_scroll_bottom (OverlayedList* self);
VALA_EXTERN gboolean overlayed_list_handle_copy_text (OverlayedList* self,
                                          gchar** copy_text);
static inline gboolean _overlayed_list_handle_copy_text (gchar** copy_text,
                                           GtkListBox* main_list_box);
VALA_EXTERN GType overlayed_list_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OverlayedListRow, g_object_unref)
VALA_EXTERN gboolean base_window_copy_clipboard_text (gchar** copy_text);
VALA_EXTERN gboolean base_window_no_copy_text (gchar** copy_text);
VALA_EXTERN gboolean overlayed_list_row_handle_copy_text (OverlayedListRow* self,
                                              gchar** copy_text);
static void overlayed_list_on_selection_changed (OverlayedList* self);
static void _overlayed_list_on_selection_changed_gtk_list_box_selected_rows_changed (GtkListBox* _sender,
                                                                              gpointer self);
VALA_EXTERN OverlayedListSelectionState overlayed_list_get_selection_state (OverlayedList* self);
static inline OverlayedListSelectionState _overlayed_list_get_selection_state (GtkListBox* main_list_box,
                                                                 GListStore** main_list_store);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ___lambda11_ (Block6Data* _data6_,
                   GtkListBoxRow* row);
static void ____lambda11__gfunc (gconstpointer data,
                          gpointer self);
VALA_EXTERN void overlayed_list_change_editability (OverlayedList* self,
                                        gboolean new_value);
static inline void overlayed_list_update_edit_mode_box_visibility (OverlayedList* self);
static void overlayed_list_connect_handlers (OverlayedList* self);
static void overlayed_list_on_content_changed (OverlayedList* self,
                                        GListModel* main_list_model,
                                        guint position,
                                        guint removed,
                                        guint added);
static void _overlayed_list_on_content_changed_g_list_model_items_changed (GListModel* _sender,
                                                                    guint position,
                                                                    guint removed,
                                                                    guint added,
                                                                    gpointer self);
static void __lambda12_ (OverlayedList* self);
static void ___lambda12__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
VALA_EXTERN guint overlayed_list_get_n_items (OverlayedList* self);
static void overlayed_list_set_n_items (OverlayedList* self,
                                 guint value);
static void overlayed_list_update_has_empty_list_class (OverlayedList* self,
                                                 gboolean list_is_empty);
static void overlayed_list_real_reset (OverlayedList* self);
VALA_EXTERN OverlayedList* overlayed_list_construct (GType object_type);
static void overlayed_list_set_edit_mode_action_prefix (OverlayedList* self,
                                                 const gchar* value);
VALA_EXTERN void overlayed_list_set_first_mode_name (OverlayedList* self,
                                         const gchar* value);
VALA_EXTERN void overlayed_list_set_second_mode_name (OverlayedList* self,
                                          const gchar* value);
static void overlayed_list_set_needs_shadows (OverlayedList* self,
                                       gboolean value);
static void overlayed_list_set_big_placeholder (OverlayedList* self,
                                         gboolean value);
static GObject * overlayed_list_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static GtkWidget* _overlayed_list_create_rows_gtk_list_box_create_widget_func (GObject* item,
                                                                        gpointer self);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void overlayed_list_finalize (GObject * obj);
static GType overlayed_list_get_type_once (void);
static void _vala_overlayed_list_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_overlayed_list_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static gboolean overlayed_list_row_real_handle_copy_text (OverlayedListRow* self,
                                                   gchar** copy_text);
VALA_EXTERN OverlayedListRow* overlayed_list_row_construct (GType object_type);
static GType overlayed_list_row_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
overlayed_list_get_instance_private (OverlayedList* self)
{
	return G_STRUCT_MEMBER_P (self, OverlayedList_private_offset);
}

static GType
overlayed_list_selection_state_get_type_once (void)
{
	static const GEnumValue values[] = {{OVERLAYED_LIST_SELECTION_STATE_EMPTY, "OVERLAYED_LIST_SELECTION_STATE_EMPTY", "empty"}, {OVERLAYED_LIST_SELECTION_STATE_UNIQUE, "OVERLAYED_LIST_SELECTION_STATE_UNIQUE", "unique"}, {OVERLAYED_LIST_SELECTION_STATE_FIRST, "OVERLAYED_LIST_SELECTION_STATE_FIRST", "first"}, {OVERLAYED_LIST_SELECTION_STATE_LAST, "OVERLAYED_LIST_SELECTION_STATE_LAST", "last"}, {OVERLAYED_LIST_SELECTION_STATE_MIDDLE, "OVERLAYED_LIST_SELECTION_STATE_MIDDLE", "middle"}, {OVERLAYED_LIST_SELECTION_STATE_MULTIPLE, "OVERLAYED_LIST_SELECTION_STATE_MULTIPLE", "multiple"}, {OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_FIRST, "OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_FIRST", "multiple-first"}, {OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_LAST, "OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_LAST", "multiple-last"}, {OVERLAYED_LIST_SELECTION_STATE_ALL, "OVERLAYED_LIST_SELECTION_STATE_ALL", "all"}, {0, NULL, NULL}};
	GType overlayed_list_selection_state_type_id;
	overlayed_list_selection_state_type_id = g_enum_register_static ("OverlayedListSelectionState", values);
	return overlayed_list_selection_state_type_id;
}

GType
overlayed_list_selection_state_get_type (void)
{
	static volatile gsize overlayed_list_selection_state_type_id__once = 0;
	if (g_once_init_enter (&overlayed_list_selection_state_type_id__once)) {
		GType overlayed_list_selection_state_type_id;
		overlayed_list_selection_state_type_id = overlayed_list_selection_state_get_type_once ();
		g_once_init_leave (&overlayed_list_selection_state_type_id__once, overlayed_list_selection_state_type_id);
	}
	return overlayed_list_selection_state_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
overlayed_list_create_rows (OverlayedList* self,
                            GObject* item)
{
	GtkWidget* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, gtk_widget_get_type (), GtkWidget));
	result = _tmp0_;
	return result;
}

void
overlayed_list_add_placeholder (OverlayedList* self)
{
	RegistryPlaceholder* placeholder = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	RegistryPlaceholder* _tmp3_;
	GtkListBox* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->placeholder_icon;
	_tmp1_ = self->placeholder_text;
	_tmp2_ = self->priv->_big_placeholder;
	_tmp3_ = registry_placeholder_new (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	placeholder = _tmp3_;
	_tmp4_ = self->main_list_box;
	gtk_list_box_set_placeholder (_tmp4_, (GtkWidget*) placeholder);
	_g_object_unref0 (placeholder);
}

static void
overlayed_list_real_set_window_size (AdaptativeWidget* base,
                                     AdaptativeWidgetWindowSize new_size)
{
	OverlayedList * self;
	gboolean _tmp0_ = FALSE;
	self = (OverlayedList*) base;
	if (!adaptative_widget_window_size_is_extra_thin (new_size)) {
		_tmp0_ = adaptative_widget_window_size_is_extra_flat (new_size);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkBox* _tmp1_;
		_tmp1_ = self->priv->edit_mode_box;
		overlayed_list_set_horizontal (&self->priv->main_context, _tmp1_);
	} else {
		GtkBox* _tmp2_;
		_tmp2_ = self->priv->edit_mode_box;
		overlayed_list_set_vertical (&self->priv->main_context, _tmp2_);
	}
}

static inline void
overlayed_list_set_horizontal (GtkStyleContext** main_context,
                               GtkBox* edit_mode_box)
{
	g_return_if_fail (*main_context != NULL);
	g_return_if_fail (edit_mode_box != NULL);
	gtk_style_context_remove_class (*main_context, "vertical");
	gtk_widget_set_halign ((GtkWidget*) edit_mode_box, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) edit_mode_box, GTK_ALIGN_CENTER);
	gtk_orientable_set_orientation ((GtkOrientable*) edit_mode_box, GTK_ORIENTATION_VERTICAL);
	g_object_set ((GtkWidget*) edit_mode_box, "width-request", 160, NULL);
	gtk_style_context_add_class (*main_context, "horizontal");
}

static inline void
overlayed_list_set_vertical (GtkStyleContext** main_context,
                             GtkBox* edit_mode_box)
{
	g_return_if_fail (*main_context != NULL);
	g_return_if_fail (edit_mode_box != NULL);
	gtk_style_context_remove_class (*main_context, "horizontal");
	gtk_widget_set_halign ((GtkWidget*) edit_mode_box, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) edit_mode_box, GTK_ALIGN_END);
	gtk_orientable_set_orientation ((GtkOrientable*) edit_mode_box, GTK_ORIENTATION_HORIZONTAL);
	g_object_set ((GtkWidget*) edit_mode_box, "width-request", 200, NULL);
	gtk_style_context_add_class (*main_context, "vertical");
}

gboolean
overlayed_list_next_match (OverlayedList* self)
{
	GtkListBox* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->main_list_box;
	result = _overlayed_list_next_match (_tmp0_);
	return result;
}

static inline gboolean
_overlayed_list_next_match (GtkListBox* main_list_box)
{
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp8_;
	GtkListBoxRow* _tmp9_;
	GtkListBoxRow* _tmp10_;
	gboolean result;
	g_return_val_if_fail (main_list_box != NULL, FALSE);
	_tmp0_ = gtk_list_box_get_selected_row (main_list_box);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	row = _tmp1_;
	_tmp2_ = row;
	if (_tmp2_ == NULL) {
		GtkListBoxRow* _tmp3_;
		GtkListBoxRow* _tmp4_;
		_tmp3_ = gtk_list_box_get_row_at_index (main_list_box, 0);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (row);
		row = _tmp4_;
	} else {
		GtkListBoxRow* _tmp5_;
		GtkListBoxRow* _tmp6_;
		GtkListBoxRow* _tmp7_;
		_tmp5_ = row;
		_tmp6_ = gtk_list_box_get_row_at_index (main_list_box, gtk_list_box_row_get_index (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_list_box_row_get_type (), GtkListBoxRow)) + 1);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (row);
		row = _tmp7_;
	}
	_tmp8_ = row;
	if (_tmp8_ == NULL) {
		_overlayed_list_scroll_bottom (main_list_box);
		result = FALSE;
		_g_object_unref0 (row);
		return result;
	}
	_tmp9_ = row;
	gtk_list_box_select_row (main_list_box, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_list_box_row_get_type (), GtkListBoxRow));
	_tmp10_ = row;
	gtk_widget_grab_focus ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_list_box_row_get_type (), GtkListBoxRow));
	result = TRUE;
	_g_object_unref0 (row);
	return result;
}

gboolean
overlayed_list_previous_match (OverlayedList* self)
{
	GtkListBox* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->main_list_box;
	result = _overlayed_list_previous_match (_tmp0_);
	return result;
}

static inline gboolean
_overlayed_list_previous_match (GtkListBox* main_list_box)
{
	guint n_items = 0U;
	GList* _tmp0_;
	GList* _tmp1_;
	guint _tmp2_;
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp3_;
	GtkListBoxRow* _tmp4_;
	GtkListBoxRow* _tmp5_;
	GtkListBoxRow* _tmp11_;
	GtkListBoxRow* _tmp12_;
	GtkListBoxRow* _tmp13_;
	gboolean result;
	g_return_val_if_fail (main_list_box != NULL, FALSE);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) main_list_box);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_list_length (_tmp1_);
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (g_list_free (_tmp1_), NULL));
	n_items = _tmp2_;
	if (n_items == ((guint) 0)) {
		result = FALSE;
		return result;
	}
	_tmp3_ = gtk_list_box_get_selected_row (main_list_box);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	row = _tmp4_;
	_tmp5_ = row;
	if (_tmp5_ == NULL) {
		GtkListBoxRow* _tmp6_;
		GtkListBoxRow* _tmp7_;
		_tmp6_ = gtk_list_box_get_row_at_index (main_list_box, ((gint) n_items) - 1);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (row);
		row = _tmp7_;
	} else {
		gint index = 0;
		GtkListBoxRow* _tmp8_;
		GtkListBoxRow* _tmp9_;
		GtkListBoxRow* _tmp10_;
		_tmp8_ = row;
		index = gtk_list_box_row_get_index (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_list_box_row_get_type (), GtkListBoxRow));
		if (index <= 0) {
			result = FALSE;
			_g_object_unref0 (row);
			return result;
		}
		_tmp9_ = gtk_list_box_get_row_at_index (main_list_box, index - 1);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (row);
		row = _tmp10_;
	}
	_tmp11_ = row;
	if (_tmp11_ == NULL) {
		g_assert_not_reached ();
	}
	_tmp12_ = row;
	gtk_list_box_select_row (main_list_box, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_list_box_row_get_type (), GtkListBoxRow));
	_tmp13_ = row;
	gtk_widget_grab_focus ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_list_box_row_get_type (), GtkListBoxRow));
	result = TRUE;
	_g_object_unref0 (row);
	return result;
}

void
overlayed_list_select_all (OverlayedList* self)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->main_list_box;
	gtk_list_box_select_all (_tmp0_);
}

void
overlayed_list_unselect_all (OverlayedList* self)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->main_list_box;
	gtk_list_box_unselect_all (_tmp0_);
}

void
overlayed_list_select_row_for_real (OverlayedList* self,
                                    GtkListBoxRow* row)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = self->main_list_box;
	gtk_list_box_unselect_row (_tmp0_, row);
	_tmp1_ = self->main_list_box;
	gtk_list_box_select_row (_tmp1_, row);
}

gint*
overlayed_list_get_selected_rows_indices (OverlayedList* self,
                                          gint* result_length1)
{
	GtkListBox* _tmp0_;
	gint _tmp1_ = 0;
	gint* _tmp2_;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->main_list_box;
	_tmp2_ = _overlayed_list_get_selected_rows_indices (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_data4_->indices = (g_free (_data4_->indices), NULL);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_vala_array_add1 (gint* * array,
                  gint* length,
                  gint* size,
                  gint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
__lambda4_ (Block4Data* _data4_,
            GtkListBox* _list_box,
            GtkListBoxRow* selected_row)
{
	gint index = 0;
	g_return_if_fail (_list_box != NULL);
	g_return_if_fail (selected_row != NULL);
	index = gtk_list_box_row_get_index (selected_row);
	if (index < 0) {
		g_assert_not_reached ();
	}
	_vala_array_add1 (&_data4_->indices, &_data4_->indices_length1, &_data4_->_indices_size_, index);
}

static void
___lambda4__gtk_list_box_foreach_func (GtkListBox* box,
                                       GtkListBoxRow* row,
                                       gpointer self)
{
	__lambda4_ (self, box, row);
}

static gint*
_vala_array_dup16 (gint* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static inline gint*
_overlayed_list_get_selected_rows_indices (GtkListBox* main_list_box,
                                           gint* result_length1)
{
	Block4Data* _data4_;
	gint* _tmp0_;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint* result;
	g_return_val_if_fail (main_list_box != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_tmp0_ = g_new0 (gint, 0);
	_data4_->indices = _tmp0_;
	_data4_->indices_length1 = 0;
	_data4_->_indices_size_ = _data4_->indices_length1;
	gtk_list_box_selected_foreach (main_list_box, ___lambda4__gtk_list_box_foreach_func, _data4_);
	_tmp1_ = (_data4_->indices != NULL) ? _vala_array_dup16 (_data4_->indices, _data4_->indices_length1) : _data4_->indices;
	_tmp1__length1 = _data4_->indices_length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}

void
overlayed_list_scroll_top (OverlayedList* self)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->main_list_box;
	_overlayed_list_scroll_top (_tmp0_);
}

static inline void
_overlayed_list_scroll_top (GtkListBox* main_list_box)
{
	GtkAdjustment* adjustment = NULL;
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	g_return_if_fail (main_list_box != NULL);
	_tmp0_ = gtk_list_box_get_adjustment (main_list_box);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	adjustment = _tmp1_;
	gtk_adjustment_set_value (adjustment, gtk_adjustment_get_lower (adjustment));
	_g_object_unref0 (adjustment);
}

void
overlayed_list_scroll_bottom (OverlayedList* self)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->main_list_box;
	_overlayed_list_scroll_bottom (_tmp0_);
}

static inline void
_overlayed_list_scroll_bottom (GtkListBox* main_list_box)
{
	GtkAdjustment* adjustment = NULL;
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	g_return_if_fail (main_list_box != NULL);
	_tmp0_ = gtk_list_box_get_adjustment (main_list_box);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	adjustment = _tmp1_;
	gtk_adjustment_set_value (adjustment, gtk_adjustment_get_upper (adjustment));
	_g_object_unref0 (adjustment);
}

gboolean
overlayed_list_handle_copy_text (OverlayedList* self,
                                 gchar** copy_text)
{
	gchar* _vala_copy_text = NULL;
	GtkListBox* _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->main_list_box;
	_tmp2_ = _overlayed_list_handle_copy_text (&_tmp1_, _tmp0_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp1_;
	result = _tmp2_;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

static inline gboolean
_overlayed_list_handle_copy_text (gchar** copy_text,
                                  GtkListBox* main_list_box)
{
	gchar* _vala_copy_text = NULL;
	GList* selected_rows = NULL;
	GList* _tmp0_;
	OverlayedListRow* row = NULL;
	GList* _tmp1_;
	OverlayedListRow* _tmp20_;
	gchar* _tmp21_ = NULL;
	gboolean _tmp22_;
	gboolean result;
	g_return_val_if_fail (main_list_box != NULL, FALSE);
	_tmp0_ = gtk_list_box_get_selected_rows (main_list_box);
	selected_rows = _tmp0_;
	_tmp1_ = selected_rows;
	switch (g_list_length (_tmp1_)) {
		case 0:
		{
			GtkWidget* focus_child = NULL;
			GtkWidget* _tmp2_;
			GtkWidget* _tmp3_;
			GtkWidget* _tmp4_;
			gchar* _tmp7_ = NULL;
			gboolean _tmp8_;
			GtkWidget* _tmp9_;
			GtkWidget* _tmp10_;
			OverlayedListRow* _tmp11_;
			_tmp2_ = gtk_container_get_focus_child ((GtkContainer*) main_list_box);
			_tmp3_ = _g_object_ref0 (_tmp2_);
			focus_child = _tmp3_;
			_tmp4_ = focus_child;
			if (_tmp4_ == NULL) {
				gchar* _tmp5_ = NULL;
				gboolean _tmp6_;
				_tmp6_ = base_window_copy_clipboard_text (&_tmp5_);
				_g_free0 (_vala_copy_text);
				_vala_copy_text = _tmp5_;
				result = _tmp6_;
				_g_object_unref0 (focus_child);
				_g_object_unref0 (row);
				(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
				if (copy_text) {
					*copy_text = _vala_copy_text;
				} else {
					_g_free0 (_vala_copy_text);
				}
				return result;
			}
			_tmp8_ = base_window_copy_clipboard_text (&_tmp7_);
			_g_free0 (_vala_copy_text);
			_vala_copy_text = _tmp7_;
			if (_tmp8_) {
				result = TRUE;
				_g_object_unref0 (focus_child);
				_g_object_unref0 (row);
				(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
				if (copy_text) {
					*copy_text = _vala_copy_text;
				} else {
					_g_free0 (_vala_copy_text);
				}
				return result;
			}
			_tmp9_ = focus_child;
			if (!IS_OVERLAYED_LIST_ROW (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget))) {
				g_assert_not_reached ();
			}
			_tmp10_ = focus_child;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), TYPE_OVERLAYED_LIST_ROW, OverlayedListRow));
			_g_object_unref0 (row);
			row = _tmp11_;
			_g_object_unref0 (focus_child);
			break;
		}
		case 1:
		{
			GtkListBoxRow* selected_row = NULL;
			GList* _tmp12_;
			gconstpointer _tmp13_;
			GtkListBoxRow* _tmp14_;
			GtkListBoxRow* _tmp15_;
			GtkListBoxRow* _tmp16_;
			OverlayedListRow* _tmp17_;
			_tmp12_ = selected_rows;
			_tmp13_ = g_list_nth_data (_tmp12_, (guint) 0);
			_tmp14_ = _g_object_ref0 ((GtkListBoxRow*) _tmp13_);
			selected_row = _tmp14_;
			_tmp15_ = selected_row;
			if (!IS_OVERLAYED_LIST_ROW (_tmp15_)) {
				g_assert_not_reached ();
			}
			_tmp16_ = selected_row;
			_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_OVERLAYED_LIST_ROW, OverlayedListRow));
			_g_object_unref0 (row);
			row = _tmp17_;
			_g_object_unref0 (selected_row);
			break;
		}
		default:
		{
			gchar* _tmp18_ = NULL;
			gboolean _tmp19_;
			_tmp19_ = base_window_no_copy_text (&_tmp18_);
			_g_free0 (_vala_copy_text);
			_vala_copy_text = _tmp18_;
			result = _tmp19_;
			_g_object_unref0 (row);
			(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
			if (copy_text) {
				*copy_text = _vala_copy_text;
			} else {
				_g_free0 (_vala_copy_text);
			}
			return result;
		}
	}
	_tmp20_ = row;
	_tmp22_ = overlayed_list_row_handle_copy_text (_tmp20_, &_tmp21_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp21_;
	result = _tmp22_;
	_g_object_unref0 (row);
	(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

static void
overlayed_list_on_selection_changed (OverlayedList* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, overlayed_list_signals[OVERLAYED_LIST_SELECTION_CHANGED_SIGNAL], 0);
}

static void
_overlayed_list_on_selection_changed_gtk_list_box_selected_rows_changed (GtkListBox* _sender,
                                                                         gpointer self)
{
	overlayed_list_on_selection_changed ((OverlayedList*) self);
}

OverlayedListSelectionState
overlayed_list_get_selection_state (OverlayedList* self)
{
	GtkListBox* _tmp0_;
	OverlayedListSelectionState _tmp1_;
	OverlayedListSelectionState result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->main_list_box;
	_tmp1_ = _overlayed_list_get_selection_state (_tmp0_, &self->main_list_store);
	result = _tmp1_;
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		g_slice_free (Block5Data, _data5_);
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}

static void
___lambda11_ (Block6Data* _data6_,
              GtkListBoxRow* row)
{
	Block5Data* _data5_;
	guint index = 0U;
	_data5_ = _data6_->_data5_;
	g_return_if_fail (row != NULL);
	index = (guint) gtk_list_box_row_get_index (row);
	if (index < _data5_->n_selected_rows) {
		guint _tmp0_;
		_tmp0_ = _data6_->first_items;
		_data6_->first_items = _tmp0_ + 1;
	}
	if (index >= _data6_->first_of_the_last_items_index) {
		guint _tmp1_;
		_tmp1_ = _data6_->last_items;
		_data6_->last_items = _tmp1_ + 1;
	}
}

static void
____lambda11__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda11_ (self, (GtkListBoxRow*) data);
}

static inline OverlayedListSelectionState
_overlayed_list_get_selection_state (GtkListBox* main_list_box,
                                     GListStore** main_list_store)
{
	Block5Data* _data5_;
	GList* selected_rows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	gint index = 0;
	GList* _tmp3_;
	gconstpointer _tmp4_;
	gboolean is_first = FALSE;
	gboolean is_last = FALSE;
	GtkListBoxRow* _tmp5_;
	gboolean _tmp6_ = FALSE;
	OverlayedListSelectionState result;
	g_return_val_if_fail (main_list_box != NULL, 0);
	g_return_val_if_fail (*main_list_store != NULL, 0);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_tmp0_ = gtk_list_box_get_selected_rows (main_list_box);
	selected_rows = _tmp0_;
	_tmp1_ = selected_rows;
	_data5_->n_selected_rows = g_list_length (_tmp1_);
	if (_data5_->n_selected_rows == ((guint) 0)) {
		result = OVERLAYED_LIST_SELECTION_STATE_EMPTY;
		(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return result;
	}
	if (_data5_->n_selected_rows >= ((guint) 2)) {
		Block6Data* _data6_;
		guint n_items = 0U;
		GList* _tmp2_;
		_data6_ = g_slice_new0 (Block6Data);
		_data6_->_ref_count_ = 1;
		_data6_->_data5_ = block5_data_ref (_data5_);
		n_items = g_list_model_get_n_items ((GListModel*) (*main_list_store));
		if (_data5_->n_selected_rows == n_items) {
			result = OVERLAYED_LIST_SELECTION_STATE_ALL;
			block6_data_unref (_data6_);
			_data6_ = NULL;
			(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return result;
		}
		_data6_->first_items = (guint) 0;
		_data6_->last_items = (guint) 0;
		_data6_->first_of_the_last_items_index = n_items - _data5_->n_selected_rows;
		_tmp2_ = selected_rows;
		g_list_foreach (_tmp2_, ____lambda11__gfunc, _data6_);
		if (_data6_->first_items == _data5_->n_selected_rows) {
			result = OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_FIRST;
			block6_data_unref (_data6_);
			_data6_ = NULL;
			(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return result;
		}
		if (_data6_->last_items == _data5_->n_selected_rows) {
			result = OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_LAST;
			block6_data_unref (_data6_);
			_data6_ = NULL;
			(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return result;
		}
		result = OVERLAYED_LIST_SELECTION_STATE_MULTIPLE;
		block6_data_unref (_data6_);
		_data6_ = NULL;
		(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return result;
	}
	_tmp3_ = selected_rows;
	_tmp4_ = g_list_nth_data (_tmp3_, (guint) 0);
	index = gtk_list_box_row_get_index ((GtkListBoxRow*) _tmp4_);
	is_first = index == 0;
	_tmp5_ = gtk_list_box_get_row_at_index (main_list_box, index + 1);
	is_last = _tmp5_ == NULL;
	if (is_first) {
		_tmp6_ = is_last;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = OVERLAYED_LIST_SELECTION_STATE_UNIQUE;
		(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return result;
	}
	if (is_first) {
		result = OVERLAYED_LIST_SELECTION_STATE_FIRST;
		(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return result;
	}
	if (is_last) {
		result = OVERLAYED_LIST_SELECTION_STATE_LAST;
		(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return result;
	}
	result = OVERLAYED_LIST_SELECTION_STATE_MIDDLE;
	(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

void
overlayed_list_change_editability (OverlayedList* self,
                                   gboolean new_value)
{
	g_return_if_fail (self != NULL);
	self->priv->is_editable = new_value;
	overlayed_list_update_edit_mode_box_visibility (self);
}

static void
_overlayed_list_on_content_changed_g_list_model_items_changed (GListModel* _sender,
                                                               guint position,
                                                               guint removed,
                                                               guint added,
                                                               gpointer self)
{
	overlayed_list_on_content_changed ((OverlayedList*) self, _sender, position, removed, added);
}

static void
__lambda12_ (OverlayedList* self)
{
	GListStore* _tmp0_;
	_tmp0_ = self->main_list_store;
	g_signal_handler_disconnect ((GObject*) _tmp0_, self->content_changed_handler);
}

static void
___lambda12__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda12_ ((OverlayedList*) self);
}

static void
overlayed_list_connect_handlers (OverlayedList* self)
{
	GListStore* _tmp0_;
	gulong _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->main_list_store;
	_tmp1_ = g_signal_connect_object ((GListModel*) _tmp0_, "items-changed", (GCallback) _overlayed_list_on_content_changed_g_list_model_items_changed, self, 0);
	self->content_changed_handler = _tmp1_;
	g_signal_connect_object ((GtkWidget*) self, "destroy", (GCallback) ___lambda12__gtk_widget_destroy, self, 0);
}

static void
overlayed_list_on_content_changed (OverlayedList* self,
                                   GListModel* main_list_model,
                                   guint position,
                                   guint removed,
                                   guint added)
{
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_list_model != NULL);
	_tmp0_ = self->priv->_n_items;
	overlayed_list_set_n_items (self, _tmp0_ + added);
	_tmp1_ = self->priv->_n_items;
	overlayed_list_set_n_items (self, _tmp1_ - removed);
	_tmp2_ = self->priv->_n_items;
	overlayed_list_update_has_empty_list_class (self, _tmp2_ == ((guint) 0));
	overlayed_list_update_edit_mode_box_visibility (self);
}

static void
overlayed_list_update_has_empty_list_class (OverlayedList* self,
                                            gboolean list_is_empty)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (list_is_empty) {
		_tmp0_ = !self->priv->has_empty_list_class;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkStyleContext* _tmp1_;
		_tmp1_ = self->priv->main_list_box_context;
		gtk_style_context_add_class (_tmp1_, "empty-list");
		self->priv->has_empty_list_class = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (!list_is_empty) {
			_tmp2_ = self->priv->has_empty_list_class;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GtkStyleContext* _tmp3_;
			self->priv->has_empty_list_class = FALSE;
			_tmp3_ = self->priv->main_list_box_context;
			gtk_style_context_remove_class (_tmp3_, "empty-list");
		}
	}
}

static inline void
overlayed_list_update_edit_mode_box_visibility (OverlayedList* self)
{
	gboolean _tmp0_ = FALSE;
	GtkBox* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->priv->is_editable) {
		guint _tmp1_;
		_tmp1_ = self->priv->_n_items;
		_tmp0_ = _tmp1_ != ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp2_ = self->priv->edit_mode_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, _tmp0_);
}

static void
overlayed_list_real_reset (OverlayedList* self)
{
	g_critical ("Type `%s' does not implement abstract method `overlayed_list_reset'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
overlayed_list_reset (OverlayedList* self)
{
	OverlayedListClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = OVERLAYED_LIST_GET_CLASS (self);
	if (_klass_->reset) {
		_klass_->reset (self);
	}
}

OverlayedList*
overlayed_list_construct (GType object_type)
{
	OverlayedList * self = NULL;
	self = (OverlayedList*) g_object_new (object_type, NULL);
	return self;
}

static void
overlayed_list_set_edit_mode_action_prefix (OverlayedList* self,
                                            const gchar* value)
{
	GtkStyleContext* _tmp0_;
	GtkModelButton* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkModelButton* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "needs-padding");
	_tmp1_ = self->priv->enter_edit_mode_button;
	_tmp2_ = g_strconcat (value, ".set-edit-mode(true)", NULL);
	_tmp3_ = _tmp2_;
	gtk_actionable_set_detailed_action_name ((GtkActionable*) _tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->leave_edit_mode_button;
	_tmp5_ = g_strconcat (value, ".set-edit-mode(false)", NULL);
	_tmp6_ = _tmp5_;
	gtk_actionable_set_detailed_action_name ((GtkActionable*) _tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
}

void
overlayed_list_set_first_mode_name (OverlayedList* self,
                                    const gchar* value)
{
	GtkModelButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->leave_edit_mode_button;
	g_object_set (_tmp0_, "text", value, NULL);
}

void
overlayed_list_set_second_mode_name (OverlayedList* self,
                                     const gchar* value)
{
	GtkModelButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->enter_edit_mode_button;
	g_object_set (_tmp0_, "text", value, NULL);
}

static void
overlayed_list_set_needs_shadows (OverlayedList* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		GtkScrolledWindow* _tmp0_;
		_tmp0_ = self->priv->scrolled;
		gtk_scrolled_window_set_shadow_type (_tmp0_, GTK_SHADOW_ETCHED_IN);
	} else {
		GtkScrolledWindow* _tmp1_;
		_tmp1_ = self->priv->scrolled;
		gtk_scrolled_window_set_shadow_type (_tmp1_, GTK_SHADOW_NONE);
	}
}

static gboolean
overlayed_list_get_big_placeholder (OverlayedList* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_big_placeholder;
	return result;
}

static void
overlayed_list_set_big_placeholder (OverlayedList* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_big_placeholder = value;
}

guint
overlayed_list_get_n_items (OverlayedList* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_n_items;
	return result;
}

static void
overlayed_list_set_n_items (OverlayedList* self,
                            guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_n_items = value;
}

static GtkWidget*
_overlayed_list_create_rows_gtk_list_box_create_widget_func (GObject* item,
                                                             gpointer self)
{
	GtkWidget* result;
	result = overlayed_list_create_rows ((OverlayedList*) self, item);
	return result;
}

static GObject *
overlayed_list_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	OverlayedList * self;
	GtkListBox* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkListBox* _tmp5_;
	GListStore* _tmp6_;
	parent_class = G_OBJECT_CLASS (overlayed_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OVERLAYED_LIST, OverlayedList);
	_tmp0_ = self->main_list_box;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->main_list_box_context);
	self->priv->main_list_box_context = _tmp2_;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->main_context);
	self->priv->main_context = _tmp4_;
	overlayed_list_connect_handlers (self);
	_tmp5_ = self->main_list_box;
	_tmp6_ = self->main_list_store;
	gtk_list_box_bind_model (_tmp5_, (GListModel*) _tmp6_, _overlayed_list_create_rows_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	return obj;
}

static void
overlayed_list_class_init (OverlayedListClass * klass,
                           gpointer klass_data)
{
	overlayed_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &OverlayedList_private_offset);
	((OverlayedListClass *) klass)->reset = (void (*) (OverlayedList*)) overlayed_list_real_reset;
	G_OBJECT_CLASS (klass)->get_property = _vala_overlayed_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_overlayed_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = overlayed_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = overlayed_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), OVERLAYED_LIST_EDIT_MODE_ACTION_PREFIX_PROPERTY, overlayed_list_properties[OVERLAYED_LIST_EDIT_MODE_ACTION_PREFIX_PROPERTY] = g_param_spec_string ("edit-mode-action-prefix", "edit-mode-action-prefix", "edit-mode-action-prefix", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OVERLAYED_LIST_FIRST_MODE_NAME_PROPERTY, overlayed_list_properties[OVERLAYED_LIST_FIRST_MODE_NAME_PROPERTY] = g_param_spec_string ("first-mode-name", "first-mode-name", "first-mode-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OVERLAYED_LIST_SECOND_MODE_NAME_PROPERTY, overlayed_list_properties[OVERLAYED_LIST_SECOND_MODE_NAME_PROPERTY] = g_param_spec_string ("second-mode-name", "second-mode-name", "second-mode-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OVERLAYED_LIST_NEEDS_SHADOWS_PROPERTY, overlayed_list_properties[OVERLAYED_LIST_NEEDS_SHADOWS_PROPERTY] = g_param_spec_boolean ("needs-shadows", "needs-shadows", "needs-shadows", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OVERLAYED_LIST_BIG_PLACEHOLDER_PROPERTY, overlayed_list_properties[OVERLAYED_LIST_BIG_PLACEHOLDER_PROPERTY] = g_param_spec_boolean ("big-placeholder", "big-placeholder", "big-placeholder", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OVERLAYED_LIST_N_ITEMS_PROPERTY, overlayed_list_properties[OVERLAYED_LIST_N_ITEMS_PROPERTY] = g_param_spec_uint ("n-items", "n-items", "n-items", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Reversi/ui/overlayed-list.ui");
	overlayed_list_signals[OVERLAYED_LIST_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", TYPE_OVERLAYED_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_list_box", FALSE, G_STRUCT_OFFSET (OverlayedList, main_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scrolled", FALSE, OverlayedList_private_offset + G_STRUCT_OFFSET (OverlayedListPrivate, scrolled));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "edit_mode_box", FALSE, OverlayedList_private_offset + G_STRUCT_OFFSET (OverlayedListPrivate, edit_mode_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "enter_edit_mode_button", FALSE, OverlayedList_private_offset + G_STRUCT_OFFSET (OverlayedListPrivate, enter_edit_mode_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "leave_edit_mode_button", FALSE, OverlayedList_private_offset + G_STRUCT_OFFSET (OverlayedListPrivate, leave_edit_mode_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_selection_changed", G_CALLBACK(_overlayed_list_on_selection_changed_gtk_list_box_selected_rows_changed));
}

static void
overlayed_list_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                                 gpointer iface_data)
{
	overlayed_list_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) overlayed_list_real_set_window_size;
}

static void
overlayed_list_instance_init (OverlayedList * self,
                              gpointer klass)
{
	GListStore* _tmp0_;
	self->priv = overlayed_list_get_instance_private (self);
	_tmp0_ = g_list_store_new (gtk_widget_get_type ());
	self->main_list_store = _tmp0_;
	self->content_changed_handler = (gulong) 0;
	self->priv->_n_items = (guint) 0;
	self->priv->is_editable = FALSE;
	self->priv->has_empty_list_class = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
overlayed_list_finalize (GObject * obj)
{
	OverlayedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OVERLAYED_LIST, OverlayedList);
	_g_object_unref0 (self->priv->main_list_box_context);
	_g_object_unref0 (self->main_list_store);
	_g_free0 (self->placeholder_icon);
	_g_free0 (self->placeholder_text);
	_g_object_unref0 (self->priv->main_context);
	G_OBJECT_CLASS (overlayed_list_parent_class)->finalize (obj);
}

static GType
overlayed_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OverlayedListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) overlayed_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OverlayedList), 0, (GInstanceInitFunc) overlayed_list_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) overlayed_list_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType overlayed_list_type_id;
	overlayed_list_type_id = g_type_register_static (gtk_overlay_get_type (), "OverlayedList", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (overlayed_list_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	OverlayedList_private_offset = g_type_add_instance_private (overlayed_list_type_id, sizeof (OverlayedListPrivate));
	return overlayed_list_type_id;
}

GType
overlayed_list_get_type (void)
{
	static volatile gsize overlayed_list_type_id__once = 0;
	if (g_once_init_enter (&overlayed_list_type_id__once)) {
		GType overlayed_list_type_id;
		overlayed_list_type_id = overlayed_list_get_type_once ();
		g_once_init_leave (&overlayed_list_type_id__once, overlayed_list_type_id);
	}
	return overlayed_list_type_id__once;
}

static void
_vala_overlayed_list_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	OverlayedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_OVERLAYED_LIST, OverlayedList);
	switch (property_id) {
		case OVERLAYED_LIST_BIG_PLACEHOLDER_PROPERTY:
		g_value_set_boolean (value, overlayed_list_get_big_placeholder (self));
		break;
		case OVERLAYED_LIST_N_ITEMS_PROPERTY:
		g_value_set_uint (value, overlayed_list_get_n_items (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_overlayed_list_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	OverlayedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_OVERLAYED_LIST, OverlayedList);
	switch (property_id) {
		case OVERLAYED_LIST_EDIT_MODE_ACTION_PREFIX_PROPERTY:
		overlayed_list_set_edit_mode_action_prefix (self, g_value_get_string (value));
		break;
		case OVERLAYED_LIST_FIRST_MODE_NAME_PROPERTY:
		overlayed_list_set_first_mode_name (self, g_value_get_string (value));
		break;
		case OVERLAYED_LIST_SECOND_MODE_NAME_PROPERTY:
		overlayed_list_set_second_mode_name (self, g_value_get_string (value));
		break;
		case OVERLAYED_LIST_NEEDS_SHADOWS_PROPERTY:
		overlayed_list_set_needs_shadows (self, g_value_get_boolean (value));
		break;
		case OVERLAYED_LIST_BIG_PLACEHOLDER_PROPERTY:
		overlayed_list_set_big_placeholder (self, g_value_get_boolean (value));
		break;
		case OVERLAYED_LIST_N_ITEMS_PROPERTY:
		overlayed_list_set_n_items (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gboolean
overlayed_list_row_real_handle_copy_text (OverlayedListRow* self,
                                          gchar** copy_text)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `overlayed_list_row_handle_copy_text'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
overlayed_list_row_handle_copy_text (OverlayedListRow* self,
                                     gchar** copy_text)
{
	OverlayedListRowClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = OVERLAYED_LIST_ROW_GET_CLASS (self);
	if (_klass_->handle_copy_text) {
		return _klass_->handle_copy_text (self, copy_text);
	}
	return FALSE;
}

OverlayedListRow*
overlayed_list_row_construct (GType object_type)
{
	OverlayedListRow * self = NULL;
	self = (OverlayedListRow*) g_object_new (object_type, NULL);
	return self;
}

static void
overlayed_list_row_class_init (OverlayedListRowClass * klass,
                               gpointer klass_data)
{
	overlayed_list_row_parent_class = g_type_class_peek_parent (klass);
	((OverlayedListRowClass *) klass)->handle_copy_text = (gboolean (*) (OverlayedListRow*, gchar**)) overlayed_list_row_real_handle_copy_text;
}

static void
overlayed_list_row_instance_init (OverlayedListRow * self,
                                  gpointer klass)
{
}

static GType
overlayed_list_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OverlayedListRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) overlayed_list_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OverlayedListRow), 0, (GInstanceInitFunc) overlayed_list_row_instance_init, NULL };
	GType overlayed_list_row_type_id;
	overlayed_list_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "OverlayedListRow", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return overlayed_list_row_type_id;
}

GType
overlayed_list_row_get_type (void)
{
	static volatile gsize overlayed_list_row_type_id__once = 0;
	if (g_once_init_enter (&overlayed_list_row_type_id__once)) {
		GType overlayed_list_row_type_id;
		overlayed_list_row_type_id = overlayed_list_row_get_type_once ();
		g_once_init_leave (&overlayed_list_row_type_id__once, overlayed_list_row_type_id);
	}
	return overlayed_list_row_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

