{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Buffered output stream implements t'GI.Gio.Objects.FilterOutputStream.FilterOutputStream' and provides
-- for buffered writes.
-- 
-- By default, @GBufferedOutputStream@\'s buffer size is set at 4 kilobytes.
-- 
-- To create a buffered output stream, use 'GI.Gio.Objects.BufferedOutputStream.bufferedOutputStreamNew',
-- or 'GI.Gio.Objects.BufferedOutputStream.bufferedOutputStreamNewSized' to specify the buffer\'s size
-- at construction.
-- 
-- To get the size of a buffer within a buffered input stream, use
-- 'GI.Gio.Objects.BufferedOutputStream.bufferedOutputStreamGetBufferSize'. To change the size of a
-- buffered output stream\'s buffer, use 'GI.Gio.Objects.BufferedOutputStream.bufferedOutputStreamSetBufferSize'.
-- Note that the buffer\'s size cannot be reduced below the size of the data within the buffer.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.BufferedOutputStream
    ( 

-- * Exported types
    BufferedOutputStream(..)                ,
    IsBufferedOutputStream                  ,
    toBufferedOutputStream                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [canSeek]("GI.Gio.Interfaces.Seekable#g:method:canSeek"), [canTruncate]("GI.Gio.Interfaces.Seekable#g:method:canTruncate"), [clearPending]("GI.Gio.Objects.OutputStream#g:method:clearPending"), [close]("GI.Gio.Objects.OutputStream#g:method:close"), [closeAsync]("GI.Gio.Objects.OutputStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.OutputStream#g:method:closeFinish"), [flush]("GI.Gio.Objects.OutputStream#g:method:flush"), [flushAsync]("GI.Gio.Objects.OutputStream#g:method:flushAsync"), [flushFinish]("GI.Gio.Objects.OutputStream#g:method:flushFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.OutputStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.OutputStream#g:method:isClosed"), [isClosing]("GI.Gio.Objects.OutputStream#g:method:isClosing"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [seek]("GI.Gio.Interfaces.Seekable#g:method:seek"), [splice]("GI.Gio.Objects.OutputStream#g:method:splice"), [spliceAsync]("GI.Gio.Objects.OutputStream#g:method:spliceAsync"), [spliceFinish]("GI.Gio.Objects.OutputStream#g:method:spliceFinish"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [tell]("GI.Gio.Interfaces.Seekable#g:method:tell"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [truncate]("GI.Gio.Interfaces.Seekable#g:method:truncate"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure"), [write]("GI.Gio.Objects.OutputStream#g:method:write"), [writeAll]("GI.Gio.Objects.OutputStream#g:method:writeAll"), [writeAllAsync]("GI.Gio.Objects.OutputStream#g:method:writeAllAsync"), [writeAllFinish]("GI.Gio.Objects.OutputStream#g:method:writeAllFinish"), [writeAsync]("GI.Gio.Objects.OutputStream#g:method:writeAsync"), [writeBytes]("GI.Gio.Objects.OutputStream#g:method:writeBytes"), [writeBytesAsync]("GI.Gio.Objects.OutputStream#g:method:writeBytesAsync"), [writeBytesFinish]("GI.Gio.Objects.OutputStream#g:method:writeBytesFinish"), [writeFinish]("GI.Gio.Objects.OutputStream#g:method:writeFinish"), [writev]("GI.Gio.Objects.OutputStream#g:method:writev"), [writevAll]("GI.Gio.Objects.OutputStream#g:method:writevAll"), [writevAllAsync]("GI.Gio.Objects.OutputStream#g:method:writevAllAsync"), [writevAllFinish]("GI.Gio.Objects.OutputStream#g:method:writevAllFinish"), [writevAsync]("GI.Gio.Objects.OutputStream#g:method:writevAsync"), [writevFinish]("GI.Gio.Objects.OutputStream#g:method:writevFinish").
-- 
-- ==== Getters
-- [getAutoGrow]("GI.Gio.Objects.BufferedOutputStream#g:method:getAutoGrow"), [getBaseStream]("GI.Gio.Objects.FilterOutputStream#g:method:getBaseStream"), [getBufferSize]("GI.Gio.Objects.BufferedOutputStream#g:method:getBufferSize"), [getCloseBaseStream]("GI.Gio.Objects.FilterOutputStream#g:method:getCloseBaseStream"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setAutoGrow]("GI.Gio.Objects.BufferedOutputStream#g:method:setAutoGrow"), [setBufferSize]("GI.Gio.Objects.BufferedOutputStream#g:method:setBufferSize"), [setCloseBaseStream]("GI.Gio.Objects.FilterOutputStream#g:method:setCloseBaseStream"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.OutputStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveBufferedOutputStreamMethod       ,
#endif

-- ** getAutoGrow #method:getAutoGrow#

#if defined(ENABLE_OVERLOADING)
    BufferedOutputStreamGetAutoGrowMethodInfo,
#endif
    bufferedOutputStreamGetAutoGrow         ,


-- ** getBufferSize #method:getBufferSize#

#if defined(ENABLE_OVERLOADING)
    BufferedOutputStreamGetBufferSizeMethodInfo,
#endif
    bufferedOutputStreamGetBufferSize       ,


-- ** new #method:new#

    bufferedOutputStreamNew                 ,


-- ** newSized #method:newSized#

    bufferedOutputStreamNewSized            ,


-- ** setAutoGrow #method:setAutoGrow#

#if defined(ENABLE_OVERLOADING)
    BufferedOutputStreamSetAutoGrowMethodInfo,
#endif
    bufferedOutputStreamSetAutoGrow         ,


-- ** setBufferSize #method:setBufferSize#

#if defined(ENABLE_OVERLOADING)
    BufferedOutputStreamSetBufferSizeMethodInfo,
#endif
    bufferedOutputStreamSetBufferSize       ,




 -- * Properties


-- ** autoGrow #attr:autoGrow#
-- | Whether the buffer should automatically grow.

#if defined(ENABLE_OVERLOADING)
    BufferedOutputStreamAutoGrowPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    bufferedOutputStreamAutoGrow            ,
#endif
    constructBufferedOutputStreamAutoGrow   ,
    getBufferedOutputStreamAutoGrow         ,
    setBufferedOutputStreamAutoGrow         ,


-- ** bufferSize #attr:bufferSize#
-- | The size of the backend buffer, in bytes.

#if defined(ENABLE_OVERLOADING)
    BufferedOutputStreamBufferSizePropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    bufferedOutputStreamBufferSize          ,
#endif
    constructBufferedOutputStreamBufferSize ,
    getBufferedOutputStreamBufferSize       ,
    setBufferedOutputStreamBufferSize       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FilterOutputStream as Gio.FilterOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Objects.FilterOutputStream as Gio.FilterOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#endif

-- | Memory-managed wrapper type.
newtype BufferedOutputStream = BufferedOutputStream (SP.ManagedPtr BufferedOutputStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype BufferedOutputStream where
    toManagedPtr (BufferedOutputStream p) = p

foreign import ccall "g_buffered_output_stream_get_type"
    c_g_buffered_output_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject BufferedOutputStream where
    glibType = c_g_buffered_output_stream_get_type

instance B.Types.GObject BufferedOutputStream

-- | Type class for types which can be safely cast to t'BufferedOutputStream', for instance with `toBufferedOutputStream`.
class (SP.GObject o, O.IsDescendantOf BufferedOutputStream o) => IsBufferedOutputStream o
instance (SP.GObject o, O.IsDescendantOf BufferedOutputStream o) => IsBufferedOutputStream o

instance O.HasParentTypes BufferedOutputStream
type instance O.ParentTypes BufferedOutputStream = '[Gio.FilterOutputStream.FilterOutputStream, Gio.OutputStream.OutputStream, GObject.Object.Object, Gio.Seekable.Seekable]

-- | Cast to t'BufferedOutputStream', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toBufferedOutputStream :: (MIO.MonadIO m, IsBufferedOutputStream o) => o -> m BufferedOutputStream
toBufferedOutputStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo BufferedOutputStream

-- | Convert t'BufferedOutputStream' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe BufferedOutputStream) where
    gvalueGType_ = c_g_buffered_output_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr BufferedOutputStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr BufferedOutputStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject BufferedOutputStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveBufferedOutputStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveBufferedOutputStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveBufferedOutputStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveBufferedOutputStreamMethod "canSeek" o = Gio.Seekable.SeekableCanSeekMethodInfo
    ResolveBufferedOutputStreamMethod "canTruncate" o = Gio.Seekable.SeekableCanTruncateMethodInfo
    ResolveBufferedOutputStreamMethod "clearPending" o = Gio.OutputStream.OutputStreamClearPendingMethodInfo
    ResolveBufferedOutputStreamMethod "close" o = Gio.OutputStream.OutputStreamCloseMethodInfo
    ResolveBufferedOutputStreamMethod "closeAsync" o = Gio.OutputStream.OutputStreamCloseAsyncMethodInfo
    ResolveBufferedOutputStreamMethod "closeFinish" o = Gio.OutputStream.OutputStreamCloseFinishMethodInfo
    ResolveBufferedOutputStreamMethod "flush" o = Gio.OutputStream.OutputStreamFlushMethodInfo
    ResolveBufferedOutputStreamMethod "flushAsync" o = Gio.OutputStream.OutputStreamFlushAsyncMethodInfo
    ResolveBufferedOutputStreamMethod "flushFinish" o = Gio.OutputStream.OutputStreamFlushFinishMethodInfo
    ResolveBufferedOutputStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveBufferedOutputStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveBufferedOutputStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveBufferedOutputStreamMethod "hasPending" o = Gio.OutputStream.OutputStreamHasPendingMethodInfo
    ResolveBufferedOutputStreamMethod "isClosed" o = Gio.OutputStream.OutputStreamIsClosedMethodInfo
    ResolveBufferedOutputStreamMethod "isClosing" o = Gio.OutputStream.OutputStreamIsClosingMethodInfo
    ResolveBufferedOutputStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveBufferedOutputStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveBufferedOutputStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveBufferedOutputStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveBufferedOutputStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveBufferedOutputStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveBufferedOutputStreamMethod "seek" o = Gio.Seekable.SeekableSeekMethodInfo
    ResolveBufferedOutputStreamMethod "splice" o = Gio.OutputStream.OutputStreamSpliceMethodInfo
    ResolveBufferedOutputStreamMethod "spliceAsync" o = Gio.OutputStream.OutputStreamSpliceAsyncMethodInfo
    ResolveBufferedOutputStreamMethod "spliceFinish" o = Gio.OutputStream.OutputStreamSpliceFinishMethodInfo
    ResolveBufferedOutputStreamMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveBufferedOutputStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveBufferedOutputStreamMethod "tell" o = Gio.Seekable.SeekableTellMethodInfo
    ResolveBufferedOutputStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveBufferedOutputStreamMethod "truncate" o = Gio.Seekable.SeekableTruncateMethodInfo
    ResolveBufferedOutputStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveBufferedOutputStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveBufferedOutputStreamMethod "write" o = Gio.OutputStream.OutputStreamWriteMethodInfo
    ResolveBufferedOutputStreamMethod "writeAll" o = Gio.OutputStream.OutputStreamWriteAllMethodInfo
    ResolveBufferedOutputStreamMethod "writeAllAsync" o = Gio.OutputStream.OutputStreamWriteAllAsyncMethodInfo
    ResolveBufferedOutputStreamMethod "writeAllFinish" o = Gio.OutputStream.OutputStreamWriteAllFinishMethodInfo
    ResolveBufferedOutputStreamMethod "writeAsync" o = Gio.OutputStream.OutputStreamWriteAsyncMethodInfo
    ResolveBufferedOutputStreamMethod "writeBytes" o = Gio.OutputStream.OutputStreamWriteBytesMethodInfo
    ResolveBufferedOutputStreamMethod "writeBytesAsync" o = Gio.OutputStream.OutputStreamWriteBytesAsyncMethodInfo
    ResolveBufferedOutputStreamMethod "writeBytesFinish" o = Gio.OutputStream.OutputStreamWriteBytesFinishMethodInfo
    ResolveBufferedOutputStreamMethod "writeFinish" o = Gio.OutputStream.OutputStreamWriteFinishMethodInfo
    ResolveBufferedOutputStreamMethod "writev" o = Gio.OutputStream.OutputStreamWritevMethodInfo
    ResolveBufferedOutputStreamMethod "writevAll" o = Gio.OutputStream.OutputStreamWritevAllMethodInfo
    ResolveBufferedOutputStreamMethod "writevAllAsync" o = Gio.OutputStream.OutputStreamWritevAllAsyncMethodInfo
    ResolveBufferedOutputStreamMethod "writevAllFinish" o = Gio.OutputStream.OutputStreamWritevAllFinishMethodInfo
    ResolveBufferedOutputStreamMethod "writevAsync" o = Gio.OutputStream.OutputStreamWritevAsyncMethodInfo
    ResolveBufferedOutputStreamMethod "writevFinish" o = Gio.OutputStream.OutputStreamWritevFinishMethodInfo
    ResolveBufferedOutputStreamMethod "getAutoGrow" o = BufferedOutputStreamGetAutoGrowMethodInfo
    ResolveBufferedOutputStreamMethod "getBaseStream" o = Gio.FilterOutputStream.FilterOutputStreamGetBaseStreamMethodInfo
    ResolveBufferedOutputStreamMethod "getBufferSize" o = BufferedOutputStreamGetBufferSizeMethodInfo
    ResolveBufferedOutputStreamMethod "getCloseBaseStream" o = Gio.FilterOutputStream.FilterOutputStreamGetCloseBaseStreamMethodInfo
    ResolveBufferedOutputStreamMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveBufferedOutputStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveBufferedOutputStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveBufferedOutputStreamMethod "setAutoGrow" o = BufferedOutputStreamSetAutoGrowMethodInfo
    ResolveBufferedOutputStreamMethod "setBufferSize" o = BufferedOutputStreamSetBufferSizeMethodInfo
    ResolveBufferedOutputStreamMethod "setCloseBaseStream" o = Gio.FilterOutputStream.FilterOutputStreamSetCloseBaseStreamMethodInfo
    ResolveBufferedOutputStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveBufferedOutputStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveBufferedOutputStreamMethod "setPending" o = Gio.OutputStream.OutputStreamSetPendingMethodInfo
    ResolveBufferedOutputStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveBufferedOutputStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveBufferedOutputStreamMethod t BufferedOutputStream, O.OverloadedMethod info BufferedOutputStream p) => OL.IsLabel t (BufferedOutputStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveBufferedOutputStreamMethod t BufferedOutputStream, O.OverloadedMethod info BufferedOutputStream p, R.HasField t BufferedOutputStream p) => R.HasField t BufferedOutputStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveBufferedOutputStreamMethod t BufferedOutputStream, O.OverloadedMethodInfo info BufferedOutputStream) => OL.IsLabel t (O.MethodProxy info BufferedOutputStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "auto-grow"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@auto-grow@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' bufferedOutputStream #autoGrow
-- @
getBufferedOutputStreamAutoGrow :: (MonadIO m, IsBufferedOutputStream o) => o -> m Bool
getBufferedOutputStreamAutoGrow obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "auto-grow"

-- | Set the value of the “@auto-grow@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' bufferedOutputStream [ #autoGrow 'Data.GI.Base.Attributes.:=' value ]
-- @
setBufferedOutputStreamAutoGrow :: (MonadIO m, IsBufferedOutputStream o) => o -> Bool -> m ()
setBufferedOutputStreamAutoGrow obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "auto-grow" val

-- | Construct a t'GValueConstruct' with valid value for the “@auto-grow@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBufferedOutputStreamAutoGrow :: (IsBufferedOutputStream o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructBufferedOutputStreamAutoGrow val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "auto-grow" val

#if defined(ENABLE_OVERLOADING)
data BufferedOutputStreamAutoGrowPropertyInfo
instance AttrInfo BufferedOutputStreamAutoGrowPropertyInfo where
    type AttrAllowedOps BufferedOutputStreamAutoGrowPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint BufferedOutputStreamAutoGrowPropertyInfo = IsBufferedOutputStream
    type AttrSetTypeConstraint BufferedOutputStreamAutoGrowPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint BufferedOutputStreamAutoGrowPropertyInfo = (~) Bool
    type AttrTransferType BufferedOutputStreamAutoGrowPropertyInfo = Bool
    type AttrGetType BufferedOutputStreamAutoGrowPropertyInfo = Bool
    type AttrLabel BufferedOutputStreamAutoGrowPropertyInfo = "auto-grow"
    type AttrOrigin BufferedOutputStreamAutoGrowPropertyInfo = BufferedOutputStream
    attrGet = getBufferedOutputStreamAutoGrow
    attrSet = setBufferedOutputStreamAutoGrow
    attrPut = setBufferedOutputStreamAutoGrow
    attrTransfer _ v = do
        return v
    attrConstruct = constructBufferedOutputStreamAutoGrow
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedOutputStream.autoGrow"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedOutputStream.html#g:attr:autoGrow"
        })
#endif

-- VVV Prop "buffer-size"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@buffer-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' bufferedOutputStream #bufferSize
-- @
getBufferedOutputStreamBufferSize :: (MonadIO m, IsBufferedOutputStream o) => o -> m Word32
getBufferedOutputStreamBufferSize obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "buffer-size"

-- | Set the value of the “@buffer-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' bufferedOutputStream [ #bufferSize 'Data.GI.Base.Attributes.:=' value ]
-- @
setBufferedOutputStreamBufferSize :: (MonadIO m, IsBufferedOutputStream o) => o -> Word32 -> m ()
setBufferedOutputStreamBufferSize obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "buffer-size" val

-- | Construct a t'GValueConstruct' with valid value for the “@buffer-size@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructBufferedOutputStreamBufferSize :: (IsBufferedOutputStream o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructBufferedOutputStreamBufferSize val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "buffer-size" val

#if defined(ENABLE_OVERLOADING)
data BufferedOutputStreamBufferSizePropertyInfo
instance AttrInfo BufferedOutputStreamBufferSizePropertyInfo where
    type AttrAllowedOps BufferedOutputStreamBufferSizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint BufferedOutputStreamBufferSizePropertyInfo = IsBufferedOutputStream
    type AttrSetTypeConstraint BufferedOutputStreamBufferSizePropertyInfo = (~) Word32
    type AttrTransferTypeConstraint BufferedOutputStreamBufferSizePropertyInfo = (~) Word32
    type AttrTransferType BufferedOutputStreamBufferSizePropertyInfo = Word32
    type AttrGetType BufferedOutputStreamBufferSizePropertyInfo = Word32
    type AttrLabel BufferedOutputStreamBufferSizePropertyInfo = "buffer-size"
    type AttrOrigin BufferedOutputStreamBufferSizePropertyInfo = BufferedOutputStream
    attrGet = getBufferedOutputStreamBufferSize
    attrSet = setBufferedOutputStreamBufferSize
    attrPut = setBufferedOutputStreamBufferSize
    attrTransfer _ v = do
        return v
    attrConstruct = constructBufferedOutputStreamBufferSize
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedOutputStream.bufferSize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedOutputStream.html#g:attr:bufferSize"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList BufferedOutputStream
type instance O.AttributeList BufferedOutputStream = BufferedOutputStreamAttributeList
type BufferedOutputStreamAttributeList = ('[ '("autoGrow", BufferedOutputStreamAutoGrowPropertyInfo), '("baseStream", Gio.FilterOutputStream.FilterOutputStreamBaseStreamPropertyInfo), '("bufferSize", BufferedOutputStreamBufferSizePropertyInfo), '("closeBaseStream", Gio.FilterOutputStream.FilterOutputStreamCloseBaseStreamPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
bufferedOutputStreamAutoGrow :: AttrLabelProxy "autoGrow"
bufferedOutputStreamAutoGrow = AttrLabelProxy

bufferedOutputStreamBufferSize :: AttrLabelProxy "bufferSize"
bufferedOutputStreamBufferSize = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList BufferedOutputStream = BufferedOutputStreamSignalList
type BufferedOutputStreamSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method BufferedOutputStream::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "base_stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "OutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.OutputStream]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "BufferedOutputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_buffered_output_stream_new" g_buffered_output_stream_new :: 
    Ptr Gio.OutputStream.OutputStream ->    -- base_stream : TInterface (Name {namespace = "Gio", name = "OutputStream"})
    IO (Ptr BufferedOutputStream)

-- | Creates a new buffered output stream for a base stream.
bufferedOutputStreamNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.OutputStream.IsOutputStream a) =>
    a
    -- ^ /@baseStream@/: a t'GI.Gio.Objects.OutputStream.OutputStream'.
    -> m BufferedOutputStream
    -- ^ __Returns:__ a t'GI.Gio.Objects.OutputStream.OutputStream' for the given /@baseStream@/.
bufferedOutputStreamNew baseStream = liftIO $ do
    baseStream' <- unsafeManagedPtrCastPtr baseStream
    result <- g_buffered_output_stream_new baseStream'
    checkUnexpectedReturnNULL "bufferedOutputStreamNew" result
    result' <- (wrapObject BufferedOutputStream) result
    touchManagedPtr baseStream
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method BufferedOutputStream::new_sized
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "base_stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "OutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.OutputStream]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gsize." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "BufferedOutputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_buffered_output_stream_new_sized" g_buffered_output_stream_new_sized :: 
    Ptr Gio.OutputStream.OutputStream ->    -- base_stream : TInterface (Name {namespace = "Gio", name = "OutputStream"})
    FCT.CSize ->                            -- size : TBasicType TSize
    IO (Ptr BufferedOutputStream)

-- | Creates a new buffered output stream with a given buffer size.
bufferedOutputStreamNewSized ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.OutputStream.IsOutputStream a) =>
    a
    -- ^ /@baseStream@/: a t'GI.Gio.Objects.OutputStream.OutputStream'.
    -> FCT.CSize
    -- ^ /@size@/: a @/gsize/@.
    -> m BufferedOutputStream
    -- ^ __Returns:__ a t'GI.Gio.Objects.OutputStream.OutputStream' with an internal buffer set to /@size@/.
bufferedOutputStreamNewSized baseStream size = liftIO $ do
    baseStream' <- unsafeManagedPtrCastPtr baseStream
    result <- g_buffered_output_stream_new_sized baseStream' size
    checkUnexpectedReturnNULL "bufferedOutputStreamNewSized" result
    result' <- (wrapObject BufferedOutputStream) result
    touchManagedPtr baseStream
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method BufferedOutputStream::get_auto_grow
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BufferedOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.BufferedOutputStream]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_buffered_output_stream_get_auto_grow" g_buffered_output_stream_get_auto_grow :: 
    Ptr BufferedOutputStream ->             -- stream : TInterface (Name {namespace = "Gio", name = "BufferedOutputStream"})
    IO CInt

-- | Checks if the buffer automatically grows as data is added.
bufferedOutputStreamGetAutoGrow ::
    (B.CallStack.HasCallStack, MonadIO m, IsBufferedOutputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.BufferedOutputStream.BufferedOutputStream'.
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if the /@stream@/\'s buffer automatically grows,
    -- @FALSE@ otherwise.
bufferedOutputStreamGetAutoGrow stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_buffered_output_stream_get_auto_grow stream'
    let result' = (/= 0) result
    touchManagedPtr stream
    return result'

#if defined(ENABLE_OVERLOADING)
data BufferedOutputStreamGetAutoGrowMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsBufferedOutputStream a) => O.OverloadedMethod BufferedOutputStreamGetAutoGrowMethodInfo a signature where
    overloadedMethod = bufferedOutputStreamGetAutoGrow

instance O.OverloadedMethodInfo BufferedOutputStreamGetAutoGrowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedOutputStream.bufferedOutputStreamGetAutoGrow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedOutputStream.html#v:bufferedOutputStreamGetAutoGrow"
        })


#endif

-- method BufferedOutputStream::get_buffer_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BufferedOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.BufferedOutputStream]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_buffered_output_stream_get_buffer_size" g_buffered_output_stream_get_buffer_size :: 
    Ptr BufferedOutputStream ->             -- stream : TInterface (Name {namespace = "Gio", name = "BufferedOutputStream"})
    IO FCT.CSize

-- | Gets the size of the buffer in the /@stream@/.
bufferedOutputStreamGetBufferSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsBufferedOutputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.BufferedOutputStream.BufferedOutputStream'.
    -> m FCT.CSize
    -- ^ __Returns:__ the current size of the buffer.
bufferedOutputStreamGetBufferSize stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_buffered_output_stream_get_buffer_size stream'
    touchManagedPtr stream
    return result

#if defined(ENABLE_OVERLOADING)
data BufferedOutputStreamGetBufferSizeMethodInfo
instance (signature ~ (m FCT.CSize), MonadIO m, IsBufferedOutputStream a) => O.OverloadedMethod BufferedOutputStreamGetBufferSizeMethodInfo a signature where
    overloadedMethod = bufferedOutputStreamGetBufferSize

instance O.OverloadedMethodInfo BufferedOutputStreamGetBufferSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedOutputStream.bufferedOutputStreamGetBufferSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedOutputStream.html#v:bufferedOutputStreamGetBufferSize"
        })


#endif

-- method BufferedOutputStream::set_auto_grow
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BufferedOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.BufferedOutputStream]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "auto_grow"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gboolean." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_buffered_output_stream_set_auto_grow" g_buffered_output_stream_set_auto_grow :: 
    Ptr BufferedOutputStream ->             -- stream : TInterface (Name {namespace = "Gio", name = "BufferedOutputStream"})
    CInt ->                                 -- auto_grow : TBasicType TBoolean
    IO ()

-- | Sets whether or not the /@stream@/\'s buffer should automatically grow.
-- If /@autoGrow@/ is true, then each write will just make the buffer
-- larger, and you must manually flush the buffer to actually write out
-- the data to the underlying stream.
bufferedOutputStreamSetAutoGrow ::
    (B.CallStack.HasCallStack, MonadIO m, IsBufferedOutputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.BufferedOutputStream.BufferedOutputStream'.
    -> Bool
    -- ^ /@autoGrow@/: a t'P.Bool'.
    -> m ()
bufferedOutputStreamSetAutoGrow stream autoGrow = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    let autoGrow' = (P.fromIntegral . P.fromEnum) autoGrow
    g_buffered_output_stream_set_auto_grow stream' autoGrow'
    touchManagedPtr stream
    return ()

#if defined(ENABLE_OVERLOADING)
data BufferedOutputStreamSetAutoGrowMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsBufferedOutputStream a) => O.OverloadedMethod BufferedOutputStreamSetAutoGrowMethodInfo a signature where
    overloadedMethod = bufferedOutputStreamSetAutoGrow

instance O.OverloadedMethodInfo BufferedOutputStreamSetAutoGrowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedOutputStream.bufferedOutputStreamSetAutoGrow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedOutputStream.html#v:bufferedOutputStreamSetAutoGrow"
        })


#endif

-- method BufferedOutputStream::set_buffer_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BufferedOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.BufferedOutputStream]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gsize." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_buffered_output_stream_set_buffer_size" g_buffered_output_stream_set_buffer_size :: 
    Ptr BufferedOutputStream ->             -- stream : TInterface (Name {namespace = "Gio", name = "BufferedOutputStream"})
    FCT.CSize ->                            -- size : TBasicType TSize
    IO ()

-- | Sets the size of the internal buffer to /@size@/.
bufferedOutputStreamSetBufferSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsBufferedOutputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.BufferedOutputStream.BufferedOutputStream'.
    -> FCT.CSize
    -- ^ /@size@/: a @/gsize/@.
    -> m ()
bufferedOutputStreamSetBufferSize stream size = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    g_buffered_output_stream_set_buffer_size stream' size
    touchManagedPtr stream
    return ()

#if defined(ENABLE_OVERLOADING)
data BufferedOutputStreamSetBufferSizeMethodInfo
instance (signature ~ (FCT.CSize -> m ()), MonadIO m, IsBufferedOutputStream a) => O.OverloadedMethod BufferedOutputStreamSetBufferSizeMethodInfo a signature where
    overloadedMethod = bufferedOutputStreamSetBufferSize

instance O.OverloadedMethodInfo BufferedOutputStreamSetBufferSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.BufferedOutputStream.bufferedOutputStreamSetBufferSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-BufferedOutputStream.html#v:bufferedOutputStreamSetBufferSize"
        })


#endif


