{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The purpose of the t'GI.Gdk.Objects.DisplayManager.DisplayManager' singleton object is to offer
-- notification when displays appear or disappear or the default display
-- changes.
-- 
-- You can use 'GI.Gdk.Objects.DisplayManager.displayManagerGet' to obtain the t'GI.Gdk.Objects.DisplayManager.DisplayManager'
-- singleton, but that should be rarely necessary. Typically, initializing
-- GTK+ opens a display that you can work with without ever accessing the
-- t'GI.Gdk.Objects.DisplayManager.DisplayManager'.
-- 
-- The GDK library can be built with support for multiple backends.
-- The t'GI.Gdk.Objects.DisplayManager.DisplayManager' object determines which backend is used
-- at runtime.
-- 
-- When writing backend-specific code that is supposed to work with
-- multiple GDK backends, you have to consider both compile time and
-- runtime. At compile time, use the @/GDK_WINDOWING_X11/@, @/GDK_WINDOWING_WIN32/@
-- macros, etc. to find out which backends are present in the GDK library
-- you are building your application against. At runtime, use type-check
-- macros like @/GDK_IS_X11_DISPLAY()/@ to find out which backend is in use:
-- 
-- ## Backend-specific code ## {@/backend/@-specific}
-- 
-- 
-- === /C code/
-- >
-- >#ifdef GDK_WINDOWING_X11
-- >  if (GDK_IS_X11_DISPLAY (display))
-- >    {
-- >      // make X11-specific calls here
-- >    }
-- >  else
-- >#endif
-- >#ifdef GDK_WINDOWING_QUARTZ
-- >  if (GDK_IS_QUARTZ_DISPLAY (display))
-- >    {
-- >      // make Quartz-specific calls here
-- >    }
-- >  else
-- >#endif
-- >  g_error ("Unsupported GDK backend");
-- 

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.DisplayManager
    ( 

-- * Exported types
    DisplayManager(..)                      ,
    IsDisplayManager                        ,
    toDisplayManager                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [listDisplays]("GI.Gdk.Objects.DisplayManager#g:method:listDisplays"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [openDisplay]("GI.Gdk.Objects.DisplayManager#g:method:openDisplay"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDefaultDisplay]("GI.Gdk.Objects.DisplayManager#g:method:getDefaultDisplay"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDefaultDisplay]("GI.Gdk.Objects.DisplayManager#g:method:setDefaultDisplay"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDisplayManagerMethod             ,
#endif

-- ** get #method:get#

    displayManagerGet                       ,


-- ** getDefaultDisplay #method:getDefaultDisplay#

#if defined(ENABLE_OVERLOADING)
    DisplayManagerGetDefaultDisplayMethodInfo,
#endif
    displayManagerGetDefaultDisplay         ,


-- ** listDisplays #method:listDisplays#

#if defined(ENABLE_OVERLOADING)
    DisplayManagerListDisplaysMethodInfo    ,
#endif
    displayManagerListDisplays              ,


-- ** openDisplay #method:openDisplay#

#if defined(ENABLE_OVERLOADING)
    DisplayManagerOpenDisplayMethodInfo     ,
#endif
    displayManagerOpenDisplay               ,


-- ** setDefaultDisplay #method:setDefaultDisplay#

#if defined(ENABLE_OVERLOADING)
    DisplayManagerSetDefaultDisplayMethodInfo,
#endif
    displayManagerSetDefaultDisplay         ,




 -- * Properties


-- ** defaultDisplay #attr:defaultDisplay#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    DisplayManagerDefaultDisplayPropertyInfo,
#endif
    constructDisplayManagerDefaultDisplay   ,
#if defined(ENABLE_OVERLOADING)
    displayManagerDefaultDisplay            ,
#endif
    getDisplayManagerDefaultDisplay         ,
    setDisplayManagerDefaultDisplay         ,




 -- * Signals


-- ** displayOpened #signal:displayOpened#

    DisplayManagerDisplayOpenedCallback     ,
#if defined(ENABLE_OVERLOADING)
    DisplayManagerDisplayOpenedSignalInfo   ,
#endif
    afterDisplayManagerDisplayOpened        ,
    onDisplayManagerDisplayOpened           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display

#endif

-- | Memory-managed wrapper type.
newtype DisplayManager = DisplayManager (SP.ManagedPtr DisplayManager)
    deriving (Eq)

instance SP.ManagedPtrNewtype DisplayManager where
    toManagedPtr (DisplayManager p) = p

foreign import ccall "gdk_display_manager_get_type"
    c_gdk_display_manager_get_type :: IO B.Types.GType

instance B.Types.TypedObject DisplayManager where
    glibType = c_gdk_display_manager_get_type

instance B.Types.GObject DisplayManager

-- | Type class for types which can be safely cast to t'DisplayManager', for instance with `toDisplayManager`.
class (SP.GObject o, O.IsDescendantOf DisplayManager o) => IsDisplayManager o
instance (SP.GObject o, O.IsDescendantOf DisplayManager o) => IsDisplayManager o

instance O.HasParentTypes DisplayManager
type instance O.ParentTypes DisplayManager = '[GObject.Object.Object]

-- | Cast to t'DisplayManager', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDisplayManager :: (MIO.MonadIO m, IsDisplayManager o) => o -> m DisplayManager
toDisplayManager = MIO.liftIO . B.ManagedPtr.unsafeCastTo DisplayManager

-- | Convert t'DisplayManager' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DisplayManager) where
    gvalueGType_ = c_gdk_display_manager_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DisplayManager)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DisplayManager)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DisplayManager ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDisplayManagerMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDisplayManagerMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDisplayManagerMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDisplayManagerMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDisplayManagerMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDisplayManagerMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDisplayManagerMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDisplayManagerMethod "listDisplays" o = DisplayManagerListDisplaysMethodInfo
    ResolveDisplayManagerMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDisplayManagerMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDisplayManagerMethod "openDisplay" o = DisplayManagerOpenDisplayMethodInfo
    ResolveDisplayManagerMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDisplayManagerMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDisplayManagerMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDisplayManagerMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDisplayManagerMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDisplayManagerMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDisplayManagerMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDisplayManagerMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDisplayManagerMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDisplayManagerMethod "getDefaultDisplay" o = DisplayManagerGetDefaultDisplayMethodInfo
    ResolveDisplayManagerMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDisplayManagerMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDisplayManagerMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDisplayManagerMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDisplayManagerMethod "setDefaultDisplay" o = DisplayManagerSetDefaultDisplayMethodInfo
    ResolveDisplayManagerMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDisplayManagerMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDisplayManagerMethod t DisplayManager, O.OverloadedMethod info DisplayManager p) => OL.IsLabel t (DisplayManager -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDisplayManagerMethod t DisplayManager, O.OverloadedMethod info DisplayManager p, R.HasField t DisplayManager p) => R.HasField t DisplayManager p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDisplayManagerMethod t DisplayManager, O.OverloadedMethodInfo info DisplayManager) => OL.IsLabel t (O.MethodProxy info DisplayManager) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal DisplayManager::display-opened
-- | The [displayOpened](#g:signal:displayOpened) signal is emitted when a display is opened.
-- 
-- /Since: 2.2/
type DisplayManagerDisplayOpenedCallback =
    Gdk.Display.Display
    -- ^ /@display@/: the opened display
    -> IO ()

type C_DisplayManagerDisplayOpenedCallback =
    Ptr DisplayManager ->                   -- object
    Ptr Gdk.Display.Display ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DisplayManagerDisplayOpenedCallback`.
foreign import ccall "wrapper"
    mk_DisplayManagerDisplayOpenedCallback :: C_DisplayManagerDisplayOpenedCallback -> IO (FunPtr C_DisplayManagerDisplayOpenedCallback)

wrap_DisplayManagerDisplayOpenedCallback :: 
    GObject a => (a -> DisplayManagerDisplayOpenedCallback) ->
    C_DisplayManagerDisplayOpenedCallback
wrap_DisplayManagerDisplayOpenedCallback gi'cb gi'selfPtr display _ = do
    display' <- (newObject Gdk.Display.Display) display
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  display'


-- | Connect a signal handler for the [displayOpened](#signal:displayOpened) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' displayManager #displayOpened callback
-- @
-- 
-- 
onDisplayManagerDisplayOpened :: (IsDisplayManager a, MonadIO m) => a -> ((?self :: a) => DisplayManagerDisplayOpenedCallback) -> m SignalHandlerId
onDisplayManagerDisplayOpened obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplayManagerDisplayOpenedCallback wrapped
    wrapped'' <- mk_DisplayManagerDisplayOpenedCallback wrapped'
    connectSignalFunPtr obj "display-opened" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [displayOpened](#signal:displayOpened) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' displayManager #displayOpened callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDisplayManagerDisplayOpened :: (IsDisplayManager a, MonadIO m) => a -> ((?self :: a) => DisplayManagerDisplayOpenedCallback) -> m SignalHandlerId
afterDisplayManagerDisplayOpened obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplayManagerDisplayOpenedCallback wrapped
    wrapped'' <- mk_DisplayManagerDisplayOpenedCallback wrapped'
    connectSignalFunPtr obj "display-opened" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DisplayManagerDisplayOpenedSignalInfo
instance SignalInfo DisplayManagerDisplayOpenedSignalInfo where
    type HaskellCallbackType DisplayManagerDisplayOpenedSignalInfo = DisplayManagerDisplayOpenedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DisplayManagerDisplayOpenedCallback cb
        cb'' <- mk_DisplayManagerDisplayOpenedCallback cb'
        connectSignalFunPtr obj "display-opened" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DisplayManager::display-opened"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DisplayManager.html#g:signal:displayOpened"})

#endif

-- VVV Prop "default-display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@default-display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' displayManager #defaultDisplay
-- @
getDisplayManagerDefaultDisplay :: (MonadIO m, IsDisplayManager o) => o -> m (Maybe Gdk.Display.Display)
getDisplayManagerDefaultDisplay obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "default-display" Gdk.Display.Display

-- | Set the value of the “@default-display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' displayManager [ #defaultDisplay 'Data.GI.Base.Attributes.:=' value ]
-- @
setDisplayManagerDefaultDisplay :: (MonadIO m, IsDisplayManager o, Gdk.Display.IsDisplay a) => o -> a -> m ()
setDisplayManagerDefaultDisplay obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "default-display" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@default-display@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDisplayManagerDefaultDisplay :: (IsDisplayManager o, MIO.MonadIO m, Gdk.Display.IsDisplay a) => a -> m (GValueConstruct o)
constructDisplayManagerDefaultDisplay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "default-display" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DisplayManagerDefaultDisplayPropertyInfo
instance AttrInfo DisplayManagerDefaultDisplayPropertyInfo where
    type AttrAllowedOps DisplayManagerDefaultDisplayPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DisplayManagerDefaultDisplayPropertyInfo = IsDisplayManager
    type AttrSetTypeConstraint DisplayManagerDefaultDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferTypeConstraint DisplayManagerDefaultDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferType DisplayManagerDefaultDisplayPropertyInfo = Gdk.Display.Display
    type AttrGetType DisplayManagerDefaultDisplayPropertyInfo = (Maybe Gdk.Display.Display)
    type AttrLabel DisplayManagerDefaultDisplayPropertyInfo = "default-display"
    type AttrOrigin DisplayManagerDefaultDisplayPropertyInfo = DisplayManager
    attrGet = getDisplayManagerDefaultDisplay
    attrSet = setDisplayManagerDefaultDisplay
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Display.Display v
    attrConstruct = constructDisplayManagerDefaultDisplay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DisplayManager.defaultDisplay"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DisplayManager.html#g:attr:defaultDisplay"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DisplayManager
type instance O.AttributeList DisplayManager = DisplayManagerAttributeList
type DisplayManagerAttributeList = ('[ '("defaultDisplay", DisplayManagerDefaultDisplayPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
displayManagerDefaultDisplay :: AttrLabelProxy "defaultDisplay"
displayManagerDefaultDisplay = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DisplayManager = DisplayManagerSignalList
type DisplayManagerSignalList = ('[ '("displayOpened", DisplayManagerDisplayOpenedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method DisplayManager::get_default_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "manager"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DisplayManager" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplayManager"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_manager_get_default_display" gdk_display_manager_get_default_display :: 
    Ptr DisplayManager ->                   -- manager : TInterface (Name {namespace = "Gdk", name = "DisplayManager"})
    IO (Ptr Gdk.Display.Display)

-- | Gets the default t'GI.Gdk.Objects.Display.Display'.
-- 
-- /Since: 2.2/
displayManagerGetDefaultDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplayManager a) =>
    a
    -- ^ /@manager@/: a t'GI.Gdk.Objects.DisplayManager.DisplayManager'
    -> m (Maybe Gdk.Display.Display)
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Display.Display', or 'P.Nothing' if
    --     there is no default display.
displayManagerGetDefaultDisplay manager = liftIO $ do
    manager' <- unsafeManagedPtrCastPtr manager
    result <- gdk_display_manager_get_default_display manager'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Display.Display) result'
        return result''
    touchManagedPtr manager
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DisplayManagerGetDefaultDisplayMethodInfo
instance (signature ~ (m (Maybe Gdk.Display.Display)), MonadIO m, IsDisplayManager a) => O.OverloadedMethod DisplayManagerGetDefaultDisplayMethodInfo a signature where
    overloadedMethod = displayManagerGetDefaultDisplay

instance O.OverloadedMethodInfo DisplayManagerGetDefaultDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DisplayManager.displayManagerGetDefaultDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DisplayManager.html#v:displayManagerGetDefaultDisplay"
        })


#endif

-- method DisplayManager::list_displays
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "manager"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DisplayManager" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplayManager"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGSList
--                  (TInterface Name { namespace = "Gdk" , name = "Display" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_manager_list_displays" gdk_display_manager_list_displays :: 
    Ptr DisplayManager ->                   -- manager : TInterface (Name {namespace = "Gdk", name = "DisplayManager"})
    IO (Ptr (GSList (Ptr Gdk.Display.Display)))

-- | List all currently open displays.
-- 
-- /Since: 2.2/
displayManagerListDisplays ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplayManager a) =>
    a
    -- ^ /@manager@/: a t'GI.Gdk.Objects.DisplayManager.DisplayManager'
    -> m [Gdk.Display.Display]
    -- ^ __Returns:__ a newly
    --     allocated t'GI.GLib.Structs.SList.SList' of t'GI.Gdk.Objects.Display.Display' objects. Free with @/g_slist_free()/@
    --     when you are done with it.
displayManagerListDisplays manager = liftIO $ do
    manager' <- unsafeManagedPtrCastPtr manager
    result <- gdk_display_manager_list_displays manager'
    result' <- unpackGSList result
    result'' <- mapM (newObject Gdk.Display.Display) result'
    g_slist_free result
    touchManagedPtr manager
    return result''

#if defined(ENABLE_OVERLOADING)
data DisplayManagerListDisplaysMethodInfo
instance (signature ~ (m [Gdk.Display.Display]), MonadIO m, IsDisplayManager a) => O.OverloadedMethod DisplayManagerListDisplaysMethodInfo a signature where
    overloadedMethod = displayManagerListDisplays

instance O.OverloadedMethodInfo DisplayManagerListDisplaysMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DisplayManager.displayManagerListDisplays",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DisplayManager.html#v:displayManagerListDisplays"
        })


#endif

-- method DisplayManager::open_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "manager"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DisplayManager" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplayManager"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the display to open"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_manager_open_display" gdk_display_manager_open_display :: 
    Ptr DisplayManager ->                   -- manager : TInterface (Name {namespace = "Gdk", name = "DisplayManager"})
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr Gdk.Display.Display)

-- | Opens a display.
-- 
-- /Since: 3.0/
displayManagerOpenDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplayManager a) =>
    a
    -- ^ /@manager@/: a t'GI.Gdk.Objects.DisplayManager.DisplayManager'
    -> T.Text
    -- ^ /@name@/: the name of the display to open
    -> m (Maybe Gdk.Display.Display)
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Display.Display', or 'P.Nothing' if the
    --     display could not be opened
displayManagerOpenDisplay manager name = liftIO $ do
    manager' <- unsafeManagedPtrCastPtr manager
    name' <- textToCString name
    result <- gdk_display_manager_open_display manager' name'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Display.Display) result'
        return result''
    touchManagedPtr manager
    freeMem name'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DisplayManagerOpenDisplayMethodInfo
instance (signature ~ (T.Text -> m (Maybe Gdk.Display.Display)), MonadIO m, IsDisplayManager a) => O.OverloadedMethod DisplayManagerOpenDisplayMethodInfo a signature where
    overloadedMethod = displayManagerOpenDisplay

instance O.OverloadedMethodInfo DisplayManagerOpenDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DisplayManager.displayManagerOpenDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DisplayManager.html#v:displayManagerOpenDisplay"
        })


#endif

-- method DisplayManager::set_default_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "manager"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DisplayManager" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplayManager"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_manager_set_default_display" gdk_display_manager_set_default_display :: 
    Ptr DisplayManager ->                   -- manager : TInterface (Name {namespace = "Gdk", name = "DisplayManager"})
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO ()

-- | Sets /@display@/ as the default display.
-- 
-- /Since: 2.2/
displayManagerSetDefaultDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplayManager a, Gdk.Display.IsDisplay b) =>
    a
    -- ^ /@manager@/: a t'GI.Gdk.Objects.DisplayManager.DisplayManager'
    -> b
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m ()
displayManagerSetDefaultDisplay manager display = liftIO $ do
    manager' <- unsafeManagedPtrCastPtr manager
    display' <- unsafeManagedPtrCastPtr display
    gdk_display_manager_set_default_display manager' display'
    touchManagedPtr manager
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayManagerSetDefaultDisplayMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsDisplayManager a, Gdk.Display.IsDisplay b) => O.OverloadedMethod DisplayManagerSetDefaultDisplayMethodInfo a signature where
    overloadedMethod = displayManagerSetDefaultDisplay

instance O.OverloadedMethodInfo DisplayManagerSetDefaultDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DisplayManager.displayManagerSetDefaultDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DisplayManager.html#v:displayManagerSetDefaultDisplay"
        })


#endif

-- method DisplayManager::get
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "DisplayManager" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_manager_get" gdk_display_manager_get :: 
    IO (Ptr DisplayManager)

-- | Gets the singleton t'GI.Gdk.Objects.DisplayManager.DisplayManager' object.
-- 
-- When called for the first time, this function consults the
-- @GDK_BACKEND@ environment variable to find out which
-- of the supported GDK backends to use (in case GDK has been compiled
-- with multiple backends). Applications can use 'GI.Gdk.Functions.setAllowedBackends'
-- to limit what backends can be used.
-- 
-- /Since: 2.2/
displayManagerGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m DisplayManager
    -- ^ __Returns:__ The global t'GI.Gdk.Objects.DisplayManager.DisplayManager' singleton;
    --     'GI.Gdk.Functions.parseArgs', 'GI.Gdk.Functions.init', or 'GI.Gdk.Functions.initCheck' must have
    --     been called first.
displayManagerGet  = liftIO $ do
    result <- gdk_display_manager_get
    checkUnexpectedReturnNULL "displayManagerGet" result
    result' <- (newObject DisplayManager) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


