{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An event related to a keyboard focus change.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.FocusEvent
    ( 

-- * Exported types
    FocusEvent(..)                          ,
    IsFocusEvent                            ,
    toFocusEvent                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [ref]("GI.Gdk.Objects.Event#g:method:ref"), [triggersContextMenu]("GI.Gdk.Objects.Event#g:method:triggersContextMenu"), [unref]("GI.Gdk.Objects.Event#g:method:unref").
-- 
-- ==== Getters
-- [getAxes]("GI.Gdk.Objects.Event#g:method:getAxes"), [getAxis]("GI.Gdk.Objects.Event#g:method:getAxis"), [getDevice]("GI.Gdk.Objects.Event#g:method:getDevice"), [getDeviceTool]("GI.Gdk.Objects.Event#g:method:getDeviceTool"), [getDisplay]("GI.Gdk.Objects.Event#g:method:getDisplay"), [getEventSequence]("GI.Gdk.Objects.Event#g:method:getEventSequence"), [getEventType]("GI.Gdk.Objects.Event#g:method:getEventType"), [getHistory]("GI.Gdk.Objects.Event#g:method:getHistory"), [getIn]("GI.Gdk.Objects.FocusEvent#g:method:getIn"), [getModifierState]("GI.Gdk.Objects.Event#g:method:getModifierState"), [getPointerEmulated]("GI.Gdk.Objects.Event#g:method:getPointerEmulated"), [getPosition]("GI.Gdk.Objects.Event#g:method:getPosition"), [getSeat]("GI.Gdk.Objects.Event#g:method:getSeat"), [getSurface]("GI.Gdk.Objects.Event#g:method:getSurface"), [getTime]("GI.Gdk.Objects.Event#g:method:getTime").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveFocusEventMethod                 ,
#endif

-- ** getIn #method:getIn#

#if defined(ENABLE_OVERLOADING)
    FocusEventGetInMethodInfo               ,
#endif
    focusEventGetIn                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event

#endif

-- | Memory-managed wrapper type.
newtype FocusEvent = FocusEvent (SP.ManagedPtr FocusEvent)
    deriving (Eq)

instance SP.ManagedPtrNewtype FocusEvent where
    toManagedPtr (FocusEvent p) = p

foreign import ccall "gdk_focus_event_get_type"
    c_gdk_focus_event_get_type :: IO B.Types.GType

instance B.Types.TypedObject FocusEvent where
    glibType = c_gdk_focus_event_get_type

-- | Type class for types which can be safely cast to t'FocusEvent', for instance with `toFocusEvent`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf FocusEvent o) => IsFocusEvent o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf FocusEvent o) => IsFocusEvent o

instance O.HasParentTypes FocusEvent
type instance O.ParentTypes FocusEvent = '[Gdk.Event.Event]

-- | Cast to t'FocusEvent', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toFocusEvent :: (MIO.MonadIO m, IsFocusEvent o) => o -> m FocusEvent
toFocusEvent = MIO.liftIO . B.ManagedPtr.unsafeCastTo FocusEvent

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveFocusEventMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFocusEventMethod "ref" o = Gdk.Event.EventRefMethodInfo
    ResolveFocusEventMethod "triggersContextMenu" o = Gdk.Event.EventTriggersContextMenuMethodInfo
    ResolveFocusEventMethod "unref" o = Gdk.Event.EventUnrefMethodInfo
    ResolveFocusEventMethod "getAxes" o = Gdk.Event.EventGetAxesMethodInfo
    ResolveFocusEventMethod "getAxis" o = Gdk.Event.EventGetAxisMethodInfo
    ResolveFocusEventMethod "getDevice" o = Gdk.Event.EventGetDeviceMethodInfo
    ResolveFocusEventMethod "getDeviceTool" o = Gdk.Event.EventGetDeviceToolMethodInfo
    ResolveFocusEventMethod "getDisplay" o = Gdk.Event.EventGetDisplayMethodInfo
    ResolveFocusEventMethod "getEventSequence" o = Gdk.Event.EventGetEventSequenceMethodInfo
    ResolveFocusEventMethod "getEventType" o = Gdk.Event.EventGetEventTypeMethodInfo
    ResolveFocusEventMethod "getHistory" o = Gdk.Event.EventGetHistoryMethodInfo
    ResolveFocusEventMethod "getIn" o = FocusEventGetInMethodInfo
    ResolveFocusEventMethod "getModifierState" o = Gdk.Event.EventGetModifierStateMethodInfo
    ResolveFocusEventMethod "getPointerEmulated" o = Gdk.Event.EventGetPointerEmulatedMethodInfo
    ResolveFocusEventMethod "getPosition" o = Gdk.Event.EventGetPositionMethodInfo
    ResolveFocusEventMethod "getSeat" o = Gdk.Event.EventGetSeatMethodInfo
    ResolveFocusEventMethod "getSurface" o = Gdk.Event.EventGetSurfaceMethodInfo
    ResolveFocusEventMethod "getTime" o = Gdk.Event.EventGetTimeMethodInfo
    ResolveFocusEventMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFocusEventMethod t FocusEvent, O.OverloadedMethod info FocusEvent p) => OL.IsLabel t (FocusEvent -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFocusEventMethod t FocusEvent, O.OverloadedMethod info FocusEvent p, R.HasField t FocusEvent p) => R.HasField t FocusEvent p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFocusEventMethod t FocusEvent, O.OverloadedMethodInfo info FocusEvent) => OL.IsLabel t (O.MethodProxy info FocusEvent) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr FocusEvent where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method FocusEvent::get_in
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FocusEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a focus change event"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_focus_event_get_in" gdk_focus_event_get_in :: 
    Ptr FocusEvent ->                       -- event : TInterface (Name {namespace = "Gdk", name = "FocusEvent"})
    IO CInt

-- | Extracts whether this event is about focus entering or
-- leaving the surface.
focusEventGetIn ::
    (B.CallStack.HasCallStack, MonadIO m, IsFocusEvent a) =>
    a
    -- ^ /@event@/: a focus change event
    -> m Bool
    -- ^ __Returns:__ 'P.True' of the focus is entering
focusEventGetIn event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_focus_event_get_in event'
    let result' = (/= 0) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data FocusEventGetInMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFocusEvent a) => O.OverloadedMethod FocusEventGetInMethodInfo a signature where
    overloadedMethod = focusEventGetIn

instance O.OverloadedMethodInfo FocusEventGetInMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FocusEvent.focusEventGetIn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-FocusEvent.html#v:focusEventGetIn"
        })


#endif


