/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, analog, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_analog_ctcss_squelch_ff = R"doc(gate or zero output if CTCSS tone not present

Constructor Specific Documentation:

Make CTCSS tone squelch block.

Args:
    rate : gain of the internal frequency filters.
    freq : frequency value to use as the squelch tone.
    level : threshold level for the squelch tone.
    len : length of the frequency filters.
    ramp : attack / release time in samples; a sinusodial ramp is used. set to 0 to disable.
    gate : if true, no output if no squelch tone. if false, output 0's if no squelch tone.)doc";


static const char* __doc_gr_analog_ctcss_squelch_ff_ctcss_squelch_ff_0 = R"doc()doc";


static const char* __doc_gr_analog_ctcss_squelch_ff_ctcss_squelch_ff_1 = R"doc()doc";


static const char* __doc_gr_analog_ctcss_squelch_ff_make = R"doc(gate or zero output if CTCSS tone not present

Constructor Specific Documentation:

Make CTCSS tone squelch block.

Args:
    rate : gain of the internal frequency filters.
    freq : frequency value to use as the squelch tone.
    level : threshold level for the squelch tone.
    len : length of the frequency filters.
    ramp : attack / release time in samples; a sinusodial ramp is used. set to 0 to disable.
    gate : if true, no output if no squelch tone. if false, output 0's if no squelch tone.)doc";


static const char* __doc_gr_analog_ctcss_squelch_ff_squelch_range = R"doc()doc";


static const char* __doc_gr_analog_ctcss_squelch_ff_level = R"doc()doc";


static const char* __doc_gr_analog_ctcss_squelch_ff_set_level = R"doc()doc";


static const char* __doc_gr_analog_ctcss_squelch_ff_len = R"doc()doc";


static const char* __doc_gr_analog_ctcss_squelch_ff_frequency = R"doc()doc";


static const char* __doc_gr_analog_ctcss_squelch_ff_set_frequency = R"doc()doc";


static const char* __doc_gr_analog_ctcss_squelch_ff_ramp = R"doc()doc";


static const char* __doc_gr_analog_ctcss_squelch_ff_set_ramp = R"doc()doc";


static const char* __doc_gr_analog_ctcss_squelch_ff_gate = R"doc()doc";


static const char* __doc_gr_analog_ctcss_squelch_ff_set_gate = R"doc()doc";


static const char* __doc_gr_analog_ctcss_squelch_ff_unmuted = R"doc()doc";
