/* history.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from history.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of GNOME Tetravex.

   Copyright (C) 2010-2013 Robert Ancell
   Copyright (C) 2019 Arnaud Bonatti

   GNOME Tetravex is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   GNOME Tetravex is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this GNOME Tetravex.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
typedef struct _HistoryPrivate HistoryPrivate;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
enum  {
	HISTORY_0_PROPERTY,
	HISTORY_FILENAME_PROPERTY,
	HISTORY_NUM_PROPERTIES
};
static GParamSpec* history_properties[HISTORY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
enum  {
	HISTORY_ENTRY_ADDED_SIGNAL,
	HISTORY_NUM_SIGNALS
};
static guint history_signals[HISTORY_NUM_SIGNALS] = {0};
typedef struct _HistoryEntryPrivate HistoryEntryPrivate;
enum  {
	HISTORY_ENTRY_0_PROPERTY,
	HISTORY_ENTRY_DATE_PROPERTY,
	HISTORY_ENTRY_SIZE_PROPERTY,
	HISTORY_ENTRY_DURATION_PROPERTY,
	HISTORY_ENTRY_INT_DURATION_PROPERTY,
	HISTORY_ENTRY_NUM_PROPERTIES
};
static GParamSpec* history_entry_properties[HISTORY_ENTRY_NUM_PROPERTIES];

struct _History {
	GObject parent_instance;
	HistoryPrivate * priv;
	GList* entries;
};

struct _HistoryClass {
	GObjectClass parent_class;
};

struct _HistoryPrivate {
	gchar* _filename;
};

struct _HistoryEntry {
	GObject parent_instance;
	HistoryEntryPrivate * priv;
};

struct _HistoryEntryClass {
	GObjectClass parent_class;
};

struct _HistoryEntryPrivate {
	GDateTime* _date;
	guint8 _size;
	gdouble _duration;
	gboolean _int_duration;
};

static gint History_private_offset;
static gpointer history_parent_class = NULL;
static gint HistoryEntry_private_offset;
static gpointer history_entry_parent_class = NULL;

VALA_EXTERN GType history_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (History, g_object_unref)
VALA_EXTERN GType history_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryEntry, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN guint history_get_place (History* self,
                         HistoryEntry* entry,
                         guint8 puzzle_size,
                         HistoryEntry** other_entry_0,
                         HistoryEntry** other_entry_1,
                         HistoryEntry** other_entry_2);
static gint history_compare_entries (HistoryEntry* a,
                              HistoryEntry* b);
static gint _history_compare_entries_gcompare_func (gconstpointer a,
                                             gconstpointer b);
static inline void history_save (History* self);
static guint history_get_best_time_position (History* self,
                                      GList* entry_item,
                                      GList** best_time_item);
VALA_EXTERN guint8 history_entry_get_size (HistoryEntry* self);
VALA_EXTERN gboolean history_is_empty (History* self);
VALA_EXTERN void history_get_fallback_scores (History* self,
                                  guint8 puzzle_size,
                                  HistoryEntry** fallback_score_0,
                                  HistoryEntry** fallback_score_1,
                                  HistoryEntry** fallback_score_2,
                                  HistoryEntry** fallback_score_3);
VALA_EXTERN History* history_new (const gchar* filename);
VALA_EXTERN History* history_construct (GType object_type,
                            const gchar* filename);
static inline void history_load (History* self);
static const gchar* history_get_filename (History* self);
VALA_EXTERN HistoryEntry* history_entry_new (GDateTime* date,
                                 guint8 size,
                                 gdouble duration,
                                 gboolean int_duration);
VALA_EXTERN HistoryEntry* history_entry_construct (GType object_type,
                                       GDateTime* date,
                                       guint8 size,
                                       gdouble duration,
                                       gboolean int_duration);
VALA_EXTERN gboolean history_entry_get_int_duration (HistoryEntry* self);
VALA_EXTERN GDateTime* history_entry_get_date (HistoryEntry* self);
VALA_EXTERN gdouble history_entry_get_duration (HistoryEntry* self);
static void history_set_filename (History* self,
                           const gchar* value);
static void history_finalize (GObject * obj);
static GType history_get_type_once (void);
static void _vala_history_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec);
static void _vala_history_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec);
VALA_EXTERN gchar* history_entry_get_duration_string (HistoryEntry* entry);
static void history_entry_set_date (HistoryEntry* self,
                             GDateTime* value);
static void history_entry_set_size (HistoryEntry* self,
                             guint8 value);
static void history_entry_set_duration (HistoryEntry* self,
                                 gdouble value);
static void history_entry_set_int_duration (HistoryEntry* self,
                                     gboolean value);
static void history_entry_finalize (GObject * obj);
static GType history_entry_get_type_once (void);
static void _vala_history_entry_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_history_entry_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
history_get_instance_private (History* self)
{
	return G_STRUCT_MEMBER_P (self, History_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
_history_compare_entries_gcompare_func (gconstpointer a,
                                        gconstpointer b)
{
	gint result;
	result = history_compare_entries ((HistoryEntry*) a, (HistoryEntry*) b);
	return result;
}

guint
history_get_place (History* self,
                   HistoryEntry* entry,
                   guint8 puzzle_size,
                   HistoryEntry** other_entry_0,
                   HistoryEntry** other_entry_1,
                   HistoryEntry** other_entry_2)
{
	HistoryEntry* _vala_other_entry_0 = NULL;
	HistoryEntry* _vala_other_entry_1 = NULL;
	HistoryEntry* _vala_other_entry_2 = NULL;
	HistoryEntry* _tmp0_;
	GList* entry_item = NULL;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* best_time_item = NULL;
	guint best_position = 0U;
	GList* _tmp3_;
	GList* _tmp4_ = NULL;
	guint _tmp5_;
	guint position = 0U;
	GList* _tmp6_;
	GList* _tmp7_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (entry != NULL, 0U);
	_tmp0_ = _g_object_ref0 (entry);
	self->entries = g_list_insert_sorted (self->entries, _tmp0_, _history_compare_entries_gcompare_func);
	g_signal_emit (self, history_signals[HISTORY_ENTRY_ADDED_SIGNAL], 0, entry);
	history_save (self);
	_tmp1_ = self->entries;
	_tmp2_ = g_list_find (_tmp1_, entry);
	entry_item = _tmp2_;
	_tmp3_ = entry_item;
	_tmp5_ = history_get_best_time_position (self, _tmp3_, &_tmp4_);
	best_time_item = _tmp4_;
	best_position = _tmp5_;
	_tmp6_ = self->entries;
	_tmp7_ = entry_item;
	position = (g_list_position (_tmp6_, _tmp7_) - best_position) + 1;
	switch (position) {
		case 1:
		{
			GList* tmp_item = NULL;
			GList* _tmp8_;
			GList* _tmp9_;
			gboolean _tmp10_ = FALSE;
			GList* _tmp11_;
			GList* _tmp16_;
			gconstpointer _tmp17_;
			HistoryEntry* _tmp18_;
			GList* _tmp19_;
			GList* _tmp20_;
			gboolean _tmp21_ = FALSE;
			GList* _tmp22_;
			GList* _tmp27_;
			gconstpointer _tmp28_;
			HistoryEntry* _tmp29_;
			GList* _tmp30_;
			GList* _tmp31_;
			gboolean _tmp32_ = FALSE;
			GList* _tmp33_;
			_tmp8_ = entry_item;
			_tmp9_ = _tmp8_->next;
			tmp_item = _tmp9_;
			_tmp11_ = tmp_item;
			if (_tmp11_ == NULL) {
				_tmp10_ = TRUE;
			} else {
				GList* _tmp12_;
				gconstpointer _tmp13_;
				guint8 _tmp14_;
				guint8 _tmp15_;
				_tmp12_ = tmp_item;
				_tmp13_ = ((GList*) _tmp12_)->data;
				_tmp14_ = history_entry_get_size ((HistoryEntry*) _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp10_ = _tmp15_ != puzzle_size;
			}
			if (_tmp10_) {
				_g_object_unref0 (_vala_other_entry_0);
				_vala_other_entry_0 = NULL;
				_g_object_unref0 (_vala_other_entry_1);
				_vala_other_entry_1 = NULL;
				_g_object_unref0 (_vala_other_entry_2);
				_vala_other_entry_2 = NULL;
				break;
			}
			_tmp16_ = tmp_item;
			_tmp17_ = ((GList*) _tmp16_)->data;
			_tmp18_ = _g_object_ref0 ((HistoryEntry*) _tmp17_);
			_g_object_unref0 (_vala_other_entry_0);
			_vala_other_entry_0 = _tmp18_;
			_tmp19_ = tmp_item;
			_tmp20_ = ((GList*) _tmp19_)->next;
			tmp_item = _tmp20_;
			_tmp22_ = tmp_item;
			if (_tmp22_ == NULL) {
				_tmp21_ = TRUE;
			} else {
				GList* _tmp23_;
				gconstpointer _tmp24_;
				guint8 _tmp25_;
				guint8 _tmp26_;
				_tmp23_ = tmp_item;
				_tmp24_ = ((GList*) _tmp23_)->data;
				_tmp25_ = history_entry_get_size ((HistoryEntry*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp21_ = _tmp26_ != puzzle_size;
			}
			if (_tmp21_) {
				_g_object_unref0 (_vala_other_entry_1);
				_vala_other_entry_1 = NULL;
				_g_object_unref0 (_vala_other_entry_2);
				_vala_other_entry_2 = NULL;
				break;
			}
			_tmp27_ = tmp_item;
			_tmp28_ = ((GList*) _tmp27_)->data;
			_tmp29_ = _g_object_ref0 ((HistoryEntry*) _tmp28_);
			_g_object_unref0 (_vala_other_entry_1);
			_vala_other_entry_1 = _tmp29_;
			_tmp30_ = tmp_item;
			_tmp31_ = ((GList*) _tmp30_)->next;
			tmp_item = _tmp31_;
			_tmp33_ = tmp_item;
			if (_tmp33_ == NULL) {
				_tmp32_ = TRUE;
			} else {
				GList* _tmp34_;
				gconstpointer _tmp35_;
				guint8 _tmp36_;
				guint8 _tmp37_;
				_tmp34_ = tmp_item;
				_tmp35_ = ((GList*) _tmp34_)->data;
				_tmp36_ = history_entry_get_size ((HistoryEntry*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp32_ = _tmp37_ != puzzle_size;
			}
			if (_tmp32_) {
				_g_object_unref0 (_vala_other_entry_2);
				_vala_other_entry_2 = NULL;
			} else {
				GList* _tmp38_;
				gconstpointer _tmp39_;
				HistoryEntry* _tmp40_;
				_tmp38_ = tmp_item;
				_tmp39_ = ((GList*) _tmp38_)->data;
				_tmp40_ = _g_object_ref0 ((HistoryEntry*) _tmp39_);
				_g_object_unref0 (_vala_other_entry_2);
				_vala_other_entry_2 = _tmp40_;
			}
			break;
		}
		case 2:
		{
			GList* _tmp41_;
			gconstpointer _tmp42_;
			HistoryEntry* _tmp43_;
			GList* tmp_item = NULL;
			GList* _tmp44_;
			GList* _tmp45_;
			gboolean _tmp46_ = FALSE;
			GList* _tmp47_;
			GList* _tmp52_;
			gconstpointer _tmp53_;
			HistoryEntry* _tmp54_;
			GList* _tmp55_;
			GList* _tmp56_;
			gboolean _tmp57_ = FALSE;
			GList* _tmp58_;
			_tmp41_ = best_time_item;
			_tmp42_ = _tmp41_->data;
			_tmp43_ = _g_object_ref0 ((HistoryEntry*) _tmp42_);
			_g_object_unref0 (_vala_other_entry_0);
			_vala_other_entry_0 = _tmp43_;
			_tmp44_ = entry_item;
			_tmp45_ = _tmp44_->next;
			tmp_item = _tmp45_;
			_tmp47_ = tmp_item;
			if (_tmp47_ == NULL) {
				_tmp46_ = TRUE;
			} else {
				GList* _tmp48_;
				gconstpointer _tmp49_;
				guint8 _tmp50_;
				guint8 _tmp51_;
				_tmp48_ = tmp_item;
				_tmp49_ = ((GList*) _tmp48_)->data;
				_tmp50_ = history_entry_get_size ((HistoryEntry*) _tmp49_);
				_tmp51_ = _tmp50_;
				_tmp46_ = _tmp51_ != puzzle_size;
			}
			if (_tmp46_) {
				_g_object_unref0 (_vala_other_entry_1);
				_vala_other_entry_1 = NULL;
				_g_object_unref0 (_vala_other_entry_2);
				_vala_other_entry_2 = NULL;
				break;
			}
			_tmp52_ = tmp_item;
			_tmp53_ = ((GList*) _tmp52_)->data;
			_tmp54_ = _g_object_ref0 ((HistoryEntry*) _tmp53_);
			_g_object_unref0 (_vala_other_entry_1);
			_vala_other_entry_1 = _tmp54_;
			_tmp55_ = tmp_item;
			_tmp56_ = ((GList*) _tmp55_)->next;
			tmp_item = _tmp56_;
			_tmp58_ = tmp_item;
			if (_tmp58_ == NULL) {
				_tmp57_ = TRUE;
			} else {
				GList* _tmp59_;
				gconstpointer _tmp60_;
				guint8 _tmp61_;
				guint8 _tmp62_;
				_tmp59_ = tmp_item;
				_tmp60_ = ((GList*) _tmp59_)->data;
				_tmp61_ = history_entry_get_size ((HistoryEntry*) _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp57_ = _tmp62_ != puzzle_size;
			}
			if (_tmp57_) {
				_g_object_unref0 (_vala_other_entry_2);
				_vala_other_entry_2 = NULL;
			} else {
				GList* _tmp63_;
				gconstpointer _tmp64_;
				HistoryEntry* _tmp65_;
				_tmp63_ = tmp_item;
				_tmp64_ = ((GList*) _tmp63_)->data;
				_tmp65_ = _g_object_ref0 ((HistoryEntry*) _tmp64_);
				_g_object_unref0 (_vala_other_entry_2);
				_vala_other_entry_2 = _tmp65_;
			}
			break;
		}
		default:
		{
			GList* _tmp66_;
			gconstpointer _tmp67_;
			HistoryEntry* _tmp68_;
			GList* _tmp69_;
			GList* _tmp70_;
			gconstpointer _tmp71_;
			HistoryEntry* _tmp72_;
			GList* next_entry_item = NULL;
			GList* _tmp73_;
			GList* _tmp74_;
			gboolean _tmp75_ = FALSE;
			GList* _tmp76_;
			_tmp66_ = best_time_item;
			_tmp67_ = _tmp66_->data;
			_tmp68_ = _g_object_ref0 ((HistoryEntry*) _tmp67_);
			_g_object_unref0 (_vala_other_entry_0);
			_vala_other_entry_0 = _tmp68_;
			_tmp69_ = entry_item;
			_tmp70_ = _tmp69_->prev;
			_tmp71_ = _tmp70_->data;
			_tmp72_ = _g_object_ref0 ((HistoryEntry*) _tmp71_);
			_g_object_unref0 (_vala_other_entry_1);
			_vala_other_entry_1 = _tmp72_;
			_tmp73_ = entry_item;
			_tmp74_ = _tmp73_->next;
			next_entry_item = _tmp74_;
			_tmp76_ = next_entry_item;
			if (_tmp76_ == NULL) {
				_tmp75_ = TRUE;
			} else {
				GList* _tmp77_;
				gconstpointer _tmp78_;
				guint8 _tmp79_;
				guint8 _tmp80_;
				_tmp77_ = next_entry_item;
				_tmp78_ = ((GList*) _tmp77_)->data;
				_tmp79_ = history_entry_get_size ((HistoryEntry*) _tmp78_);
				_tmp80_ = _tmp79_;
				_tmp75_ = _tmp80_ != puzzle_size;
			}
			if (_tmp75_) {
				_g_object_unref0 (_vala_other_entry_2);
				_vala_other_entry_2 = NULL;
			} else {
				GList* _tmp81_;
				gconstpointer _tmp82_;
				HistoryEntry* _tmp83_;
				_tmp81_ = next_entry_item;
				_tmp82_ = ((GList*) _tmp81_)->data;
				_tmp83_ = _g_object_ref0 ((HistoryEntry*) _tmp82_);
				_g_object_unref0 (_vala_other_entry_2);
				_vala_other_entry_2 = _tmp83_;
			}
			break;
		}
	}
	result = position;
	if (other_entry_0) {
		*other_entry_0 = _vala_other_entry_0;
	} else {
		_g_object_unref0 (_vala_other_entry_0);
	}
	if (other_entry_1) {
		*other_entry_1 = _vala_other_entry_1;
	} else {
		_g_object_unref0 (_vala_other_entry_1);
	}
	if (other_entry_2) {
		*other_entry_2 = _vala_other_entry_2;
	} else {
		_g_object_unref0 (_vala_other_entry_2);
	}
	return result;
}

static guint
history_get_best_time_position (History* self,
                                GList* entry_item,
                                GList** best_time_item)
{
	GList* _vala_best_time_item = NULL;
	guint8 puzzle_size = 0U;
	gconstpointer _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GList* _tmp17_;
	GList* _tmp18_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = entry_item->data;
	_tmp1_ = history_entry_get_size ((HistoryEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	puzzle_size = _tmp2_;
	_tmp3_ = self->entries;
	_tmp4_ = g_list_first (_tmp3_);
	_vala_best_time_item = _tmp4_;
	if (((gint) puzzle_size) == 2) {
		_tmp5_ = TRUE;
	} else {
		GList* _tmp6_;
		_tmp6_ = _vala_best_time_item;
		_tmp5_ = entry_item == _tmp6_;
	}
	if (_tmp5_) {
		result = (guint) 0;
		if (best_time_item) {
			*best_time_item = _vala_best_time_item;
		}
		return result;
	}
	_vala_best_time_item = entry_item;
	{
		gboolean _tmp7_ = FALSE;
		_tmp7_ = TRUE;
		while (TRUE) {
			GList* _tmp15_;
			GList* _tmp16_;
			if (!_tmp7_) {
				gboolean _tmp8_ = FALSE;
				GList* _tmp9_;
				GList* _tmp10_;
				_tmp9_ = _vala_best_time_item;
				_tmp10_ = self->entries;
				if (_tmp9_ != _tmp10_) {
					GList* _tmp11_;
					gconstpointer _tmp12_;
					guint8 _tmp13_;
					guint8 _tmp14_;
					_tmp11_ = _vala_best_time_item;
					_tmp12_ = _tmp11_->data;
					_tmp13_ = history_entry_get_size ((HistoryEntry*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp8_ = _tmp14_ == puzzle_size;
				} else {
					_tmp8_ = FALSE;
				}
				if (!_tmp8_) {
					break;
				}
			}
			_tmp7_ = FALSE;
			_tmp15_ = _vala_best_time_item;
			_tmp16_ = _tmp15_->prev;
			_vala_best_time_item = _tmp16_;
		}
	}
	_tmp17_ = self->entries;
	_tmp18_ = _vala_best_time_item;
	result = (guint) g_list_position (_tmp17_, _tmp18_);
	if (best_time_item) {
		*best_time_item = _vala_best_time_item;
	}
	return result;
}

gboolean
history_is_empty (History* self)
{
	GList* first_entry = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->entries;
	_tmp1_ = g_list_first (_tmp0_);
	first_entry = _tmp1_;
	result = first_entry == NULL;
	return result;
}

void
history_get_fallback_scores (History* self,
                             guint8 puzzle_size,
                             HistoryEntry** fallback_score_0,
                             HistoryEntry** fallback_score_1,
                             HistoryEntry** fallback_score_2,
                             HistoryEntry** fallback_score_3)
{
	HistoryEntry* _vala_fallback_score_0 = NULL;
	HistoryEntry* _vala_fallback_score_1 = NULL;
	HistoryEntry* _vala_fallback_score_2 = NULL;
	HistoryEntry* _vala_fallback_score_3 = NULL;
	GList* tmp_item = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	gboolean _tmp10_ = FALSE;
	GList* _tmp11_;
	GList* _tmp16_;
	gconstpointer _tmp17_;
	HistoryEntry* _tmp18_;
	GList* _tmp19_;
	GList* _tmp20_;
	gboolean _tmp21_ = FALSE;
	GList* _tmp22_;
	GList* _tmp27_;
	gconstpointer _tmp28_;
	HistoryEntry* _tmp29_;
	GList* _tmp30_;
	GList* _tmp31_;
	gboolean _tmp32_ = FALSE;
	GList* _tmp33_;
	GList* _tmp38_;
	gconstpointer _tmp39_;
	HistoryEntry* _tmp40_;
	GList* _tmp41_;
	GList* _tmp42_;
	gboolean _tmp43_ = FALSE;
	GList* _tmp44_;
	GList* tmp_item_prev = NULL;
	GList* _tmp49_;
	GList* _tmp60_;
	gconstpointer _tmp61_;
	HistoryEntry* _tmp62_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->entries;
	_tmp1_ = g_list_first (_tmp0_);
	tmp_item = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		GList* _tmp3_;
		GList* _tmp8_;
		GList* _tmp9_;
		_tmp3_ = tmp_item;
		if (_tmp3_ != NULL) {
			GList* _tmp4_;
			gconstpointer _tmp5_;
			guint8 _tmp6_;
			guint8 _tmp7_;
			_tmp4_ = tmp_item;
			_tmp5_ = ((GList*) _tmp4_)->data;
			_tmp6_ = history_entry_get_size ((HistoryEntry*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp2_ = _tmp7_ < puzzle_size;
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp8_ = tmp_item;
		_tmp9_ = ((GList*) _tmp8_)->next;
		tmp_item = _tmp9_;
	}
	_tmp11_ = tmp_item;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		GList* _tmp12_;
		gconstpointer _tmp13_;
		guint8 _tmp14_;
		guint8 _tmp15_;
		_tmp12_ = tmp_item;
		_tmp13_ = ((GList*) _tmp12_)->data;
		_tmp14_ = history_entry_get_size ((HistoryEntry*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp10_ = _tmp15_ != puzzle_size;
	}
	if (_tmp10_) {
		_g_object_unref0 (_vala_fallback_score_0);
		_vala_fallback_score_0 = NULL;
		_g_object_unref0 (_vala_fallback_score_1);
		_vala_fallback_score_1 = NULL;
		_g_object_unref0 (_vala_fallback_score_2);
		_vala_fallback_score_2 = NULL;
		_g_object_unref0 (_vala_fallback_score_3);
		_vala_fallback_score_3 = NULL;
		if (fallback_score_0) {
			*fallback_score_0 = _vala_fallback_score_0;
		} else {
			_g_object_unref0 (_vala_fallback_score_0);
		}
		if (fallback_score_1) {
			*fallback_score_1 = _vala_fallback_score_1;
		} else {
			_g_object_unref0 (_vala_fallback_score_1);
		}
		if (fallback_score_2) {
			*fallback_score_2 = _vala_fallback_score_2;
		} else {
			_g_object_unref0 (_vala_fallback_score_2);
		}
		if (fallback_score_3) {
			*fallback_score_3 = _vala_fallback_score_3;
		} else {
			_g_object_unref0 (_vala_fallback_score_3);
		}
		return;
	}
	_tmp16_ = tmp_item;
	_tmp17_ = ((GList*) _tmp16_)->data;
	_tmp18_ = _g_object_ref0 ((HistoryEntry*) _tmp17_);
	_g_object_unref0 (_vala_fallback_score_0);
	_vala_fallback_score_0 = _tmp18_;
	_tmp19_ = tmp_item;
	_tmp20_ = ((GList*) _tmp19_)->next;
	tmp_item = _tmp20_;
	_tmp22_ = tmp_item;
	if (_tmp22_ == NULL) {
		_tmp21_ = TRUE;
	} else {
		GList* _tmp23_;
		gconstpointer _tmp24_;
		guint8 _tmp25_;
		guint8 _tmp26_;
		_tmp23_ = tmp_item;
		_tmp24_ = ((GList*) _tmp23_)->data;
		_tmp25_ = history_entry_get_size ((HistoryEntry*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp21_ = _tmp26_ != puzzle_size;
	}
	if (_tmp21_) {
		_g_object_unref0 (_vala_fallback_score_1);
		_vala_fallback_score_1 = NULL;
		_g_object_unref0 (_vala_fallback_score_2);
		_vala_fallback_score_2 = NULL;
		_g_object_unref0 (_vala_fallback_score_3);
		_vala_fallback_score_3 = NULL;
		if (fallback_score_0) {
			*fallback_score_0 = _vala_fallback_score_0;
		} else {
			_g_object_unref0 (_vala_fallback_score_0);
		}
		if (fallback_score_1) {
			*fallback_score_1 = _vala_fallback_score_1;
		} else {
			_g_object_unref0 (_vala_fallback_score_1);
		}
		if (fallback_score_2) {
			*fallback_score_2 = _vala_fallback_score_2;
		} else {
			_g_object_unref0 (_vala_fallback_score_2);
		}
		if (fallback_score_3) {
			*fallback_score_3 = _vala_fallback_score_3;
		} else {
			_g_object_unref0 (_vala_fallback_score_3);
		}
		return;
	}
	_tmp27_ = tmp_item;
	_tmp28_ = ((GList*) _tmp27_)->data;
	_tmp29_ = _g_object_ref0 ((HistoryEntry*) _tmp28_);
	_g_object_unref0 (_vala_fallback_score_1);
	_vala_fallback_score_1 = _tmp29_;
	_tmp30_ = tmp_item;
	_tmp31_ = ((GList*) _tmp30_)->next;
	tmp_item = _tmp31_;
	_tmp33_ = tmp_item;
	if (_tmp33_ == NULL) {
		_tmp32_ = TRUE;
	} else {
		GList* _tmp34_;
		gconstpointer _tmp35_;
		guint8 _tmp36_;
		guint8 _tmp37_;
		_tmp34_ = tmp_item;
		_tmp35_ = ((GList*) _tmp34_)->data;
		_tmp36_ = history_entry_get_size ((HistoryEntry*) _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp32_ = _tmp37_ != puzzle_size;
	}
	if (_tmp32_) {
		_g_object_unref0 (_vala_fallback_score_2);
		_vala_fallback_score_2 = NULL;
		_g_object_unref0 (_vala_fallback_score_3);
		_vala_fallback_score_3 = NULL;
		if (fallback_score_0) {
			*fallback_score_0 = _vala_fallback_score_0;
		} else {
			_g_object_unref0 (_vala_fallback_score_0);
		}
		if (fallback_score_1) {
			*fallback_score_1 = _vala_fallback_score_1;
		} else {
			_g_object_unref0 (_vala_fallback_score_1);
		}
		if (fallback_score_2) {
			*fallback_score_2 = _vala_fallback_score_2;
		} else {
			_g_object_unref0 (_vala_fallback_score_2);
		}
		if (fallback_score_3) {
			*fallback_score_3 = _vala_fallback_score_3;
		} else {
			_g_object_unref0 (_vala_fallback_score_3);
		}
		return;
	}
	_tmp38_ = tmp_item;
	_tmp39_ = ((GList*) _tmp38_)->data;
	_tmp40_ = _g_object_ref0 ((HistoryEntry*) _tmp39_);
	_g_object_unref0 (_vala_fallback_score_2);
	_vala_fallback_score_2 = _tmp40_;
	_tmp41_ = tmp_item;
	_tmp42_ = ((GList*) _tmp41_)->next;
	tmp_item = _tmp42_;
	_tmp44_ = tmp_item;
	if (_tmp44_ == NULL) {
		_tmp43_ = TRUE;
	} else {
		GList* _tmp45_;
		gconstpointer _tmp46_;
		guint8 _tmp47_;
		guint8 _tmp48_;
		_tmp45_ = tmp_item;
		_tmp46_ = ((GList*) _tmp45_)->data;
		_tmp47_ = history_entry_get_size ((HistoryEntry*) _tmp46_);
		_tmp48_ = _tmp47_;
		_tmp43_ = _tmp48_ != puzzle_size;
	}
	if (_tmp43_) {
		_g_object_unref0 (_vala_fallback_score_3);
		_vala_fallback_score_3 = NULL;
		if (fallback_score_0) {
			*fallback_score_0 = _vala_fallback_score_0;
		} else {
			_g_object_unref0 (_vala_fallback_score_0);
		}
		if (fallback_score_1) {
			*fallback_score_1 = _vala_fallback_score_1;
		} else {
			_g_object_unref0 (_vala_fallback_score_1);
		}
		if (fallback_score_2) {
			*fallback_score_2 = _vala_fallback_score_2;
		} else {
			_g_object_unref0 (_vala_fallback_score_2);
		}
		if (fallback_score_3) {
			*fallback_score_3 = _vala_fallback_score_3;
		} else {
			_g_object_unref0 (_vala_fallback_score_3);
		}
		return;
	}
	_tmp49_ = tmp_item;
	tmp_item_prev = (GList*) _tmp49_;
	{
		gboolean _tmp50_ = FALSE;
		_tmp50_ = TRUE;
		while (TRUE) {
			GList* _tmp57_;
			GList* _tmp58_;
			GList* _tmp59_;
			if (!_tmp50_) {
				gboolean _tmp51_ = FALSE;
				GList* _tmp52_;
				_tmp52_ = tmp_item;
				if (_tmp52_ != NULL) {
					GList* _tmp53_;
					gconstpointer _tmp54_;
					guint8 _tmp55_;
					guint8 _tmp56_;
					_tmp53_ = tmp_item;
					_tmp54_ = ((GList*) _tmp53_)->data;
					_tmp55_ = history_entry_get_size ((HistoryEntry*) _tmp54_);
					_tmp56_ = _tmp55_;
					_tmp51_ = _tmp56_ == puzzle_size;
				} else {
					_tmp51_ = FALSE;
				}
				if (!_tmp51_) {
					break;
				}
			}
			_tmp50_ = FALSE;
			_tmp57_ = tmp_item;
			tmp_item_prev = (GList*) _tmp57_;
			_tmp58_ = tmp_item;
			_tmp59_ = ((GList*) _tmp58_)->next;
			tmp_item = _tmp59_;
		}
	}
	_tmp60_ = tmp_item_prev;
	_tmp61_ = _tmp60_->data;
	_tmp62_ = _g_object_ref0 ((HistoryEntry*) _tmp61_);
	_g_object_unref0 (_vala_fallback_score_3);
	_vala_fallback_score_3 = _tmp62_;
	if (fallback_score_0) {
		*fallback_score_0 = _vala_fallback_score_0;
	} else {
		_g_object_unref0 (_vala_fallback_score_0);
	}
	if (fallback_score_1) {
		*fallback_score_1 = _vala_fallback_score_1;
	} else {
		_g_object_unref0 (_vala_fallback_score_1);
	}
	if (fallback_score_2) {
		*fallback_score_2 = _vala_fallback_score_2;
	} else {
		_g_object_unref0 (_vala_fallback_score_2);
	}
	if (fallback_score_3) {
		*fallback_score_3 = _vala_fallback_score_3;
	} else {
		_g_object_unref0 (_vala_fallback_score_3);
	}
}

History*
history_construct (GType object_type,
                   const gchar* filename)
{
	History * self = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (History*) g_object_new (object_type, "filename", filename, NULL);
	history_load (self);
	return self;
}

History*
history_new (const gchar* filename)
{
	return history_construct (TYPE_HISTORY, filename);
}

static gboolean
uint64_try_parse (const gchar* str,
                  guint64* _result_,
                  const gchar** unparsed,
                  guint _base)
{
	guint64 _vala__result_ = 0ULL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	guint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoull (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gboolean
double_try_parse (const gchar* str,
                  gdouble* _result_,
                  const gchar** unparsed)
{
	gdouble _vala__result_ = 0.0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gdouble _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtod (str, &_tmp0_);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = errno != ERANGE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static inline void
history_load (History* self)
{
	gchar* contents = NULL;
	gchar* _tmp0_;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	contents = _tmp0_;
	{
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		_tmp1_ = self->priv->_filename;
		g_file_get_contents (_tmp1_, &_tmp2_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		if (!g_error_matches (_tmp3_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			GError* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("history.vala:196: Failed to load history: %s", _tmp5_);
		}
		_g_error_free0 (e);
		_g_free0 (contents);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp6_ = contents;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp8_;
		line_collection_length1 = _vala_array_length (_tmp7_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp9_;
			gchar* line = NULL;
			_tmp9_ = g_strdup (line_collection[line_it]);
			line = _tmp9_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp10_;
				gchar** _tmp11_;
				gchar** _tmp12_;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				GDateTime* date = NULL;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				GDateTime* _tmp16_;
				GDateTime* _tmp17_;
				guint64 test = 0ULL;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				guint64 _tmp20_ = 0ULL;
				gboolean _tmp21_;
				gboolean _tmp22_ = FALSE;
				guint8 size = 0U;
				gdouble duration = 0.0;
				gboolean int_duration = FALSE;
				gchar** _tmp23_;
				gint _tmp23__length1;
				const gchar* _tmp24_;
				guint64 _tmp25_ = 0ULL;
				gboolean _tmp26_;
				GDateTime* _tmp31_;
				HistoryEntry* _tmp32_;
				_tmp10_ = line;
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, " ", 0);
				tokens = _tmp12_;
				tokens_length1 = _vala_array_length (_tmp11_);
				_tokens_size_ = tokens_length1;
				_tmp13_ = tokens;
				_tmp13__length1 = tokens_length1;
				if (_tmp13__length1 != 3) {
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp14_ = tokens;
				_tmp14__length1 = tokens_length1;
				_tmp15_ = _tmp14_[0];
				_tmp16_ = g_date_time_new_from_iso8601 (_tmp15_, NULL);
				date = _tmp16_;
				_tmp17_ = date;
				if (_tmp17_ == NULL) {
					_g_date_time_unref0 (date);
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp18_ = tokens;
				_tmp18__length1 = tokens_length1;
				_tmp19_ = _tmp18_[1];
				_tmp21_ = uint64_try_parse (_tmp19_, &_tmp20_, NULL, (guint) 0);
				test = _tmp20_;
				if (!_tmp21_) {
					_g_date_time_unref0 (date);
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				if (test < ((guint64) 2)) {
					_tmp22_ = TRUE;
				} else {
					_tmp22_ = test > ((guint64) 6);
				}
				if (_tmp22_) {
					_g_date_time_unref0 (date);
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				size = (guint8) test;
				_tmp23_ = tokens;
				_tmp23__length1 = tokens_length1;
				_tmp24_ = _tmp23_[2];
				_tmp26_ = uint64_try_parse (_tmp24_, &_tmp25_, NULL, (guint) 0);
				duration = (gdouble) _tmp25_;
				if (_tmp26_) {
					int_duration = TRUE;
				} else {
					gchar** _tmp27_;
					gint _tmp27__length1;
					const gchar* _tmp28_;
					gdouble _tmp29_ = 0.0;
					gboolean _tmp30_;
					_tmp27_ = tokens;
					_tmp27__length1 = tokens_length1;
					_tmp28_ = _tmp27_[2];
					_tmp30_ = double_try_parse (_tmp28_, &_tmp29_, NULL);
					duration = _tmp29_;
					if (_tmp30_) {
						int_duration = FALSE;
					} else {
						_g_date_time_unref0 (date);
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
						continue;
					}
				}
				_tmp31_ = date;
				_tmp32_ = history_entry_new ((GDateTime*) _tmp31_, size, duration, int_duration);
				self->entries = g_list_prepend (self->entries, _tmp32_);
				_g_date_time_unref0 (date);
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	self->entries = g_list_sort (self->entries, _history_compare_entries_gcompare_func);
	_g_free0 (contents);
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static inline void
history_save (History* self)
{
	gchar* contents = NULL;
	gchar* _tmp0_;
	GList* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	contents = _tmp0_;
	_tmp1_ = self->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp1_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			HistoryEntry* _tmp2_;
			HistoryEntry* entry = NULL;
			_tmp2_ = _g_object_ref0 ((HistoryEntry*) entry_it->data);
			entry = _tmp2_;
			{
				gchar* line = NULL;
				HistoryEntry* _tmp3_;
				gboolean _tmp4_;
				gboolean _tmp5_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp3_ = entry;
				_tmp4_ = history_entry_get_int_duration (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_) {
					HistoryEntry* _tmp6_;
					GDateTime* _tmp7_;
					GDateTime* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					HistoryEntry* _tmp11_;
					guint8 _tmp12_;
					guint8 _tmp13_;
					HistoryEntry* _tmp14_;
					gdouble _tmp15_;
					gdouble _tmp16_;
					gchar* _tmp17_;
					_tmp6_ = entry;
					_tmp7_ = history_entry_get_date (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = g_date_time_to_string (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = entry;
					_tmp12_ = history_entry_get_size (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = entry;
					_tmp15_ = history_entry_get_duration (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strdup_printf ("%s %hu %u\n", _tmp10_, (gushort) _tmp13_, (guint) _tmp16_);
					_g_free0 (line);
					line = _tmp17_;
					_g_free0 (_tmp10_);
				} else {
					HistoryEntry* _tmp18_;
					GDateTime* _tmp19_;
					GDateTime* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					HistoryEntry* _tmp23_;
					guint8 _tmp24_;
					guint8 _tmp25_;
					HistoryEntry* _tmp26_;
					gdouble _tmp27_;
					gdouble _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp18_ = entry;
					_tmp19_ = history_entry_get_date (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = g_date_time_to_string (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = entry;
					_tmp24_ = history_entry_get_size (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = entry;
					_tmp27_ = history_entry_get_duration (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = double_to_string (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = g_strdup_printf ("%s %hu %s\n", _tmp22_, (gushort) _tmp25_, _tmp30_);
					_g_free0 (line);
					line = _tmp31_;
					_g_free0 (_tmp30_);
					_g_free0 (_tmp22_);
				}
				_tmp32_ = contents;
				_tmp33_ = line;
				_tmp34_ = g_strconcat (_tmp32_, _tmp33_, NULL);
				_g_free0 (contents);
				contents = _tmp34_;
				_g_free0 (line);
				_g_object_unref0 (entry);
			}
		}
	}
	{
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		_tmp35_ = self->priv->_filename;
		_tmp36_ = g_path_get_dirname (_tmp35_);
		_tmp37_ = _tmp36_;
		g_mkdir_with_parents (_tmp37_, 0775);
		_g_free0 (_tmp37_);
		_tmp38_ = self->priv->_filename;
		_tmp39_ = contents;
		g_file_set_contents (_tmp38_, _tmp39_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp40_;
		const gchar* _tmp41_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp40_ = e;
		_tmp41_ = _tmp40_->message;
		g_warning ("history.vala:256: Failed to save history: %s", _tmp41_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (contents);
}

static gint
history_compare_entries (HistoryEntry* a,
                         HistoryEntry* b)
{
	guint8 _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	guint8 _tmp3_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gdouble _tmp26_;
	gdouble _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	gdouble _tmp33_;
	GDateTime* _tmp34_;
	GDateTime* _tmp35_;
	GDateTime* _tmp36_;
	GDateTime* _tmp37_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = history_entry_get_size (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = history_entry_get_size (b);
	_tmp3_ = _tmp2_;
	if (_tmp1_ != _tmp3_) {
		guint8 _tmp4_;
		guint8 _tmp5_;
		guint8 _tmp6_;
		guint8 _tmp7_;
		_tmp4_ = history_entry_get_size (a);
		_tmp5_ = _tmp4_;
		_tmp6_ = history_entry_get_size (b);
		_tmp7_ = _tmp6_;
		result = ((gint) _tmp5_) - ((gint) _tmp7_);
		return result;
	}
	_tmp8_ = history_entry_get_duration (a);
	_tmp9_ = _tmp8_;
	_tmp10_ = history_entry_get_duration (b);
	_tmp11_ = _tmp10_;
	if (((guint) _tmp9_) < ((guint) _tmp11_)) {
		result = -1;
		return result;
	}
	_tmp12_ = history_entry_get_duration (a);
	_tmp13_ = _tmp12_;
	_tmp14_ = history_entry_get_duration (b);
	_tmp15_ = _tmp14_;
	if (((guint) _tmp13_) > ((guint) _tmp15_)) {
		result = 1;
		return result;
	}
	_tmp17_ = history_entry_get_int_duration (a);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp19_ = history_entry_get_int_duration (b);
		_tmp20_ = _tmp19_;
		_tmp16_ = !_tmp20_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		result = 1;
		return result;
	}
	_tmp22_ = history_entry_get_int_duration (b);
	_tmp23_ = _tmp22_;
	if (_tmp23_) {
		gboolean _tmp24_;
		gboolean _tmp25_;
		_tmp24_ = history_entry_get_int_duration (a);
		_tmp25_ = _tmp24_;
		_tmp21_ = !_tmp25_;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		result = -1;
		return result;
	}
	_tmp26_ = history_entry_get_duration (a);
	_tmp27_ = _tmp26_;
	_tmp28_ = history_entry_get_duration (b);
	_tmp29_ = _tmp28_;
	if (_tmp27_ < _tmp29_) {
		result = -1;
		return result;
	}
	_tmp30_ = history_entry_get_duration (a);
	_tmp31_ = _tmp30_;
	_tmp32_ = history_entry_get_duration (b);
	_tmp33_ = _tmp32_;
	if (_tmp31_ > _tmp33_) {
		result = 1;
		return result;
	}
	_tmp34_ = history_entry_get_date (a);
	_tmp35_ = _tmp34_;
	_tmp36_ = history_entry_get_date (b);
	_tmp37_ = _tmp36_;
	result = -1 * g_date_time_compare (_tmp35_, _tmp37_);
	return result;
}

static const gchar*
history_get_filename (History* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

static void
history_set_filename (History* self,
                      const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp0_;
}

static void
history_class_init (HistoryClass * klass,
                    gpointer klass_data)
{
	history_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &History_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_history_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_history_set_property;
	G_OBJECT_CLASS (klass)->finalize = history_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), HISTORY_FILENAME_PROPERTY, history_properties[HISTORY_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	history_signals[HISTORY_ENTRY_ADDED_SIGNAL] = g_signal_new ("entry-added", TYPE_HISTORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_HISTORY_ENTRY);
}

static void
history_instance_init (History * self,
                       gpointer klass)
{
	self->priv = history_get_instance_private (self);
	self->entries = NULL;
}

static void
history_finalize (GObject * obj)
{
	History * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY, History);
	_g_free0 (self->priv->_filename);
	(self->entries == NULL) ? NULL : (self->entries = (_g_list_free__g_object_unref0_ (self->entries), NULL));
	G_OBJECT_CLASS (history_parent_class)->finalize (obj);
}

static GType
history_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (HistoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (History), 0, (GInstanceInitFunc) history_instance_init, NULL };
	GType history_type_id;
	history_type_id = g_type_register_static (G_TYPE_OBJECT, "History", &g_define_type_info, 0);
	History_private_offset = g_type_add_instance_private (history_type_id, sizeof (HistoryPrivate));
	return history_type_id;
}

GType
history_get_type (void)
{
	static volatile gsize history_type_id__once = 0;
	if (g_once_init_enter (&history_type_id__once)) {
		GType history_type_id;
		history_type_id = history_get_type_once ();
		g_once_init_leave (&history_type_id__once, history_type_id);
	}
	return history_type_id__once;
}

static void
_vala_history_get_property (GObject * object,
                            guint property_id,
                            GValue * value,
                            GParamSpec * pspec)
{
	History * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_HISTORY, History);
	switch (property_id) {
		case HISTORY_FILENAME_PROPERTY:
		g_value_set_string (value, history_get_filename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_history_set_property (GObject * object,
                            guint property_id,
                            const GValue * value,
                            GParamSpec * pspec)
{
	History * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_HISTORY, History);
	switch (property_id) {
		case HISTORY_FILENAME_PROPERTY:
		history_set_filename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
history_entry_get_instance_private (HistoryEntry* self)
{
	return G_STRUCT_MEMBER_P (self, HistoryEntry_private_offset);
}

HistoryEntry*
history_entry_construct (GType object_type,
                         GDateTime* date,
                         guint8 size,
                         gdouble duration,
                         gboolean int_duration)
{
	HistoryEntry * self = NULL;
	g_return_val_if_fail (date != NULL, NULL);
	self = (HistoryEntry*) g_object_new (object_type, "date", date, "size", size, "duration", duration, "int-duration", int_duration, NULL);
	return self;
}

HistoryEntry*
history_entry_new (GDateTime* date,
                   guint8 size,
                   gdouble duration,
                   gboolean int_duration)
{
	return history_entry_construct (TYPE_HISTORY_ENTRY, date, size, duration, int_duration);
}

gchar*
history_entry_get_duration_string (HistoryEntry* entry)
{
	gdouble _tmp0_;
	gdouble _tmp5_;
	gchar* result;
	g_return_val_if_fail (entry != NULL, NULL);
	_tmp0_ = entry->priv->_duration;
	if (_tmp0_ >= 3600.0) {
		gdouble _tmp1_;
		gdouble _tmp2_;
		gdouble _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = entry->priv->_duration;
		_tmp2_ = entry->priv->_duration;
		_tmp3_ = entry->priv->_duration;
		_tmp4_ = g_strdup_printf (_ ("%uh %um %us"), ((guint) _tmp1_) / 3600, (((guint) _tmp2_) / 60) % 60, ((guint) _tmp3_) % 60);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = entry->priv->_duration;
	if (_tmp5_ >= 60.0) {
		gdouble _tmp6_;
		gdouble _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = entry->priv->_duration;
		_tmp7_ = entry->priv->_duration;
		_tmp8_ = g_strdup_printf (_ ("%um %us"), ((guint) _tmp6_) / 60, ((guint) _tmp7_) % 60);
		result = _tmp8_;
		return result;
	} else {
		gboolean _tmp9_;
		_tmp9_ = entry->priv->_int_duration;
		if (_tmp9_) {
			gdouble _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = entry->priv->_duration;
			_tmp11_ = g_strdup_printf (_ ("%us"), (guint) _tmp10_);
			result = _tmp11_;
			return result;
		} else {
			gdouble _tmp12_;
			_tmp12_ = entry->priv->_duration;
			if (_tmp12_ >= 20.0) {
				gdouble _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = entry->priv->_duration;
				_tmp14_ = g_strdup_printf (_ ("%.0fs"), floor (_tmp13_));
				result = _tmp14_;
				return result;
			} else {
				gdouble _tmp15_;
				_tmp15_ = entry->priv->_duration;
				if (_tmp15_ >= 10.0) {
					gdouble _tmp16_;
					gchar* _tmp17_;
					_tmp16_ = entry->priv->_duration;
					_tmp17_ = g_strdup_printf (_ ("%.1fs"), floor (_tmp16_ * 10.0) / 10.0);
					result = _tmp17_;
					return result;
				} else {
					gdouble _tmp18_;
					_tmp18_ = entry->priv->_duration;
					if (_tmp18_ >= 5.0) {
						gdouble _tmp19_;
						gchar* _tmp20_;
						_tmp19_ = entry->priv->_duration;
						_tmp20_ = g_strdup_printf (_ ("%.2fs"), floor (_tmp19_ * 100.0) / 100.0);
						result = _tmp20_;
						return result;
					} else {
						gdouble _tmp21_;
						gchar* _tmp22_;
						_tmp21_ = entry->priv->_duration;
						_tmp22_ = g_strdup_printf (_ ("%.3fs"), floor (_tmp21_ * 1000.0) / 1000.0);
						result = _tmp22_;
						return result;
					}
				}
			}
		}
	}
}

GDateTime*
history_entry_get_date (HistoryEntry* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_date;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
history_entry_set_date (HistoryEntry* self,
                        GDateTime* value)
{
	GDateTime* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_date_time_ref0 (value);
	_g_date_time_unref0 (self->priv->_date);
	self->priv->_date = _tmp0_;
}

guint8
history_entry_get_size (HistoryEntry* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_size;
	return result;
}

static void
history_entry_set_size (HistoryEntry* self,
                        guint8 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_size = value;
}

gdouble
history_entry_get_duration (HistoryEntry* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_duration;
	return result;
}

static void
history_entry_set_duration (HistoryEntry* self,
                            gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_duration = value;
}

gboolean
history_entry_get_int_duration (HistoryEntry* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_int_duration;
	return result;
}

static void
history_entry_set_int_duration (HistoryEntry* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_int_duration = value;
}

static void
history_entry_class_init (HistoryEntryClass * klass,
                          gpointer klass_data)
{
	history_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &HistoryEntry_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_history_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_history_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = history_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), HISTORY_ENTRY_DATE_PROPERTY, history_entry_properties[HISTORY_ENTRY_DATE_PROPERTY] = g_param_spec_boxed ("date", "date", "date", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), HISTORY_ENTRY_SIZE_PROPERTY, history_entry_properties[HISTORY_ENTRY_SIZE_PROPERTY] = g_param_spec_uchar ("size", "size", "size", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), HISTORY_ENTRY_DURATION_PROPERTY, history_entry_properties[HISTORY_ENTRY_DURATION_PROPERTY] = g_param_spec_double ("duration", "duration", "duration", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), HISTORY_ENTRY_INT_DURATION_PROPERTY, history_entry_properties[HISTORY_ENTRY_INT_DURATION_PROPERTY] = g_param_spec_boolean ("int-duration", "int-duration", "int-duration", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
}

static void
history_entry_instance_init (HistoryEntry * self,
                             gpointer klass)
{
	self->priv = history_entry_get_instance_private (self);
}

static void
history_entry_finalize (GObject * obj)
{
	HistoryEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY_ENTRY, HistoryEntry);
	_g_date_time_unref0 (self->priv->_date);
	G_OBJECT_CLASS (history_entry_parent_class)->finalize (obj);
}

static GType
history_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (HistoryEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryEntry), 0, (GInstanceInitFunc) history_entry_instance_init, NULL };
	GType history_entry_type_id;
	history_entry_type_id = g_type_register_static (G_TYPE_OBJECT, "HistoryEntry", &g_define_type_info, 0);
	HistoryEntry_private_offset = g_type_add_instance_private (history_entry_type_id, sizeof (HistoryEntryPrivate));
	return history_entry_type_id;
}

GType
history_entry_get_type (void)
{
	static volatile gsize history_entry_type_id__once = 0;
	if (g_once_init_enter (&history_entry_type_id__once)) {
		GType history_entry_type_id;
		history_entry_type_id = history_entry_get_type_once ();
		g_once_init_leave (&history_entry_type_id__once, history_entry_type_id);
	}
	return history_entry_type_id__once;
}

static void
_vala_history_entry_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	HistoryEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_HISTORY_ENTRY, HistoryEntry);
	switch (property_id) {
		case HISTORY_ENTRY_DATE_PROPERTY:
		g_value_set_boxed (value, history_entry_get_date (self));
		break;
		case HISTORY_ENTRY_SIZE_PROPERTY:
		g_value_set_uchar (value, history_entry_get_size (self));
		break;
		case HISTORY_ENTRY_DURATION_PROPERTY:
		g_value_set_double (value, history_entry_get_duration (self));
		break;
		case HISTORY_ENTRY_INT_DURATION_PROPERTY:
		g_value_set_boolean (value, history_entry_get_int_duration (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_history_entry_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	HistoryEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_HISTORY_ENTRY, HistoryEntry);
	switch (property_id) {
		case HISTORY_ENTRY_DATE_PROPERTY:
		history_entry_set_date (self, g_value_get_boxed (value));
		break;
		case HISTORY_ENTRY_SIZE_PROPERTY:
		history_entry_set_size (self, g_value_get_uchar (value));
		break;
		case HISTORY_ENTRY_DURATION_PROPERTY:
		history_entry_set_duration (self, g_value_get_double (value));
		break;
		case HISTORY_ENTRY_INT_DURATION_PROPERTY:
		history_entry_set_int_duration (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

