/* gnome-chess.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gnome-chess.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2024 Michael Catanzaro
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "libchess.h"
#include "libengine.h"
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <locale.h>

#define NEW_GAME_ACTION_NAME "new"
#define OPEN_GAME_ACTION_NAME "open"
#define SAVE_GAME_ACTION_NAME "save"
#define SAVE_GAME_AS_ACTION_NAME "save-as"
#define UNDO_MOVE_ACTION_NAME "undo"
#define RESIGN_ACTION_NAME "resign"
#define PAUSE_RESUME_ACTION_NAME "pause-resume"
#define HISTORY_GO_FIRST_ACTION_NAME "go-first"
#define HISTORY_GO_PREVIOUS_ACTION_NAME "go-previous"
#define HISTORY_GO_NEXT_ACTION_NAME "go-next"
#define HISTORY_GO_LAST_ACTION_NAME "go-last"
#define PREFERENCES_ACTION_NAME "preferences"
#define HELP_ACTION_NAME "help"
#define ABOUT_ACTION_NAME "about"
#define QUIT_ACTION_NAME "quit"
#define WIDTH_SETTINGS_KEY "width"
#define HEIGHT_SETTINGS_KEY "height"
#define MAXIMIZED_SETTINGS_KEY "maximized"
#define SHOW_BOARD_NUMBERING_SETTINGS_KEY "show-numbering"
#define PIECE_STYLE_SETTINGS_KEY "piece-theme"
#define MOVE_FORMAT_SETTINGS_KEY "move-format"
#define BOARD_ORIENTATION_SETTINGS_KEY "board-side"
#define INCREMENT_SETTINGS_KEY "timer-increment"
#define CLOCK_TYPE_SETTINGS_KEY "clock-type"
#define DURATION_SETTINGS_KEY "duration"
#define DIFFICULTY_SETTINGS_KEY "difficulty"
#define OPPONENT_SETTINGS_KEY "opponent"
#define PLAY_AS_SETTINGS_KEY "play-as"
#define LAST_PLAYED_AS_SETTINGS_KEY "last-played-as"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CHESS_APPLICATION (chess_application_get_type ())
#define CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_APPLICATION, ChessApplication))
#define CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_APPLICATION, ChessApplicationClass))
#define IS_CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_APPLICATION))
#define IS_CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_APPLICATION))
#define CHESS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_APPLICATION, ChessApplicationClass))

typedef struct _ChessApplication ChessApplication;
typedef struct _ChessApplicationClass ChessApplicationClass;
typedef struct _ChessApplicationPrivate ChessApplicationPrivate;

#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;

#define TYPE_CHESS_WINDOW (chess_window_get_type ())
#define CHESS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_WINDOW, ChessWindow))
#define CHESS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_WINDOW, ChessWindowClass))
#define IS_CHESS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_WINDOW))
#define IS_CHESS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_WINDOW))
#define CHESS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_WINDOW, ChessWindowClass))

typedef struct _ChessWindow ChessWindow;
typedef struct _ChessWindowClass ChessWindowClass;

#define TYPE_NEW_GAME_DIALOG (new_game_dialog_get_type ())
#define NEW_GAME_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NEW_GAME_DIALOG, NewGameDialog))
#define NEW_GAME_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NEW_GAME_DIALOG, NewGameDialogClass))
#define IS_NEW_GAME_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NEW_GAME_DIALOG))
#define IS_NEW_GAME_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NEW_GAME_DIALOG))
#define NEW_GAME_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NEW_GAME_DIALOG, NewGameDialogClass))

typedef struct _NewGameDialog NewGameDialog;
typedef struct _NewGameDialogClass NewGameDialogClass;

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
enum  {
	CHESS_APPLICATION_0_PROPERTY,
	CHESS_APPLICATION_WINDOW_PROPERTY,
	CHESS_APPLICATION_VIEW_PROPERTY,
	CHESS_APPLICATION_SCENE_PROPERTY,
	CHESS_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* chess_application_properties[CHESS_APPLICATION_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
typedef void (*ChessScenePromotionTypeCompletionHandler) (PieceType* type, gpointer user_data);
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;

#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;
typedef void (*ChessApplicationPromptSaveGameCallback) (gboolean cancelled, gpointer user_data);
typedef struct _Block6Data Block6Data;
typedef void (*ChessApplicationPresentSaveDialogCallback) (gboolean saved, gpointer user_data);
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;

#define TYPE_PROMOTION_TYPE_SELECTOR_DIALOG (promotion_type_selector_dialog_get_type ())
#define PROMOTION_TYPE_SELECTOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, PromotionTypeSelectorDialog))
#define PROMOTION_TYPE_SELECTOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, PromotionTypeSelectorDialogClass))
#define IS_PROMOTION_TYPE_SELECTOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG))
#define IS_PROMOTION_TYPE_SELECTOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG))
#define PROMOTION_TYPE_SELECTOR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, PromotionTypeSelectorDialogClass))

typedef struct _PromotionTypeSelectorDialog PromotionTypeSelectorDialog;
typedef struct _PromotionTypeSelectorDialogClass PromotionTypeSelectorDialogClass;
typedef struct _Block7Data Block7Data;
typedef enum  {
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_QUEEN,
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_KNIGHT,
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_ROOK,
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_BISHOP
} PromotionTypeSelectorDialogSelectedType;

#define PROMOTION_TYPE_SELECTOR_DIALOG_TYPE_SELECTED_TYPE (promotion_type_selector_dialog_selected_type_get_type ())
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ChessApplication {
	AdwApplication parent_instance;
	ChessApplicationPrivate * priv;
};

struct _ChessApplicationClass {
	AdwApplicationClass parent_class;
};

struct _ChessApplicationPrivate {
	GSettings* settings;
	Preferences* preferences;
	ChessWindow* _window;
	NewGameDialog* new_game_dialog;
	PreferencesDialog* preferences_dialog;
	AdwAboutDialog* about_dialog;
	GtkFileDialog* open_dialog;
	GtkFileDialog* save_dialog;
	PGNGame* pgn_game;
	ChessGame* game;
	gchar* autosave_filename;
	GFile* game_file;
	gboolean game_needs_saving;
	gboolean starting;
	GList* ai_profiles;
	ChessPlayer* opponent;
	ChessPlayer* human_player;
	ChessEngine* opponent_engine;
	guint engine_timeout_source;
	gchar* copyrights;
};

struct _Block3Data {
	int _ref_count_;
	ChessApplication* self;
	ChessGame* original_game;
	ChessState* original_state;
	gchar* move;
};

struct _Block4Data {
	int _ref_count_;
	ChessApplication* self;
	ChessGame* original_game;
};

struct _Block5Data {
	int _ref_count_;
	ChessApplication* self;
	gboolean started;
	ChessGame* game;
	ChessMove* move;
};

struct _Block6Data {
	int _ref_count_;
	ChessApplication* self;
	ChessApplicationPromptSaveGameCallback callback;
	gpointer callback_target;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	ChessApplication* self;
	PromotionTypeSelectorDialog* promotion_type_selector_dialog;
	ChessScenePromotionTypeCompletionHandler handler;
	gpointer handler_target;
	GDestroyNotify handler_target_destroy_notify;
};

struct _Block8Data {
	int _ref_count_;
	ChessApplication* self;
	AdwAlertDialog* invalid_pgn_dialog;
};

struct _Block9Data {
	int _ref_count_;
	ChessApplication* self;
	AdwAlertDialog* invalid_move_dialog;
};

struct _Block10Data {
	int _ref_count_;
	ChessApplication* self;
	ChessApplicationPresentSaveDialogCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

static gint ChessApplication_private_offset;
static gpointer chess_application_parent_class = NULL;
static gint chess_application_ENGINE_INACTIVITY_TIMEOUT;
static gint chess_application_ENGINE_INACTIVITY_TIMEOUT = 33;

VALA_EXTERN GType chess_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessApplication, g_object_unref)
VALA_EXTERN GType preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Preferences, g_object_unref)
VALA_EXTERN GType chess_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessWindow, g_object_unref)
VALA_EXTERN GType new_game_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NewGameDialog, g_object_unref)
VALA_EXTERN GType preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PreferencesDialog, g_object_unref)
VALA_EXTERN void chess_application_new_game_cb (ChessApplication* self);
static void _chess_application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
VALA_EXTERN void chess_application_open_game_cb (ChessApplication* self);
static void _chess_application_open_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
VALA_EXTERN void chess_application_save_game_cb (ChessApplication* self);
static void _chess_application_save_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
VALA_EXTERN void chess_application_save_game_as_cb (ChessApplication* self);
static void _chess_application_save_game_as_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
VALA_EXTERN void chess_application_undo_move_cb (ChessApplication* self);
static void _chess_application_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
VALA_EXTERN void chess_application_resign_cb (ChessApplication* self);
static void _chess_application_resign_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
VALA_EXTERN void chess_application_pause_resume_cb (ChessApplication* self);
static void _chess_application_pause_resume_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void chess_application_history_go_first_cb (ChessApplication* self);
static void _chess_application_history_go_first_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void chess_application_history_go_previous_cb (ChessApplication* self);
static void _chess_application_history_go_previous_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self);
static void chess_application_history_go_next_cb (ChessApplication* self);
static void _chess_application_history_go_next_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void chess_application_history_go_last_cb (ChessApplication* self);
static void _chess_application_history_go_last_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void chess_application_preferences_cb (ChessApplication* self);
static void _chess_application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
VALA_EXTERN void chess_application_help_cb (ChessApplication* self);
static void _chess_application_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
VALA_EXTERN void chess_application_about_cb (ChessApplication* self);
static void _chess_application_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
VALA_EXTERN void chess_application_quit_cb (ChessApplication* self);
static void _chess_application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static ChessApplication* chess_application_new (void);
static ChessApplication* chess_application_construct (GType object_type);
static gint chess_application_real_handle_local_options (GApplication* base,
                                                  GVariantDict* options);
static void chess_application_real_startup (GApplication* base);
VALA_EXTERN Preferences* preferences_new (GSettings* settings);
VALA_EXTERN Preferences* preferences_construct (GType object_type,
                                    GSettings* settings);
static void chess_application_create_window (ChessApplication* self);
VALA_EXTERN ChessWindow* chess_window_new (ChessApplication* app);
VALA_EXTERN ChessWindow* chess_window_construct (GType object_type,
                                     ChessApplication* app);
static void chess_application_set_window (ChessApplication* self,
                                   ChessWindow* value);
VALA_EXTERN ChessWindow* chess_application_get_window (ChessApplication* self);
VALA_EXTERN GType chess_scene_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessScene, g_object_unref)
VALA_EXTERN ChessScene* chess_application_get_scene (ChessApplication* self);
static gboolean __lambda38_ (ChessApplication* self,
                      ChessPlayer* p);
static gboolean ___lambda38__chess_scene_is_human (ChessScene* _sender,
                                            ChessPlayer* player,
                                            gpointer self);
static void chess_application_show_promotion_type_selector (ChessApplication* self,
                                                     ChessScenePromotionTypeCompletionHandler handler,
                                                     gpointer handler_target,
                                                     GDestroyNotify handler_target_destroy_notify);
static void _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender,
                                                                                        ChessScenePromotionTypeCompletionHandler handler,
                                                                                        gpointer handler_target,
                                                                                        GDestroyNotify handler_target_destroy_notify,
                                                                                        gpointer self);
static void chess_application_start_new_game (ChessApplication* self);
static void chess_application_load_game (ChessApplication* self,
                                  GFile* file);
static void chess_application_real_open (GApplication* base,
                                  GFile** files,
                                  gint files_length1,
                                  const gchar* hint);
static void chess_application_real_activate (GApplication* base);
static void chess_application_real_shutdown (GApplication* base);
static void chess_application_autosave (ChessApplication* self);
VALA_EXTERN void chess_application_quit_game (ChessApplication* self);
static void chess_application_update_pgn_time_remaining (ChessApplication* self);
static void chess_application_start_game (ChessApplication* self);
static void chess_application_game_turn_cb (ChessApplication* self,
                                     ChessGame* game,
                                     ChessPlayer* player);
static void _chess_application_game_turn_cb_chess_game_turn_started (ChessGame* _sender,
                                                              ChessPlayer* player,
                                                              gpointer self);
static void chess_application_game_move_cb (ChessApplication* self,
                                     ChessGame* game,
                                     ChessMove* move);
static void _chess_application_game_move_cb_chess_game_moved (ChessGame* _sender,
                                                       ChessMove* move,
                                                       gpointer self);
static void chess_application_game_undo_cb (ChessApplication* self,
                                     ChessGame* game);
static void _chess_application_game_undo_cb_chess_game_undo (ChessGame* _sender,
                                                      gpointer self);
static void chess_application_game_end_cb (ChessApplication* self);
static void _chess_application_game_end_cb_chess_game_ended (ChessGame* _sender,
                                                      gpointer self);
static void chess_application_show_invalid_move_dialog (ChessApplication* self,
                                                 const gchar* error_message);
static void chess_application_configure_new_game (ChessApplication* self);
VALA_EXTERN void chess_scene_set_game (ChessScene* self,
                           ChessGame* value);
VALA_EXTERN void chess_window_start_game (ChessWindow* self);
static void chess_application_engine_move_cb (ChessApplication* self,
                                       ChessEngine* engine,
                                       const gchar* move);
static void _chess_application_engine_move_cb_chess_engine_moved (ChessEngine* _sender,
                                                           const gchar* move,
                                                           gpointer self);
static void chess_application_engine_resigned_cb (ChessApplication* self,
                                           ChessEngine* engine);
static void _chess_application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender,
                                                                  gpointer self);
static void chess_application_engine_stopped_unexpectedly_cb (ChessApplication* self,
                                                       ChessEngine* engine);
static void _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly (ChessEngine* _sender,
                                                                                          gpointer self);
static void chess_application_engine_error_cb (ChessApplication* self,
                                        ChessEngine* engine);
static void _chess_application_engine_error_cb_chess_engine_error (ChessEngine* _sender,
                                                            gpointer self);
static void chess_application_engine_claim_draw_cb (ChessApplication* self,
                                             ChessEngine* engine);
static void _chess_application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender,
                                                                      gpointer self);
static void chess_application_engine_offer_draw_cb (ChessApplication* self,
                                             ChessEngine* engine);
static void _chess_application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender,
                                                                      gpointer self);
static ChessEngine* chess_application_get_engine (ChessApplication* self,
                                           const gchar* name,
                                           const gchar* difficulty);
VALA_EXTERN void chess_application_disable_action (ChessApplication* self,
                                       const gchar* name);
VALA_EXTERN void chess_application_enable_action (ChessApplication* self,
                                      const gchar* name);
VALA_EXTERN void chess_window_set_clock_visible (ChessWindow* self,
                                     gboolean visible);
static void chess_application_update_action_status (ChessApplication* self);
VALA_EXTERN void chess_window_update_history_panel (ChessWindow* self);
VALA_EXTERN void chess_window_update_pause_resume_button (ChessWindow* self);
VALA_EXTERN void chess_window_update_game_status (ChessWindow* self,
                                      const gchar* title,
                                      const gchar* info);
static void chess_application_update_engine_timeout (ChessApplication* self);
static gint chess_application_time_to_move (ChessApplication* self);
static AIProfile* chess_application_get_ai_profile (ChessApplication* self,
                                             const gchar* name);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup7 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup8 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup9 (gchar** self,
                          gssize length);
static void chess_application_do_engine_move (ChessApplication* self,
                                       const gchar* move);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean ___lambda32_ (Block3Data* _data3_);
static gboolean ____lambda32__gsource_func (gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda33_ (Block4Data* _data4_);
static gboolean ___lambda33__gsource_func (gpointer self);
static gboolean ___lambda29_ (ChessApplication* self);
static gboolean ____lambda29__gsource_func (gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN void chess_window_move (ChessWindow* self,
                        ChessMove* m);
VALA_EXTERN GType chess_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessView, g_object_unref)
VALA_EXTERN ChessView* chess_application_get_view (ChessApplication* self);
static gboolean __lambda27_ (Block5Data* _data5_);
static void chess_application_present_claim_draw_dialog (ChessApplication* self);
static gboolean ___lambda27__gsource_func (gpointer self);
VALA_EXTERN void chess_window_undo (ChessWindow* self);
VALA_EXTERN gchar* chess_application_compute_current_title (ChessApplication* self);
VALA_EXTERN gchar* chess_application_compute_status_info (ChessApplication* self);
VALA_EXTERN void chess_window_end_game (ChessWindow* self);
static void chess_application_prompt_save_game (ChessApplication* self,
                                         const gchar* prompt_text,
                                         ChessApplicationPromptSaveGameCallback callback,
                                         gpointer callback_target);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda21_ (Block6Data* _data6_,
                  AdwAlertDialog* dialog,
                  const gchar* response);
static void chess_application_present_save_dialog (ChessApplication* self,
                                            ChessApplicationPresentSaveDialogCallback callback,
                                            gpointer callback_target,
                                            GDestroyNotify callback_target_destroy_notify);
static void ____lambda24_ (Block6Data* _data6_,
                    gboolean saved);
static void _____lambda24__chess_application_present_save_dialog_callback (gboolean saved,
                                                                    gpointer self);
static void ___lambda21__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                             const gchar* response,
                                             gpointer self);
static void __lambda28_ (ChessApplication* self,
                  AdwAlertDialog* dialog,
                  const gchar* response);
static void ___lambda28__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                             const gchar* response,
                                             gpointer self);
static void __lambda25_ (ChessApplication* self,
                  gboolean cancelled);
static void ___lambda25__chess_application_prompt_save_game_callback (gboolean cancelled,
                                                               gpointer self);
static void __lambda37_ (ChessApplication* self,
                  AdwAlertDialog* dialog,
                  const gchar* response);
static void ___lambda37__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                             const gchar* response,
                                             gpointer self);
VALA_EXTERN GType chess_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessModel, g_object_unref)
VALA_EXTERN void chess_scene_set_move_number (ChessScene* self,
                                  gint value);
VALA_EXTERN gint chess_scene_get_move_number (ChessScene* self);
VALA_EXTERN NewGameDialog* new_game_dialog_new (Preferences* preferences,
                                    GList* ai_profiles);
VALA_EXTERN NewGameDialog* new_game_dialog_construct (GType object_type,
                                          Preferences* preferences,
                                          GList* ai_profiles);
static void __lambda26_ (ChessApplication* self);
static void ___lambda26__new_game_dialog_new_game_requested (NewGameDialog* _sender,
                                                      gpointer self);
VALA_EXTERN PreferencesDialog* preferences_dialog_new (Preferences* preferences);
VALA_EXTERN PreferencesDialog* preferences_dialog_construct (GType object_type,
                                                 Preferences* preferences);
VALA_EXTERN GType promotion_type_selector_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PromotionTypeSelectorDialog, g_object_unref)
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
VALA_EXTERN const gchar* chess_scene_get_theme_name (ChessScene* self);
VALA_EXTERN PromotionTypeSelectorDialog* promotion_type_selector_dialog_new (Color color,
                                                                 const gchar* theme);
VALA_EXTERN PromotionTypeSelectorDialog* promotion_type_selector_dialog_construct (GType object_type,
                                                                       Color color,
                                                                       const gchar* theme);
VALA_EXTERN GType promotion_type_selector_dialog_selected_type_get_type (void) G_GNUC_CONST ;
static void __lambda39_ (Block7Data* _data7_,
                  PromotionTypeSelectorDialogSelectedType selected_type);
static void ___lambda39__promotion_type_selector_dialog_piece_selected (PromotionTypeSelectorDialog* _sender,
                                                                 PromotionTypeSelectorDialogSelectedType type,
                                                                 gpointer self);
static void chess_application_run_invalid_pgn_dialog (ChessApplication* self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda36_ (Block8Data* _data8_,
                  AdwAlertDialog* dialog,
                  const gchar* response);
static void ___lambda36__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                             const gchar* response,
                                             gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda30_ (Block9Data* _data9_,
                  AdwAlertDialog* dialog,
                  const gchar* response);
static void ___lambda30__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                             const gchar* response,
                                             gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda22_ (Block10Data* _data10_,
                  GObject* object,
                  GAsyncResult* _result_);
static void ___lambda23_ (Block10Data* _data10_,
                   AdwAlertDialog* dialog,
                   const gchar* response);
static void ____lambda23__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                              const gchar* response,
                                              gpointer self);
static void ___lambda22__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void __lambda34_ (ChessApplication* self,
                  gboolean cancelled);
static void __lambda35_ (ChessApplication* self,
                  GObject* object,
                  GAsyncResult* _result_);
static void ___lambda35__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ___lambda34__chess_application_prompt_save_game_callback (gboolean cancelled,
                                                               gpointer self);
static gint chess_application_main (gchar** args,
                             gint args_length1);
VALA_EXTERN ChessView* chess_window_get_view (ChessWindow* self);
VALA_EXTERN ChessScene* chess_view_get_scene (ChessView* self);
static void chess_application_finalize (GObject * obj);
static GType chess_application_get_type_once (void);
static void _vala_chess_application_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_chess_application_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry CHESS_APPLICATION_action_entries[15] = {{NEW_GAME_ACTION_NAME, _chess_application_new_game_cb_gsimple_action_activate_callback}, {OPEN_GAME_ACTION_NAME, _chess_application_open_game_cb_gsimple_action_activate_callback}, {SAVE_GAME_ACTION_NAME, _chess_application_save_game_cb_gsimple_action_activate_callback}, {SAVE_GAME_AS_ACTION_NAME, _chess_application_save_game_as_cb_gsimple_action_activate_callback}, {UNDO_MOVE_ACTION_NAME, _chess_application_undo_move_cb_gsimple_action_activate_callback}, {RESIGN_ACTION_NAME, _chess_application_resign_cb_gsimple_action_activate_callback}, {PAUSE_RESUME_ACTION_NAME, _chess_application_pause_resume_cb_gsimple_action_activate_callback}, {HISTORY_GO_FIRST_ACTION_NAME, _chess_application_history_go_first_cb_gsimple_action_activate_callback}, {HISTORY_GO_PREVIOUS_ACTION_NAME, _chess_application_history_go_previous_cb_gsimple_action_activate_callback}, {HISTORY_GO_NEXT_ACTION_NAME, _chess_application_history_go_next_cb_gsimple_action_activate_callback}, {HISTORY_GO_LAST_ACTION_NAME, _chess_application_history_go_last_cb_gsimple_action_activate_callback}, {PREFERENCES_ACTION_NAME, _chess_application_preferences_cb_gsimple_action_activate_callback}, {HELP_ACTION_NAME, _chess_application_help_cb_gsimple_action_activate_callback}, {ABOUT_ACTION_NAME, _chess_application_about_cb_gsimple_action_activate_callback}, {QUIT_ACTION_NAME, _chess_application_quit_cb_gsimple_action_activate_callback}};
static const GOptionEntry CHESS_APPLICATION_option_entries[2] = {{"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {NULL}};
static const gchar* CHESS_APPLICATION_authors[3] = {"Robert Ancell <robert.ancell@gmail.com>", "Michael Catanzaro <mcatanzaro@gnome.org>", NULL};
static const gchar* CHESS_APPLICATION_artists[3] = {"Max Froumentin", "Jakub Steiner", NULL};

static inline gpointer
chess_application_get_instance_private (ChessApplication* self)
{
	return G_STRUCT_MEMBER_P (self, ChessApplication_private_offset);
}

static void
_chess_application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	chess_application_new_game_cb ((ChessApplication*) self);
}

static void
_chess_application_open_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	chess_application_open_game_cb ((ChessApplication*) self);
}

static void
_chess_application_save_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	chess_application_save_game_cb ((ChessApplication*) self);
}

static void
_chess_application_save_game_as_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	chess_application_save_game_as_cb ((ChessApplication*) self);
}

static void
_chess_application_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	chess_application_undo_move_cb ((ChessApplication*) self);
}

static void
_chess_application_resign_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	chess_application_resign_cb ((ChessApplication*) self);
}

static void
_chess_application_pause_resume_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	chess_application_pause_resume_cb ((ChessApplication*) self);
}

static void
_chess_application_history_go_first_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	chess_application_history_go_first_cb ((ChessApplication*) self);
}

static void
_chess_application_history_go_previous_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self)
{
	chess_application_history_go_previous_cb ((ChessApplication*) self);
}

static void
_chess_application_history_go_next_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	chess_application_history_go_next_cb ((ChessApplication*) self);
}

static void
_chess_application_history_go_last_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	chess_application_history_go_last_cb ((ChessApplication*) self);
}

static void
_chess_application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	chess_application_preferences_cb ((ChessApplication*) self);
}

static void
_chess_application_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	chess_application_help_cb ((ChessApplication*) self);
}

static void
_chess_application_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	chess_application_about_cb ((ChessApplication*) self);
}

static void
_chess_application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	chess_application_quit_cb ((ChessApplication*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static ChessApplication*
chess_application_construct (GType object_type)
{
	ChessApplication * self = NULL;
	self = (ChessApplication*) g_object_new (object_type, "application-id", "org.gnome.Chess", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
	g_application_add_main_option_entries ((GApplication*) self, CHESS_APPLICATION_option_entries);
	return self;
}

static ChessApplication*
chess_application_new (void)
{
	return chess_application_construct (TYPE_CHESS_APPLICATION);
}

static gint
chess_application_real_handle_local_options (GApplication* base,
                                             GVariantDict* options)
{
	ChessApplication * self;
	gint result;
	self = (ChessApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "gnome-chess %s\n", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	result = -1;
	return result;
}

static void
chess_application_real_startup (GApplication* base)
{
	ChessApplication * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	Preferences* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gchar* _tmp28_;
	gchar** _tmp29_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gchar* _tmp31_;
	gchar** _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gchar* _tmp34_;
	gchar** _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar** _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	self = (ChessApplication*) base;
	G_APPLICATION_CLASS (chess_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	_tmp0_ = g_settings_new ("org.gnome.Chess");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = preferences_new (_tmp1_);
	_g_object_unref0 (self->priv->preferences);
	self->priv->preferences = _tmp2_;
	g_action_map_add_action_entries ((GActionMap*) self, CHESS_APPLICATION_action_entries, (gint) G_N_ELEMENTS (CHESS_APPLICATION_action_entries), self);
	_tmp3_ = g_strdup ("<Control>n");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." NEW_GAME_ACTION_NAME, _tmp5_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = g_strdup ("<Control>o");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." OPEN_GAME_ACTION_NAME, _tmp8_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = g_strdup ("<Control>s");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." SAVE_GAME_ACTION_NAME, _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_strdup ("<Shift><Control>s");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." SAVE_GAME_AS_ACTION_NAME, _tmp14_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = g_strdup ("<Control>z");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." UNDO_MOVE_ACTION_NAME, _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = g_strdup ("<Control>p");
	_tmp19_ = g_strdup ("Pause");
	_tmp20_ = g_new0 (gchar*, 2 + 1);
	_tmp20_[0] = _tmp18_;
	_tmp20_[1] = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp21__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." PAUSE_RESUME_ACTION_NAME, _tmp21_);
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
	_tmp22_ = g_strdup ("Up");
	_tmp23_ = g_new0 (gchar*, 1 + 1);
	_tmp23_[0] = _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp24__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." HISTORY_GO_FIRST_ACTION_NAME, _tmp24_);
	_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
	_tmp25_ = g_strdup ("Left");
	_tmp26_ = g_new0 (gchar*, 1 + 1);
	_tmp26_[0] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." HISTORY_GO_PREVIOUS_ACTION_NAME, _tmp27_);
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	_tmp28_ = g_strdup ("Right");
	_tmp29_ = g_new0 (gchar*, 1 + 1);
	_tmp29_[0] = _tmp28_;
	_tmp30_ = _tmp29_;
	_tmp30__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." HISTORY_GO_NEXT_ACTION_NAME, _tmp30_);
	_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
	_tmp31_ = g_strdup ("Down");
	_tmp32_ = g_new0 (gchar*, 1 + 1);
	_tmp32_[0] = _tmp31_;
	_tmp33_ = _tmp32_;
	_tmp33__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." HISTORY_GO_LAST_ACTION_NAME, _tmp33_);
	_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
	_tmp34_ = g_strdup ("F1");
	_tmp35_ = g_new0 (gchar*, 1 + 1);
	_tmp35_[0] = _tmp34_;
	_tmp36_ = _tmp35_;
	_tmp36__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." HELP_ACTION_NAME, _tmp36_);
	_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
	_tmp37_ = g_strdup ("<Control>q");
	_tmp38_ = g_strdup ("<Control>w");
	_tmp39_ = g_new0 (gchar*, 2 + 1);
	_tmp39_[0] = _tmp37_;
	_tmp39_[1] = _tmp38_;
	_tmp40_ = _tmp39_;
	_tmp40__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." QUIT_ACTION_NAME, _tmp40_);
	_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_free), NULL);
}

static gboolean
__lambda38_ (ChessApplication* self,
             ChessPlayer* p)
{
	ChessPlayer* _tmp0_;
	gboolean result;
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = self->priv->human_player;
	result = p == _tmp0_;
	return result;
}

static gboolean
___lambda38__chess_scene_is_human (ChessScene* _sender,
                                   ChessPlayer* player,
                                   gpointer self)
{
	gboolean result;
	result = __lambda38_ ((ChessApplication*) self, player);
	return result;
}

static void
_chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender,
                                                                                   ChessScenePromotionTypeCompletionHandler handler,
                                                                                   gpointer handler_target,
                                                                                   GDestroyNotify handler_target_destroy_notify,
                                                                                   gpointer self)
{
	chess_application_show_promotion_type_selector ((ChessApplication*) self, handler, handler_target, handler_target_destroy_notify);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
chess_application_create_window (ChessApplication* self)
{
	ChessWindow* _tmp0_;
	ChessWindow* _tmp1_;
	ChessWindow* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	ChessWindow* _tmp7_;
	GSettings* _tmp8_;
	ChessScene* _tmp9_;
	ChessScene* _tmp10_;
	GSettings* _tmp11_;
	ChessScene* _tmp12_;
	ChessScene* _tmp13_;
	GSettings* _tmp14_;
	ChessScene* _tmp15_;
	ChessScene* _tmp16_;
	GSettings* _tmp17_;
	ChessScene* _tmp18_;
	ChessScene* _tmp19_;
	ChessScene* _tmp20_;
	ChessScene* _tmp21_;
	ChessScene* _tmp22_;
	ChessScene* _tmp23_;
	gchar* system_engine_cfg = NULL;
	gchar* _tmp24_;
	gchar* user_engine_cfg = NULL;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	GList* _tmp33_;
	GFile* data_dir = NULL;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GFile* _tmp44_;
	GFile* _tmp45_;
	GFile* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GFile* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gboolean _tmp53_ = FALSE;
	GFile* _tmp54_;
	GFile* _tmp58_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_window_new (self);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	chess_application_set_window (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_window;
	_tmp3_ = self->priv->settings;
	_tmp4_ = self->priv->settings;
	gtk_window_set_default_size ((GtkWindow*) _tmp2_, g_settings_get_int (_tmp3_, WIDTH_SETTINGS_KEY), g_settings_get_int (_tmp4_, HEIGHT_SETTINGS_KEY));
	_tmp5_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp5_, MAXIMIZED_SETTINGS_KEY)) {
		ChessWindow* _tmp6_;
		_tmp6_ = self->priv->_window;
		gtk_window_maximize ((GtkWindow*) _tmp6_);
	}
	_tmp7_ = self->priv->_window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp7_);
	_tmp8_ = self->priv->settings;
	_tmp9_ = chess_application_get_scene (self);
	_tmp10_ = _tmp9_;
	g_settings_bind (_tmp8_, SHOW_BOARD_NUMBERING_SETTINGS_KEY, (GObject*) _tmp10_, "show-numbering", G_SETTINGS_BIND_GET);
	_tmp11_ = self->priv->settings;
	_tmp12_ = chess_application_get_scene (self);
	_tmp13_ = _tmp12_;
	g_settings_bind (_tmp11_, PIECE_STYLE_SETTINGS_KEY, (GObject*) _tmp13_, "theme-name", G_SETTINGS_BIND_GET);
	_tmp14_ = self->priv->settings;
	_tmp15_ = chess_application_get_scene (self);
	_tmp16_ = _tmp15_;
	g_settings_bind (_tmp14_, MOVE_FORMAT_SETTINGS_KEY, (GObject*) _tmp16_, "move-format", G_SETTINGS_BIND_GET);
	_tmp17_ = self->priv->settings;
	_tmp18_ = chess_application_get_scene (self);
	_tmp19_ = _tmp18_;
	g_settings_bind (_tmp17_, BOARD_ORIENTATION_SETTINGS_KEY, (GObject*) _tmp19_, "board-side", G_SETTINGS_BIND_GET);
	_tmp20_ = chess_application_get_scene (self);
	_tmp21_ = _tmp20_;
	g_signal_connect_object (_tmp21_, "is-human", (GCallback) ___lambda38__chess_scene_is_human, self, 0);
	_tmp22_ = chess_application_get_scene (self);
	_tmp23_ = _tmp22_;
	g_signal_connect_object (_tmp23_, "choose-promotion-type", (GCallback) _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type, self, 0);
	_tmp24_ = g_build_filename (SYSCONFDIR, "gnome-chess", "engines.conf", NULL, NULL);
	system_engine_cfg = _tmp24_;
	_tmp25_ = g_get_user_config_dir ();
	_tmp26_ = g_build_filename (_tmp25_, "gnome-chess", "engines.conf", NULL, NULL);
	user_engine_cfg = _tmp26_;
	_tmp27_ = user_engine_cfg;
	if (g_file_test (_tmp27_, G_FILE_TEST_EXISTS)) {
		const gchar* _tmp28_;
		GList* _tmp29_;
		_tmp28_ = user_engine_cfg;
		_tmp29_ = ai_profile_load_ai_profiles (_tmp28_);
		(self->priv->ai_profiles == NULL) ? NULL : (self->priv->ai_profiles = (_g_list_free__g_object_unref0_ (self->priv->ai_profiles), NULL));
		self->priv->ai_profiles = _tmp29_;
	} else {
		const gchar* _tmp30_;
		_tmp30_ = system_engine_cfg;
		if (g_file_test (_tmp30_, G_FILE_TEST_EXISTS)) {
			const gchar* _tmp31_;
			GList* _tmp32_;
			_tmp31_ = system_engine_cfg;
			_tmp32_ = ai_profile_load_ai_profiles (_tmp31_);
			(self->priv->ai_profiles == NULL) ? NULL : (self->priv->ai_profiles = (_g_list_free__g_object_unref0_ (self->priv->ai_profiles), NULL));
			self->priv->ai_profiles = _tmp32_;
		} else {
			g_warning ("gnome-chess.vala:172: engines.conf not found");
		}
	}
	_tmp33_ = self->priv->ai_profiles;
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
		profile_collection = _tmp33_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			AIProfile* _tmp34_;
			AIProfile* profile = NULL;
			_tmp34_ = _g_object_ref0 ((AIProfile*) profile_it->data);
			profile = _tmp34_;
			{
				AIProfile* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				AIProfile* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				_tmp35_ = profile;
				_tmp36_ = ai_profile_get_name (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = profile;
				_tmp39_ = ai_profile_get_path (_tmp38_);
				_tmp40_ = _tmp39_;
				g_debug ("gnome-chess.vala:175: Detected AI profile %s in %s", _tmp37_, _tmp40_);
				_g_object_unref0 (profile);
			}
		}
	}
	_tmp41_ = g_get_user_data_dir ();
	_tmp42_ = g_build_filename (_tmp41_, "gnome-chess", NULL, NULL);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_file_new_for_path (_tmp43_);
	_tmp45_ = _tmp44_;
	_g_free0 (_tmp43_);
	data_dir = _tmp45_;
	_tmp46_ = data_dir;
	_tmp47_ = g_file_get_path (_tmp46_);
	_tmp48_ = _tmp47_;
	g_mkdir_with_parents (_tmp48_, 0755);
	_g_free0 (_tmp48_);
	_tmp49_ = data_dir;
	_tmp50_ = g_file_get_path (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_strconcat (_tmp51_, "/autosave.pgn", NULL);
	_g_free0 (self->priv->autosave_filename);
	self->priv->autosave_filename = _tmp52_;
	_g_free0 (_tmp51_);
	_tmp54_ = self->priv->game_file;
	if (_tmp54_ == NULL) {
		const gchar* _tmp55_;
		_tmp55_ = self->priv->autosave_filename;
		_tmp53_ = g_file_test (_tmp55_, G_FILE_TEST_EXISTS);
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		const gchar* _tmp56_;
		GFile* _tmp57_;
		_tmp56_ = self->priv->autosave_filename;
		_tmp57_ = g_file_new_for_path (_tmp56_);
		_g_object_unref0 (self->priv->game_file);
		self->priv->game_file = _tmp57_;
	}
	_tmp58_ = self->priv->game_file;
	if (_tmp58_ == NULL) {
		chess_application_start_new_game (self);
	} else {
		GFile* _tmp59_;
		_tmp59_ = self->priv->game_file;
		chess_application_load_game (self, _tmp59_);
	}
	_g_object_unref0 (data_dir);
	_g_free0 (user_engine_cfg);
	_g_free0 (system_engine_cfg);
}

static void
chess_application_real_open (GApplication* base,
                             GFile** files,
                             gint files_length1,
                             const gchar* hint)
{
	ChessApplication * self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	self = (ChessApplication*) base;
	g_return_if_fail (hint != NULL);
	if (files_length1 != 1) {
		g_warning ("gnome-chess.vala:197: %s", _ ("GNOME Chess can only open one PGN at a time."));
	}
	_tmp0_ = files[0];
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = _tmp1_;
	g_application_activate ((GApplication*) self);
}

static void
chess_application_real_activate (GApplication* base)
{
	ChessApplication * self;
	ChessWindow* _tmp0_;
	ChessWindow* _tmp1_;
	self = (ChessApplication*) base;
	_tmp0_ = self->priv->_window;
	if (_tmp0_ == NULL) {
		chess_application_create_window (self);
	}
	_tmp1_ = self->priv->_window;
	gtk_window_present ((GtkWindow*) _tmp1_);
}

static void
chess_application_real_shutdown (GApplication* base)
{
	ChessApplication * self;
	ChessWindow* _tmp0_;
	self = (ChessApplication*) base;
	_tmp0_ = self->priv->_window;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_;
		GSettings* _tmp3_;
		GSettings* _tmp4_;
		ChessWindow* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GSettings* _tmp8_;
		ChessWindow* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		GSettings* _tmp12_;
		ChessWindow* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		GSettings* _tmp16_;
		_tmp1_ = self->priv->opponent_engine;
		if (_tmp1_ != NULL) {
			ChessEngine* _tmp2_;
			_tmp2_ = self->priv->opponent_engine;
			chess_engine_stop (_tmp2_, TRUE);
		}
		chess_application_autosave (self);
		_tmp3_ = self->priv->settings;
		g_settings_delay (_tmp3_);
		_tmp4_ = self->priv->settings;
		_tmp5_ = self->priv->_window;
		g_object_get ((GtkWindow*) _tmp5_, "default-width", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		g_settings_set_int (_tmp4_, WIDTH_SETTINGS_KEY, _tmp7_);
		_tmp8_ = self->priv->settings;
		_tmp9_ = self->priv->_window;
		g_object_get ((GtkWindow*) _tmp9_, "default-height", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		g_settings_set_int (_tmp8_, HEIGHT_SETTINGS_KEY, _tmp11_);
		_tmp12_ = self->priv->settings;
		_tmp13_ = self->priv->_window;
		g_object_get ((GtkWindow*) _tmp13_, "maximized", &_tmp14_, NULL);
		_tmp15_ = _tmp14_;
		g_settings_set_boolean (_tmp12_, MAXIMIZED_SETTINGS_KEY, _tmp15_);
		_tmp16_ = self->priv->settings;
		g_settings_apply (_tmp16_);
	}
	G_APPLICATION_CLASS (chess_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
}

void
chess_application_quit_game (ChessApplication* self)
{
	ChessWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
}

static void
chess_application_autosave (ChessApplication* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->game_needs_saving) {
		const gchar* _tmp0_;
		_tmp0_ = self->priv->autosave_filename;
		g_remove (_tmp0_);
		return;
	}
	{
		GFile* autosave_file = NULL;
		const gchar* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		PGNGame* _tmp6_;
		GFile* _tmp7_;
		_tmp1_ = self->priv->autosave_filename;
		_tmp2_ = g_file_new_for_path (_tmp1_);
		autosave_file = _tmp2_;
		_tmp3_ = autosave_file;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		g_debug ("gnome-chess.vala:249: Writing current game to %s", _tmp5_);
		_g_free0 (_tmp5_);
		chess_application_update_pgn_time_remaining (self);
		_tmp6_ = self->priv->pgn_game;
		_tmp7_ = autosave_file;
		pgn_game_write (_tmp6_, _tmp7_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (autosave_file);
			goto __catch0_g_error;
		}
		_g_object_unref0 (autosave_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("gnome-chess.vala:255: Failed to autosave: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_chess_application_game_turn_cb_chess_game_turn_started (ChessGame* _sender,
                                                         ChessPlayer* player,
                                                         gpointer self)
{
	chess_application_game_turn_cb ((ChessApplication*) self, _sender, player);
}

static void
_chess_application_game_move_cb_chess_game_moved (ChessGame* _sender,
                                                  ChessMove* move,
                                                  gpointer self)
{
	chess_application_game_move_cb ((ChessApplication*) self, _sender, move);
}

static void
_chess_application_game_undo_cb_chess_game_undo (ChessGame* _sender,
                                                 gpointer self)
{
	chess_application_game_undo_cb ((ChessApplication*) self, _sender);
}

static void
_chess_application_game_end_cb_chess_game_ended (ChessGame* _sender,
                                                 gpointer self)
{
	chess_application_game_end_cb ((ChessApplication*) self);
}

static void
_chess_application_engine_move_cb_chess_engine_moved (ChessEngine* _sender,
                                                      const gchar* move,
                                                      gpointer self)
{
	chess_application_engine_move_cb ((ChessApplication*) self, _sender, move);
}

static void
_chess_application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender,
                                                             gpointer self)
{
	chess_application_engine_resigned_cb ((ChessApplication*) self, _sender);
}

static void
_chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly (ChessEngine* _sender,
                                                                                     gpointer self)
{
	chess_application_engine_stopped_unexpectedly_cb ((ChessApplication*) self, _sender);
}

static void
_chess_application_engine_error_cb_chess_engine_error (ChessEngine* _sender,
                                                       gpointer self)
{
	chess_application_engine_error_cb ((ChessApplication*) self, _sender);
}

static void
_chess_application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender,
                                                                 gpointer self)
{
	chess_application_engine_claim_draw_cb ((ChessApplication*) self, _sender);
}

static void
_chess_application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender,
                                                                 gpointer self)
{
	chess_application_engine_offer_draw_cb ((ChessApplication*) self, _sender);
}

static void
chess_application_start_game (ChessApplication* self)
{
	gchar* fen = NULL;
	gchar* _tmp0_;
	gchar** moves = NULL;
	PGNGame* _tmp1_;
	GList* _tmp2_;
	gchar** _tmp3_;
	gint moves_length1;
	gint _moves_size_;
	gint i = 0;
	PGNGame* _tmp4_;
	GList* _tmp5_;
	PGNGame* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	ChessGame* _tmp21_;
	gboolean _tmp36_ = FALSE;
	PGNGame* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	ChessGame* _tmp60_;
	ChessGame* _tmp61_;
	ChessGame* _tmp62_;
	ChessGame* _tmp63_;
	ChessScene* _tmp64_;
	ChessScene* _tmp65_;
	ChessGame* _tmp66_;
	ChessWindow* _tmp67_;
	gchar* white_engine = NULL;
	PGNGame* _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* white_level = NULL;
	PGNGame* _tmp72_;
	const gchar* _tmp73_;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	const gchar* _tmp76_;
	gchar* black_engine = NULL;
	PGNGame* _tmp78_;
	const gchar* _tmp79_;
	const gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* black_level = NULL;
	PGNGame* _tmp82_;
	const gchar* _tmp83_;
	const gchar* _tmp84_;
	gchar* _tmp85_;
	const gchar* _tmp86_;
	ChessEngine* _tmp88_;
	const gchar* _tmp102_;
	ChessEngine* _tmp126_;
	gboolean _tmp155_ = FALSE;
	GFile* _tmp156_;
	ChessGame* _tmp161_;
	gint timer_increment_adj_value = 0;
	PGNGame* _tmp162_;
	const gchar* _tmp163_;
	const gchar* _tmp164_;
	ChessClockType clock_type = 0;
	PGNGame* _tmp172_;
	const gchar* _tmp173_;
	const gchar* _tmp174_;
	ChessWindow* _tmp184_;
	ChessGame* _tmp185_;
	ChessClock* _tmp186_;
	ChessClock* _tmp187_;
	ChessGame* _tmp188_;
	ChessClock* _tmp189_;
	ChessClock* _tmp190_;
	PGNGame* _tmp197_;
	const gchar* _tmp198_;
	const gchar* _tmp199_;
	const gchar* _tmp200_;
	ChessEngine* _tmp212_;
	gboolean _tmp214_ = FALSE;
	gchar** _tmp215_;
	gint _tmp215__length1;
	ChessWindow* _tmp222_;
	ChessWindow* _tmp223_;
	GList* _tmp224_;
	gboolean _tmp227_ = FALSE;
	ChessEngine* _tmp228_;
	ChessGame* _tmp244_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->starting = TRUE;
	_tmp0_ = g_strdup (CHESS_GAME_STANDARD_SETUP);
	fen = _tmp0_;
	_tmp1_ = self->priv->pgn_game;
	_tmp2_ = _tmp1_->moves;
	_tmp3_ = g_new0 (gchar*, g_list_length (_tmp2_) + 1);
	moves = _tmp3_;
	moves_length1 = g_list_length (_tmp2_);
	_moves_size_ = moves_length1;
	i = 0;
	_tmp4_ = self->priv->pgn_game;
	_tmp5_ = _tmp4_->moves;
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
		move_collection = _tmp5_;
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
			gchar* _tmp6_;
			gchar* move = NULL;
			_tmp6_ = g_strdup ((const gchar*) move_it->data);
			move = _tmp6_;
			{
				gchar** _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp7_ = moves;
				_tmp7__length1 = moves_length1;
				_tmp8_ = i;
				i = _tmp8_ + 1;
				_tmp9_ = move;
				_tmp10_ = g_strdup (_tmp9_);
				_g_free0 (_tmp7_[_tmp8_]);
				_tmp7_[_tmp8_] = _tmp10_;
				_g_free0 (move);
			}
		}
	}
	_tmp11_ = self->priv->pgn_game;
	_tmp12_ = pgn_game_get_set_up (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		PGNGame* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp14_ = self->priv->pgn_game;
		_tmp15_ = pgn_game_get_fen (_tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_ != NULL) {
			PGNGame* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp17_ = self->priv->pgn_game;
			_tmp18_ = pgn_game_get_fen (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strdup (_tmp19_);
			_g_free0 (fen);
			fen = _tmp20_;
		} else {
			g_warning ("gnome-chess.vala:274: Chess game has SetUp tag but no FEN tag");
		}
	}
	_tmp21_ = self->priv->game;
	if (_tmp21_ != NULL) {
		ChessGame* _tmp22_;
		guint _tmp23_;
		ChessGame* _tmp24_;
		guint _tmp25_;
		ChessGame* _tmp26_;
		guint _tmp27_;
		ChessGame* _tmp28_;
		_tmp22_ = self->priv->game;
		g_signal_parse_name ("turn-started", TYPE_CHESS_GAME, &_tmp23_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _chess_application_game_turn_cb_chess_game_turn_started, self);
		_tmp24_ = self->priv->game;
		g_signal_parse_name ("moved", TYPE_CHESS_GAME, &_tmp25_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp24_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp25_, 0, NULL, (GCallback) _chess_application_game_move_cb_chess_game_moved, self);
		_tmp26_ = self->priv->game;
		g_signal_parse_name ("undo", TYPE_CHESS_GAME, &_tmp27_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp26_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp27_, 0, NULL, (GCallback) _chess_application_game_undo_cb_chess_game_undo, self);
		_tmp28_ = self->priv->game;
		g_signal_connect_object (_tmp28_, "ended", (GCallback) _chess_application_game_end_cb_chess_game_ended, self, 0);
	}
	{
		ChessGame* _tmp29_ = NULL;
		const gchar* _tmp30_;
		gchar** _tmp31_;
		gint _tmp31__length1;
		ChessGame* _tmp32_;
		ChessGame* _tmp33_;
		_tmp30_ = fen;
		_tmp31_ = moves;
		_tmp31__length1 = moves_length1;
		_tmp32_ = chess_game_new (_tmp30_, _tmp31_, _tmp31__length1, &_inner_error0_);
		_tmp29_ = _tmp32_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp33_ = _tmp29_;
		_tmp29_ = NULL;
		_g_object_unref0 (self->priv->game);
		self->priv->game = _tmp33_;
		_g_object_unref0 (_tmp29_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp34_ = e;
		_tmp35_ = _tmp34_->message;
		chess_application_show_invalid_move_dialog (self, _tmp35_);
		chess_application_configure_new_game (self);
		_g_error_free0 (e);
		moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (fen);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (fen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp37_ = self->priv->pgn_game;
	_tmp38_ = pgn_game_get_time_control (_tmp37_);
	_tmp39_ = _tmp38_;
	if (_tmp39_ != NULL) {
		PGNGame* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		_tmp40_ = self->priv->pgn_game;
		_tmp41_ = pgn_game_get_time_control (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp36_ = atoi (_tmp42_) != 0;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		gboolean _tmp43_ = FALSE;
		PGNGame* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		_tmp44_ = self->priv->pgn_game;
		_tmp45_ = pgn_game_get_white_time_left (_tmp44_);
		_tmp46_ = _tmp45_;
		if (_tmp46_ != NULL) {
			PGNGame* _tmp47_;
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			_tmp47_ = self->priv->pgn_game;
			_tmp48_ = pgn_game_get_black_time_left (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp43_ = _tmp49_ != NULL;
		} else {
			_tmp43_ = FALSE;
		}
		if (_tmp43_) {
			gint white_seconds = 0;
			PGNGame* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			gint black_seconds = 0;
			PGNGame* _tmp53_;
			const gchar* _tmp54_;
			const gchar* _tmp55_;
			gboolean _tmp56_ = FALSE;
			_tmp50_ = self->priv->pgn_game;
			_tmp51_ = pgn_game_get_white_time_left (_tmp50_);
			_tmp52_ = _tmp51_;
			white_seconds = atoi (_tmp52_);
			_tmp53_ = self->priv->pgn_game;
			_tmp54_ = pgn_game_get_black_time_left (_tmp53_);
			_tmp55_ = _tmp54_;
			black_seconds = atoi (_tmp55_);
			if (white_seconds >= 0) {
				_tmp56_ = black_seconds >= 0;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				ChessGame* _tmp57_;
				ChessClock* _tmp58_;
				ChessClock* _tmp59_;
				_tmp57_ = self->priv->game;
				_tmp58_ = chess_clock_new (white_seconds, black_seconds);
				_tmp59_ = _tmp58_;
				chess_game_set_clock (_tmp57_, _tmp59_);
				_g_object_unref0 (_tmp59_);
			}
		}
	}
	_tmp60_ = self->priv->game;
	g_signal_connect_object (_tmp60_, "turn-started", (GCallback) _chess_application_game_turn_cb_chess_game_turn_started, self, 0);
	_tmp61_ = self->priv->game;
	g_signal_connect_object (_tmp61_, "moved", (GCallback) _chess_application_game_move_cb_chess_game_moved, self, 0);
	_tmp62_ = self->priv->game;
	g_signal_connect_object (_tmp62_, "undo", (GCallback) _chess_application_game_undo_cb_chess_game_undo, self, 0);
	_tmp63_ = self->priv->game;
	g_signal_connect_object (_tmp63_, "ended", (GCallback) _chess_application_game_end_cb_chess_game_ended, self, 0);
	_tmp64_ = chess_application_get_scene (self);
	_tmp65_ = _tmp64_;
	_tmp66_ = self->priv->game;
	chess_scene_set_game (_tmp65_, _tmp66_);
	_tmp67_ = self->priv->_window;
	chess_window_start_game (_tmp67_);
	_tmp68_ = self->priv->pgn_game;
	_tmp69_ = pgn_game_get_white_ai (_tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = g_strdup (_tmp70_);
	white_engine = _tmp71_;
	_tmp72_ = self->priv->pgn_game;
	_tmp73_ = pgn_game_get_white_level (_tmp72_);
	_tmp74_ = _tmp73_;
	_tmp75_ = g_strdup (_tmp74_);
	white_level = _tmp75_;
	_tmp76_ = white_level;
	if (_tmp76_ == NULL) {
		gchar* _tmp77_;
		_tmp77_ = g_strdup ("normal");
		_g_free0 (white_level);
		white_level = _tmp77_;
	}
	_tmp78_ = self->priv->pgn_game;
	_tmp79_ = pgn_game_get_black_ai (_tmp78_);
	_tmp80_ = _tmp79_;
	_tmp81_ = g_strdup (_tmp80_);
	black_engine = _tmp81_;
	_tmp82_ = self->priv->pgn_game;
	_tmp83_ = pgn_game_get_black_level (_tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = g_strdup (_tmp84_);
	black_level = _tmp85_;
	_tmp86_ = black_level;
	if (_tmp86_ == NULL) {
		gchar* _tmp87_;
		_tmp87_ = g_strdup ("normal");
		_g_free0 (black_level);
		black_level = _tmp87_;
	}
	_g_object_unref0 (self->priv->human_player);
	self->priv->human_player = NULL;
	_g_object_unref0 (self->priv->opponent);
	self->priv->opponent = NULL;
	_tmp88_ = self->priv->opponent_engine;
	if (_tmp88_ != NULL) {
		ChessEngine* _tmp89_;
		ChessEngine* _tmp90_;
		guint _tmp91_;
		ChessEngine* _tmp92_;
		guint _tmp93_;
		ChessEngine* _tmp94_;
		guint _tmp95_;
		ChessEngine* _tmp96_;
		guint _tmp97_;
		ChessEngine* _tmp98_;
		guint _tmp99_;
		ChessEngine* _tmp100_;
		guint _tmp101_;
		_tmp89_ = self->priv->opponent_engine;
		chess_engine_stop (_tmp89_, TRUE);
		_tmp90_ = self->priv->opponent_engine;
		g_signal_parse_name ("moved", TYPE_CHESS_ENGINE, &_tmp91_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp90_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp91_, 0, NULL, (GCallback) _chess_application_engine_move_cb_chess_engine_moved, self);
		_tmp92_ = self->priv->opponent_engine;
		g_signal_parse_name ("resigned", TYPE_CHESS_ENGINE, &_tmp93_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp92_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp93_, 0, NULL, (GCallback) _chess_application_engine_resigned_cb_chess_engine_resigned, self);
		_tmp94_ = self->priv->opponent_engine;
		g_signal_parse_name ("stopped-unexpectedly", TYPE_CHESS_ENGINE, &_tmp95_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp94_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp95_, 0, NULL, (GCallback) _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly, self);
		_tmp96_ = self->priv->opponent_engine;
		g_signal_parse_name ("error", TYPE_CHESS_ENGINE, &_tmp97_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp96_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp97_, 0, NULL, (GCallback) _chess_application_engine_error_cb_chess_engine_error, self);
		_tmp98_ = self->priv->opponent_engine;
		g_signal_parse_name ("claim-draw", TYPE_CHESS_ENGINE, &_tmp99_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp98_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp99_, 0, NULL, (GCallback) _chess_application_engine_claim_draw_cb_chess_engine_claim_draw, self);
		_tmp100_ = self->priv->opponent_engine;
		g_signal_parse_name ("offer-draw", TYPE_CHESS_ENGINE, &_tmp101_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp100_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp101_, 0, NULL, (GCallback) _chess_application_engine_offer_draw_cb_chess_engine_offer_draw, self);
		_g_object_unref0 (self->priv->opponent_engine);
		self->priv->opponent_engine = NULL;
	}
	_tmp102_ = white_engine;
	if (_tmp102_ != NULL) {
		ChessGame* _tmp103_;
		ChessPlayer* _tmp104_;
		ChessPlayer* _tmp105_;
		ChessPlayer* _tmp106_;
		ChessGame* _tmp107_;
		ChessPlayer* _tmp108_;
		ChessPlayer* _tmp109_;
		ChessPlayer* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		ChessEngine* _tmp113_;
		_tmp103_ = self->priv->game;
		_tmp104_ = chess_game_get_white (_tmp103_);
		_tmp105_ = _tmp104_;
		_tmp106_ = _g_object_ref0 (_tmp105_);
		_g_object_unref0 (self->priv->opponent);
		self->priv->opponent = _tmp106_;
		_tmp107_ = self->priv->game;
		_tmp108_ = chess_game_get_black (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = _g_object_ref0 (_tmp109_);
		_g_object_unref0 (self->priv->human_player);
		self->priv->human_player = _tmp110_;
		_tmp111_ = white_engine;
		_tmp112_ = white_level;
		_tmp113_ = chess_application_get_engine (self, _tmp111_, _tmp112_);
		_g_object_unref0 (self->priv->opponent_engine);
		self->priv->opponent_engine = _tmp113_;
	} else {
		const gchar* _tmp114_;
		_tmp114_ = black_engine;
		if (_tmp114_ != NULL) {
			ChessGame* _tmp115_;
			ChessPlayer* _tmp116_;
			ChessPlayer* _tmp117_;
			ChessPlayer* _tmp118_;
			ChessGame* _tmp119_;
			ChessPlayer* _tmp120_;
			ChessPlayer* _tmp121_;
			ChessPlayer* _tmp122_;
			const gchar* _tmp123_;
			const gchar* _tmp124_;
			ChessEngine* _tmp125_;
			_tmp115_ = self->priv->game;
			_tmp116_ = chess_game_get_black (_tmp115_);
			_tmp117_ = _tmp116_;
			_tmp118_ = _g_object_ref0 (_tmp117_);
			_g_object_unref0 (self->priv->opponent);
			self->priv->opponent = _tmp118_;
			_tmp119_ = self->priv->game;
			_tmp120_ = chess_game_get_white (_tmp119_);
			_tmp121_ = _tmp120_;
			_tmp122_ = _g_object_ref0 (_tmp121_);
			_g_object_unref0 (self->priv->human_player);
			self->priv->human_player = _tmp122_;
			_tmp123_ = black_engine;
			_tmp124_ = black_level;
			_tmp125_ = chess_application_get_engine (self, _tmp123_, _tmp124_);
			_g_object_unref0 (self->priv->opponent_engine);
			self->priv->opponent_engine = _tmp125_;
		}
	}
	_tmp126_ = self->priv->opponent_engine;
	if (_tmp126_ == NULL) {
		ChessGame* _tmp127_;
		ChessPlayer* _tmp128_;
		ChessPlayer* _tmp129_;
		ChessGame* _tmp130_;
		ChessPlayer* _tmp131_;
		ChessPlayer* _tmp132_;
		_tmp127_ = self->priv->game;
		_tmp128_ = chess_game_get_black (_tmp127_);
		_tmp129_ = _tmp128_;
		chess_player_set_local_human (_tmp129_, TRUE);
		_tmp130_ = self->priv->game;
		_tmp131_ = chess_game_get_white (_tmp130_);
		_tmp132_ = _tmp131_;
		chess_player_set_local_human (_tmp132_, TRUE);
		_g_object_unref0 (self->priv->human_player);
		self->priv->human_player = NULL;
	} else {
		ChessPlayer* _tmp133_;
		ChessPlayer* _tmp134_;
		ChessEngine* _tmp135_;
		ChessEngine* _tmp136_;
		ChessEngine* _tmp137_;
		ChessEngine* _tmp138_;
		ChessEngine* _tmp139_;
		ChessEngine* _tmp140_;
		ChessEngine* _tmp141_;
		_tmp133_ = self->priv->opponent;
		chess_player_set_local_human (_tmp133_, FALSE);
		_tmp134_ = self->priv->human_player;
		chess_player_set_local_human (_tmp134_, TRUE);
		_tmp135_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp135_, "moved", (GCallback) _chess_application_engine_move_cb_chess_engine_moved, self, 0);
		_tmp136_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp136_, "resigned", (GCallback) _chess_application_engine_resigned_cb_chess_engine_resigned, self, 0);
		_tmp137_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp137_, "stopped-unexpectedly", (GCallback) _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly, self, 0);
		_tmp138_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp138_, "error", (GCallback) _chess_application_engine_error_cb_chess_engine_error, self, 0);
		_tmp139_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp139_, "claim-draw", (GCallback) _chess_application_engine_claim_draw_cb_chess_engine_claim_draw, self, 0);
		_tmp140_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp140_, "offer-draw", (GCallback) _chess_application_engine_offer_draw_cb_chess_engine_offer_draw, self, 0);
		_tmp141_ = self->priv->opponent_engine;
		if (!chess_engine_start (_tmp141_)) {
			ChessGame* _tmp142_;
			ChessGame* _tmp143_;
			chess_application_disable_action (self, SAVE_GAME_ACTION_NAME);
			_tmp142_ = self->priv->game;
			_tmp142_->result = CHESS_RESULT_BUG;
			_tmp143_ = self->priv->game;
			_tmp143_->rule = CHESS_RULE_BUG;
			chess_application_game_end_cb (self);
			_g_free0 (black_level);
			_g_free0 (black_engine);
			_g_free0 (white_level);
			_g_free0 (white_engine);
			moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (fen);
			return;
		}
	}
	{
		gint j = 0;
		ChessGame* _tmp144_;
		GList* _tmp145_;
		_tmp144_ = self->priv->game;
		_tmp145_ = _tmp144_->move_stack;
		j = ((gint) g_list_length (_tmp145_)) - 2;
		{
			gboolean _tmp146_ = FALSE;
			_tmp146_ = TRUE;
			while (TRUE) {
				ChessState* state = NULL;
				ChessGame* _tmp148_;
				GList* _tmp149_;
				gconstpointer _tmp150_;
				ChessState* _tmp151_;
				ChessGame* _tmp152_;
				ChessState* _tmp153_;
				ChessMove* _tmp154_;
				if (!_tmp146_) {
					gint _tmp147_;
					_tmp147_ = j;
					j = _tmp147_ - 1;
				}
				_tmp146_ = FALSE;
				if (!(j >= 0)) {
					break;
				}
				_tmp148_ = self->priv->game;
				_tmp149_ = _tmp148_->move_stack;
				_tmp150_ = g_list_nth_data (_tmp149_, (guint) j);
				_tmp151_ = _g_object_ref0 ((ChessState*) _tmp150_);
				state = _tmp151_;
				_tmp152_ = self->priv->game;
				_tmp153_ = state;
				_tmp154_ = _tmp153_->last_move;
				chess_application_game_move_cb (self, _tmp152_, _tmp154_);
				_g_object_unref0 (state);
			}
		}
	}
	_tmp156_ = self->priv->game_file;
	if (_tmp156_ != NULL) {
		GFile* _tmp157_;
		gchar* _tmp158_;
		gchar* _tmp159_;
		const gchar* _tmp160_;
		_tmp157_ = self->priv->game_file;
		_tmp158_ = g_file_get_path (_tmp157_);
		_tmp159_ = _tmp158_;
		_tmp160_ = self->priv->autosave_filename;
		_tmp155_ = g_strcmp0 (_tmp159_, _tmp160_) == 0;
		_g_free0 (_tmp159_);
	} else {
		_tmp155_ = FALSE;
	}
	if (_tmp155_) {
		self->priv->game_needs_saving = TRUE;
		chess_application_enable_action (self, SAVE_GAME_ACTION_NAME);
	} else {
		self->priv->game_needs_saving = FALSE;
		chess_application_disable_action (self, SAVE_GAME_ACTION_NAME);
	}
	_tmp161_ = self->priv->game;
	chess_game_start (_tmp161_);
	timer_increment_adj_value = 0;
	_tmp162_ = self->priv->pgn_game;
	_tmp163_ = pgn_game_get_timer_increment (_tmp162_);
	_tmp164_ = _tmp163_;
	if (_tmp164_ != NULL) {
		PGNGame* _tmp165_;
		const gchar* _tmp166_;
		const gchar* _tmp167_;
		_tmp165_ = self->priv->pgn_game;
		_tmp166_ = pgn_game_get_timer_increment (_tmp165_);
		_tmp167_ = _tmp166_;
		timer_increment_adj_value = atoi (_tmp167_);
	} else {
		GSettings* _tmp168_;
		PGNGame* _tmp169_;
		gchar* _tmp170_;
		gchar* _tmp171_;
		_tmp168_ = self->priv->settings;
		timer_increment_adj_value = g_settings_get_int (_tmp168_, INCREMENT_SETTINGS_KEY);
		_tmp169_ = self->priv->pgn_game;
		_tmp170_ = g_strdup_printf ("%i", timer_increment_adj_value);
		_tmp171_ = _tmp170_;
		pgn_game_set_timer_increment (_tmp169_, _tmp171_);
		_g_free0 (_tmp171_);
	}
	clock_type = CHESS_CLOCK_TYPE_SIMPLE;
	_tmp172_ = self->priv->pgn_game;
	_tmp173_ = pgn_game_get_clock_type (_tmp172_);
	_tmp174_ = _tmp173_;
	if (_tmp174_ != NULL) {
		PGNGame* _tmp175_;
		const gchar* _tmp176_;
		const gchar* _tmp177_;
		_tmp175_ = self->priv->pgn_game;
		_tmp176_ = pgn_game_get_clock_type (_tmp175_);
		_tmp177_ = _tmp176_;
		clock_type = chess_clock_type_string_to_enum (_tmp177_);
	} else {
		GSettings* _tmp178_;
		gchar* _tmp179_;
		gchar* _tmp180_;
		PGNGame* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		_tmp178_ = self->priv->settings;
		_tmp179_ = g_settings_get_string (_tmp178_, CLOCK_TYPE_SETTINGS_KEY);
		_tmp180_ = _tmp179_;
		clock_type = chess_clock_type_string_to_enum (_tmp180_);
		_g_free0 (_tmp180_);
		_tmp181_ = self->priv->pgn_game;
		_tmp182_ = chess_clock_type_to_string (clock_type);
		_tmp183_ = _tmp182_;
		pgn_game_set_clock_type (_tmp181_, _tmp183_);
		_g_free0 (_tmp183_);
	}
	_tmp184_ = self->priv->_window;
	_tmp185_ = self->priv->game;
	_tmp186_ = chess_game_get_clock (_tmp185_);
	_tmp187_ = _tmp186_;
	chess_window_set_clock_visible (_tmp184_, _tmp187_ != NULL);
	_tmp188_ = self->priv->game;
	_tmp189_ = chess_game_get_clock (_tmp188_);
	_tmp190_ = _tmp189_;
	if (_tmp190_ != NULL) {
		ChessGame* _tmp191_;
		ChessClock* _tmp192_;
		ChessClock* _tmp193_;
		ChessGame* _tmp194_;
		ChessClock* _tmp195_;
		ChessClock* _tmp196_;
		_tmp191_ = self->priv->game;
		_tmp192_ = chess_game_get_clock (_tmp191_);
		_tmp193_ = _tmp192_;
		chess_clock_set_extra_seconds (_tmp193_, (gint) timer_increment_adj_value);
		_tmp194_ = self->priv->game;
		_tmp195_ = chess_game_get_clock (_tmp194_);
		_tmp196_ = _tmp195_;
		chess_clock_set_clock_type (_tmp196_, clock_type);
	}
	_tmp197_ = self->priv->pgn_game;
	_tmp198_ = pgn_game_get_result (_tmp197_);
	_tmp199_ = _tmp198_;
	_tmp200_ = pgn_game_RESULT_WHITE;
	if (g_strcmp0 (_tmp199_, _tmp200_) == 0) {
		ChessGame* _tmp201_;
		_tmp201_ = self->priv->game;
		_tmp201_->result = CHESS_RESULT_WHITE_WON;
	} else {
		PGNGame* _tmp202_;
		const gchar* _tmp203_;
		const gchar* _tmp204_;
		const gchar* _tmp205_;
		_tmp202_ = self->priv->pgn_game;
		_tmp203_ = pgn_game_get_result (_tmp202_);
		_tmp204_ = _tmp203_;
		_tmp205_ = pgn_game_RESULT_BLACK;
		if (g_strcmp0 (_tmp204_, _tmp205_) == 0) {
			ChessGame* _tmp206_;
			_tmp206_ = self->priv->game;
			_tmp206_->result = CHESS_RESULT_BLACK_WON;
		} else {
			PGNGame* _tmp207_;
			const gchar* _tmp208_;
			const gchar* _tmp209_;
			const gchar* _tmp210_;
			_tmp207_ = self->priv->pgn_game;
			_tmp208_ = pgn_game_get_result (_tmp207_);
			_tmp209_ = _tmp208_;
			_tmp210_ = pgn_game_RESULT_DRAW;
			if (g_strcmp0 (_tmp209_, _tmp210_) == 0) {
				ChessGame* _tmp211_;
				_tmp211_ = self->priv->game;
				_tmp211_->result = CHESS_RESULT_DRAW;
			}
		}
	}
	_tmp212_ = self->priv->opponent_engine;
	if (_tmp212_ != NULL) {
		ChessEngine* _tmp213_;
		_tmp213_ = self->priv->opponent_engine;
		chess_engine_start_game (_tmp213_);
	}
	_tmp215_ = moves;
	_tmp215__length1 = moves_length1;
	if (_tmp215__length1 > 0) {
		ChessGame* _tmp216_;
		ChessClock* _tmp217_;
		ChessClock* _tmp218_;
		_tmp216_ = self->priv->game;
		_tmp217_ = chess_game_get_clock (_tmp216_);
		_tmp218_ = _tmp217_;
		_tmp214_ = _tmp218_ != NULL;
	} else {
		_tmp214_ = FALSE;
	}
	if (_tmp214_) {
		ChessGame* _tmp219_;
		ChessClock* _tmp220_;
		ChessClock* _tmp221_;
		_tmp219_ = self->priv->game;
		_tmp220_ = chess_game_get_clock (_tmp219_);
		_tmp221_ = _tmp220_;
		chess_clock_start (_tmp221_);
		chess_application_enable_action (self, PAUSE_RESUME_ACTION_NAME);
	} else {
		chess_application_disable_action (self, PAUSE_RESUME_ACTION_NAME);
	}
	chess_application_update_action_status (self);
	_tmp222_ = self->priv->_window;
	chess_window_update_history_panel (_tmp222_);
	_tmp223_ = self->priv->_window;
	chess_window_update_pause_resume_button (_tmp223_);
	_tmp224_ = self->priv->ai_profiles;
	if (_tmp224_ == NULL) {
		ChessWindow* _tmp225_;
		_tmp225_ = self->priv->_window;
		chess_window_update_game_status (_tmp225_, NULL, _ ("No chess engine is installed. You will not be able to play against the" \
" computer."));
	} else {
		ChessWindow* _tmp226_;
		_tmp226_ = self->priv->_window;
		chess_window_update_game_status (_tmp226_, NULL, NULL);
	}
	self->priv->starting = FALSE;
	_tmp228_ = self->priv->opponent_engine;
	if (_tmp228_ != NULL) {
		gboolean _tmp229_ = FALSE;
		gboolean _tmp230_ = FALSE;
		const gchar* _tmp231_;
		_tmp231_ = white_engine;
		if (_tmp231_ != NULL) {
			ChessGame* _tmp232_;
			ChessPlayer* _tmp233_;
			ChessPlayer* _tmp234_;
			_tmp232_ = self->priv->game;
			_tmp233_ = chess_game_get_current_player (_tmp232_);
			_tmp234_ = _tmp233_;
			_tmp230_ = _tmp234_->color == COLOR_WHITE;
		} else {
			_tmp230_ = FALSE;
		}
		if (_tmp230_) {
			_tmp229_ = TRUE;
		} else {
			gboolean _tmp235_ = FALSE;
			const gchar* _tmp236_;
			_tmp236_ = black_engine;
			if (_tmp236_ != NULL) {
				ChessGame* _tmp237_;
				ChessPlayer* _tmp238_;
				ChessPlayer* _tmp239_;
				_tmp237_ = self->priv->game;
				_tmp238_ = chess_game_get_current_player (_tmp237_);
				_tmp239_ = _tmp238_;
				_tmp235_ = _tmp239_->color == COLOR_BLACK;
			} else {
				_tmp235_ = FALSE;
			}
			_tmp229_ = _tmp235_;
		}
		_tmp227_ = _tmp229_;
	} else {
		_tmp227_ = FALSE;
	}
	if (_tmp227_) {
		ChessEngine* _tmp240_;
		ChessGame* _tmp241_;
		ChessClock* _tmp242_;
		ChessClock* _tmp243_;
		chess_application_update_engine_timeout (self);
		_tmp240_ = self->priv->opponent_engine;
		_tmp241_ = self->priv->game;
		_tmp242_ = chess_game_get_clock (_tmp241_);
		_tmp243_ = _tmp242_;
		chess_engine_move (_tmp240_, _tmp243_, chess_application_time_to_move (self));
	}
	_tmp244_ = self->priv->game;
	if (_tmp244_->result != CHESS_RESULT_IN_PROGRESS) {
		ChessGame* _tmp245_;
		ChessGame* _tmp246_;
		_tmp245_ = self->priv->game;
		_tmp246_ = self->priv->game;
		chess_game_stop (_tmp245_, _tmp246_->result, CHESS_RULE_UNKNOWN);
	}
	_g_free0 (black_level);
	_g_free0 (black_engine);
	_g_free0 (white_level);
	_g_free0 (white_engine);
	moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (fen);
}

static AIProfile*
chess_application_get_ai_profile (ChessApplication* self,
                                  const gchar* name)
{
	GList* _tmp0_;
	AIProfile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (g_strcmp0 (name, "human") == 0) {
		result = NULL;
		return result;
	}
	if (g_strcmp0 (name, "GNUchess") == 0) {
		name = "GNU Chess";
	}
	_tmp0_ = self->priv->ai_profiles;
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp0_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AIProfile* _tmp1_;
			AIProfile* p = NULL;
			_tmp1_ = _g_object_ref0 ((AIProfile*) p_it->data);
			p = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				if (g_strcmp0 (name, "") == 0) {
					_tmp2_ = TRUE;
				} else {
					AIProfile* _tmp3_;
					const gchar* _tmp4_;
					const gchar* _tmp5_;
					_tmp3_ = p;
					_tmp4_ = ai_profile_get_name (_tmp3_);
					_tmp5_ = _tmp4_;
					_tmp2_ = g_strcmp0 (_tmp5_, name) == 0;
				}
				if (_tmp2_) {
					result = p;
					return result;
				}
				_g_object_unref0 (p);
			}
		}
	}
	result = NULL;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup9 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static ChessEngine*
chess_application_get_engine (ChessApplication* self,
                              const gchar* name,
                              const gchar* difficulty)
{
	AIProfile* profile = NULL;
	AIProfile* _tmp0_;
	AIProfile* _tmp1_;
	gchar** options = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	gchar** uci_go_options = NULL;
	gint uci_go_options_length1 = 0;
	gint _uci_go_options_size_ = 0;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	const gchar* _tmp6_;
	GQuark _tmp8_ = 0U;
	static GQuark _tmp7_label0 = 0;
	static GQuark _tmp7_label1 = 0;
	ChessEngine* engine = NULL;
	AIProfile* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	ChessEngine* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (difficulty != NULL, NULL);
	_tmp0_ = chess_application_get_ai_profile (self, name);
	profile = _tmp0_;
	_tmp1_ = profile;
	if (_tmp1_ == NULL) {
		GList* _tmp2_;
		GList* _tmp3_;
		gconstpointer _tmp4_;
		AIProfile* _tmp5_;
		g_warning ("gnome-chess.vala:507: Unknown AI profile %s", name);
		_tmp2_ = self->priv->ai_profiles;
		if (_tmp2_ == NULL) {
			result = NULL;
			_g_object_unref0 (profile);
			return result;
		}
		_tmp3_ = self->priv->ai_profiles;
		_tmp4_ = _tmp3_->data;
		_tmp5_ = _g_object_ref0 ((AIProfile*) _tmp4_);
		_g_object_unref0 (profile);
		profile = _tmp5_;
	}
	_tmp6_ = difficulty;
	_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
	if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("easy")))) {
		switch (0) {
			default:
			{
				AIProfile* _tmp9_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				gint _tmp11_ = 0;
				gchar** _tmp12_;
				gint _tmp12__length1;
				gchar** _tmp13_;
				gint _tmp13__length1;
				AIProfile* _tmp14_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_ = 0;
				gchar** _tmp17_;
				gint _tmp17__length1;
				gchar** _tmp18_;
				gint _tmp18__length1;
				AIProfile* _tmp19_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gchar** _tmp23_;
				gint _tmp23__length1;
				_tmp9_ = profile;
				_tmp10_ = ai_profile_get_easy_options (_tmp9_, &_tmp11_);
				_tmp10__length1 = _tmp11_;
				_tmp12_ = _tmp10_;
				_tmp12__length1 = _tmp10__length1;
				_tmp13_ = (_tmp12_ != NULL) ? _vala_array_dup1 (_tmp12_, _tmp12__length1) : _tmp12_;
				_tmp13__length1 = _tmp12__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp13_;
				options_length1 = _tmp13__length1;
				_options_size_ = options_length1;
				_tmp14_ = profile;
				_tmp15_ = ai_profile_get_easy_uci_go_options (_tmp14_, &_tmp16_);
				_tmp15__length1 = _tmp16_;
				_tmp17_ = _tmp15_;
				_tmp17__length1 = _tmp15__length1;
				_tmp18_ = (_tmp17_ != NULL) ? _vala_array_dup2 (_tmp17_, _tmp17__length1) : _tmp17_;
				_tmp18__length1 = _tmp17__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp18_;
				uci_go_options_length1 = _tmp18__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp19_ = profile;
				_tmp20_ = ai_profile_get_easy_args (_tmp19_, &_tmp21_);
				_tmp20__length1 = _tmp21_;
				_tmp22_ = _tmp20_;
				_tmp22__length1 = _tmp20__length1;
				_tmp23_ = (_tmp22_ != NULL) ? _vala_array_dup3 (_tmp22_, _tmp22__length1) : _tmp22_;
				_tmp23__length1 = _tmp22__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp23_;
				args_length1 = _tmp23__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	} else if (_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("hard")))) {
		switch (0) {
			default:
			{
				AIProfile* _tmp24_;
				gchar** _tmp25_;
				gint _tmp25__length1;
				gint _tmp26_ = 0;
				gchar** _tmp27_;
				gint _tmp27__length1;
				gchar** _tmp28_;
				gint _tmp28__length1;
				AIProfile* _tmp29_;
				gchar** _tmp30_;
				gint _tmp30__length1;
				gint _tmp31_ = 0;
				gchar** _tmp32_;
				gint _tmp32__length1;
				gchar** _tmp33_;
				gint _tmp33__length1;
				AIProfile* _tmp34_;
				gchar** _tmp35_;
				gint _tmp35__length1;
				gint _tmp36_ = 0;
				gchar** _tmp37_;
				gint _tmp37__length1;
				gchar** _tmp38_;
				gint _tmp38__length1;
				_tmp24_ = profile;
				_tmp25_ = ai_profile_get_hard_options (_tmp24_, &_tmp26_);
				_tmp25__length1 = _tmp26_;
				_tmp27_ = _tmp25_;
				_tmp27__length1 = _tmp25__length1;
				_tmp28_ = (_tmp27_ != NULL) ? _vala_array_dup4 (_tmp27_, _tmp27__length1) : _tmp27_;
				_tmp28__length1 = _tmp27__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp28_;
				options_length1 = _tmp28__length1;
				_options_size_ = options_length1;
				_tmp29_ = profile;
				_tmp30_ = ai_profile_get_hard_uci_go_options (_tmp29_, &_tmp31_);
				_tmp30__length1 = _tmp31_;
				_tmp32_ = _tmp30_;
				_tmp32__length1 = _tmp30__length1;
				_tmp33_ = (_tmp32_ != NULL) ? _vala_array_dup5 (_tmp32_, _tmp32__length1) : _tmp32_;
				_tmp33__length1 = _tmp32__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp33_;
				uci_go_options_length1 = _tmp33__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp34_ = profile;
				_tmp35_ = ai_profile_get_hard_args (_tmp34_, &_tmp36_);
				_tmp35__length1 = _tmp36_;
				_tmp37_ = _tmp35_;
				_tmp37__length1 = _tmp35__length1;
				_tmp38_ = (_tmp37_ != NULL) ? _vala_array_dup6 (_tmp37_, _tmp37__length1) : _tmp37_;
				_tmp38__length1 = _tmp37__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp38_;
				args_length1 = _tmp38__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				AIProfile* _tmp39_;
				gchar** _tmp40_;
				gint _tmp40__length1;
				gint _tmp41_ = 0;
				gchar** _tmp42_;
				gint _tmp42__length1;
				gchar** _tmp43_;
				gint _tmp43__length1;
				AIProfile* _tmp44_;
				gchar** _tmp45_;
				gint _tmp45__length1;
				gint _tmp46_ = 0;
				gchar** _tmp47_;
				gint _tmp47__length1;
				gchar** _tmp48_;
				gint _tmp48__length1;
				AIProfile* _tmp49_;
				gchar** _tmp50_;
				gint _tmp50__length1;
				gint _tmp51_ = 0;
				gchar** _tmp52_;
				gint _tmp52__length1;
				gchar** _tmp53_;
				gint _tmp53__length1;
				_tmp39_ = profile;
				_tmp40_ = ai_profile_get_normal_options (_tmp39_, &_tmp41_);
				_tmp40__length1 = _tmp41_;
				_tmp42_ = _tmp40_;
				_tmp42__length1 = _tmp40__length1;
				_tmp43_ = (_tmp42_ != NULL) ? _vala_array_dup7 (_tmp42_, _tmp42__length1) : _tmp42_;
				_tmp43__length1 = _tmp42__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp43_;
				options_length1 = _tmp43__length1;
				_options_size_ = options_length1;
				_tmp44_ = profile;
				_tmp45_ = ai_profile_get_normal_uci_go_options (_tmp44_, &_tmp46_);
				_tmp45__length1 = _tmp46_;
				_tmp47_ = _tmp45_;
				_tmp47__length1 = _tmp45__length1;
				_tmp48_ = (_tmp47_ != NULL) ? _vala_array_dup8 (_tmp47_, _tmp47__length1) : _tmp47_;
				_tmp48__length1 = _tmp47__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp48_;
				uci_go_options_length1 = _tmp48__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp49_ = profile;
				_tmp50_ = ai_profile_get_normal_args (_tmp49_, &_tmp51_);
				_tmp50__length1 = _tmp51_;
				_tmp52_ = _tmp50_;
				_tmp52__length1 = _tmp50__length1;
				_tmp53_ = (_tmp52_ != NULL) ? _vala_array_dup9 (_tmp52_, _tmp52__length1) : _tmp52_;
				_tmp53__length1 = _tmp52__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp53_;
				args_length1 = _tmp53__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	}
	_tmp54_ = profile;
	_tmp55_ = ai_profile_get_protocol (_tmp54_);
	_tmp56_ = _tmp55_;
	if (g_strcmp0 (_tmp56_, "cecp") == 0) {
		gchar** _tmp57_;
		gint _tmp57__length1;
		AIProfile* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		gchar** _tmp61_;
		gint _tmp61__length1;
		AIProfile* _tmp62_;
		guint _tmp63_;
		guint _tmp64_;
		gchar** _tmp65_;
		gint _tmp65__length1;
		ChessEngineCECP* _tmp66_;
		_tmp57_ = uci_go_options;
		_tmp57__length1 = uci_go_options_length1;
		g_warn_if_fail (_tmp57__length1 == 0);
		_tmp58_ = profile;
		_tmp59_ = ai_profile_get_binary (_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = args;
		_tmp61__length1 = args_length1;
		_tmp62_ = profile;
		_tmp63_ = ai_profile_get_delay_seconds (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = options;
		_tmp65__length1 = options_length1;
		_tmp66_ = chess_engine_cecp_new (_tmp60_, _tmp61_, _tmp61__length1, _tmp64_, _tmp65_, _tmp65__length1);
		_g_object_unref0 (engine);
		engine = (ChessEngine*) _tmp66_;
	} else {
		AIProfile* _tmp67_;
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		_tmp67_ = profile;
		_tmp68_ = ai_profile_get_protocol (_tmp67_);
		_tmp69_ = _tmp68_;
		if (g_strcmp0 (_tmp69_, "uci") == 0) {
			AIProfile* _tmp70_;
			const gchar* _tmp71_;
			const gchar* _tmp72_;
			gchar** _tmp73_;
			gint _tmp73__length1;
			AIProfile* _tmp74_;
			guint _tmp75_;
			guint _tmp76_;
			gchar** _tmp77_;
			gint _tmp77__length1;
			gchar** _tmp78_;
			gint _tmp78__length1;
			ChessEngineUCI* _tmp79_;
			_tmp70_ = profile;
			_tmp71_ = ai_profile_get_binary (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = args;
			_tmp73__length1 = args_length1;
			_tmp74_ = profile;
			_tmp75_ = ai_profile_get_delay_seconds (_tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = options;
			_tmp77__length1 = options_length1;
			_tmp78_ = uci_go_options;
			_tmp78__length1 = uci_go_options_length1;
			_tmp79_ = chess_engine_uci_new (_tmp72_, _tmp73_, _tmp73__length1, _tmp76_, _tmp77_, _tmp77__length1, _tmp78_, _tmp78__length1);
			_g_object_unref0 (engine);
			engine = (ChessEngine*) _tmp79_;
		} else {
			AIProfile* _tmp80_;
			const gchar* _tmp81_;
			const gchar* _tmp82_;
			_tmp80_ = profile;
			_tmp81_ = ai_profile_get_protocol (_tmp80_);
			_tmp82_ = _tmp81_;
			g_warning ("gnome-chess.vala:546: Unknown AI protocol %s", _tmp82_);
			result = NULL;
			_g_object_unref0 (engine);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
			options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (profile);
			return result;
		}
	}
	result = engine;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (profile);
	return result;
}

static void
chess_application_do_engine_move (ChessApplication* self,
                                  const gchar* move)
{
	ChessPlayer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (move != NULL);
	_tmp0_ = self->priv->opponent;
	if (!chess_player_move (_tmp0_, move, TRUE)) {
		ChessGame* _tmp1_;
		g_warning ("gnome-chess.vala:557: Engine's move %s is illegal! Engine desync?", move);
		_tmp1_ = self->priv->game;
		chess_game_stop (_tmp1_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ChessApplication* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->original_state);
		_g_object_unref0 (_data3_->original_game);
		_g_free0 (_data3_->move);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
___lambda32_ (Block3Data* _data3_)
{
	ChessApplication* self;
	ChessGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = _data3_->self;
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = G_SOURCE_CONTINUE;
		return result;
	} else {
		ChessGame* _tmp3_;
		ChessGame* _tmp4_;
		_tmp3_ = self->priv->game;
		_tmp4_ = _data3_->original_game;
		if (_tmp3_ == _tmp4_) {
			ChessGame* _tmp5_;
			ChessState* _tmp6_;
			ChessState* _tmp7_;
			ChessState* _tmp8_;
			_tmp5_ = self->priv->game;
			_tmp6_ = chess_game_get_current_state (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _data3_->original_state;
			_vala_assert (_tmp7_ == _tmp8_, "game.current_state == original_state");
			chess_application_do_engine_move (self, _data3_->move);
		}
		result = G_SOURCE_REMOVE;
		return result;
	}
}

static gboolean
____lambda32__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda32_ (self);
	return result;
}

static void
chess_application_engine_move_cb (ChessApplication* self,
                                  ChessEngine* engine,
                                  const gchar* move)
{
	Block3Data* _data3_;
	gchar* _tmp0_;
	ChessGame* _tmp1_;
	ChessGame* _tmp2_;
	ChessGame* _tmp3_;
	ChessState* _tmp4_;
	ChessState* _tmp5_;
	ChessState* _tmp6_;
	ChessGame* _tmp7_;
	ChessGame* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	g_return_if_fail (move != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_strdup (move);
	_g_free0 (_data3_->move);
	_data3_->move = _tmp0_;
	_tmp1_ = self->priv->game;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data3_->original_game = _tmp2_;
	_tmp3_ = self->priv->game;
	_tmp4_ = chess_game_get_current_state (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_data3_->original_state = _tmp6_;
	_tmp7_ = self->priv->game;
	if (!_tmp7_->is_started) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp8_ = self->priv->game;
	_tmp9_ = chess_game_get_is_paused (_tmp8_);
	_tmp10_ = _tmp9_;
	if (!_tmp10_) {
		chess_application_do_engine_move (self, _data3_->move);
	} else {
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda32__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	}
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
chess_application_engine_resigned_cb (ChessApplication* self,
                                      ChessEngine* engine)
{
	ChessPlayer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->opponent;
	chess_player_resign (_tmp0_);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ChessApplication* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->original_game);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gboolean
__lambda33_ (Block4Data* _data4_)
{
	ChessApplication* self;
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_;
	gboolean result;
	self = _data4_->self;
	_tmp1_ = self->priv->game;
	if (_tmp1_ == _data4_->original_game) {
		ChessGame* _tmp2_;
		_tmp2_ = self->priv->game;
		_tmp0_ = _tmp2_->is_started;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessGame* _tmp3_;
		_tmp3_ = self->priv->game;
		chess_game_stop (_tmp3_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda33__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda33_ (self);
	return result;
}

static void
chess_application_engine_stopped_unexpectedly_cb (ChessApplication* self,
                                                  ChessEngine* engine)
{
	Block4Data* _data4_;
	ChessGame* _tmp0_;
	ChessGame* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data4_->original_game = _tmp1_;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ___lambda33__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
chess_application_engine_error_cb (ChessApplication* self,
                                   ChessEngine* engine)
{
	ChessGame* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->game;
	chess_game_stop (_tmp0_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
}

static void
chess_application_engine_claim_draw_cb (ChessApplication* self,
                                        ChessEngine* engine)
{
	ChessGame* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->game;
	if (chess_game_can_claim_draw (_tmp0_)) {
		ChessPlayer* _tmp1_;
		_tmp1_ = self->priv->opponent;
		chess_player_claim_draw (_tmp1_);
	} else {
		ChessGame* _tmp2_;
		ChessState* _tmp3_;
		ChessState* _tmp4_;
		ChessGame* _tmp5_;
		ChessState* _tmp6_;
		ChessState* _tmp7_;
		ChessPlayer* _tmp8_;
		_tmp2_ = self->priv->game;
		_tmp3_ = chess_game_get_current_state (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->game;
		_tmp6_ = chess_game_get_current_state (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->current_player;
		if (!chess_state_can_move (_tmp4_, _tmp8_)) {
			ChessGame* _tmp9_;
			_tmp9_ = self->priv->game;
			chess_game_stop (_tmp9_, CHESS_RESULT_DRAW, CHESS_RULE_STALEMATE);
		} else {
			ChessGame* _tmp10_;
			_tmp10_ = self->priv->game;
			chess_game_stop (_tmp10_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
		}
	}
}

static void
chess_application_engine_offer_draw_cb (ChessApplication* self,
                                        ChessEngine* engine)
{
	ChessGame* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->game;
	if (chess_game_can_claim_draw (_tmp0_)) {
		ChessPlayer* _tmp1_;
		_tmp1_ = self->priv->opponent;
		chess_player_claim_draw (_tmp1_);
	}
}

static void
chess_application_game_turn_cb (ChessApplication* self,
                                ChessGame* game,
                                ChessPlayer* player)
{
	ChessClock* _tmp0_;
	ChessClock* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (player != NULL);
	if (!game->is_started) {
		return;
	}
	_tmp0_ = chess_game_get_clock (game);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		chess_application_enable_action (self, PAUSE_RESUME_ACTION_NAME);
	}
}

static gboolean
___lambda29_ (ChessApplication* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ChessEngine* _tmp4_;
	gboolean result;
	self->priv->engine_timeout_source = (guint) 0;
	_tmp0_ = g_strdup_printf ("%i", chess_application_ENGINE_INACTIVITY_TIMEOUT);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("Engine did not move for ", _tmp1_, " seconds! Game over.", NULL);
	_tmp3_ = _tmp2_;
	g_warning ("gnome-chess.vala:696: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = self->priv->opponent_engine;
	chess_application_engine_error_cb (self, _tmp4_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda29__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda29_ ((ChessApplication*) self);
	return result;
}

static void
chess_application_update_engine_timeout (ChessApplication* self)
{
	ChessGame* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	PGNGame* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	if (self->priv->engine_timeout_source != ((guint) 0)) {
		g_source_remove (self->priv->engine_timeout_source);
		self->priv->engine_timeout_source = (guint) 0;
	}
	_tmp0_ = self->priv->game;
	if (!_tmp0_->is_started) {
		return;
	}
	_tmp3_ = self->priv->pgn_game;
	_tmp4_ = pgn_game_get_white_ai (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ChessGame* _tmp6_;
		ChessPlayer* _tmp7_;
		ChessPlayer* _tmp8_;
		_tmp6_ = self->priv->game;
		_tmp7_ = chess_game_get_current_player (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_->color == COLOR_WHITE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		PGNGame* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = self->priv->pgn_game;
		_tmp11_ = pgn_game_get_black_ai (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			ChessGame* _tmp13_;
			ChessPlayer* _tmp14_;
			ChessPlayer* _tmp15_;
			_tmp13_ = self->priv->game;
			_tmp14_ = chess_game_get_current_player (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_->color == COLOR_BLACK;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp1_ = _tmp9_;
	}
	if (_tmp1_) {
		self->priv->engine_timeout_source = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) chess_application_ENGINE_INACTIVITY_TIMEOUT, ____lambda29__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static gint
chess_application_time_to_move (ChessApplication* self)
{
	gint timeout = 0;
	ChessGame* _tmp0_;
	ChessClock* _tmp1_;
	ChessClock* _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	timeout = chess_application_ENGINE_INACTIVITY_TIMEOUT;
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_clock (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ChessPlayer* _tmp3_;
		_tmp3_ = self->priv->opponent;
		if (_tmp3_->color == COLOR_WHITE) {
			ChessGame* _tmp4_;
			ChessClock* _tmp5_;
			ChessClock* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			_tmp4_ = self->priv->game;
			_tmp5_ = chess_game_get_clock (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = chess_clock_get_white_remaining_seconds (_tmp6_);
			_tmp8_ = _tmp7_;
			timeout = MIN (timeout, _tmp8_);
		} else {
			ChessGame* _tmp9_;
			ChessClock* _tmp10_;
			ChessClock* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_tmp9_ = self->priv->game;
			_tmp10_ = chess_game_get_clock (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = chess_clock_get_black_remaining_seconds (_tmp11_);
			_tmp13_ = _tmp12_;
			timeout = MIN (timeout, _tmp13_);
		}
	}
	result = timeout;
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ChessApplication* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->game);
		_g_object_unref0 (_data5_->move);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda27_ (Block5Data* _data5_)
{
	ChessApplication* self;
	gboolean _tmp0_ = FALSE;
	ChessEngine* _tmp1_;
	gboolean result;
	self = _data5_->self;
	if (chess_game_can_claim_draw (_data5_->game)) {
		_tmp0_ = _data5_->started;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		chess_application_present_claim_draw_dialog (self);
	}
	_tmp1_ = self->priv->opponent_engine;
	if (_tmp1_ != NULL) {
		ChessEngine* _tmp2_;
		gboolean _tmp3_ = FALSE;
		ChessPiece* _tmp4_;
		Color _tmp5_;
		Color _tmp6_;
		ChessPlayer* _tmp7_;
		_tmp2_ = self->priv->opponent_engine;
		chess_engine_report_move (_tmp2_, _data5_->move);
		_tmp4_ = _data5_->move->piece;
		_tmp5_ = chess_piece_get_color (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->opponent;
		if (_tmp6_ != _tmp7_->color) {
			_tmp3_ = _data5_->started;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			ChessEngine* _tmp8_;
			ChessClock* _tmp9_;
			ChessClock* _tmp10_;
			_tmp8_ = self->priv->opponent_engine;
			_tmp9_ = chess_game_get_clock (_data5_->game);
			_tmp10_ = _tmp9_;
			chess_engine_move (_tmp8_, _tmp10_, chess_application_time_to_move (self));
		}
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda27__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda27_ (self);
	return result;
}

static void
chess_application_game_move_cb (ChessApplication* self,
                                ChessGame* game,
                                ChessMove* move)
{
	Block5Data* _data5_;
	ChessGame* _tmp0_;
	ChessMove* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	PGNGame* _tmp6_;
	GList* _tmp7_;
	ChessWindow* _tmp10_;
	ChessWindow* _tmp11_;
	ChessWindow* _tmp12_;
	ChessView* _tmp13_;
	ChessView* _tmp14_;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (move != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (_data5_->game);
	_data5_->game = _tmp0_;
	_tmp1_ = _g_object_ref0 (move);
	_g_object_unref0 (_data5_->move);
	_data5_->move = _tmp1_;
	self->priv->game_needs_saving = TRUE;
	if (_data5_->move->number == 1) {
		ChessPlayer* _tmp4_;
		_tmp4_ = self->priv->opponent;
		_tmp3_ = _tmp4_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ChessPlayer* _tmp5_;
		_tmp5_ = self->priv->opponent;
		_tmp2_ = _tmp5_->color == COLOR_WHITE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		self->priv->game_needs_saving = FALSE;
	}
	_tmp6_ = self->priv->pgn_game;
	_tmp7_ = _tmp6_->moves;
	if (((guint) _data5_->move->number) > g_list_length (_tmp7_)) {
		PGNGame* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->pgn_game;
		_tmp9_ = chess_move_get_san (_data5_->move);
		_tmp8_->moves = g_list_append (_tmp8_->moves, _tmp9_);
	}
	_tmp10_ = self->priv->_window;
	chess_window_move (_tmp10_, _data5_->move);
	chess_application_enable_action (self, SAVE_GAME_ACTION_NAME);
	chess_application_enable_action (self, SAVE_GAME_AS_ACTION_NAME);
	chess_application_update_action_status (self);
	_tmp11_ = self->priv->_window;
	chess_window_update_history_panel (_tmp11_);
	_tmp12_ = self->priv->_window;
	chess_window_update_game_status (_tmp12_, NULL, NULL);
	_tmp13_ = chess_application_get_view (self);
	_tmp14_ = _tmp13_;
	gtk_widget_queue_draw ((GtkWidget*) _tmp14_);
	if (!self->priv->starting) {
		_tmp15_ = _data5_->game->is_started;
	} else {
		_tmp15_ = FALSE;
	}
	_data5_->started = _tmp15_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda27__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	if (_data5_->started) {
		chess_application_update_engine_timeout (self);
	}
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
chess_application_game_undo_cb (ChessApplication* self,
                                ChessGame* game)
{
	ChessEngine* _tmp0_;
	PGNGame* _tmp2_;
	PGNGame* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	PGNGame* _tmp6_;
	const gchar* _tmp7_;
	ChessWindow* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	ChessWindow* _tmp11_;
	ChessWindow* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->opponent_engine;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_;
		_tmp1_ = self->priv->opponent_engine;
		chess_engine_undo (_tmp1_);
	}
	_tmp2_ = self->priv->pgn_game;
	_tmp3_ = self->priv->pgn_game;
	_tmp4_ = _tmp3_->moves;
	_tmp5_ = g_list_last (_tmp4_);
	_tmp2_->moves = g_list_remove_link (_tmp2_->moves, _tmp5_);
	_tmp6_ = self->priv->pgn_game;
	_tmp7_ = pgn_game_RESULT_IN_PROGRESS;
	pgn_game_set_result (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->_window;
	chess_window_undo (_tmp8_);
	_tmp9_ = chess_game_get_n_moves (game);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > ((guint) 0)) {
		self->priv->game_needs_saving = TRUE;
		chess_application_enable_action (self, SAVE_GAME_ACTION_NAME);
		chess_application_enable_action (self, SAVE_GAME_AS_ACTION_NAME);
	} else {
		self->priv->game_needs_saving = FALSE;
		chess_application_disable_action (self, SAVE_GAME_ACTION_NAME);
		chess_application_disable_action (self, SAVE_GAME_AS_ACTION_NAME);
	}
	chess_application_update_action_status (self);
	_tmp11_ = self->priv->_window;
	chess_window_update_history_panel (_tmp11_);
	_tmp12_ = self->priv->_window;
	chess_window_update_game_status (_tmp12_, NULL, NULL);
}

static void
chess_application_update_action_status (ChessApplication* self)
{
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gboolean can_resign = FALSE;
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	gboolean can_undo = FALSE;
	gboolean _tmp14_ = FALSE;
	ChessPlayer* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	_tmp2_ = chess_game_get_n_moves (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > ((guint) 0)) {
		ChessGame* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->game;
		_tmp5_ = chess_game_get_is_paused (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	can_resign = _tmp0_;
	if (can_resign) {
		chess_application_enable_action (self, RESIGN_ACTION_NAME);
	} else {
		chess_application_disable_action (self, RESIGN_ACTION_NAME);
	}
	_tmp8_ = self->priv->game;
	_tmp9_ = chess_game_get_n_moves (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > ((guint) 0)) {
		ChessGame* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = self->priv->game;
		_tmp12_ = chess_game_get_is_paused (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp7_ = !_tmp13_;
	} else {
		_tmp7_ = FALSE;
	}
	can_undo = _tmp7_;
	_tmp15_ = self->priv->opponent;
	if (_tmp15_ != NULL) {
		ChessPlayer* _tmp16_;
		_tmp16_ = self->priv->opponent;
		_tmp14_ = _tmp16_->color == COLOR_WHITE;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gboolean _tmp17_ = FALSE;
		ChessGame* _tmp18_;
		guint _tmp19_;
		guint _tmp20_;
		_tmp18_ = self->priv->game;
		_tmp19_ = chess_game_get_n_moves (_tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_ > ((guint) 1)) {
			ChessGame* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_;
			_tmp21_ = self->priv->game;
			_tmp22_ = chess_game_get_is_paused (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp17_ = !_tmp23_;
		} else {
			_tmp17_ = FALSE;
		}
		can_undo = _tmp17_;
	}
	if (can_undo) {
		chess_application_enable_action (self, UNDO_MOVE_ACTION_NAME);
	} else {
		chess_application_disable_action (self, UNDO_MOVE_ACTION_NAME);
	}
}

gchar*
chess_application_compute_current_title (ChessApplication* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessPlayer* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp2_ = self->priv->human_player;
	if (_tmp2_ != NULL) {
		ChessPlayer* _tmp3_;
		ChessGame* _tmp4_;
		ChessPlayer* _tmp5_;
		ChessPlayer* _tmp6_;
		_tmp3_ = self->priv->human_player;
		_tmp4_ = self->priv->game;
		_tmp5_ = chess_game_get_current_player (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp3_->color == _tmp6_->color;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ChessGame* _tmp7_;
		ChessState* _tmp8_;
		ChessState* _tmp9_;
		ChessGame* _tmp10_;
		ChessPlayer* _tmp11_;
		ChessPlayer* _tmp12_;
		_tmp7_ = self->priv->game;
		_tmp8_ = chess_game_get_current_state (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->game;
		_tmp11_ = chess_game_get_current_player (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp0_ = chess_state_is_in_check (_tmp9_, _tmp12_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessGame* _tmp13_;
		ChessPlayer* _tmp14_;
		ChessPlayer* _tmp15_;
		_tmp13_ = self->priv->game;
		_tmp14_ = chess_game_get_current_player (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_->color == COLOR_WHITE) {
			gchar* _tmp16_;
			_tmp16_ = g_strdup (_ ("White is in Check"));
			result = _tmp16_;
			return result;
		} else {
			gchar* _tmp17_;
			_tmp17_ = g_strdup (_ ("Black is in Check"));
			result = _tmp17_;
			return result;
		}
	} else {
		ChessGame* _tmp18_;
		ChessPlayer* _tmp19_;
		ChessPlayer* _tmp20_;
		_tmp18_ = self->priv->game;
		_tmp19_ = chess_game_get_current_player (_tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_->color == COLOR_WHITE) {
			gboolean _tmp21_ = FALSE;
			ChessPlayer* _tmp22_;
			_tmp22_ = self->priv->human_player;
			if (_tmp22_ == NULL) {
				_tmp21_ = TRUE;
			} else {
				ChessPlayer* _tmp23_;
				_tmp23_ = self->priv->human_player;
				_tmp21_ = _tmp23_->color == COLOR_WHITE;
			}
			if (_tmp21_) {
				gchar* _tmp24_;
				_tmp24_ = g_strdup (_ ("White to Move"));
				result = _tmp24_;
				return result;
			} else {
				gchar* _tmp25_;
				_tmp25_ = g_strdup (_ ("White is Thinking…"));
				result = _tmp25_;
				return result;
			}
		} else {
			gboolean _tmp26_ = FALSE;
			ChessPlayer* _tmp27_;
			_tmp27_ = self->priv->human_player;
			if (_tmp27_ == NULL) {
				_tmp26_ = TRUE;
			} else {
				ChessPlayer* _tmp28_;
				_tmp28_ = self->priv->human_player;
				_tmp26_ = _tmp28_->color == COLOR_BLACK;
			}
			if (_tmp26_) {
				gchar* _tmp29_;
				_tmp29_ = g_strdup (_ ("Black to Move"));
				result = _tmp29_;
				return result;
			} else {
				gchar* _tmp30_;
				_tmp30_ = g_strdup (_ ("Black is Thinking…"));
				result = _tmp30_;
				return result;
			}
		}
	}
}

gchar*
chess_application_compute_status_info (ChessApplication* self)
{
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_;
	ChessState* _tmp2_;
	ChessState* _tmp3_;
	ChessMove* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->game;
	_tmp2_ = chess_game_get_current_state (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->last_move;
	if (_tmp4_ != NULL) {
		ChessGame* _tmp5_;
		ChessState* _tmp6_;
		ChessState* _tmp7_;
		ChessMove* _tmp8_;
		_tmp5_ = self->priv->game;
		_tmp6_ = chess_game_get_current_state (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->last_move;
		_tmp0_ = _tmp8_->en_passant;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessGame* _tmp9_;
		ChessPlayer* _tmp10_;
		ChessPlayer* _tmp11_;
		_tmp9_ = self->priv->game;
		_tmp10_ = chess_game_get_current_player (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_->color == COLOR_WHITE) {
			gchar* _tmp12_;
			_tmp12_ = g_strdup (_ ("Black captured White's pawn <span font_style='italic'>en passant</span" \
">."));
			result = _tmp12_;
			return result;
		} else {
			gchar* _tmp13_;
			_tmp13_ = g_strdup (_ ("White captured Black's pawn <span font_style='italic'>en passant</span" \
">."));
			result = _tmp13_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static void
chess_application_game_end_cb (ChessApplication* self)
{
	gchar* what = NULL;
	gchar* _tmp0_;
	ChessGame* _tmp1_;
	gchar* why = NULL;
	gchar* _tmp12_;
	ChessGame* _tmp13_;
	ChessWindow* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	ChessWindow* _tmp44_;
	g_return_if_fail (self != NULL);
	chess_application_disable_action (self, RESIGN_ACTION_NAME);
	chess_application_disable_action (self, PAUSE_RESUME_ACTION_NAME);
	self->priv->game_needs_saving = FALSE;
	_tmp0_ = g_strdup ("");
	what = _tmp0_;
	_tmp1_ = self->priv->game;
	switch (_tmp1_->result) {
		case CHESS_RESULT_WHITE_WON:
		{
			gchar* _tmp2_;
			PGNGame* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = g_strdup (_ ("White Wins"));
			_g_free0 (what);
			what = _tmp2_;
			_tmp3_ = self->priv->pgn_game;
			_tmp4_ = pgn_game_RESULT_WHITE;
			pgn_game_set_result (_tmp3_, _tmp4_);
			break;
		}
		case CHESS_RESULT_BLACK_WON:
		{
			gchar* _tmp5_;
			PGNGame* _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = g_strdup (_ ("Black Wins"));
			_g_free0 (what);
			what = _tmp5_;
			_tmp6_ = self->priv->pgn_game;
			_tmp7_ = pgn_game_RESULT_BLACK;
			pgn_game_set_result (_tmp6_, _tmp7_);
			break;
		}
		case CHESS_RESULT_DRAW:
		{
			gchar* _tmp8_;
			PGNGame* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = g_strdup (_ ("Game is Drawn"));
			_g_free0 (what);
			what = _tmp8_;
			_tmp9_ = self->priv->pgn_game;
			_tmp10_ = pgn_game_RESULT_DRAW;
			pgn_game_set_result (_tmp9_, _tmp10_);
			break;
		}
		case CHESS_RESULT_BUG:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup (_ ("Oops!"));
			_g_free0 (what);
			what = _tmp11_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp12_ = g_strdup ("");
	why = _tmp12_;
	_tmp13_ = self->priv->game;
	switch (_tmp13_->rule) {
		case CHESS_RULE_CHECKMATE:
		{
			ChessGame* _tmp14_;
			_tmp14_ = self->priv->game;
			if (_tmp14_->result == CHESS_RESULT_WHITE_WON) {
				gchar* _tmp15_;
				_tmp15_ = g_strdup (_ ("Black is in check and cannot move."));
				_g_free0 (why);
				why = _tmp15_;
			} else {
				ChessGame* _tmp16_;
				_tmp16_ = self->priv->game;
				if (_tmp16_->result == CHESS_RESULT_BLACK_WON) {
					gchar* _tmp17_;
					_tmp17_ = g_strdup (_ ("White is in check and cannot move."));
					_g_free0 (why);
					why = _tmp17_;
				} else {
					g_assert_not_reached ();
				}
			}
			break;
		}
		case CHESS_RULE_STALEMATE:
		{
			gchar* _tmp18_;
			_tmp18_ = g_strdup (_ ("Player cannot move."));
			_g_free0 (why);
			why = _tmp18_;
			break;
		}
		case CHESS_RULE_FIFTY_MOVES:
		{
			gchar* _tmp19_;
			_tmp19_ = g_strdup (_ ("No piece was taken or pawn moved in fifty moves."));
			_g_free0 (why);
			why = _tmp19_;
			break;
		}
		case CHESS_RULE_SEVENTY_FIVE_MOVES:
		{
			gchar* _tmp20_;
			_tmp20_ = g_strdup (_ ("No piece was taken or pawn moved in 75 moves."));
			_g_free0 (why);
			why = _tmp20_;
			break;
		}
		case CHESS_RULE_TIMEOUT:
		{
			ChessGame* _tmp21_;
			_tmp21_ = self->priv->game;
			if (_tmp21_->result == CHESS_RESULT_WHITE_WON) {
				gchar* _tmp22_;
				_tmp22_ = g_strdup (_ ("Black has run out of time."));
				_g_free0 (why);
				why = _tmp22_;
			} else {
				ChessGame* _tmp23_;
				_tmp23_ = self->priv->game;
				if (_tmp23_->result == CHESS_RESULT_BLACK_WON) {
					gchar* _tmp24_;
					_tmp24_ = g_strdup (_ ("White has run out of time."));
					_g_free0 (why);
					why = _tmp24_;
				} else {
					g_assert_not_reached ();
				}
			}
			break;
		}
		case CHESS_RULE_THREE_FOLD_REPETITION:
		{
			gchar* _tmp25_;
			_tmp25_ = g_strdup (_ ("The same board state has occurred three times."));
			_g_free0 (why);
			why = _tmp25_;
			break;
		}
		case CHESS_RULE_FIVE_FOLD_REPETITION:
		{
			gchar* _tmp26_;
			_tmp26_ = g_strdup (_ ("The same board state has occurred five times."));
			_g_free0 (why);
			why = _tmp26_;
			break;
		}
		case CHESS_RULE_INSUFFICIENT_MATERIAL:
		{
			gchar* _tmp27_;
			_tmp27_ = g_strdup (_ ("Neither player can checkmate."));
			_g_free0 (why);
			why = _tmp27_;
			break;
		}
		case CHESS_RULE_RESIGN:
		{
			ChessGame* _tmp28_;
			_tmp28_ = self->priv->game;
			if (_tmp28_->result == CHESS_RESULT_WHITE_WON) {
				gchar* _tmp29_;
				_tmp29_ = g_strdup (_ ("Black has resigned."));
				_g_free0 (why);
				why = _tmp29_;
			} else {
				ChessGame* _tmp30_;
				_tmp30_ = self->priv->game;
				if (_tmp30_->result == CHESS_RESULT_BLACK_WON) {
					gchar* _tmp31_;
					_tmp31_ = g_strdup (_ ("White has resigned."));
					_g_free0 (why);
					why = _tmp31_;
				} else {
					g_assert_not_reached ();
				}
			}
			break;
		}
		case CHESS_RULE_ABANDONMENT:
		{
			gchar* _tmp32_;
			PGNGame* _tmp33_;
			const gchar* _tmp34_;
			_tmp32_ = g_strdup (_ ("The game has been abandoned."));
			_g_free0 (why);
			why = _tmp32_;
			_tmp33_ = self->priv->pgn_game;
			_tmp34_ = pgn_game_TERMINATE_ABANDONED;
			pgn_game_set_termination (_tmp33_, _tmp34_);
			break;
		}
		case CHESS_RULE_DEATH:
		{
			gchar* _tmp35_;
			PGNGame* _tmp36_;
			const gchar* _tmp37_;
			_tmp35_ = g_strdup (_ ("The game log says a player died!"));
			_g_free0 (why);
			why = _tmp35_;
			_tmp36_ = self->priv->pgn_game;
			_tmp37_ = pgn_game_TERMINATE_DEATH;
			pgn_game_set_termination (_tmp36_, _tmp37_);
			break;
		}
		case CHESS_RULE_BUG:
		{
			gchar* _tmp38_;
			_tmp38_ = g_strdup (_ ("The computer player is confused. The game cannot continue."));
			_g_free0 (why);
			why = _tmp38_;
			break;
		}
		case CHESS_RULE_UNKNOWN:
		{
			GFile* _tmp39_;
			gchar* _tmp40_;
			_tmp39_ = self->priv->game_file;
			_tmp40_ = g_file_get_basename (_tmp39_);
			_g_free0 (why);
			why = _tmp40_;
			break;
		}
		default:
		break;
	}
	_tmp41_ = self->priv->_window;
	_tmp42_ = what;
	_tmp43_ = why;
	chess_window_update_game_status (_tmp41_, _tmp42_, _tmp43_);
	_tmp44_ = self->priv->_window;
	chess_window_end_game (_tmp44_);
	chess_application_update_engine_timeout (self);
	_g_free0 (why);
	_g_free0 (what);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ChessApplication* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
____lambda24_ (Block6Data* _data6_,
               gboolean saved)
{
	ChessApplication* self;
	self = _data6_->self;
	_data6_->callback (!saved, _data6_->callback_target);
}

static void
_____lambda24__chess_application_present_save_dialog_callback (gboolean saved,
                                                               gpointer self)
{
	____lambda24_ (self, saved);
}

static void
__lambda21_ (Block6Data* _data6_,
             AdwAlertDialog* dialog,
             const gchar* response)
{
	ChessApplication* self;
	gboolean _tmp0_ = FALSE;
	self = _data6_->self;
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (response != NULL);
	if (g_strcmp0 (response, "cancel") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (response, "close") == 0;
	}
	if (_tmp0_) {
		_data6_->callback (TRUE, _data6_->callback_target);
	} else {
		if (g_strcmp0 (response, "yes") == 0) {
			chess_application_present_save_dialog (self, _____lambda24__chess_application_present_save_dialog_callback, block6_data_ref (_data6_), block6_data_unref);
		} else {
			if (g_strcmp0 (response, "no") == 0) {
				self->priv->game_needs_saving = FALSE;
				chess_application_autosave (self);
				_data6_->callback (FALSE, _data6_->callback_target);
			}
		}
	}
}

static void
___lambda21__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                        const gchar* response,
                                        gpointer self)
{
	__lambda21_ (self, _sender, response);
}

static void
chess_application_prompt_save_game (ChessApplication* self,
                                    const gchar* prompt_text,
                                    ChessApplicationPromptSaveGameCallback callback,
                                    gpointer callback_target)
{
	Block6Data* _data6_;
	AdwAlertDialog* prompt_save_game_dialog = NULL;
	AdwAlertDialog* _tmp0_;
	AdwAlertDialog* _tmp1_;
	ChessGame* _tmp2_;
	AdwAlertDialog* _tmp9_;
	AdwAlertDialog* _tmp10_;
	ChessWindow* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prompt_text != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->callback = callback;
	_data6_->callback_target = callback_target;
	if (!self->priv->game_needs_saving) {
		_data6_->callback (FALSE, _data6_->callback_target);
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return;
	}
	_tmp0_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Save Game?"), prompt_text);
	g_object_ref_sink (_tmp0_);
	prompt_save_game_dialog = _tmp0_;
	_tmp1_ = prompt_save_game_dialog;
	adw_alert_dialog_add_response (_tmp1_, "cancel", _ ("_Cancel"));
	_tmp2_ = self->priv->game;
	if (_tmp2_->result == CHESS_RESULT_IN_PROGRESS) {
		AdwAlertDialog* _tmp3_;
		AdwAlertDialog* _tmp4_;
		AdwAlertDialog* _tmp5_;
		_tmp3_ = prompt_save_game_dialog;
		adw_alert_dialog_add_responses (_tmp3_, "no", _ ("_Abandon Game"), "yes", _ ("Save game for later"), NULL);
		_tmp4_ = prompt_save_game_dialog;
		adw_alert_dialog_set_response_appearance (_tmp4_, "no", ADW_RESPONSE_DESTRUCTIVE);
		_tmp5_ = prompt_save_game_dialog;
		adw_alert_dialog_set_response_appearance (_tmp5_, "yes", ADW_RESPONSE_SUGGESTED);
	} else {
		AdwAlertDialog* _tmp6_;
		AdwAlertDialog* _tmp7_;
		AdwAlertDialog* _tmp8_;
		_tmp6_ = prompt_save_game_dialog;
		adw_alert_dialog_add_responses (_tmp6_, "no", _ ("_Discard Game"), "yes", _ ("Save game log"), NULL);
		_tmp7_ = prompt_save_game_dialog;
		adw_alert_dialog_set_response_appearance (_tmp7_, "no", ADW_RESPONSE_DESTRUCTIVE);
		_tmp8_ = prompt_save_game_dialog;
		adw_alert_dialog_set_response_appearance (_tmp8_, "yes", ADW_RESPONSE_SUGGESTED);
	}
	_tmp9_ = prompt_save_game_dialog;
	g_signal_connect_data (_tmp9_, "response", (GCallback) ___lambda21__adw_alert_dialog_response, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp10_ = prompt_save_game_dialog;
	_tmp11_ = self->priv->_window;
	adw_dialog_present ((AdwDialog*) _tmp10_, (GtkWidget*) _tmp11_);
	_g_object_unref0 (prompt_save_game_dialog);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
__lambda28_ (ChessApplication* self,
             AdwAlertDialog* dialog,
             const gchar* response)
{
	ChessGame* _tmp0_;
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (response != NULL);
	_tmp0_ = self->priv->game;
	chess_game_unpause (_tmp0_);
	if (g_strcmp0 (response, "accept") == 0) {
		ChessGame* _tmp1_;
		ChessPlayer* _tmp2_;
		ChessPlayer* _tmp3_;
		_tmp1_ = self->priv->game;
		_tmp2_ = chess_game_get_current_player (_tmp1_);
		_tmp3_ = _tmp2_;
		chess_player_claim_draw (_tmp3_);
	}
}

static void
___lambda28__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                        const gchar* response,
                                        gpointer self)
{
	__lambda28_ ((ChessApplication*) self, _sender, response);
}

static void
chess_application_present_claim_draw_dialog (ChessApplication* self)
{
	ChessGame* _tmp0_;
	ChessGame* _tmp1_;
	AdwAlertDialog* claim_draw_dialog = NULL;
	AdwAlertDialog* _tmp2_;
	gchar* reason = NULL;
	ChessGame* _tmp3_;
	AdwAlertDialog* _tmp7_;
	const gchar* _tmp8_;
	AdwAlertDialog* _tmp9_;
	AdwAlertDialog* _tmp10_;
	AdwAlertDialog* _tmp11_;
	AdwAlertDialog* _tmp12_;
	AdwAlertDialog* _tmp13_;
	ChessWindow* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_vala_return_if_fail (chess_game_can_claim_draw (_tmp0_), "game.can_claim_draw ()");
	_tmp1_ = self->priv->game;
	chess_game_pause (_tmp1_, FALSE);
	_tmp2_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Would you like to claim a draw?"), "");
	g_object_ref_sink (_tmp2_);
	claim_draw_dialog = _tmp2_;
	_tmp3_ = self->priv->game;
	if (chess_game_is_fifty_move_rule_fulfilled (_tmp3_)) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (_ ("You may claim a draw because fifty moves have passed without a capture" \
" or pawn advancement. (The computer player may still choose to claim a" \
" draw even if you choose to keep playing.)"));
		_g_free0 (reason);
		reason = _tmp4_;
	} else {
		ChessGame* _tmp5_;
		_tmp5_ = self->priv->game;
		if (chess_game_is_three_fold_repeat (_tmp5_)) {
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("You may claim a draw because the current board position has occurred t" \
"hree times. (The computer player may still choose to claim a draw even" \
" if you choose to keep playing.)"));
			_g_free0 (reason);
			reason = _tmp6_;
		} else {
			g_assert_not_reached ();
		}
	}
	_tmp7_ = claim_draw_dialog;
	_tmp8_ = reason;
	adw_alert_dialog_set_body (_tmp7_, _tmp8_);
	_tmp9_ = claim_draw_dialog;
	adw_alert_dialog_add_responses (_tmp9_, "reject", _ ("_Keep Playing"), "accept", _ ("_Claim Draw"), NULL);
	_tmp10_ = claim_draw_dialog;
	adw_alert_dialog_set_response_appearance (_tmp10_, "reject", ADW_RESPONSE_SUGGESTED);
	_tmp11_ = claim_draw_dialog;
	adw_alert_dialog_set_response_appearance (_tmp11_, "accept", ADW_RESPONSE_DESTRUCTIVE);
	_tmp12_ = claim_draw_dialog;
	g_signal_connect_object (_tmp12_, "response", (GCallback) ___lambda28__adw_alert_dialog_response, self, 0);
	_tmp13_ = claim_draw_dialog;
	_tmp14_ = self->priv->_window;
	adw_dialog_present ((AdwDialog*) _tmp13_, (GtkWidget*) _tmp14_);
	_g_free0 (reason);
	_g_object_unref0 (claim_draw_dialog);
}

static void
__lambda25_ (ChessApplication* self,
             gboolean cancelled)
{
	if (!cancelled) {
		chess_application_configure_new_game (self);
	}
}

static void
___lambda25__chess_application_prompt_save_game_callback (gboolean cancelled,
                                                          gpointer self)
{
	__lambda25_ ((ChessApplication*) self, cancelled);
}

void
chess_application_new_game_cb (ChessApplication* self)
{
	g_return_if_fail (self != NULL);
	chess_application_prompt_save_game (self, _ ("By starting a new game now, unsaved progress would be lost."), ___lambda25__chess_application_prompt_save_game_callback, self);
}

static void
__lambda37_ (ChessApplication* self,
             AdwAlertDialog* dialog,
             const gchar* response)
{
	ChessGame* _tmp0_;
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (response != NULL);
	_tmp0_ = self->priv->game;
	chess_game_unpause (_tmp0_);
	if (g_strcmp0 (response, "accept") == 0) {
		ChessPlayer* _tmp1_;
		_tmp1_ = self->priv->human_player;
		if (_tmp1_ != NULL) {
			ChessPlayer* _tmp2_;
			_tmp2_ = self->priv->human_player;
			chess_player_resign (_tmp2_);
		} else {
			ChessGame* _tmp3_;
			ChessPlayer* _tmp4_;
			ChessPlayer* _tmp5_;
			_tmp3_ = self->priv->game;
			_tmp4_ = chess_game_get_current_player (_tmp3_);
			_tmp5_ = _tmp4_;
			chess_player_resign (_tmp5_);
		}
	}
}

static void
___lambda37__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                        const gchar* response,
                                        gpointer self)
{
	__lambda37_ ((ChessApplication*) self, _sender, response);
}

void
chess_application_resign_cb (ChessApplication* self)
{
	ChessGame* _tmp0_;
	AdwAlertDialog* resign_dialog = NULL;
	AdwAlertDialog* _tmp1_;
	ChessWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	chess_game_pause (_tmp0_, FALSE);
	_tmp1_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Are you sure you want to resign?"), "");
	g_object_ref_sink (_tmp1_);
	resign_dialog = _tmp1_;
	adw_alert_dialog_set_body (resign_dialog, _ ("This makes sense if you plan to save the game as a record of your loss" \
"."));
	adw_alert_dialog_add_responses (resign_dialog, "reject", _ ("_Keep Playing"), "accept", _ ("_Resign"), NULL);
	adw_alert_dialog_set_response_appearance (resign_dialog, "reject", ADW_RESPONSE_SUGGESTED);
	adw_alert_dialog_set_response_appearance (resign_dialog, "accept", ADW_RESPONSE_DESTRUCTIVE);
	g_signal_connect_object (resign_dialog, "response", (GCallback) ___lambda37__adw_alert_dialog_response, self, 0);
	_tmp2_ = self->priv->_window;
	adw_dialog_present ((AdwDialog*) resign_dialog, (GtkWidget*) _tmp2_);
	_g_object_unref0 (resign_dialog);
}

void
chess_application_undo_move_cb (ChessApplication* self)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessScene* _tmp2_;
	ChessScene* _tmp3_;
	ChessPlayer* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_application_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp1_->selected_rank = -1;
	_tmp2_ = chess_application_get_scene (self);
	_tmp3_ = _tmp2_;
	_tmp3_->selected_file = -1;
	_tmp4_ = self->priv->opponent;
	if (_tmp4_ != NULL) {
		ChessPlayer* _tmp5_;
		_tmp5_ = self->priv->human_player;
		chess_player_undo (_tmp5_);
	} else {
		ChessGame* _tmp6_;
		ChessPlayer* _tmp7_;
		ChessPlayer* _tmp8_;
		_tmp6_ = self->priv->game;
		_tmp7_ = chess_game_get_opponent (_tmp6_);
		_tmp8_ = _tmp7_;
		chess_player_undo (_tmp8_);
	}
}

void
chess_application_pause_resume_cb (ChessApplication* self)
{
	ChessGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ChessWindow* _tmp5_;
	ChessWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ChessGame* _tmp3_;
		_tmp3_ = self->priv->game;
		chess_game_unpause (_tmp3_);
	} else {
		ChessGame* _tmp4_;
		_tmp4_ = self->priv->game;
		chess_game_pause (_tmp4_, TRUE);
	}
	chess_application_update_action_status (self);
	_tmp5_ = self->priv->_window;
	chess_window_update_history_panel (_tmp5_);
	_tmp6_ = self->priv->_window;
	chess_window_update_pause_resume_button (_tmp6_);
}

void
chess_application_quit_cb (ChessApplication* self)
{
	g_return_if_fail (self != NULL);
	chess_application_quit_game (self);
}

static void
chess_application_history_go_first_cb (ChessApplication* self)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_application_get_scene (self);
	_tmp1_ = _tmp0_;
	chess_scene_set_move_number (_tmp1_, 0);
}

static void
chess_application_history_go_previous_cb (ChessApplication* self)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ChessScene* _tmp4_;
	ChessScene* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_application_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_scene_get_move_number (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		return;
	}
	_tmp4_ = chess_application_get_scene (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = chess_scene_get_move_number (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == -1) {
		ChessScene* _tmp8_;
		ChessScene* _tmp9_;
		ChessGame* _tmp10_;
		guint _tmp11_;
		guint _tmp12_;
		_tmp8_ = chess_application_get_scene (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->game;
		_tmp11_ = chess_game_get_n_moves (_tmp10_);
		_tmp12_ = _tmp11_;
		chess_scene_set_move_number (_tmp9_, ((gint) _tmp12_) - 1);
	} else {
		ChessScene* _tmp13_;
		ChessScene* _tmp14_;
		ChessScene* _tmp15_;
		ChessScene* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp13_ = chess_application_get_scene (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = chess_application_get_scene (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = chess_scene_get_move_number (_tmp16_);
		_tmp18_ = _tmp17_;
		chess_scene_set_move_number (_tmp14_, _tmp18_ - 1);
	}
}

static void
chess_application_history_go_next_cb (ChessApplication* self)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint move_number = 0;
	ChessScene* _tmp4_;
	ChessScene* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	ChessGame* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_application_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_scene_get_move_number (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == -1) {
		return;
	}
	_tmp4_ = chess_application_get_scene (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = chess_scene_get_move_number (_tmp5_);
	_tmp7_ = _tmp6_;
	move_number = _tmp7_ + 1;
	_tmp8_ = self->priv->game;
	_tmp9_ = chess_game_get_n_moves (_tmp8_);
	_tmp10_ = _tmp9_;
	if (((guint) move_number) >= _tmp10_) {
		ChessScene* _tmp11_;
		ChessScene* _tmp12_;
		_tmp11_ = chess_application_get_scene (self);
		_tmp12_ = _tmp11_;
		chess_scene_set_move_number (_tmp12_, -1);
	} else {
		ChessScene* _tmp13_;
		ChessScene* _tmp14_;
		_tmp13_ = chess_application_get_scene (self);
		_tmp14_ = _tmp13_;
		chess_scene_set_move_number (_tmp14_, move_number);
	}
}

static void
chess_application_history_go_last_cb (ChessApplication* self)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_application_get_scene (self);
	_tmp1_ = _tmp0_;
	chess_scene_set_move_number (_tmp1_, -1);
}

static void
__lambda26_ (ChessApplication* self)
{
	chess_application_start_new_game (self);
}

static void
___lambda26__new_game_dialog_new_game_requested (NewGameDialog* _sender,
                                                 gpointer self)
{
	__lambda26_ ((ChessApplication*) self);
}

static void
chess_application_configure_new_game (ChessApplication* self)
{
	NewGameDialog* _tmp0_;
	Preferences* _tmp3_;
	GList* _tmp4_;
	NewGameDialog* _tmp5_;
	NewGameDialog* _tmp6_;
	NewGameDialog* _tmp7_;
	ChessWindow* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->new_game_dialog;
	if (_tmp0_ != NULL) {
		NewGameDialog* _tmp1_;
		ChessWindow* _tmp2_;
		_tmp1_ = self->priv->new_game_dialog;
		_tmp2_ = self->priv->_window;
		adw_dialog_present ((AdwDialog*) _tmp1_, (GtkWidget*) _tmp2_);
		return;
	}
	_tmp3_ = self->priv->preferences;
	_tmp4_ = self->priv->ai_profiles;
	_tmp5_ = new_game_dialog_new (_tmp3_, _tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->new_game_dialog);
	self->priv->new_game_dialog = _tmp5_;
	_tmp6_ = self->priv->new_game_dialog;
	g_signal_connect_object (_tmp6_, "new-game-requested", (GCallback) ___lambda26__new_game_dialog_new_game_requested, self, 0);
	_tmp7_ = self->priv->new_game_dialog;
	_tmp8_ = self->priv->_window;
	adw_dialog_present ((AdwDialog*) _tmp7_, (GtkWidget*) _tmp8_);
}

static void
chess_application_preferences_cb (ChessApplication* self)
{
	PreferencesDialog* _tmp0_;
	Preferences* _tmp3_;
	PreferencesDialog* _tmp4_;
	PreferencesDialog* _tmp5_;
	ChessWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ != NULL) {
		PreferencesDialog* _tmp1_;
		ChessWindow* _tmp2_;
		_tmp1_ = self->priv->preferences_dialog;
		_tmp2_ = self->priv->_window;
		adw_dialog_present ((AdwDialog*) _tmp1_, (GtkWidget*) _tmp2_);
		return;
	}
	_tmp3_ = self->priv->preferences;
	_tmp4_ = preferences_dialog_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp4_;
	_tmp5_ = self->priv->preferences_dialog;
	_tmp6_ = self->priv->_window;
	adw_dialog_present ((AdwDialog*) _tmp5_, (GtkWidget*) _tmp6_);
}

void
chess_application_help_cb (ChessApplication* self)
{
	ChessWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	gtk_show_uri ((GtkWindow*) _tmp0_, "help:gnome-chess", (guint32) GDK_CURRENT_TIME);
}

void
chess_application_about_cb (ChessApplication* self)
{
	AdwAboutDialog* _tmp0_;
	AdwAboutDialog* _tmp3_;
	AdwAboutDialog* _tmp4_;
	AdwAboutDialog* _tmp5_;
	AdwAboutDialog* _tmp6_;
	const gchar* _tmp7_;
	AdwAboutDialog* _tmp8_;
	AdwAboutDialog* _tmp9_;
	AdwAboutDialog* _tmp10_;
	AdwAboutDialog* _tmp11_;
	AdwAboutDialog* _tmp12_;
	AdwAboutDialog* _tmp13_;
	ChessWindow* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->about_dialog;
	if (_tmp0_ != NULL) {
		AdwAboutDialog* _tmp1_;
		ChessWindow* _tmp2_;
		_tmp1_ = self->priv->about_dialog;
		_tmp2_ = self->priv->_window;
		adw_dialog_present ((AdwDialog*) _tmp1_, (GtkWidget*) _tmp2_);
		return;
	}
	_tmp3_ = (AdwAboutDialog*) adw_about_dialog_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = _tmp3_;
	_tmp4_ = self->priv->about_dialog;
	adw_about_dialog_set_application_name (_tmp4_, _ ("Chess"));
	_tmp5_ = self->priv->about_dialog;
	adw_about_dialog_set_version (_tmp5_, VERSION);
	_tmp6_ = self->priv->about_dialog;
	_tmp7_ = self->priv->copyrights;
	adw_about_dialog_set_copyright (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->about_dialog;
	adw_about_dialog_set_license_type (_tmp8_, GTK_LICENSE_GPL_3_0);
	_tmp9_ = self->priv->about_dialog;
	adw_about_dialog_set_developers (_tmp9_, CHESS_APPLICATION_authors);
	_tmp10_ = self->priv->about_dialog;
	adw_about_dialog_set_artists (_tmp10_, CHESS_APPLICATION_artists);
	_tmp11_ = self->priv->about_dialog;
	adw_about_dialog_set_translator_credits (_tmp11_, _ ("translator-credits"));
	_tmp12_ = self->priv->about_dialog;
	adw_about_dialog_set_application_icon (_tmp12_, "org.gnome.Chess");
	_tmp13_ = self->priv->about_dialog;
	_tmp14_ = self->priv->_window;
	adw_dialog_present ((AdwDialog*) _tmp13_, (GtkWidget*) _tmp14_);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ChessApplication* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->promotion_type_selector_dialog);
		(_data7_->handler_target_destroy_notify == NULL) ? NULL : (_data7_->handler_target_destroy_notify (_data7_->handler_target), NULL);
		_data7_->handler = NULL;
		_data7_->handler_target = NULL;
		_data7_->handler_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda39_ (Block7Data* _data7_,
             PromotionTypeSelectorDialogSelectedType selected_type)
{
	ChessApplication* self;
	self = _data7_->self;
	switch (selected_type) {
		case PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_QUEEN:
		{
			PieceType _tmp0_;
			_tmp0_ = PIECE_TYPE_QUEEN;
			_data7_->handler (&_tmp0_, _data7_->handler_target);
			break;
		}
		case PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_KNIGHT:
		{
			PieceType _tmp1_;
			_tmp1_ = PIECE_TYPE_KNIGHT;
			_data7_->handler (&_tmp1_, _data7_->handler_target);
			break;
		}
		case PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_ROOK:
		{
			PieceType _tmp2_;
			_tmp2_ = PIECE_TYPE_ROOK;
			_data7_->handler (&_tmp2_, _data7_->handler_target);
			break;
		}
		case PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_BISHOP:
		{
			PieceType _tmp3_;
			_tmp3_ = PIECE_TYPE_BISHOP;
			_data7_->handler (&_tmp3_, _data7_->handler_target);
			break;
		}
		default:
		{
			_data7_->handler (NULL, _data7_->handler_target);
			break;
		}
	}
	adw_dialog_close ((AdwDialog*) _data7_->promotion_type_selector_dialog);
	_g_object_unref0 (_data7_->promotion_type_selector_dialog);
	_data7_->promotion_type_selector_dialog = NULL;
}

static void
___lambda39__promotion_type_selector_dialog_piece_selected (PromotionTypeSelectorDialog* _sender,
                                                            PromotionTypeSelectorDialogSelectedType type,
                                                            gpointer self)
{
	__lambda39_ (self, type);
}

static void
chess_application_show_promotion_type_selector (ChessApplication* self,
                                                ChessScenePromotionTypeCompletionHandler handler,
                                                gpointer handler_target,
                                                GDestroyNotify handler_target_destroy_notify)
{
	Block7Data* _data7_;
	ChessGame* _tmp0_;
	ChessPlayer* _tmp1_;
	ChessPlayer* _tmp2_;
	ChessScene* _tmp3_;
	ChessScene* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	PromotionTypeSelectorDialog* _tmp7_;
	ChessWindow* _tmp8_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	(_data7_->handler_target_destroy_notify == NULL) ? NULL : (_data7_->handler_target_destroy_notify (_data7_->handler_target), NULL);
	_data7_->handler = NULL;
	_data7_->handler_target = NULL;
	_data7_->handler_target_destroy_notify = NULL;
	_data7_->handler = handler;
	_data7_->handler_target = handler_target;
	_data7_->handler_target_destroy_notify = handler_target_destroy_notify;
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_current_player (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = chess_application_get_scene (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = chess_scene_get_theme_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = promotion_type_selector_dialog_new (_tmp2_->color, _tmp6_);
	g_object_ref_sink (_tmp7_);
	_data7_->promotion_type_selector_dialog = _tmp7_;
	g_signal_connect_data (_data7_->promotion_type_selector_dialog, "piece-selected", (GCallback) ___lambda39__promotion_type_selector_dialog_piece_selected, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp8_ = self->priv->_window;
	adw_dialog_present ((AdwDialog*) _data7_->promotion_type_selector_dialog, (GtkWidget*) _tmp8_);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		ChessApplication* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->invalid_pgn_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda36_ (Block8Data* _data8_,
             AdwAlertDialog* dialog,
             const gchar* response)
{
	ChessApplication* self;
	self = _data8_->self;
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (response != NULL);
	g_signal_emit_by_name ((GtkWidget*) _data8_->invalid_pgn_dialog, "destroy");
}

static void
___lambda36__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                        const gchar* response,
                                        gpointer self)
{
	__lambda36_ (self, _sender, response);
}

static void
chess_application_run_invalid_pgn_dialog (ChessApplication* self)
{
	Block8Data* _data8_;
	AdwAlertDialog* _tmp0_;
	ChessWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Error Loading PGN File"), _ ("This does not look like a valid PGN game."));
	g_object_ref_sink (_tmp0_);
	_data8_->invalid_pgn_dialog = _tmp0_;
	adw_alert_dialog_add_response (_data8_->invalid_pgn_dialog, "okay", _ ("_OK"));
	g_signal_connect_data (_data8_->invalid_pgn_dialog, "response", (GCallback) ___lambda36__adw_alert_dialog_response, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	_tmp1_ = self->priv->_window;
	adw_dialog_present ((AdwDialog*) _data8_->invalid_pgn_dialog, (GtkWidget*) _tmp1_);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		ChessApplication* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->invalid_move_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda30_ (Block9Data* _data9_,
             AdwAlertDialog* dialog,
             const gchar* response)
{
	ChessApplication* self;
	self = _data9_->self;
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (response != NULL);
	g_signal_emit_by_name ((GtkWidget*) _data9_->invalid_move_dialog, "destroy");
}

static void
___lambda30__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                        const gchar* response,
                                        gpointer self)
{
	__lambda30_ (self, _sender, response);
}

static void
chess_application_show_invalid_move_dialog (ChessApplication* self,
                                            const gchar* error_message)
{
	Block9Data* _data9_;
	AdwAlertDialog* _tmp0_;
	ChessWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_message != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Invalid Move"), error_message);
	g_object_ref_sink (_tmp0_);
	_data9_->invalid_move_dialog = _tmp0_;
	adw_alert_dialog_add_response (_data9_->invalid_move_dialog, "okay", _ ("_OK"));
	g_signal_connect_data (_data9_->invalid_move_dialog, "response", (GCallback) ___lambda30__adw_alert_dialog_response, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp1_ = self->priv->_window;
	adw_dialog_present ((AdwDialog*) _data9_->invalid_move_dialog, (GtkWidget*) _tmp1_);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static void
chess_application_update_pgn_time_remaining (ChessApplication* self)
{
	ChessGame* _tmp0_;
	ChessClock* _tmp1_;
	ChessClock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_clock (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		PGNGame* _tmp3_;
		ChessGame* _tmp4_;
		ChessClock* _tmp5_;
		ChessClock* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		PGNGame* _tmp11_;
		ChessGame* _tmp12_;
		ChessClock* _tmp13_;
		ChessClock* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp3_ = self->priv->pgn_game;
		_tmp4_ = self->priv->game;
		_tmp5_ = chess_game_get_clock (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = chess_clock_get_white_remaining_seconds (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("%i", _tmp8_);
		_tmp10_ = _tmp9_;
		pgn_game_set_white_time_left (_tmp3_, _tmp10_);
		_g_free0 (_tmp10_);
		_tmp11_ = self->priv->pgn_game;
		_tmp12_ = self->priv->game;
		_tmp13_ = chess_game_get_clock (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = chess_clock_get_black_remaining_seconds (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf ("%i", _tmp16_);
		_tmp18_ = _tmp17_;
		pgn_game_set_black_time_left (_tmp11_, _tmp18_);
		_g_free0 (_tmp18_);
	}
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		ChessApplication* self;
		self = _data10_->self;
		(_data10_->callback_target_destroy_notify == NULL) ? NULL : (_data10_->callback_target_destroy_notify (_data10_->callback_target), NULL);
		_data10_->callback = NULL;
		_data10_->callback_target = NULL;
		_data10_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
___lambda23_ (Block10Data* _data10_,
              AdwAlertDialog* dialog,
              const gchar* response)
{
	ChessApplication* self;
	self = _data10_->self;
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (response != NULL);
	if (_data10_->callback != NULL) {
		_data10_->callback (FALSE, _data10_->callback_target);
	}
}

static void
____lambda23__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                         const gchar* response,
                                         gpointer self)
{
	___lambda23_ (self, _sender, response);
}

static void
__lambda22_ (Block10Data* _data10_,
             GObject* object,
             GAsyncResult* _result_)
{
	ChessApplication* self;
	GError* _inner_error0_ = NULL;
	self = _data10_->self;
	g_return_if_fail (_result_ != NULL);
	chess_application_update_pgn_time_remaining (self);
	{
		GFile* _tmp0_ = NULL;
		GtkFileDialog* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		PGNGame* _tmp4_;
		GFile* _tmp5_;
		_tmp1_ = self->priv->save_dialog;
		_tmp2_ = gtk_file_dialog_save_finish (_tmp1_, _result_, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->game_file);
		self->priv->game_file = _tmp3_;
		_tmp4_ = self->priv->pgn_game;
		_tmp5_ = self->priv->game_file;
		pgn_game_write (_tmp4_, _tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		chess_application_disable_action (self, SAVE_GAME_ACTION_NAME);
		self->priv->game_needs_saving = FALSE;
		if (_data10_->callback != NULL) {
			_data10_->callback (TRUE, _data10_->callback_target);
		}
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		AdwAlertDialog* save_error_dialog = NULL;
		AdwAlertDialog* _tmp7_;
		AdwAlertDialog* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		AdwAlertDialog* _tmp11_;
		AdwAlertDialog* _tmp12_;
		AdwAlertDialog* _tmp13_;
		ChessWindow* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		if (g_error_matches (_tmp6_, gtk_dialog_error_quark (), GTK_DIALOG_ERROR_DISMISSED)) {
			if (_data10_->callback != NULL) {
				_data10_->callback (FALSE, _data10_->callback_target);
			}
			_g_error_free0 (e);
			return;
		}
		_tmp7_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Save Error"), "");
		g_object_ref_sink (_tmp7_);
		save_error_dialog = _tmp7_;
		_tmp8_ = save_error_dialog;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		adw_alert_dialog_format_body (_tmp8_, _ ("Failed to save game: %s"), _tmp10_);
		_tmp11_ = save_error_dialog;
		adw_alert_dialog_add_response (_tmp11_, "ok", _ ("_OK"));
		_tmp12_ = save_error_dialog;
		g_signal_connect_data (_tmp12_, "response", (GCallback) ____lambda23__adw_alert_dialog_response, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
		_tmp13_ = save_error_dialog;
		_tmp14_ = self->priv->_window;
		adw_dialog_present ((AdwDialog*) _tmp13_, (GtkWidget*) _tmp14_);
		_g_object_unref0 (save_error_dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda22__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda22_ (self, source_object, res);
	block10_data_unref (self);
}

static void
chess_application_present_save_dialog (ChessApplication* self,
                                       ChessApplicationPresentSaveDialogCallback callback,
                                       gpointer callback_target,
                                       GDestroyNotify callback_target_destroy_notify)
{
	Block10Data* _data10_;
	GtkFileDialog* _tmp0_;
	GtkFileDialog* _tmp28_;
	ChessWindow* _tmp29_;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	(_data10_->callback_target_destroy_notify == NULL) ? NULL : (_data10_->callback_target_destroy_notify (_data10_->callback_target), NULL);
	_data10_->callback = NULL;
	_data10_->callback_target = NULL;
	_data10_->callback_target_destroy_notify = NULL;
	_data10_->callback = callback;
	_data10_->callback_target = callback_target;
	_data10_->callback_target_destroy_notify = callback_target_destroy_notify;
	_tmp0_ = self->priv->save_dialog;
	if (_tmp0_ == NULL) {
		GtkFileDialog* _tmp1_;
		GtkFileDialog* _tmp2_;
		gboolean set_file = FALSE;
		GFile* _tmp3_;
		GtkFileFilter* pgn_filter = NULL;
		GtkFileFilter* _tmp15_;
		GtkFileFilter* _tmp16_;
		GtkFileFilter* _tmp17_;
		GtkFileFilter* all_filter = NULL;
		GtkFileFilter* _tmp18_;
		GtkFileFilter* _tmp19_;
		GtkFileFilter* _tmp20_;
		GListStore* filters = NULL;
		GListStore* _tmp21_;
		GListStore* _tmp22_;
		GtkFileFilter* _tmp23_;
		GListStore* _tmp24_;
		GtkFileFilter* _tmp25_;
		GtkFileDialog* _tmp26_;
		GListStore* _tmp27_;
		_tmp1_ = gtk_file_dialog_new ();
		_g_object_unref0 (self->priv->save_dialog);
		self->priv->save_dialog = _tmp1_;
		_tmp2_ = self->priv->save_dialog;
		gtk_file_dialog_set_title (_tmp2_, _ ("Save Chess Game"));
		set_file = FALSE;
		_tmp3_ = self->priv->game_file;
		if (_tmp3_ != NULL) {
			gchar* path = NULL;
			GFile* _tmp4_;
			gchar* _tmp5_;
			gboolean _tmp6_ = FALSE;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp4_ = self->priv->game_file;
			_tmp5_ = g_file_get_path (_tmp4_);
			path = _tmp5_;
			_tmp7_ = path;
			_tmp8_ = self->priv->autosave_filename;
			if (g_strcmp0 (_tmp7_, _tmp8_) != 0) {
				const gchar* _tmp9_;
				_tmp9_ = path;
				_tmp6_ = !g_str_has_prefix (_tmp9_, "/run");
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				GtkFileDialog* _tmp10_;
				GFile* _tmp11_;
				_tmp10_ = self->priv->save_dialog;
				_tmp11_ = self->priv->game_file;
				gtk_file_dialog_set_initial_file (_tmp10_, _tmp11_);
				set_file = TRUE;
			}
			_g_free0 (path);
		}
		if (!set_file) {
			GtkFileDialog* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp12_ = self->priv->save_dialog;
			_tmp13_ = g_strconcat (_ ("Untitled Chess Game"), ".pgn", NULL);
			_tmp14_ = _tmp13_;
			gtk_file_dialog_set_initial_name (_tmp12_, _tmp14_);
			_g_free0 (_tmp14_);
		}
		_tmp15_ = gtk_file_filter_new ();
		pgn_filter = _tmp15_;
		_tmp16_ = pgn_filter;
		gtk_file_filter_set_name (_tmp16_, _ ("PGN files"));
		_tmp17_ = pgn_filter;
		gtk_file_filter_add_pattern (_tmp17_, "*.pgn");
		_tmp18_ = gtk_file_filter_new ();
		all_filter = _tmp18_;
		_tmp19_ = all_filter;
		gtk_file_filter_set_name (_tmp19_, _ ("All files"));
		_tmp20_ = all_filter;
		gtk_file_filter_add_pattern (_tmp20_, "*");
		_tmp21_ = g_list_store_new (gtk_file_filter_get_type ());
		filters = _tmp21_;
		_tmp22_ = filters;
		_tmp23_ = pgn_filter;
		g_list_store_append (_tmp22_, (GObject*) _tmp23_);
		_tmp24_ = filters;
		_tmp25_ = all_filter;
		g_list_store_append (_tmp24_, (GObject*) _tmp25_);
		_tmp26_ = self->priv->save_dialog;
		_tmp27_ = filters;
		gtk_file_dialog_set_filters (_tmp26_, (GListModel*) _tmp27_);
		_g_object_unref0 (filters);
		_g_object_unref0 (all_filter);
		_g_object_unref0 (pgn_filter);
	}
	_tmp28_ = self->priv->save_dialog;
	_tmp29_ = self->priv->_window;
	gtk_file_dialog_save (_tmp28_, (GtkWindow*) _tmp29_, NULL, ___lambda22__gasync_ready_callback, block10_data_ref (_data10_));
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

void
chess_application_save_game_cb (ChessApplication* self)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game_file;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp2_ = self->priv->game_file;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->autosave_filename;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
		_g_free0 (_tmp4_);
	}
	if (_tmp0_) {
		chess_application_present_save_dialog (self, NULL, NULL, NULL);
		return;
	}
	chess_application_update_pgn_time_remaining (self);
	{
		PGNGame* _tmp6_;
		GFile* _tmp7_;
		_tmp6_ = self->priv->pgn_game;
		_tmp7_ = self->priv->game_file;
		pgn_game_write (_tmp6_, _tmp7_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->priv->game_needs_saving = FALSE;
		chess_application_disable_action (self, SAVE_GAME_ACTION_NAME);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		chess_application_present_save_dialog (self, NULL, NULL, NULL);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
chess_application_save_game_as_cb (ChessApplication* self)
{
	g_return_if_fail (self != NULL);
	chess_application_present_save_dialog (self, NULL, NULL, NULL);
}

static void
__lambda35_ (ChessApplication* self,
             GObject* object,
             GAsyncResult* _result_)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (_result_ != NULL);
	{
		GFile* _tmp0_ = NULL;
		GtkFileDialog* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		_tmp1_ = self->priv->open_dialog;
		_tmp2_ = gtk_file_dialog_open_finish (_tmp1_, _result_, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->game_file);
		self->priv->game_file = _tmp3_;
		_tmp4_ = self->priv->game_file;
		chess_application_load_game (self, _tmp4_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		if (!g_error_matches (_tmp5_, gtk_dialog_error_quark (), GTK_DIALOG_ERROR_DISMISSED)) {
			GError* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_warning ("gnome-chess.vala:1433: Failed to open game: %s", _tmp7_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda35__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda35_ ((ChessApplication*) self, source_object, res);
	g_object_unref (self);
}

static void
__lambda34_ (ChessApplication* self,
             gboolean cancelled)
{
	GtkFileDialog* _tmp0_;
	GtkFileDialog* _tmp17_;
	ChessWindow* _tmp18_;
	if (cancelled) {
		return;
	}
	_tmp0_ = self->priv->open_dialog;
	if (_tmp0_ == NULL) {
		GtkFileDialog* _tmp1_;
		GtkFileDialog* _tmp2_;
		GtkFileDialog* _tmp3_;
		GtkFileFilter* pgn_filter = NULL;
		GtkFileFilter* _tmp4_;
		GtkFileFilter* _tmp5_;
		GtkFileFilter* _tmp6_;
		GtkFileFilter* all_filter = NULL;
		GtkFileFilter* _tmp7_;
		GtkFileFilter* _tmp8_;
		GtkFileFilter* _tmp9_;
		GListStore* filters = NULL;
		GListStore* _tmp10_;
		GListStore* _tmp11_;
		GtkFileFilter* _tmp12_;
		GListStore* _tmp13_;
		GtkFileFilter* _tmp14_;
		GtkFileDialog* _tmp15_;
		GListStore* _tmp16_;
		_tmp1_ = gtk_file_dialog_new ();
		_g_object_unref0 (self->priv->open_dialog);
		self->priv->open_dialog = _tmp1_;
		_tmp2_ = self->priv->open_dialog;
		gtk_file_dialog_set_title (_tmp2_, _ ("Load Chess Game"));
		_tmp3_ = self->priv->open_dialog;
		gtk_file_dialog_set_modal (_tmp3_, TRUE);
		_tmp4_ = gtk_file_filter_new ();
		pgn_filter = _tmp4_;
		_tmp5_ = pgn_filter;
		gtk_file_filter_set_name (_tmp5_, _ ("PGN files"));
		_tmp6_ = pgn_filter;
		gtk_file_filter_add_pattern (_tmp6_, "*.pgn");
		_tmp7_ = gtk_file_filter_new ();
		all_filter = _tmp7_;
		_tmp8_ = all_filter;
		gtk_file_filter_set_name (_tmp8_, _ ("All files"));
		_tmp9_ = all_filter;
		gtk_file_filter_add_pattern (_tmp9_, "*");
		_tmp10_ = g_list_store_new (gtk_file_filter_get_type ());
		filters = _tmp10_;
		_tmp11_ = filters;
		_tmp12_ = pgn_filter;
		g_list_store_append (_tmp11_, (GObject*) _tmp12_);
		_tmp13_ = filters;
		_tmp14_ = all_filter;
		g_list_store_append (_tmp13_, (GObject*) _tmp14_);
		_tmp15_ = self->priv->open_dialog;
		_tmp16_ = filters;
		gtk_file_dialog_set_filters (_tmp15_, (GListModel*) _tmp16_);
		_g_object_unref0 (filters);
		_g_object_unref0 (all_filter);
		_g_object_unref0 (pgn_filter);
	}
	_tmp17_ = self->priv->open_dialog;
	_tmp18_ = self->priv->_window;
	gtk_file_dialog_open (_tmp17_, (GtkWindow*) _tmp18_, NULL, ___lambda35__gasync_ready_callback, g_object_ref (self));
}

static void
___lambda34__chess_application_prompt_save_game_callback (gboolean cancelled,
                                                          gpointer self)
{
	__lambda34_ ((ChessApplication*) self, cancelled);
}

void
chess_application_open_game_cb (ChessApplication* self)
{
	g_return_if_fail (self != NULL);
	chess_application_prompt_save_game (self, _ ("Save this game before loading another one?"), ___lambda34__chess_application_prompt_save_game_callback, self);
}

static void
chess_application_start_new_game (ChessApplication* self)
{
	PGNGame* _tmp0_;
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	PGNGame* _tmp2_;
	GDateTime* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	PGNGame* _tmp6_;
	GDateTime* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint duration = 0;
	GSettings* _tmp10_;
	gchar* engine_level = NULL;
	GSettings* _tmp20_;
	gchar* _tmp21_;
	gchar* engine_name = NULL;
	GSettings* _tmp22_;
	gchar* _tmp23_;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_;
	gboolean _tmp36_ = FALSE;
	const gchar* _tmp37_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = NULL;
	chess_application_disable_action (self, SAVE_GAME_AS_ACTION_NAME);
	_tmp0_ = pgn_game_new ();
	_g_object_unref0 (self->priv->pgn_game);
	self->priv->pgn_game = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = self->priv->pgn_game;
	_tmp3_ = now;
	_tmp4_ = g_date_time_format (_tmp3_, "%Y.%m.%d");
	_tmp5_ = _tmp4_;
	pgn_game_set_date (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->pgn_game;
	_tmp7_ = now;
	_tmp8_ = g_date_time_format (_tmp7_, "%H:%M:%S");
	_tmp9_ = _tmp8_;
	pgn_game_set_time (_tmp6_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->settings;
	duration = g_settings_get_int (_tmp10_, DURATION_SETTINGS_KEY);
	if (duration > 0) {
		PGNGame* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		PGNGame* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		PGNGame* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp11_ = self->priv->pgn_game;
		_tmp12_ = g_strdup_printf ("%i", duration);
		_tmp13_ = _tmp12_;
		pgn_game_set_time_control (_tmp11_, _tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = self->priv->pgn_game;
		_tmp15_ = g_strdup_printf ("%i", duration);
		_tmp16_ = _tmp15_;
		pgn_game_set_white_time_left (_tmp14_, _tmp16_);
		_g_free0 (_tmp16_);
		_tmp17_ = self->priv->pgn_game;
		_tmp18_ = g_strdup_printf ("%i", duration);
		_tmp19_ = _tmp18_;
		pgn_game_set_black_time_left (_tmp17_, _tmp19_);
		_g_free0 (_tmp19_);
	}
	_tmp20_ = self->priv->settings;
	_tmp21_ = g_settings_get_string (_tmp20_, DIFFICULTY_SETTINGS_KEY);
	engine_level = _tmp21_;
	_tmp22_ = self->priv->settings;
	_tmp23_ = g_settings_get_string (_tmp22_, OPPONENT_SETTINGS_KEY);
	engine_name = _tmp23_;
	_tmp25_ = engine_name;
	if (g_strcmp0 (_tmp25_, "human") != 0) {
		const gchar* _tmp26_;
		AIProfile* _tmp27_;
		AIProfile* _tmp28_;
		_tmp26_ = engine_name;
		_tmp27_ = chess_application_get_ai_profile (self, _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp24_ = _tmp28_ == NULL;
		_g_object_unref0 (_tmp28_);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		GList* _tmp29_;
		_tmp29_ = self->priv->ai_profiles;
		if (_tmp29_ != NULL) {
			GList* _tmp30_;
			gconstpointer _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp30_ = self->priv->ai_profiles;
			_tmp31_ = _tmp30_->data;
			_tmp32_ = ai_profile_get_name ((AIProfile*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strdup (_tmp33_);
			_g_free0 (engine_name);
			engine_name = _tmp34_;
		} else {
			gchar* _tmp35_;
			_tmp35_ = g_strdup ("human");
			_g_free0 (engine_name);
			engine_name = _tmp35_;
		}
	}
	_tmp37_ = engine_name;
	if (_tmp37_ != NULL) {
		const gchar* _tmp38_;
		_tmp38_ = engine_name;
		_tmp36_ = g_strcmp0 (_tmp38_, "human") != 0;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		gchar* play_as = NULL;
		GSettings* _tmp39_;
		gchar* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp47_;
		GSettings* _tmp57_;
		const gchar* _tmp58_;
		_tmp39_ = self->priv->settings;
		_tmp40_ = g_settings_get_string (_tmp39_, PLAY_AS_SETTINGS_KEY);
		play_as = _tmp40_;
		_tmp41_ = play_as;
		if (g_strcmp0 (_tmp41_, "alternate") == 0) {
			gchar* last_side = NULL;
			GSettings* _tmp42_;
			gchar* _tmp43_;
			const gchar* _tmp44_ = NULL;
			const gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp42_ = self->priv->settings;
			_tmp43_ = g_settings_get_string (_tmp42_, LAST_PLAYED_AS_SETTINGS_KEY);
			last_side = _tmp43_;
			_tmp45_ = last_side;
			if (g_strcmp0 (_tmp45_, "white") == 0) {
				_tmp44_ = "black";
			} else {
				_tmp44_ = "white";
			}
			_tmp46_ = g_strdup (_tmp44_);
			_g_free0 (play_as);
			play_as = _tmp46_;
			_g_free0 (last_side);
		}
		_tmp47_ = play_as;
		if (g_strcmp0 (_tmp47_, "white") == 0) {
			PGNGame* _tmp48_;
			const gchar* _tmp49_;
			PGNGame* _tmp50_;
			const gchar* _tmp51_;
			_tmp48_ = self->priv->pgn_game;
			_tmp49_ = engine_name;
			pgn_game_set_black_ai (_tmp48_, _tmp49_);
			_tmp50_ = self->priv->pgn_game;
			_tmp51_ = engine_level;
			pgn_game_set_black_level (_tmp50_, _tmp51_);
		} else {
			const gchar* _tmp52_;
			_tmp52_ = play_as;
			if (g_strcmp0 (_tmp52_, "black") == 0) {
				PGNGame* _tmp53_;
				const gchar* _tmp54_;
				PGNGame* _tmp55_;
				const gchar* _tmp56_;
				_tmp53_ = self->priv->pgn_game;
				_tmp54_ = engine_name;
				pgn_game_set_white_ai (_tmp53_, _tmp54_);
				_tmp55_ = self->priv->pgn_game;
				_tmp56_ = engine_level;
				pgn_game_set_white_level (_tmp55_, _tmp56_);
			} else {
				g_assert_not_reached ();
			}
		}
		_tmp57_ = self->priv->settings;
		_tmp58_ = play_as;
		g_settings_set_string (_tmp57_, LAST_PLAYED_AS_SETTINGS_KEY, _tmp58_);
		_g_free0 (play_as);
	}
	chess_application_start_game (self);
	_g_free0 (engine_name);
	_g_free0 (engine_level);
	_g_date_time_unref0 (now);
}

static void
chess_application_load_game (ChessApplication* self,
                             GFile* file)
{
	PGNGame* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		PGN* pgn = NULL;
		PGN* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		PGNGame* _tmp3_;
		_tmp0_ = pgn_new_from_file (file, &_inner_error0_);
		pgn = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = pgn->games;
		_tmp2_ = g_list_nth_data (_tmp1_, (guint) 0);
		_tmp3_ = _g_object_ref0 ((PGNGame*) _tmp2_);
		_g_object_unref0 (self->priv->pgn_game);
		self->priv->pgn_game = _tmp3_;
		_g_object_unref0 (pgn);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (self->priv->pgn_game);
		self->priv->pgn_game = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = self->priv->pgn_game;
	if (_tmp4_ == NULL) {
		PGNGame* _tmp5_;
		chess_application_run_invalid_pgn_dialog (self);
		_tmp5_ = pgn_game_new ();
		_g_object_unref0 (self->priv->pgn_game);
		self->priv->pgn_game = _tmp5_;
		_g_object_unref0 (self->priv->game_file);
		self->priv->game_file = NULL;
	} else {
		GFile* _tmp6_;
		_tmp6_ = _g_object_ref0 (file);
		_g_object_unref0 (self->priv->game_file);
		self->priv->game_file = _tmp6_;
		chess_application_start_game (self);
	}
}

void
chess_application_enable_action (ChessApplication* self,
                                 const gchar* name)
{
	GAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, name);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), TRUE);
}

void
chess_application_disable_action (ChessApplication* self,
                                  const gchar* name)
{
	GAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, name);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), FALSE);
}

static gint
chess_application_main (gchar** args,
                        gint args_length1)
{
	ChessApplication* _tmp0_;
	ChessApplication* _tmp1_;
	gint _tmp2_;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name (_ ("Chess"));
	gtk_window_set_default_icon_name ("org.gnome.Chess");
	_tmp0_ = chess_application_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return chess_application_main (argv, argc);
}

ChessWindow*
chess_application_get_window (ChessApplication* self)
{
	ChessWindow* result;
	ChessWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
chess_application_set_window (ChessApplication* self,
                              ChessWindow* value)
{
	ChessWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = chess_application_get_window (self);
	if (old_value != value) {
		self->priv->_window = value;
		g_object_notify_by_pspec ((GObject *) self, chess_application_properties[CHESS_APPLICATION_WINDOW_PROPERTY]);
	}
}

ChessView*
chess_application_get_view (ChessApplication* self)
{
	ChessView* result;
	ChessWindow* _tmp0_;
	ChessView* _tmp1_;
	ChessView* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = chess_window_get_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

ChessScene*
chess_application_get_scene (ChessApplication* self)
{
	ChessScene* result;
	ChessView* _tmp0_;
	ChessView* _tmp1_;
	ChessScene* _tmp2_;
	ChessScene* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_application_get_view (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_view_get_scene (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static void
chess_application_class_init (ChessApplicationClass * klass,
                              gpointer klass_data)
{
	chess_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ChessApplication_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) chess_application_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) chess_application_real_startup;
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) chess_application_real_open;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) chess_application_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) chess_application_real_shutdown;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_application_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_APPLICATION_WINDOW_PROPERTY, chess_application_properties[CHESS_APPLICATION_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", TYPE_CHESS_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_APPLICATION_VIEW_PROPERTY, chess_application_properties[CHESS_APPLICATION_VIEW_PROPERTY] = g_param_spec_object ("view", "view", "view", TYPE_CHESS_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_APPLICATION_SCENE_PROPERTY, chess_application_properties[CHESS_APPLICATION_SCENE_PROPERTY] = g_param_spec_object ("scene", "scene", "scene", TYPE_CHESS_SCENE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
chess_application_instance_init (ChessApplication * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
	self->priv = chess_application_get_instance_private (self);
	self->priv->new_game_dialog = NULL;
	self->priv->preferences_dialog = NULL;
	self->priv->about_dialog = NULL;
	self->priv->open_dialog = NULL;
	self->priv->save_dialog = NULL;
	self->priv->game = NULL;
	self->priv->game_needs_saving = FALSE;
	self->priv->starting = TRUE;
	self->priv->opponent = NULL;
	self->priv->human_player = NULL;
	self->priv->opponent_engine = NULL;
	self->priv->engine_timeout_source = (guint) 0;
	_tmp0_ = g_strdup ("Copyright \302\251 2010\342\200\2232013 Robert Ancell\n" \
"Copyright \302\251 2013\342\200\2232024 Michael Catanzaro\n" \
"Copyright \302\251 2015\342\200\2232016 Sahil Sareen");
	self->priv->copyrights = _tmp0_;
}

static void
chess_application_finalize (GObject * obj)
{
	ChessApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_APPLICATION, ChessApplication);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->preferences);
	_g_object_unref0 (self->priv->new_game_dialog);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->about_dialog);
	_g_object_unref0 (self->priv->open_dialog);
	_g_object_unref0 (self->priv->save_dialog);
	_g_object_unref0 (self->priv->pgn_game);
	_g_object_unref0 (self->priv->game);
	_g_free0 (self->priv->autosave_filename);
	_g_object_unref0 (self->priv->game_file);
	(self->priv->ai_profiles == NULL) ? NULL : (self->priv->ai_profiles = (_g_list_free__g_object_unref0_ (self->priv->ai_profiles), NULL));
	_g_object_unref0 (self->priv->opponent);
	_g_object_unref0 (self->priv->human_player);
	_g_object_unref0 (self->priv->opponent_engine);
	_g_free0 (self->priv->copyrights);
	G_OBJECT_CLASS (chess_application_parent_class)->finalize (obj);
}

static GType
chess_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ChessApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessApplication), 0, (GInstanceInitFunc) chess_application_instance_init, NULL };
	GType chess_application_type_id;
	chess_application_type_id = g_type_register_static (adw_application_get_type (), "ChessApplication", &g_define_type_info, 0);
	ChessApplication_private_offset = g_type_add_instance_private (chess_application_type_id, sizeof (ChessApplicationPrivate));
	return chess_application_type_id;
}

GType
chess_application_get_type (void)
{
	static volatile gsize chess_application_type_id__once = 0;
	if (g_once_init_enter (&chess_application_type_id__once)) {
		GType chess_application_type_id;
		chess_application_type_id = chess_application_get_type_once ();
		g_once_init_leave (&chess_application_type_id__once, chess_application_type_id);
	}
	return chess_application_type_id__once;
}

static void
_vala_chess_application_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	ChessApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_APPLICATION, ChessApplication);
	switch (property_id) {
		case CHESS_APPLICATION_WINDOW_PROPERTY:
		g_value_set_object (value, chess_application_get_window (self));
		break;
		case CHESS_APPLICATION_VIEW_PROPERTY:
		g_value_set_object (value, chess_application_get_view (self));
		break;
		case CHESS_APPLICATION_SCENE_PROPERTY:
		g_value_set_object (value, chess_application_get_scene (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_chess_application_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	ChessApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_APPLICATION, ChessApplication);
	switch (property_id) {
		case CHESS_APPLICATION_WINDOW_PROPERTY:
		chess_application_set_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

