//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PTransportProviderChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/net/IPCTransportProvider.h"

#include "mozilla/net/PNeckoChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


MOZ_IMPLICIT PTransportProviderChild::PTransportProviderChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PTransportProviderChild);
}

PTransportProviderChild::~PTransportProviderChild()
{
    MOZ_COUNT_DTOR(PTransportProviderChild);
}

auto PTransportProviderChild::ActorAlloc() -> void
{
}

auto PTransportProviderChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PTransportProviderChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PTransportProviderChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PTransportProviderChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PTransportProviderChild::Manager() const -> PNeckoChild*
{
    return static_cast<PNeckoChild*>(IProtocol::Manager());
}

auto PTransportProviderChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PTransportProviderChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PTransportProviderChild::Send__delete__(PTransportProviderChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PTransportProvider::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PTransportProvider", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PTransportProviderChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PTransportProvider::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PTransportProviderChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PTransportProviderChild::OnMessageReceived(const Message& msg__) -> PTransportProviderChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PTransportProvider::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PTransportProviderChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PTransportProviderChild::Result
{
    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PTransportProviderChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PTransportProvider'
    (aWriter)->WriteSentinel(1158612841);
}

auto ParamTraits<::mozilla::net::PTransportProviderChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PTransportProvider actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PTransportProvider'
    if ((!((aReader)->ReadSentinel(1158612841)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PTransportProvider actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PTransportProviderMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PTransportProvider)");

        return {};
    }
    return static_cast<::mozilla::net::PTransportProviderChild*>(actor);
}

} // namespace IPC
