/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM ProgressEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "ProgressEvent.h"
#include "ProgressEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ProgressEvent.h"

namespace mozilla::dom {


ProgressEvent::ProgressEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

ProgressEvent::~ProgressEvent()
{
}

ProgressEvent*
ProgressEvent::AsProgressEvent()
{
  return this;
}

JSObject*
ProgressEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return ProgressEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<ProgressEvent>
ProgressEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const ProgressEventInit& aEventInitDict)
{
  RefPtr<ProgressEvent> e = new ProgressEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mLengthComputable = aEventInitDict.mLengthComputable;
  e->mLoaded = aEventInitDict.mLoaded;
  e->mTotal = aEventInitDict.mTotal;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<ProgressEvent>
ProgressEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const ProgressEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

bool
ProgressEvent::LengthComputable() const
{
  return mLengthComputable;
}

double
ProgressEvent::Loaded() const
{
  return mLoaded;
}

double
ProgressEvent::Total() const
{
  return mTotal;
}


} // namespace mozilla::dom
