/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM NavigationCurrentEntryChangeEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "Navigation.h"
#include "NavigationCurrentEntryChangeEvent.h"
#include "NavigationCurrentEntryChangeEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/NavigationCurrentEntryChangeEvent.h"
#include "mozilla/dom/NavigationHistoryEntry.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(NavigationCurrentEntryChangeEvent)

NS_IMPL_ADDREF_INHERITED(NavigationCurrentEntryChangeEvent, Event)
NS_IMPL_RELEASE_INHERITED(NavigationCurrentEntryChangeEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(NavigationCurrentEntryChangeEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mFrom)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(NavigationCurrentEntryChangeEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(NavigationCurrentEntryChangeEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mFrom)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(NavigationCurrentEntryChangeEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

NavigationCurrentEntryChangeEvent::NavigationCurrentEntryChangeEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

NavigationCurrentEntryChangeEvent::~NavigationCurrentEntryChangeEvent()
{
}

NavigationCurrentEntryChangeEvent*
NavigationCurrentEntryChangeEvent::AsNavigationCurrentEntryChangeEvent()
{
  return this;
}

JSObject*
NavigationCurrentEntryChangeEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return NavigationCurrentEntryChangeEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<NavigationCurrentEntryChangeEvent>
NavigationCurrentEntryChangeEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const NavigationCurrentEntryChangeEventInit& aEventInitDict)
{
  RefPtr<NavigationCurrentEntryChangeEvent> e = new NavigationCurrentEntryChangeEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mNavigationType = aEventInitDict.mNavigationType;
  e->mFrom = aEventInitDict.mFrom;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<NavigationCurrentEntryChangeEvent>
NavigationCurrentEntryChangeEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const NavigationCurrentEntryChangeEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

Nullable<NavigationType>
NavigationCurrentEntryChangeEvent::GetNavigationType() const
{
  return mNavigationType;
}

NavigationHistoryEntry*
NavigationCurrentEntryChangeEvent::From() const
{
  return mFrom;
}


} // namespace mozilla::dom
