/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM AnimationPlaybackEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "AnimationPlaybackEvent.h"
#include "AnimationPlaybackEventBinding.h"
#include "EventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/AnimationPlaybackEvent.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


AnimationPlaybackEvent::AnimationPlaybackEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

AnimationPlaybackEvent::~AnimationPlaybackEvent()
{
}

AnimationPlaybackEvent*
AnimationPlaybackEvent::AsAnimationPlaybackEvent()
{
  return this;
}

JSObject*
AnimationPlaybackEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return AnimationPlaybackEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<AnimationPlaybackEvent>
AnimationPlaybackEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const AnimationPlaybackEventInit& aEventInitDict)
{
  RefPtr<AnimationPlaybackEvent> e = new AnimationPlaybackEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mCurrentTime = aEventInitDict.mCurrentTime;
  e->mTimelineTime = aEventInitDict.mTimelineTime;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<AnimationPlaybackEvent>
AnimationPlaybackEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const AnimationPlaybackEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

Nullable<double>
AnimationPlaybackEvent::GetCurrentTime() const
{
  return mCurrentTime;
}

Nullable<double>
AnimationPlaybackEvent::GetTimelineTime() const
{
  return mTimelineTime;
}


} // namespace mozilla::dom
