/* MainWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*
* Copyright 2015-2023 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA.
*
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <adwaita.h>
#include <granite-7.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <webkit/webkit.h>
#include <gcr/gcr.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gdk/gdk.h>

#define CAPTIVE_MAIN_WINDOW_DUMMY_URL "http://capnet.elementary.io"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CAPTIVE_TYPE_MAIN_WINDOW (captive_main_window_get_type ())
#define CAPTIVE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAPTIVE_TYPE_MAIN_WINDOW, CaptiveMainWindow))
#define CAPTIVE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CAPTIVE_TYPE_MAIN_WINDOW, CaptiveMainWindowClass))
#define CAPTIVE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAPTIVE_TYPE_MAIN_WINDOW))
#define CAPTIVE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CAPTIVE_TYPE_MAIN_WINDOW))
#define CAPTIVE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CAPTIVE_TYPE_MAIN_WINDOW, CaptiveMainWindowClass))

typedef struct _CaptiveMainWindow CaptiveMainWindow;
typedef struct _CaptiveMainWindowClass CaptiveMainWindowClass;
typedef struct _CaptiveMainWindowPrivate CaptiveMainWindowPrivate;
enum  {
	CAPTIVE_MAIN_WINDOW_0_PROPERTY,
	CAPTIVE_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* captive_main_window_properties[CAPTIVE_MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CAPTIVE_TYPE_TABBED_WEB_VIEW (captive_tabbed_web_view_get_type ())
#define CAPTIVE_TABBED_WEB_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAPTIVE_TYPE_TABBED_WEB_VIEW, CaptiveTabbedWebView))
#define CAPTIVE_TABBED_WEB_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CAPTIVE_TYPE_TABBED_WEB_VIEW, CaptiveTabbedWebViewClass))
#define CAPTIVE_IS_TABBED_WEB_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAPTIVE_TYPE_TABBED_WEB_VIEW))
#define CAPTIVE_IS_TABBED_WEB_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CAPTIVE_TYPE_TABBED_WEB_VIEW))
#define CAPTIVE_TABBED_WEB_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CAPTIVE_TYPE_TABBED_WEB_VIEW, CaptiveTabbedWebViewClass))

typedef struct _CaptiveTabbedWebView CaptiveTabbedWebView;
typedef struct _CaptiveTabbedWebViewClass CaptiveTabbedWebViewClass;
typedef enum  {
	CAPTIVE_TABBED_WEB_VIEW_SECURITY_NONE,
	CAPTIVE_TABBED_WEB_VIEW_SECURITY_SECURE,
	CAPTIVE_TABBED_WEB_VIEW_SECURITY_LOADING,
	CAPTIVE_TABBED_WEB_VIEW_SECURITY_MIXED_CONTENT
} CaptiveTabbedWebViewSecurity;

#define CAPTIVE_TABBED_WEB_VIEW_TYPE_SECURITY (captive_tabbed_web_view_security_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CaptiveMainWindow {
	GtkApplicationWindow parent_instance;
	CaptiveMainWindowPrivate * priv;
};

struct _CaptiveMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _CaptiveMainWindowPrivate {
	AdwTabView* tabview;
	GraniteHeaderLabel* cert_subject;
	GtkImage* popover_image;
	GtkLabel* cert_expiry;
	GtkLabel* cert_issuer;
	GtkLabel* popover_label;
	GtkLabel* title_label;
	GtkMenuButton* cert_button;
	gboolean download_requested;
};

struct _Block2Data {
	int _ref_count_;
	CaptiveMainWindow* self;
	CaptiveTabbedWebView* webview;
	AdwTabPage* tabpage;
};

static gint CaptiveMainWindow_private_offset;
static gpointer captive_main_window_parent_class = NULL;

VALA_EXTERN GType captive_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CaptiveMainWindow, g_object_unref)
VALA_EXTERN CaptiveMainWindow* captive_main_window_new (GtkApplication* app);
VALA_EXTERN CaptiveMainWindow* captive_main_window_construct (GType object_type,
                                                  GtkApplication* app);
VALA_EXTERN GType captive_tabbed_web_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CaptiveTabbedWebView, g_object_unref)
static void captive_main_window_update_security (CaptiveMainWindow* self,
                                          CaptiveTabbedWebView* web_view);
VALA_EXTERN GType captive_tabbed_web_view_security_get_type (void) G_GNUC_CONST ;
VALA_EXTERN CaptiveTabbedWebViewSecurity captive_tabbed_web_view_get_security (CaptiveTabbedWebView* self);
VALA_EXTERN gchar* captive_tabbed_web_view_security_to_icon_name (CaptiveTabbedWebViewSecurity self);
VALA_EXTERN gchar* captive_tabbed_web_view_security_to_string (CaptiveTabbedWebView* self);
VALA_EXTERN GcrSimpleCertificate* captive_tabbed_web_view_get_certificate (CaptiveTabbedWebView* self);
static gboolean captive_main_window_is_privacy_mode_enabled (CaptiveMainWindow* self);
static CaptiveTabbedWebView* captive_main_window_create_tab (CaptiveMainWindow* self,
                                                      const gchar* uri);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN CaptiveTabbedWebView* captive_tabbed_web_view_new (gboolean load_cookies);
VALA_EXTERN CaptiveTabbedWebView* captive_tabbed_web_view_construct (GType object_type,
                                                         gboolean load_cookies);
static void __lambda6_ (Block2Data* _data2_,
                 GObject* view,
                 GParamSpec* param_spec);
static void ___lambda6__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda7_ (Block2Data* _data2_,
                 GObject* view,
                 GParamSpec* param_spec);
static void ___lambda7__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static GtkWidget* __lambda8_ (CaptiveMainWindow* self,
                       WebKitNavigationAction* navigation_action);
static GtkWidget* ___lambda8__webkit_web_view_create (WebKitWebView* _sender,
                                               WebKitNavigationAction* navigation_action,
                                               gpointer self);
static gboolean __lambda9_ (CaptiveMainWindow* self,
                     WebKitPolicyDecision* decision,
                     WebKitPolicyDecisionType type);
static gboolean ___lambda9__webkit_web_view_decide_policy (WebKitWebView* _sender,
                                                    WebKitPolicyDecision* decision,
                                                    WebKitPolicyDecisionType type,
                                                    gpointer self);
VALA_EXTERN void captive_main_window_start (CaptiveMainWindow* self,
                                const gchar* browser_url);
static gboolean __lambda10_ (CaptiveMainWindow* self,
                      WebKitLoadEvent event,
                      const gchar* uri,
                      GError* _error_);
static gboolean ___lambda10__webkit_web_view_load_failed (WebKitWebView* _sender,
                                                   WebKitLoadEvent load_event,
                                                   const gchar* failing_uri,
                                                   GError* _error_,
                                                   gpointer self);
static GObject * captive_main_window_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _captive_main_window___lambda11_ (CaptiveMainWindow* self);
static void __captive_main_window___lambda11__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static gboolean _captive_main_window___lambda12_ (CaptiveMainWindow* self,
                                           AdwTabPage* page);
static gboolean __captive_main_window___lambda12__adw_tab_view_close_page (AdwTabView* _sender,
                                                                    AdwTabPage* page,
                                                                    gpointer self);
static void captive_main_window_finalize (GObject * obj);
static GType captive_main_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
captive_main_window_get_instance_private (CaptiveMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, CaptiveMainWindow_private_offset);
}

CaptiveMainWindow*
captive_main_window_construct (GType object_type,
                               GtkApplication* app)
{
	CaptiveMainWindow * self = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	self = (CaptiveMainWindow*) g_object_new (object_type, "application", app, NULL);
	return self;
}

CaptiveMainWindow*
captive_main_window_new (GtkApplication* app)
{
	return captive_main_window_construct (CAPTIVE_TYPE_MAIN_WINDOW, app);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
captive_main_window_update_security (CaptiveMainWindow* self,
                                     CaptiveTabbedWebView* web_view)
{
	GtkMenuButton* _tmp0_;
	CaptiveTabbedWebViewSecurity _tmp1_;
	CaptiveTabbedWebViewSecurity _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkMenuButton* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkLabel* _tmp8_;
	GtkMenuButton* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	CaptiveTabbedWebViewSecurity _tmp12_;
	CaptiveTabbedWebViewSecurity _tmp13_;
	GtkImage* _tmp22_;
	GtkMenuButton* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gboolean _tmp28_ = FALSE;
	CaptiveTabbedWebViewSecurity _tmp29_;
	CaptiveTabbedWebViewSecurity _tmp30_;
	GtkMenuButton* _tmp33_;
	GcrSimpleCertificate* _tmp34_;
	GcrSimpleCertificate* _tmp35_;
	GtkLabel* _tmp37_;
	GcrSimpleCertificate* _tmp38_;
	GcrSimpleCertificate* _tmp39_;
	GDateTime* _tmp40_;
	GDateTime* _tmp41_;
	GDateTime* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GtkLabel* _tmp49_;
	GcrSimpleCertificate* _tmp50_;
	GcrSimpleCertificate* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	GraniteHeaderLabel* _tmp57_;
	GcrSimpleCertificate* _tmp58_;
	GcrSimpleCertificate* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (web_view != NULL);
	_tmp0_ = self->priv->cert_button;
	_tmp1_ = captive_tabbed_web_view_get_security (web_view);
	_tmp2_ = _tmp1_;
	_tmp3_ = captive_tabbed_web_view_security_to_icon_name (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_window_set_icon_name ((GtkWindow*) self, _tmp4_);
	gtk_menu_button_set_icon_name (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->cert_button;
	_tmp6_ = captive_tabbed_web_view_security_to_string (web_view);
	_tmp7_ = _tmp6_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->popover_label;
	_tmp9_ = self->priv->cert_button;
	_tmp10_ = gtk_widget_get_tooltip_text ((GtkWidget*) _tmp9_);
	_tmp11_ = _tmp10_;
	gtk_label_set_label (_tmp8_, _tmp11_);
	_tmp12_ = captive_tabbed_web_view_get_security (web_view);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == CAPTIVE_TABBED_WEB_VIEW_SECURITY_SECURE) {
		GtkLabel* _tmp14_;
		gchar* _tmp15_;
		gchar** _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		_tmp14_ = self->priv->popover_label;
		_tmp15_ = g_strdup ("success");
		_tmp16_ = g_new0 (gchar*, 1 + 1);
		_tmp16_[0] = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp17__length1 = 1;
		gtk_widget_set_css_classes ((GtkWidget*) _tmp14_, _tmp17_);
		_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	} else {
		GtkLabel* _tmp18_;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		_tmp18_ = self->priv->popover_label;
		_tmp19_ = g_strdup (GRANITE_STYLE_CLASS_WARNING);
		_tmp20_ = g_new0 (gchar*, 1 + 1);
		_tmp20_[0] = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp21__length1 = 1;
		gtk_widget_set_css_classes ((GtkWidget*) _tmp18_, _tmp21_);
		_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp22_ = self->priv->popover_image;
	_tmp23_ = self->priv->cert_button;
	_tmp24_ = gtk_menu_button_get_icon_name (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = string_replace (_tmp25_, "-symbolic", "");
	_tmp27_ = _tmp26_;
	g_object_set (_tmp22_, "icon-name", _tmp27_, NULL);
	_g_free0 (_tmp27_);
	_tmp29_ = captive_tabbed_web_view_get_security (web_view);
	_tmp30_ = _tmp29_;
	if (_tmp30_ != CAPTIVE_TABBED_WEB_VIEW_SECURITY_NONE) {
		CaptiveTabbedWebViewSecurity _tmp31_;
		CaptiveTabbedWebViewSecurity _tmp32_;
		_tmp31_ = captive_tabbed_web_view_get_security (web_view);
		_tmp32_ = _tmp31_;
		_tmp28_ = _tmp32_ != CAPTIVE_TABBED_WEB_VIEW_SECURITY_LOADING;
	} else {
		_tmp28_ = FALSE;
	}
	_tmp33_ = self->priv->cert_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp33_, _tmp28_);
	_tmp34_ = captive_tabbed_web_view_get_certificate (web_view);
	_tmp35_ = _tmp34_;
	if (_tmp35_ == NULL) {
		GtkMenuButton* _tmp36_;
		_tmp36_ = self->priv->cert_button;
		gtk_menu_button_set_active (_tmp36_, FALSE);
		return;
	}
	_tmp37_ = self->priv->cert_expiry;
	_tmp38_ = captive_tabbed_web_view_get_certificate (web_view);
	_tmp39_ = _tmp38_;
	_tmp40_ = gcr_certificate_get_expiry_date ((GcrCertificate*) _tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = _tmp41_;
	_tmp43_ = granite_date_time_get_default_date_format (FALSE, TRUE, TRUE);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_date_time_format (_tmp42_, _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = g_strdup_printf (_ ("Expires %s"), _tmp46_);
	_tmp48_ = _tmp47_;
	gtk_label_set_label (_tmp37_, _tmp48_);
	_g_free0 (_tmp48_);
	_g_free0 (_tmp46_);
	_g_free0 (_tmp44_);
	_g_date_time_unref0 (_tmp42_);
	_tmp49_ = self->priv->cert_issuer;
	_tmp50_ = captive_tabbed_web_view_get_certificate (web_view);
	_tmp51_ = _tmp50_;
	_tmp52_ = gcr_certificate_get_issuer_name ((GcrCertificate*) _tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = _tmp53_;
	_tmp55_ = g_strdup_printf (_ ("Issued by “%s”"), _tmp54_);
	_tmp56_ = _tmp55_;
	gtk_label_set_label (_tmp49_, _tmp56_);
	_g_free0 (_tmp56_);
	_g_free0 (_tmp54_);
	_tmp57_ = self->priv->cert_subject;
	_tmp58_ = captive_tabbed_web_view_get_certificate (web_view);
	_tmp59_ = _tmp58_;
	_tmp60_ = gcr_certificate_get_subject_name ((GcrCertificate*) _tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = _tmp61_;
	granite_header_label_set_label (_tmp57_, _tmp62_);
	_g_free0 (_tmp62_);
}

static gboolean
captive_main_window_is_privacy_mode_enabled (CaptiveMainWindow* self)
{
	GSettings* privacy_settings = NULL;
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_settings_new ("org.gnome.desktop.privacy");
	privacy_settings = _tmp0_;
	_tmp2_ = privacy_settings;
	if (!g_settings_get_boolean (_tmp2_, "remember-recent-files")) {
		_tmp1_ = TRUE;
	} else {
		GSettings* _tmp3_;
		_tmp3_ = privacy_settings;
		_tmp1_ = !g_settings_get_boolean (_tmp3_, "remember-app-usage");
	}
	result = _tmp1_;
	_g_object_unref0 (privacy_settings);
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		CaptiveMainWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->tabpage);
		_g_object_unref0 (_data2_->webview);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda6_ (Block2Data* _data2_,
            GObject* view,
            GParamSpec* param_spec)
{
	CaptiveMainWindow* self;
	AdwTabView* _tmp0_;
	AdwTabPage* _tmp1_;
	self = _data2_->self;
	g_return_if_fail (view != NULL);
	g_return_if_fail (param_spec != NULL);
	_tmp0_ = self->priv->tabview;
	_tmp1_ = adw_tab_view_get_selected_page (_tmp0_);
	if (_data2_->tabpage == _tmp1_) {
		GtkLabel* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->title_label;
		_tmp3_ = webkit_web_view_get_title ((WebKitWebView*) _data2_->webview);
		_tmp4_ = _tmp3_;
		gtk_label_set_text (_tmp2_, _tmp4_);
	}
}

static void
___lambda6__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda6_ (self, _sender, pspec);
}

static void
__lambda7_ (Block2Data* _data2_,
            GObject* view,
            GParamSpec* param_spec)
{
	CaptiveMainWindow* self;
	AdwTabView* _tmp0_;
	AdwTabPage* _tmp1_;
	self = _data2_->self;
	g_return_if_fail (view != NULL);
	g_return_if_fail (param_spec != NULL);
	_tmp0_ = self->priv->tabview;
	_tmp1_ = adw_tab_view_get_selected_page (_tmp0_);
	if (_data2_->tabpage == _tmp1_) {
		captive_main_window_update_security (self, _data2_->webview);
	}
}

static void
___lambda7__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda7_ (self, _sender, pspec);
}

static GtkWidget*
__lambda8_ (CaptiveMainWindow* self,
            WebKitNavigationAction* navigation_action)
{
	WebKitURIRequest* _tmp0_;
	const gchar* _tmp1_;
	CaptiveTabbedWebView* _tmp2_;
	CaptiveTabbedWebView* _tmp3_;
	GtkWidget* result;
	g_return_val_if_fail (navigation_action != NULL, NULL);
	_tmp0_ = webkit_navigation_action_get_request (navigation_action);
	_tmp1_ = webkit_uri_request_get_uri (_tmp0_);
	_tmp2_ = captive_main_window_create_tab (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	result = NULL;
	return result;
}

static GtkWidget*
___lambda8__webkit_web_view_create (WebKitWebView* _sender,
                                    WebKitNavigationAction* navigation_action,
                                    gpointer self)
{
	GtkWidget* result;
	result = __lambda8_ ((CaptiveMainWindow*) self, navigation_action);
	return result;
}

static gboolean
__lambda9_ (CaptiveMainWindow* self,
            WebKitPolicyDecision* decision,
            WebKitPolicyDecisionType type)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (decision != NULL, FALSE);
	switch (type) {
		case WEBKIT_POLICY_DECISION_TYPE_NEW_WINDOW_ACTION:
		{
			if (G_TYPE_CHECK_INSTANCE_TYPE (decision, webkit_response_policy_decision_get_type ())) {
				WebKitResponsePolicyDecision* policy = NULL;
				WebKitResponsePolicyDecision* _tmp0_;
				WebKitResponsePolicyDecision* _tmp1_;
				WebKitURIRequest* _tmp2_;
				WebKitURIRequest* _tmp3_;
				const gchar* _tmp4_;
				CaptiveTabbedWebView* _tmp5_;
				CaptiveTabbedWebView* _tmp6_;
				_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (decision, webkit_response_policy_decision_get_type (), WebKitResponsePolicyDecision));
				policy = _tmp0_;
				_tmp1_ = policy;
				_tmp2_ = webkit_response_policy_decision_get_request (_tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = webkit_uri_request_get_uri (_tmp3_);
				_tmp5_ = captive_main_window_create_tab (self, _tmp4_);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp6_);
				_g_object_unref0 (policy);
			}
			break;
		}
		case WEBKIT_POLICY_DECISION_TYPE_RESPONSE:
		{
			if (G_TYPE_CHECK_INSTANCE_TYPE (decision, webkit_response_policy_decision_get_type ())) {
				WebKitResponsePolicyDecision* policy = NULL;
				WebKitResponsePolicyDecision* _tmp7_;
				WebKitResponsePolicyDecision* _tmp8_;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (decision, webkit_response_policy_decision_get_type (), WebKitResponsePolicyDecision));
				policy = _tmp7_;
				_tmp8_ = policy;
				if (!webkit_response_policy_decision_is_mime_type_supported (_tmp8_)) {
					{
						gchar* url = NULL;
						WebKitResponsePolicyDecision* _tmp9_;
						WebKitURIRequest* _tmp10_;
						WebKitURIRequest* _tmp11_;
						const gchar* _tmp12_;
						gchar* _tmp13_;
						_tmp9_ = policy;
						_tmp10_ = webkit_response_policy_decision_get_request (_tmp9_);
						_tmp11_ = _tmp10_;
						_tmp12_ = webkit_uri_request_get_uri (_tmp11_);
						_tmp13_ = g_strdup (_tmp12_);
						url = _tmp13_;
						g_app_info_launch_default_for_uri (url, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (url);
							goto __catch0_g_error;
						}
						self->priv->download_requested = TRUE;
						_g_free0 (url);
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						GError* _tmp14_;
						const gchar* _tmp15_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp14_ = e;
						_tmp15_ = _tmp14_->message;
						g_warning ("MainWindow.vala:222: No app to handle urls: %s", _tmp15_);
						_g_error_free0 (e);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gboolean _tmp16_ = FALSE;
						_g_object_unref0 (policy);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp16_;
					}
					result = FALSE;
					_g_object_unref0 (policy);
					return result;
				}
				_g_object_unref0 (policy);
			}
			break;
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda9__webkit_web_view_decide_policy (WebKitWebView* _sender,
                                           WebKitPolicyDecision* decision,
                                           WebKitPolicyDecisionType type,
                                           gpointer self)
{
	gboolean result;
	result = __lambda9_ ((CaptiveMainWindow*) self, decision, type);
	return result;
}

static CaptiveTabbedWebView*
captive_main_window_create_tab (CaptiveMainWindow* self,
                                const gchar* uri)
{
	Block2Data* _data2_;
	CaptiveTabbedWebView* _tmp0_;
	AdwTabView* _tmp1_;
	AdwTabPage* _tmp2_;
	AdwTabPage* _tmp3_;
	CaptiveTabbedWebView* _tmp4_;
	CaptiveTabbedWebView* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = captive_tabbed_web_view_new (!captive_main_window_is_privacy_mode_enabled (self));
	g_object_ref_sink (_tmp0_);
	_data2_->webview = _tmp0_;
	_tmp1_ = self->priv->tabview;
	_tmp2_ = adw_tab_view_append (_tmp1_, (GtkWidget*) _data2_->webview);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_data2_->tabpage = _tmp3_;
	g_object_bind_property_with_closures ((GObject*) _data2_->webview, "title", (GObject*) _data2_->tabpage, "title", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data ((GObject*) _data2_->webview, "notify::title", (GCallback) ___lambda6__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	g_signal_connect_data ((GObject*) _data2_->webview, "notify::security", (GCallback) ___lambda7__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	g_signal_connect_object ((WebKitWebView*) _data2_->webview, "create", (GCallback) ___lambda8__webkit_web_view_create, self, 0);
	g_signal_connect_object ((WebKitWebView*) _data2_->webview, "decide-policy", (GCallback) ___lambda9__webkit_web_view_decide_policy, self, 0);
	webkit_web_view_load_uri ((WebKitWebView*) _data2_->webview, uri);
	_tmp4_ = _g_object_ref0 (_data2_->webview);
	result = _tmp4_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static gboolean
__lambda10_ (CaptiveMainWindow* self,
             WebKitLoadEvent event,
             const gchar* uri,
             GError* _error_)
{
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	gboolean result;
	g_return_val_if_fail (uri != NULL, FALSE);
	g_return_val_if_fail (_error_ != NULL, FALSE);
	if (g_error_matches ((GError*) _error_, WEBKIT_NETWORK_ERROR, WEBKIT_NETWORK_ERROR_CANCELLED)) {
		result = TRUE;
		return result;
	}
	if (self->priv->download_requested) {
		self->priv->download_requested = FALSE;
		result = TRUE;
		return result;
	}
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	g_application_quit ((GApplication*) _tmp1_);
	result = TRUE;
	return result;
}

static gboolean
___lambda10__webkit_web_view_load_failed (WebKitWebView* _sender,
                                          WebKitLoadEvent load_event,
                                          const gchar* failing_uri,
                                          GError* _error_,
                                          gpointer self)
{
	gboolean result;
	result = __lambda10_ ((CaptiveMainWindow*) self, load_event, failing_uri, _error_);
	return result;
}

void
captive_main_window_start (CaptiveMainWindow* self,
                           const gchar* browser_url)
{
	const gchar* _tmp0_ = NULL;
	CaptiveTabbedWebView* default_tab = NULL;
	CaptiveTabbedWebView* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = browser_url;
	if (_tmp0_ == NULL) {
		_tmp0_ = CAPTIVE_MAIN_WINDOW_DUMMY_URL;
	}
	_tmp1_ = captive_main_window_create_tab (self, _tmp0_);
	default_tab = _tmp1_;
	g_signal_connect_object ((WebKitWebView*) default_tab, "load-failed", (GCallback) ___lambda10__webkit_web_view_load_failed, self, 0);
	gtk_window_present ((GtkWindow*) self);
	_g_object_unref0 (default_tab);
}

static void
_captive_main_window___lambda11_ (CaptiveMainWindow* self)
{
	CaptiveTabbedWebView* webview = NULL;
	AdwTabView* _tmp0_;
	AdwTabPage* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	CaptiveTabbedWebView* _tmp4_;
	GtkLabel* _tmp5_;
	CaptiveTabbedWebView* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	CaptiveTabbedWebView* _tmp9_;
	_tmp0_ = self->priv->tabview;
	_tmp1_ = adw_tab_view_get_selected_page (_tmp0_);
	_tmp2_ = adw_tab_page_get_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CAPTIVE_TYPE_TABBED_WEB_VIEW, CaptiveTabbedWebView));
	webview = _tmp4_;
	_tmp5_ = self->priv->title_label;
	_tmp6_ = webview;
	_tmp7_ = webkit_web_view_get_title ((WebKitWebView*) _tmp6_);
	_tmp8_ = _tmp7_;
	gtk_label_set_label (_tmp5_, _tmp8_);
	_tmp9_ = webview;
	captive_main_window_update_security (self, _tmp9_);
	_g_object_unref0 (webview);
}

static void
__captive_main_window___lambda11__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	_captive_main_window___lambda11_ ((CaptiveMainWindow*) self);
}

static gboolean
_captive_main_window___lambda12_ (CaptiveMainWindow* self,
                                  AdwTabPage* page)
{
	AdwTabView* _tmp0_;
	AdwTabView* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result;
	g_return_val_if_fail (page != NULL, FALSE);
	_tmp0_ = self->priv->tabview;
	adw_tab_view_close_page_finish (_tmp0_, page, TRUE);
	_tmp1_ = self->priv->tabview;
	_tmp2_ = adw_tab_view_get_n_pages (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		GtkApplication* _tmp4_;
		GtkApplication* _tmp5_;
		_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp5_ = _tmp4_;
		g_application_quit ((GApplication*) _tmp5_);
	}
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__captive_main_window___lambda12__adw_tab_view_close_page (AdwTabView* _sender,
                                                           AdwTabPage* page,
                                                           gpointer self)
{
	gboolean result;
	result = _captive_main_window___lambda12_ ((CaptiveMainWindow*) self, page);
	return result;
}

static GObject *
captive_main_window_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CaptiveMainWindow * self;
	GtkImage* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_;
	GraniteHeaderLabel* _tmp3_;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkBox* cert_box = NULL;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GraniteHeaderLabel* _tmp9_;
	GtkBox* _tmp10_;
	GtkLabel* _tmp11_;
	GtkBox* _tmp12_;
	GtkLabel* _tmp13_;
	GtkFrame* frame = NULL;
	GtkBox* _tmp14_;
	GtkWidget* _tmp15_;
	GtkFrame* _tmp16_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp17_ = NULL;
	GtkGrid* _tmp18_;
	GtkImage* _tmp19_;
	GtkGrid* _tmp20_;
	GtkLabel* _tmp21_;
	GtkGrid* _tmp22_;
	GtkFrame* _tmp23_;
	GtkPopover* popover = NULL;
	GtkGrid* _tmp24_;
	GtkWidget* _tmp25_;
	GtkPopover* _tmp26_ = NULL;
	GtkPopover* _tmp27_;
	GtkPopover* _tmp28_;
	GtkMenuButton* _tmp29_ = NULL;
	GtkMenuButton* _tmp30_;
	GtkLabel* _tmp31_;
	GtkLabel* _tmp32_;
	GtkBox* header_box = NULL;
	GtkBox* _tmp33_;
	GtkBox* _tmp34_;
	GtkMenuButton* _tmp35_;
	GtkBox* _tmp36_;
	GtkLabel* _tmp37_;
	GtkBox* _tmp38_;
	GtkWidget* _tmp39_;
	GtkHeaderBar* _tmp40_ = NULL;
	GtkHeaderBar* _tmp41_;
	GtkWidget* _tmp42_;
	GtkWidget* _tmp43_;
	AdwTabView* _tmp44_ = NULL;
	AdwTabBar* tabbar = NULL;
	AdwTabView* _tmp45_;
	AdwTabView* _tmp46_;
	AdwTabBar* _tmp47_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp48_;
	GtkBox* _tmp49_;
	AdwTabBar* _tmp50_;
	GtkBox* _tmp51_;
	AdwTabView* _tmp52_;
	GtkBox* _tmp53_;
	AdwTabView* _tmp54_;
	AdwTabView* _tmp55_;
	parent_class = G_OBJECT_CLASS (captive_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CAPTIVE_TYPE_MAIN_WINDOW, CaptiveMainWindow);
	_tmp0_ = (GtkImage*) gtk_image_new ();
	gtk_image_set_pixel_size (_tmp0_, 48);
	gtk_widget_set_valign ((GtkWidget*) _tmp0_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->popover_image);
	self->priv->popover_image = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp1_, (gfloat) 0);
	gtk_label_set_max_width_chars (_tmp1_, 55);
	gtk_label_set_wrap (_tmp1_, TRUE);
	gtk_label_set_wrap_mode (_tmp1_, PANGO_WRAP_WORD_CHAR);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->popover_label);
	self->priv->popover_label = _tmp1_;
	_tmp2_ = self->priv->popover_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_H3_LABEL);
	_tmp3_ = granite_header_label_new ("");
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->cert_subject);
	self->priv->cert_subject = _tmp3_;
	_tmp4_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 12);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->cert_issuer);
	self->priv->cert_issuer = _tmp4_;
	_tmp5_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp5_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp5_, 6);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->cert_expiry);
	self->priv->cert_expiry = _tmp5_;
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	g_object_ref_sink (_tmp6_);
	cert_box = _tmp6_;
	_tmp7_ = cert_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp7_, GRANITE_STYLE_CLASS_VIEW);
	_tmp8_ = cert_box;
	_tmp9_ = self->priv->cert_subject;
	gtk_box_append (_tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = cert_box;
	_tmp11_ = self->priv->cert_issuer;
	gtk_box_append (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = cert_box;
	_tmp13_ = self->priv->cert_expiry;
	gtk_box_append (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = cert_box;
	_tmp15_ = _g_object_ref0 ((GtkWidget*) _tmp14_);
	_tmp16_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp16_, _tmp15_);
	_g_object_unref0 (_tmp15_);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp16_, 12);
	g_object_ref_sink (_tmp16_);
	frame = _tmp16_;
	_tmp17_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp17_, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp17_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp17_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp17_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp17_, 12);
	g_object_ref_sink (_tmp17_);
	grid = _tmp17_;
	_tmp18_ = grid;
	_tmp19_ = self->priv->popover_image;
	gtk_grid_attach (_tmp18_, (GtkWidget*) _tmp19_, 0, 0, 1, 2);
	_tmp20_ = grid;
	_tmp21_ = self->priv->popover_label;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 1, 0, 1, 1);
	_tmp22_ = grid;
	_tmp23_ = frame;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 1, 1, 1, 1);
	_tmp24_ = grid;
	_tmp25_ = _g_object_ref0 ((GtkWidget*) _tmp24_);
	_tmp26_ = (GtkPopover*) gtk_popover_new ();
	gtk_popover_set_child (_tmp26_, _tmp25_);
	_g_object_unref0 (_tmp25_);
	g_object_ref_sink (_tmp26_);
	popover = _tmp26_;
	_tmp27_ = popover;
	_tmp28_ = _g_object_ref0 (_tmp27_);
	_tmp29_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_menu_button_set_popover (_tmp29_, _tmp28_);
	_g_object_unref0 (_tmp28_);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->cert_button);
	self->priv->cert_button = _tmp29_;
	_tmp30_ = self->priv->cert_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp30_, "titlebutton");
	_tmp31_ = (GtkLabel*) gtk_label_new (_ ("Log in"));
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp31_;
	_tmp32_ = self->priv->title_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp32_, GRANITE_STYLE_CLASS_TITLE_LABEL);
	_tmp33_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp33_);
	header_box = _tmp33_;
	_tmp34_ = header_box;
	_tmp35_ = self->priv->cert_button;
	gtk_box_append (_tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = header_box;
	_tmp37_ = self->priv->title_label;
	gtk_box_append (_tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = header_box;
	_tmp39_ = _g_object_ref0 ((GtkWidget*) _tmp38_);
	_tmp40_ = (GtkHeaderBar*) gtk_header_bar_new ();
	gtk_header_bar_set_title_widget (_tmp40_, _tmp39_);
	_g_object_unref0 (_tmp39_);
	gtk_header_bar_set_show_title_buttons (_tmp40_, TRUE);
	g_object_ref_sink (_tmp40_);
	_tmp41_ = _tmp40_;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp41_);
	_g_object_unref0 (_tmp41_);
	_tmp42_ = gtk_window_get_titlebar ((GtkWindow*) self);
	_tmp43_ = _tmp42_;
	gtk_widget_add_css_class (_tmp43_, "default-decoration");
	_tmp44_ = adw_tab_view_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp44_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp44_, TRUE);
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->tabview);
	self->priv->tabview = _tmp44_;
	_tmp45_ = self->priv->tabview;
	_tmp46_ = _g_object_ref0 (_tmp45_);
	_tmp47_ = adw_tab_bar_new ();
	adw_tab_bar_set_expand_tabs (_tmp47_, FALSE);
	adw_tab_bar_set_inverted (_tmp47_, TRUE);
	adw_tab_bar_set_view (_tmp47_, _tmp46_);
	_g_object_unref0 (_tmp46_);
	g_object_ref_sink (_tmp47_);
	tabbar = _tmp47_;
	_tmp48_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp48_);
	box = _tmp48_;
	_tmp49_ = box;
	_tmp50_ = tabbar;
	gtk_box_append (_tmp49_, (GtkWidget*) _tmp50_);
	_tmp51_ = box;
	_tmp52_ = self->priv->tabview;
	gtk_box_append (_tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = box;
	gtk_window_set_child ((GtkWindow*) self, (GtkWidget*) _tmp53_);
	_tmp54_ = self->priv->tabview;
	g_signal_connect_object ((GObject*) _tmp54_, "notify::selected-page", (GCallback) __captive_main_window___lambda11__g_object_notify, self, 0);
	_tmp55_ = self->priv->tabview;
	g_signal_connect_object (_tmp55_, "close-page", (GCallback) __captive_main_window___lambda12__adw_tab_view_close_page, self, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (tabbar);
	_g_object_unref0 (header_box);
	_g_object_unref0 (popover);
	_g_object_unref0 (grid);
	_g_object_unref0 (frame);
	_g_object_unref0 (cert_box);
	return obj;
}

static void
captive_main_window_class_init (CaptiveMainWindowClass * klass,
                                gpointer klass_data)
{
	captive_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CaptiveMainWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = captive_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = captive_main_window_finalize;
}

static void
captive_main_window_instance_init (CaptiveMainWindow * self,
                                   gpointer klass)
{
	self->priv = captive_main_window_get_instance_private (self);
	self->priv->download_requested = FALSE;
}

static void
captive_main_window_finalize (GObject * obj)
{
	CaptiveMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CAPTIVE_TYPE_MAIN_WINDOW, CaptiveMainWindow);
	_g_object_unref0 (self->priv->tabview);
	_g_object_unref0 (self->priv->cert_subject);
	_g_object_unref0 (self->priv->popover_image);
	_g_object_unref0 (self->priv->cert_expiry);
	_g_object_unref0 (self->priv->cert_issuer);
	_g_object_unref0 (self->priv->popover_label);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->cert_button);
	G_OBJECT_CLASS (captive_main_window_parent_class)->finalize (obj);
}

static GType
captive_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CaptiveMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) captive_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaptiveMainWindow), 0, (GInstanceInitFunc) captive_main_window_instance_init, NULL };
	GType captive_main_window_type_id;
	captive_main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "CaptiveMainWindow", &g_define_type_info, 0);
	CaptiveMainWindow_private_offset = g_type_add_instance_private (captive_main_window_type_id, sizeof (CaptiveMainWindowPrivate));
	return captive_main_window_type_id;
}

GType
captive_main_window_get_type (void)
{
	static volatile gsize captive_main_window_type_id__once = 0;
	if (g_once_init_enter (&captive_main_window_type_id__once)) {
		GType captive_main_window_type_id;
		captive_main_window_type_id = captive_main_window_get_type_once ();
		g_once_init_leave (&captive_main_window_type_id__once, captive_main_window_type_id);
	}
	return captive_main_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

