// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by github.com/bufbuild/protocompile/internal/enum enums.yaml. DO NOT EDIT.

package ast

import (
	"fmt"
	"iter"
)

// DeclKind is a kind of declaration. There is one value of DeclKind for each
// Decl* type in this package.
type DeclKind int8

const (
	DeclKindInvalid DeclKind = iota
	DeclKindEmpty
	DeclKindSyntax
	DeclKindPackage
	DeclKindImport
	DeclKindDef
	DeclKindBody
	DeclKindRange
)

// String implements [fmt.Stringer].
func (v DeclKind) String() string {
	if int(v) < 0 || int(v) > len(_table_DeclKind_String) {
		return fmt.Sprintf("DeclKind(%v)", int(v))
	}
	return _table_DeclKind_String[v]
}

// GoString implements [fmt.GoStringer].
func (v DeclKind) GoString() string {
	if int(v) < 0 || int(v) > len(_table_DeclKind_GoString) {
		return fmt.Sprintf("ast.DeclKind(%v)", int(v))
	}
	return _table_DeclKind_GoString[v]
}

// DefKind is the kind of definition a [DeclDef] contains.
//
// See [DeclDef.Classify].
type DefKind int8

const (
	DefKindInvalid DefKind = iota
	DefKindMessage
	DefKindEnum
	DefKindService
	DefKindExtend
	DefKindField
	DefKindOneof
	DefKindGroup
	DefKindEnumValue
	DefKindMethod
	DefKindOption
)

// String implements [fmt.Stringer].
func (v DefKind) String() string {
	if int(v) < 0 || int(v) > len(_table_DefKind_String) {
		return fmt.Sprintf("DefKind(%v)", int(v))
	}
	return _table_DefKind_String[v]
}

// GoString implements [fmt.GoStringer].
func (v DefKind) GoString() string {
	if int(v) < 0 || int(v) > len(_table_DefKind_GoString) {
		return fmt.Sprintf("ast.DefKind(%v)", int(v))
	}
	return _table_DefKind_GoString[v]
}

// ExprKind is a kind of expression. There is one value of ExprKind for each
// Expr* type in this package.
type ExprKind int8

const (
	ExprKindInvalid ExprKind = iota
	ExprKindError
	ExprKindLiteral
	ExprKindPrefixed
	ExprKindPath
	ExprKindRange
	ExprKindArray
	ExprKindDict
	ExprKindField
)

// String implements [fmt.Stringer].
func (v ExprKind) String() string {
	if int(v) < 0 || int(v) > len(_table_ExprKind_String) {
		return fmt.Sprintf("ExprKind(%v)", int(v))
	}
	return _table_ExprKind_String[v]
}

// GoString implements [fmt.GoStringer].
func (v ExprKind) GoString() string {
	if int(v) < 0 || int(v) > len(_table_ExprKind_GoString) {
		return fmt.Sprintf("ast.ExprKind(%v)", int(v))
	}
	return _table_ExprKind_GoString[v]
}

// TypeKind is a kind of type. There is one value of TypeKind for each
// Type* type in this package.
type TypeKind int8

const (
	TypeKindInvalid TypeKind = iota
	TypeKindError
	TypeKindPath
	TypeKindPrefixed
	TypeKindGeneric
)

// String implements [fmt.Stringer].
func (v TypeKind) String() string {
	if int(v) < 0 || int(v) > len(_table_TypeKind_String) {
		return fmt.Sprintf("TypeKind(%v)", int(v))
	}
	return _table_TypeKind_String[v]
}

// GoString implements [fmt.GoStringer].
func (v TypeKind) GoString() string {
	if int(v) < 0 || int(v) > len(_table_TypeKind_GoString) {
		return fmt.Sprintf("ast.TypeKind(%v)", int(v))
	}
	return _table_TypeKind_GoString[v]
}

var _table_DeclKind_String = [...]string{
	DeclKindInvalid: "DeclKindInvalid",
	DeclKindEmpty:   "DeclKindEmpty",
	DeclKindSyntax:  "DeclKindSyntax",
	DeclKindPackage: "DeclKindPackage",
	DeclKindImport:  "DeclKindImport",
	DeclKindDef:     "DeclKindDef",
	DeclKindBody:    "DeclKindBody",
	DeclKindRange:   "DeclKindRange",
}

var _table_DeclKind_GoString = [...]string{
	DeclKindInvalid: "DeclKindInvalid",
	DeclKindEmpty:   "DeclKindEmpty",
	DeclKindSyntax:  "DeclKindSyntax",
	DeclKindPackage: "DeclKindPackage",
	DeclKindImport:  "DeclKindImport",
	DeclKindDef:     "DeclKindDef",
	DeclKindBody:    "DeclKindBody",
	DeclKindRange:   "DeclKindRange",
}

var _table_DefKind_String = [...]string{
	DefKindInvalid:   "DefKindInvalid",
	DefKindMessage:   "DefKindMessage",
	DefKindEnum:      "DefKindEnum",
	DefKindService:   "DefKindService",
	DefKindExtend:    "DefKindExtend",
	DefKindField:     "DefKindField",
	DefKindOneof:     "DefKindOneof",
	DefKindGroup:     "DefKindGroup",
	DefKindEnumValue: "DefKindEnumValue",
	DefKindMethod:    "DefKindMethod",
	DefKindOption:    "DefKindOption",
}

var _table_DefKind_GoString = [...]string{
	DefKindInvalid:   "DefKindInvalid",
	DefKindMessage:   "DefKindMessage",
	DefKindEnum:      "DefKindEnum",
	DefKindService:   "DefKindService",
	DefKindExtend:    "DefKindExtend",
	DefKindField:     "DefKindField",
	DefKindOneof:     "DefKindOneof",
	DefKindGroup:     "DefKindGroup",
	DefKindEnumValue: "DefKindEnumValue",
	DefKindMethod:    "DefKindMethod",
	DefKindOption:    "DefKindOption",
}

var _table_ExprKind_String = [...]string{
	ExprKindInvalid:  "ExprKindInvalid",
	ExprKindError:    "ExprKindError",
	ExprKindLiteral:  "ExprKindLiteral",
	ExprKindPrefixed: "ExprKindPrefixed",
	ExprKindPath:     "ExprKindPath",
	ExprKindRange:    "ExprKindRange",
	ExprKindArray:    "ExprKindArray",
	ExprKindDict:     "ExprKindDict",
	ExprKindField:    "ExprKindField",
}

var _table_ExprKind_GoString = [...]string{
	ExprKindInvalid:  "ExprKindInvalid",
	ExprKindError:    "ExprKindError",
	ExprKindLiteral:  "ExprKindLiteral",
	ExprKindPrefixed: "ExprKindPrefixed",
	ExprKindPath:     "ExprKindPath",
	ExprKindRange:    "ExprKindRange",
	ExprKindArray:    "ExprKindArray",
	ExprKindDict:     "ExprKindDict",
	ExprKindField:    "ExprKindField",
}

var _table_TypeKind_String = [...]string{
	TypeKindInvalid:  "TypeKindInvalid",
	TypeKindError:    "TypeKindError",
	TypeKindPath:     "TypeKindPath",
	TypeKindPrefixed: "TypeKindPrefixed",
	TypeKindGeneric:  "TypeKindGeneric",
}

var _table_TypeKind_GoString = [...]string{
	TypeKindInvalid:  "TypeKindInvalid",
	TypeKindError:    "TypeKindError",
	TypeKindPath:     "TypeKindPath",
	TypeKindPrefixed: "TypeKindPrefixed",
	TypeKindGeneric:  "TypeKindGeneric",
}
var _ iter.Seq[int] // Mark iter as used.
