/* baobab-progress-cell.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from baobab-progress-cell.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright © 2024 Adrien Plazas <aplazas@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "baobab.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <adwaita.h>
#include <gtk/gtk.h>
#include <graphene-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BAOBAB_PROGRESS_CELL_0_PROPERTY,
	BAOBAB_PROGRESS_CELL_FRACTION_PROPERTY,
	BAOBAB_PROGRESS_CELL_NUM_PROPERTIES
};
static GParamSpec* baobab_progress_cell_properties[BAOBAB_PROGRESS_CELL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BaobabProgressCellPrivate {
	gdouble _fraction;
	AdwBin* trough;
	AdwBin* progress;
	GtkLabel* label;
	GtkLabel* alt_label;
};

static gint BaobabProgressCell_private_offset;
static gpointer baobab_progress_cell_parent_class = NULL;

static void baobab_progress_cell_real_size_allocate (GtkWidget* base,
                                              gint width,
                                              gint height,
                                              gint baseline);
static void baobab_progress_cell_real_snapshot (GtkWidget* base,
                                         GtkSnapshot* snapshot);
static void baobab_progress_cell_real_measure (GtkWidget* base,
                                        GtkOrientation orientation,
                                        gint for_size,
                                        gint* minimum,
                                        gint* natural,
                                        gint* minimum_baseline,
                                        gint* natural_baseline);
static void baobab_progress_cell_update_text (BaobabProgressCell* self);
static GObject * baobab_progress_cell_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void baobab_progress_cell_finalize (GObject * obj);
static GType baobab_progress_cell_get_type_once (void);
static void _vala_baobab_progress_cell_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_baobab_progress_cell_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
baobab_progress_cell_get_instance_private (BaobabProgressCell* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabProgressCell_private_offset);
}

static void
baobab_progress_cell_real_size_allocate (GtkWidget* base,
                                         gint width,
                                         gint height,
                                         gint baseline)
{
	BaobabProgressCell * self;
	GtkAllocation all = {0};
	GtkAllocation _tmp0_ = {0};
	GtkLabel* _tmp1_;
	GtkAllocation _tmp2_;
	GtkLabel* _tmp3_;
	GtkAllocation _tmp4_;
	AdwBin* _tmp5_;
	GtkAllocation _tmp6_;
	AdwBin* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	self = (BaobabProgressCell*) base;
	_tmp0_.x = 0;
	_tmp0_.y = 0;
	_tmp0_.width = width;
	_tmp0_.height = height;
	all = _tmp0_;
	_tmp1_ = self->priv->label;
	_tmp2_ = all;
	gtk_widget_size_allocate ((GtkWidget*) _tmp1_, &_tmp2_, baseline);
	_tmp3_ = self->priv->alt_label;
	_tmp4_ = all;
	gtk_widget_size_allocate ((GtkWidget*) _tmp3_, &_tmp4_, baseline);
	_tmp5_ = self->priv->trough;
	_tmp6_ = all;
	gtk_widget_size_allocate ((GtkWidget*) _tmp5_, &_tmp6_, baseline);
	_tmp7_ = self->priv->progress;
	_tmp8_ = gtk_widget_get_visible ((GtkWidget*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		gdouble _tmp10_;
		gdouble _tmp11_;
		AdwBin* _tmp12_;
		GtkAllocation _tmp13_;
		_tmp10_ = baobab_progress_cell_get_fraction (self);
		_tmp11_ = _tmp10_;
		all.width = MAX (1, (gint) (width * _tmp11_));
		_tmp12_ = self->priv->progress;
		_tmp13_ = all;
		gtk_widget_size_allocate ((GtkWidget*) _tmp12_, &_tmp13_, baseline);
	}
}

static void
baobab_progress_cell_real_snapshot (GtkWidget* base,
                                    GtkSnapshot* snapshot)
{
	BaobabProgressCell * self;
	AdwBin* _tmp0_;
	GtkLabel* _tmp1_;
	AdwBin* _tmp2_;
	graphene_rect_t rect = {0};
	graphene_rect_t _tmp3_ = {0};
	gdouble _tmp4_;
	gdouble _tmp5_;
	graphene_rect_t _tmp6_;
	GtkLabel* _tmp7_;
	self = (BaobabProgressCell*) base;
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = self->priv->trough;
	gtk_widget_snapshot_child ((GtkWidget*) self, (GtkWidget*) _tmp0_, snapshot);
	_tmp1_ = self->priv->label;
	gtk_widget_snapshot_child ((GtkWidget*) self, (GtkWidget*) _tmp1_, snapshot);
	_tmp2_ = self->priv->progress;
	gtk_widget_snapshot_child ((GtkWidget*) self, (GtkWidget*) _tmp2_, snapshot);
	rect = _tmp3_;
	_tmp4_ = baobab_progress_cell_get_fraction (self);
	_tmp5_ = _tmp4_;
	graphene_rect_init (&rect, (gfloat) 0, (gfloat) 0, (gfloat) (gtk_widget_get_width ((GtkWidget*) self) * _tmp5_), (gfloat) gtk_widget_get_height ((GtkWidget*) self));
	_tmp6_ = rect;
	gtk_snapshot_push_clip (snapshot, &_tmp6_);
	_tmp7_ = self->priv->alt_label;
	gtk_widget_snapshot_child ((GtkWidget*) self, (GtkWidget*) _tmp7_, snapshot);
	gtk_snapshot_pop (snapshot);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
baobab_progress_cell_real_measure (GtkWidget* base,
                                   GtkOrientation orientation,
                                   gint for_size,
                                   gint* minimum,
                                   gint* natural,
                                   gint* minimum_baseline,
                                   gint* natural_baseline)
{
	BaobabProgressCell * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint _vala_minimum_baseline = 0;
	gint _vala_natural_baseline = 0;
	GtkWidget** children = NULL;
	AdwBin* _tmp0_;
	GtkWidget* _tmp1_;
	AdwBin* _tmp2_;
	GtkWidget* _tmp3_;
	GtkLabel* _tmp4_;
	GtkWidget* _tmp5_;
	GtkLabel* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget** _tmp8_;
	gint children_length1;
	gint _children_size_;
	GtkWidget** _tmp9_;
	gint _tmp9__length1;
	self = (BaobabProgressCell*) base;
	_tmp0_ = self->priv->trough;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	_tmp2_ = self->priv->progress;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
	_tmp4_ = self->priv->label;
	_tmp5_ = _g_object_ref0 ((GtkWidget*) _tmp4_);
	_tmp6_ = self->priv->alt_label;
	_tmp7_ = _g_object_ref0 ((GtkWidget*) _tmp6_);
	_tmp8_ = g_new0 (GtkWidget*, 4 + 1);
	_tmp8_[0] = _tmp1_;
	_tmp8_[1] = _tmp3_;
	_tmp8_[2] = _tmp5_;
	_tmp8_[3] = _tmp7_;
	children = _tmp8_;
	children_length1 = 4;
	_children_size_ = children_length1;
	_vala_minimum = 0;
	_vala_natural = 0;
	_vala_minimum_baseline = -1;
	_vala_natural_baseline = -1;
	_tmp9_ = children;
	_tmp9__length1 = children_length1;
	{
		GtkWidget** child_collection = NULL;
		gint child_collection_length1 = 0;
		gint _child_collection_size_ = 0;
		gint child_it = 0;
		child_collection = _tmp9_;
		child_collection_length1 = _tmp9__length1;
		for (child_it = 0; child_it < child_collection_length1; child_it = child_it + 1) {
			GtkWidget* _tmp10_;
			GtkWidget* child = NULL;
			_tmp10_ = _g_object_ref0 (child_collection[child_it]);
			child = _tmp10_;
			{
				gint child_min = 0;
				gint child_nat = 0;
				GtkWidget* _tmp11_;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				child_min = 0;
				child_nat = 0;
				_tmp11_ = child;
				gtk_widget_measure (_tmp11_, orientation, for_size, &_tmp12_, &_tmp13_, NULL, NULL);
				child_min = _tmp12_;
				child_nat = _tmp13_;
				if (child_min > _vala_minimum) {
					_vala_minimum = child_min;
				}
				if (child_nat > _vala_natural) {
					_vala_natural = child_nat;
				}
				_g_object_unref0 (child);
			}
		}
	}
	children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_object_unref), NULL);
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
	if (minimum_baseline) {
		*minimum_baseline = _vala_minimum_baseline;
	}
	if (natural_baseline) {
		*natural_baseline = _vala_natural_baseline;
	}
}

static void
baobab_progress_cell_update_text (BaobabProgressCell* self)
{
	gchar* text = NULL;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gchar* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	AdwBin* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_progress_cell_get_fraction (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%6.2lf%%", _tmp1_ * 100.0);
	text = _tmp2_;
	_tmp3_ = self->priv->label;
	gtk_label_set_text (_tmp3_, text);
	_tmp4_ = self->priv->alt_label;
	gtk_label_set_text (_tmp4_, text);
	_tmp5_ = self->priv->progress;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, self->priv->_fraction > 0.0);
	_tmp6_ = baobab_progress_cell_get_fraction (self);
	_tmp7_ = _tmp6_;
	gtk_accessible_update_property ((GtkAccessible*) self, GTK_ACCESSIBLE_PROPERTY_VALUE_MAX, 1.0, GTK_ACCESSIBLE_PROPERTY_VALUE_MIN, 0.0, GTK_ACCESSIBLE_PROPERTY_VALUE_NOW, _tmp7_, GTK_ACCESSIBLE_PROPERTY_VALUE_TEXT, text, -1);
	_g_free0 (text);
}

BaobabProgressCell*
baobab_progress_cell_construct (GType object_type)
{
	BaobabProgressCell * self = NULL;
	self = (BaobabProgressCell*) g_object_new (object_type, NULL);
	return self;
}

BaobabProgressCell*
baobab_progress_cell_new (void)
{
	return baobab_progress_cell_construct (BAOBAB_TYPE_PROGRESS_CELL);
}

gdouble
baobab_progress_cell_get_fraction (BaobabProgressCell* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_fraction;
	return result;
}

void
baobab_progress_cell_set_fraction (BaobabProgressCell* self,
                                   gdouble value)
{
	gdouble clamped_value = 0.0;
	g_return_if_fail (self != NULL);
	clamped_value = CLAMP (value, 0.0, 1.0);
	if (self->priv->_fraction == clamped_value) {
		return;
	}
	self->priv->_fraction = clamped_value;
	baobab_progress_cell_update_text (self);
	g_object_notify ((GObject*) self, "fraction");
	gtk_widget_queue_allocate ((GtkWidget*) self);
}

static GObject *
baobab_progress_cell_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BaobabProgressCell * self;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GtkLabel* _tmp2_;
	GObject* _tmp3_;
	GObject* _tmp4_;
	GtkLabel* _tmp5_;
	GObject* _tmp6_;
	GObject* _tmp7_;
	AdwBin* _tmp8_;
	GObject* _tmp9_;
	GObject* _tmp10_;
	AdwBin* _tmp11_;
	GtkLabel* _tmp12_;
	AdwBin* _tmp13_;
	GtkLabel* _tmp14_;
	AdwBin* _tmp15_;
	GtkLabel* _tmp16_;
	parent_class = G_OBJECT_CLASS (baobab_progress_cell_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_PROGRESS_CELL, BaobabProgressCell);
	gtk_widget_set_overflow ((GtkWidget*) self, GTK_OVERFLOW_HIDDEN);
	_tmp0_ = g_object_new (gtk_label_get_type (), "xalign", (gfloat) 1.0, "valign", GTK_ALIGN_CENTER, "width-chars", 7, NULL, NULL);
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp1_) : NULL;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_tmp1_);
	}
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp2_;
	_tmp3_ = g_object_new (gtk_label_get_type (), "xalign", (gfloat) 1.0, "valign", GTK_ALIGN_CENTER, "width-chars", 7, NULL, NULL);
	_tmp4_ = G_IS_INITIALLY_UNOWNED (_tmp3_) ? g_object_ref_sink (_tmp3_) : _tmp3_;
	_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp4_) : NULL;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (_tmp4_);
	}
	_g_object_unref0 (self->priv->alt_label);
	self->priv->alt_label = _tmp5_;
	_tmp6_ = g_object_new (adw_bin_get_type (), "css-name", "trough", NULL, NULL);
	_tmp7_ = G_IS_INITIALLY_UNOWNED (_tmp6_) ? g_object_ref_sink (_tmp6_) : _tmp6_;
	_tmp8_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, adw_bin_get_type ()) ? ((AdwBin*) _tmp7_) : NULL;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (_tmp7_);
	}
	_g_object_unref0 (self->priv->trough);
	self->priv->trough = _tmp8_;
	_tmp9_ = g_object_new (adw_bin_get_type (), "css-name", "progress", "visible", FALSE, NULL, NULL);
	_tmp10_ = G_IS_INITIALLY_UNOWNED (_tmp9_) ? g_object_ref_sink (_tmp9_) : _tmp9_;
	_tmp11_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, adw_bin_get_type ()) ? ((AdwBin*) _tmp10_) : NULL;
	if (_tmp11_ == NULL) {
		_g_object_unref0 (_tmp10_);
	}
	_g_object_unref0 (self->priv->progress);
	self->priv->progress = _tmp11_;
	_tmp12_ = self->priv->alt_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp12_, "in-progress");
	_tmp13_ = self->priv->trough;
	gtk_widget_set_parent ((GtkWidget*) _tmp13_, (GtkWidget*) self);
	_tmp14_ = self->priv->label;
	gtk_widget_set_parent ((GtkWidget*) _tmp14_, (GtkWidget*) self);
	_tmp15_ = self->priv->progress;
	gtk_widget_set_parent ((GtkWidget*) _tmp15_, (GtkWidget*) self);
	_tmp16_ = self->priv->alt_label;
	gtk_widget_set_parent ((GtkWidget*) _tmp16_, (GtkWidget*) self);
	baobab_progress_cell_update_text (self);
	return obj;
}

static void
baobab_progress_cell_class_init (BaobabProgressCellClass * klass,
                                 gpointer klass_data)
{
	baobab_progress_cell_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabProgressCell_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) baobab_progress_cell_real_size_allocate;
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) baobab_progress_cell_real_snapshot;
	((GtkWidgetClass *) klass)->measure = (void (*) (GtkWidget*, GtkOrientation, gint, gint*, gint*, gint*, gint*)) baobab_progress_cell_real_measure;
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_progress_cell_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_progress_cell_set_property;
	G_OBJECT_CLASS (klass)->constructor = baobab_progress_cell_constructor;
	G_OBJECT_CLASS (klass)->finalize = baobab_progress_cell_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_PROGRESS_CELL_FRACTION_PROPERTY, baobab_progress_cell_properties[BAOBAB_PROGRESS_CELL_FRACTION_PROPERTY] = g_param_spec_double ("fraction", "fraction", "fraction", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "progresscell");
	gtk_widget_class_set_accessible_role (GTK_WIDGET_CLASS (klass), GTK_ACCESSIBLE_ROLE_PROGRESS_BAR);
}

static void
baobab_progress_cell_instance_init (BaobabProgressCell * self,
                                    gpointer klass)
{
	self->priv = baobab_progress_cell_get_instance_private (self);
}

static void
baobab_progress_cell_finalize (GObject * obj)
{
	BaobabProgressCell * self;
	AdwBin* _tmp0_;
	GtkLabel* _tmp1_;
	AdwBin* _tmp2_;
	GtkLabel* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_PROGRESS_CELL, BaobabProgressCell);
	_tmp0_ = self->priv->trough;
	gtk_widget_unparent ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->label;
	gtk_widget_unparent ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->progress;
	gtk_widget_unparent ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->alt_label;
	gtk_widget_unparent ((GtkWidget*) _tmp3_);
	_g_object_unref0 (self->priv->trough);
	_g_object_unref0 (self->priv->progress);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->alt_label);
	G_OBJECT_CLASS (baobab_progress_cell_parent_class)->finalize (obj);
}

static GType
baobab_progress_cell_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabProgressCellClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_progress_cell_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabProgressCell), 0, (GInstanceInitFunc) baobab_progress_cell_instance_init, NULL };
	GType baobab_progress_cell_type_id;
	baobab_progress_cell_type_id = g_type_register_static (gtk_widget_get_type (), "BaobabProgressCell", &g_define_type_info, 0);
	BaobabProgressCell_private_offset = g_type_add_instance_private (baobab_progress_cell_type_id, sizeof (BaobabProgressCellPrivate));
	return baobab_progress_cell_type_id;
}

GType
baobab_progress_cell_get_type (void)
{
	static volatile gsize baobab_progress_cell_type_id__once = 0;
	if (g_once_init_enter (&baobab_progress_cell_type_id__once)) {
		GType baobab_progress_cell_type_id;
		baobab_progress_cell_type_id = baobab_progress_cell_get_type_once ();
		g_once_init_leave (&baobab_progress_cell_type_id__once, baobab_progress_cell_type_id);
	}
	return baobab_progress_cell_type_id__once;
}

static void
_vala_baobab_progress_cell_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	BaobabProgressCell * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_PROGRESS_CELL, BaobabProgressCell);
	switch (property_id) {
		case BAOBAB_PROGRESS_CELL_FRACTION_PROPERTY:
		g_value_set_double (value, baobab_progress_cell_get_fraction (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_baobab_progress_cell_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	BaobabProgressCell * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_PROGRESS_CELL, BaobabProgressCell);
	switch (property_id) {
		case BAOBAB_PROGRESS_CELL_FRACTION_PROPERTY:
		baobab_progress_cell_set_fraction (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

