/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch.core.search.SearchRequestBody;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ScriptSource
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<ScriptSource> _DESERIALIZER = JsonpDeserializer.lazy(ScriptSource::buildScriptSourceDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private ScriptSource(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private ScriptSource(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static ScriptSource of(Function<Builder, ObjectBuilder<ScriptSource>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isScriptTemplate() {
        return this._kind == Kind.ScriptTemplate;
    }

    public SearchRequestBody scriptTemplate() {
        return (SearchRequestBody)TaggedUnionUtils.get(this, Kind.ScriptTemplate);
    }

    public boolean isScriptString() {
        return this._kind == Kind.ScriptString;
    }

    public String scriptString() {
        return (String)TaggedUnionUtils.get(this, Kind.ScriptString);
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case ScriptString: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    private static JsonpDeserializer<ScriptSource> buildScriptSourceDeserializer() {
        return new UnionDeserializer.Builder(ScriptSource::new, false).addMember((Object)Kind.ScriptTemplate, SearchRequestBody._DESERIALIZER).addMember((Object)Kind.ScriptString, JsonpDeserializer.stringDeserializer()).build();
    }

    public static enum Kind {
        ScriptTemplate,
        ScriptString;

    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ScriptSource> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<ScriptSource> scriptTemplate(SearchRequestBody v) {
            this._kind = Kind.ScriptTemplate;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ScriptSource> scriptTemplate(Function<SearchRequestBody.Builder, ObjectBuilder<SearchRequestBody>> fn) {
            return this.scriptTemplate(fn.apply(new SearchRequestBody.Builder()).build());
        }

        public ObjectBuilder<ScriptSource> scriptString(String v) {
            this._kind = Kind.ScriptString;
            this._value = v;
            return this;
        }

        @Override
        public ScriptSource build() {
            this._checkSingleUse();
            return new ScriptSource(this);
        }
    }
}

