/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.index.seqno.RetentionLease;
import org.elasticsearch.index.seqno.RetentionLeases;

final class SoftDeletesPolicy {
    private final LongSupplier globalCheckpointSupplier;
    private long localCheckpointOfSafeCommit;
    private int retentionLockCount;
    private long retentionOperations;
    private long minRetainedSeqNo;
    private final Supplier<RetentionLeases> retentionLeasesSupplier;

    SoftDeletesPolicy(LongSupplier globalCheckpointSupplier, long minRetainedSeqNo, long retentionOperations, Supplier<RetentionLeases> retentionLeasesSupplier) {
        this.globalCheckpointSupplier = globalCheckpointSupplier;
        this.retentionOperations = retentionOperations;
        this.minRetainedSeqNo = minRetainedSeqNo;
        this.retentionLeasesSupplier = Objects.requireNonNull(retentionLeasesSupplier);
        this.localCheckpointOfSafeCommit = -1L;
        this.retentionLockCount = 0;
    }

    synchronized void setRetentionOperations(long retentionOperations) {
        this.retentionOperations = retentionOperations;
    }

    synchronized void setLocalCheckpointOfSafeCommit(long newCheckpoint) {
        if (newCheckpoint < this.localCheckpointOfSafeCommit) {
            throw new IllegalArgumentException("Local checkpoint can't go backwards; new checkpoint [" + newCheckpoint + "],current checkpoint [" + this.localCheckpointOfSafeCommit + "]");
        }
        this.localCheckpointOfSafeCommit = newCheckpoint;
    }

    synchronized Releasable acquireRetentionLock() {
        assert (this.retentionLockCount >= 0) : "Invalid number of retention locks [" + this.retentionLockCount + "]";
        ++this.retentionLockCount;
        AtomicBoolean released = new AtomicBoolean();
        return () -> {
            if (released.compareAndSet(false, true)) {
                this.releaseRetentionLock();
            }
        };
    }

    private synchronized void releaseRetentionLock() {
        assert (this.retentionLockCount > 0) : "Invalid number of retention locks [" + this.retentionLockCount + "]";
        --this.retentionLockCount;
    }

    synchronized long getMinRetainedSeqNo() {
        RetentionLeases retentionLeases = this.retentionLeasesSupplier.get();
        if (this.retentionLockCount == 0) {
            long minimumRetainingSequenceNumber = retentionLeases.leases().stream().mapToLong(RetentionLease::retainingSequenceNumber).min().orElse(Long.MAX_VALUE);
            long minSeqNoForQueryingChanges = Math.min(1L + this.globalCheckpointSupplier.getAsLong() - this.retentionOperations, minimumRetainingSequenceNumber);
            long minSeqNoToRetain = Math.min(minSeqNoForQueryingChanges, 1L + this.localCheckpointOfSafeCommit);
            this.minRetainedSeqNo = Math.max(this.minRetainedSeqNo, minSeqNoToRetain);
        }
        return this.minRetainedSeqNo;
    }

    Query getRetentionQuery() {
        return LongPoint.newRangeQuery((String)"_seq_no", (long)this.getMinRetainedSeqNo(), (long)Long.MAX_VALUE);
    }
}

