/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import org.slf4j.Logger;

public class ExitUtils {
    private static boolean isSystemExitDisabled = false;

    public static void terminate(int status, String message, Throwable throwable, Logger logger) throws ExitException {
        if (logger != null) {
            String s2 = "Terminating with exit status " + status + ": " + message;
            if (status == 0) {
                logger.info(s2, throwable);
            } else {
                logger.error(s2, throwable);
            }
        }
        if (!isSystemExitDisabled) {
            System.exit(status);
        }
        throw new ExitException(status, message, throwable);
    }

    public static void disableSystemExit() {
        isSystemExitDisabled = true;
    }

    public static class ExitException
    extends RuntimeException {
        private final int status;

        ExitException(int status, String message, Throwable throwable) {
            super(message, throwable);
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

