/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.future;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;

public class CompletableFutureExtension {
    public static <T> CompletableFuture<T> orTimeout(CompletableFuture<T> future, long timeout, TimeUnit unit) {
        if (future.isDone()) {
            return future;
        }
        return future.whenComplete((BiConsumer)new Canceller(Delayer.delay(new Timeout(future), timeout, unit)));
    }

    static final class Delayer {
        static final ScheduledThreadPoolExecutor delayer = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());

        Delayer() {
        }

        static ScheduledFuture<?> delay(Runnable command, long delay, TimeUnit unit) {
            return delayer.schedule(command, delay, unit);
        }

        static {
            delayer.setRemoveOnCancelPolicy(true);
        }

        static final class DaemonThreadFactory
        implements ThreadFactory {
            DaemonThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t2 = new Thread(r);
                t2.setDaemon(true);
                t2.setName("CompletableFutureExtensionDelayScheduler");
                return t2;
            }
        }
    }

    static final class Canceller
    implements BiConsumer<Object, Throwable> {
        final Future<?> future;

        Canceller(Future<?> future) {
            this.future = future;
        }

        @Override
        public void accept(Object ignore, Throwable ex) {
            if (null == ex && null != this.future && !this.future.isDone()) {
                this.future.cancel(false);
            }
        }
    }

    static final class Timeout
    implements Runnable {
        final CompletableFuture<?> future;

        Timeout(CompletableFuture<?> future) {
            this.future = future;
        }

        @Override
        public void run() {
            if (null != this.future && !this.future.isDone()) {
                this.future.completeExceptionally(new TimeoutException());
            }
        }
    }
}

