/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.uniffle.client.common.ShuffleServerPushCost;
import org.apache.uniffle.client.request.RssReportShuffleWriteMetricRequest;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.shaded.org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleServerPushCostTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShuffleServerPushCostTracker.class);
    private Map<String, ShuffleServerPushCost> tracking = new ConcurrentHashMap<String, ShuffleServerPushCost>();

    public void merge(ShuffleServerPushCostTracker tracker) {
        if (tracker == null) {
            return;
        }
        for (Map.Entry<String, ShuffleServerPushCost> entry : tracker.tracking.entrySet()) {
            String id = entry.getKey();
            ShuffleServerPushCost cost = entry.getValue();
            this.tracking.computeIfAbsent(id, key -> new ShuffleServerPushCost((String)key)).merge(cost);
        }
    }

    public void recordRequireBufferFailure(String id) {
        ShuffleServerPushCost cost = this.tracking.computeIfAbsent(id, key -> new ShuffleServerPushCost((String)key));
        cost.incRequiredBufferFailure(1L);
    }

    public void recordPushFailure(String id, StatusCode failureStatusCode) {
        ShuffleServerPushCost cost = this.tracking.computeIfAbsent(id, key -> new ShuffleServerPushCost((String)key));
        cost.incSentFailure(1L, failureStatusCode.name());
    }

    public void record(String id, long sentBytes, long pushDuration) {
        ShuffleServerPushCost cost = this.tracking.computeIfAbsent(id, key -> new ShuffleServerPushCost((String)key));
        cost.incDurationMs(pushDuration);
        cost.incSentBytes(sentBytes);
    }

    public void statistics() {
        ArrayList<ShuffleServerPushCost> shuffleServerPushCosts = new ArrayList<ShuffleServerPushCost>(this.tracking.values());
        if (CollectionUtils.isEmpty(shuffleServerPushCosts)) {
            return;
        }
        Collections.sort(shuffleServerPushCosts, Comparator.comparingLong(ShuffleServerPushCost::speed));
        LOGGER.info("Statistics of shuffle server push speed: \n-------------------------------------------\nMinimum: {} \nP25: {} \nMedian: {} \nP75: {} \nMaximum: {}\n-------------------------------------------", new Object[]{shuffleServerPushCosts.isEmpty() ? Integer.valueOf(0) : shuffleServerPushCosts.get(0), this.getPercentile(shuffleServerPushCosts, 25.0), this.getPercentile(shuffleServerPushCosts, 50.0), this.getPercentile(shuffleServerPushCosts, 75.0), shuffleServerPushCosts.isEmpty() ? Integer.valueOf(0) : shuffleServerPushCosts.get(shuffleServerPushCosts.size() - 1)});
    }

    private ShuffleServerPushCost getPercentile(List<ShuffleServerPushCost> costs, double percentile) {
        if (costs.isEmpty()) {
            return null;
        }
        int index = (int)Math.ceil(percentile / 100.0 * (double)costs.size()) - 1;
        return costs.get(Math.min(Math.max(index, 0), costs.size() - 1));
    }

    public Map<String, RssReportShuffleWriteMetricRequest.TaskShuffleWriteMetric> toMetric() {
        return this.tracking.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> {
            ShuffleServerPushCost cost = (ShuffleServerPushCost)x.getValue();
            return new RssReportShuffleWriteMetricRequest.TaskShuffleWriteMetric(cost.sentDurationMillis(), cost.sentBytes(), cost.requiredBufferFailureNumber(), cost.pushFailureNumber(), cost.getLastPushFailureReason());
        }));
    }
}

