/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.handle;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.spark.shuffle.handle.ShuffleHandleInfoBase;
import org.apache.spark.shuffle.handle.split.PartitionSplitInfo;
import org.apache.uniffle.client.PartitionDataReplicaRequirementTracking;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.exception.RssException;

public class SimpleShuffleHandleInfo
extends ShuffleHandleInfoBase
implements Serializable {
    private static final long serialVersionUID = 0L;
    private Map<Integer, List<ShuffleServerInfo>> partitionToServers;

    public SimpleShuffleHandleInfo(int shuffleId, Map<Integer, List<ShuffleServerInfo>> partitionToServers, RemoteStorageInfo storageInfo) {
        super(shuffleId, storageInfo);
        this.partitionToServers = partitionToServers;
    }

    @Override
    public Set<ShuffleServerInfo> getServers() {
        return this.partitionToServers.values().stream().flatMap(x -> x.stream()).collect(Collectors.toSet());
    }

    @Override
    public Map<Integer, List<ShuffleServerInfo>> getAvailablePartitionServersForWriter(Map<Integer, List<ShuffleServerInfo>> exclusiveServers) {
        if (exclusiveServers != null && !exclusiveServers.isEmpty()) {
            throw new RssException("Exclusive servers are not supported when getting available partition servers for shuffle writer");
        }
        return this.partitionToServers;
    }

    @Override
    public Map<Integer, List<ShuffleServerInfo>> getAllPartitionServersForReader() {
        return this.partitionToServers;
    }

    @Override
    public PartitionDataReplicaRequirementTracking createPartitionReplicaTracking() {
        return new PartitionDataReplicaRequirementTracking(this.partitionToServers, this.shuffleId);
    }

    @Override
    public RemoteStorageInfo getRemoteStorage() {
        return this.remoteStorage;
    }

    @Override
    public PartitionSplitInfo getPartitionSplitInfo(int partitionId) {
        return null;
    }

    @Override
    public int getShuffleId() {
        return this.shuffleId;
    }
}

