/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer.writable;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.uniffle.common.serializer.SerOutputStream;
import org.apache.uniffle.common.serializer.SerializationStream;
import org.apache.uniffle.common.serializer.writable.WritableSerializerInstance;

public class WritableSerializationStream<K extends Writable, V extends Writable>
extends SerializationStream {
    private SerOutputStream output;
    private DataOutputStream dataOut;
    private long totalBytesWritten = 0L;
    DataOutputBuffer buffer = new DataOutputBuffer();
    DataOutputBuffer sizebuffer = new DataOutputBuffer();

    public WritableSerializationStream(WritableSerializerInstance instance, SerOutputStream out) {
        this.output = out;
    }

    @Override
    public void init() {
        this.dataOut = new DataOutputStream(this.output);
    }

    @Override
    public void writeRecord(Object key, Object value) throws IOException {
        this.buffer.reset();
        ((Writable)key).write((DataOutput)this.buffer);
        int keyLength = this.buffer.getLength();
        ((Writable)value).write((DataOutput)this.buffer);
        int valueLength = this.buffer.getLength() - keyLength;
        int toWriteLength = WritableUtils.getVIntSize((long)keyLength) + WritableUtils.getVIntSize((long)valueLength) + keyLength + valueLength;
        this.output.preAllocate(toWriteLength);
        this.sizebuffer.reset();
        WritableUtils.writeVInt((DataOutput)this.sizebuffer, (int)keyLength);
        WritableUtils.writeVInt((DataOutput)this.sizebuffer, (int)valueLength);
        this.sizebuffer.writeTo((OutputStream)this.dataOut);
        this.buffer.writeTo((OutputStream)this.dataOut);
        this.totalBytesWritten += (long)toWriteLength;
    }

    @Override
    public void flush() throws IOException {
        this.dataOut.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.close();
            this.dataOut = null;
        }
    }

    @Override
    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }
}

