/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer.writable;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.uniffle.common.serializer.DeserializationStream;
import org.apache.uniffle.common.serializer.SerInputStream;
import org.apache.uniffle.common.serializer.writable.ComparativeOutputBuffer;
import org.apache.uniffle.common.serializer.writable.WritableSerializerInstance;

public class RawWritableDeserializationStream<K extends Writable, V extends Writable>
extends DeserializationStream<ComparativeOutputBuffer, ComparativeOutputBuffer> {
    public static final int EOF_MARKER = -1;
    private SerInputStream inputStream;
    private DataInputStream dataIn;
    private ComparativeOutputBuffer currentKeyBuffer;
    private ComparativeOutputBuffer currentValueBuffer;

    public RawWritableDeserializationStream(WritableSerializerInstance instance, SerInputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public void init() {
        this.inputStream.init();
        this.dataIn = new DataInputStream(this.inputStream);
    }

    @Override
    public boolean nextRecord() throws IOException {
        if (this.inputStream.available() <= 0) {
            return false;
        }
        int currentKeyLength = WritableUtils.readVInt((DataInput)this.dataIn);
        int currentValueLength = WritableUtils.readVInt((DataInput)this.dataIn);
        if (currentKeyLength == -1 && currentValueLength == -1) {
            return false;
        }
        this.currentKeyBuffer = new ComparativeOutputBuffer();
        this.currentValueBuffer = new ComparativeOutputBuffer();
        this.currentKeyBuffer.write(this.dataIn, currentKeyLength);
        this.currentValueBuffer.write(this.dataIn, currentValueLength);
        return true;
    }

    @Override
    public ComparativeOutputBuffer getCurrentKey() {
        return this.currentKeyBuffer;
    }

    @Override
    public ComparativeOutputBuffer getCurrentValue() {
        return this.currentValueBuffer;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.dataIn != null) {
            this.dataIn.close();
            this.dataIn = null;
        }
    }
}

