/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.rpc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.executor.ThreadPoolManager;
import org.apache.uniffle.common.metrics.GRPCMetrics;
import org.apache.uniffle.common.rpc.ClientContextServerInterceptor;
import org.apache.uniffle.common.rpc.MonitoringServerInterceptor;
import org.apache.uniffle.common.rpc.MonitoringServerTransportFilter;
import org.apache.uniffle.common.rpc.ServerInterface;
import org.apache.uniffle.common.util.ExitUtils;
import org.apache.uniffle.common.util.GrpcNettyUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.com.google.common.collect.Queues;
import org.apache.uniffle.shaded.io.grpc.BindableService;
import org.apache.uniffle.shaded.io.grpc.Server;
import org.apache.uniffle.shaded.io.grpc.ServerBuilder;
import org.apache.uniffle.shaded.io.grpc.ServerInterceptor;
import org.apache.uniffle.shaded.io.grpc.ServerInterceptors;
import org.apache.uniffle.shaded.io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import org.apache.uniffle.shaded.io.grpc.netty.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.apache.uniffle.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import org.apache.uniffle.shaded.org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcServer
implements ServerInterface {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcServer.class);
    private static volatile boolean poolExecutorHasExecuted;
    private Server server;
    private final int port;
    private int listenPort;
    private final GrpcThreadPoolExecutor pool;
    private List<Pair<BindableService, List<ServerInterceptor>>> servicesWithInterceptors;
    private GRPCMetrics grpcMetrics;
    private RssBaseConf rssConf;

    protected GrpcServer(RssBaseConf conf, List<Pair<BindableService, List<ServerInterceptor>>> servicesWithInterceptors, GRPCMetrics grpcMetrics) {
        this.rssConf = conf;
        this.port = this.rssConf.getInteger(RssBaseConf.RPC_SERVER_PORT);
        this.servicesWithInterceptors = servicesWithInterceptors;
        this.grpcMetrics = grpcMetrics;
        int rpcExecutorSize = conf.getInteger(RssBaseConf.RPC_EXECUTOR_SIZE);
        int queueSize = conf.getInteger(RssBaseConf.RPC_EXECUTOR_QUEUE_SIZE);
        this.pool = new GrpcThreadPoolExecutor(rpcExecutorSize, rpcExecutorSize * 2, 10L, TimeUnit.MINUTES, Queues.newLinkedBlockingQueue(queueSize), ThreadUtils.getThreadFactory("Grpc"), grpcMetrics);
        ThreadPoolManager.registerThreadPool("Grpc", () -> conf.getInteger(RssBaseConf.RPC_EXECUTOR_SIZE), () -> conf.getInteger(RssBaseConf.RPC_EXECUTOR_SIZE) * 2, () -> TimeUnit.MINUTES.toMillis(10L), (ThreadPoolExecutor)this.pool);
    }

    static boolean isPoolExecutorHasExecuted() {
        return poolExecutorHasExecuted;
    }

    static void reset() {
        poolExecutorHasExecuted = false;
    }

    private Server buildGrpcServer(int serverPort) {
        boolean isMetricsEnabled = this.rssConf.getBoolean(RssBaseConf.RPC_METRICS_ENABLED);
        long maxInboundMessageSize = this.rssConf.getLong(RssBaseConf.RPC_MESSAGE_MAX_SIZE);
        int pageSize = this.rssConf.getInteger(RssBaseConf.RPC_NETTY_PAGE_SIZE);
        int maxOrder = this.rssConf.getInteger(RssBaseConf.RPC_NETTY_MAX_ORDER);
        int smallCacheSize = this.rssConf.getInteger(RssBaseConf.RPC_NETTY_SMALL_CACHE_SIZE);
        PooledByteBufAllocator pooledByteBufAllocator = this.rssConf.getBoolean(RssBaseConf.RPC_NETTY_SMALL_CACHE_ENABLED) ? GrpcNettyUtils.createPooledByteBufAllocatorWithSmallCacheOnly(true, 0, pageSize, maxOrder, smallCacheSize) : GrpcNettyUtils.createPooledByteBufAllocator(true, 0, 0, 0, 0);
        NettyServerBuilder builder = ((NettyServerBuilder)NettyServerBuilder.forPort(serverPort).executor(this.pool)).maxInboundMessageSize((int)maxInboundMessageSize).withOption(ChannelOption.ALLOCATOR, pooledByteBufAllocator).withChildOption(ChannelOption.ALLOCATOR, pooledByteBufAllocator);
        if (isMetricsEnabled) {
            ((ServerBuilder)builder).addTransportFilter(new MonitoringServerTransportFilter(this.grpcMetrics));
        }
        this.servicesWithInterceptors.forEach(serviceWithInterceptors -> {
            ArrayList<ClientContextServerInterceptor> interceptors = (ArrayList<ClientContextServerInterceptor>)serviceWithInterceptors.getRight();
            interceptors.add(new ClientContextServerInterceptor());
            if (isMetricsEnabled) {
                MonitoringServerInterceptor monitoringInterceptor = new MonitoringServerInterceptor(this.grpcMetrics);
                ArrayList<ClientContextServerInterceptor> newInterceptors = Lists.newArrayList(interceptors);
                newInterceptors.add((ClientContextServerInterceptor)((Object)monitoringInterceptor));
                interceptors = newInterceptors;
            }
            builder.addService(ServerInterceptors.intercept((BindableService)serviceWithInterceptors.getLeft(), (List<? extends ServerInterceptor>)interceptors));
        });
        return ((ServerBuilder)builder).build();
    }

    @Override
    public int start() throws IOException {
        try {
            this.listenPort = RssUtils.startServiceOnPort(this, "grpc.server", this.port, this.rssConf);
        }
        catch (Exception e) {
            ExitUtils.terminate(1, "Fail to start grpc server on conf port:" + this.port, e, LOG);
        }
        return this.listenPort;
    }

    @Override
    public void startOnPort(int startPort) throws Exception {
        this.server = this.buildGrpcServer(startPort);
        this.server.start();
        this.listenPort = this.server.getPort();
        LOG.info("Grpc server started, configured port: {}, listening on {}.", (Object)this.port, (Object)this.listenPort);
    }

    @Override
    public void stop() throws InterruptedException {
        if (this.server != null) {
            this.server.shutdown().awaitTermination(10L, TimeUnit.SECONDS);
            LOG.info("GRPC server stopped!");
        }
        if (this.pool != null) {
            ThreadPoolManager.unregister(this.pool);
            this.pool.shutdown();
        }
    }

    @Override
    public void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public int getPort() {
        return this.listenPort;
    }

    public static class GrpcThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final GRPCMetrics grpcMetrics;
        private final AtomicLong activeThreadSize = new AtomicLong(0L);

        public GrpcThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, GRPCMetrics grpcMetrics) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
            this.grpcMetrics = grpcMetrics;
        }

        @Override
        protected void beforeExecute(Thread t2, Runnable r) {
            this.grpcMetrics.incGauge("grpcServerExecutorActiveThreads");
            this.grpcMetrics.setGauge("grpcServerExecutorBlockingQueueSize", this.getQueue().size());
            poolExecutorHasExecuted = true;
            super.beforeExecute(t2, r);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t2) {
            this.grpcMetrics.decGauge("grpcServerExecutorActiveThreads");
            this.grpcMetrics.setGauge("grpcServerExecutorBlockingQueueSize", this.getQueue().size());
            super.afterExecute(r, t2);
        }

        @VisibleForTesting
        void correctMetrics() {
            this.grpcMetrics.setGauge("grpcServerExecutorBlockingQueueSize", this.getQueue().size());
        }
    }

    public static class Builder {
        private RssBaseConf rssBaseConf;
        private GRPCMetrics grpcMetrics;
        private List<Pair<BindableService, List<ServerInterceptor>>> servicesWithInterceptors = new ArrayList<Pair<BindableService, List<ServerInterceptor>>>();

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder conf(RssBaseConf rssBaseConf) {
            this.rssBaseConf = rssBaseConf;
            return this;
        }

        public Builder addService(BindableService bindableService, ServerInterceptor ... interceptors) {
            this.servicesWithInterceptors.add(Pair.of(bindableService, Lists.newArrayList(interceptors)));
            return this;
        }

        public Builder grpcMetrics(GRPCMetrics metrics) {
            this.grpcMetrics = metrics;
            return this;
        }

        public GrpcServer build() {
            return new GrpcServer(this.rssBaseConf, this.servicesWithInterceptors, this.grpcMetrics);
        }
    }
}

