/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.request;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.uniffle.proto.RssProtos;

public class RssReportShuffleWriteMetricRequest {
    private int stageId;
    private int shuffleId;
    private long taskId;
    private Map<String, TaskShuffleWriteMetric> metrics;
    private TaskShuffleWriteTimes writeTimes;
    private boolean isShuffleWriteFailed;
    private Optional<String> shuffleWriteFailureReason;
    private long uncompressedByteSize;

    public RssReportShuffleWriteMetricRequest(int stageId, int shuffleId, long taskId, Map<String, TaskShuffleWriteMetric> metrics, TaskShuffleWriteTimes writeTimes, boolean isShuffleWriteFailed, Optional<String> shuffleWriteFailureReason, long uncompressedByteSize) {
        this.stageId = stageId;
        this.shuffleId = shuffleId;
        this.taskId = taskId;
        this.metrics = metrics;
        this.writeTimes = writeTimes;
        this.isShuffleWriteFailed = isShuffleWriteFailed;
        this.shuffleWriteFailureReason = shuffleWriteFailureReason;
        this.uncompressedByteSize = uncompressedByteSize;
    }

    public RssProtos.ReportShuffleWriteMetricRequest toProto() {
        RssReportShuffleWriteMetricRequest request = this;
        RssProtos.ReportShuffleWriteMetricRequest.Builder builder = RssProtos.ReportShuffleWriteMetricRequest.newBuilder();
        builder.setShuffleId(request.shuffleId).setStageId(request.stageId).setTaskId(request.taskId).setShuffleWriteTimes(this.writeTimes.toProto()).setIsTaskWriteFailed(this.isShuffleWriteFailed).setShuffleWriteFailureReason(this.shuffleWriteFailureReason.orElse("")).setUncompressedByteSize(request.uncompressedByteSize).putAllMetrics(request.metrics.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> {
            TaskShuffleWriteMetric metric = (TaskShuffleWriteMetric)x.getValue();
            return RssProtos.ShuffleWriteMetric.newBuilder().setByteSize(metric.getByteSize()).setDurationMillis(metric.getDurationMillis()).setPushFailureNumber(metric.getPushFailureNumber()).setRequireBufferFailureNumber(metric.getRequireBufferFailureNumber()).setLastPushFailureReason(Optional.ofNullable(metric.getLastFailureReason()).orElse("")).build();
        })));
        return builder.build();
    }

    public static class TaskShuffleWriteMetric {
        private long durationMillis;
        private long byteSize;
        private long requireBufferFailureNumber;
        private long pushFailureNumber;
        private String lastFailureReason;

        public TaskShuffleWriteMetric(long durationMillis, long byteSize, long requireBufferFailureNumber, long pushFailureNumber, String lastFailureReason) {
            this.durationMillis = durationMillis;
            this.byteSize = byteSize;
            this.requireBufferFailureNumber = requireBufferFailureNumber;
            this.pushFailureNumber = pushFailureNumber;
            this.lastFailureReason = lastFailureReason;
        }

        public long getDurationMillis() {
            return this.durationMillis;
        }

        public long getByteSize() {
            return this.byteSize;
        }

        public long getRequireBufferFailureNumber() {
            return this.requireBufferFailureNumber;
        }

        public long getPushFailureNumber() {
            return this.pushFailureNumber;
        }

        public String getLastFailureReason() {
            return this.lastFailureReason;
        }
    }

    public static class TaskShuffleWriteTimes {
        private long totalTime;
        private long copyTime = 0L;
        private long serializeTime = 0L;
        private long compressTime = 0L;
        private long sortTime = 0L;
        private long requireMemoryTime = 0L;
        private long waitFinishTime = 0L;

        public TaskShuffleWriteTimes(long totalTime, long copyTime, long serializeTime, long compressTime, long sortTime, long requireMemoryTime, long waitFinishTime) {
            this.totalTime = totalTime;
            this.copyTime = copyTime;
            this.serializeTime = serializeTime;
            this.compressTime = compressTime;
            this.sortTime = sortTime;
            this.requireMemoryTime = requireMemoryTime;
            this.waitFinishTime = waitFinishTime;
        }

        public long getTotalTime() {
            return this.totalTime;
        }

        public long getCopyTime() {
            return this.copyTime;
        }

        public long getSerializeTime() {
            return this.serializeTime;
        }

        public long getCompressTime() {
            return this.compressTime;
        }

        public long getSortTime() {
            return this.sortTime;
        }

        public long getRequireMemoryTime() {
            return this.requireMemoryTime;
        }

        public long getWaitFinishTime() {
            return this.waitFinishTime;
        }

        public RssProtos.ShuffleWriteTimes toProto() {
            return RssProtos.ShuffleWriteTimes.newBuilder().setTotal(this.totalTime).setCopy(this.copyTime).setSerialize(this.serializeTime).setCompress(this.compressTime).setSort(this.sortTime).setRequireMemory(this.requireMemoryTime).setWaitFinish(this.waitFinishTime).build();
        }
    }
}

