/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.record;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.uniffle.client.record.Record;
import org.apache.uniffle.client.record.RecordBuffer;
import org.apache.uniffle.client.record.RecordCollection;
import org.apache.uniffle.client.record.writer.Combiner;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.records.RecordsWriter;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;

public class RecordBlob<K, V, C>
implements RecordCollection<K, V, C> {
    private final int partitionId;
    private int size = 0;
    private LinkedHashMap<K, List<Record<K, ?>>> records = new LinkedHashMap();
    private List<Record<K, C>> result = new ArrayList<Record<K, C>>();

    public RecordBlob(int partitionId) {
        this.partitionId = partitionId;
    }

    public void addRecords(RecordBuffer<K, V> recordBuffer) {
        List<Record<K, V>> recordList = recordBuffer.getRecords();
        for (Record<K, V> record : recordList) {
            K key = record.getKey();
            if (!this.records.containsKey(key)) {
                this.records.put(key, new ArrayList());
            }
            this.records.get(key).add(record);
            ++this.size;
        }
    }

    @Override
    public void addRecord(K key, V value) {
        if (!this.records.containsKey(key)) {
            this.records.put(key, new ArrayList());
        }
        this.records.get(key).add(Record.create(key, value));
        ++this.size;
    }

    public void combine(Combiner combiner, boolean isMapCombined) {
        if (combiner == null) {
            throw new RssException("combiner is not set");
        }
        this.result = isMapCombined ? combiner.combineCombiners(this.records.entrySet().iterator()) : combiner.combineValues(this.records.entrySet().iterator());
        this.records.clear();
    }

    @Override
    public void serialize(RecordsWriter writer) throws IOException {
        for (Record<K, C> record : this.result) {
            writer.append(record.getKey(), record.getValue());
        }
    }

    public void clear() {
        this.size = 0;
        this.records.clear();
        this.result.clear();
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public int size() {
        return this.size;
    }

    @VisibleForTesting
    public LinkedHashMap<K, List<Record<K, ?>>> getRecords() {
        return this.records;
    }

    public List<Record<K, C>> getResult() {
        return this.result;
    }
}

