/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.shuffle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.reduce.WrappedReducer;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.uniffle.client.record.Record;
import org.apache.uniffle.client.record.writer.Combiner;
import org.apache.uniffle.client.shuffle.RecordCollector;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.serializer.SerializerInstance;

public class MRCombiner<K extends Writable, V extends Writable>
extends Combiner<K, V, V> {
    private JobConf jobConf;
    private Class combineClass;
    private SerializerInstance instance;
    private Class<K> keyClass;
    private Class<V> valueClass;

    public MRCombiner(JobConf jobConf, Class combineClass, SerializerInstance instance, Class<K> keyClass, Class<V> valueClass) {
        this.jobConf = jobConf;
        this.combineClass = combineClass;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.instance = instance;
    }

    @Override
    public List<Record> combineValues(Iterator<Map.Entry<K, List<Record>>> recordIterator) {
        try {
            ArrayList<Record> ret = new ArrayList<Record>();
            Reducer reducer = (Reducer)ReflectionUtils.newInstance((Class)this.combineClass, (Configuration)this.jobConf);
            Reducer.Context context = new WrappedReducer().getReducerContext(new RecordCollector<K, V>(recordIterator, ret, this.instance, this.keyClass, this.valueClass));
            reducer.run(context);
            return ret;
        }
        catch (IOException | InterruptedException e) {
            throw new RssException(e);
        }
    }

    @Override
    public List<Record> combineCombiners(Iterator<Map.Entry<K, List<Record>>> recordIterator) {
        return this.combineValues(recordIterator);
    }
}

