/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.factory;

import java.util.Map;
import org.apache.uniffle.client.api.ShuffleServerClient;
import org.apache.uniffle.client.impl.grpc.ShuffleServerGrpcClient;
import org.apache.uniffle.client.impl.grpc.ShuffleServerGrpcNettyClient;
import org.apache.uniffle.common.ClientType;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.util.JavaUtils;

public class ShuffleServerClientFactory {
    private Map<String, Map<ShuffleServerInfo, ShuffleServerClient>> clients = JavaUtils.newConcurrentMap();

    private ShuffleServerClientFactory() {
    }

    public static ShuffleServerClientFactory getInstance() {
        return LazyHolder.INSTANCE;
    }

    private ShuffleServerClient createShuffleServerClient(String clientType, ShuffleServerInfo shuffleServerInfo, RssConf rssConf) {
        if (clientType.equalsIgnoreCase(ClientType.GRPC.name())) {
            return new ShuffleServerGrpcClient(rssConf, shuffleServerInfo);
        }
        if (clientType.equalsIgnoreCase(ClientType.GRPC_NETTY.name())) {
            return new ShuffleServerGrpcNettyClient(rssConf, shuffleServerInfo.getHost(), shuffleServerInfo.getGrpcPort(), shuffleServerInfo.getNettyPort());
        }
        throw new UnsupportedOperationException("Unsupported client type " + clientType);
    }

    public ShuffleServerClient getShuffleServerClient(String clientType, ShuffleServerInfo shuffleServerInfo) {
        return this.getShuffleServerClient(clientType, shuffleServerInfo, new RssConf());
    }

    public ShuffleServerClient getShuffleServerClient(String clientType, ShuffleServerInfo shuffleServerInfo, RssConf rssConf) {
        Map serverToClients = this.clients.computeIfAbsent(clientType, key -> JavaUtils.newConcurrentMap());
        return serverToClients.computeIfAbsent(shuffleServerInfo, key -> this.createShuffleServerClient(clientType, shuffleServerInfo, rssConf));
    }

    public synchronized void cleanupCache() {
        this.clients.values().stream().flatMap(x -> x.values().stream()).forEach(ShuffleServerClient::close);
        this.clients = JavaUtils.newConcurrentMap();
    }

    private static class LazyHolder {
        static final ShuffleServerClientFactory INSTANCE = new ShuffleServerClientFactory();

        private LazyHolder() {
        }
    }
}

