/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.ShuffleConsumerPlugin;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.RssMRConfig;
import org.apache.hadoop.mapreduce.RssMRUtils;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.MRMetricsReporter;
import org.apache.hadoop.mapreduce.task.reduce.RssEventFetcher;
import org.apache.hadoop.util.Progress;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.record.Record;
import org.apache.uniffle.client.record.reader.KeyValueReader;
import org.apache.uniffle.client.record.reader.RMRecordsReader;
import org.apache.uniffle.client.shuffle.MRCombiner;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.serializer.SerializerFactory;
import org.apache.uniffle.common.serializer.SerializerInstance;
import org.apache.uniffle.common.serializer.writable.ComparativeOutputBuffer;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Sets;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;

public class RMRssShuffle<K, V>
implements ShuffleConsumerPlugin<K, V>,
ExceptionReporter {
    private static final int MAX_EVENTS_TO_FETCH = 10000;
    private static final Log LOG = LogFactory.getLog(RMRssShuffle.class);
    private String appId;
    private int appAttemptId;
    private int partitionId;
    private ShuffleConsumerPlugin.Context<K, V> context;
    private TaskAttemptID reduceId;
    private JobConf mrJobConf;
    private Configuration rssJobConf;
    private TaskStatus taskStatus;
    private Task reduceTask;
    private TaskUmbilicalProtocol umbilical;
    private RssConf rssConf;
    private RecordsRelayer relayer;
    private Class keyClass;
    private Class valueClass;
    private RawComparator rawComparator;
    private SerializerInstance serializerInstance;
    private RMRecordsReader reader;
    Set<ShuffleServerInfo> serverInfoSet;
    private ScheduledExecutorService scheduledExecutorService;

    public void init(ShuffleConsumerPlugin.Context<K, V> context) {
        LOG.info((Object)"use RMRssShuffle");
        this.context = context;
        this.reduceId = context.getReduceId();
        this.mrJobConf = context.getJobConf();
        this.umbilical = context.getUmbilical();
        this.reduceTask = context.getReduceTask();
        this.taskStatus = context.getStatus();
        this.rssJobConf = new JobConf("rss_conf.xml");
        this.appId = RssMRUtils.getApplicationAttemptId().toString();
        this.appAttemptId = RssMRUtils.getApplicationAttemptId().getAttemptId();
        this.keyClass = context.getJobConf().getMapOutputKeyClass();
        this.valueClass = context.getJobConf().getMapOutputValueClass();
        this.rawComparator = context.getJobConf().getOutputKeyComparator();
        this.rssConf = RssMRConfig.toRssConf(this.rssJobConf);
        SerializerFactory factory = new SerializerFactory(this.rssConf);
        this.serializerInstance = factory.getSerializer(this.keyClass).newInstance();
        this.partitionId = this.reduceId.getTaskID().getId();
        this.serverInfoSet = RssMRUtils.getAssignedServers(this.rssJobConf, this.partitionId);
        if (this.serverInfoSet.size() != 1) {
            throw new RssException("For now, only support one shuffle server.");
        }
        MRCombiner combiner = null;
        if (context.getCombinerClass() != null) {
            combiner = new MRCombiner(new JobConf(), context.getCombinerClass(), this.serializerInstance, this.keyClass, this.valueClass);
        }
        HashMap<Integer, List<ShuffleServerInfo>> serverInfoMap = new HashMap<Integer, List<ShuffleServerInfo>>();
        serverInfoMap.put(this.partitionId, new ArrayList<ShuffleServerInfo>(this.serverInfoSet));
        String clientType = this.rssJobConf.get("mapreduce.rss.client.type", "GRPC_NETTY");
        this.reader = new RMRecordsReader(this.appId, 0, (Set<Integer>)Sets.newHashSet(this.partitionId), (Map<Integer, List<ShuffleServerInfo>>)serverInfoMap, this.rssConf, this.keyClass, this.valueClass, this.rawComparator, true, combiner, combiner != null, new MRMetricsReporter(context.getReporter()), clientType);
    }

    public RawKeyValueIterator run() throws IOException, InterruptedException {
        this.reportUniqueBlockIds();
        this.taskStatus.setPhase(TaskStatus.Phase.SORT);
        this.reduceTask.statusUpdate(this.umbilical);
        this.reader.start();
        this.scheduledExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor("PingThread");
        long interval = this.mrJobConf.getLong("mapreduce.task.timeout", 300000L) / 2L;
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.context.getReporter().progress(), interval, interval, TimeUnit.MILLISECONDS);
        this.relayer = new RecordsRelayer(this.reader, this.serializerInstance);
        return this.relayer;
    }

    public void reportUniqueBlockIds() {
        ShuffleWriteClient writeClient = RssMRUtils.createShuffleClient(this.mrJobConf);
        Roaring64NavigableMap blockIdBitmap = writeClient.getShuffleResult(null, this.serverInfoSet, this.appId, 0, this.partitionId);
        RssEventFetcher<K, V> eventFetcher = this.createEventFetcher();
        Roaring64NavigableMap taskIdBitmap = eventFetcher.fetchAllRssTaskIds();
        Roaring64NavigableMap uniqueBlockIdBitMap = Roaring64NavigableMap.bitmapOf(new long[0]);
        blockIdBitmap.forEach(blockId -> {
            long taId = RssMRUtils.getTaskAttemptId(blockId);
            if (taskIdBitmap.contains(taId)) {
                uniqueBlockIdBitMap.add(blockId);
            }
        });
        writeClient.startSortMerge(this.serverInfoSet, this.appId, 0, this.partitionId, uniqueBlockIdBitMap);
    }

    public void close() {
        if (this.relayer != null) {
            try {
                this.relayer.close();
            }
            catch (IOException e) {
                throw new RssException(e);
            }
        }
    }

    public void reportException(Throwable throwable) {
    }

    @VisibleForTesting
    void setReader(RMRecordsReader reader) {
        this.reader = reader;
    }

    @VisibleForTesting
    RssEventFetcher<K, V> createEventFetcher() {
        return new RssEventFetcher(this.appAttemptId, this.reduceId, this.umbilical, this.mrJobConf, 10000);
    }

    public static class RecordsRelayer
    implements RawKeyValueIterator {
        RMRecordsReader reader;
        KeyValueReader<ComparativeOutputBuffer, ComparativeOutputBuffer> keyValueReader;
        private Progress mergeProgress = new Progress();
        Record<ComparativeOutputBuffer, ComparativeOutputBuffer> current;

        public RecordsRelayer(RMRecordsReader reader, SerializerInstance keySerializer) {
            this.reader = reader;
            this.keyValueReader = this.reader.rawKeyValueReader();
        }

        public DataInputBuffer getKey() throws IOException {
            ComparativeOutputBuffer buffer = this.current.getKey();
            DataInputBuffer inputBuffer = new DataInputBuffer();
            inputBuffer.reset(buffer.getData(), 0, buffer.getLength());
            return inputBuffer;
        }

        public DataInputBuffer getValue() throws IOException {
            ComparativeOutputBuffer buffer = this.current.getValue();
            DataInputBuffer inputBuffer = new DataInputBuffer();
            inputBuffer.reset(buffer.getData(), 0, buffer.getLength());
            return inputBuffer;
        }

        public boolean next() throws IOException {
            boolean hasNext = this.keyValueReader.hasNext();
            if (hasNext) {
                this.current = this.keyValueReader.next();
            }
            return hasNext;
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public Progress getProgress() {
            return this.mergeProgress;
        }
    }

    static enum Counter {
        INPUT_RECORDS_PROCESSED;

    }
}

