/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.uniffle.common.serializer.BufferSerInputStream;
import org.apache.uniffle.common.serializer.FileSerInputStream;

public abstract class SerInputStream
extends InputStream {
    public void init() {
    }

    @Override
    public abstract int available();

    public abstract long getStart();

    public abstract long getEnd();

    public abstract void transferTo(ByteBuf var1, int var2) throws IOException;

    public static SerInputStream newInputStream(File file) throws IOException {
        return SerInputStream.newInputStream(file, 0L, file.length());
    }

    public static SerInputStream newInputStream(File file, long start) throws IOException {
        return SerInputStream.newInputStream(file, start, file.length());
    }

    public static SerInputStream newInputStream(File file, long start, long end) throws IOException {
        return new FileSerInputStream(file, start, Math.min(end, file.length()));
    }

    public static SerInputStream newInputStream(ByteBuf byteBuf) {
        return SerInputStream.newInputStream(byteBuf, 0, byteBuf.writerIndex());
    }

    public static SerInputStream newInputStream(ByteBuf byteBuf, int start) {
        return SerInputStream.newInputStream(byteBuf, start, byteBuf.writerIndex());
    }

    public static SerInputStream newInputStream(ByteBuf byteBuf, int start, int end) {
        return new BufferSerInputStream(byteBuf, start, Math.min(byteBuf.writerIndex(), end));
    }
}

