/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.merge;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.serializer.SerOutputStream;
import org.apache.uniffle.common.util.NettyUtils;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.merge.Partition;

public class MergedResult {
    private final RssConf rssConf;
    private final long mergedBlockSize;
    private final List<Long> offsets = new ArrayList<Long>();
    private final CacheMergedBlockFuntion cachedMergedBlock;
    private final Partition partition;

    public MergedResult(RssConf rssConf, CacheMergedBlockFuntion cachedMergedBlock, int mergedBlockSize, Partition partition) {
        this.rssConf = rssConf;
        this.cachedMergedBlock = cachedMergedBlock;
        this.mergedBlockSize = mergedBlockSize > 0 ? (long)mergedBlockSize : this.rssConf.getSizeAsBytes(ShuffleServerConf.SERVER_MERGE_DEFAULT_MERGED_BLOCK_SIZE.key(), (String)ShuffleServerConf.SERVER_MERGE_DEFAULT_MERGED_BLOCK_SIZE.defaultValue());
        this.partition = partition;
        this.offsets.add(0L);
    }

    public SerOutputStream getOutputStream(boolean direct, long totalBytes) {
        return new MergedSegmentOutputStream(direct, totalBytes);
    }

    public boolean isOutOfBound(long blockId) {
        return blockId >= (long)this.offsets.size();
    }

    public long getBlockSize(long blockId) {
        return this.offsets.get((int)blockId) - this.offsets.get((int)(blockId - 1L));
    }

    public class MergedSegmentOutputStream
    extends SerOutputStream {
        private final boolean direct;
        private final long totalBytes;
        private ByteBuf byteBuf;
        private long written = 0L;

        MergedSegmentOutputStream(boolean direct, long totalBytes) {
            this.direct = direct;
            this.totalBytes = totalBytes;
        }

        public void finalizeBlock() throws IOException {
            if (this.written <= (Long)MergedResult.this.offsets.get(MergedResult.this.offsets.size() - 1)) {
                return;
            }
            int requireSize = this.byteBuf.readableBytes();
            if (MergedResult.this.partition == null) {
                throw new IOException("Can't find partition!");
            }
            MergedResult.this.partition.requireMemory(requireSize);
            boolean success = false;
            try {
                success = MergedResult.this.cachedMergedBlock.cache(this.byteBuf, MergedResult.this.offsets.size(), requireSize);
            }
            finally {
                if (!success) {
                    MergedResult.this.partition.releaseMemory(requireSize);
                }
            }
            MergedResult.this.offsets.add(this.written);
        }

        private void allocateNewBuffer(int preAllocateSize) {
            if (this.byteBuf != null) {
                this.byteBuf.release();
                this.byteBuf = null;
            }
            int alloc = Math.max((int)Math.min(MergedResult.this.mergedBlockSize, this.totalBytes - this.written), preAllocateSize);
            UnpooledByteBufAllocator allocator = NettyUtils.getSharedUnpooledByteBufAllocator((boolean)true);
            this.byteBuf = this.direct ? allocator.directBuffer(alloc) : Unpooled.buffer((int)alloc);
        }

        public void write(ByteBuf from) throws IOException {
            this.preAllocate(from.readableBytes());
            int c = from.readableBytes();
            this.byteBuf.writeBytes(from);
            this.written += (long)c;
        }

        public void write(int b) throws IOException {
            this.preAllocate(1);
            this.byteBuf.writeByte((int)((byte)(b & 0xFF)));
            ++this.written;
        }

        public void preAllocate(int length) throws IOException {
            if (this.byteBuf == null || this.byteBuf.writableBytes() < length) {
                this.finalizeBlock();
                this.allocateNewBuffer(length);
            }
        }

        public void flush() throws IOException {
            this.finalizeBlock();
        }

        public void close() throws IOException {
            if (this.byteBuf != null) {
                this.byteBuf.release();
                this.byteBuf = null;
            }
        }
    }

    @FunctionalInterface
    public static interface CacheMergedBlockFuntion {
        public boolean cache(ByteBuf var1, long var2, int var4);
    }
}

