/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.records;

import java.io.IOException;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.serializer.DeserializationStream;
import org.apache.uniffle.common.serializer.SerInputStream;
import org.apache.uniffle.common.serializer.Serializer;
import org.apache.uniffle.common.serializer.SerializerFactory;
import org.apache.uniffle.common.serializer.SerializerInstance;

public class RecordsReader<K, V> {
    private DeserializationStream<K, V> stream;
    private Object currentKey;
    private Object currentValue;

    public RecordsReader(RssConf rssConf, SerInputStream input, Class<K> keyClass, Class<V> valueClass, boolean raw, boolean buffered) {
        SerializerFactory factory = new SerializerFactory(rssConf);
        Serializer serializer = factory.getSerializer(keyClass);
        assert (factory.getSerializer(valueClass).getClass().equals(serializer.getClass()));
        SerializerInstance instance = serializer.newInstance();
        this.stream = instance.deserializeStream(input, keyClass, valueClass, raw, buffered);
    }

    public void init() {
        this.stream.init();
    }

    public boolean next() throws IOException {
        boolean hasNext = this.stream.nextRecord();
        if (hasNext) {
            this.currentKey = this.stream.getCurrentKey();
            this.currentValue = this.stream.getCurrentValue();
        }
        return hasNext;
    }

    public Object getCurrentKey() {
        return this.currentKey;
    }

    public Object getCurrentValue() {
        return this.currentValue;
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }
}

