/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.audit;

import java.io.Closeable;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.proto.RssProtos;
import org.slf4j.Logger;

public abstract class RpcAuditContext
implements Closeable {
    private final Logger log;
    private String command;
    private String statusCode;
    private String args;
    private String returnValue;
    private String from;
    private long creationTimeNs;
    protected long executionTimeNs;

    public RpcAuditContext(Logger log) {
        this.log = log;
    }

    protected abstract String content();

    public RpcAuditContext withCommand(String command) {
        this.command = command;
        return this;
    }

    public RpcAuditContext withCreationTimeNs(long creationTimeNs) {
        this.creationTimeNs = creationTimeNs;
        return this;
    }

    public RpcAuditContext withStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode == null ? "UNKNOWN" : statusCode.name();
        return this;
    }

    public RpcAuditContext withStatusCode(RssProtos.StatusCode statusCode) {
        this.statusCode = statusCode == null ? "UNKNOWN" : statusCode.name();
        return this;
    }

    public RpcAuditContext withStatusCode(String statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public RpcAuditContext withArgs(String args) {
        this.args = args;
        return this;
    }

    public RpcAuditContext withReturnValue(String returnValue) {
        this.returnValue = returnValue;
        return this;
    }

    public RpcAuditContext withFrom(String from) {
        this.from = from;
        return this;
    }

    @Override
    public void close() {
        if (this.log == null) {
            return;
        }
        this.executionTimeNs = System.nanoTime() - this.creationTimeNs;
        this.log.info(this.toString());
    }

    public String toString() {
        String line = String.format("cmd=%s\tstatusCode=%s\tfrom=%s\texecutionTimeUs=%d\t%s", this.command, this.statusCode, this.from, this.executionTimeNs / 1000L, this.content());
        if (this.args != null) {
            line = line + String.format("\targs{%s}", this.args);
        }
        if (this.returnValue != null) {
            line = line + String.format("\treturn{%s}", this.returnValue);
        }
        return line;
    }
}

