/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.RpcResponse;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.ByteBufUtils;

public class GetSortedShuffleDataResponse
extends RpcResponse {
    private long nextBlockId;
    private int mergeState;

    public GetSortedShuffleDataResponse(long requestId, StatusCode statusCode, String retMessage, long nextBlockId, int mergeState, ByteBuf data) {
        this(requestId, statusCode, retMessage, nextBlockId, mergeState, new NettyManagedBuffer(data));
    }

    public GetSortedShuffleDataResponse(long requestId, StatusCode statusCode, String retMessage, long nextBlockId, int mergeState, ManagedBuffer managedBuffer) {
        super(requestId, statusCode, retMessage, managedBuffer);
        this.nextBlockId = nextBlockId;
        this.mergeState = mergeState;
    }

    public long getNextBlockId() {
        return this.nextBlockId;
    }

    public int getMergeState() {
        return this.mergeState;
    }

    @Override
    public int encodedLength() {
        return super.encodedLength() + 8 + 4;
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        buf.writeLong(this.nextBlockId);
        buf.writeInt(this.mergeState);
    }

    public static GetSortedShuffleDataResponse decode(ByteBuf buf, boolean decodeBody) {
        long requestId = buf.readLong();
        StatusCode statusCode = StatusCode.fromCode(buf.readInt());
        String retMessage = ByteBufUtils.readLengthAndString(buf);
        NettyManagedBuffer nettyManagedBuffer = decodeBody ? new NettyManagedBuffer(buf) : NettyManagedBuffer.EMPTY_BUFFER;
        long nextBlockId = buf.readLong();
        int mergeState = buf.readInt();
        return new GetSortedShuffleDataResponse(requestId, statusCode, retMessage, nextBlockId, mergeState, nettyManagedBuffer);
    }

    @Override
    public Message.Type type() {
        return Message.Type.GET_SORTED_SHUFFLE_DATA_RESPONSE;
    }
}

