/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.compression;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.uniffle.common.compression.Lz4Codec;
import org.apache.uniffle.common.compression.NoOpCodec;
import org.apache.uniffle.common.compression.SnappyCodec;
import org.apache.uniffle.common.compression.StatisticsCodec;
import org.apache.uniffle.common.compression.ZstdCodec;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;

public abstract class Codec {
    public static Optional<Codec> create(RssConf rssConf) {
        Optional<Codec> codec = Codec.newInstance(rssConf);
        if (codec.isPresent() && rssConf.getBoolean(RssClientConf.COMPRESSION_STATISTICS_ENABLED)) {
            return Optional.of(new StatisticsCodec(codec.get()));
        }
        return codec;
    }

    public static Optional<Codec> newInstance(RssConf rssConf) {
        Type type = rssConf.get(RssClientConf.COMPRESSION_TYPE);
        switch (type) {
            case NONE: {
                return Optional.empty();
            }
            case ZSTD: {
                return Optional.of(ZstdCodec.getInstance(rssConf));
            }
            case SNAPPY: {
                return Optional.of(SnappyCodec.getInstance());
            }
            case NOOP: {
                return Optional.of(NoOpCodec.getInstance());
            }
        }
        return Optional.of(Lz4Codec.getInstance());
    }

    public abstract void decompress(ByteBuffer var1, int var2, ByteBuffer var3, int var4);

    public abstract byte[] compress(byte[] var1);

    public abstract int compress(ByteBuffer var1, ByteBuffer var2);

    public abstract int maxCompressedLength(int var1);

    public static enum Type {
        LZ4,
        ZSTD,
        NOOP,
        SNAPPY,
        NONE;

    }
}

