/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.dashboard.web.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardUtils.class);

    public static Map<String, String> convertAddressesStrToMap(String coordinatorAddressesStr) {
        String[] coordinators;
        Preconditions.checkNotNull((Object)coordinatorAddressesStr, (Object)"Coordinator web address is null");
        HashMap coordinatorAddressMap = Maps.newHashMap();
        for (String coordinator : coordinators = coordinatorAddressesStr.split(",")) {
            try {
                URL coordinatorURL = new URL(coordinator);
                coordinatorAddressMap.put(coordinatorURL.getHost(), DashboardUtils.removeBackslash(coordinator));
            }
            catch (MalformedURLException e) {
                LOG.error("The coordinator address is abnormal.", (Throwable)e);
            }
        }
        LOG.info("Monitored the Coordinator of {}.", (Object)String.join((CharSequence)",", coordinatorAddressMap.values()));
        return coordinatorAddressMap;
    }

    public static String removeBackslash(String addressStr) {
        if (StringUtils.isNotEmpty((CharSequence)addressStr) && addressStr.endsWith("/")) {
            return addressStr.substring(0, addressStr.length() - 1);
        }
        return addressStr;
    }
}

