/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.uniffle.storage.api.FileWriter;
import org.apache.uniffle.storage.common.FileBasedShuffleSegment;

public class LocalFileNioWriter
implements FileWriter {
    private DataOutputStream dataOutputStream;
    private FileOutputStream fileOutputStream;
    private long nextOffset;

    @VisibleForTesting
    public LocalFileNioWriter(File file) throws IOException {
        this(file, 8192);
    }

    public LocalFileNioWriter(File file, int bufferSize) throws IOException {
        this.fileOutputStream = new FileOutputStream(file, true);
        this.dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.fileOutputStream, bufferSize));
        this.nextOffset = file.length();
    }

    @Override
    public void writeData(byte[] data) throws IOException {
        this.writeData(Unpooled.wrappedBuffer((byte[])data));
    }

    @Override
    public void writeData(ByteBuf buf) throws IOException {
        if (buf != null && buf.readableBytes() > 0) {
            int writtenSize = this.fileOutputStream.getChannel().write(buf.nioBuffer());
            if (writtenSize <= 0) {
                throw new IOException("Failed to write data to file");
            }
            this.nextOffset += (long)buf.readableBytes();
        }
    }

    @Override
    public void writeIndex(FileBasedShuffleSegment segment) throws IOException {
        this.dataOutputStream.writeLong(segment.getOffset());
        this.dataOutputStream.writeInt(segment.getLength());
        this.dataOutputStream.writeInt(segment.getUncompressLength());
        this.dataOutputStream.writeLong(segment.getCrc());
        this.dataOutputStream.writeLong(segment.getBlockId());
        this.dataOutputStream.writeLong(segment.getTaskAttemptId());
    }

    @Override
    public long nextOffset() {
        return this.nextOffset;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.dataOutputStream != null) {
            this.dataOutputStream.close();
        }
    }
}

