/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.security;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.security.ACLConfigurationParser;
import org.apache.tez.common.security.ACLManager;
import org.apache.tez.common.security.ACLType;

@InterfaceAudience.Public
public class DAGAccessControls {
    private final Set<String> usersWithViewACLs;
    private final Set<String> usersWithModifyACLs;
    private final Set<String> groupsWithViewACLs;
    private final Set<String> groupsWithModifyACLs;

    public DAGAccessControls() {
        this.usersWithViewACLs = new HashSet<String>();
        this.usersWithModifyACLs = new HashSet<String>();
        this.groupsWithViewACLs = new HashSet<String>();
        this.groupsWithModifyACLs = new HashSet<String>();
    }

    public DAGAccessControls(String viewACLsStr, String modifyACLsStr) {
        Configuration conf = new Configuration(false);
        conf.set("tez.am.dag.view-acls", viewACLsStr != null ? viewACLsStr : "");
        conf.set("tez.am.dag.modify-acls", modifyACLsStr != null ? modifyACLsStr : "");
        ACLConfigurationParser parser = new ACLConfigurationParser(conf, true);
        this.usersWithViewACLs = new HashSet<String>();
        this.usersWithModifyACLs = new HashSet<String>();
        this.groupsWithViewACLs = new HashSet<String>();
        this.groupsWithModifyACLs = new HashSet<String>();
        Map<ACLType, Set<String>> allowedUsers = parser.getAllowedUsers();
        Map<ACLType, Set<String>> allowedGroups = parser.getAllowedGroups();
        if (allowedUsers.containsKey((Object)ACLType.DAG_VIEW_ACL)) {
            this.usersWithViewACLs.addAll((Collection<String>)allowedUsers.get((Object)ACLType.DAG_VIEW_ACL));
        }
        if (allowedUsers.containsKey((Object)ACLType.DAG_MODIFY_ACL)) {
            this.usersWithModifyACLs.addAll((Collection<String>)allowedUsers.get((Object)ACLType.DAG_MODIFY_ACL));
        }
        if (allowedGroups.containsKey((Object)ACLType.DAG_VIEW_ACL)) {
            this.groupsWithViewACLs.addAll((Collection<String>)allowedGroups.get((Object)ACLType.DAG_VIEW_ACL));
        }
        if (allowedGroups.containsKey((Object)ACLType.DAG_MODIFY_ACL)) {
            this.groupsWithModifyACLs.addAll((Collection<String>)allowedGroups.get((Object)ACLType.DAG_MODIFY_ACL));
        }
    }

    public synchronized DAGAccessControls setUsersWithViewACLs(Collection<String> users) {
        this.usersWithViewACLs.clear();
        this.usersWithViewACLs.addAll(users);
        return this;
    }

    public synchronized DAGAccessControls setUsersWithModifyACLs(Collection<String> users) {
        this.usersWithModifyACLs.clear();
        this.usersWithModifyACLs.addAll(users);
        return this;
    }

    public synchronized DAGAccessControls setGroupsWithViewACLs(Collection<String> groups) {
        this.groupsWithViewACLs.clear();
        this.groupsWithViewACLs.addAll(groups);
        return this;
    }

    public synchronized DAGAccessControls setGroupsWithModifyACLs(Collection<String> groups) {
        this.groupsWithModifyACLs.clear();
        this.groupsWithModifyACLs.addAll(groups);
        return this;
    }

    @InterfaceAudience.Private
    public synchronized Set<String> getUsersWithViewACLs() {
        return Collections.unmodifiableSet(this.usersWithViewACLs);
    }

    @InterfaceAudience.Private
    public synchronized Set<String> getUsersWithModifyACLs() {
        return Collections.unmodifiableSet(this.usersWithModifyACLs);
    }

    @InterfaceAudience.Private
    public synchronized Set<String> getGroupsWithViewACLs() {
        return Collections.unmodifiableSet(this.groupsWithViewACLs);
    }

    @InterfaceAudience.Private
    public synchronized Set<String> getGroupsWithModifyACLs() {
        return Collections.unmodifiableSet(this.groupsWithModifyACLs);
    }

    @InterfaceAudience.Private
    public synchronized void mergeIntoAmAcls(Configuration conf) {
        ACLConfigurationParser parser = new ACLConfigurationParser(conf, false);
        parser.addAllowedGroups((Map<ACLType, Set<String>>)ImmutableMap.of((Object)((Object)ACLType.AM_VIEW_ACL), this.groupsWithViewACLs, (Object)((Object)ACLType.AM_MODIFY_ACL), this.groupsWithModifyACLs));
        parser.addAllowedUsers((Map<ACLType, Set<String>>)ImmutableMap.of((Object)((Object)ACLType.AM_VIEW_ACL), this.usersWithViewACLs, (Object)((Object)ACLType.AM_MODIFY_ACL), this.usersWithModifyACLs));
        Set<String> viewUsers = parser.getAllowedUsers().get((Object)ACLType.AM_VIEW_ACL);
        Set<String> viewGroups = parser.getAllowedGroups().get((Object)ACLType.AM_VIEW_ACL);
        if (viewUsers.contains("*")) {
            conf.set("tez.am.view-acls", "*");
        } else {
            String userList = ACLManager.toCommaSeparatedString(viewUsers);
            String groupList = ACLManager.toCommaSeparatedString(viewGroups);
            conf.set("tez.am.view-acls", userList + " " + groupList);
        }
        Set<String> modifyUsers = parser.getAllowedUsers().get((Object)ACLType.AM_MODIFY_ACL);
        Set<String> modifyGroups = parser.getAllowedGroups().get((Object)ACLType.AM_MODIFY_ACL);
        if (modifyUsers.contains("*")) {
            conf.set("tez.am.modify-acls", "*");
        } else {
            String userList = ACLManager.toCommaSeparatedString(modifyUsers);
            String groupList = ACLManager.toCommaSeparatedString(modifyGroups);
            conf.set("tez.am.modify-acls", userList + " " + groupList);
        }
    }
}

