/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Factorial$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the factorial of `expr`. `expr` is [0..20]. Otherwise, null.", examples="\n    Examples:\n      > SELECT _FUNC_(5);\n       120\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005=w!B\u000f\u001f\u0011\u0003Yc!B\u0017\u001f\u0011\u0003q\u0003\"B\u001f\u0002\t\u0003q\u0004\"B \u0002\t\u0003\u0001\u0005bB%\u0002\u0005\u0004%IA\u0013\u0005\u0007\u001d\u0006\u0001\u000b\u0011B&\t\u000f=\u000b\u0011\u0011!CA!\"I\u0011qW\u0001\u0002\u0002\u0013\u0005\u0015\u0011\u0018\u0005\n\u0003\u000b\f\u0011\u0011!C\u0005\u0003\u000f4A!\f\u0010A%\"Aq-\u0003BK\u0002\u0013\u0005\u0001\u000e\u0003\u0005m\u0013\tE\t\u0015!\u0003j\u0011\u0015i\u0014\u0002\"\u0001n\u0011\u0015y\u0017\u0002\"\u0011q\u0011\u0015!\u0018\u0002\"\u0011v\u0011\u0019y\u0018\u0002\"\u0011\u0002\u0002!1\u00111A\u0005\u0005BADq!!\u0002\n\t#\n9\u0001C\u0004\u0002\u0014%!\t%!\u0006\t\u000f\u0005E\u0012\u0002\"\u0015\u00024!I\u0011\u0011H\u0005\u0002\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u007fI\u0011\u0013!C\u0001\u0003\u0003B\u0011\"a\u0016\n\u0003\u0003%\t%!\u0017\t\u0013\u0005\u001d\u0014\"!A\u0005\u0002\u0005%\u0004\"CA6\u0013\u0005\u0005I\u0011AA7\u0011%\t\u0019(CA\u0001\n\u0003\n)\bC\u0005\u0002\u0004&\t\t\u0011\"\u0001\u0002\u0006\"I\u0011\u0011R\u0005\u0002\u0002\u0013\u0005\u00131\u0012\u0005\n\u0003\u001fK\u0011\u0011!C!\u0003#\u000b\u0011BR1di>\u0014\u0018.\u00197\u000b\u0005}\u0001\u0013aC3yaJ,7o]5p]NT!!\t\u0012\u0002\u0011\r\fG/\u00197zgRT!a\t\u0013\u0002\u0007M\fHN\u0003\u0002&M\u0005)1\u000f]1sW*\u0011q\u0005K\u0001\u0007CB\f7\r[3\u000b\u0003%\n1a\u001c:h\u0007\u0001\u0001\"\u0001L\u0001\u000e\u0003y\u0011\u0011BR1di>\u0014\u0018.\u00197\u0014\u0007\u0005yS\u0007\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VM\u001a\t\u0003mmj\u0011a\u000e\u0006\u0003qe\n!![8\u000b\u0003i\nAA[1wC&\u0011Ah\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\n\u0011BZ1di>\u0014\u0018.\u00197\u0015\u0005\u0005#\u0005C\u0001\u0019C\u0013\t\u0019\u0015G\u0001\u0003M_:<\u0007\"B#\u0004\u0001\u00041\u0015!\u00018\u0011\u0005A:\u0015B\u0001%2\u0005\rIe\u000e^\u0001\u000bM\u0006\u001cGo\u001c:jC2\u001cX#A&\u0011\u0007Ab\u0015)\u0003\u0002Nc\t)\u0011I\u001d:bs\u0006Ya-Y2u_JL\u0017\r\\:!\u0003\u0015\t\u0007\u000f\u001d7z)\r\t\u0016Q\u0017\t\u0003Y%\u0019R!C*W3r\u0003\"\u0001\f+\n\u0005Us\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00051:\u0016B\u0001-\u001f\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u0019[\u0013\tY\u0016GA\u0004Qe>$Wo\u0019;\u0011\u0005u+gB\u00010d\u001d\ty&-D\u0001a\u0015\t\t'&\u0001\u0004=e>|GOP\u0005\u0002e%\u0011A-M\u0001\ba\u0006\u001c7.Y4f\u0013\tadM\u0003\u0002ec\u0005)1\r[5mIV\t\u0011\u000e\u0005\u0002-U&\u00111N\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007\u0005\u0006\u0002R]\")q\r\u0004a\u0001S\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$X#A9\u0011\u0005A\u0012\u0018BA:2\u0005\u001d\u0011un\u001c7fC:\f!\"\u001b8qkR$\u0016\u0010]3t+\u00051\bcA/xs&\u0011\u0001P\u001a\u0002\u0004'\u0016\f\bC\u0001>~\u001b\u0005Y(B\u0001?#\u0003\u0015!\u0018\u0010]3t\u0013\tq8P\u0001\u0005ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#A=\u0002\u00119,H\u000e\\1cY\u0016\fAB\\;mYN\u000bg-Z#wC2$B!!\u0003\u0002\u0010A\u0019\u0001'a\u0003\n\u0007\u00055\u0011GA\u0002B]fDq!!\u0005\u0012\u0001\u0004\tI!A\u0003j]B,H/A\u0005e_\u001e+gnQ8eKR1\u0011qCA\u0012\u0003[\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;q\u0012aB2pI\u0016<WM\\\u0005\u0005\u0003C\tYB\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t)C\u0005a\u0001\u0003O\t1a\u0019;y!\u0011\tI\"!\u000b\n\t\u0005-\u00121\u0004\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tyC\u0005a\u0001\u0003/\t!!\u001a<\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\r\t\u0016Q\u0007\u0005\u0007\u0003o\u0019\u0002\u0019A5\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR\u0019\u0011+!\u0010\t\u000f\u001d$\u0002\u0013!a\u0001S\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\"U\rI\u0017QI\u0016\u0003\u0003\u000f\u0002B!!\u0013\u0002T5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011K\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002V\u0005-#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0017\u0011\t\u0005u\u00131M\u0007\u0003\u0003?R1!!\u0019:\u0003\u0011a\u0017M\\4\n\t\u0005\u0015\u0014q\f\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003\u0019\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\n\u0005=\u0004\u0002CA91\u0005\u0005\t\u0019\u0001$\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\b\u0005\u0004\u0002z\u0005}\u0014\u0011B\u0007\u0003\u0003wR1!! 2\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0003\u000bYH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA9\u0002\b\"I\u0011\u0011\u000f\u000e\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\\\u00055\u0005\u0002CA97\u0005\u0005\t\u0019\u0001$\u0002\r\u0015\fX/\u00197t)\r\t\u00181\u0013\u0005\n\u0003cb\u0012\u0011!a\u0001\u0003\u0013A3#CAL\u0003;\u000by*a)\u0002&\u0006%\u00161VAX\u0003c\u00032\u0001LAM\u0013\r\tYJ\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t+A*`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t4bGR|'/[1mA=4\u0007\u0005Y3yaJ\u0004g\u0006\t1fqB\u0014\b\rI5tAm\u0003dF\f\u001a1;:\u0002s\n\u001e5fe^L7/\u001a\u0017!]VdGNL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qU\u00017\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112eAR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003[\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!a-\u0002\u00155\fG\u000f[0gk:\u001c7\u000fC\u0003h\r\u0001\u0007\u0011.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005m\u0016\u0011\u0019\t\u0005a\u0005u\u0016.C\u0002\u0002@F\u0012aa\u00149uS>t\u0007\u0002CAb\u000f\u0005\u0005\t\u0019A)\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002JB!\u0011QLAf\u0013\u0011\ti-a\u0018\u0003\r=\u0013'.Z2u\u0001")
public class Factorial
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Factorial x$0) {
        return Factorial$.MODULE$.unapply(x$0);
    }

    public static long factorial(int n) {
        return Factorial$.MODULE$.factorial(n);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object input) {
        Integer value = (Integer)input;
        if (Predef$.MODULE$.Integer2int(value) > 20 || Predef$.MODULE$.Integer2int(value) < 0) {
            return null;
        }
        return BoxesRunTime.boxToLong((long)Factorial$.MODULE$.factorial(Predef$.MODULE$.Integer2int(value)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> "\n        if (" + eval + " > 20 || " + eval + " < 0) {\n          " + ev.isNull() + " = true;\n        } else {\n          " + ev.value() + " =\n            org.apache.spark.sql.catalyst.expressions.Factorial.factorial(" + eval + ");\n        }\n      ");
    }

    @Override
    public Factorial withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Factorial copy(Expression child) {
        return new Factorial(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Factorial";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Factorial;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Factorial)) return false;
        boolean bl = true;
        if (!bl) return false;
        Factorial factorial = (Factorial)x$1;
        Expression expression = this.child();
        Expression expression2 = factorial.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!factorial.canEqual(this)) return false;
        return true;
    }

    public Factorial(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

